# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExtractedToken(Model):
    """Canonical representation of single extracted text.

    :param text: String value of the extracted text.
    :type text: str
    :param bounding_box: Bounding box of the extracted text. Represents the
     location of the extracted text as a pair of
     cartesian co-ordinates. The co-ordinate pairs are arranged by
     top-left, top-right, bottom-right and bottom-left endpoints box
     with origin reference from the bottom-left of the page.
    :type bounding_box: list[float]
    :param confidence: A measure of accuracy of the extracted text.
    :type confidence: float
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': '[float]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ExtractedToken, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.bounding_box = kwargs.get('bounding_box', None)
        self.confidence = kwargs.get('confidence', None)
