# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.apimanagement import ApiManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-apimanagement
# USAGE
    python api_management_create_portal_config.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ApiManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.portal_config.create_or_update(
        resource_group_name="rg1",
        service_name="apimService1",
        portal_config_id="default",
        if_match="*",
        parameters={
            "properties": {
                "cors": {"allowedOrigins": ["https://contoso.com"]},
                "csp": {
                    "allowedSources": ["*.contoso.com"],
                    "mode": "reportOnly",
                    "reportUri": ["https://report.contoso.com"],
                },
                "delegation": {
                    "delegateRegistration": False,
                    "delegateSubscription": False,
                    "delegationUrl": None,
                    "validationKey": None,
                },
                "enableBasicAuth": True,
                "signin": {"require": False},
                "signup": {
                    "termsOfService": {"requireConsent": False, "text": "I agree to the service terms and conditions."}
                },
            }
        },
    )
    print(response)


# x-ms-original-file: specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreatePortalConfig.json
if __name__ == "__main__":
    main()
