# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, Union

import msrest.serialization

from ._microsoft_serial_console_client_enums import *


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the Batch service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.serialconsole.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class DisableSerialConsoleResult(msrest.serialization.Model):
    """Returns whether or not Serial Console is disabled.

    :param disabled: Whether or not Serial Console is disabled.
    :type disabled: bool
    """

    _attribute_map = {
        'disabled': {'key': 'disabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        disabled: Optional[bool] = None,
        **kwargs
    ):
        super(DisableSerialConsoleResult, self).__init__(**kwargs)
        self.disabled = disabled


class EnableSerialConsoleResult(msrest.serialization.Model):
    """Returns whether or not Serial Console is disabled (enabled).

    :param disabled: Whether or not Serial Console is disabled (enabled).
    :type disabled: bool
    """

    _attribute_map = {
        'disabled': {'key': 'disabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        disabled: Optional[bool] = None,
        **kwargs
    ):
        super(EnableSerialConsoleResult, self).__init__(**kwargs)
        self.disabled = disabled


class GetSerialConsoleSubscriptionNotFound(msrest.serialization.Model):
    """Error saying that the provided subscription could not be found.

    :param code: Error code.
    :type code: str
    :param message: Subscription not found message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(GetSerialConsoleSubscriptionNotFound, self).__init__(**kwargs)
        self.code = code
        self.message = message


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class SerialConsoleOperations(msrest.serialization.Model):
    """Serial Console operations.

    :param value: A list of Serial Console operations.
    :type value: list[~azure.mgmt.serialconsole.models.SerialConsoleOperationsValueItem]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SerialConsoleOperationsValueItem]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SerialConsoleOperationsValueItem"]] = None,
        **kwargs
    ):
        super(SerialConsoleOperations, self).__init__(**kwargs)
        self.value = value


class SerialConsoleOperationsValueItem(msrest.serialization.Model):
    """SerialConsoleOperationsValueItem.

    :param name:
    :type name: str
    :param is_data_action:
    :type is_data_action: str
    :param display:
    :type display: ~azure.mgmt.serialconsole.models.SerialConsoleOperationsValueItemDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'str'},
        'display': {'key': 'display', 'type': 'SerialConsoleOperationsValueItemDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[str] = None,
        display: Optional["SerialConsoleOperationsValueItemDisplay"] = None,
        **kwargs
    ):
        super(SerialConsoleOperationsValueItem, self).__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display


class SerialConsoleOperationsValueItemDisplay(msrest.serialization.Model):
    """SerialConsoleOperationsValueItemDisplay.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(SerialConsoleOperationsValueItemDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class SerialConsoleStatus(msrest.serialization.Model):
    """Returns whether or not Serial Console is disabled.

    :param disabled: Whether or not Serial Console is disabled.
    :type disabled: bool
    """

    _attribute_map = {
        'disabled': {'key': 'disabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        disabled: Optional[bool] = None,
        **kwargs
    ):
        super(SerialConsoleStatus, self).__init__(**kwargs)
        self.disabled = disabled


class SerialPort(ProxyResource):
    """Represents the serial port of the parent resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: Specifies whether the port is enabled for a serial console connection. Possible
     values include: "enabled", "disabled".
    :type state: str or ~azure.mgmt.serialconsole.models.SerialPortState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "SerialPortState"]] = None,
        **kwargs
    ):
        super(SerialPort, self).__init__(**kwargs)
        self.state = state


class SerialPortConnectResult(msrest.serialization.Model):
    """Returns a connection string to the serial port of the resource.

    :param connection_string: Connection string to the serial port of the resource.
    :type connection_string: str
    """

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: Optional[str] = None,
        **kwargs
    ):
        super(SerialPortConnectResult, self).__init__(**kwargs)
        self.connection_string = connection_string


class SerialPortListResult(msrest.serialization.Model):
    """The list serial ports operation response.

    :param value: The list of serial ports.
    :type value: list[~azure.mgmt.serialconsole.models.SerialPort]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SerialPort]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SerialPort"]] = None,
        **kwargs
    ):
        super(SerialPortListResult, self).__init__(**kwargs)
        self.value = value
