# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._site_recovery_management_client_enums import *


class AddDisksProviderSpecificInput(msrest.serialization.Model):
    """Add Disks provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AAddDisksInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AAddDisksInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddDisksProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AAddDisksInput(AddDisksProviderSpecificInput):
    """A2A add disk(s) input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param vm_disks: The list of vm disk details.
    :type vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
    :param vm_managed_disks: The list of vm managed disk details.
    :type vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vm_disks': {'key': 'vmDisks', 'type': '[A2AVmDiskInputDetails]'},
        'vm_managed_disks': {'key': 'vmManagedDisks', 'type': '[A2AVmManagedDiskInputDetails]'},
    }

    def __init__(
        self,
        *,
        vm_disks: Optional[List["A2AVmDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["A2AVmManagedDiskInputDetails"]] = None,
        **kwargs
    ):
        super(A2AAddDisksInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks


class ApplyRecoveryPointProviderSpecificInput(msrest.serialization.Model):
    """Provider specific input for apply recovery point.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AApplyRecoveryPointInput, A2ACrossClusterMigrationApplyRecoveryPointInput, HyperVReplicaAzureApplyRecoveryPointInput, InMageAzureV2ApplyRecoveryPointInput, InMageRcmApplyRecoveryPointInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AApplyRecoveryPointInput', 'A2ACrossClusterMigration': 'A2ACrossClusterMigrationApplyRecoveryPointInput', 'HyperVReplicaAzure': 'HyperVReplicaAzureApplyRecoveryPointInput', 'InMageAzureV2': 'InMageAzureV2ApplyRecoveryPointInput', 'InMageRcm': 'InMageRcmApplyRecoveryPointInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplyRecoveryPointProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to A2A provider.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(A2AApplyRecoveryPointInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str


class ReplicationProviderSpecificContainerCreationInput(msrest.serialization.Model):
    """Provider specific input for container creation operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AContainerCreationInput, A2ACrossClusterMigrationContainerCreationInput, VMwareCbtContainerCreationInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AContainerCreationInput', 'A2ACrossClusterMigration': 'A2ACrossClusterMigrationContainerCreationInput', 'VMwareCbt': 'VMwareCbtContainerCreationInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationProviderSpecificContainerCreationInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AContainerCreationInput(ReplicationProviderSpecificContainerCreationInput):
    """A2A cloud creation input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(A2AContainerCreationInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str


class ReplicationProviderSpecificContainerMappingInput(msrest.serialization.Model):
    """Provider specific input for pairing operations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AContainerMappingInput, VMwareCbtContainerMappingInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AContainerMappingInput', 'VMwareCbt': 'VMwareCbtContainerMappingInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationProviderSpecificContainerMappingInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AContainerMappingInput(ReplicationProviderSpecificContainerMappingInput):
    """A2A container mapping input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param agent_auto_update_status: A value indicating whether the auto update is enabled.
     Possible values include: "Disabled", "Enabled".
    :type agent_auto_update_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
    :param automation_account_arm_id: The automation account arm id.
    :type automation_account_arm_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'agent_auto_update_status': {'key': 'agentAutoUpdateStatus', 'type': 'str'},
        'automation_account_arm_id': {'key': 'automationAccountArmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        agent_auto_update_status: Optional[Union[str, "AgentAutoUpdateStatus"]] = None,
        automation_account_arm_id: Optional[str] = None,
        **kwargs
    ):
        super(A2AContainerMappingInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.agent_auto_update_status = agent_auto_update_status
        self.automation_account_arm_id = automation_account_arm_id


class CreateProtectionIntentProviderSpecificDetails(msrest.serialization.Model):
    """Create protection intent provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2ACreateProtectionIntentInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2ACreateProtectionIntentInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateProtectionIntentProviderSpecificDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2ACreateProtectionIntentInput(CreateProtectionIntentProviderSpecificDetails):
    """A2A create protection intent input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param fabric_object_id: Required. The fabric specific object Id of the virtual machine.
    :type fabric_object_id: str
    :param primary_location: Required. The primary location for the virtual machine.
    :type primary_location: str
    :param recovery_location: Required. The recovery location for the virtual machine.
    :type recovery_location: str
    :param recovery_subscription_id: Required. The recovery subscription Id of the virtual machine.
    :type recovery_subscription_id: str
    :param recovery_availability_type: Required. The recovery availability type of the virtual
     machine. Possible values include: "Single", "AvailabilitySet", "AvailabilityZone".
    :type recovery_availability_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.A2ARecoveryAvailabilityType
    :param protection_profile_custom_input: The protection profile custom inputs.
    :type protection_profile_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionProfileCustomDetails
    :param recovery_resource_group_id: Required. The recovery resource group Id. Valid for V2
     scenarios.
    :type recovery_resource_group_id: str
    :param primary_staging_storage_account_custom_input: The primary staging storage account input.
    :type primary_staging_storage_account_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :param recovery_availability_set_custom_input: The recovery availability set input.
    :type recovery_availability_set_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryAvailabilitySetCustomDetails
    :param recovery_virtual_network_custom_input: The recovery virtual network input.
    :type recovery_virtual_network_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryVirtualNetworkCustomDetails
    :param recovery_proximity_placement_group_custom_input: The recovery proximity placement group
     custom input.
    :type recovery_proximity_placement_group_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryProximityPlacementGroupCustomDetails
    :param auto_protection_of_data_disk: A value indicating whether the auto protection is enabled.
     Possible values include: "Disabled", "Enabled".
    :type auto_protection_of_data_disk: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
    :param vm_disks: The list of vm disk inputs.
    :type vm_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentDiskInputDetails]
    :param vm_managed_disks: The list of vm managed disk inputs.
    :type vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentManagedDiskInputDetails]
    :param multi_vm_group_name: The multi vm group name.
    :type multi_vm_group_name: str
    :param multi_vm_group_id: The multi vm group id.
    :type multi_vm_group_id: str
    :param recovery_boot_diag_storage_account: The boot diagnostic storage account.
    :type recovery_boot_diag_storage_account:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :param disk_encryption_info: The recovery disk encryption information (for two pass flows).
    :type disk_encryption_info: ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :param recovery_availability_zone: The recovery availability zone.
    :type recovery_availability_zone: str
    """

    _validation = {
        'instance_type': {'required': True},
        'fabric_object_id': {'required': True},
        'primary_location': {'required': True},
        'recovery_location': {'required': True},
        'recovery_subscription_id': {'required': True},
        'recovery_availability_type': {'required': True},
        'recovery_resource_group_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'primary_location': {'key': 'primaryLocation', 'type': 'str'},
        'recovery_location': {'key': 'recoveryLocation', 'type': 'str'},
        'recovery_subscription_id': {'key': 'recoverySubscriptionId', 'type': 'str'},
        'recovery_availability_type': {'key': 'recoveryAvailabilityType', 'type': 'str'},
        'protection_profile_custom_input': {'key': 'protectionProfileCustomInput', 'type': 'ProtectionProfileCustomDetails'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
        'primary_staging_storage_account_custom_input': {'key': 'primaryStagingStorageAccountCustomInput', 'type': 'StorageAccountCustomDetails'},
        'recovery_availability_set_custom_input': {'key': 'recoveryAvailabilitySetCustomInput', 'type': 'RecoveryAvailabilitySetCustomDetails'},
        'recovery_virtual_network_custom_input': {'key': 'recoveryVirtualNetworkCustomInput', 'type': 'RecoveryVirtualNetworkCustomDetails'},
        'recovery_proximity_placement_group_custom_input': {'key': 'recoveryProximityPlacementGroupCustomInput', 'type': 'RecoveryProximityPlacementGroupCustomDetails'},
        'auto_protection_of_data_disk': {'key': 'autoProtectionOfDataDisk', 'type': 'str'},
        'vm_disks': {'key': 'vmDisks', 'type': '[A2AProtectionIntentDiskInputDetails]'},
        'vm_managed_disks': {'key': 'vmManagedDisks', 'type': '[A2AProtectionIntentManagedDiskInputDetails]'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'multi_vm_group_id': {'key': 'multiVmGroupId', 'type': 'str'},
        'recovery_boot_diag_storage_account': {'key': 'recoveryBootDiagStorageAccount', 'type': 'StorageAccountCustomDetails'},
        'disk_encryption_info': {'key': 'diskEncryptionInfo', 'type': 'DiskEncryptionInfo'},
        'recovery_availability_zone': {'key': 'recoveryAvailabilityZone', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fabric_object_id: str,
        primary_location: str,
        recovery_location: str,
        recovery_subscription_id: str,
        recovery_availability_type: Union[str, "A2ARecoveryAvailabilityType"],
        recovery_resource_group_id: str,
        protection_profile_custom_input: Optional["ProtectionProfileCustomDetails"] = None,
        primary_staging_storage_account_custom_input: Optional["StorageAccountCustomDetails"] = None,
        recovery_availability_set_custom_input: Optional["RecoveryAvailabilitySetCustomDetails"] = None,
        recovery_virtual_network_custom_input: Optional["RecoveryVirtualNetworkCustomDetails"] = None,
        recovery_proximity_placement_group_custom_input: Optional["RecoveryProximityPlacementGroupCustomDetails"] = None,
        auto_protection_of_data_disk: Optional[Union[str, "AutoProtectionOfDataDisk"]] = None,
        vm_disks: Optional[List["A2AProtectionIntentDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["A2AProtectionIntentManagedDiskInputDetails"]] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        recovery_boot_diag_storage_account: Optional["StorageAccountCustomDetails"] = None,
        disk_encryption_info: Optional["DiskEncryptionInfo"] = None,
        recovery_availability_zone: Optional[str] = None,
        **kwargs
    ):
        super(A2ACreateProtectionIntentInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.fabric_object_id = fabric_object_id
        self.primary_location = primary_location
        self.recovery_location = recovery_location
        self.recovery_subscription_id = recovery_subscription_id
        self.recovery_availability_type = recovery_availability_type
        self.protection_profile_custom_input = protection_profile_custom_input
        self.recovery_resource_group_id = recovery_resource_group_id
        self.primary_staging_storage_account_custom_input = primary_staging_storage_account_custom_input
        self.recovery_availability_set_custom_input = recovery_availability_set_custom_input
        self.recovery_virtual_network_custom_input = recovery_virtual_network_custom_input
        self.recovery_proximity_placement_group_custom_input = recovery_proximity_placement_group_custom_input
        self.auto_protection_of_data_disk = auto_protection_of_data_disk
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_group_id = multi_vm_group_id
        self.recovery_boot_diag_storage_account = recovery_boot_diag_storage_account
        self.disk_encryption_info = disk_encryption_info
        self.recovery_availability_zone = recovery_availability_zone


class A2ACrossClusterMigrationApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to A2ACrossClusterMigration provider.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(A2ACrossClusterMigrationApplyRecoveryPointInput, self).__init__(**kwargs)
        self.instance_type = 'A2ACrossClusterMigration'  # type: str


class A2ACrossClusterMigrationContainerCreationInput(ReplicationProviderSpecificContainerCreationInput):
    """A2ACrossClusterMigration cloud creation input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(A2ACrossClusterMigrationContainerCreationInput, self).__init__(**kwargs)
        self.instance_type = 'A2ACrossClusterMigration'  # type: str


class EnableProtectionProviderSpecificInput(msrest.serialization.Model):
    """Enable protection provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AEnableProtectionInput, A2ACrossClusterMigrationEnableProtectionInput, HyperVReplicaAzureEnableProtectionInput, InMageEnableProtectionInput, InMageAzureV2EnableProtectionInput, InMageRcmEnableProtectionInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AEnableProtectionInput', 'A2ACrossClusterMigration': 'A2ACrossClusterMigrationEnableProtectionInput', 'HyperVReplicaAzure': 'HyperVReplicaAzureEnableProtectionInput', 'InMage': 'InMageEnableProtectionInput', 'InMageAzureV2': 'InMageAzureV2EnableProtectionInput', 'InMageRcm': 'InMageRcmEnableProtectionInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnableProtectionProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2ACrossClusterMigrationEnableProtectionInput(EnableProtectionProviderSpecificInput):
    """A2A Cross-Cluster Migration enable protection input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param fabric_object_id: The fabric specific object Id of the virtual machine.
    :type fabric_object_id: str
    :param recovery_container_id: The recovery container Id.
    :type recovery_container_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'recovery_container_id': {'key': 'recoveryContainerId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fabric_object_id: Optional[str] = None,
        recovery_container_id: Optional[str] = None,
        **kwargs
    ):
        super(A2ACrossClusterMigrationEnableProtectionInput, self).__init__(**kwargs)
        self.instance_type = 'A2ACrossClusterMigration'  # type: str
        self.fabric_object_id = fabric_object_id
        self.recovery_container_id = recovery_container_id


class PolicyProviderSpecificInput(msrest.serialization.Model):
    """Base class for provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2APolicyCreationInput, A2ACrossClusterMigrationPolicyCreationInput, HyperVReplicaPolicyInput, HyperVReplicaAzurePolicyInput, InMagePolicyInput, InMageAzureV2PolicyInput, InMageRcmPolicyCreationInput, InMageRcmFailbackPolicyCreationInput, VMwareCbtPolicyCreationInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2APolicyCreationInput', 'A2ACrossClusterMigration': 'A2ACrossClusterMigrationPolicyCreationInput', 'HyperVReplica2012': 'HyperVReplicaPolicyInput', 'HyperVReplicaAzure': 'HyperVReplicaAzurePolicyInput', 'InMage': 'InMagePolicyInput', 'InMageAzureV2': 'InMageAzureV2PolicyInput', 'InMageRcm': 'InMageRcmPolicyCreationInput', 'InMageRcmFailback': 'InMageRcmFailbackPolicyCreationInput', 'VMwareCbt': 'VMwareCbtPolicyCreationInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2ACrossClusterMigrationPolicyCreationInput(PolicyProviderSpecificInput):
    """A2A Cross-Cluster Migration Policy creation input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(A2ACrossClusterMigrationPolicyCreationInput, self).__init__(**kwargs)
        self.instance_type = 'A2ACrossClusterMigration'  # type: str


class ReplicationProviderSpecificSettings(msrest.serialization.Model):
    """Replication provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AReplicationDetails, A2ACrossClusterMigrationReplicationDetails, HyperVReplicaReplicationDetails, HyperVReplicaBlueReplicationDetails, HyperVReplicaAzureReplicationDetails, HyperVReplicaBaseReplicationDetails, InMageReplicationDetails, InMageAzureV2ReplicationDetails, InMageRcmReplicationDetails, InMageRcmFailbackReplicationDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AReplicationDetails', 'A2ACrossClusterMigration': 'A2ACrossClusterMigrationReplicationDetails', 'HyperVReplica2012': 'HyperVReplicaReplicationDetails', 'HyperVReplica2012R2': 'HyperVReplicaBlueReplicationDetails', 'HyperVReplicaAzure': 'HyperVReplicaAzureReplicationDetails', 'HyperVReplicaBaseReplicationDetails': 'HyperVReplicaBaseReplicationDetails', 'InMage': 'InMageReplicationDetails', 'InMageAzureV2': 'InMageAzureV2ReplicationDetails', 'InMageRcm': 'InMageRcmReplicationDetails', 'InMageRcmFailback': 'InMageRcmFailbackReplicationDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationProviderSpecificSettings, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2ACrossClusterMigrationReplicationDetails(ReplicationProviderSpecificSettings):
    """A2A provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param fabric_object_id: The fabric specific object Id of the virtual machine.
    :type fabric_object_id: str
    :param primary_fabric_location: Primary fabric location.
    :type primary_fabric_location: str
    :param os_type: The type of operating system.
    :type os_type: str
    :param vm_protection_state: The protection state for the vm.
    :type vm_protection_state: str
    :param vm_protection_state_description: The protection state description for the vm.
    :type vm_protection_state_description: str
    :param lifecycle_id: An id associated with the PE that survives actions like switch protection
     which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to
     have a link/continuity in being able to have an Id that denotes the "same" protected item even
     though other internal Ids/ARM Id might be changing.
    :type lifecycle_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'primary_fabric_location': {'key': 'primaryFabricLocation', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_protection_state': {'key': 'vmProtectionState', 'type': 'str'},
        'vm_protection_state_description': {'key': 'vmProtectionStateDescription', 'type': 'str'},
        'lifecycle_id': {'key': 'lifecycleId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fabric_object_id: Optional[str] = None,
        primary_fabric_location: Optional[str] = None,
        os_type: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        lifecycle_id: Optional[str] = None,
        **kwargs
    ):
        super(A2ACrossClusterMigrationReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'A2ACrossClusterMigration'  # type: str
        self.fabric_object_id = fabric_object_id
        self.primary_fabric_location = primary_fabric_location
        self.os_type = os_type
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.lifecycle_id = lifecycle_id


class A2AEnableProtectionInput(EnableProtectionProviderSpecificInput):
    """A2A enable protection input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param fabric_object_id: Required. The fabric specific object Id of the virtual machine.
    :type fabric_object_id: str
    :param recovery_container_id: The recovery container Id.
    :type recovery_container_id: str
    :param recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
    :type recovery_resource_group_id: str
    :param recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
    :type recovery_cloud_service_id: str
    :param recovery_availability_set_id: The recovery availability set Id.
    :type recovery_availability_set_id: str
    :param recovery_proximity_placement_group_id: The recovery proximity placement group Id.
    :type recovery_proximity_placement_group_id: str
    :param vm_disks: The list of vm disk details.
    :type vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
    :param vm_managed_disks: The list of vm managed disk details.
    :type vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
    :param multi_vm_group_name: The multi vm group name.
    :type multi_vm_group_name: str
    :param multi_vm_group_id: The multi vm group id.
    :type multi_vm_group_id: str
    :param recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
    :type recovery_boot_diag_storage_account_id: str
    :param disk_encryption_info: The recovery disk encryption information (for two pass flows).
    :type disk_encryption_info: ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :param recovery_availability_zone: The recovery availability zone.
    :type recovery_availability_zone: str
    :param recovery_azure_network_id: The recovery Azure virtual network ARM id.
    :type recovery_azure_network_id: str
    :param recovery_subnet_name: The recovery subnet name.
    :type recovery_subnet_name: str
    :param recovery_virtual_machine_scale_set_id: The virtual machine scale set Id.
    :type recovery_virtual_machine_scale_set_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'fabric_object_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'recovery_container_id': {'key': 'recoveryContainerId', 'type': 'str'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
        'recovery_cloud_service_id': {'key': 'recoveryCloudServiceId', 'type': 'str'},
        'recovery_availability_set_id': {'key': 'recoveryAvailabilitySetId', 'type': 'str'},
        'recovery_proximity_placement_group_id': {'key': 'recoveryProximityPlacementGroupId', 'type': 'str'},
        'vm_disks': {'key': 'vmDisks', 'type': '[A2AVmDiskInputDetails]'},
        'vm_managed_disks': {'key': 'vmManagedDisks', 'type': '[A2AVmManagedDiskInputDetails]'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'multi_vm_group_id': {'key': 'multiVmGroupId', 'type': 'str'},
        'recovery_boot_diag_storage_account_id': {'key': 'recoveryBootDiagStorageAccountId', 'type': 'str'},
        'disk_encryption_info': {'key': 'diskEncryptionInfo', 'type': 'DiskEncryptionInfo'},
        'recovery_availability_zone': {'key': 'recoveryAvailabilityZone', 'type': 'str'},
        'recovery_azure_network_id': {'key': 'recoveryAzureNetworkId', 'type': 'str'},
        'recovery_subnet_name': {'key': 'recoverySubnetName', 'type': 'str'},
        'recovery_virtual_machine_scale_set_id': {'key': 'recoveryVirtualMachineScaleSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fabric_object_id: str,
        recovery_container_id: Optional[str] = None,
        recovery_resource_group_id: Optional[str] = None,
        recovery_cloud_service_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        recovery_proximity_placement_group_id: Optional[str] = None,
        vm_disks: Optional[List["A2AVmDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["A2AVmManagedDiskInputDetails"]] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        recovery_boot_diag_storage_account_id: Optional[str] = None,
        disk_encryption_info: Optional["DiskEncryptionInfo"] = None,
        recovery_availability_zone: Optional[str] = None,
        recovery_azure_network_id: Optional[str] = None,
        recovery_subnet_name: Optional[str] = None,
        recovery_virtual_machine_scale_set_id: Optional[str] = None,
        **kwargs
    ):
        super(A2AEnableProtectionInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.fabric_object_id = fabric_object_id
        self.recovery_container_id = recovery_container_id
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_cloud_service_id = recovery_cloud_service_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_group_id = multi_vm_group_id
        self.recovery_boot_diag_storage_account_id = recovery_boot_diag_storage_account_id
        self.disk_encryption_info = disk_encryption_info
        self.recovery_availability_zone = recovery_availability_zone
        self.recovery_azure_network_id = recovery_azure_network_id
        self.recovery_subnet_name = recovery_subnet_name
        self.recovery_virtual_machine_scale_set_id = recovery_virtual_machine_scale_set_id


class EventProviderSpecificDetails(msrest.serialization.Model):
    """Model class for provider specific details for an event.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AEventDetails, HyperVReplica2012EventDetails, HyperVReplica2012R2EventDetails, HyperVReplicaAzureEventDetails, HyperVReplicaBaseEventDetails, InMageAzureV2EventDetails, InMageRcmEventDetails, InMageRcmFailbackEventDetails, VMwareCbtEventDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AEventDetails', 'HyperVReplica2012': 'HyperVReplica2012EventDetails', 'HyperVReplica2012R2': 'HyperVReplica2012R2EventDetails', 'HyperVReplicaAzure': 'HyperVReplicaAzureEventDetails', 'HyperVReplicaBaseEventDetails': 'HyperVReplicaBaseEventDetails', 'InMageAzureV2': 'InMageAzureV2EventDetails', 'InMageRcm': 'InMageRcmEventDetails', 'InMageRcmFailback': 'InMageRcmFailbackEventDetails', 'VMwareCbt': 'VMwareCbtEventDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventProviderSpecificDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AEventDetails(EventProviderSpecificDetails):
    """Model class for event details of a A2A event.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param protected_item_name: The protected item arm name.
    :type protected_item_name: str
    :param fabric_object_id: The azure vm arm id.
    :type fabric_object_id: str
    :param fabric_name: Fabric arm name.
    :type fabric_name: str
    :param fabric_location: The fabric location.
    :type fabric_location: str
    :param remote_fabric_name: Remote fabric arm name.
    :type remote_fabric_name: str
    :param remote_fabric_location: Remote fabric location.
    :type remote_fabric_location: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'protected_item_name': {'key': 'protectedItemName', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'fabric_location': {'key': 'fabricLocation', 'type': 'str'},
        'remote_fabric_name': {'key': 'remoteFabricName', 'type': 'str'},
        'remote_fabric_location': {'key': 'remoteFabricLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protected_item_name: Optional[str] = None,
        fabric_object_id: Optional[str] = None,
        fabric_name: Optional[str] = None,
        fabric_location: Optional[str] = None,
        remote_fabric_name: Optional[str] = None,
        remote_fabric_location: Optional[str] = None,
        **kwargs
    ):
        super(A2AEventDetails, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.protected_item_name = protected_item_name
        self.fabric_object_id = fabric_object_id
        self.fabric_name = fabric_name
        self.fabric_location = fabric_location
        self.remote_fabric_name = remote_fabric_name
        self.remote_fabric_location = remote_fabric_location


class A2APolicyCreationInput(PolicyProviderSpecificInput):
    """A2A Policy creation input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :type recovery_point_history: int
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :type crash_consistent_frequency_in_minutes: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :type app_consistent_frequency_in_minutes: int
    :param multi_vm_sync_status: Required. A value indicating whether multi-VM sync has to be
     enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: "Enable", "Disable".
    :type multi_vm_sync_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
    """

    _validation = {
        'instance_type': {'required': True},
        'multi_vm_sync_status': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_history': {'key': 'recoveryPointHistory', 'type': 'int'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        multi_vm_sync_status: Union[str, "SetMultiVmSyncStatus"],
        recovery_point_history: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(A2APolicyCreationInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_point_history = recovery_point_history
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class PolicyProviderSpecificDetails(msrest.serialization.Model):
    """Base class for Provider specific details for policies.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2APolicyDetails, HyperVReplicaPolicyDetails, HyperVReplicaBluePolicyDetails, HyperVReplicaAzurePolicyDetails, HyperVReplicaBasePolicyDetails, InMagePolicyDetails, InMageAzureV2PolicyDetails, InMageBasePolicyDetails, InMageRcmPolicyDetails, InMageRcmFailbackPolicyDetails, VmwareCbtPolicyDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2APolicyDetails', 'HyperVReplica2012': 'HyperVReplicaPolicyDetails', 'HyperVReplica2012R2': 'HyperVReplicaBluePolicyDetails', 'HyperVReplicaAzure': 'HyperVReplicaAzurePolicyDetails', 'HyperVReplicaBasePolicyDetails': 'HyperVReplicaBasePolicyDetails', 'InMage': 'InMagePolicyDetails', 'InMageAzureV2': 'InMageAzureV2PolicyDetails', 'InMageBasePolicyDetails': 'InMageBasePolicyDetails', 'InMageRcm': 'InMageRcmPolicyDetails', 'InMageRcmFailback': 'InMageRcmFailbackPolicyDetails', 'VMwareCbt': 'VmwareCbtPolicyDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyProviderSpecificDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2APolicyDetails(PolicyProviderSpecificDetails):
    """A2A specific policy details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :type recovery_point_threshold_in_minutes: int
    :param recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :type recovery_point_history: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :type app_consistent_frequency_in_minutes: int
    :param multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
    :type multi_vm_sync_status: str
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :type crash_consistent_frequency_in_minutes: int
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_threshold_in_minutes': {'key': 'recoveryPointThresholdInMinutes', 'type': 'int'},
        'recovery_point_history': {'key': 'recoveryPointHistory', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        multi_vm_sync_status: Optional[str] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(A2APolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes


class A2AProtectedDiskDetails(msrest.serialization.Model):
    """A2A protected disk details.

    :param disk_uri: The disk uri.
    :type disk_uri: str
    :param recovery_azure_storage_account_id: The recovery disk storage account.
    :type recovery_azure_storage_account_id: str
    :param primary_disk_azure_storage_account_id: The primary disk storage account.
    :type primary_disk_azure_storage_account_id: str
    :param recovery_disk_uri: Recovery disk uri.
    :type recovery_disk_uri: str
    :param disk_name: The disk name.
    :type disk_name: str
    :param disk_capacity_in_bytes: The disk capacity in bytes.
    :type disk_capacity_in_bytes: long
    :param primary_staging_azure_storage_account_id: The primary staging storage account.
    :type primary_staging_azure_storage_account_id: str
    :param disk_type: The type of disk.
    :type disk_type: str
    :param resync_required: A value indicating whether resync is required for this disk.
    :type resync_required: bool
    :param monitoring_percentage_completion: The percentage of the monitoring job. The type of the
     monitoring job is defined by MonitoringJobType property.
    :type monitoring_percentage_completion: int
    :param monitoring_job_type: The type of the monitoring job. The progress is contained in
     MonitoringPercentageCompletion property.
    :type monitoring_job_type: str
    :param data_pending_in_staging_storage_account_in_mb: The data pending for replication in MB at
     staging account.
    :type data_pending_in_staging_storage_account_in_mb: float
    :param data_pending_at_source_agent_in_mb: The data pending at source virtual machine in MB.
    :type data_pending_at_source_agent_in_mb: float
    :param disk_state: The disk state.
    :type disk_state: str
    :param allowed_disk_level_operation: The disk level operations list.
    :type allowed_disk_level_operation: list[str]
    :param is_disk_encrypted: A value indicating whether vm has encrypted os disk or not.
    :type is_disk_encrypted: bool
    :param secret_identifier: The secret URL / identifier (BEK).
    :type secret_identifier: str
    :param dek_key_vault_arm_id: The KeyVault resource id for secret (BEK).
    :type dek_key_vault_arm_id: str
    :param is_disk_key_encrypted: A value indicating whether disk key got encrypted or not.
    :type is_disk_key_encrypted: bool
    :param key_identifier: The key URL / identifier (KEK).
    :type key_identifier: str
    :param kek_key_vault_arm_id: The KeyVault resource id for key (KEK).
    :type kek_key_vault_arm_id: str
    :param failover_disk_name: The failover name for the managed disk.
    :type failover_disk_name: str
    :param tfo_disk_name: The test failover name for the managed disk.
    :type tfo_disk_name: str
    """

    _attribute_map = {
        'disk_uri': {'key': 'diskUri', 'type': 'str'},
        'recovery_azure_storage_account_id': {'key': 'recoveryAzureStorageAccountId', 'type': 'str'},
        'primary_disk_azure_storage_account_id': {'key': 'primaryDiskAzureStorageAccountId', 'type': 'str'},
        'recovery_disk_uri': {'key': 'recoveryDiskUri', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'disk_capacity_in_bytes': {'key': 'diskCapacityInBytes', 'type': 'long'},
        'primary_staging_azure_storage_account_id': {'key': 'primaryStagingAzureStorageAccountId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'resync_required': {'key': 'resyncRequired', 'type': 'bool'},
        'monitoring_percentage_completion': {'key': 'monitoringPercentageCompletion', 'type': 'int'},
        'monitoring_job_type': {'key': 'monitoringJobType', 'type': 'str'},
        'data_pending_in_staging_storage_account_in_mb': {'key': 'dataPendingInStagingStorageAccountInMB', 'type': 'float'},
        'data_pending_at_source_agent_in_mb': {'key': 'dataPendingAtSourceAgentInMB', 'type': 'float'},
        'disk_state': {'key': 'diskState', 'type': 'str'},
        'allowed_disk_level_operation': {'key': 'allowedDiskLevelOperation', 'type': '[str]'},
        'is_disk_encrypted': {'key': 'isDiskEncrypted', 'type': 'bool'},
        'secret_identifier': {'key': 'secretIdentifier', 'type': 'str'},
        'dek_key_vault_arm_id': {'key': 'dekKeyVaultArmId', 'type': 'str'},
        'is_disk_key_encrypted': {'key': 'isDiskKeyEncrypted', 'type': 'bool'},
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'kek_key_vault_arm_id': {'key': 'kekKeyVaultArmId', 'type': 'str'},
        'failover_disk_name': {'key': 'failoverDiskName', 'type': 'str'},
        'tfo_disk_name': {'key': 'tfoDiskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_uri: Optional[str] = None,
        recovery_azure_storage_account_id: Optional[str] = None,
        primary_disk_azure_storage_account_id: Optional[str] = None,
        recovery_disk_uri: Optional[str] = None,
        disk_name: Optional[str] = None,
        disk_capacity_in_bytes: Optional[int] = None,
        primary_staging_azure_storage_account_id: Optional[str] = None,
        disk_type: Optional[str] = None,
        resync_required: Optional[bool] = None,
        monitoring_percentage_completion: Optional[int] = None,
        monitoring_job_type: Optional[str] = None,
        data_pending_in_staging_storage_account_in_mb: Optional[float] = None,
        data_pending_at_source_agent_in_mb: Optional[float] = None,
        disk_state: Optional[str] = None,
        allowed_disk_level_operation: Optional[List[str]] = None,
        is_disk_encrypted: Optional[bool] = None,
        secret_identifier: Optional[str] = None,
        dek_key_vault_arm_id: Optional[str] = None,
        is_disk_key_encrypted: Optional[bool] = None,
        key_identifier: Optional[str] = None,
        kek_key_vault_arm_id: Optional[str] = None,
        failover_disk_name: Optional[str] = None,
        tfo_disk_name: Optional[str] = None,
        **kwargs
    ):
        super(A2AProtectedDiskDetails, self).__init__(**kwargs)
        self.disk_uri = disk_uri
        self.recovery_azure_storage_account_id = recovery_azure_storage_account_id
        self.primary_disk_azure_storage_account_id = primary_disk_azure_storage_account_id
        self.recovery_disk_uri = recovery_disk_uri
        self.disk_name = disk_name
        self.disk_capacity_in_bytes = disk_capacity_in_bytes
        self.primary_staging_azure_storage_account_id = primary_staging_azure_storage_account_id
        self.disk_type = disk_type
        self.resync_required = resync_required
        self.monitoring_percentage_completion = monitoring_percentage_completion
        self.monitoring_job_type = monitoring_job_type
        self.data_pending_in_staging_storage_account_in_mb = data_pending_in_staging_storage_account_in_mb
        self.data_pending_at_source_agent_in_mb = data_pending_at_source_agent_in_mb
        self.disk_state = disk_state
        self.allowed_disk_level_operation = allowed_disk_level_operation
        self.is_disk_encrypted = is_disk_encrypted
        self.secret_identifier = secret_identifier
        self.dek_key_vault_arm_id = dek_key_vault_arm_id
        self.is_disk_key_encrypted = is_disk_key_encrypted
        self.key_identifier = key_identifier
        self.kek_key_vault_arm_id = kek_key_vault_arm_id
        self.failover_disk_name = failover_disk_name
        self.tfo_disk_name = tfo_disk_name


class A2AProtectedManagedDiskDetails(msrest.serialization.Model):
    """A2A protected managed disk details.

    :param disk_id: The managed disk Arm id.
    :type disk_id: str
    :param recovery_resource_group_id: The recovery disk resource group Arm Id.
    :type recovery_resource_group_id: str
    :param recovery_target_disk_id: Recovery target disk Arm Id.
    :type recovery_target_disk_id: str
    :param recovery_replica_disk_id: Recovery replica disk Arm Id.
    :type recovery_replica_disk_id: str
    :param recovery_orignal_target_disk_id: Recovery original target disk Arm Id.
    :type recovery_orignal_target_disk_id: str
    :param recovery_replica_disk_account_type: The replica disk type. Its an optional value and
     will be same as source disk type if not user provided.
    :type recovery_replica_disk_account_type: str
    :param recovery_target_disk_account_type: The target disk type after failover. Its an optional
     value and will be same as source disk type if not user provided.
    :type recovery_target_disk_account_type: str
    :param recovery_disk_encryption_set_id: The recovery disk encryption set Id.
    :type recovery_disk_encryption_set_id: str
    :param primary_disk_encryption_set_id: The primary disk encryption set Id.
    :type primary_disk_encryption_set_id: str
    :param disk_name: The disk name.
    :type disk_name: str
    :param disk_capacity_in_bytes: The disk capacity in bytes.
    :type disk_capacity_in_bytes: long
    :param primary_staging_azure_storage_account_id: The primary staging storage account.
    :type primary_staging_azure_storage_account_id: str
    :param disk_type: The type of disk.
    :type disk_type: str
    :param resync_required: A value indicating whether resync is required for this disk.
    :type resync_required: bool
    :param monitoring_percentage_completion: The percentage of the monitoring job. The type of the
     monitoring job is defined by MonitoringJobType property.
    :type monitoring_percentage_completion: int
    :param monitoring_job_type: The type of the monitoring job. The progress is contained in
     MonitoringPercentageCompletion property.
    :type monitoring_job_type: str
    :param data_pending_in_staging_storage_account_in_mb: The data pending for replication in MB at
     staging account.
    :type data_pending_in_staging_storage_account_in_mb: float
    :param data_pending_at_source_agent_in_mb: The data pending at source virtual machine in MB.
    :type data_pending_at_source_agent_in_mb: float
    :param disk_state: The disk state.
    :type disk_state: str
    :param allowed_disk_level_operation: The disk level operations list.
    :type allowed_disk_level_operation: list[str]
    :param is_disk_encrypted: A value indicating whether vm has encrypted os disk or not.
    :type is_disk_encrypted: bool
    :param secret_identifier: The secret URL / identifier (BEK).
    :type secret_identifier: str
    :param dek_key_vault_arm_id: The KeyVault resource id for secret (BEK).
    :type dek_key_vault_arm_id: str
    :param is_disk_key_encrypted: A value indicating whether disk key got encrypted or not.
    :type is_disk_key_encrypted: bool
    :param key_identifier: The key URL / identifier (KEK).
    :type key_identifier: str
    :param kek_key_vault_arm_id: The KeyVault resource id for key (KEK).
    :type kek_key_vault_arm_id: str
    :param failover_disk_name: The failover name for the managed disk.
    :type failover_disk_name: str
    :param tfo_disk_name: The test failover name for the managed disk.
    :type tfo_disk_name: str
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
        'recovery_target_disk_id': {'key': 'recoveryTargetDiskId', 'type': 'str'},
        'recovery_replica_disk_id': {'key': 'recoveryReplicaDiskId', 'type': 'str'},
        'recovery_orignal_target_disk_id': {'key': 'recoveryOrignalTargetDiskId', 'type': 'str'},
        'recovery_replica_disk_account_type': {'key': 'recoveryReplicaDiskAccountType', 'type': 'str'},
        'recovery_target_disk_account_type': {'key': 'recoveryTargetDiskAccountType', 'type': 'str'},
        'recovery_disk_encryption_set_id': {'key': 'recoveryDiskEncryptionSetId', 'type': 'str'},
        'primary_disk_encryption_set_id': {'key': 'primaryDiskEncryptionSetId', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'disk_capacity_in_bytes': {'key': 'diskCapacityInBytes', 'type': 'long'},
        'primary_staging_azure_storage_account_id': {'key': 'primaryStagingAzureStorageAccountId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'resync_required': {'key': 'resyncRequired', 'type': 'bool'},
        'monitoring_percentage_completion': {'key': 'monitoringPercentageCompletion', 'type': 'int'},
        'monitoring_job_type': {'key': 'monitoringJobType', 'type': 'str'},
        'data_pending_in_staging_storage_account_in_mb': {'key': 'dataPendingInStagingStorageAccountInMB', 'type': 'float'},
        'data_pending_at_source_agent_in_mb': {'key': 'dataPendingAtSourceAgentInMB', 'type': 'float'},
        'disk_state': {'key': 'diskState', 'type': 'str'},
        'allowed_disk_level_operation': {'key': 'allowedDiskLevelOperation', 'type': '[str]'},
        'is_disk_encrypted': {'key': 'isDiskEncrypted', 'type': 'bool'},
        'secret_identifier': {'key': 'secretIdentifier', 'type': 'str'},
        'dek_key_vault_arm_id': {'key': 'dekKeyVaultArmId', 'type': 'str'},
        'is_disk_key_encrypted': {'key': 'isDiskKeyEncrypted', 'type': 'bool'},
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'kek_key_vault_arm_id': {'key': 'kekKeyVaultArmId', 'type': 'str'},
        'failover_disk_name': {'key': 'failoverDiskName', 'type': 'str'},
        'tfo_disk_name': {'key': 'tfoDiskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        recovery_resource_group_id: Optional[str] = None,
        recovery_target_disk_id: Optional[str] = None,
        recovery_replica_disk_id: Optional[str] = None,
        recovery_orignal_target_disk_id: Optional[str] = None,
        recovery_replica_disk_account_type: Optional[str] = None,
        recovery_target_disk_account_type: Optional[str] = None,
        recovery_disk_encryption_set_id: Optional[str] = None,
        primary_disk_encryption_set_id: Optional[str] = None,
        disk_name: Optional[str] = None,
        disk_capacity_in_bytes: Optional[int] = None,
        primary_staging_azure_storage_account_id: Optional[str] = None,
        disk_type: Optional[str] = None,
        resync_required: Optional[bool] = None,
        monitoring_percentage_completion: Optional[int] = None,
        monitoring_job_type: Optional[str] = None,
        data_pending_in_staging_storage_account_in_mb: Optional[float] = None,
        data_pending_at_source_agent_in_mb: Optional[float] = None,
        disk_state: Optional[str] = None,
        allowed_disk_level_operation: Optional[List[str]] = None,
        is_disk_encrypted: Optional[bool] = None,
        secret_identifier: Optional[str] = None,
        dek_key_vault_arm_id: Optional[str] = None,
        is_disk_key_encrypted: Optional[bool] = None,
        key_identifier: Optional[str] = None,
        kek_key_vault_arm_id: Optional[str] = None,
        failover_disk_name: Optional[str] = None,
        tfo_disk_name: Optional[str] = None,
        **kwargs
    ):
        super(A2AProtectedManagedDiskDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_target_disk_id = recovery_target_disk_id
        self.recovery_replica_disk_id = recovery_replica_disk_id
        self.recovery_orignal_target_disk_id = recovery_orignal_target_disk_id
        self.recovery_replica_disk_account_type = recovery_replica_disk_account_type
        self.recovery_target_disk_account_type = recovery_target_disk_account_type
        self.recovery_disk_encryption_set_id = recovery_disk_encryption_set_id
        self.primary_disk_encryption_set_id = primary_disk_encryption_set_id
        self.disk_name = disk_name
        self.disk_capacity_in_bytes = disk_capacity_in_bytes
        self.primary_staging_azure_storage_account_id = primary_staging_azure_storage_account_id
        self.disk_type = disk_type
        self.resync_required = resync_required
        self.monitoring_percentage_completion = monitoring_percentage_completion
        self.monitoring_job_type = monitoring_job_type
        self.data_pending_in_staging_storage_account_in_mb = data_pending_in_staging_storage_account_in_mb
        self.data_pending_at_source_agent_in_mb = data_pending_at_source_agent_in_mb
        self.disk_state = disk_state
        self.allowed_disk_level_operation = allowed_disk_level_operation
        self.is_disk_encrypted = is_disk_encrypted
        self.secret_identifier = secret_identifier
        self.dek_key_vault_arm_id = dek_key_vault_arm_id
        self.is_disk_key_encrypted = is_disk_key_encrypted
        self.key_identifier = key_identifier
        self.kek_key_vault_arm_id = kek_key_vault_arm_id
        self.failover_disk_name = failover_disk_name
        self.tfo_disk_name = tfo_disk_name


class ProtectionContainerMappingProviderSpecificDetails(msrest.serialization.Model):
    """Container mapping provider specific details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AProtectionContainerMappingDetails, InMageRcmProtectionContainerMappingDetails, VMwareCbtProtectionContainerMappingDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AProtectionContainerMappingDetails', 'InMageRcm': 'InMageRcmProtectionContainerMappingDetails', 'VMwareCbt': 'VMwareCbtProtectionContainerMappingDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProtectionContainerMappingProviderSpecificDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AProtectionContainerMappingDetails(ProtectionContainerMappingProviderSpecificDetails):
    """A2A provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param agent_auto_update_status: A value indicating whether the auto update is enabled.
     Possible values include: "Disabled", "Enabled".
    :type agent_auto_update_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
    :param automation_account_arm_id: The automation account arm id.
    :type automation_account_arm_id: str
    :param schedule_name: The schedule arm name.
    :type schedule_name: str
    :param job_schedule_name: The job schedule arm name.
    :type job_schedule_name: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'agent_auto_update_status': {'key': 'agentAutoUpdateStatus', 'type': 'str'},
        'automation_account_arm_id': {'key': 'automationAccountArmId', 'type': 'str'},
        'schedule_name': {'key': 'scheduleName', 'type': 'str'},
        'job_schedule_name': {'key': 'jobScheduleName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        agent_auto_update_status: Optional[Union[str, "AgentAutoUpdateStatus"]] = None,
        automation_account_arm_id: Optional[str] = None,
        schedule_name: Optional[str] = None,
        job_schedule_name: Optional[str] = None,
        **kwargs
    ):
        super(A2AProtectionContainerMappingDetails, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.agent_auto_update_status = agent_auto_update_status
        self.automation_account_arm_id = automation_account_arm_id
        self.schedule_name = schedule_name
        self.job_schedule_name = job_schedule_name


class A2AProtectionIntentDiskInputDetails(msrest.serialization.Model):
    """Azure VM unmanaged disk input details.

    All required parameters must be populated in order to send to Azure.

    :param disk_uri: Required. The disk Uri.
    :type disk_uri: str
    :param recovery_azure_storage_account_custom_input: The recovery VHD storage account input.
    :type recovery_azure_storage_account_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :param primary_staging_storage_account_custom_input: The primary staging storage account input.
    :type primary_staging_storage_account_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    """

    _validation = {
        'disk_uri': {'required': True},
    }

    _attribute_map = {
        'disk_uri': {'key': 'diskUri', 'type': 'str'},
        'recovery_azure_storage_account_custom_input': {'key': 'recoveryAzureStorageAccountCustomInput', 'type': 'StorageAccountCustomDetails'},
        'primary_staging_storage_account_custom_input': {'key': 'primaryStagingStorageAccountCustomInput', 'type': 'StorageAccountCustomDetails'},
    }

    def __init__(
        self,
        *,
        disk_uri: str,
        recovery_azure_storage_account_custom_input: Optional["StorageAccountCustomDetails"] = None,
        primary_staging_storage_account_custom_input: Optional["StorageAccountCustomDetails"] = None,
        **kwargs
    ):
        super(A2AProtectionIntentDiskInputDetails, self).__init__(**kwargs)
        self.disk_uri = disk_uri
        self.recovery_azure_storage_account_custom_input = recovery_azure_storage_account_custom_input
        self.primary_staging_storage_account_custom_input = primary_staging_storage_account_custom_input


class A2AProtectionIntentManagedDiskInputDetails(msrest.serialization.Model):
    """Azure VM managed disk input details.

    All required parameters must be populated in order to send to Azure.

    :param disk_id: Required. The disk Id.
    :type disk_id: str
    :param primary_staging_storage_account_custom_input: The primary staging storage account input.
    :type primary_staging_storage_account_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :param recovery_resource_group_custom_input: The recovery resource group input.
    :type recovery_resource_group_custom_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryResourceGroupCustomDetails
    :param recovery_replica_disk_account_type: The replica disk type. Its an optional value and
     will be same as source disk type if not user provided.
    :type recovery_replica_disk_account_type: str
    :param recovery_target_disk_account_type: The target disk type after failover. Its an optional
     value and will be same as source disk type if not user provided.
    :type recovery_target_disk_account_type: str
    :param recovery_disk_encryption_set_id: The recovery disk encryption set Id.
    :type recovery_disk_encryption_set_id: str
    :param disk_encryption_info: The recovery disk encryption information (for one / single pass
     flows).
    :type disk_encryption_info: ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    """

    _validation = {
        'disk_id': {'required': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'primary_staging_storage_account_custom_input': {'key': 'primaryStagingStorageAccountCustomInput', 'type': 'StorageAccountCustomDetails'},
        'recovery_resource_group_custom_input': {'key': 'recoveryResourceGroupCustomInput', 'type': 'RecoveryResourceGroupCustomDetails'},
        'recovery_replica_disk_account_type': {'key': 'recoveryReplicaDiskAccountType', 'type': 'str'},
        'recovery_target_disk_account_type': {'key': 'recoveryTargetDiskAccountType', 'type': 'str'},
        'recovery_disk_encryption_set_id': {'key': 'recoveryDiskEncryptionSetId', 'type': 'str'},
        'disk_encryption_info': {'key': 'diskEncryptionInfo', 'type': 'DiskEncryptionInfo'},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        primary_staging_storage_account_custom_input: Optional["StorageAccountCustomDetails"] = None,
        recovery_resource_group_custom_input: Optional["RecoveryResourceGroupCustomDetails"] = None,
        recovery_replica_disk_account_type: Optional[str] = None,
        recovery_target_disk_account_type: Optional[str] = None,
        recovery_disk_encryption_set_id: Optional[str] = None,
        disk_encryption_info: Optional["DiskEncryptionInfo"] = None,
        **kwargs
    ):
        super(A2AProtectionIntentManagedDiskInputDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.primary_staging_storage_account_custom_input = primary_staging_storage_account_custom_input
        self.recovery_resource_group_custom_input = recovery_resource_group_custom_input
        self.recovery_replica_disk_account_type = recovery_replica_disk_account_type
        self.recovery_target_disk_account_type = recovery_target_disk_account_type
        self.recovery_disk_encryption_set_id = recovery_disk_encryption_set_id
        self.disk_encryption_info = disk_encryption_info


class ProviderSpecificRecoveryPointDetails(msrest.serialization.Model):
    """Replication provider specific recovery point details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2ARecoveryPointDetails, InMageAzureV2RecoveryPointDetails, InMageRcmRecoveryPointDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the provider type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2ARecoveryPointDetails', 'InMageAzureV2': 'InMageAzureV2RecoveryPointDetails', 'InMageRcm': 'InMageRcmRecoveryPointDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProviderSpecificRecoveryPointDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2ARecoveryPointDetails(ProviderSpecificRecoveryPointDetails):
    """A2A provider specific recovery point details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the provider type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_sync_type: A value indicating whether the recovery point is multi VM
     consistent. Possible values include: "MultiVmSyncRecoveryPoint", "PerVmRecoveryPoint".
    :type recovery_point_sync_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointSyncType
    :param disks: List of disk ids representing a recovery point.
    :type disks: list[str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_sync_type': {'key': 'recoveryPointSyncType', 'type': 'str'},
        'disks': {'key': 'disks', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        recovery_point_sync_type: Optional[Union[str, "RecoveryPointSyncType"]] = None,
        disks: Optional[List[str]] = None,
        **kwargs
    ):
        super(A2ARecoveryPointDetails, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_point_sync_type = recovery_point_sync_type
        self.disks = disks


class RemoveDisksProviderSpecificInput(msrest.serialization.Model):
    """Remove Disk provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2ARemoveDisksInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2ARemoveDisksInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemoveDisksProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2ARemoveDisksInput(RemoveDisksProviderSpecificInput):
    """A2A remove disk(s) input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param vm_disks_uris: The list of vm disk vhd URIs.
    :type vm_disks_uris: list[str]
    :param vm_managed_disks_ids: The list of vm managed disk Ids.
    :type vm_managed_disks_ids: list[str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vm_disks_uris': {'key': 'vmDisksUris', 'type': '[str]'},
        'vm_managed_disks_ids': {'key': 'vmManagedDisksIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        vm_disks_uris: Optional[List[str]] = None,
        vm_managed_disks_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(A2ARemoveDisksInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.vm_disks_uris = vm_disks_uris
        self.vm_managed_disks_ids = vm_managed_disks_ids


class A2AReplicationDetails(ReplicationProviderSpecificSettings):
    """A2A provider specific settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param fabric_object_id: The fabric specific object Id of the virtual machine.
    :type fabric_object_id: str
    :ivar initial_primary_zone: The initial primary availability zone.
    :vartype initial_primary_zone: str
    :ivar initial_primary_fabric_location: The initial primary fabric location.
    :vartype initial_primary_fabric_location: str
    :ivar initial_recovery_zone: The initial recovery availability zone.
    :vartype initial_recovery_zone: str
    :ivar initial_recovery_fabric_location: The initial recovery fabric location.
    :vartype initial_recovery_fabric_location: str
    :param multi_vm_group_id: The multi vm group Id.
    :type multi_vm_group_id: str
    :param multi_vm_group_name: The multi vm group name.
    :type multi_vm_group_name: str
    :param multi_vm_group_create_option: Whether Multi VM group is auto created or specified by
     user. Possible values include: "AutoCreated", "UserSpecified".
    :type multi_vm_group_create_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmGroupCreateOption
    :param management_id: The management Id.
    :type management_id: str
    :param protected_disks: The list of protected disks.
    :type protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectedDiskDetails]
    :param unprotected_disks: The list of unprotected disks.
    :type unprotected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AUnprotectedDiskDetails]
    :param protected_managed_disks: The list of protected managed disks.
    :type protected_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectedManagedDiskDetails]
    :param recovery_boot_diag_storage_account_id: The recovery boot diagnostic storage account Arm
     Id.
    :type recovery_boot_diag_storage_account_id: str
    :param primary_fabric_location: Primary fabric location.
    :type primary_fabric_location: str
    :param recovery_fabric_location: The recovery fabric location.
    :type recovery_fabric_location: str
    :param os_type: The type of operating system.
    :type os_type: str
    :param recovery_azure_vm_size: The size of recovery virtual machine.
    :type recovery_azure_vm_size: str
    :param recovery_azure_vm_name: The name of recovery virtual machine.
    :type recovery_azure_vm_name: str
    :param recovery_azure_resource_group_id: The recovery resource group.
    :type recovery_azure_resource_group_id: str
    :param recovery_cloud_service: The recovery cloud service.
    :type recovery_cloud_service: str
    :param recovery_availability_set: The recovery availability set.
    :type recovery_availability_set: str
    :param selected_recovery_azure_network_id: The recovery virtual network.
    :type selected_recovery_azure_network_id: str
    :param selected_tfo_azure_network_id: The test failover virtual network.
    :type selected_tfo_azure_network_id: str
    :param vm_nics: The virtual machine nic details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :param vm_synced_config_details: The synced configuration details.
    :type vm_synced_config_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.AzureToAzureVmSyncedConfigDetails
    :param monitoring_percentage_completion: The percentage of the monitoring job. The type of the
     monitoring job is defined by MonitoringJobType property.
    :type monitoring_percentage_completion: int
    :param monitoring_job_type: The type of the monitoring job. The progress is contained in
     MonitoringPercentageCompletion property.
    :type monitoring_job_type: str
    :param last_heartbeat: The last heartbeat received from the source server.
    :type last_heartbeat: ~datetime.datetime
    :param agent_version: The agent version.
    :type agent_version: str
    :param agent_expiry_date: Agent expiry date.
    :type agent_expiry_date: ~datetime.datetime
    :param is_replication_agent_update_required: A value indicating whether replication agent
     update is required.
    :type is_replication_agent_update_required: bool
    :ivar agent_certificate_expiry_date: Agent certificate expiry date.
    :vartype agent_certificate_expiry_date: ~datetime.datetime
    :param is_replication_agent_certificate_update_required: A value indicating whether agent
     certificate update is required.
    :type is_replication_agent_certificate_update_required: bool
    :param recovery_fabric_object_id: The recovery fabric object Id.
    :type recovery_fabric_object_id: str
    :param vm_protection_state: The protection state for the vm.
    :type vm_protection_state: str
    :param vm_protection_state_description: The protection state description for the vm.
    :type vm_protection_state_description: str
    :param lifecycle_id: An id associated with the PE that survives actions like switch protection
     which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to
     have a link/continuity in being able to have an Id that denotes the "same" protected item even
     though other internal Ids/ARM Id might be changing.
    :type lifecycle_id: str
    :param test_failover_recovery_fabric_object_id: The test failover fabric object Id.
    :type test_failover_recovery_fabric_object_id: str
    :param rpo_in_seconds: The last RPO value in seconds.
    :type rpo_in_seconds: long
    :param last_rpo_calculated_time: The time (in UTC) when the last RPO value was calculated by
     Protection Service.
    :type last_rpo_calculated_time: ~datetime.datetime
    :param primary_availability_zone: The primary availability zone.
    :type primary_availability_zone: str
    :param recovery_availability_zone: The recovery availability zone.
    :type recovery_availability_zone: str
    :ivar vm_encryption_type: The encryption type of the VM. Possible values include:
     "NotEncrypted", "OnePassEncrypted", "TwoPassEncrypted".
    :vartype vm_encryption_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmEncryptionType
    :param tfo_azure_vm_name: The test failover vm name.
    :type tfo_azure_vm_name: str
    :ivar recovery_azure_generation: The recovery azure generation.
    :vartype recovery_azure_generation: str
    :param recovery_proximity_placement_group_id: The recovery proximity placement group Id.
    :type recovery_proximity_placement_group_id: str
    :param auto_protection_of_data_disk: A value indicating whether the auto protection is enabled.
     Possible values include: "Disabled", "Enabled".
    :type auto_protection_of_data_disk: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
    :param recovery_virtual_machine_scale_set_id: The recovery virtual machine scale set id.
    :type recovery_virtual_machine_scale_set_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'initial_primary_zone': {'readonly': True},
        'initial_primary_fabric_location': {'readonly': True},
        'initial_recovery_zone': {'readonly': True},
        'initial_recovery_fabric_location': {'readonly': True},
        'agent_certificate_expiry_date': {'readonly': True},
        'vm_encryption_type': {'readonly': True},
        'recovery_azure_generation': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'initial_primary_zone': {'key': 'initialPrimaryZone', 'type': 'str'},
        'initial_primary_fabric_location': {'key': 'initialPrimaryFabricLocation', 'type': 'str'},
        'initial_recovery_zone': {'key': 'initialRecoveryZone', 'type': 'str'},
        'initial_recovery_fabric_location': {'key': 'initialRecoveryFabricLocation', 'type': 'str'},
        'multi_vm_group_id': {'key': 'multiVmGroupId', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'multi_vm_group_create_option': {'key': 'multiVmGroupCreateOption', 'type': 'str'},
        'management_id': {'key': 'managementId', 'type': 'str'},
        'protected_disks': {'key': 'protectedDisks', 'type': '[A2AProtectedDiskDetails]'},
        'unprotected_disks': {'key': 'unprotectedDisks', 'type': '[A2AUnprotectedDiskDetails]'},
        'protected_managed_disks': {'key': 'protectedManagedDisks', 'type': '[A2AProtectedManagedDiskDetails]'},
        'recovery_boot_diag_storage_account_id': {'key': 'recoveryBootDiagStorageAccountId', 'type': 'str'},
        'primary_fabric_location': {'key': 'primaryFabricLocation', 'type': 'str'},
        'recovery_fabric_location': {'key': 'recoveryFabricLocation', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'recovery_azure_vm_size': {'key': 'recoveryAzureVMSize', 'type': 'str'},
        'recovery_azure_vm_name': {'key': 'recoveryAzureVMName', 'type': 'str'},
        'recovery_azure_resource_group_id': {'key': 'recoveryAzureResourceGroupId', 'type': 'str'},
        'recovery_cloud_service': {'key': 'recoveryCloudService', 'type': 'str'},
        'recovery_availability_set': {'key': 'recoveryAvailabilitySet', 'type': 'str'},
        'selected_recovery_azure_network_id': {'key': 'selectedRecoveryAzureNetworkId', 'type': 'str'},
        'selected_tfo_azure_network_id': {'key': 'selectedTfoAzureNetworkId', 'type': 'str'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMNicDetails]'},
        'vm_synced_config_details': {'key': 'vmSyncedConfigDetails', 'type': 'AzureToAzureVmSyncedConfigDetails'},
        'monitoring_percentage_completion': {'key': 'monitoringPercentageCompletion', 'type': 'int'},
        'monitoring_job_type': {'key': 'monitoringJobType', 'type': 'str'},
        'last_heartbeat': {'key': 'lastHeartbeat', 'type': 'iso-8601'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'agent_expiry_date': {'key': 'agentExpiryDate', 'type': 'iso-8601'},
        'is_replication_agent_update_required': {'key': 'isReplicationAgentUpdateRequired', 'type': 'bool'},
        'agent_certificate_expiry_date': {'key': 'agentCertificateExpiryDate', 'type': 'iso-8601'},
        'is_replication_agent_certificate_update_required': {'key': 'isReplicationAgentCertificateUpdateRequired', 'type': 'bool'},
        'recovery_fabric_object_id': {'key': 'recoveryFabricObjectId', 'type': 'str'},
        'vm_protection_state': {'key': 'vmProtectionState', 'type': 'str'},
        'vm_protection_state_description': {'key': 'vmProtectionStateDescription', 'type': 'str'},
        'lifecycle_id': {'key': 'lifecycleId', 'type': 'str'},
        'test_failover_recovery_fabric_object_id': {'key': 'testFailoverRecoveryFabricObjectId', 'type': 'str'},
        'rpo_in_seconds': {'key': 'rpoInSeconds', 'type': 'long'},
        'last_rpo_calculated_time': {'key': 'lastRpoCalculatedTime', 'type': 'iso-8601'},
        'primary_availability_zone': {'key': 'primaryAvailabilityZone', 'type': 'str'},
        'recovery_availability_zone': {'key': 'recoveryAvailabilityZone', 'type': 'str'},
        'vm_encryption_type': {'key': 'vmEncryptionType', 'type': 'str'},
        'tfo_azure_vm_name': {'key': 'tfoAzureVMName', 'type': 'str'},
        'recovery_azure_generation': {'key': 'recoveryAzureGeneration', 'type': 'str'},
        'recovery_proximity_placement_group_id': {'key': 'recoveryProximityPlacementGroupId', 'type': 'str'},
        'auto_protection_of_data_disk': {'key': 'autoProtectionOfDataDisk', 'type': 'str'},
        'recovery_virtual_machine_scale_set_id': {'key': 'recoveryVirtualMachineScaleSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fabric_object_id: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_group_create_option: Optional[Union[str, "MultiVmGroupCreateOption"]] = None,
        management_id: Optional[str] = None,
        protected_disks: Optional[List["A2AProtectedDiskDetails"]] = None,
        unprotected_disks: Optional[List["A2AUnprotectedDiskDetails"]] = None,
        protected_managed_disks: Optional[List["A2AProtectedManagedDiskDetails"]] = None,
        recovery_boot_diag_storage_account_id: Optional[str] = None,
        primary_fabric_location: Optional[str] = None,
        recovery_fabric_location: Optional[str] = None,
        os_type: Optional[str] = None,
        recovery_azure_vm_size: Optional[str] = None,
        recovery_azure_vm_name: Optional[str] = None,
        recovery_azure_resource_group_id: Optional[str] = None,
        recovery_cloud_service: Optional[str] = None,
        recovery_availability_set: Optional[str] = None,
        selected_recovery_azure_network_id: Optional[str] = None,
        selected_tfo_azure_network_id: Optional[str] = None,
        vm_nics: Optional[List["VMNicDetails"]] = None,
        vm_synced_config_details: Optional["AzureToAzureVmSyncedConfigDetails"] = None,
        monitoring_percentage_completion: Optional[int] = None,
        monitoring_job_type: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        agent_version: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        is_replication_agent_update_required: Optional[bool] = None,
        is_replication_agent_certificate_update_required: Optional[bool] = None,
        recovery_fabric_object_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        lifecycle_id: Optional[str] = None,
        test_failover_recovery_fabric_object_id: Optional[str] = None,
        rpo_in_seconds: Optional[int] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        primary_availability_zone: Optional[str] = None,
        recovery_availability_zone: Optional[str] = None,
        tfo_azure_vm_name: Optional[str] = None,
        recovery_proximity_placement_group_id: Optional[str] = None,
        auto_protection_of_data_disk: Optional[Union[str, "AutoProtectionOfDataDisk"]] = None,
        recovery_virtual_machine_scale_set_id: Optional[str] = None,
        **kwargs
    ):
        super(A2AReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.fabric_object_id = fabric_object_id
        self.initial_primary_zone = None
        self.initial_primary_fabric_location = None
        self.initial_recovery_zone = None
        self.initial_recovery_fabric_location = None
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_group_create_option = multi_vm_group_create_option
        self.management_id = management_id
        self.protected_disks = protected_disks
        self.unprotected_disks = unprotected_disks
        self.protected_managed_disks = protected_managed_disks
        self.recovery_boot_diag_storage_account_id = recovery_boot_diag_storage_account_id
        self.primary_fabric_location = primary_fabric_location
        self.recovery_fabric_location = recovery_fabric_location
        self.os_type = os_type
        self.recovery_azure_vm_size = recovery_azure_vm_size
        self.recovery_azure_vm_name = recovery_azure_vm_name
        self.recovery_azure_resource_group_id = recovery_azure_resource_group_id
        self.recovery_cloud_service = recovery_cloud_service
        self.recovery_availability_set = recovery_availability_set
        self.selected_recovery_azure_network_id = selected_recovery_azure_network_id
        self.selected_tfo_azure_network_id = selected_tfo_azure_network_id
        self.vm_nics = vm_nics
        self.vm_synced_config_details = vm_synced_config_details
        self.monitoring_percentage_completion = monitoring_percentage_completion
        self.monitoring_job_type = monitoring_job_type
        self.last_heartbeat = last_heartbeat
        self.agent_version = agent_version
        self.agent_expiry_date = agent_expiry_date
        self.is_replication_agent_update_required = is_replication_agent_update_required
        self.agent_certificate_expiry_date = None
        self.is_replication_agent_certificate_update_required = is_replication_agent_certificate_update_required
        self.recovery_fabric_object_id = recovery_fabric_object_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.lifecycle_id = lifecycle_id
        self.test_failover_recovery_fabric_object_id = test_failover_recovery_fabric_object_id
        self.rpo_in_seconds = rpo_in_seconds
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.primary_availability_zone = primary_availability_zone
        self.recovery_availability_zone = recovery_availability_zone
        self.vm_encryption_type = None
        self.tfo_azure_vm_name = tfo_azure_vm_name
        self.recovery_azure_generation = None
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id
        self.auto_protection_of_data_disk = auto_protection_of_data_disk
        self.recovery_virtual_machine_scale_set_id = recovery_virtual_machine_scale_set_id


class ReplicationProtectionIntentProviderSpecificSettings(msrest.serialization.Model):
    """Replication provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AReplicationIntentDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AReplicationIntentDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationProtectionIntentProviderSpecificSettings, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AReplicationIntentDetails(ReplicationProtectionIntentProviderSpecificSettings):
    """A2A provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param fabric_object_id: The fabric specific object Id of the virtual machine.
    :type fabric_object_id: str
    :param primary_location: The primary location for the virtual machine.
    :type primary_location: str
    :param recovery_location: The recovery location for the virtual machine.
    :type recovery_location: str
    :param recovery_subscription_id: The recovery subscription Id of the virtual machine.
    :type recovery_subscription_id: str
    :param vm_disks: The list of vm disk details.
    :type vm_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentDiskInputDetails]
    :param vm_managed_disks: The list of vm managed disk details.
    :type vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AProtectionIntentManagedDiskInputDetails]
    :param recovery_resource_group_id: The recovery resource group id.
    :type recovery_resource_group_id: str
    :param protection_profile: The protection profile custom details.
    :type protection_profile:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionProfileCustomDetails
    :param primary_staging_storage_account: The primary staging storage account details.
    :type primary_staging_storage_account:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :param recovery_availability_set: The recovery availability set details.
    :type recovery_availability_set:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryAvailabilitySetCustomDetails
    :param recovery_virtual_network: The recovery virtual network details.
    :type recovery_virtual_network:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryVirtualNetworkCustomDetails
    :param recovery_proximity_placement_group: The recovery proximity placement group custom
     details.
    :type recovery_proximity_placement_group:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryProximityPlacementGroupCustomDetails
    :param auto_protection_of_data_disk: A value indicating whether the auto protection is enabled.
     Possible values include: "Disabled", "Enabled".
    :type auto_protection_of_data_disk: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
    :param multi_vm_group_name: The multi vm group name.
    :type multi_vm_group_name: str
    :param multi_vm_group_id: The multi vm group id.
    :type multi_vm_group_id: str
    :param recovery_boot_diag_storage_account: The boot diagnostic storage account.
    :type recovery_boot_diag_storage_account:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageAccountCustomDetails
    :param disk_encryption_info: The recovery disk encryption information (for two pass flows).
    :type disk_encryption_info: ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :param recovery_availability_zone: The recovery availability zone.
    :type recovery_availability_zone: str
    :param recovery_availability_type: Required. The recovery availability type of the virtual
     machine.
    :type recovery_availability_type: str
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_availability_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'primary_location': {'key': 'primaryLocation', 'type': 'str'},
        'recovery_location': {'key': 'recoveryLocation', 'type': 'str'},
        'recovery_subscription_id': {'key': 'recoverySubscriptionId', 'type': 'str'},
        'vm_disks': {'key': 'vmDisks', 'type': '[A2AProtectionIntentDiskInputDetails]'},
        'vm_managed_disks': {'key': 'vmManagedDisks', 'type': '[A2AProtectionIntentManagedDiskInputDetails]'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
        'protection_profile': {'key': 'protectionProfile', 'type': 'ProtectionProfileCustomDetails'},
        'primary_staging_storage_account': {'key': 'primaryStagingStorageAccount', 'type': 'StorageAccountCustomDetails'},
        'recovery_availability_set': {'key': 'recoveryAvailabilitySet', 'type': 'RecoveryAvailabilitySetCustomDetails'},
        'recovery_virtual_network': {'key': 'recoveryVirtualNetwork', 'type': 'RecoveryVirtualNetworkCustomDetails'},
        'recovery_proximity_placement_group': {'key': 'recoveryProximityPlacementGroup', 'type': 'RecoveryProximityPlacementGroupCustomDetails'},
        'auto_protection_of_data_disk': {'key': 'autoProtectionOfDataDisk', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'multi_vm_group_id': {'key': 'multiVmGroupId', 'type': 'str'},
        'recovery_boot_diag_storage_account': {'key': 'recoveryBootDiagStorageAccount', 'type': 'StorageAccountCustomDetails'},
        'disk_encryption_info': {'key': 'diskEncryptionInfo', 'type': 'DiskEncryptionInfo'},
        'recovery_availability_zone': {'key': 'recoveryAvailabilityZone', 'type': 'str'},
        'recovery_availability_type': {'key': 'recoveryAvailabilityType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_availability_type: str,
        fabric_object_id: Optional[str] = None,
        primary_location: Optional[str] = None,
        recovery_location: Optional[str] = None,
        recovery_subscription_id: Optional[str] = None,
        vm_disks: Optional[List["A2AProtectionIntentDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["A2AProtectionIntentManagedDiskInputDetails"]] = None,
        recovery_resource_group_id: Optional[str] = None,
        protection_profile: Optional["ProtectionProfileCustomDetails"] = None,
        primary_staging_storage_account: Optional["StorageAccountCustomDetails"] = None,
        recovery_availability_set: Optional["RecoveryAvailabilitySetCustomDetails"] = None,
        recovery_virtual_network: Optional["RecoveryVirtualNetworkCustomDetails"] = None,
        recovery_proximity_placement_group: Optional["RecoveryProximityPlacementGroupCustomDetails"] = None,
        auto_protection_of_data_disk: Optional[Union[str, "AutoProtectionOfDataDisk"]] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        recovery_boot_diag_storage_account: Optional["StorageAccountCustomDetails"] = None,
        disk_encryption_info: Optional["DiskEncryptionInfo"] = None,
        recovery_availability_zone: Optional[str] = None,
        **kwargs
    ):
        super(A2AReplicationIntentDetails, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.fabric_object_id = fabric_object_id
        self.primary_location = primary_location
        self.recovery_location = recovery_location
        self.recovery_subscription_id = recovery_subscription_id
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks
        self.recovery_resource_group_id = recovery_resource_group_id
        self.protection_profile = protection_profile
        self.primary_staging_storage_account = primary_staging_storage_account
        self.recovery_availability_set = recovery_availability_set
        self.recovery_virtual_network = recovery_virtual_network
        self.recovery_proximity_placement_group = recovery_proximity_placement_group
        self.auto_protection_of_data_disk = auto_protection_of_data_disk
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_group_id = multi_vm_group_id
        self.recovery_boot_diag_storage_account = recovery_boot_diag_storage_account
        self.disk_encryption_info = disk_encryption_info
        self.recovery_availability_zone = recovery_availability_zone
        self.recovery_availability_type = recovery_availability_type


class ReverseReplicationProviderSpecificInput(msrest.serialization.Model):
    """Provider specific reverse replication input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AReprotectInput, HyperVReplicaAzureReprotectInput, InMageReprotectInput, InMageAzureV2ReprotectInput, InMageRcmReprotectInput, InMageRcmFailbackReprotectInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AReprotectInput', 'HyperVReplicaAzure': 'HyperVReplicaAzureReprotectInput', 'InMage': 'InMageReprotectInput', 'InMageAzureV2': 'InMageAzureV2ReprotectInput', 'InMageRcm': 'InMageRcmReprotectInput', 'InMageRcmFailback': 'InMageRcmFailbackReprotectInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReverseReplicationProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AReprotectInput(ReverseReplicationProviderSpecificInput):
    """Azure specific reprotect input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_container_id: The recovery container Id.
    :type recovery_container_id: str
    :param vm_disks: The list of vm disk details.
    :type vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
    :param recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
    :type recovery_resource_group_id: str
    :param recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
    :type recovery_cloud_service_id: str
    :param recovery_availability_set_id: The recovery availability set.
    :type recovery_availability_set_id: str
    :param policy_id: The Policy Id.
    :type policy_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_container_id': {'key': 'recoveryContainerId', 'type': 'str'},
        'vm_disks': {'key': 'vmDisks', 'type': '[A2AVmDiskInputDetails]'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
        'recovery_cloud_service_id': {'key': 'recoveryCloudServiceId', 'type': 'str'},
        'recovery_availability_set_id': {'key': 'recoveryAvailabilitySetId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_container_id: Optional[str] = None,
        vm_disks: Optional[List["A2AVmDiskInputDetails"]] = None,
        recovery_resource_group_id: Optional[str] = None,
        recovery_cloud_service_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        **kwargs
    ):
        super(A2AReprotectInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_container_id = recovery_container_id
        self.vm_disks = vm_disks
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_cloud_service_id = recovery_cloud_service_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.policy_id = policy_id


class SwitchProtectionProviderSpecificInput(msrest.serialization.Model):
    """Provider specific switch protection input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2ASwitchProtectionInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2ASwitchProtectionInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SwitchProtectionProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2ASwitchProtectionInput(SwitchProtectionProviderSpecificInput):
    """A2A specific switch protection input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param recovery_container_id: The recovery container Id.
    :type recovery_container_id: str
    :param vm_disks: The list of vm disk details.
    :type vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmDiskInputDetails]
    :param vm_managed_disks: The list of vm managed disk details.
    :type vm_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskInputDetails]
    :param recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
    :type recovery_resource_group_id: str
    :param recovery_cloud_service_id: The recovery cloud service Id. Valid for V1 scenarios.
    :type recovery_cloud_service_id: str
    :param recovery_availability_set_id: The recovery availability set.
    :type recovery_availability_set_id: str
    :param policy_id: The Policy Id.
    :type policy_id: str
    :param recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
    :type recovery_boot_diag_storage_account_id: str
    :param recovery_availability_zone: The recovery availability zone.
    :type recovery_availability_zone: str
    :param recovery_proximity_placement_group_id: The recovery proximity placement group Id.
    :type recovery_proximity_placement_group_id: str
    :param recovery_virtual_machine_scale_set_id: The virtual machine scale set id.
    :type recovery_virtual_machine_scale_set_id: str
    :param disk_encryption_info: The recovery disk encryption information.
    :type disk_encryption_info: ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_container_id': {'key': 'recoveryContainerId', 'type': 'str'},
        'vm_disks': {'key': 'vmDisks', 'type': '[A2AVmDiskInputDetails]'},
        'vm_managed_disks': {'key': 'vmManagedDisks', 'type': '[A2AVmManagedDiskInputDetails]'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
        'recovery_cloud_service_id': {'key': 'recoveryCloudServiceId', 'type': 'str'},
        'recovery_availability_set_id': {'key': 'recoveryAvailabilitySetId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'recovery_boot_diag_storage_account_id': {'key': 'recoveryBootDiagStorageAccountId', 'type': 'str'},
        'recovery_availability_zone': {'key': 'recoveryAvailabilityZone', 'type': 'str'},
        'recovery_proximity_placement_group_id': {'key': 'recoveryProximityPlacementGroupId', 'type': 'str'},
        'recovery_virtual_machine_scale_set_id': {'key': 'recoveryVirtualMachineScaleSetId', 'type': 'str'},
        'disk_encryption_info': {'key': 'diskEncryptionInfo', 'type': 'DiskEncryptionInfo'},
    }

    def __init__(
        self,
        *,
        recovery_container_id: Optional[str] = None,
        vm_disks: Optional[List["A2AVmDiskInputDetails"]] = None,
        vm_managed_disks: Optional[List["A2AVmManagedDiskInputDetails"]] = None,
        recovery_resource_group_id: Optional[str] = None,
        recovery_cloud_service_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        recovery_boot_diag_storage_account_id: Optional[str] = None,
        recovery_availability_zone: Optional[str] = None,
        recovery_proximity_placement_group_id: Optional[str] = None,
        recovery_virtual_machine_scale_set_id: Optional[str] = None,
        disk_encryption_info: Optional["DiskEncryptionInfo"] = None,
        **kwargs
    ):
        super(A2ASwitchProtectionInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_container_id = recovery_container_id
        self.vm_disks = vm_disks
        self.vm_managed_disks = vm_managed_disks
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_cloud_service_id = recovery_cloud_service_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.policy_id = policy_id
        self.recovery_boot_diag_storage_account_id = recovery_boot_diag_storage_account_id
        self.recovery_availability_zone = recovery_availability_zone
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id
        self.recovery_virtual_machine_scale_set_id = recovery_virtual_machine_scale_set_id
        self.disk_encryption_info = disk_encryption_info


class TestFailoverProviderSpecificInput(msrest.serialization.Model):
    """Provider specific test failover input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2ATestFailoverInput, HyperVReplicaAzureTestFailoverInput, InMageTestFailoverInput, InMageAzureV2TestFailoverInput, InMageRcmTestFailoverInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2ATestFailoverInput', 'HyperVReplicaAzure': 'HyperVReplicaAzureTestFailoverInput', 'InMage': 'InMageTestFailoverInput', 'InMageAzureV2': 'InMageAzureV2TestFailoverInput', 'InMageRcm': 'InMageRcmTestFailoverInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TestFailoverProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2ATestFailoverInput(TestFailoverProviderSpecificInput):
    """A2A provider specific input for test failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    :param cloud_service_creation_option: A value indicating whether to use recovery cloud service
     for TFO or not.
    :type cloud_service_creation_option: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'cloud_service_creation_option': {'key': 'cloudServiceCreationOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_id: Optional[str] = None,
        cloud_service_creation_option: Optional[str] = None,
        **kwargs
    ):
        super(A2ATestFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_point_id = recovery_point_id
        self.cloud_service_creation_option = cloud_service_creation_option


class UnplannedFailoverProviderSpecificInput(msrest.serialization.Model):
    """Provider specific unplanned failover input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AUnplannedFailoverInput, HyperVReplicaAzureUnplannedFailoverInput, InMageUnplannedFailoverInput, InMageAzureV2UnplannedFailoverInput, InMageRcmUnplannedFailoverInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AUnplannedFailoverInput', 'HyperVReplicaAzure': 'HyperVReplicaAzureUnplannedFailoverInput', 'InMage': 'InMageUnplannedFailoverInput', 'InMageAzureV2': 'InMageAzureV2UnplannedFailoverInput', 'InMageRcm': 'InMageRcmUnplannedFailoverInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UnplannedFailoverProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AUnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """A2A provider specific input for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    :param cloud_service_creation_option: A value indicating whether to use recovery cloud service
     for failover or not.
    :type cloud_service_creation_option: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'cloud_service_creation_option': {'key': 'cloudServiceCreationOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_id: Optional[str] = None,
        cloud_service_creation_option: Optional[str] = None,
        **kwargs
    ):
        super(A2AUnplannedFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_point_id = recovery_point_id
        self.cloud_service_creation_option = cloud_service_creation_option


class A2AUnprotectedDiskDetails(msrest.serialization.Model):
    """A2A unprotected disk details.

    :param disk_lun_id: The source lun Id for the data disk.
    :type disk_lun_id: int
    :param disk_auto_protection_status: A value indicating whether the disk auto protection is
     enabled. Possible values include: "Disabled", "Enabled".
    :type disk_auto_protection_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AutoProtectionOfDataDisk
    """

    _attribute_map = {
        'disk_lun_id': {'key': 'diskLunId', 'type': 'int'},
        'disk_auto_protection_status': {'key': 'diskAutoProtectionStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_lun_id: Optional[int] = None,
        disk_auto_protection_status: Optional[Union[str, "AutoProtectionOfDataDisk"]] = None,
        **kwargs
    ):
        super(A2AUnprotectedDiskDetails, self).__init__(**kwargs)
        self.disk_lun_id = disk_lun_id
        self.disk_auto_protection_status = disk_auto_protection_status


class ReplicationProviderSpecificUpdateContainerMappingInput(msrest.serialization.Model):
    """Provider specific input for update pairing operations.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AUpdateContainerMappingInput, InMageRcmUpdateContainerMappingInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AUpdateContainerMappingInput', 'InMageRcm': 'InMageRcmUpdateContainerMappingInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationProviderSpecificUpdateContainerMappingInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AUpdateContainerMappingInput(ReplicationProviderSpecificUpdateContainerMappingInput):
    """A2A update protection container mapping.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param agent_auto_update_status: A value indicating whether the auto update is enabled.
     Possible values include: "Disabled", "Enabled".
    :type agent_auto_update_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentAutoUpdateStatus
    :param automation_account_arm_id: The automation account arm id.
    :type automation_account_arm_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'agent_auto_update_status': {'key': 'agentAutoUpdateStatus', 'type': 'str'},
        'automation_account_arm_id': {'key': 'automationAccountArmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        agent_auto_update_status: Optional[Union[str, "AgentAutoUpdateStatus"]] = None,
        automation_account_arm_id: Optional[str] = None,
        **kwargs
    ):
        super(A2AUpdateContainerMappingInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.agent_auto_update_status = agent_auto_update_status
        self.automation_account_arm_id = automation_account_arm_id


class UpdateReplicationProtectedItemProviderInput(msrest.serialization.Model):
    """Update replication protected item provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: A2AUpdateReplicationProtectedItemInput, HyperVReplicaAzureUpdateReplicationProtectedItemInput, InMageAzureV2UpdateReplicationProtectedItemInput, InMageRcmUpdateReplicationProtectedItemInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'A2AUpdateReplicationProtectedItemInput', 'HyperVReplicaAzure': 'HyperVReplicaAzureUpdateReplicationProtectedItemInput', 'InMageAzureV2': 'InMageAzureV2UpdateReplicationProtectedItemInput', 'InMageRcm': 'InMageRcmUpdateReplicationProtectedItemInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateReplicationProtectedItemProviderInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class A2AUpdateReplicationProtectedItemInput(UpdateReplicationProtectedItemProviderInput):
    """InMage Azure V2 input to update replication protected item.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_cloud_service_id: The target cloud service ARM Id (for V1).
    :type recovery_cloud_service_id: str
    :param recovery_resource_group_id: The target resource group ARM Id (for V2).
    :type recovery_resource_group_id: str
    :param managed_disk_update_details: Managed disk update details.
    :type managed_disk_update_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.A2AVmManagedDiskUpdateDetails]
    :param recovery_boot_diag_storage_account_id: The boot diagnostic storage account.
    :type recovery_boot_diag_storage_account_id: str
    :param disk_encryption_info: The recovery os disk encryption information.
    :type disk_encryption_info: ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :param tfo_azure_vm_name: The user given name for Test Failover VM.
    :type tfo_azure_vm_name: str
    :param recovery_proximity_placement_group_id: The recovery proximity placement group Id.
    :type recovery_proximity_placement_group_id: str
    :param recovery_virtual_machine_scale_set_id: The recovery virtual machine scale set Id.
    :type recovery_virtual_machine_scale_set_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_cloud_service_id': {'key': 'recoveryCloudServiceId', 'type': 'str'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
        'managed_disk_update_details': {'key': 'managedDiskUpdateDetails', 'type': '[A2AVmManagedDiskUpdateDetails]'},
        'recovery_boot_diag_storage_account_id': {'key': 'recoveryBootDiagStorageAccountId', 'type': 'str'},
        'disk_encryption_info': {'key': 'diskEncryptionInfo', 'type': 'DiskEncryptionInfo'},
        'tfo_azure_vm_name': {'key': 'tfoAzureVMName', 'type': 'str'},
        'recovery_proximity_placement_group_id': {'key': 'recoveryProximityPlacementGroupId', 'type': 'str'},
        'recovery_virtual_machine_scale_set_id': {'key': 'recoveryVirtualMachineScaleSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_cloud_service_id: Optional[str] = None,
        recovery_resource_group_id: Optional[str] = None,
        managed_disk_update_details: Optional[List["A2AVmManagedDiskUpdateDetails"]] = None,
        recovery_boot_diag_storage_account_id: Optional[str] = None,
        disk_encryption_info: Optional["DiskEncryptionInfo"] = None,
        tfo_azure_vm_name: Optional[str] = None,
        recovery_proximity_placement_group_id: Optional[str] = None,
        recovery_virtual_machine_scale_set_id: Optional[str] = None,
        **kwargs
    ):
        super(A2AUpdateReplicationProtectedItemInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_cloud_service_id = recovery_cloud_service_id
        self.recovery_resource_group_id = recovery_resource_group_id
        self.managed_disk_update_details = managed_disk_update_details
        self.recovery_boot_diag_storage_account_id = recovery_boot_diag_storage_account_id
        self.disk_encryption_info = disk_encryption_info
        self.tfo_azure_vm_name = tfo_azure_vm_name
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id
        self.recovery_virtual_machine_scale_set_id = recovery_virtual_machine_scale_set_id


class A2AVmDiskInputDetails(msrest.serialization.Model):
    """A2A disk input details.

    All required parameters must be populated in order to send to Azure.

    :param disk_uri: Required. The disk Uri.
    :type disk_uri: str
    :param recovery_azure_storage_account_id: Required. The recovery VHD storage account Id.
    :type recovery_azure_storage_account_id: str
    :param primary_staging_azure_storage_account_id: Required. The primary staging storage account
     Id.
    :type primary_staging_azure_storage_account_id: str
    """

    _validation = {
        'disk_uri': {'required': True},
        'recovery_azure_storage_account_id': {'required': True},
        'primary_staging_azure_storage_account_id': {'required': True},
    }

    _attribute_map = {
        'disk_uri': {'key': 'diskUri', 'type': 'str'},
        'recovery_azure_storage_account_id': {'key': 'recoveryAzureStorageAccountId', 'type': 'str'},
        'primary_staging_azure_storage_account_id': {'key': 'primaryStagingAzureStorageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_uri: str,
        recovery_azure_storage_account_id: str,
        primary_staging_azure_storage_account_id: str,
        **kwargs
    ):
        super(A2AVmDiskInputDetails, self).__init__(**kwargs)
        self.disk_uri = disk_uri
        self.recovery_azure_storage_account_id = recovery_azure_storage_account_id
        self.primary_staging_azure_storage_account_id = primary_staging_azure_storage_account_id


class A2AVmManagedDiskInputDetails(msrest.serialization.Model):
    """A2A managed disk input details.

    All required parameters must be populated in order to send to Azure.

    :param disk_id: Required. The disk Id.
    :type disk_id: str
    :param primary_staging_azure_storage_account_id: Required. The primary staging storage account
     Arm Id.
    :type primary_staging_azure_storage_account_id: str
    :param recovery_resource_group_id: Required. The target resource group Arm Id.
    :type recovery_resource_group_id: str
    :param recovery_replica_disk_account_type: The replica disk type. Its an optional value and
     will be same as source disk type if not user provided.
    :type recovery_replica_disk_account_type: str
    :param recovery_target_disk_account_type: The target disk type after failover. Its an optional
     value and will be same as source disk type if not user provided.
    :type recovery_target_disk_account_type: str
    :param recovery_disk_encryption_set_id: The recovery disk encryption set Id.
    :type recovery_disk_encryption_set_id: str
    :param disk_encryption_info: The recovery disk encryption information (for one / single pass
     flows).
    :type disk_encryption_info: ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    """

    _validation = {
        'disk_id': {'required': True},
        'primary_staging_azure_storage_account_id': {'required': True},
        'recovery_resource_group_id': {'required': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'primary_staging_azure_storage_account_id': {'key': 'primaryStagingAzureStorageAccountId', 'type': 'str'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
        'recovery_replica_disk_account_type': {'key': 'recoveryReplicaDiskAccountType', 'type': 'str'},
        'recovery_target_disk_account_type': {'key': 'recoveryTargetDiskAccountType', 'type': 'str'},
        'recovery_disk_encryption_set_id': {'key': 'recoveryDiskEncryptionSetId', 'type': 'str'},
        'disk_encryption_info': {'key': 'diskEncryptionInfo', 'type': 'DiskEncryptionInfo'},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        primary_staging_azure_storage_account_id: str,
        recovery_resource_group_id: str,
        recovery_replica_disk_account_type: Optional[str] = None,
        recovery_target_disk_account_type: Optional[str] = None,
        recovery_disk_encryption_set_id: Optional[str] = None,
        disk_encryption_info: Optional["DiskEncryptionInfo"] = None,
        **kwargs
    ):
        super(A2AVmManagedDiskInputDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.primary_staging_azure_storage_account_id = primary_staging_azure_storage_account_id
        self.recovery_resource_group_id = recovery_resource_group_id
        self.recovery_replica_disk_account_type = recovery_replica_disk_account_type
        self.recovery_target_disk_account_type = recovery_target_disk_account_type
        self.recovery_disk_encryption_set_id = recovery_disk_encryption_set_id
        self.disk_encryption_info = disk_encryption_info


class A2AVmManagedDiskUpdateDetails(msrest.serialization.Model):
    """A2A Vm managed disk update details.

    :param disk_id: The disk Id.
    :type disk_id: str
    :param recovery_target_disk_account_type: The target disk type before failover.
    :type recovery_target_disk_account_type: str
    :param recovery_replica_disk_account_type: The replica disk type before failover.
    :type recovery_replica_disk_account_type: str
    :param disk_encryption_info: The recovery os disk encryption information.
    :type disk_encryption_info: ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionInfo
    :param failover_disk_name: The target disk name for unplanned failover operation.
    :type failover_disk_name: str
    :param tfo_disk_name: The target disk name for test failover operation.
    :type tfo_disk_name: str
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'recovery_target_disk_account_type': {'key': 'recoveryTargetDiskAccountType', 'type': 'str'},
        'recovery_replica_disk_account_type': {'key': 'recoveryReplicaDiskAccountType', 'type': 'str'},
        'disk_encryption_info': {'key': 'diskEncryptionInfo', 'type': 'DiskEncryptionInfo'},
        'failover_disk_name': {'key': 'failoverDiskName', 'type': 'str'},
        'tfo_disk_name': {'key': 'tfoDiskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        recovery_target_disk_account_type: Optional[str] = None,
        recovery_replica_disk_account_type: Optional[str] = None,
        disk_encryption_info: Optional["DiskEncryptionInfo"] = None,
        failover_disk_name: Optional[str] = None,
        tfo_disk_name: Optional[str] = None,
        **kwargs
    ):
        super(A2AVmManagedDiskUpdateDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.recovery_target_disk_account_type = recovery_target_disk_account_type
        self.recovery_replica_disk_account_type = recovery_replica_disk_account_type
        self.disk_encryption_info = disk_encryption_info
        self.failover_disk_name = failover_disk_name
        self.tfo_disk_name = tfo_disk_name


class A2AZoneDetails(msrest.serialization.Model):
    """Zone details data.

    :param source: Source zone info.
    :type source: str
    :param target: The target zone info.
    :type target: str
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        super(A2AZoneDetails, self).__init__(**kwargs)
        self.source = source
        self.target = target


class AddDisksInput(msrest.serialization.Model):
    """Input for add disk(s) operation.

    :param properties: Add disks input properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AddDisksInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AddDisksInputProperties"] = None,
        **kwargs
    ):
        super(AddDisksInput, self).__init__(**kwargs)
        self.properties = properties


class AddDisksInputProperties(msrest.serialization.Model):
    """Add Disks input properties.

    All required parameters must be populated in order to send to Azure.

    :param provider_specific_details: Required. The ReplicationProviderInput. For
     HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it
     will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksProviderSpecificInput
    """

    _validation = {
        'provider_specific_details': {'required': True},
    }

    _attribute_map = {
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'AddDisksProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: "AddDisksProviderSpecificInput",
        **kwargs
    ):
        super(AddDisksInputProperties, self).__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class AddRecoveryServicesProviderInput(msrest.serialization.Model):
    """Input required to add a provider.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. The properties of an add provider request.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.AddRecoveryServicesProviderInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AddRecoveryServicesProviderInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "AddRecoveryServicesProviderInputProperties",
        **kwargs
    ):
        super(AddRecoveryServicesProviderInput, self).__init__(**kwargs)
        self.properties = properties


class AddRecoveryServicesProviderInputProperties(msrest.serialization.Model):
    """The properties of an add provider request.

    All required parameters must be populated in order to send to Azure.

    :param machine_name: Required. The name of the machine where the provider is getting added.
    :type machine_name: str
    :param machine_id: The Id of the machine where the provider is getting added.
    :type machine_id: str
    :param bios_id: The Bios Id of the machine.
    :type bios_id: str
    :param authentication_identity_input: Required. The identity provider input for DRA
     authentication.
    :type authentication_identity_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
    :param resource_access_identity_input: Required. The identity provider input for resource
     access.
    :type resource_access_identity_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
    :param data_plane_authentication_identity_input: The identity provider input for data plane
     authentication.
    :type data_plane_authentication_identity_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
    """

    _validation = {
        'machine_name': {'required': True},
        'authentication_identity_input': {'required': True},
        'resource_access_identity_input': {'required': True},
    }

    _attribute_map = {
        'machine_name': {'key': 'machineName', 'type': 'str'},
        'machine_id': {'key': 'machineId', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'authentication_identity_input': {'key': 'authenticationIdentityInput', 'type': 'IdentityProviderInput'},
        'resource_access_identity_input': {'key': 'resourceAccessIdentityInput', 'type': 'IdentityProviderInput'},
        'data_plane_authentication_identity_input': {'key': 'dataPlaneAuthenticationIdentityInput', 'type': 'IdentityProviderInput'},
    }

    def __init__(
        self,
        *,
        machine_name: str,
        authentication_identity_input: "IdentityProviderInput",
        resource_access_identity_input: "IdentityProviderInput",
        machine_id: Optional[str] = None,
        bios_id: Optional[str] = None,
        data_plane_authentication_identity_input: Optional["IdentityProviderInput"] = None,
        **kwargs
    ):
        super(AddRecoveryServicesProviderInputProperties, self).__init__(**kwargs)
        self.machine_name = machine_name
        self.machine_id = machine_id
        self.bios_id = bios_id
        self.authentication_identity_input = authentication_identity_input
        self.resource_access_identity_input = resource_access_identity_input
        self.data_plane_authentication_identity_input = data_plane_authentication_identity_input


class AddVCenterRequest(msrest.serialization.Model):
    """Input required to add vCenter.

    :param properties: The properties of an add vCenter request.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.AddVCenterRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AddVCenterRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["AddVCenterRequestProperties"] = None,
        **kwargs
    ):
        super(AddVCenterRequest, self).__init__(**kwargs)
        self.properties = properties


class AddVCenterRequestProperties(msrest.serialization.Model):
    """The properties of an add vCenter request.

    :param friendly_name: The friendly name of the vCenter.
    :type friendly_name: str
    :param ip_address: The IP address of the vCenter to be discovered.
    :type ip_address: str
    :param process_server_id: The process server Id from where the discovery is orchestrated.
    :type process_server_id: str
    :param port: The port number for discovery.
    :type port: str
    :param run_as_account_id: The account Id which has privileges to discover the vCenter.
    :type run_as_account_id: str
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        ip_address: Optional[str] = None,
        process_server_id: Optional[str] = None,
        port: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        **kwargs
    ):
        super(AddVCenterRequestProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.ip_address = ip_address
        self.process_server_id = process_server_id
        self.port = port
        self.run_as_account_id = run_as_account_id


class AgentDetails(msrest.serialization.Model):
    """Agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar agent_id: The Id of the agent running on the server.
    :vartype agent_id: str
    :ivar machine_id: The Id of the machine to which the agent is registered.
    :vartype machine_id: str
    :ivar bios_id: The machine BIOS Id.
    :vartype bios_id: str
    :ivar fqdn: The machine FQDN.
    :vartype fqdn: str
    :ivar disks: The disks.
    :vartype disks: list[~azure.mgmt.recoveryservicessiterecovery.models.AgentDiskDetails]
    """

    _validation = {
        'agent_id': {'readonly': True},
        'machine_id': {'readonly': True},
        'bios_id': {'readonly': True},
        'fqdn': {'readonly': True},
        'disks': {'readonly': True},
    }

    _attribute_map = {
        'agent_id': {'key': 'agentId', 'type': 'str'},
        'machine_id': {'key': 'machineId', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'disks': {'key': 'disks', 'type': '[AgentDiskDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentDetails, self).__init__(**kwargs)
        self.agent_id = None
        self.machine_id = None
        self.bios_id = None
        self.fqdn = None
        self.disks = None


class AgentDiskDetails(msrest.serialization.Model):
    """Agent disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_id: The disk Id.
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar is_os_disk: A value indicating whether the disk is the OS disk.
    :vartype is_os_disk: str
    :ivar capacity_in_bytes: The disk capacity in bytes.
    :vartype capacity_in_bytes: long
    :ivar lun_id: The lun of disk.
    :vartype lun_id: int
    """

    _validation = {
        'disk_id': {'readonly': True},
        'disk_name': {'readonly': True},
        'is_os_disk': {'readonly': True},
        'capacity_in_bytes': {'readonly': True},
        'lun_id': {'readonly': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'is_os_disk': {'key': 'isOSDisk', 'type': 'str'},
        'capacity_in_bytes': {'key': 'capacityInBytes', 'type': 'long'},
        'lun_id': {'key': 'lunId', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentDiskDetails, self).__init__(**kwargs)
        self.disk_id = None
        self.disk_name = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.lun_id = None


class Resource(msrest.serialization.Model):
    """Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location


class Alert(Resource):
    """Implements the Alert class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: Alert related data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.AlertProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AlertProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["AlertProperties"] = None,
        **kwargs
    ):
        super(Alert, self).__init__(location=location, **kwargs)
        self.properties = properties


class AlertCollection(msrest.serialization.Model):
    """Collection of alerts.

    :param value: The list of alerts.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.Alert]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Alert]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Alert"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AlertCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AlertProperties(msrest.serialization.Model):
    """The properties of an alert.

    :param send_to_owners: A value indicating whether to send email to subscription administrator.
    :type send_to_owners: str
    :param custom_email_addresses: The custom email address for sending emails.
    :type custom_email_addresses: list[str]
    :param locale: The locale for the email notification.
    :type locale: str
    """

    _attribute_map = {
        'send_to_owners': {'key': 'sendToOwners', 'type': 'str'},
        'custom_email_addresses': {'key': 'customEmailAddresses', 'type': '[str]'},
        'locale': {'key': 'locale', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        send_to_owners: Optional[str] = None,
        custom_email_addresses: Optional[List[str]] = None,
        locale: Optional[str] = None,
        **kwargs
    ):
        super(AlertProperties, self).__init__(**kwargs)
        self.send_to_owners = send_to_owners
        self.custom_email_addresses = custom_email_addresses
        self.locale = locale


class ApplyRecoveryPointInput(msrest.serialization.Model):
    """Input to apply recovery point.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. The input properties to apply recovery point.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ApplyRecoveryPointInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ApplyRecoveryPointInputProperties",
        **kwargs
    ):
        super(ApplyRecoveryPointInput, self).__init__(**kwargs)
        self.properties = properties


class ApplyRecoveryPointInputProperties(msrest.serialization.Model):
    """Input properties to apply recovery point.

    All required parameters must be populated in order to send to Azure.

    :param recovery_point_id: The recovery point Id.
    :type recovery_point_id: str
    :param provider_specific_details: Required. Provider specific input for applying recovery
     point.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointProviderSpecificInput
    """

    _validation = {
        'provider_specific_details': {'required': True},
    }

    _attribute_map = {
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'ApplyRecoveryPointProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: "ApplyRecoveryPointProviderSpecificInput",
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(ApplyRecoveryPointInputProperties, self).__init__(**kwargs)
        self.recovery_point_id = recovery_point_id
        self.provider_specific_details = provider_specific_details


class JobDetails(msrest.serialization.Model):
    """Job details based on specific job type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AsrJobDetails, ExportJobDetails, FailoverJobDetails, SwitchProtectionJobDetails, TestFailoverJobDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of job details (see JobDetailsTypes enum for
     possible values).Constant filled by server.
    :type instance_type: str
    :param affected_object_details: The affected object properties like source server, source
     cloud, target server, target cloud etc. based on the workflow object details.
    :type affected_object_details: dict[str, str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'affected_object_details': {'key': 'affectedObjectDetails', 'type': '{str}'},
    }

    _subtype_map = {
        'instance_type': {'AsrJobDetails': 'AsrJobDetails', 'ExportJobDetails': 'ExportJobDetails', 'FailoverJobDetails': 'FailoverJobDetails', 'SwitchProtectionJobDetails': 'SwitchProtectionJobDetails', 'TestFailoverJobDetails': 'TestFailoverJobDetails'}
    }

    def __init__(
        self,
        *,
        affected_object_details: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(JobDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]
        self.affected_object_details = affected_object_details


class AsrJobDetails(JobDetails):
    """This class represents job details based on specific job type.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of job details (see JobDetailsTypes enum for
     possible values).Constant filled by server.
    :type instance_type: str
    :param affected_object_details: The affected object properties like source server, source
     cloud, target server, target cloud etc. based on the workflow object details.
    :type affected_object_details: dict[str, str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'affected_object_details': {'key': 'affectedObjectDetails', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        affected_object_details: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(AsrJobDetails, self).__init__(affected_object_details=affected_object_details, **kwargs)
        self.instance_type = 'AsrJobDetails'  # type: str


class ASRTask(msrest.serialization.Model):
    """Task of the Job.

    :param task_id: The Id.
    :type task_id: str
    :param name: The unique Task name.
    :type name: str
    :param start_time: The start time.
    :type start_time: ~datetime.datetime
    :param end_time: The end time.
    :type end_time: ~datetime.datetime
    :param allowed_actions: The state/actions applicable on this task.
    :type allowed_actions: list[str]
    :param friendly_name: The name.
    :type friendly_name: str
    :param state: The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed,
     Cancelled, Suspended or Other.
    :type state: str
    :param state_description: The description of the task state. For example - For Succeeded state,
     description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
    :type state_description: str
    :param task_type: The type of task. Details in CustomDetails property depend on this type.
    :type task_type: str
    :param custom_details: The custom task details based on the task type.
    :type custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.TaskTypeDetails
    :param group_task_custom_details: The custom task details based on the task type, if the task
     type is GroupTaskDetails or one of the types derived from it.
    :type group_task_custom_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.GroupTaskDetails
    :param errors: The task error details.
    :type errors: list[~azure.mgmt.recoveryservicessiterecovery.models.JobErrorDetails]
    """

    _attribute_map = {
        'task_id': {'key': 'taskId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'allowed_actions': {'key': 'allowedActions', 'type': '[str]'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'state_description': {'key': 'stateDescription', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'custom_details': {'key': 'customDetails', 'type': 'TaskTypeDetails'},
        'group_task_custom_details': {'key': 'groupTaskCustomDetails', 'type': 'GroupTaskDetails'},
        'errors': {'key': 'errors', 'type': '[JobErrorDetails]'},
    }

    def __init__(
        self,
        *,
        task_id: Optional[str] = None,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        allowed_actions: Optional[List[str]] = None,
        friendly_name: Optional[str] = None,
        state: Optional[str] = None,
        state_description: Optional[str] = None,
        task_type: Optional[str] = None,
        custom_details: Optional["TaskTypeDetails"] = None,
        group_task_custom_details: Optional["GroupTaskDetails"] = None,
        errors: Optional[List["JobErrorDetails"]] = None,
        **kwargs
    ):
        super(ASRTask, self).__init__(**kwargs)
        self.task_id = task_id
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.allowed_actions = allowed_actions
        self.friendly_name = friendly_name
        self.state = state
        self.state_description = state_description
        self.task_type = task_type
        self.custom_details = custom_details
        self.group_task_custom_details = group_task_custom_details
        self.errors = errors


class TaskTypeDetails(msrest.serialization.Model):
    """Task details based on specific task type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutomationRunbookTaskDetails, ConsistencyCheckTaskDetails, JobTaskDetails, ManualActionTaskDetails, ScriptActionTaskDetails, VmNicUpdatesTaskDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'AutomationRunbookTaskDetails': 'AutomationRunbookTaskDetails', 'ConsistencyCheckTaskDetails': 'ConsistencyCheckTaskDetails', 'JobTaskDetails': 'JobTaskDetails', 'ManualActionTaskDetails': 'ManualActionTaskDetails', 'ScriptActionTaskDetails': 'ScriptActionTaskDetails', 'VmNicUpdatesTaskDetails': 'VmNicUpdatesTaskDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskTypeDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class AutomationRunbookTaskDetails(TaskTypeDetails):
    """This class represents the task details for an automation runbook.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param name: The recovery plan task name.
    :type name: str
    :param cloud_service_name: The cloud service of the automation runbook account.
    :type cloud_service_name: str
    :param subscription_id: The subscription Id of the automation runbook account.
    :type subscription_id: str
    :param account_name: The automation account name of the runbook.
    :type account_name: str
    :param runbook_id: The runbook Id.
    :type runbook_id: str
    :param runbook_name: The runbook name.
    :type runbook_name: str
    :param job_id: The job Id of the runbook execution.
    :type job_id: str
    :param job_output: The execution output of the runbook.
    :type job_output: str
    :param is_primary_side_script: A value indicating whether it is a primary side script or not.
    :type is_primary_side_script: bool
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'cloud_service_name': {'key': 'cloudServiceName', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'runbook_id': {'key': 'runbookId', 'type': 'str'},
        'runbook_name': {'key': 'runbookName', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'job_output': {'key': 'jobOutput', 'type': 'str'},
        'is_primary_side_script': {'key': 'isPrimarySideScript', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        cloud_service_name: Optional[str] = None,
        subscription_id: Optional[str] = None,
        account_name: Optional[str] = None,
        runbook_id: Optional[str] = None,
        runbook_name: Optional[str] = None,
        job_id: Optional[str] = None,
        job_output: Optional[str] = None,
        is_primary_side_script: Optional[bool] = None,
        **kwargs
    ):
        super(AutomationRunbookTaskDetails, self).__init__(**kwargs)
        self.instance_type = 'AutomationRunbookTaskDetails'  # type: str
        self.name = name
        self.cloud_service_name = cloud_service_name
        self.subscription_id = subscription_id
        self.account_name = account_name
        self.runbook_id = runbook_id
        self.runbook_name = runbook_name
        self.job_id = job_id
        self.job_output = job_output
        self.is_primary_side_script = is_primary_side_script


class FabricSpecificCreationInput(msrest.serialization.Model):
    """Fabric provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFabricCreationInput, InMageRcmFabricCreationInput, VMwareV2FabricCreationInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'Azure': 'AzureFabricCreationInput', 'InMageRcm': 'InMageRcmFabricCreationInput', 'VMwareV2': 'VMwareV2FabricCreationInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FabricSpecificCreationInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class AzureFabricCreationInput(FabricSpecificCreationInput):
    """Fabric provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type.Constant filled by server.
    :type instance_type: str
    :param location: The Location.
    :type location: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        super(AzureFabricCreationInput, self).__init__(**kwargs)
        self.instance_type = 'Azure'  # type: str
        self.location = location


class FabricSpecificDetails(msrest.serialization.Model):
    """Fabric specific details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFabricSpecificDetails, HyperVSiteDetails, InMageRcmFabricSpecificDetails, VmmDetails, VMwareDetails, VMwareV2FabricSpecificDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'Azure': 'AzureFabricSpecificDetails', 'HyperVSite': 'HyperVSiteDetails', 'InMageRcm': 'InMageRcmFabricSpecificDetails', 'VMM': 'VmmDetails', 'VMware': 'VMwareDetails', 'VMwareV2': 'VMwareV2FabricSpecificDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FabricSpecificDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class AzureFabricSpecificDetails(FabricSpecificDetails):
    """Azure Fabric Specific Details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param location: The Location for the Azure fabric.
    :type location: str
    :param container_ids: The container Ids for the Azure fabric.
    :type container_ids: list[str]
    :param zones: The zones.
    :type zones: list[~azure.mgmt.recoveryservicessiterecovery.models.A2AZoneDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'container_ids': {'key': 'containerIds', 'type': '[str]'},
        'zones': {'key': 'zones', 'type': '[A2AZoneDetails]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        container_ids: Optional[List[str]] = None,
        zones: Optional[List["A2AZoneDetails"]] = None,
        **kwargs
    ):
        super(AzureFabricSpecificDetails, self).__init__(**kwargs)
        self.instance_type = 'Azure'  # type: str
        self.location = location
        self.container_ids = container_ids
        self.zones = zones


class FabricSpecificCreateNetworkMappingInput(msrest.serialization.Model):
    """Input details specific to fabrics during Network Mapping.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureToAzureCreateNetworkMappingInput, VmmToAzureCreateNetworkMappingInput, VmmToVmmCreateNetworkMappingInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'AzureToAzure': 'AzureToAzureCreateNetworkMappingInput', 'VmmToAzure': 'VmmToAzureCreateNetworkMappingInput', 'VmmToVmm': 'VmmToVmmCreateNetworkMappingInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FabricSpecificCreateNetworkMappingInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class AzureToAzureCreateNetworkMappingInput(FabricSpecificCreateNetworkMappingInput):
    """Create network mappings input properties/behavior specific to Azure to Azure Network mapping.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The instance type.Constant filled by server.
    :type instance_type: str
    :param primary_network_id: Required. The primary azure vnet Id.
    :type primary_network_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'primary_network_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_network_id': {'key': 'primaryNetworkId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_network_id: str,
        **kwargs
    ):
        super(AzureToAzureCreateNetworkMappingInput, self).__init__(**kwargs)
        self.instance_type = 'AzureToAzure'  # type: str
        self.primary_network_id = primary_network_id


class NetworkMappingFabricSpecificSettings(msrest.serialization.Model):
    """Network Mapping fabric specific settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureToAzureNetworkMappingSettings, VmmToAzureNetworkMappingSettings, VmmToVmmNetworkMappingSettings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'AzureToAzure': 'AzureToAzureNetworkMappingSettings', 'VmmToAzure': 'VmmToAzureNetworkMappingSettings', 'VmmToVmm': 'VmmToVmmNetworkMappingSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkMappingFabricSpecificSettings, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class AzureToAzureNetworkMappingSettings(NetworkMappingFabricSpecificSettings):
    """A2A Network Mapping fabric specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param primary_fabric_location: The primary fabric location.
    :type primary_fabric_location: str
    :param recovery_fabric_location: The recovery fabric location.
    :type recovery_fabric_location: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_fabric_location': {'key': 'primaryFabricLocation', 'type': 'str'},
        'recovery_fabric_location': {'key': 'recoveryFabricLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_fabric_location: Optional[str] = None,
        recovery_fabric_location: Optional[str] = None,
        **kwargs
    ):
        super(AzureToAzureNetworkMappingSettings, self).__init__(**kwargs)
        self.instance_type = 'AzureToAzure'  # type: str
        self.primary_fabric_location = primary_fabric_location
        self.recovery_fabric_location = recovery_fabric_location


class FabricSpecificUpdateNetworkMappingInput(msrest.serialization.Model):
    """Input details specific to fabrics during Network Mapping.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureToAzureUpdateNetworkMappingInput, VmmToAzureUpdateNetworkMappingInput, VmmToVmmUpdateNetworkMappingInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'AzureToAzure': 'AzureToAzureUpdateNetworkMappingInput', 'VmmToAzure': 'VmmToAzureUpdateNetworkMappingInput', 'VmmToVmm': 'VmmToVmmUpdateNetworkMappingInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FabricSpecificUpdateNetworkMappingInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class AzureToAzureUpdateNetworkMappingInput(FabricSpecificUpdateNetworkMappingInput):
    """Updates network mappings input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The instance type.Constant filled by server.
    :type instance_type: str
    :param primary_network_id: The primary azure vnet Id.
    :type primary_network_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_network_id': {'key': 'primaryNetworkId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_network_id: Optional[str] = None,
        **kwargs
    ):
        super(AzureToAzureUpdateNetworkMappingInput, self).__init__(**kwargs)
        self.instance_type = 'AzureToAzure'  # type: str
        self.primary_network_id = primary_network_id


class AzureToAzureVmSyncedConfigDetails(msrest.serialization.Model):
    """Azure to Azure VM synced configuration details.

    :param tags: A set of tags. The Azure VM tags.
    :type tags: dict[str, str]
    :param input_endpoints: The Azure VM input endpoints.
    :type input_endpoints: list[~azure.mgmt.recoveryservicessiterecovery.models.InputEndpoint]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'input_endpoints': {'key': 'inputEndpoints', 'type': '[InputEndpoint]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        input_endpoints: Optional[List["InputEndpoint"]] = None,
        **kwargs
    ):
        super(AzureToAzureVmSyncedConfigDetails, self).__init__(**kwargs)
        self.tags = tags
        self.input_endpoints = input_endpoints


class AzureVmDiskDetails(msrest.serialization.Model):
    """Disk details for E2A provider.

    :param vhd_type: VHD type.
    :type vhd_type: str
    :param vhd_id: The VHD id.
    :type vhd_id: str
    :param disk_id: The disk resource id.
    :type disk_id: str
    :param vhd_name: VHD name.
    :type vhd_name: str
    :param max_size_mb: Max side in MB.
    :type max_size_mb: str
    :param target_disk_location: Blob uri of the Azure disk.
    :type target_disk_location: str
    :param target_disk_name: The target Azure disk name.
    :type target_disk_name: str
    :param lun_id: Ordinal\LunId of the disk for the Azure VM.
    :type lun_id: str
    :param disk_encryption_set_id: The DiskEncryptionSet ARM ID.
    :type disk_encryption_set_id: str
    :param custom_target_disk_name: The custom target Azure disk name.
    :type custom_target_disk_name: str
    """

    _attribute_map = {
        'vhd_type': {'key': 'vhdType', 'type': 'str'},
        'vhd_id': {'key': 'vhdId', 'type': 'str'},
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'vhd_name': {'key': 'vhdName', 'type': 'str'},
        'max_size_mb': {'key': 'maxSizeMB', 'type': 'str'},
        'target_disk_location': {'key': 'targetDiskLocation', 'type': 'str'},
        'target_disk_name': {'key': 'targetDiskName', 'type': 'str'},
        'lun_id': {'key': 'lunId', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'custom_target_disk_name': {'key': 'customTargetDiskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vhd_type: Optional[str] = None,
        vhd_id: Optional[str] = None,
        disk_id: Optional[str] = None,
        vhd_name: Optional[str] = None,
        max_size_mb: Optional[str] = None,
        target_disk_location: Optional[str] = None,
        target_disk_name: Optional[str] = None,
        lun_id: Optional[str] = None,
        disk_encryption_set_id: Optional[str] = None,
        custom_target_disk_name: Optional[str] = None,
        **kwargs
    ):
        super(AzureVmDiskDetails, self).__init__(**kwargs)
        self.vhd_type = vhd_type
        self.vhd_id = vhd_id
        self.disk_id = disk_id
        self.vhd_name = vhd_name
        self.max_size_mb = max_size_mb
        self.target_disk_location = target_disk_location
        self.target_disk_name = target_disk_name
        self.lun_id = lun_id
        self.disk_encryption_set_id = disk_encryption_set_id
        self.custom_target_disk_name = custom_target_disk_name


class ComputeSizeErrorDetails(msrest.serialization.Model):
    """Represents the error used to indicate why the target compute size is not applicable.

    :param message: The error message.
    :type message: str
    :param severity: The severity of the error.
    :type severity: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        severity: Optional[str] = None,
        **kwargs
    ):
        super(ComputeSizeErrorDetails, self).__init__(**kwargs)
        self.message = message
        self.severity = severity


class ConfigurationSettings(msrest.serialization.Model):
    """Replication provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: HyperVVirtualMachineDetails, ReplicationGroupDetails, VMwareVirtualMachineDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'HyperVVirtualMachine': 'HyperVVirtualMachineDetails', 'ReplicationGroupDetails': 'ReplicationGroupDetails', 'VMwareVirtualMachine': 'VMwareVirtualMachineDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationSettings, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class ConfigureAlertRequest(msrest.serialization.Model):
    """Request to configure alerts for the system.

    :param properties: The properties of a configure alert request.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ConfigureAlertRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ConfigureAlertRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ConfigureAlertRequestProperties"] = None,
        **kwargs
    ):
        super(ConfigureAlertRequest, self).__init__(**kwargs)
        self.properties = properties


class ConfigureAlertRequestProperties(msrest.serialization.Model):
    """Properties of a configure alert request.

    :param send_to_owners: A value indicating whether to send email to subscription administrator.
    :type send_to_owners: str
    :param custom_email_addresses: The custom email address for sending emails.
    :type custom_email_addresses: list[str]
    :param locale: The locale for the email notification.
    :type locale: str
    """

    _attribute_map = {
        'send_to_owners': {'key': 'sendToOwners', 'type': 'str'},
        'custom_email_addresses': {'key': 'customEmailAddresses', 'type': '[str]'},
        'locale': {'key': 'locale', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        send_to_owners: Optional[str] = None,
        custom_email_addresses: Optional[List[str]] = None,
        locale: Optional[str] = None,
        **kwargs
    ):
        super(ConfigureAlertRequestProperties, self).__init__(**kwargs)
        self.send_to_owners = send_to_owners
        self.custom_email_addresses = custom_email_addresses
        self.locale = locale


class ConsistencyCheckTaskDetails(TaskTypeDetails):
    """This class contains monitoring details of all the inconsistent Protected Entities in Vmm.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param vm_details: The list of inconsistent Vm details.
    :type vm_details: list[~azure.mgmt.recoveryservicessiterecovery.models.InconsistentVmDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vm_details': {'key': 'vmDetails', 'type': '[InconsistentVmDetails]'},
    }

    def __init__(
        self,
        *,
        vm_details: Optional[List["InconsistentVmDetails"]] = None,
        **kwargs
    ):
        super(ConsistencyCheckTaskDetails, self).__init__(**kwargs)
        self.instance_type = 'ConsistencyCheckTaskDetails'  # type: str
        self.vm_details = vm_details


class CreateNetworkMappingInput(msrest.serialization.Model):
    """Create network mappings input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Input properties for creating network mapping.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateNetworkMappingInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CreateNetworkMappingInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "CreateNetworkMappingInputProperties",
        **kwargs
    ):
        super(CreateNetworkMappingInput, self).__init__(**kwargs)
        self.properties = properties


class CreateNetworkMappingInputProperties(msrest.serialization.Model):
    """Common input details for network mapping operation.

    All required parameters must be populated in order to send to Azure.

    :param recovery_fabric_name: Recovery fabric Name.
    :type recovery_fabric_name: str
    :param recovery_network_id: Required. Recovery network Id.
    :type recovery_network_id: str
    :param fabric_specific_details: Fabric specific input properties.
    :type fabric_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificCreateNetworkMappingInput
    """

    _validation = {
        'recovery_network_id': {'required': True},
    }

    _attribute_map = {
        'recovery_fabric_name': {'key': 'recoveryFabricName', 'type': 'str'},
        'recovery_network_id': {'key': 'recoveryNetworkId', 'type': 'str'},
        'fabric_specific_details': {'key': 'fabricSpecificDetails', 'type': 'FabricSpecificCreateNetworkMappingInput'},
    }

    def __init__(
        self,
        *,
        recovery_network_id: str,
        recovery_fabric_name: Optional[str] = None,
        fabric_specific_details: Optional["FabricSpecificCreateNetworkMappingInput"] = None,
        **kwargs
    ):
        super(CreateNetworkMappingInputProperties, self).__init__(**kwargs)
        self.recovery_fabric_name = recovery_fabric_name
        self.recovery_network_id = recovery_network_id
        self.fabric_specific_details = fabric_specific_details


class CreatePolicyInput(msrest.serialization.Model):
    """Protection Policy input.

    :param properties: Policy creation properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.CreatePolicyInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CreatePolicyInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["CreatePolicyInputProperties"] = None,
        **kwargs
    ):
        super(CreatePolicyInput, self).__init__(**kwargs)
        self.properties = properties


class CreatePolicyInputProperties(msrest.serialization.Model):
    """Policy creation properties.

    :param provider_specific_input: The ReplicationProviderSettings.
    :type provider_specific_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProviderSpecificInput
    """

    _attribute_map = {
        'provider_specific_input': {'key': 'providerSpecificInput', 'type': 'PolicyProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_input: Optional["PolicyProviderSpecificInput"] = None,
        **kwargs
    ):
        super(CreatePolicyInputProperties, self).__init__(**kwargs)
        self.provider_specific_input = provider_specific_input


class CreateProtectionContainerInput(msrest.serialization.Model):
    """Create protection container input.

    :param properties: Create protection container input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionContainerInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CreateProtectionContainerInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["CreateProtectionContainerInputProperties"] = None,
        **kwargs
    ):
        super(CreateProtectionContainerInput, self).__init__(**kwargs)
        self.properties = properties


class CreateProtectionContainerInputProperties(msrest.serialization.Model):
    """Create protection container input properties.

    :param provider_specific_input: Provider specific inputs for container creation.
    :type provider_specific_input:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderSpecificContainerCreationInput]
    """

    _attribute_map = {
        'provider_specific_input': {'key': 'providerSpecificInput', 'type': '[ReplicationProviderSpecificContainerCreationInput]'},
    }

    def __init__(
        self,
        *,
        provider_specific_input: Optional[List["ReplicationProviderSpecificContainerCreationInput"]] = None,
        **kwargs
    ):
        super(CreateProtectionContainerInputProperties, self).__init__(**kwargs)
        self.provider_specific_input = provider_specific_input


class CreateProtectionContainerMappingInput(msrest.serialization.Model):
    """Configure pairing input.

    :param properties: Configure protection input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionContainerMappingInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CreateProtectionContainerMappingInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["CreateProtectionContainerMappingInputProperties"] = None,
        **kwargs
    ):
        super(CreateProtectionContainerMappingInput, self).__init__(**kwargs)
        self.properties = properties


class CreateProtectionContainerMappingInputProperties(msrest.serialization.Model):
    """Configure pairing input properties.

    :param target_protection_container_id: The target unique protection container name.
    :type target_protection_container_id: str
    :param policy_id: Applicable policy.
    :type policy_id: str
    :param provider_specific_input: Provider specific input for pairing.
    :type provider_specific_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderSpecificContainerMappingInput
    """

    _attribute_map = {
        'target_protection_container_id': {'key': 'targetProtectionContainerId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'provider_specific_input': {'key': 'providerSpecificInput', 'type': 'ReplicationProviderSpecificContainerMappingInput'},
    }

    def __init__(
        self,
        *,
        target_protection_container_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        provider_specific_input: Optional["ReplicationProviderSpecificContainerMappingInput"] = None,
        **kwargs
    ):
        super(CreateProtectionContainerMappingInputProperties, self).__init__(**kwargs)
        self.target_protection_container_id = target_protection_container_id
        self.policy_id = policy_id
        self.provider_specific_input = provider_specific_input


class CreateProtectionIntentInput(msrest.serialization.Model):
    """Create protection intent input.

    :param properties: Create protection intent input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionIntentProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CreateProtectionIntentProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["CreateProtectionIntentProperties"] = None,
        **kwargs
    ):
        super(CreateProtectionIntentInput, self).__init__(**kwargs)
        self.properties = properties


class CreateProtectionIntentProperties(msrest.serialization.Model):
    """Create protection intent input properties.

    :param provider_specific_details: The ReplicationProviderInput. For A2A provider, it will be
     A2ACreateProtectionIntentInput object.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateProtectionIntentProviderSpecificDetails
    """

    _attribute_map = {
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'CreateProtectionIntentProviderSpecificDetails'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: Optional["CreateProtectionIntentProviderSpecificDetails"] = None,
        **kwargs
    ):
        super(CreateProtectionIntentProperties, self).__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class CreateRecoveryPlanInput(msrest.serialization.Model):
    """Create recovery plan input class.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Recovery plan creation properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.CreateRecoveryPlanInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CreateRecoveryPlanInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "CreateRecoveryPlanInputProperties",
        **kwargs
    ):
        super(CreateRecoveryPlanInput, self).__init__(**kwargs)
        self.properties = properties


class CreateRecoveryPlanInputProperties(msrest.serialization.Model):
    """Recovery plan creation properties.

    All required parameters must be populated in order to send to Azure.

    :param primary_fabric_id: Required. The primary fabric Id.
    :type primary_fabric_id: str
    :param recovery_fabric_id: Required. The recovery fabric Id.
    :type recovery_fabric_id: str
    :param failover_deployment_model: The failover deployment model. Possible values include:
     "NotApplicable", "Classic", "ResourceManager".
    :type failover_deployment_model: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.FailoverDeploymentModel
    :param groups: Required. The recovery plan groups.
    :type groups: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroup]
    :param provider_specific_input: The provider specific input.
    :type provider_specific_input:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificInput]
    """

    _validation = {
        'primary_fabric_id': {'required': True},
        'recovery_fabric_id': {'required': True},
        'groups': {'required': True},
    }

    _attribute_map = {
        'primary_fabric_id': {'key': 'primaryFabricId', 'type': 'str'},
        'recovery_fabric_id': {'key': 'recoveryFabricId', 'type': 'str'},
        'failover_deployment_model': {'key': 'failoverDeploymentModel', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[RecoveryPlanGroup]'},
        'provider_specific_input': {'key': 'providerSpecificInput', 'type': '[RecoveryPlanProviderSpecificInput]'},
    }

    def __init__(
        self,
        *,
        primary_fabric_id: str,
        recovery_fabric_id: str,
        groups: List["RecoveryPlanGroup"],
        failover_deployment_model: Optional[Union[str, "FailoverDeploymentModel"]] = None,
        provider_specific_input: Optional[List["RecoveryPlanProviderSpecificInput"]] = None,
        **kwargs
    ):
        super(CreateRecoveryPlanInputProperties, self).__init__(**kwargs)
        self.primary_fabric_id = primary_fabric_id
        self.recovery_fabric_id = recovery_fabric_id
        self.failover_deployment_model = failover_deployment_model
        self.groups = groups
        self.provider_specific_input = provider_specific_input


class CurrentJobDetails(msrest.serialization.Model):
    """Current job details of the migration item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_name: The job name.
    :vartype job_name: str
    :ivar job_id: The ARM Id of the job being executed.
    :vartype job_id: str
    :ivar start_time: The start time of the job.
    :vartype start_time: ~datetime.datetime
    """

    _validation = {
        'job_name': {'readonly': True},
        'job_id': {'readonly': True},
        'start_time': {'readonly': True},
    }

    _attribute_map = {
        'job_name': {'key': 'jobName', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CurrentJobDetails, self).__init__(**kwargs)
        self.job_name = None
        self.job_id = None
        self.start_time = None


class CurrentScenarioDetails(msrest.serialization.Model):
    """Current scenario details of the protected entity.

    :param scenario_name: Scenario name.
    :type scenario_name: str
    :param job_id: ARM Id of the job being executed.
    :type job_id: str
    :param start_time: Start time of the workflow.
    :type start_time: ~datetime.datetime
    """

    _attribute_map = {
        'scenario_name': {'key': 'scenarioName', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        scenario_name: Optional[str] = None,
        job_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(CurrentScenarioDetails, self).__init__(**kwargs)
        self.scenario_name = scenario_name
        self.job_id = job_id
        self.start_time = start_time


class DataStore(msrest.serialization.Model):
    """The datastore details of the MT.

    :param symbolic_name: The symbolic name of data store.
    :type symbolic_name: str
    :param uuid: The uuid of data store.
    :type uuid: str
    :param capacity: The capacity of data store in GBs.
    :type capacity: str
    :param free_space: The free space of data store in GBs.
    :type free_space: str
    :param type: The type of data store.
    :type type: str
    """

    _attribute_map = {
        'symbolic_name': {'key': 'symbolicName', 'type': 'str'},
        'uuid': {'key': 'uuid', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'str'},
        'free_space': {'key': 'freeSpace', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        symbolic_name: Optional[str] = None,
        uuid: Optional[str] = None,
        capacity: Optional[str] = None,
        free_space: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(DataStore, self).__init__(**kwargs)
        self.symbolic_name = symbolic_name
        self.uuid = uuid
        self.capacity = capacity
        self.free_space = free_space
        self.type = type


class DisableProtectionInput(msrest.serialization.Model):
    """Disable protection input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Disable protection input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DisableProtectionInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DisableProtectionInputProperties",
        **kwargs
    ):
        super(DisableProtectionInput, self).__init__(**kwargs)
        self.properties = properties


class DisableProtectionInputProperties(msrest.serialization.Model):
    """Disable protection input properties.

    :param disable_protection_reason: Disable protection reason. It can have values
     NotSpecified/MigrationComplete. Possible values include: "NotSpecified", "MigrationComplete".
    :type disable_protection_reason: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionReason
    :param replication_provider_input: Replication provider specific input.
    :type replication_provider_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionProviderSpecificInput
    """

    _attribute_map = {
        'disable_protection_reason': {'key': 'disableProtectionReason', 'type': 'str'},
        'replication_provider_input': {'key': 'replicationProviderInput', 'type': 'DisableProtectionProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        disable_protection_reason: Optional[Union[str, "DisableProtectionReason"]] = None,
        replication_provider_input: Optional["DisableProtectionProviderSpecificInput"] = None,
        **kwargs
    ):
        super(DisableProtectionInputProperties, self).__init__(**kwargs)
        self.disable_protection_reason = disable_protection_reason
        self.replication_provider_input = replication_provider_input


class DisableProtectionProviderSpecificInput(msrest.serialization.Model):
    """Disable protection provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: InMageDisableProtectionProviderSpecificInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'InMage': 'InMageDisableProtectionProviderSpecificInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DisableProtectionProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class DiscoverProtectableItemRequest(msrest.serialization.Model):
    """Request to add a physical machine as a protectable item in a container.

    :param properties: The properties of a discover protectable item request.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiscoverProtectableItemRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DiscoverProtectableItemRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DiscoverProtectableItemRequestProperties"] = None,
        **kwargs
    ):
        super(DiscoverProtectableItemRequest, self).__init__(**kwargs)
        self.properties = properties


class DiscoverProtectableItemRequestProperties(msrest.serialization.Model):
    """Discover protectable item properties.

    :param friendly_name: The friendly name of the physical machine.
    :type friendly_name: str
    :param ip_address: The IP address of the physical machine to be discovered.
    :type ip_address: str
    :param os_type: The OS type on the physical machine.
    :type os_type: str
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        ip_address: Optional[str] = None,
        os_type: Optional[str] = None,
        **kwargs
    ):
        super(DiscoverProtectableItemRequestProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.ip_address = ip_address
        self.os_type = os_type


class DiskDetails(msrest.serialization.Model):
    """Onprem disk details data.

    :param max_size_mb: The hard disk max size in MB.
    :type max_size_mb: long
    :param vhd_type: The type of the volume.
    :type vhd_type: str
    :param vhd_id: The VHD Id.
    :type vhd_id: str
    :param vhd_name: The VHD name.
    :type vhd_name: str
    """

    _attribute_map = {
        'max_size_mb': {'key': 'maxSizeMB', 'type': 'long'},
        'vhd_type': {'key': 'vhdType', 'type': 'str'},
        'vhd_id': {'key': 'vhdId', 'type': 'str'},
        'vhd_name': {'key': 'vhdName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        max_size_mb: Optional[int] = None,
        vhd_type: Optional[str] = None,
        vhd_id: Optional[str] = None,
        vhd_name: Optional[str] = None,
        **kwargs
    ):
        super(DiskDetails, self).__init__(**kwargs)
        self.max_size_mb = max_size_mb
        self.vhd_type = vhd_type
        self.vhd_id = vhd_id
        self.vhd_name = vhd_name


class DiskEncryptionInfo(msrest.serialization.Model):
    """Recovery disk encryption info (BEK and KEK).

    :param disk_encryption_key_info: The recovery KeyVault reference for secret.
    :type disk_encryption_key_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskEncryptionKeyInfo
    :param key_encryption_key_info: The recovery KeyVault reference for key.
    :type key_encryption_key_info:
     ~azure.mgmt.recoveryservicessiterecovery.models.KeyEncryptionKeyInfo
    """

    _attribute_map = {
        'disk_encryption_key_info': {'key': 'diskEncryptionKeyInfo', 'type': 'DiskEncryptionKeyInfo'},
        'key_encryption_key_info': {'key': 'keyEncryptionKeyInfo', 'type': 'KeyEncryptionKeyInfo'},
    }

    def __init__(
        self,
        *,
        disk_encryption_key_info: Optional["DiskEncryptionKeyInfo"] = None,
        key_encryption_key_info: Optional["KeyEncryptionKeyInfo"] = None,
        **kwargs
    ):
        super(DiskEncryptionInfo, self).__init__(**kwargs)
        self.disk_encryption_key_info = disk_encryption_key_info
        self.key_encryption_key_info = key_encryption_key_info


class DiskEncryptionKeyInfo(msrest.serialization.Model):
    """Disk Encryption Key Information (BitLocker Encryption Key (BEK) on Windows).

    :param secret_identifier: The secret url / identifier.
    :type secret_identifier: str
    :param key_vault_resource_arm_id: The KeyVault resource ARM id for secret.
    :type key_vault_resource_arm_id: str
    """

    _attribute_map = {
        'secret_identifier': {'key': 'secretIdentifier', 'type': 'str'},
        'key_vault_resource_arm_id': {'key': 'keyVaultResourceArmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        secret_identifier: Optional[str] = None,
        key_vault_resource_arm_id: Optional[str] = None,
        **kwargs
    ):
        super(DiskEncryptionKeyInfo, self).__init__(**kwargs)
        self.secret_identifier = secret_identifier
        self.key_vault_resource_arm_id = key_vault_resource_arm_id


class DiskVolumeDetails(msrest.serialization.Model):
    """Volume details.

    :param label: The volume label.
    :type label: str
    :param name: The volume name.
    :type name: str
    """

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DiskVolumeDetails, self).__init__(**kwargs)
        self.label = label
        self.name = name


class Display(msrest.serialization.Model):
    """Contains the localized display information for this particular operation / action. These value will be used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for the event service; and (3) audit history / records for management operations.

    :param provider: The provider. The localized friendly form of the resource provider name - it
     is expected to also include the publisher/company responsible. It should use Title Casing and
     begin with "Microsoft" for 1st party services. e.g. "Microsoft Monitoring Insights" or
     "Microsoft Compute.".
    :type provider: str
    :param resource: The resource. The localized friendly form of the resource related to this
     action/operation - it should match the public documentation for the resource provider. It
     should use Title Casing. This value should be unique for a particular URL type (e.g. nested
     types should *not* reuse their parent's display.resource field). e.g. "Virtual Machines" or
     "Scheduler Job Collections", or "Virtual Machine VM Sizes" or "Scheduler Jobs".
    :type resource: str
    :param operation: The operation. The localized friendly name for the operation, as it should be
     shown to the user. It should be concise (to fit in drop downs) but clear (i.e.
     self-documenting). It should use Title Casing. Prescriptive guidance: Read Create or Update
     Delete 'ActionName'.
    :type operation: str
    :param description: The description. The localized friendly description for the operation, as
     it should be shown to the user. It should be thorough, yet concise - it will be used in tool
     tips and detailed views. Prescriptive guidance for namespaces: Read any 'display.provider'
     resource Create or Update any 'display.provider' resource Delete any 'display.provider'
     resource Perform any other action on any 'display.provider' resource Prescriptive guidance for
     namespaces: Read any 'display.resource' Create or Update any 'display.resource' Delete any
     'display.resource' 'ActionName' any 'display.resources'.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(Display, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class DraDetails(msrest.serialization.Model):
    """DRA details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The DRA Id.
    :vartype id: str
    :ivar name: The DRA name.
    :vartype name: str
    :ivar bios_id: The DRA Bios Id.
    :vartype bios_id: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the DRA.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health. Possible values include: "None", "Normal", "Warning", "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar forward_protected_item_count: The count of protected items which are protected in forward
     direction.
    :vartype forward_protected_item_count: int
    :ivar reverse_protected_item_count: The count of protected items which are protected in reverse
     direction.
    :vartype reverse_protected_item_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'bios_id': {'readonly': True},
        'version': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'health': {'readonly': True},
        'health_errors': {'readonly': True},
        'forward_protected_item_count': {'readonly': True},
        'reverse_protected_item_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'health': {'key': 'health', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
        'forward_protected_item_count': {'key': 'forwardProtectedItemCount', 'type': 'int'},
        'reverse_protected_item_count': {'key': 'reverseProtectedItemCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DraDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None
        self.forward_protected_item_count = None
        self.reverse_protected_item_count = None


class EnableMigrationInput(msrest.serialization.Model):
    """Enable migration input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Enable migration input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.EnableMigrationInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'EnableMigrationInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "EnableMigrationInputProperties",
        **kwargs
    ):
        super(EnableMigrationInput, self).__init__(**kwargs)
        self.properties = properties


class EnableMigrationInputProperties(msrest.serialization.Model):
    """Enable migration input properties.

    All required parameters must be populated in order to send to Azure.

    :param policy_id: Required. The policy Id.
    :type policy_id: str
    :param provider_specific_details: Required. The provider specific details.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EnableMigrationProviderSpecificInput
    """

    _validation = {
        'policy_id': {'required': True},
        'provider_specific_details': {'required': True},
    }

    _attribute_map = {
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'EnableMigrationProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        policy_id: str,
        provider_specific_details: "EnableMigrationProviderSpecificInput",
        **kwargs
    ):
        super(EnableMigrationInputProperties, self).__init__(**kwargs)
        self.policy_id = policy_id
        self.provider_specific_details = provider_specific_details


class EnableMigrationProviderSpecificInput(msrest.serialization.Model):
    """Enable migration provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VMwareCbtEnableMigrationInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'VMwareCbt': 'VMwareCbtEnableMigrationInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnableMigrationProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class EnableProtectionInput(msrest.serialization.Model):
    """Enable protection input.

    :param properties: Enable protection input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'EnableProtectionInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["EnableProtectionInputProperties"] = None,
        **kwargs
    ):
        super(EnableProtectionInput, self).__init__(**kwargs)
        self.properties = properties


class EnableProtectionInputProperties(msrest.serialization.Model):
    """Enable protection input properties.

    :param policy_id: The Policy Id.
    :type policy_id: str
    :param protectable_item_id: The protectable item Id.
    :type protectable_item_id: str
    :param provider_specific_details: The ReplicationProviderInput. For HyperVReplicaAzure
     provider, it will be AzureEnableProtectionInput object. For San provider, it will be
     SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionProviderSpecificInput
    """

    _attribute_map = {
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'protectable_item_id': {'key': 'protectableItemId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'EnableProtectionProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        policy_id: Optional[str] = None,
        protectable_item_id: Optional[str] = None,
        provider_specific_details: Optional["EnableProtectionProviderSpecificInput"] = None,
        **kwargs
    ):
        super(EnableProtectionInputProperties, self).__init__(**kwargs)
        self.policy_id = policy_id
        self.protectable_item_id = protectable_item_id
        self.provider_specific_details = provider_specific_details


class EncryptionDetails(msrest.serialization.Model):
    """Encryption details for the fabric.

    :param kek_state: The key encryption key state for the Vmm.
    :type kek_state: str
    :param kek_cert_thumbprint: The key encryption key certificate thumbprint.
    :type kek_cert_thumbprint: str
    :param kek_cert_expiry_date: The key encryption key certificate expiry date.
    :type kek_cert_expiry_date: ~datetime.datetime
    """

    _attribute_map = {
        'kek_state': {'key': 'kekState', 'type': 'str'},
        'kek_cert_thumbprint': {'key': 'kekCertThumbprint', 'type': 'str'},
        'kek_cert_expiry_date': {'key': 'kekCertExpiryDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        kek_state: Optional[str] = None,
        kek_cert_thumbprint: Optional[str] = None,
        kek_cert_expiry_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(EncryptionDetails, self).__init__(**kwargs)
        self.kek_state = kek_state
        self.kek_cert_thumbprint = kek_cert_thumbprint
        self.kek_cert_expiry_date = kek_cert_expiry_date


class Event(Resource):
    """Implements the Event class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: Event related data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.EventProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'EventProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["EventProperties"] = None,
        **kwargs
    ):
        super(Event, self).__init__(location=location, **kwargs)
        self.properties = properties


class EventCollection(msrest.serialization.Model):
    """Collection of fabric details.

    :param value: The list of events.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.Event]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Event]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Event"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EventCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventProperties(msrest.serialization.Model):
    """The properties of a monitoring event.

    :param event_code: The Id of the monitoring event.
    :type event_code: str
    :param description: The event name.
    :type description: str
    :param event_type: The type of the event. for example: VM Health, Server Health, Job Failure
     etc.
    :type event_type: str
    :param affected_object_friendly_name: The friendly name of the source of the event on which it
     is raised (for example, VM, VMM etc).
    :type affected_object_friendly_name: str
    :param affected_object_correlation_id: The affected object correlationId for the event.
    :type affected_object_correlation_id: str
    :param severity: The severity of the event.
    :type severity: str
    :param time_of_occurrence: The time of occurrence of the event.
    :type time_of_occurrence: ~datetime.datetime
    :param fabric_id: The ARM ID of the fabric.
    :type fabric_id: str
    :param provider_specific_details: The provider specific settings.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EventProviderSpecificDetails
    :param event_specific_details: The event specific settings.
    :type event_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EventSpecificDetails
    :param health_errors: The list of errors / warnings capturing details associated with the
     issue(s).
    :type health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _attribute_map = {
        'event_code': {'key': 'eventCode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'affected_object_friendly_name': {'key': 'affectedObjectFriendlyName', 'type': 'str'},
        'affected_object_correlation_id': {'key': 'affectedObjectCorrelationId', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'time_of_occurrence': {'key': 'timeOfOccurrence', 'type': 'iso-8601'},
        'fabric_id': {'key': 'fabricId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'EventProviderSpecificDetails'},
        'event_specific_details': {'key': 'eventSpecificDetails', 'type': 'EventSpecificDetails'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
    }

    def __init__(
        self,
        *,
        event_code: Optional[str] = None,
        description: Optional[str] = None,
        event_type: Optional[str] = None,
        affected_object_friendly_name: Optional[str] = None,
        affected_object_correlation_id: Optional[str] = None,
        severity: Optional[str] = None,
        time_of_occurrence: Optional[datetime.datetime] = None,
        fabric_id: Optional[str] = None,
        provider_specific_details: Optional["EventProviderSpecificDetails"] = None,
        event_specific_details: Optional["EventSpecificDetails"] = None,
        health_errors: Optional[List["HealthError"]] = None,
        **kwargs
    ):
        super(EventProperties, self).__init__(**kwargs)
        self.event_code = event_code
        self.description = description
        self.event_type = event_type
        self.affected_object_friendly_name = affected_object_friendly_name
        self.affected_object_correlation_id = affected_object_correlation_id
        self.severity = severity
        self.time_of_occurrence = time_of_occurrence
        self.fabric_id = fabric_id
        self.provider_specific_details = provider_specific_details
        self.event_specific_details = event_specific_details
        self.health_errors = health_errors


class EventQueryParameter(msrest.serialization.Model):
    """Implements the event query parameter.

    :param event_code: The source id of the events to be queried.
    :type event_code: str
    :param severity: The severity of the events to be queried.
    :type severity: str
    :param event_type: The type of the events to be queried.
    :type event_type: str
    :param fabric_name: The affected object server id of the events to be queried.
    :type fabric_name: str
    :param affected_object_friendly_name: The affected object name of the events to be queried.
    :type affected_object_friendly_name: str
    :param affected_object_correlation_id: The affected object correlationId for the events to be
     queried.
    :type affected_object_correlation_id: str
    :param start_time: The start time of the time range within which the events are to be queried.
    :type start_time: ~datetime.datetime
    :param end_time: The end time of the time range within which the events are to be queried.
    :type end_time: ~datetime.datetime
    """

    _attribute_map = {
        'event_code': {'key': 'eventCode', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'affected_object_friendly_name': {'key': 'affectedObjectFriendlyName', 'type': 'str'},
        'affected_object_correlation_id': {'key': 'affectedObjectCorrelationId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        event_code: Optional[str] = None,
        severity: Optional[str] = None,
        event_type: Optional[str] = None,
        fabric_name: Optional[str] = None,
        affected_object_friendly_name: Optional[str] = None,
        affected_object_correlation_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(EventQueryParameter, self).__init__(**kwargs)
        self.event_code = event_code
        self.severity = severity
        self.event_type = event_type
        self.fabric_name = fabric_name
        self.affected_object_friendly_name = affected_object_friendly_name
        self.affected_object_correlation_id = affected_object_correlation_id
        self.start_time = start_time
        self.end_time = end_time


class EventSpecificDetails(msrest.serialization.Model):
    """Model class for event specific details for an event.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JobStatusEventDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'JobStatus': 'JobStatusEventDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSpecificDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class ProtectionProfileCustomDetails(msrest.serialization.Model):
    """Protection Profile custom input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExistingProtectionProfile, NewProtectionProfile.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    _subtype_map = {
        'resource_type': {'Existing': 'ExistingProtectionProfile', 'New': 'NewProtectionProfile'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProtectionProfileCustomDetails, self).__init__(**kwargs)
        self.resource_type = None  # type: Optional[str]


class ExistingProtectionProfile(ProtectionProfileCustomDetails):
    """Existing storage account input.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    :param protection_profile_id: Required. The protection profile Arm Id. Throw error, if resource
     does not exists.
    :type protection_profile_id: str
    """

    _validation = {
        'resource_type': {'required': True},
        'protection_profile_id': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'protection_profile_id': {'key': 'protectionProfileId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protection_profile_id: str,
        **kwargs
    ):
        super(ExistingProtectionProfile, self).__init__(**kwargs)
        self.resource_type = 'Existing'  # type: str
        self.protection_profile_id = protection_profile_id


class RecoveryAvailabilitySetCustomDetails(msrest.serialization.Model):
    """Recovery Availability Set custom input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExistingRecoveryAvailabilitySet.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    _subtype_map = {
        'resource_type': {'Existing': 'ExistingRecoveryAvailabilitySet'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryAvailabilitySetCustomDetails, self).__init__(**kwargs)
        self.resource_type = None  # type: Optional[str]


class ExistingRecoveryAvailabilitySet(RecoveryAvailabilitySetCustomDetails):
    """Existing recovery availability set input.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    :param recovery_availability_set_id: The recovery availability set Id. Will throw error, if
     resource does not exist.
    :type recovery_availability_set_id: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'recovery_availability_set_id': {'key': 'recoveryAvailabilitySetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_availability_set_id: Optional[str] = None,
        **kwargs
    ):
        super(ExistingRecoveryAvailabilitySet, self).__init__(**kwargs)
        self.resource_type = 'Existing'  # type: str
        self.recovery_availability_set_id = recovery_availability_set_id


class RecoveryProximityPlacementGroupCustomDetails(msrest.serialization.Model):
    """Recovery Proximity placement group custom input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExistingRecoveryProximityPlacementGroup.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    _subtype_map = {
        'resource_type': {'Existing': 'ExistingRecoveryProximityPlacementGroup'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryProximityPlacementGroupCustomDetails, self).__init__(**kwargs)
        self.resource_type = None  # type: Optional[str]


class ExistingRecoveryProximityPlacementGroup(RecoveryProximityPlacementGroupCustomDetails):
    """Existing recovery proximity placement group input.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    :param recovery_proximity_placement_group_id: The recovery proximity placement group Id. Will
     throw error, if resource does not exist.
    :type recovery_proximity_placement_group_id: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'recovery_proximity_placement_group_id': {'key': 'recoveryProximityPlacementGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_proximity_placement_group_id: Optional[str] = None,
        **kwargs
    ):
        super(ExistingRecoveryProximityPlacementGroup, self).__init__(**kwargs)
        self.resource_type = 'Existing'  # type: str
        self.recovery_proximity_placement_group_id = recovery_proximity_placement_group_id


class RecoveryResourceGroupCustomDetails(msrest.serialization.Model):
    """Recovery Resource Group custom input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExistingRecoveryResourceGroup.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    _subtype_map = {
        'resource_type': {'Existing': 'ExistingRecoveryResourceGroup'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryResourceGroupCustomDetails, self).__init__(**kwargs)
        self.resource_type = None  # type: Optional[str]


class ExistingRecoveryResourceGroup(RecoveryResourceGroupCustomDetails):
    """Existing recovery resource group input.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    :param recovery_resource_group_id: The recovery resource group Id. Valid for V2 scenarios.
    :type recovery_resource_group_id: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'recovery_resource_group_id': {'key': 'recoveryResourceGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_resource_group_id: Optional[str] = None,
        **kwargs
    ):
        super(ExistingRecoveryResourceGroup, self).__init__(**kwargs)
        self.resource_type = 'Existing'  # type: str
        self.recovery_resource_group_id = recovery_resource_group_id


class RecoveryVirtualNetworkCustomDetails(msrest.serialization.Model):
    """Recovery Virtual network custom input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExistingRecoveryVirtualNetwork, NewRecoveryVirtualNetwork.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    _subtype_map = {
        'resource_type': {'Existing': 'ExistingRecoveryVirtualNetwork', 'New': 'NewRecoveryVirtualNetwork'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryVirtualNetworkCustomDetails, self).__init__(**kwargs)
        self.resource_type = None  # type: Optional[str]


class ExistingRecoveryVirtualNetwork(RecoveryVirtualNetworkCustomDetails):
    """Existing recovery virtual network input.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    :param recovery_virtual_network_id: Required. The recovery virtual network Id. Will throw
     error, if resource does not exist.
    :type recovery_virtual_network_id: str
    :param recovery_subnet_name: The recovery subnet name.
    :type recovery_subnet_name: str
    """

    _validation = {
        'resource_type': {'required': True},
        'recovery_virtual_network_id': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'recovery_virtual_network_id': {'key': 'recoveryVirtualNetworkId', 'type': 'str'},
        'recovery_subnet_name': {'key': 'recoverySubnetName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_virtual_network_id: str,
        recovery_subnet_name: Optional[str] = None,
        **kwargs
    ):
        super(ExistingRecoveryVirtualNetwork, self).__init__(**kwargs)
        self.resource_type = 'Existing'  # type: str
        self.recovery_virtual_network_id = recovery_virtual_network_id
        self.recovery_subnet_name = recovery_subnet_name


class StorageAccountCustomDetails(msrest.serialization.Model):
    """Storage account custom input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ExistingStorageAccount.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    _subtype_map = {
        'resource_type': {'Existing': 'ExistingStorageAccount'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountCustomDetails, self).__init__(**kwargs)
        self.resource_type = None  # type: Optional[str]


class ExistingStorageAccount(StorageAccountCustomDetails):
    """Existing storage account input.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    :param azure_storage_account_id: Required. The storage account Arm Id. Throw error, if resource
     does not exists.
    :type azure_storage_account_id: str
    """

    _validation = {
        'resource_type': {'required': True},
        'azure_storage_account_id': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'azure_storage_account_id': {'key': 'azureStorageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_storage_account_id: str,
        **kwargs
    ):
        super(ExistingStorageAccount, self).__init__(**kwargs)
        self.resource_type = 'Existing'  # type: str
        self.azure_storage_account_id = azure_storage_account_id


class ExportJobDetails(JobDetails):
    """This class represents details for export jobs workflow.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of job details (see JobDetailsTypes enum for
     possible values).Constant filled by server.
    :type instance_type: str
    :param affected_object_details: The affected object properties like source server, source
     cloud, target server, target cloud etc. based on the workflow object details.
    :type affected_object_details: dict[str, str]
    :param blob_uri: BlobUri of the exported jobs.
    :type blob_uri: str
    :param sas_token: The sas token to access blob.
    :type sas_token: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'affected_object_details': {'key': 'affectedObjectDetails', 'type': '{str}'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'sas_token': {'key': 'sasToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        affected_object_details: Optional[Dict[str, str]] = None,
        blob_uri: Optional[str] = None,
        sas_token: Optional[str] = None,
        **kwargs
    ):
        super(ExportJobDetails, self).__init__(affected_object_details=affected_object_details, **kwargs)
        self.instance_type = 'ExportJobDetails'  # type: str
        self.blob_uri = blob_uri
        self.sas_token = sas_token


class Fabric(Resource):
    """Fabric definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: Fabric related data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.FabricProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'FabricProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["FabricProperties"] = None,
        **kwargs
    ):
        super(Fabric, self).__init__(location=location, **kwargs)
        self.properties = properties


class FabricCollection(msrest.serialization.Model):
    """Collection of fabric details.

    :param value: The fabric details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.Fabric]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Fabric]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Fabric"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(FabricCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FabricCreationInput(msrest.serialization.Model):
    """Site details provided during the time of site creation.

    :param properties: Fabric creation input.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.FabricCreationInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'FabricCreationInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["FabricCreationInputProperties"] = None,
        **kwargs
    ):
        super(FabricCreationInput, self).__init__(**kwargs)
        self.properties = properties


class FabricCreationInputProperties(msrest.serialization.Model):
    """Properties of site details provided during the time of site creation.

    :param custom_details: Fabric provider specific creation input.
    :type custom_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificCreationInput
    """

    _attribute_map = {
        'custom_details': {'key': 'customDetails', 'type': 'FabricSpecificCreationInput'},
    }

    def __init__(
        self,
        *,
        custom_details: Optional["FabricSpecificCreationInput"] = None,
        **kwargs
    ):
        super(FabricCreationInputProperties, self).__init__(**kwargs)
        self.custom_details = custom_details


class FabricProperties(msrest.serialization.Model):
    """Fabric properties.

    :param friendly_name: Friendly name of the fabric.
    :type friendly_name: str
    :param encryption_details: Encryption details for the fabric.
    :type encryption_details: ~azure.mgmt.recoveryservicessiterecovery.models.EncryptionDetails
    :param rollover_encryption_details: Rollover encryption details for the fabric.
    :type rollover_encryption_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.EncryptionDetails
    :param internal_identifier: Dra Registration Id.
    :type internal_identifier: str
    :param bcdr_state: BCDR state of the fabric.
    :type bcdr_state: str
    :param custom_details: Fabric specific settings.
    :type custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificDetails
    :param health_error_details: Fabric health error details.
    :type health_error_details: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param health: Health of fabric.
    :type health: str
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'encryption_details': {'key': 'encryptionDetails', 'type': 'EncryptionDetails'},
        'rollover_encryption_details': {'key': 'rolloverEncryptionDetails', 'type': 'EncryptionDetails'},
        'internal_identifier': {'key': 'internalIdentifier', 'type': 'str'},
        'bcdr_state': {'key': 'bcdrState', 'type': 'str'},
        'custom_details': {'key': 'customDetails', 'type': 'FabricSpecificDetails'},
        'health_error_details': {'key': 'healthErrorDetails', 'type': '[HealthError]'},
        'health': {'key': 'health', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        encryption_details: Optional["EncryptionDetails"] = None,
        rollover_encryption_details: Optional["EncryptionDetails"] = None,
        internal_identifier: Optional[str] = None,
        bcdr_state: Optional[str] = None,
        custom_details: Optional["FabricSpecificDetails"] = None,
        health_error_details: Optional[List["HealthError"]] = None,
        health: Optional[str] = None,
        **kwargs
    ):
        super(FabricProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.encryption_details = encryption_details
        self.rollover_encryption_details = rollover_encryption_details
        self.internal_identifier = internal_identifier
        self.bcdr_state = bcdr_state
        self.custom_details = custom_details
        self.health_error_details = health_error_details
        self.health = health


class FabricQueryParameter(msrest.serialization.Model):
    """Query parameter to get fabric.

    :param zone_to_zone_mappings: A value indicating whether the zone to zone mappings are to be
     returned.
    :type zone_to_zone_mappings: str
    :param fetch_agent_details: A value indicating whether the agent details are to be fetched.
    :type fetch_agent_details: str
    :param bios_id: The BIOS Id to be used for fetching agent details.
    :type bios_id: str
    :param fqdn: The FQDN to be used for fetching agent details.
    :type fqdn: str
    :param discovery_type: The type of the discovered machine to be used for fetching agent
     details.
    :type discovery_type: str
    :param os_type: The OS type to be used for fetching agent details.
    :type os_type: str
    """

    _attribute_map = {
        'zone_to_zone_mappings': {'key': 'zoneToZoneMappings', 'type': 'str'},
        'fetch_agent_details': {'key': 'fetchAgentDetails', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'discovery_type': {'key': 'discoveryType', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        zone_to_zone_mappings: Optional[str] = None,
        fetch_agent_details: Optional[str] = None,
        bios_id: Optional[str] = None,
        fqdn: Optional[str] = None,
        discovery_type: Optional[str] = None,
        os_type: Optional[str] = None,
        **kwargs
    ):
        super(FabricQueryParameter, self).__init__(**kwargs)
        self.zone_to_zone_mappings = zone_to_zone_mappings
        self.fetch_agent_details = fetch_agent_details
        self.bios_id = bios_id
        self.fqdn = fqdn
        self.discovery_type = discovery_type
        self.os_type = os_type


class JobTaskDetails(TaskTypeDetails):
    """This class represents a task which is actually a workflow so that one can navigate to its individual drill down.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FabricReplicationGroupTaskDetails, VirtualMachineTaskDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param job_task: The job entity.
    :type job_task: ~azure.mgmt.recoveryservicessiterecovery.models.JobEntity
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'job_task': {'key': 'jobTask', 'type': 'JobEntity'},
    }

    _subtype_map = {
        'instance_type': {'FabricReplicationGroupTaskDetails': 'FabricReplicationGroupTaskDetails', 'VirtualMachineTaskDetails': 'VirtualMachineTaskDetails'}
    }

    def __init__(
        self,
        *,
        job_task: Optional["JobEntity"] = None,
        **kwargs
    ):
        super(JobTaskDetails, self).__init__(**kwargs)
        self.instance_type = 'JobTaskDetails'  # type: str
        self.job_task = job_task


class FabricReplicationGroupTaskDetails(JobTaskDetails):
    """This class represents the fabric replication group task details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param job_task: The job entity.
    :type job_task: ~azure.mgmt.recoveryservicessiterecovery.models.JobEntity
    :param skipped_reason: The skipped reason.
    :type skipped_reason: str
    :param skipped_reason_string: The skipped reason string.
    :type skipped_reason_string: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'job_task': {'key': 'jobTask', 'type': 'JobEntity'},
        'skipped_reason': {'key': 'skippedReason', 'type': 'str'},
        'skipped_reason_string': {'key': 'skippedReasonString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_task: Optional["JobEntity"] = None,
        skipped_reason: Optional[str] = None,
        skipped_reason_string: Optional[str] = None,
        **kwargs
    ):
        super(FabricReplicationGroupTaskDetails, self).__init__(job_task=job_task, **kwargs)
        self.instance_type = 'FabricReplicationGroupTaskDetails'  # type: str
        self.skipped_reason = skipped_reason
        self.skipped_reason_string = skipped_reason_string


class FailoverJobDetails(JobDetails):
    """This class represents the details for a failover job.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of job details (see JobDetailsTypes enum for
     possible values).Constant filled by server.
    :type instance_type: str
    :param affected_object_details: The affected object properties like source server, source
     cloud, target server, target cloud etc. based on the workflow object details.
    :type affected_object_details: dict[str, str]
    :param protected_item_details: The test VM details.
    :type protected_item_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.FailoverReplicationProtectedItemDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'affected_object_details': {'key': 'affectedObjectDetails', 'type': '{str}'},
        'protected_item_details': {'key': 'protectedItemDetails', 'type': '[FailoverReplicationProtectedItemDetails]'},
    }

    def __init__(
        self,
        *,
        affected_object_details: Optional[Dict[str, str]] = None,
        protected_item_details: Optional[List["FailoverReplicationProtectedItemDetails"]] = None,
        **kwargs
    ):
        super(FailoverJobDetails, self).__init__(affected_object_details=affected_object_details, **kwargs)
        self.instance_type = 'FailoverJobDetails'  # type: str
        self.protected_item_details = protected_item_details


class FailoverProcessServerRequest(msrest.serialization.Model):
    """Request to failover a process server.

    :param properties: The properties of the PS Failover request.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.FailoverProcessServerRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'FailoverProcessServerRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["FailoverProcessServerRequestProperties"] = None,
        **kwargs
    ):
        super(FailoverProcessServerRequest, self).__init__(**kwargs)
        self.properties = properties


class FailoverProcessServerRequestProperties(msrest.serialization.Model):
    """The properties of the Failover Process Server request.

    :param container_name: The container identifier.
    :type container_name: str
    :param source_process_server_id: The source process server.
    :type source_process_server_id: str
    :param target_process_server_id: The new process server.
    :type target_process_server_id: str
    :param vms_to_migrate: The VMS to migrate.
    :type vms_to_migrate: list[str]
    :param update_type: A value for failover type. It can be systemlevel/serverlevel.
    :type update_type: str
    """

    _attribute_map = {
        'container_name': {'key': 'containerName', 'type': 'str'},
        'source_process_server_id': {'key': 'sourceProcessServerId', 'type': 'str'},
        'target_process_server_id': {'key': 'targetProcessServerId', 'type': 'str'},
        'vms_to_migrate': {'key': 'vmsToMigrate', 'type': '[str]'},
        'update_type': {'key': 'updateType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        source_process_server_id: Optional[str] = None,
        target_process_server_id: Optional[str] = None,
        vms_to_migrate: Optional[List[str]] = None,
        update_type: Optional[str] = None,
        **kwargs
    ):
        super(FailoverProcessServerRequestProperties, self).__init__(**kwargs)
        self.container_name = container_name
        self.source_process_server_id = source_process_server_id
        self.target_process_server_id = target_process_server_id
        self.vms_to_migrate = vms_to_migrate
        self.update_type = update_type


class FailoverReplicationProtectedItemDetails(msrest.serialization.Model):
    """Failover details for a replication protected item.

    :param name: The name.
    :type name: str
    :param friendly_name: The friendly name.
    :type friendly_name: str
    :param test_vm_name: The test Vm name.
    :type test_vm_name: str
    :param test_vm_friendly_name: The test Vm friendly name.
    :type test_vm_friendly_name: str
    :param network_connection_status: The network connection status.
    :type network_connection_status: str
    :param network_friendly_name: The network friendly name.
    :type network_friendly_name: str
    :param subnet: The network subnet.
    :type subnet: str
    :param recovery_point_id: The recovery point Id.
    :type recovery_point_id: str
    :param recovery_point_time: The recovery point time.
    :type recovery_point_time: ~datetime.datetime
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'test_vm_name': {'key': 'testVmName', 'type': 'str'},
        'test_vm_friendly_name': {'key': 'testVmFriendlyName', 'type': 'str'},
        'network_connection_status': {'key': 'networkConnectionStatus', 'type': 'str'},
        'network_friendly_name': {'key': 'networkFriendlyName', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        test_vm_name: Optional[str] = None,
        test_vm_friendly_name: Optional[str] = None,
        network_connection_status: Optional[str] = None,
        network_friendly_name: Optional[str] = None,
        subnet: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        recovery_point_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(FailoverReplicationProtectedItemDetails, self).__init__(**kwargs)
        self.name = name
        self.friendly_name = friendly_name
        self.test_vm_name = test_vm_name
        self.test_vm_friendly_name = test_vm_friendly_name
        self.network_connection_status = network_connection_status
        self.network_friendly_name = network_friendly_name
        self.subnet = subnet
        self.recovery_point_id = recovery_point_id
        self.recovery_point_time = recovery_point_time


class GroupTaskDetails(msrest.serialization.Model):
    """This class represents the group task details when parent child relationship exists in the drill down.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: InlineWorkflowTaskDetails, RecoveryPlanGroupTaskDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param child_tasks: The child tasks.
    :type child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'child_tasks': {'key': 'childTasks', 'type': '[ASRTask]'},
    }

    _subtype_map = {
        'instance_type': {'InlineWorkflowTaskDetails': 'InlineWorkflowTaskDetails', 'RecoveryPlanGroupTaskDetails': 'RecoveryPlanGroupTaskDetails'}
    }

    def __init__(
        self,
        *,
        child_tasks: Optional[List["ASRTask"]] = None,
        **kwargs
    ):
        super(GroupTaskDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]
        self.child_tasks = child_tasks


class HealthError(msrest.serialization.Model):
    """Health Error.

    :param inner_health_errors: The inner health errors. HealthError having a list of HealthError
     as child errors is problematic. InnerHealthError is used because this will prevent an infinite
     loop of structures when Hydra tries to auto-generate the contract. We are exposing the related
     health errors as inner health errors and all API consumers can utilize this in the same fashion
     as Exception -&gt; InnerException.
    :type inner_health_errors:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InnerHealthError]
    :param error_source: Source of error.
    :type error_source: str
    :param error_type: Type of error.
    :type error_type: str
    :param error_level: Level of error.
    :type error_level: str
    :param error_category: Category of error.
    :type error_category: str
    :param error_code: Error code.
    :type error_code: str
    :param summary_message: Summary message of the entity.
    :type summary_message: str
    :param error_message: Error message.
    :type error_message: str
    :param possible_causes: Possible causes of error.
    :type possible_causes: str
    :param recommended_action: Recommended action to resolve error.
    :type recommended_action: str
    :param creation_time_utc: Error creation time (UTC).
    :type creation_time_utc: ~datetime.datetime
    :param recovery_provider_error_message: DRA error message.
    :type recovery_provider_error_message: str
    :param entity_id: ID of the entity.
    :type entity_id: str
    :param error_id: The health error unique id.
    :type error_id: str
    :param customer_resolvability: Value indicating whether the health error is customer
     resolvable. Possible values include: "Allowed", "NotAllowed".
    :type customer_resolvability: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCustomerResolvability
    """

    _attribute_map = {
        'inner_health_errors': {'key': 'innerHealthErrors', 'type': '[InnerHealthError]'},
        'error_source': {'key': 'errorSource', 'type': 'str'},
        'error_type': {'key': 'errorType', 'type': 'str'},
        'error_level': {'key': 'errorLevel', 'type': 'str'},
        'error_category': {'key': 'errorCategory', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'summary_message': {'key': 'summaryMessage', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'possible_causes': {'key': 'possibleCauses', 'type': 'str'},
        'recommended_action': {'key': 'recommendedAction', 'type': 'str'},
        'creation_time_utc': {'key': 'creationTimeUtc', 'type': 'iso-8601'},
        'recovery_provider_error_message': {'key': 'recoveryProviderErrorMessage', 'type': 'str'},
        'entity_id': {'key': 'entityId', 'type': 'str'},
        'error_id': {'key': 'errorId', 'type': 'str'},
        'customer_resolvability': {'key': 'customerResolvability', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        inner_health_errors: Optional[List["InnerHealthError"]] = None,
        error_source: Optional[str] = None,
        error_type: Optional[str] = None,
        error_level: Optional[str] = None,
        error_category: Optional[str] = None,
        error_code: Optional[str] = None,
        summary_message: Optional[str] = None,
        error_message: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        creation_time_utc: Optional[datetime.datetime] = None,
        recovery_provider_error_message: Optional[str] = None,
        entity_id: Optional[str] = None,
        error_id: Optional[str] = None,
        customer_resolvability: Optional[Union[str, "HealthErrorCustomerResolvability"]] = None,
        **kwargs
    ):
        super(HealthError, self).__init__(**kwargs)
        self.inner_health_errors = inner_health_errors
        self.error_source = error_source
        self.error_type = error_type
        self.error_level = error_level
        self.error_category = error_category
        self.error_code = error_code
        self.summary_message = summary_message
        self.error_message = error_message
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action
        self.creation_time_utc = creation_time_utc
        self.recovery_provider_error_message = recovery_provider_error_message
        self.entity_id = entity_id
        self.error_id = error_id
        self.customer_resolvability = customer_resolvability


class HealthErrorSummary(msrest.serialization.Model):
    """class to define the summary of the health error details.

    :param summary_code: The code of the health error.
    :type summary_code: str
    :param category: The category of the health error. Possible values include: "None",
     "Replication", "TestFailover", "Configuration", "FabricInfrastructure", "VersionExpiry",
     "AgentAutoUpdateInfra", "AgentAutoUpdateArtifactDeleted", "AgentAutoUpdateRunAsAccount",
     "AgentAutoUpdateRunAsAccountExpiry", "AgentAutoUpdateRunAsAccountExpired".
    :type category: str or ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCategory
    :param severity: Severity of error. Possible values include: "NONE", "Warning", "Error",
     "Info".
    :type severity: str or ~azure.mgmt.recoveryservicessiterecovery.models.Severity
    :param summary_message: The summary message of the health error.
    :type summary_message: str
    :param affected_resource_type: The type of affected ARM resource.
    :type affected_resource_type: str
    :param affected_resource_subtype: The sub type of any subcomponent within the ARM resource that
     this might be applicable. Value remains null if not applicable.
    :type affected_resource_subtype: str
    :param affected_resource_correlation_ids: The list of affected resource correlation Ids. This
     can be used to uniquely identify the count of items affected by a specific category and
     severity as well as count of item affected by an specific issue.
    :type affected_resource_correlation_ids: list[str]
    """

    _attribute_map = {
        'summary_code': {'key': 'summaryCode', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'summary_message': {'key': 'summaryMessage', 'type': 'str'},
        'affected_resource_type': {'key': 'affectedResourceType', 'type': 'str'},
        'affected_resource_subtype': {'key': 'affectedResourceSubtype', 'type': 'str'},
        'affected_resource_correlation_ids': {'key': 'affectedResourceCorrelationIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        summary_code: Optional[str] = None,
        category: Optional[Union[str, "HealthErrorCategory"]] = None,
        severity: Optional[Union[str, "Severity"]] = None,
        summary_message: Optional[str] = None,
        affected_resource_type: Optional[str] = None,
        affected_resource_subtype: Optional[str] = None,
        affected_resource_correlation_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(HealthErrorSummary, self).__init__(**kwargs)
        self.summary_code = summary_code
        self.category = category
        self.severity = severity
        self.summary_message = summary_message
        self.affected_resource_type = affected_resource_type
        self.affected_resource_subtype = affected_resource_subtype
        self.affected_resource_correlation_ids = affected_resource_correlation_ids


class HyperVHostDetails(msrest.serialization.Model):
    """Hyper-V host details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Hyper-V host Id.
    :vartype id: str
    :ivar name: The Hyper-V host name.
    :vartype name: str
    :ivar mars_agent_version: The Mars agent version.
    :vartype mars_agent_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'mars_agent_version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'mars_agent_version': {'key': 'marsAgentVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HyperVHostDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.mars_agent_version = None


class HyperVReplica2012EventDetails(EventProviderSpecificDetails):
    """Model class for event details of a HyperVReplica E2E event.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param container_name: The container friendly name.
    :type container_name: str
    :param fabric_name: The fabric friendly name.
    :type fabric_name: str
    :param remote_container_name: The remote container name.
    :type remote_container_name: str
    :param remote_fabric_name: The remote fabric name.
    :type remote_fabric_name: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'remote_container_name': {'key': 'remoteContainerName', 'type': 'str'},
        'remote_fabric_name': {'key': 'remoteFabricName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        remote_container_name: Optional[str] = None,
        remote_fabric_name: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplica2012EventDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplica2012'  # type: str
        self.container_name = container_name
        self.fabric_name = fabric_name
        self.remote_container_name = remote_container_name
        self.remote_fabric_name = remote_fabric_name


class HyperVReplica2012R2EventDetails(EventProviderSpecificDetails):
    """Model class for event details of a HyperVReplica blue E2E event.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param container_name: The container friendly name.
    :type container_name: str
    :param fabric_name: The fabric friendly name.
    :type fabric_name: str
    :param remote_container_name: The remote container name.
    :type remote_container_name: str
    :param remote_fabric_name: The remote fabric name.
    :type remote_fabric_name: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'remote_container_name': {'key': 'remoteContainerName', 'type': 'str'},
        'remote_fabric_name': {'key': 'remoteFabricName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        remote_container_name: Optional[str] = None,
        remote_fabric_name: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplica2012R2EventDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplica2012R2'  # type: str
        self.container_name = container_name
        self.fabric_name = fabric_name
        self.remote_container_name = remote_container_name
        self.remote_fabric_name = remote_fabric_name


class HyperVReplicaAzureApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to HyperVReplicaAzure provider.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param primary_kek_certificate_pfx: The primary kek certificate pfx.
    :type primary_kek_certificate_pfx: str
    :param secondary_kek_certificate_pfx: The secondary kek certificate pfx.
    :type secondary_kek_certificate_pfx: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_kek_certificate_pfx': {'key': 'primaryKekCertificatePfx', 'type': 'str'},
        'secondary_kek_certificate_pfx': {'key': 'secondaryKekCertificatePfx', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureApplyRecoveryPointInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx


class HyperVReplicaAzureDiskInputDetails(msrest.serialization.Model):
    """Disk input details.

    :param disk_id: The DiskId.
    :type disk_id: str
    :param log_storage_account_id: The LogStorageAccountId.
    :type log_storage_account_id: str
    :param disk_type: The DiskType. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :param disk_encryption_set_id: The DiskEncryptionSet ARM ID.
    :type disk_encryption_set_id: str
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        disk_type: Optional[Union[str, "DiskAccountType"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureDiskInputDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.log_storage_account_id = log_storage_account_id
        self.disk_type = disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class HyperVReplicaAzureEnableProtectionInput(EnableProtectionProviderSpecificInput):
    """HyperVReplicaAzure specific enable protection input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param hv_host_vm_id: The Hyper-V host VM Id.
    :type hv_host_vm_id: str
    :param vm_name: The VM Name.
    :type vm_name: str
    :param os_type: The OS type associated with VM.
    :type os_type: str
    :param vhd_id: The OS disk VHD id associated with VM.
    :type vhd_id: str
    :param target_storage_account_id: The storage account Id.
    :type target_storage_account_id: str
    :param target_azure_network_id: The selected target Azure network Id.
    :type target_azure_network_id: str
    :param target_azure_subnet_id: The selected target Azure subnet Id.
    :type target_azure_subnet_id: str
    :param enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :type enable_rdp_on_target_option: str
    :param target_azure_vm_name: The target azure VM Name.
    :type target_azure_vm_name: str
    :param log_storage_account_id: The storage account to be used for logging during replication.
    :type log_storage_account_id: str
    :param disks_to_include: The list of VHD Ids of disks to be protected.
    :type disks_to_include: list[str]
    :param target_azure_v1_resource_group_id: The Id of the target resource group (for classic
     deployment) in which the failover VM is to be created.
    :type target_azure_v1_resource_group_id: str
    :param target_azure_v2_resource_group_id: The Id of the target resource group (for resource
     manager deployment) in which the failover VM is to be created.
    :type target_azure_v2_resource_group_id: str
    :param use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :type use_managed_disks: str
    :param target_availability_set_id: The target availability set ARM Id for resource manager
     deployment.
    :type target_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param license_type: License type. Possible values include: "NotSpecified", "NoLicenseType",
     "WindowsServer".
    :type license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :param sql_server_license_type: The SQL Server license type. Possible values include:
     "NotSpecified", "NoLicenseType", "PAYG", "AHUB".
    :type sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :param target_vm_size: The target VM size.
    :type target_vm_size: str
    :param target_proximity_placement_group_id: The proximity placement group ARM Id.
    :type target_proximity_placement_group_id: str
    :param use_managed_disks_for_replication: A value indicating whether managed disks should be
     used during replication.
    :type use_managed_disks_for_replication: str
    :param disk_type: The DiskType. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :param disks_to_include_for_managed_disks: The disks to include list for managed disks.
    :type disks_to_include_for_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureDiskInputDetails]
    :param disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :type disk_encryption_set_id: str
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param seed_managed_disk_tags: The tags for the seed managed disks.
    :type seed_managed_disk_tags: dict[str, str]
    :param target_managed_disk_tags: The tags for the target managed disks.
    :type target_managed_disk_tags: dict[str, str]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'hv_host_vm_id': {'key': 'hvHostVmId', 'type': 'str'},
        'vm_name': {'key': 'vmName', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vhd_id': {'key': 'vhdId', 'type': 'str'},
        'target_storage_account_id': {'key': 'targetStorageAccountId', 'type': 'str'},
        'target_azure_network_id': {'key': 'targetAzureNetworkId', 'type': 'str'},
        'target_azure_subnet_id': {'key': 'targetAzureSubnetId', 'type': 'str'},
        'enable_rdp_on_target_option': {'key': 'enableRdpOnTargetOption', 'type': 'str'},
        'target_azure_vm_name': {'key': 'targetAzureVmName', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'disks_to_include': {'key': 'disksToInclude', 'type': '[str]'},
        'target_azure_v1_resource_group_id': {'key': 'targetAzureV1ResourceGroupId', 'type': 'str'},
        'target_azure_v2_resource_group_id': {'key': 'targetAzureV2ResourceGroupId', 'type': 'str'},
        'use_managed_disks': {'key': 'useManagedDisks', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'use_managed_disks_for_replication': {'key': 'useManagedDisksForReplication', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'disks_to_include_for_managed_disks': {'key': 'disksToIncludeForManagedDisks', 'type': '[HyperVReplicaAzureDiskInputDetails]'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'seed_managed_disk_tags': {'key': 'seedManagedDiskTags', 'type': '{str}'},
        'target_managed_disk_tags': {'key': 'targetManagedDiskTags', 'type': '{str}'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        hv_host_vm_id: Optional[str] = None,
        vm_name: Optional[str] = None,
        os_type: Optional[str] = None,
        vhd_id: Optional[str] = None,
        target_storage_account_id: Optional[str] = None,
        target_azure_network_id: Optional[str] = None,
        target_azure_subnet_id: Optional[str] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        target_azure_vm_name: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        disks_to_include: Optional[List[str]] = None,
        target_azure_v1_resource_group_id: Optional[str] = None,
        target_azure_v2_resource_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        license_type: Optional[Union[str, "LicenseType"]] = None,
        sql_server_license_type: Optional[Union[str, "SqlServerLicenseType"]] = None,
        target_vm_size: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        use_managed_disks_for_replication: Optional[str] = None,
        disk_type: Optional[Union[str, "DiskAccountType"]] = None,
        disks_to_include_for_managed_disks: Optional[List["HyperVReplicaAzureDiskInputDetails"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureEnableProtectionInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.hv_host_vm_id = hv_host_vm_id
        self.vm_name = vm_name
        self.os_type = os_type
        self.vhd_id = vhd_id
        self.target_storage_account_id = target_storage_account_id
        self.target_azure_network_id = target_azure_network_id
        self.target_azure_subnet_id = target_azure_subnet_id
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.target_azure_vm_name = target_azure_vm_name
        self.log_storage_account_id = log_storage_account_id
        self.disks_to_include = disks_to_include
        self.target_azure_v1_resource_group_id = target_azure_v1_resource_group_id
        self.target_azure_v2_resource_group_id = target_azure_v2_resource_group_id
        self.use_managed_disks = use_managed_disks
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.target_vm_size = target_vm_size
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.use_managed_disks_for_replication = use_managed_disks_for_replication
        self.disk_type = disk_type
        self.disks_to_include_for_managed_disks = disks_to_include_for_managed_disks
        self.disk_encryption_set_id = disk_encryption_set_id
        self.target_vm_tags = target_vm_tags
        self.seed_managed_disk_tags = seed_managed_disk_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags


class HyperVReplicaAzureEventDetails(EventProviderSpecificDetails):
    """Model class for event details of a HyperVReplica E2A event.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param container_name: The container friendly name.
    :type container_name: str
    :param fabric_name: The fabric friendly name.
    :type fabric_name: str
    :param remote_container_name: The remote container name.
    :type remote_container_name: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'remote_container_name': {'key': 'remoteContainerName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        remote_container_name: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureEventDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.container_name = container_name
        self.fabric_name = fabric_name
        self.remote_container_name = remote_container_name


class PlannedFailoverProviderSpecificFailoverInput(msrest.serialization.Model):
    """Provider specific failover input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: HyperVReplicaAzurePlannedFailoverProviderInput, HyperVReplicaAzureFailbackProviderInput, InMageRcmFailbackPlannedFailoverProviderInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'HyperVReplicaAzure': 'HyperVReplicaAzurePlannedFailoverProviderInput', 'HyperVReplicaAzureFailback': 'HyperVReplicaAzureFailbackProviderInput', 'InMageRcmFailback': 'InMageRcmFailbackPlannedFailoverProviderInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlannedFailoverProviderSpecificFailoverInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class HyperVReplicaAzureFailbackProviderInput(PlannedFailoverProviderSpecificFailoverInput):
    """HyperVReplicaAzureFailback specific planned failover input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param data_sync_option: Data sync option.
    :type data_sync_option: str
    :param recovery_vm_creation_option: ALR options to create alternate recovery.
    :type recovery_vm_creation_option: str
    :param provider_id_for_alternate_recovery: Provider Id for alternate location.
    :type provider_id_for_alternate_recovery: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'data_sync_option': {'key': 'dataSyncOption', 'type': 'str'},
        'recovery_vm_creation_option': {'key': 'recoveryVmCreationOption', 'type': 'str'},
        'provider_id_for_alternate_recovery': {'key': 'providerIdForAlternateRecovery', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_sync_option: Optional[str] = None,
        recovery_vm_creation_option: Optional[str] = None,
        provider_id_for_alternate_recovery: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureFailbackProviderInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzureFailback'  # type: str
        self.data_sync_option = data_sync_option
        self.recovery_vm_creation_option = recovery_vm_creation_option
        self.provider_id_for_alternate_recovery = provider_id_for_alternate_recovery


class HyperVReplicaAzureManagedDiskDetails(msrest.serialization.Model):
    """Hyper-V Managed disk details.

    :param disk_id: The disk Id.
    :type disk_id: str
    :param seed_managed_disk_id: Seed managed disk Id.
    :type seed_managed_disk_id: str
    :param replica_disk_type: The replica disk type.
    :type replica_disk_type: str
    :param disk_encryption_set_id: The disk encryption set ARM Id.
    :type disk_encryption_set_id: str
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'seed_managed_disk_id': {'key': 'seedManagedDiskId', 'type': 'str'},
        'replica_disk_type': {'key': 'replicaDiskType', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        seed_managed_disk_id: Optional[str] = None,
        replica_disk_type: Optional[str] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureManagedDiskDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.seed_managed_disk_id = seed_managed_disk_id
        self.replica_disk_type = replica_disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class HyperVReplicaAzurePlannedFailoverProviderInput(PlannedFailoverProviderSpecificFailoverInput):
    """HyperVReplicaAzure specific planned failover input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param primary_kek_certificate_pfx: Primary kek certificate pfx.
    :type primary_kek_certificate_pfx: str
    :param secondary_kek_certificate_pfx: Secondary kek certificate pfx.
    :type secondary_kek_certificate_pfx: str
    :param recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_kek_certificate_pfx': {'key': 'primaryKekCertificatePfx', 'type': 'str'},
        'secondary_kek_certificate_pfx': {'key': 'secondaryKekCertificatePfx', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzurePlannedFailoverProviderInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx
        self.recovery_point_id = recovery_point_id


class HyperVReplicaAzurePolicyDetails(PolicyProviderSpecificDetails):
    """Hyper-V Replica Azure specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param recovery_point_history_duration_in_hours: The duration (in hours) to which point the
     recovery history needs to be maintained.
    :type recovery_point_history_duration_in_hours: int
    :param application_consistent_snapshot_frequency_in_hours: The interval (in hours) at which
     Hyper-V Replica should create an application consistent snapshot within the VM.
    :type application_consistent_snapshot_frequency_in_hours: int
    :param replication_interval: The replication interval.
    :type replication_interval: int
    :param online_replication_start_time: The scheduled start time for the initial replication. If
     this parameter is Null, the initial replication starts immediately.
    :type online_replication_start_time: str
    :param encryption: A value indicating whether encryption is enabled for virtual machines in
     this cloud.
    :type encryption: str
    :param active_storage_account_id: The active storage account Id.
    :type active_storage_account_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_history_duration_in_hours': {'key': 'recoveryPointHistoryDurationInHours', 'type': 'int'},
        'application_consistent_snapshot_frequency_in_hours': {'key': 'applicationConsistentSnapshotFrequencyInHours', 'type': 'int'},
        'replication_interval': {'key': 'replicationInterval', 'type': 'int'},
        'online_replication_start_time': {'key': 'onlineReplicationStartTime', 'type': 'str'},
        'encryption': {'key': 'encryption', 'type': 'str'},
        'active_storage_account_id': {'key': 'activeStorageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_history_duration_in_hours: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        replication_interval: Optional[int] = None,
        online_replication_start_time: Optional[str] = None,
        encryption: Optional[str] = None,
        active_storage_account_id: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzurePolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.recovery_point_history_duration_in_hours = recovery_point_history_duration_in_hours
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.replication_interval = replication_interval
        self.online_replication_start_time = online_replication_start_time
        self.encryption = encryption
        self.active_storage_account_id = active_storage_account_id


class HyperVReplicaAzurePolicyInput(PolicyProviderSpecificInput):
    """Hyper-V Replica Azure specific input for creating a protection profile.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_history_duration: The duration (in hours) to which point the recovery
     history needs to be maintained.
    :type recovery_point_history_duration: int
    :param application_consistent_snapshot_frequency_in_hours: The interval (in hours) at which
     Hyper-V Replica should create an application consistent snapshot within the VM.
    :type application_consistent_snapshot_frequency_in_hours: int
    :param replication_interval: The replication interval.
    :type replication_interval: int
    :param online_replication_start_time: The scheduled start time for the initial replication. If
     this parameter is Null, the initial replication starts immediately.
    :type online_replication_start_time: str
    :param storage_accounts: The list of storage accounts to which the VMs in the primary cloud can
     replicate to.
    :type storage_accounts: list[str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_history_duration': {'key': 'recoveryPointHistoryDuration', 'type': 'int'},
        'application_consistent_snapshot_frequency_in_hours': {'key': 'applicationConsistentSnapshotFrequencyInHours', 'type': 'int'},
        'replication_interval': {'key': 'replicationInterval', 'type': 'int'},
        'online_replication_start_time': {'key': 'onlineReplicationStartTime', 'type': 'str'},
        'storage_accounts': {'key': 'storageAccounts', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        recovery_point_history_duration: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        replication_interval: Optional[int] = None,
        online_replication_start_time: Optional[str] = None,
        storage_accounts: Optional[List[str]] = None,
        **kwargs
    ):
        super(HyperVReplicaAzurePolicyInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.recovery_point_history_duration = recovery_point_history_duration
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.replication_interval = replication_interval
        self.online_replication_start_time = online_replication_start_time
        self.storage_accounts = storage_accounts


class HyperVReplicaAzureReplicationDetails(ReplicationProviderSpecificSettings):
    """Hyper V Replica Azure provider specific settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param azure_vm_disk_details: Azure VM Disk details.
    :type azure_vm_disk_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.AzureVmDiskDetails]
    :param recovery_azure_vm_name: Recovery Azure given name.
    :type recovery_azure_vm_name: str
    :param recovery_azure_vm_size: The Recovery Azure VM size.
    :type recovery_azure_vm_size: str
    :param recovery_azure_storage_account: The recovery Azure storage account.
    :type recovery_azure_storage_account: str
    :param recovery_azure_log_storage_account_id: The ARM id of the log storage account used for
     replication. This will be set to null if no log storage account was provided during enable
     protection.
    :type recovery_azure_log_storage_account_id: str
    :param last_replicated_time: The Last replication time.
    :type last_replicated_time: ~datetime.datetime
    :param rpo_in_seconds: Last RPO value.
    :type rpo_in_seconds: long
    :param last_rpo_calculated_time: The last RPO calculated time.
    :type last_rpo_calculated_time: ~datetime.datetime
    :param vm_id: The virtual machine Id.
    :type vm_id: str
    :param vm_protection_state: The protection state for the vm.
    :type vm_protection_state: str
    :param vm_protection_state_description: The protection state description for the vm.
    :type vm_protection_state_description: str
    :param initial_replication_details: Initial replication details.
    :type initial_replication_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :param vm_nics: The PE Network details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :param selected_recovery_azure_network_id: The selected recovery azure network Id.
    :type selected_recovery_azure_network_id: str
    :param selected_source_nic_id: The selected source nic Id which will be used as the primary nic
     during failover.
    :type selected_source_nic_id: str
    :param encryption: The encryption info.
    :type encryption: str
    :param o_s_details: The operating system info.
    :type o_s_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDetails
    :param source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
    :type source_vm_ram_size_in_mb: int
    :param source_vm_cpu_count: The CPU count of the VM on the primary side.
    :type source_vm_cpu_count: int
    :param enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :type enable_rdp_on_target_option: str
    :param recovery_azure_resource_group_id: The target resource group Id.
    :type recovery_azure_resource_group_id: str
    :param recovery_availability_set_id: The recovery availability set Id.
    :type recovery_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The target proximity placement group Id.
    :type target_proximity_placement_group_id: str
    :param use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :type use_managed_disks: str
    :param license_type: License Type of the VM to be used.
    :type license_type: str
    :param sql_server_license_type: The SQL Server license type.
    :type sql_server_license_type: str
    :ivar last_recovery_point_received: The last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param seed_managed_disk_tags: The tags for the seed managed disks.
    :type seed_managed_disk_tags: dict[str, str]
    :param target_managed_disk_tags: The tags for the target managed disks.
    :type target_managed_disk_tags: dict[str, str]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    :param protected_managed_disks: The list of protected managed disks.
    :type protected_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureManagedDiskDetails]
    """

    _validation = {
        'instance_type': {'required': True},
        'last_recovery_point_received': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'azure_vm_disk_details': {'key': 'azureVmDiskDetails', 'type': '[AzureVmDiskDetails]'},
        'recovery_azure_vm_name': {'key': 'recoveryAzureVmName', 'type': 'str'},
        'recovery_azure_vm_size': {'key': 'recoveryAzureVMSize', 'type': 'str'},
        'recovery_azure_storage_account': {'key': 'recoveryAzureStorageAccount', 'type': 'str'},
        'recovery_azure_log_storage_account_id': {'key': 'recoveryAzureLogStorageAccountId', 'type': 'str'},
        'last_replicated_time': {'key': 'lastReplicatedTime', 'type': 'iso-8601'},
        'rpo_in_seconds': {'key': 'rpoInSeconds', 'type': 'long'},
        'last_rpo_calculated_time': {'key': 'lastRpoCalculatedTime', 'type': 'iso-8601'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'vm_protection_state': {'key': 'vmProtectionState', 'type': 'str'},
        'vm_protection_state_description': {'key': 'vmProtectionStateDescription', 'type': 'str'},
        'initial_replication_details': {'key': 'initialReplicationDetails', 'type': 'InitialReplicationDetails'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMNicDetails]'},
        'selected_recovery_azure_network_id': {'key': 'selectedRecoveryAzureNetworkId', 'type': 'str'},
        'selected_source_nic_id': {'key': 'selectedSourceNicId', 'type': 'str'},
        'encryption': {'key': 'encryption', 'type': 'str'},
        'o_s_details': {'key': 'oSDetails', 'type': 'OSDetails'},
        'source_vm_ram_size_in_mb': {'key': 'sourceVmRamSizeInMB', 'type': 'int'},
        'source_vm_cpu_count': {'key': 'sourceVmCpuCount', 'type': 'int'},
        'enable_rdp_on_target_option': {'key': 'enableRdpOnTargetOption', 'type': 'str'},
        'recovery_azure_resource_group_id': {'key': 'recoveryAzureResourceGroupId', 'type': 'str'},
        'recovery_availability_set_id': {'key': 'recoveryAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'use_managed_disks': {'key': 'useManagedDisks', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'last_recovery_point_received': {'key': 'lastRecoveryPointReceived', 'type': 'iso-8601'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'seed_managed_disk_tags': {'key': 'seedManagedDiskTags', 'type': '{str}'},
        'target_managed_disk_tags': {'key': 'targetManagedDiskTags', 'type': '{str}'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
        'protected_managed_disks': {'key': 'protectedManagedDisks', 'type': '[HyperVReplicaAzureManagedDiskDetails]'},
    }

    def __init__(
        self,
        *,
        azure_vm_disk_details: Optional[List["AzureVmDiskDetails"]] = None,
        recovery_azure_vm_name: Optional[str] = None,
        recovery_azure_vm_size: Optional[str] = None,
        recovery_azure_storage_account: Optional[str] = None,
        recovery_azure_log_storage_account_id: Optional[str] = None,
        last_replicated_time: Optional[datetime.datetime] = None,
        rpo_in_seconds: Optional[int] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        initial_replication_details: Optional["InitialReplicationDetails"] = None,
        vm_nics: Optional[List["VMNicDetails"]] = None,
        selected_recovery_azure_network_id: Optional[str] = None,
        selected_source_nic_id: Optional[str] = None,
        encryption: Optional[str] = None,
        o_s_details: Optional["OSDetails"] = None,
        source_vm_ram_size_in_mb: Optional[int] = None,
        source_vm_cpu_count: Optional[int] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        recovery_azure_resource_group_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        license_type: Optional[str] = None,
        sql_server_license_type: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        protected_managed_disks: Optional[List["HyperVReplicaAzureManagedDiskDetails"]] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.azure_vm_disk_details = azure_vm_disk_details
        self.recovery_azure_vm_name = recovery_azure_vm_name
        self.recovery_azure_vm_size = recovery_azure_vm_size
        self.recovery_azure_storage_account = recovery_azure_storage_account
        self.recovery_azure_log_storage_account_id = recovery_azure_log_storage_account_id
        self.last_replicated_time = last_replicated_time
        self.rpo_in_seconds = rpo_in_seconds
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.initial_replication_details = initial_replication_details
        self.vm_nics = vm_nics
        self.selected_recovery_azure_network_id = selected_recovery_azure_network_id
        self.selected_source_nic_id = selected_source_nic_id
        self.encryption = encryption
        self.o_s_details = o_s_details
        self.source_vm_ram_size_in_mb = source_vm_ram_size_in_mb
        self.source_vm_cpu_count = source_vm_cpu_count
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.recovery_azure_resource_group_id = recovery_azure_resource_group_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.use_managed_disks = use_managed_disks
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.last_recovery_point_received = None
        self.target_vm_tags = target_vm_tags
        self.seed_managed_disk_tags = seed_managed_disk_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags
        self.protected_managed_disks = protected_managed_disks


class HyperVReplicaAzureReprotectInput(ReverseReplicationProviderSpecificInput):
    """Azure specific reprotect input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param hv_host_vm_id: The Hyper-V host Vm Id.
    :type hv_host_vm_id: str
    :param vm_name: The Vm Name.
    :type vm_name: str
    :param os_type: The OS type associated with vm.
    :type os_type: str
    :param v_hd_id: The OS disk VHD id associated with vm.
    :type v_hd_id: str
    :param storage_account_id: The storage account name.
    :type storage_account_id: str
    :param log_storage_account_id: The storage account to be used for logging during replication.
    :type log_storage_account_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'hv_host_vm_id': {'key': 'hvHostVmId', 'type': 'str'},
        'vm_name': {'key': 'vmName', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'v_hd_id': {'key': 'vHDId', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        hv_host_vm_id: Optional[str] = None,
        vm_name: Optional[str] = None,
        os_type: Optional[str] = None,
        v_hd_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureReprotectInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.hv_host_vm_id = hv_host_vm_id
        self.vm_name = vm_name
        self.os_type = os_type
        self.v_hd_id = v_hd_id
        self.storage_account_id = storage_account_id
        self.log_storage_account_id = log_storage_account_id


class HyperVReplicaAzureTestFailoverInput(TestFailoverProviderSpecificInput):
    """HvrA provider specific input for test failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param primary_kek_certificate_pfx: Primary kek certificate pfx.
    :type primary_kek_certificate_pfx: str
    :param secondary_kek_certificate_pfx: Secondary kek certificate pfx.
    :type secondary_kek_certificate_pfx: str
    :param recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_kek_certificate_pfx': {'key': 'primaryKekCertificatePfx', 'type': 'str'},
        'secondary_kek_certificate_pfx': {'key': 'secondaryKekCertificatePfx', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureTestFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx
        self.recovery_point_id = recovery_point_id


class HyperVReplicaAzureUnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """HvrA provider specific input for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param primary_kek_certificate_pfx: Primary kek certificate pfx.
    :type primary_kek_certificate_pfx: str
    :param secondary_kek_certificate_pfx: Secondary kek certificate pfx.
    :type secondary_kek_certificate_pfx: str
    :param recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_kek_certificate_pfx': {'key': 'primaryKekCertificatePfx', 'type': 'str'},
        'secondary_kek_certificate_pfx': {'key': 'secondaryKekCertificatePfx', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureUnplannedFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx
        self.recovery_point_id = recovery_point_id


class HyperVReplicaAzureUpdateReplicationProtectedItemInput(UpdateReplicationProtectedItemProviderInput):
    """HyperV replica Azure input to update replication protected item.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_azure_v1_resource_group_id: The recovery Azure resource group Id for classic
     deployment.
    :type recovery_azure_v1_resource_group_id: str
    :param recovery_azure_v2_resource_group_id: The recovery Azure resource group Id for resource
     manager deployment.
    :type recovery_azure_v2_resource_group_id: str
    :param use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :type use_managed_disks: str
    :param disk_id_to_disk_encryption_map: The dictionary of disk resource Id to disk encryption
     set ARM Id.
    :type disk_id_to_disk_encryption_map: dict[str, str]
    :param target_proximity_placement_group_id: The target proximity placement group Id.
    :type target_proximity_placement_group_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param target_managed_disk_tags: The tags for the target managed disks.
    :type target_managed_disk_tags: dict[str, str]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    :param sql_server_license_type: The SQL Server license type. Possible values include:
     "NotSpecified", "NoLicenseType", "PAYG", "AHUB".
    :type sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :param vm_disks: The list of disk update properties.
    :type vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.UpdateDiskInput]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_azure_v1_resource_group_id': {'key': 'recoveryAzureV1ResourceGroupId', 'type': 'str'},
        'recovery_azure_v2_resource_group_id': {'key': 'recoveryAzureV2ResourceGroupId', 'type': 'str'},
        'use_managed_disks': {'key': 'useManagedDisks', 'type': 'str'},
        'disk_id_to_disk_encryption_map': {'key': 'diskIdToDiskEncryptionMap', 'type': '{str}'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'target_managed_disk_tags': {'key': 'targetManagedDiskTags', 'type': '{str}'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'vm_disks': {'key': 'vmDisks', 'type': '[UpdateDiskInput]'},
    }

    def __init__(
        self,
        *,
        recovery_azure_v1_resource_group_id: Optional[str] = None,
        recovery_azure_v2_resource_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        disk_id_to_disk_encryption_map: Optional[Dict[str, str]] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        sql_server_license_type: Optional[Union[str, "SqlServerLicenseType"]] = None,
        vm_disks: Optional[List["UpdateDiskInput"]] = None,
        **kwargs
    ):
        super(HyperVReplicaAzureUpdateReplicationProtectedItemInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.recovery_azure_v1_resource_group_id = recovery_azure_v1_resource_group_id
        self.recovery_azure_v2_resource_group_id = recovery_azure_v2_resource_group_id
        self.use_managed_disks = use_managed_disks
        self.disk_id_to_disk_encryption_map = disk_id_to_disk_encryption_map
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_availability_zone = target_availability_zone
        self.target_vm_tags = target_vm_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags
        self.sql_server_license_type = sql_server_license_type
        self.vm_disks = vm_disks


class HyperVReplicaBaseEventDetails(EventProviderSpecificDetails):
    """Abstract model class for event details of a HyperVReplica E2E event.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param container_name: The container friendly name.
    :type container_name: str
    :param fabric_name: The fabric friendly name.
    :type fabric_name: str
    :param remote_container_name: The remote container name.
    :type remote_container_name: str
    :param remote_fabric_name: The remote fabric name.
    :type remote_fabric_name: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'remote_container_name': {'key': 'remoteContainerName', 'type': 'str'},
        'remote_fabric_name': {'key': 'remoteFabricName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        remote_container_name: Optional[str] = None,
        remote_fabric_name: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaBaseEventDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaBaseEventDetails'  # type: str
        self.container_name = container_name
        self.fabric_name = fabric_name
        self.remote_container_name = remote_container_name
        self.remote_fabric_name = remote_fabric_name


class HyperVReplicaBasePolicyDetails(PolicyProviderSpecificDetails):
    """Base class for HyperVReplica policy details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param recovery_points: A value indicating the number of recovery points.
    :type recovery_points: int
    :param application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :type application_consistent_snapshot_frequency_in_hours: int
    :param compression: A value indicating whether compression has to be enabled.
    :type compression: str
    :param initial_replication_method: A value indicating whether IR is online.
    :type initial_replication_method: str
    :param online_replication_start_time: A value indicating the online IR start time.
    :type online_replication_start_time: str
    :param offline_replication_import_path: A value indicating the offline IR import path.
    :type offline_replication_import_path: str
    :param offline_replication_export_path: A value indicating the offline IR export path.
    :type offline_replication_export_path: str
    :param replication_port: A value indicating the recovery HTTPS port.
    :type replication_port: int
    :param allowed_authentication_type: A value indicating the authentication type.
    :type allowed_authentication_type: int
    :param replica_deletion_option: A value indicating whether the VM has to be auto deleted.
     Supported Values: String.Empty, None, OnRecoveryCloud.
    :type replica_deletion_option: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_points': {'key': 'recoveryPoints', 'type': 'int'},
        'application_consistent_snapshot_frequency_in_hours': {'key': 'applicationConsistentSnapshotFrequencyInHours', 'type': 'int'},
        'compression': {'key': 'compression', 'type': 'str'},
        'initial_replication_method': {'key': 'initialReplicationMethod', 'type': 'str'},
        'online_replication_start_time': {'key': 'onlineReplicationStartTime', 'type': 'str'},
        'offline_replication_import_path': {'key': 'offlineReplicationImportPath', 'type': 'str'},
        'offline_replication_export_path': {'key': 'offlineReplicationExportPath', 'type': 'str'},
        'replication_port': {'key': 'replicationPort', 'type': 'int'},
        'allowed_authentication_type': {'key': 'allowedAuthenticationType', 'type': 'int'},
        'replica_deletion_option': {'key': 'replicaDeletionOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion_option: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaBasePolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaBasePolicyDetails'  # type: str
        self.recovery_points = recovery_points
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.compression = compression
        self.initial_replication_method = initial_replication_method
        self.online_replication_start_time = online_replication_start_time
        self.offline_replication_import_path = offline_replication_import_path
        self.offline_replication_export_path = offline_replication_export_path
        self.replication_port = replication_port
        self.allowed_authentication_type = allowed_authentication_type
        self.replica_deletion_option = replica_deletion_option


class HyperVReplicaBaseReplicationDetails(ReplicationProviderSpecificSettings):
    """Hyper V replica provider specific settings base class.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param last_replicated_time: The Last replication time.
    :type last_replicated_time: ~datetime.datetime
    :param vm_nics: The PE Network details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :param vm_id: The virtual machine Id.
    :type vm_id: str
    :param vm_protection_state: The protection state for the vm.
    :type vm_protection_state: str
    :param vm_protection_state_description: The protection state description for the vm.
    :type vm_protection_state_description: str
    :param initial_replication_details: Initial replication details.
    :type initial_replication_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :param v_m_disk_details: VM disk details.
    :type v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'last_replicated_time': {'key': 'lastReplicatedTime', 'type': 'iso-8601'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMNicDetails]'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'vm_protection_state': {'key': 'vmProtectionState', 'type': 'str'},
        'vm_protection_state_description': {'key': 'vmProtectionStateDescription', 'type': 'str'},
        'initial_replication_details': {'key': 'initialReplicationDetails', 'type': 'InitialReplicationDetails'},
        'v_m_disk_details': {'key': 'vMDiskDetails', 'type': '[DiskDetails]'},
    }

    def __init__(
        self,
        *,
        last_replicated_time: Optional[datetime.datetime] = None,
        vm_nics: Optional[List["VMNicDetails"]] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        initial_replication_details: Optional["InitialReplicationDetails"] = None,
        v_m_disk_details: Optional[List["DiskDetails"]] = None,
        **kwargs
    ):
        super(HyperVReplicaBaseReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaBaseReplicationDetails'  # type: str
        self.last_replicated_time = last_replicated_time
        self.vm_nics = vm_nics
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.initial_replication_details = initial_replication_details
        self.v_m_disk_details = v_m_disk_details


class HyperVReplicaBluePolicyDetails(PolicyProviderSpecificDetails):
    """Hyper-V Replica Blue specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param replication_frequency_in_seconds: A value indicating the replication interval.
    :type replication_frequency_in_seconds: int
    :param recovery_points: A value indicating the number of recovery points.
    :type recovery_points: int
    :param application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :type application_consistent_snapshot_frequency_in_hours: int
    :param compression: A value indicating whether compression has to be enabled.
    :type compression: str
    :param initial_replication_method: A value indicating whether IR is online.
    :type initial_replication_method: str
    :param online_replication_start_time: A value indicating the online IR start time.
    :type online_replication_start_time: str
    :param offline_replication_import_path: A value indicating the offline IR import path.
    :type offline_replication_import_path: str
    :param offline_replication_export_path: A value indicating the offline IR export path.
    :type offline_replication_export_path: str
    :param replication_port: A value indicating the recovery HTTPS port.
    :type replication_port: int
    :param allowed_authentication_type: A value indicating the authentication type.
    :type allowed_authentication_type: int
    :param replica_deletion_option: A value indicating whether the VM has to be auto deleted.
     Supported Values: String.Empty, None, OnRecoveryCloud.
    :type replica_deletion_option: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'replication_frequency_in_seconds': {'key': 'replicationFrequencyInSeconds', 'type': 'int'},
        'recovery_points': {'key': 'recoveryPoints', 'type': 'int'},
        'application_consistent_snapshot_frequency_in_hours': {'key': 'applicationConsistentSnapshotFrequencyInHours', 'type': 'int'},
        'compression': {'key': 'compression', 'type': 'str'},
        'initial_replication_method': {'key': 'initialReplicationMethod', 'type': 'str'},
        'online_replication_start_time': {'key': 'onlineReplicationStartTime', 'type': 'str'},
        'offline_replication_import_path': {'key': 'offlineReplicationImportPath', 'type': 'str'},
        'offline_replication_export_path': {'key': 'offlineReplicationExportPath', 'type': 'str'},
        'replication_port': {'key': 'replicationPort', 'type': 'int'},
        'allowed_authentication_type': {'key': 'allowedAuthenticationType', 'type': 'int'},
        'replica_deletion_option': {'key': 'replicaDeletionOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        replication_frequency_in_seconds: Optional[int] = None,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion_option: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaBluePolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplica2012R2'  # type: str
        self.replication_frequency_in_seconds = replication_frequency_in_seconds
        self.recovery_points = recovery_points
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.compression = compression
        self.initial_replication_method = initial_replication_method
        self.online_replication_start_time = online_replication_start_time
        self.offline_replication_import_path = offline_replication_import_path
        self.offline_replication_export_path = offline_replication_export_path
        self.replication_port = replication_port
        self.allowed_authentication_type = allowed_authentication_type
        self.replica_deletion_option = replica_deletion_option


class HyperVReplicaPolicyInput(PolicyProviderSpecificInput):
    """Hyper-V Replica specific policy Input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: HyperVReplicaBluePolicyInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_points: A value indicating the number of recovery points.
    :type recovery_points: int
    :param application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :type application_consistent_snapshot_frequency_in_hours: int
    :param compression: A value indicating whether compression has to be enabled.
    :type compression: str
    :param initial_replication_method: A value indicating whether IR is online.
    :type initial_replication_method: str
    :param online_replication_start_time: A value indicating the online IR start time.
    :type online_replication_start_time: str
    :param offline_replication_import_path: A value indicating the offline IR import path.
    :type offline_replication_import_path: str
    :param offline_replication_export_path: A value indicating the offline IR export path.
    :type offline_replication_export_path: str
    :param replication_port: A value indicating the recovery HTTPS port.
    :type replication_port: int
    :param allowed_authentication_type: A value indicating the authentication type.
    :type allowed_authentication_type: int
    :param replica_deletion: A value indicating whether the VM has to be auto deleted.
    :type replica_deletion: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_points': {'key': 'recoveryPoints', 'type': 'int'},
        'application_consistent_snapshot_frequency_in_hours': {'key': 'applicationConsistentSnapshotFrequencyInHours', 'type': 'int'},
        'compression': {'key': 'compression', 'type': 'str'},
        'initial_replication_method': {'key': 'initialReplicationMethod', 'type': 'str'},
        'online_replication_start_time': {'key': 'onlineReplicationStartTime', 'type': 'str'},
        'offline_replication_import_path': {'key': 'offlineReplicationImportPath', 'type': 'str'},
        'offline_replication_export_path': {'key': 'offlineReplicationExportPath', 'type': 'str'},
        'replication_port': {'key': 'replicationPort', 'type': 'int'},
        'allowed_authentication_type': {'key': 'allowedAuthenticationType', 'type': 'int'},
        'replica_deletion': {'key': 'replicaDeletion', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'HyperVReplica2012R2': 'HyperVReplicaBluePolicyInput'}
    }

    def __init__(
        self,
        *,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaPolicyInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplica2012'  # type: str
        self.recovery_points = recovery_points
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.compression = compression
        self.initial_replication_method = initial_replication_method
        self.online_replication_start_time = online_replication_start_time
        self.offline_replication_import_path = offline_replication_import_path
        self.offline_replication_export_path = offline_replication_export_path
        self.replication_port = replication_port
        self.allowed_authentication_type = allowed_authentication_type
        self.replica_deletion = replica_deletion


class HyperVReplicaBluePolicyInput(HyperVReplicaPolicyInput):
    """HyperV Replica Blue policy input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_points: A value indicating the number of recovery points.
    :type recovery_points: int
    :param application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :type application_consistent_snapshot_frequency_in_hours: int
    :param compression: A value indicating whether compression has to be enabled.
    :type compression: str
    :param initial_replication_method: A value indicating whether IR is online.
    :type initial_replication_method: str
    :param online_replication_start_time: A value indicating the online IR start time.
    :type online_replication_start_time: str
    :param offline_replication_import_path: A value indicating the offline IR import path.
    :type offline_replication_import_path: str
    :param offline_replication_export_path: A value indicating the offline IR export path.
    :type offline_replication_export_path: str
    :param replication_port: A value indicating the recovery HTTPS port.
    :type replication_port: int
    :param allowed_authentication_type: A value indicating the authentication type.
    :type allowed_authentication_type: int
    :param replica_deletion: A value indicating whether the VM has to be auto deleted.
    :type replica_deletion: str
    :param replication_frequency_in_seconds: A value indicating the replication interval.
    :type replication_frequency_in_seconds: int
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_points': {'key': 'recoveryPoints', 'type': 'int'},
        'application_consistent_snapshot_frequency_in_hours': {'key': 'applicationConsistentSnapshotFrequencyInHours', 'type': 'int'},
        'compression': {'key': 'compression', 'type': 'str'},
        'initial_replication_method': {'key': 'initialReplicationMethod', 'type': 'str'},
        'online_replication_start_time': {'key': 'onlineReplicationStartTime', 'type': 'str'},
        'offline_replication_import_path': {'key': 'offlineReplicationImportPath', 'type': 'str'},
        'offline_replication_export_path': {'key': 'offlineReplicationExportPath', 'type': 'str'},
        'replication_port': {'key': 'replicationPort', 'type': 'int'},
        'allowed_authentication_type': {'key': 'allowedAuthenticationType', 'type': 'int'},
        'replica_deletion': {'key': 'replicaDeletion', 'type': 'str'},
        'replication_frequency_in_seconds': {'key': 'replicationFrequencyInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion: Optional[str] = None,
        replication_frequency_in_seconds: Optional[int] = None,
        **kwargs
    ):
        super(HyperVReplicaBluePolicyInput, self).__init__(recovery_points=recovery_points, application_consistent_snapshot_frequency_in_hours=application_consistent_snapshot_frequency_in_hours, compression=compression, initial_replication_method=initial_replication_method, online_replication_start_time=online_replication_start_time, offline_replication_import_path=offline_replication_import_path, offline_replication_export_path=offline_replication_export_path, replication_port=replication_port, allowed_authentication_type=allowed_authentication_type, replica_deletion=replica_deletion, **kwargs)
        self.instance_type = 'HyperVReplica2012R2'  # type: str
        self.replication_frequency_in_seconds = replication_frequency_in_seconds


class HyperVReplicaBlueReplicationDetails(ReplicationProviderSpecificSettings):
    """HyperV replica 2012 R2 (Blue) replication details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param last_replicated_time: The Last replication time.
    :type last_replicated_time: ~datetime.datetime
    :param vm_nics: The PE Network details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :param vm_id: The virtual machine Id.
    :type vm_id: str
    :param vm_protection_state: The protection state for the vm.
    :type vm_protection_state: str
    :param vm_protection_state_description: The protection state description for the vm.
    :type vm_protection_state_description: str
    :param initial_replication_details: Initial replication details.
    :type initial_replication_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :param v_m_disk_details: VM disk details.
    :type v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'last_replicated_time': {'key': 'lastReplicatedTime', 'type': 'iso-8601'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMNicDetails]'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'vm_protection_state': {'key': 'vmProtectionState', 'type': 'str'},
        'vm_protection_state_description': {'key': 'vmProtectionStateDescription', 'type': 'str'},
        'initial_replication_details': {'key': 'initialReplicationDetails', 'type': 'InitialReplicationDetails'},
        'v_m_disk_details': {'key': 'vMDiskDetails', 'type': '[DiskDetails]'},
    }

    def __init__(
        self,
        *,
        last_replicated_time: Optional[datetime.datetime] = None,
        vm_nics: Optional[List["VMNicDetails"]] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        initial_replication_details: Optional["InitialReplicationDetails"] = None,
        v_m_disk_details: Optional[List["DiskDetails"]] = None,
        **kwargs
    ):
        super(HyperVReplicaBlueReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplica2012R2'  # type: str
        self.last_replicated_time = last_replicated_time
        self.vm_nics = vm_nics
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.initial_replication_details = initial_replication_details
        self.v_m_disk_details = v_m_disk_details


class HyperVReplicaPolicyDetails(PolicyProviderSpecificDetails):
    """Hyper-V Replica Blue specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param recovery_points: A value indicating the number of recovery points.
    :type recovery_points: int
    :param application_consistent_snapshot_frequency_in_hours: A value indicating the application
     consistent frequency.
    :type application_consistent_snapshot_frequency_in_hours: int
    :param compression: A value indicating whether compression has to be enabled.
    :type compression: str
    :param initial_replication_method: A value indicating whether IR is online.
    :type initial_replication_method: str
    :param online_replication_start_time: A value indicating the online IR start time.
    :type online_replication_start_time: str
    :param offline_replication_import_path: A value indicating the offline IR import path.
    :type offline_replication_import_path: str
    :param offline_replication_export_path: A value indicating the offline IR export path.
    :type offline_replication_export_path: str
    :param replication_port: A value indicating the recovery HTTPS port.
    :type replication_port: int
    :param allowed_authentication_type: A value indicating the authentication type.
    :type allowed_authentication_type: int
    :param replica_deletion_option: A value indicating whether the VM has to be auto deleted.
     Supported Values: String.Empty, None, OnRecoveryCloud.
    :type replica_deletion_option: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_points': {'key': 'recoveryPoints', 'type': 'int'},
        'application_consistent_snapshot_frequency_in_hours': {'key': 'applicationConsistentSnapshotFrequencyInHours', 'type': 'int'},
        'compression': {'key': 'compression', 'type': 'str'},
        'initial_replication_method': {'key': 'initialReplicationMethod', 'type': 'str'},
        'online_replication_start_time': {'key': 'onlineReplicationStartTime', 'type': 'str'},
        'offline_replication_import_path': {'key': 'offlineReplicationImportPath', 'type': 'str'},
        'offline_replication_export_path': {'key': 'offlineReplicationExportPath', 'type': 'str'},
        'replication_port': {'key': 'replicationPort', 'type': 'int'},
        'allowed_authentication_type': {'key': 'allowedAuthenticationType', 'type': 'int'},
        'replica_deletion_option': {'key': 'replicaDeletionOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_points: Optional[int] = None,
        application_consistent_snapshot_frequency_in_hours: Optional[int] = None,
        compression: Optional[str] = None,
        initial_replication_method: Optional[str] = None,
        online_replication_start_time: Optional[str] = None,
        offline_replication_import_path: Optional[str] = None,
        offline_replication_export_path: Optional[str] = None,
        replication_port: Optional[int] = None,
        allowed_authentication_type: Optional[int] = None,
        replica_deletion_option: Optional[str] = None,
        **kwargs
    ):
        super(HyperVReplicaPolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplica2012'  # type: str
        self.recovery_points = recovery_points
        self.application_consistent_snapshot_frequency_in_hours = application_consistent_snapshot_frequency_in_hours
        self.compression = compression
        self.initial_replication_method = initial_replication_method
        self.online_replication_start_time = online_replication_start_time
        self.offline_replication_import_path = offline_replication_import_path
        self.offline_replication_export_path = offline_replication_export_path
        self.replication_port = replication_port
        self.allowed_authentication_type = allowed_authentication_type
        self.replica_deletion_option = replica_deletion_option


class HyperVReplicaReplicationDetails(ReplicationProviderSpecificSettings):
    """HyperV replica 2012 replication details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param last_replicated_time: The Last replication time.
    :type last_replicated_time: ~datetime.datetime
    :param vm_nics: The PE Network details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :param vm_id: The virtual machine Id.
    :type vm_id: str
    :param vm_protection_state: The protection state for the vm.
    :type vm_protection_state: str
    :param vm_protection_state_description: The protection state description for the vm.
    :type vm_protection_state_description: str
    :param initial_replication_details: Initial replication details.
    :type initial_replication_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :param v_m_disk_details: VM disk details.
    :type v_m_disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'last_replicated_time': {'key': 'lastReplicatedTime', 'type': 'iso-8601'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMNicDetails]'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'vm_protection_state': {'key': 'vmProtectionState', 'type': 'str'},
        'vm_protection_state_description': {'key': 'vmProtectionStateDescription', 'type': 'str'},
        'initial_replication_details': {'key': 'initialReplicationDetails', 'type': 'InitialReplicationDetails'},
        'v_m_disk_details': {'key': 'vMDiskDetails', 'type': '[DiskDetails]'},
    }

    def __init__(
        self,
        *,
        last_replicated_time: Optional[datetime.datetime] = None,
        vm_nics: Optional[List["VMNicDetails"]] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        initial_replication_details: Optional["InitialReplicationDetails"] = None,
        v_m_disk_details: Optional[List["DiskDetails"]] = None,
        **kwargs
    ):
        super(HyperVReplicaReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplica2012'  # type: str
        self.last_replicated_time = last_replicated_time
        self.vm_nics = vm_nics
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.initial_replication_details = initial_replication_details
        self.v_m_disk_details = v_m_disk_details


class HyperVSiteDetails(FabricSpecificDetails):
    """HyperVSite fabric specific details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param hyper_v_hosts: The list of Hyper-V hosts associated with the fabric.
    :type hyper_v_hosts: list[~azure.mgmt.recoveryservicessiterecovery.models.HyperVHostDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'hyper_v_hosts': {'key': 'hyperVHosts', 'type': '[HyperVHostDetails]'},
    }

    def __init__(
        self,
        *,
        hyper_v_hosts: Optional[List["HyperVHostDetails"]] = None,
        **kwargs
    ):
        super(HyperVSiteDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVSite'  # type: str
        self.hyper_v_hosts = hyper_v_hosts


class HyperVVirtualMachineDetails(ConfigurationSettings):
    """Single Host fabric provider specific VM settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VmmVirtualMachineDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param source_item_id: The source id of the object.
    :type source_item_id: str
    :param generation: The id of the object in fabric.
    :type generation: str
    :param os_details: The Last replication time.
    :type os_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDetails
    :param disk_details: The Last successful failover time.
    :type disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    :param has_physical_disk: A value indicating whether the VM has a physical disk attached.
     String value of SrsDataContract.PresenceStatus enum. Possible values include: "Unknown",
     "Present", "NotPresent".
    :type has_physical_disk: str or ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    :param has_fibre_channel_adapter: A value indicating whether the VM has a fibre channel adapter
     attached. String value of SrsDataContract.PresenceStatus enum. Possible values include:
     "Unknown", "Present", "NotPresent".
    :type has_fibre_channel_adapter: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    :param has_shared_vhd: A value indicating whether the VM has a shared VHD attached. String
     value of SrsDataContract.PresenceStatus enum. Possible values include: "Unknown", "Present",
     "NotPresent".
    :type has_shared_vhd: str or ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'source_item_id': {'key': 'sourceItemId', 'type': 'str'},
        'generation': {'key': 'generation', 'type': 'str'},
        'os_details': {'key': 'osDetails', 'type': 'OSDetails'},
        'disk_details': {'key': 'diskDetails', 'type': '[DiskDetails]'},
        'has_physical_disk': {'key': 'hasPhysicalDisk', 'type': 'str'},
        'has_fibre_channel_adapter': {'key': 'hasFibreChannelAdapter', 'type': 'str'},
        'has_shared_vhd': {'key': 'hasSharedVhd', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'VmmVirtualMachine': 'VmmVirtualMachineDetails'}
    }

    def __init__(
        self,
        *,
        source_item_id: Optional[str] = None,
        generation: Optional[str] = None,
        os_details: Optional["OSDetails"] = None,
        disk_details: Optional[List["DiskDetails"]] = None,
        has_physical_disk: Optional[Union[str, "PresenceStatus"]] = None,
        has_fibre_channel_adapter: Optional[Union[str, "PresenceStatus"]] = None,
        has_shared_vhd: Optional[Union[str, "PresenceStatus"]] = None,
        **kwargs
    ):
        super(HyperVVirtualMachineDetails, self).__init__(**kwargs)
        self.instance_type = 'HyperVVirtualMachine'  # type: str
        self.source_item_id = source_item_id
        self.generation = generation
        self.os_details = os_details
        self.disk_details = disk_details
        self.has_physical_disk = has_physical_disk
        self.has_fibre_channel_adapter = has_fibre_channel_adapter
        self.has_shared_vhd = has_shared_vhd


class IdentityProviderDetails(msrest.serialization.Model):
    """Identity provider details.

    :param tenant_id: The tenant Id for the service principal with which the on-premise
     management/data plane components would communicate with our Azure services.
    :type tenant_id: str
    :param application_id: The application/client Id for the service principal with which the
     on-premise management/data plane components would communicate with our Azure services.
    :type application_id: str
    :param object_id: The object Id of the service principal with which the on-premise
     management/data plane components would communicate with our Azure services.
    :type object_id: str
    :param audience: The intended Audience of the service principal with which the on-premise
     management/data plane components would communicate with our Azure services.
    :type audience: str
    :param aad_authority: The base authority for Azure Active Directory authentication.
    :type aad_authority: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
        'aad_authority': {'key': 'aadAuthority', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        application_id: Optional[str] = None,
        object_id: Optional[str] = None,
        audience: Optional[str] = None,
        aad_authority: Optional[str] = None,
        **kwargs
    ):
        super(IdentityProviderDetails, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.application_id = application_id
        self.object_id = object_id
        self.audience = audience
        self.aad_authority = aad_authority


class IdentityProviderInput(msrest.serialization.Model):
    """Identity provider input.

    All required parameters must be populated in order to send to Azure.

    :param tenant_id: Required. The tenant Id for the service principal with which the on-premise
     management/data plane components would communicate with our Azure services.
    :type tenant_id: str
    :param application_id: Required. The application/client Id for the service principal with which
     the on-premise management/data plane components would communicate with our Azure services.
    :type application_id: str
    :param object_id: Required. The object Id of the service principal with which the on-premise
     management/data plane components would communicate with our Azure services.
    :type object_id: str
    :param audience: Required. The intended Audience of the service principal with which the
     on-premise management/data plane components would communicate with our Azure services.
    :type audience: str
    :param aad_authority: Required. The base authority for Azure Active Directory authentication.
    :type aad_authority: str
    """

    _validation = {
        'tenant_id': {'required': True},
        'application_id': {'required': True},
        'object_id': {'required': True},
        'audience': {'required': True},
        'aad_authority': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
        'aad_authority': {'key': 'aadAuthority', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        application_id: str,
        object_id: str,
        audience: str,
        aad_authority: str,
        **kwargs
    ):
        super(IdentityProviderInput, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.application_id = application_id
        self.object_id = object_id
        self.audience = audience
        self.aad_authority = aad_authority


class InconsistentVmDetails(msrest.serialization.Model):
    """This class stores the monitoring details for consistency check of inconsistent Protected Entity.

    :param vm_name: The Vm name.
    :type vm_name: str
    :param cloud_name: The Cloud name.
    :type cloud_name: str
    :param details: The list of details regarding state of the Protected Entity in SRS and On prem.
    :type details: list[str]
    :param error_ids: The list of error ids.
    :type error_ids: list[str]
    """

    _attribute_map = {
        'vm_name': {'key': 'vmName', 'type': 'str'},
        'cloud_name': {'key': 'cloudName', 'type': 'str'},
        'details': {'key': 'details', 'type': '[str]'},
        'error_ids': {'key': 'errorIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        vm_name: Optional[str] = None,
        cloud_name: Optional[str] = None,
        details: Optional[List[str]] = None,
        error_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(InconsistentVmDetails, self).__init__(**kwargs)
        self.vm_name = vm_name
        self.cloud_name = cloud_name
        self.details = details
        self.error_ids = error_ids


class InitialReplicationDetails(msrest.serialization.Model):
    """Initial replication details.

    :param initial_replication_type: Initial replication type.
    :type initial_replication_type: str
    :param initial_replication_progress_percentage: The initial replication progress percentage.
    :type initial_replication_progress_percentage: str
    """

    _attribute_map = {
        'initial_replication_type': {'key': 'initialReplicationType', 'type': 'str'},
        'initial_replication_progress_percentage': {'key': 'initialReplicationProgressPercentage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        initial_replication_type: Optional[str] = None,
        initial_replication_progress_percentage: Optional[str] = None,
        **kwargs
    ):
        super(InitialReplicationDetails, self).__init__(**kwargs)
        self.initial_replication_type = initial_replication_type
        self.initial_replication_progress_percentage = initial_replication_progress_percentage


class InlineWorkflowTaskDetails(GroupTaskDetails):
    """This class represents the inline workflow task details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param child_tasks: The child tasks.
    :type child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    :param workflow_ids: The list of child workflow ids.
    :type workflow_ids: list[str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'child_tasks': {'key': 'childTasks', 'type': '[ASRTask]'},
        'workflow_ids': {'key': 'workflowIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        child_tasks: Optional[List["ASRTask"]] = None,
        workflow_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(InlineWorkflowTaskDetails, self).__init__(child_tasks=child_tasks, **kwargs)
        self.instance_type = 'InlineWorkflowTaskDetails'  # type: str
        self.workflow_ids = workflow_ids


class InMageAgentDetails(msrest.serialization.Model):
    """The details of the InMage agent.

    :param agent_version: The agent version.
    :type agent_version: str
    :param agent_update_status: A value indicating whether installed agent needs to be updated.
    :type agent_update_status: str
    :param post_update_reboot_status: A value indicating whether reboot is required after update is
     applied.
    :type post_update_reboot_status: str
    :param agent_expiry_date: Agent expiry date.
    :type agent_expiry_date: ~datetime.datetime
    """

    _attribute_map = {
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'agent_update_status': {'key': 'agentUpdateStatus', 'type': 'str'},
        'post_update_reboot_status': {'key': 'postUpdateRebootStatus', 'type': 'str'},
        'agent_expiry_date': {'key': 'agentExpiryDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        agent_version: Optional[str] = None,
        agent_update_status: Optional[str] = None,
        post_update_reboot_status: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(InMageAgentDetails, self).__init__(**kwargs)
        self.agent_version = agent_version
        self.agent_update_status = agent_update_status
        self.post_update_reboot_status = post_update_reboot_status
        self.agent_expiry_date = agent_expiry_date


class InMageAzureV2ApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to InMageAzureV2 provider.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageAzureV2ApplyRecoveryPointInput, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str


class InMageAzureV2DiskInputDetails(msrest.serialization.Model):
    """Disk input details.

    :param disk_id: The DiskId.
    :type disk_id: str
    :param log_storage_account_id: The LogStorageAccountId.
    :type log_storage_account_id: str
    :param disk_type: The DiskType. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :param disk_encryption_set_id: The DiskEncryptionSet ARM ID.
    :type disk_encryption_set_id: str
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        disk_type: Optional[Union[str, "DiskAccountType"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageAzureV2DiskInputDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.log_storage_account_id = log_storage_account_id
        self.disk_type = disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class InMageAzureV2EnableProtectionInput(EnableProtectionProviderSpecificInput):
    """VMware Azure specific enable protection input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param master_target_id: The Master target Id.
    :type master_target_id: str
    :param process_server_id: The Process Server Id.
    :type process_server_id: str
    :param storage_account_id: The storage account Id.
    :type storage_account_id: str
    :param run_as_account_id: The CS account Id.
    :type run_as_account_id: str
    :param multi_vm_group_id: The multi VM group Id.
    :type multi_vm_group_id: str
    :param multi_vm_group_name: The multi VM group name.
    :type multi_vm_group_name: str
    :param disks_to_include: The disks to include list.
    :type disks_to_include:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2DiskInputDetails]
    :param target_azure_network_id: The selected target Azure network Id.
    :type target_azure_network_id: str
    :param target_azure_subnet_id: The selected target Azure subnet Id.
    :type target_azure_subnet_id: str
    :param enable_rdp_on_target_option: The selected option to enable RDP\SSH on target VM after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :type enable_rdp_on_target_option: str
    :param target_azure_vm_name: The target azure VM Name.
    :type target_azure_vm_name: str
    :param log_storage_account_id: The storage account to be used for logging during replication.
    :type log_storage_account_id: str
    :param target_azure_v1_resource_group_id: The Id of the target resource group (for classic
     deployment) in which the failover VM is to be created.
    :type target_azure_v1_resource_group_id: str
    :param target_azure_v2_resource_group_id: The Id of the target resource group (for resource
     manager deployment) in which the failover VM is to be created.
    :type target_azure_v2_resource_group_id: str
    :param disk_type: The DiskType. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :param target_availability_set_id: The target availability set ARM Id for resource manager
     deployment.
    :type target_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The proximity placement group ARM Id.
    :type target_proximity_placement_group_id: str
    :param license_type: License type. Possible values include: "NotSpecified", "NoLicenseType",
     "WindowsServer".
    :type license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :param sql_server_license_type: The SQL Server license type. Possible values include:
     "NotSpecified", "NoLicenseType", "PAYG", "AHUB".
    :type sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :param target_vm_size: The target VM size.
    :type target_vm_size: str
    :param disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :type disk_encryption_set_id: str
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param seed_managed_disk_tags: The tags for the seed managed disks.
    :type seed_managed_disk_tags: dict[str, str]
    :param target_managed_disk_tags: The tags for the target managed disks.
    :type target_managed_disk_tags: dict[str, str]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'master_target_id': {'key': 'masterTargetId', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
        'multi_vm_group_id': {'key': 'multiVmGroupId', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'disks_to_include': {'key': 'disksToInclude', 'type': '[InMageAzureV2DiskInputDetails]'},
        'target_azure_network_id': {'key': 'targetAzureNetworkId', 'type': 'str'},
        'target_azure_subnet_id': {'key': 'targetAzureSubnetId', 'type': 'str'},
        'enable_rdp_on_target_option': {'key': 'enableRdpOnTargetOption', 'type': 'str'},
        'target_azure_vm_name': {'key': 'targetAzureVmName', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'target_azure_v1_resource_group_id': {'key': 'targetAzureV1ResourceGroupId', 'type': 'str'},
        'target_azure_v2_resource_group_id': {'key': 'targetAzureV2ResourceGroupId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'seed_managed_disk_tags': {'key': 'seedManagedDiskTags', 'type': '{str}'},
        'target_managed_disk_tags': {'key': 'targetManagedDiskTags', 'type': '{str}'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        master_target_id: Optional[str] = None,
        process_server_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        disks_to_include: Optional[List["InMageAzureV2DiskInputDetails"]] = None,
        target_azure_network_id: Optional[str] = None,
        target_azure_subnet_id: Optional[str] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        target_azure_vm_name: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        target_azure_v1_resource_group_id: Optional[str] = None,
        target_azure_v2_resource_group_id: Optional[str] = None,
        disk_type: Optional[Union[str, "DiskAccountType"]] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        license_type: Optional[Union[str, "LicenseType"]] = None,
        sql_server_license_type: Optional[Union[str, "SqlServerLicenseType"]] = None,
        target_vm_size: Optional[str] = None,
        disk_encryption_set_id: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(InMageAzureV2EnableProtectionInput, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.master_target_id = master_target_id
        self.process_server_id = process_server_id
        self.storage_account_id = storage_account_id
        self.run_as_account_id = run_as_account_id
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.disks_to_include = disks_to_include
        self.target_azure_network_id = target_azure_network_id
        self.target_azure_subnet_id = target_azure_subnet_id
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.target_azure_vm_name = target_azure_vm_name
        self.log_storage_account_id = log_storage_account_id
        self.target_azure_v1_resource_group_id = target_azure_v1_resource_group_id
        self.target_azure_v2_resource_group_id = target_azure_v2_resource_group_id
        self.disk_type = disk_type
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.target_vm_size = target_vm_size
        self.disk_encryption_set_id = disk_encryption_set_id
        self.target_vm_tags = target_vm_tags
        self.seed_managed_disk_tags = seed_managed_disk_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags


class InMageAzureV2EventDetails(EventProviderSpecificDetails):
    """Model class for event details of a VMwareAzureV2 event.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param event_type: InMage Event type. Takes one of the values of
     InMageDataContract.InMageMonitoringEventType.
    :type event_type: str
    :param category: InMage Event Category.
    :type category: str
    :param component: InMage Event Component.
    :type component: str
    :param corrective_action: Corrective Action string for the event.
    :type corrective_action: str
    :param details: InMage Event Details.
    :type details: str
    :param summary: InMage Event Summary.
    :type summary: str
    :param site_name: VMware Site name.
    :type site_name: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'component': {'key': 'component', 'type': 'str'},
        'corrective_action': {'key': 'correctiveAction', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'summary': {'key': 'summary', 'type': 'str'},
        'site_name': {'key': 'siteName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_type: Optional[str] = None,
        category: Optional[str] = None,
        component: Optional[str] = None,
        corrective_action: Optional[str] = None,
        details: Optional[str] = None,
        summary: Optional[str] = None,
        site_name: Optional[str] = None,
        **kwargs
    ):
        super(InMageAzureV2EventDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.event_type = event_type
        self.category = category
        self.component = component
        self.corrective_action = corrective_action
        self.details = details
        self.summary = summary
        self.site_name = site_name


class InMageAzureV2ManagedDiskDetails(msrest.serialization.Model):
    """InMageAzureV2 Managed disk details.

    :param disk_id: The disk id.
    :type disk_id: str
    :param seed_managed_disk_id: Seed managed disk Id.
    :type seed_managed_disk_id: str
    :param replica_disk_type: The replica disk type.
    :type replica_disk_type: str
    :param disk_encryption_set_id: The DiskEncryptionSet ARM ID.
    :type disk_encryption_set_id: str
    :param target_disk_name: The target disk name.
    :type target_disk_name: str
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'seed_managed_disk_id': {'key': 'seedManagedDiskId', 'type': 'str'},
        'replica_disk_type': {'key': 'replicaDiskType', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'target_disk_name': {'key': 'targetDiskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        seed_managed_disk_id: Optional[str] = None,
        replica_disk_type: Optional[str] = None,
        disk_encryption_set_id: Optional[str] = None,
        target_disk_name: Optional[str] = None,
        **kwargs
    ):
        super(InMageAzureV2ManagedDiskDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.seed_managed_disk_id = seed_managed_disk_id
        self.replica_disk_type = replica_disk_type
        self.disk_encryption_set_id = disk_encryption_set_id
        self.target_disk_name = target_disk_name


class InMageAzureV2PolicyDetails(PolicyProviderSpecificDetails):
    """InMage Azure v2 specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :type crash_consistent_frequency_in_minutes: int
    :param recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :type recovery_point_threshold_in_minutes: int
    :param recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :type recovery_point_history: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :type app_consistent_frequency_in_minutes: int
    :param multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
    :type multi_vm_sync_status: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
        'recovery_point_threshold_in_minutes': {'key': 'recoveryPointThresholdInMinutes', 'type': 'int'},
        'recovery_point_history': {'key': 'recoveryPointHistory', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        multi_vm_sync_status: Optional[str] = None,
        **kwargs
    ):
        super(InMageAzureV2PolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMageAzureV2PolicyInput(PolicyProviderSpecificInput):
    """VMWare Azure specific policy Input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :type recovery_point_threshold_in_minutes: int
    :param recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :type recovery_point_history: int
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :type crash_consistent_frequency_in_minutes: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :type app_consistent_frequency_in_minutes: int
    :param multi_vm_sync_status: Required. A value indicating whether multi-VM sync has to be
     enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: "Enable", "Disable".
    :type multi_vm_sync_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
    """

    _validation = {
        'instance_type': {'required': True},
        'multi_vm_sync_status': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_threshold_in_minutes': {'key': 'recoveryPointThresholdInMinutes', 'type': 'int'},
        'recovery_point_history': {'key': 'recoveryPointHistory', 'type': 'int'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        multi_vm_sync_status: Union[str, "SetMultiVmSyncStatus"],
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(InMageAzureV2PolicyInput, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMageAzureV2ProtectedDiskDetails(msrest.serialization.Model):
    """InMageAzureV2 protected disk details.

    :param disk_id: The disk id.
    :type disk_id: str
    :param disk_name: The disk name.
    :type disk_name: str
    :param protection_stage: The protection stage.
    :type protection_stage: str
    :param health_error_code: The health error code for the disk.
    :type health_error_code: str
    :param rpo_in_seconds: The RPO in seconds.
    :type rpo_in_seconds: long
    :param resync_required: A value indicating whether resync is required for this disk.
    :type resync_required: str
    :param resync_progress_percentage: The resync progress percentage.
    :type resync_progress_percentage: int
    :param resync_duration_in_seconds: The resync duration in seconds.
    :type resync_duration_in_seconds: long
    :param disk_capacity_in_bytes: The disk capacity in bytes.
    :type disk_capacity_in_bytes: long
    :param file_system_capacity_in_bytes: The disk file system capacity in bytes.
    :type file_system_capacity_in_bytes: long
    :param source_data_in_mega_bytes: The source data transit in MB.
    :type source_data_in_mega_bytes: float
    :param ps_data_in_mega_bytes: The PS data transit in MB.
    :type ps_data_in_mega_bytes: float
    :param target_data_in_mega_bytes: The target data transit in MB.
    :type target_data_in_mega_bytes: float
    :param disk_resized: A value indicating whether disk is resized.
    :type disk_resized: str
    :param last_rpo_calculated_time: The last RPO calculated time.
    :type last_rpo_calculated_time: ~datetime.datetime
    :param resync_processed_bytes: The resync processed bytes.
    :type resync_processed_bytes: long
    :param resync_total_transferred_bytes: The resync total transferred bytes.
    :type resync_total_transferred_bytes: long
    :param resync_last15_minutes_transferred_bytes: The resync last 15 minutes transferred bytes.
    :type resync_last15_minutes_transferred_bytes: long
    :param resync_last_data_transfer_time_utc: The last data transfer time in UTC.
    :type resync_last_data_transfer_time_utc: ~datetime.datetime
    :param resync_start_time: The resync start time.
    :type resync_start_time: ~datetime.datetime
    :param progress_health: The Progress Health.
    :type progress_health: str
    :param progress_status: The Progress Status.
    :type progress_status: str
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'protection_stage': {'key': 'protectionStage', 'type': 'str'},
        'health_error_code': {'key': 'healthErrorCode', 'type': 'str'},
        'rpo_in_seconds': {'key': 'rpoInSeconds', 'type': 'long'},
        'resync_required': {'key': 'resyncRequired', 'type': 'str'},
        'resync_progress_percentage': {'key': 'resyncProgressPercentage', 'type': 'int'},
        'resync_duration_in_seconds': {'key': 'resyncDurationInSeconds', 'type': 'long'},
        'disk_capacity_in_bytes': {'key': 'diskCapacityInBytes', 'type': 'long'},
        'file_system_capacity_in_bytes': {'key': 'fileSystemCapacityInBytes', 'type': 'long'},
        'source_data_in_mega_bytes': {'key': 'sourceDataInMegaBytes', 'type': 'float'},
        'ps_data_in_mega_bytes': {'key': 'psDataInMegaBytes', 'type': 'float'},
        'target_data_in_mega_bytes': {'key': 'targetDataInMegaBytes', 'type': 'float'},
        'disk_resized': {'key': 'diskResized', 'type': 'str'},
        'last_rpo_calculated_time': {'key': 'lastRpoCalculatedTime', 'type': 'iso-8601'},
        'resync_processed_bytes': {'key': 'resyncProcessedBytes', 'type': 'long'},
        'resync_total_transferred_bytes': {'key': 'resyncTotalTransferredBytes', 'type': 'long'},
        'resync_last15_minutes_transferred_bytes': {'key': 'resyncLast15MinutesTransferredBytes', 'type': 'long'},
        'resync_last_data_transfer_time_utc': {'key': 'resyncLastDataTransferTimeUTC', 'type': 'iso-8601'},
        'resync_start_time': {'key': 'resyncStartTime', 'type': 'iso-8601'},
        'progress_health': {'key': 'progressHealth', 'type': 'str'},
        'progress_status': {'key': 'progressStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        disk_name: Optional[str] = None,
        protection_stage: Optional[str] = None,
        health_error_code: Optional[str] = None,
        rpo_in_seconds: Optional[int] = None,
        resync_required: Optional[str] = None,
        resync_progress_percentage: Optional[int] = None,
        resync_duration_in_seconds: Optional[int] = None,
        disk_capacity_in_bytes: Optional[int] = None,
        file_system_capacity_in_bytes: Optional[int] = None,
        source_data_in_mega_bytes: Optional[float] = None,
        ps_data_in_mega_bytes: Optional[float] = None,
        target_data_in_mega_bytes: Optional[float] = None,
        disk_resized: Optional[str] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        resync_processed_bytes: Optional[int] = None,
        resync_total_transferred_bytes: Optional[int] = None,
        resync_last15_minutes_transferred_bytes: Optional[int] = None,
        resync_last_data_transfer_time_utc: Optional[datetime.datetime] = None,
        resync_start_time: Optional[datetime.datetime] = None,
        progress_health: Optional[str] = None,
        progress_status: Optional[str] = None,
        **kwargs
    ):
        super(InMageAzureV2ProtectedDiskDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.disk_name = disk_name
        self.protection_stage = protection_stage
        self.health_error_code = health_error_code
        self.rpo_in_seconds = rpo_in_seconds
        self.resync_required = resync_required
        self.resync_progress_percentage = resync_progress_percentage
        self.resync_duration_in_seconds = resync_duration_in_seconds
        self.disk_capacity_in_bytes = disk_capacity_in_bytes
        self.file_system_capacity_in_bytes = file_system_capacity_in_bytes
        self.source_data_in_mega_bytes = source_data_in_mega_bytes
        self.ps_data_in_mega_bytes = ps_data_in_mega_bytes
        self.target_data_in_mega_bytes = target_data_in_mega_bytes
        self.disk_resized = disk_resized
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.resync_processed_bytes = resync_processed_bytes
        self.resync_total_transferred_bytes = resync_total_transferred_bytes
        self.resync_last15_minutes_transferred_bytes = resync_last15_minutes_transferred_bytes
        self.resync_last_data_transfer_time_utc = resync_last_data_transfer_time_utc
        self.resync_start_time = resync_start_time
        self.progress_health = progress_health
        self.progress_status = progress_status


class InMageAzureV2RecoveryPointDetails(ProviderSpecificRecoveryPointDetails):
    """InMage Azure V2 provider specific recovery point details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the provider type.Constant filled by server.
    :type instance_type: str
    :param is_multi_vm_sync_point: A value indicating whether the recovery point is multi VM
     consistent.
    :type is_multi_vm_sync_point: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'is_multi_vm_sync_point': {'key': 'isMultiVmSyncPoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_multi_vm_sync_point: Optional[str] = None,
        **kwargs
    ):
        super(InMageAzureV2RecoveryPointDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.is_multi_vm_sync_point = is_multi_vm_sync_point


class InMageAzureV2ReplicationDetails(ReplicationProviderSpecificSettings):
    """InMageAzureV2 provider specific settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param infrastructure_vm_id: The infrastructure VM Id.
    :type infrastructure_vm_id: str
    :param v_center_infrastructure_id: The vCenter infrastructure Id.
    :type v_center_infrastructure_id: str
    :param protection_stage: The protection stage.
    :type protection_stage: str
    :param vm_id: The virtual machine Id.
    :type vm_id: str
    :param vm_protection_state: The protection state for the vm.
    :type vm_protection_state: str
    :param vm_protection_state_description: The protection state description for the vm.
    :type vm_protection_state_description: str
    :param resync_progress_percentage: The resync progress percentage.
    :type resync_progress_percentage: int
    :param rpo_in_seconds: The RPO in seconds.
    :type rpo_in_seconds: long
    :param compressed_data_rate_in_mb: The compressed data change rate in MB.
    :type compressed_data_rate_in_mb: float
    :param uncompressed_data_rate_in_mb: The uncompressed data change rate in MB.
    :type uncompressed_data_rate_in_mb: float
    :param ip_address: The source IP address.
    :type ip_address: str
    :param agent_version: The agent version.
    :type agent_version: str
    :param agent_expiry_date: Agent expiry date.
    :type agent_expiry_date: ~datetime.datetime
    :param is_agent_update_required: A value indicating whether installed agent needs to be
     updated.
    :type is_agent_update_required: str
    :param is_reboot_after_update_required: A value indicating whether the source server requires a
     restart after update.
    :type is_reboot_after_update_required: str
    :param last_heartbeat: The last heartbeat received from the source server.
    :type last_heartbeat: ~datetime.datetime
    :param process_server_id: The process server Id.
    :type process_server_id: str
    :param process_server_name: The process server name.
    :type process_server_name: str
    :param multi_vm_group_id: The multi vm group Id.
    :type multi_vm_group_id: str
    :param multi_vm_group_name: The multi vm group name.
    :type multi_vm_group_name: str
    :param multi_vm_sync_status: A value indicating whether multi vm sync is enabled or disabled.
    :type multi_vm_sync_status: str
    :param protected_disks: The list of protected disks.
    :type protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2ProtectedDiskDetails]
    :param disk_resized: A value indicating whether any disk is resized for this VM.
    :type disk_resized: str
    :param master_target_id: The master target Id.
    :type master_target_id: str
    :param source_vm_cpu_count: The CPU count of the VM on the primary side.
    :type source_vm_cpu_count: int
    :param source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
    :type source_vm_ram_size_in_mb: int
    :param os_type: The type of the OS on the VM.
    :type os_type: str
    :param vhd_name: The OS disk VHD name.
    :type vhd_name: str
    :param os_disk_id: The id of the disk containing the OS.
    :type os_disk_id: str
    :param azure_vm_disk_details: Azure VM Disk details.
    :type azure_vm_disk_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.AzureVmDiskDetails]
    :param recovery_azure_vm_name: Recovery Azure given name.
    :type recovery_azure_vm_name: str
    :param recovery_azure_vm_size: The Recovery Azure VM size.
    :type recovery_azure_vm_size: str
    :param recovery_azure_storage_account: The recovery Azure storage account.
    :type recovery_azure_storage_account: str
    :param recovery_azure_log_storage_account_id: The ARM id of the log storage account used for
     replication. This will be set to null if no log storage account was provided during enable
     protection.
    :type recovery_azure_log_storage_account_id: str
    :param vm_nics: The PE Network details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :param selected_recovery_azure_network_id: The selected recovery azure network Id.
    :type selected_recovery_azure_network_id: str
    :param selected_tfo_azure_network_id: The test failover virtual network.
    :type selected_tfo_azure_network_id: str
    :param selected_source_nic_id: The selected source nic Id which will be used as the primary nic
     during failover.
    :type selected_source_nic_id: str
    :param discovery_type: A value indicating the discovery type of the machine. Value can be
     vCenter or physical.
    :type discovery_type: str
    :param enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :type enable_rdp_on_target_option: str
    :param datastores: The datastores of the on-premise machine. Value can be list of strings that
     contain datastore names.
    :type datastores: list[str]
    :param target_vm_id: The ARM Id of the target Azure VM. This value will be null until the VM is
     failed over. Only after failure it will be populated with the ARM Id of the Azure VM.
    :type target_vm_id: str
    :param recovery_azure_resource_group_id: The target resource group Id.
    :type recovery_azure_resource_group_id: str
    :param recovery_availability_set_id: The recovery availability set Id.
    :type recovery_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The target proximity placement group Id.
    :type target_proximity_placement_group_id: str
    :param use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :type use_managed_disks: str
    :param license_type: License Type of the VM to be used.
    :type license_type: str
    :param sql_server_license_type: The SQL Server license type.
    :type sql_server_license_type: str
    :param validation_errors: The validation errors of the on-premise machine Value can be list of
     validation errors.
    :type validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param last_rpo_calculated_time: The last RPO calculated time.
    :type last_rpo_calculated_time: ~datetime.datetime
    :param last_update_received_time: The last update time received from on-prem components.
    :type last_update_received_time: ~datetime.datetime
    :param replica_id: The replica id of the protected item.
    :type replica_id: str
    :param os_version: The OS Version of the protected item.
    :type os_version: str
    :param protected_managed_disks: The list of protected managed disks.
    :type protected_managed_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageAzureV2ManagedDiskDetails]
    :ivar last_recovery_point_received: The last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :param firmware_type: The firmware type of this protected item.
    :type firmware_type: str
    :param azure_vm_generation: The target generation for this protected item.
    :type azure_vm_generation: str
    :param is_additional_stats_available: A value indicating whether additional IR stats are
     available or not.
    :type is_additional_stats_available: bool
    :param total_data_transferred: The total transferred data in bytes.
    :type total_data_transferred: long
    :param total_progress_health: The progress health.
    :type total_progress_health: str
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param seed_managed_disk_tags: The tags for the seed managed disks.
    :type seed_managed_disk_tags: dict[str, str]
    :param target_managed_disk_tags: The tags for the target managed disks.
    :type target_managed_disk_tags: dict[str, str]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    """

    _validation = {
        'instance_type': {'required': True},
        'last_recovery_point_received': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'infrastructure_vm_id': {'key': 'infrastructureVmId', 'type': 'str'},
        'v_center_infrastructure_id': {'key': 'vCenterInfrastructureId', 'type': 'str'},
        'protection_stage': {'key': 'protectionStage', 'type': 'str'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'vm_protection_state': {'key': 'vmProtectionState', 'type': 'str'},
        'vm_protection_state_description': {'key': 'vmProtectionStateDescription', 'type': 'str'},
        'resync_progress_percentage': {'key': 'resyncProgressPercentage', 'type': 'int'},
        'rpo_in_seconds': {'key': 'rpoInSeconds', 'type': 'long'},
        'compressed_data_rate_in_mb': {'key': 'compressedDataRateInMB', 'type': 'float'},
        'uncompressed_data_rate_in_mb': {'key': 'uncompressedDataRateInMB', 'type': 'float'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'agent_expiry_date': {'key': 'agentExpiryDate', 'type': 'iso-8601'},
        'is_agent_update_required': {'key': 'isAgentUpdateRequired', 'type': 'str'},
        'is_reboot_after_update_required': {'key': 'isRebootAfterUpdateRequired', 'type': 'str'},
        'last_heartbeat': {'key': 'lastHeartbeat', 'type': 'iso-8601'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'process_server_name': {'key': 'processServerName', 'type': 'str'},
        'multi_vm_group_id': {'key': 'multiVmGroupId', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
        'protected_disks': {'key': 'protectedDisks', 'type': '[InMageAzureV2ProtectedDiskDetails]'},
        'disk_resized': {'key': 'diskResized', 'type': 'str'},
        'master_target_id': {'key': 'masterTargetId', 'type': 'str'},
        'source_vm_cpu_count': {'key': 'sourceVmCpuCount', 'type': 'int'},
        'source_vm_ram_size_in_mb': {'key': 'sourceVmRamSizeInMB', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vhd_name': {'key': 'vhdName', 'type': 'str'},
        'os_disk_id': {'key': 'osDiskId', 'type': 'str'},
        'azure_vm_disk_details': {'key': 'azureVMDiskDetails', 'type': '[AzureVmDiskDetails]'},
        'recovery_azure_vm_name': {'key': 'recoveryAzureVMName', 'type': 'str'},
        'recovery_azure_vm_size': {'key': 'recoveryAzureVMSize', 'type': 'str'},
        'recovery_azure_storage_account': {'key': 'recoveryAzureStorageAccount', 'type': 'str'},
        'recovery_azure_log_storage_account_id': {'key': 'recoveryAzureLogStorageAccountId', 'type': 'str'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMNicDetails]'},
        'selected_recovery_azure_network_id': {'key': 'selectedRecoveryAzureNetworkId', 'type': 'str'},
        'selected_tfo_azure_network_id': {'key': 'selectedTfoAzureNetworkId', 'type': 'str'},
        'selected_source_nic_id': {'key': 'selectedSourceNicId', 'type': 'str'},
        'discovery_type': {'key': 'discoveryType', 'type': 'str'},
        'enable_rdp_on_target_option': {'key': 'enableRdpOnTargetOption', 'type': 'str'},
        'datastores': {'key': 'datastores', 'type': '[str]'},
        'target_vm_id': {'key': 'targetVmId', 'type': 'str'},
        'recovery_azure_resource_group_id': {'key': 'recoveryAzureResourceGroupId', 'type': 'str'},
        'recovery_availability_set_id': {'key': 'recoveryAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'use_managed_disks': {'key': 'useManagedDisks', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'validation_errors': {'key': 'validationErrors', 'type': '[HealthError]'},
        'last_rpo_calculated_time': {'key': 'lastRpoCalculatedTime', 'type': 'iso-8601'},
        'last_update_received_time': {'key': 'lastUpdateReceivedTime', 'type': 'iso-8601'},
        'replica_id': {'key': 'replicaId', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'protected_managed_disks': {'key': 'protectedManagedDisks', 'type': '[InMageAzureV2ManagedDiskDetails]'},
        'last_recovery_point_received': {'key': 'lastRecoveryPointReceived', 'type': 'iso-8601'},
        'firmware_type': {'key': 'firmwareType', 'type': 'str'},
        'azure_vm_generation': {'key': 'azureVmGeneration', 'type': 'str'},
        'is_additional_stats_available': {'key': 'isAdditionalStatsAvailable', 'type': 'bool'},
        'total_data_transferred': {'key': 'totalDataTransferred', 'type': 'long'},
        'total_progress_health': {'key': 'totalProgressHealth', 'type': 'str'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'seed_managed_disk_tags': {'key': 'seedManagedDiskTags', 'type': '{str}'},
        'target_managed_disk_tags': {'key': 'targetManagedDiskTags', 'type': '{str}'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        infrastructure_vm_id: Optional[str] = None,
        v_center_infrastructure_id: Optional[str] = None,
        protection_stage: Optional[str] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        resync_progress_percentage: Optional[int] = None,
        rpo_in_seconds: Optional[int] = None,
        compressed_data_rate_in_mb: Optional[float] = None,
        uncompressed_data_rate_in_mb: Optional[float] = None,
        ip_address: Optional[str] = None,
        agent_version: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        is_agent_update_required: Optional[str] = None,
        is_reboot_after_update_required: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        process_server_id: Optional[str] = None,
        process_server_name: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_sync_status: Optional[str] = None,
        protected_disks: Optional[List["InMageAzureV2ProtectedDiskDetails"]] = None,
        disk_resized: Optional[str] = None,
        master_target_id: Optional[str] = None,
        source_vm_cpu_count: Optional[int] = None,
        source_vm_ram_size_in_mb: Optional[int] = None,
        os_type: Optional[str] = None,
        vhd_name: Optional[str] = None,
        os_disk_id: Optional[str] = None,
        azure_vm_disk_details: Optional[List["AzureVmDiskDetails"]] = None,
        recovery_azure_vm_name: Optional[str] = None,
        recovery_azure_vm_size: Optional[str] = None,
        recovery_azure_storage_account: Optional[str] = None,
        recovery_azure_log_storage_account_id: Optional[str] = None,
        vm_nics: Optional[List["VMNicDetails"]] = None,
        selected_recovery_azure_network_id: Optional[str] = None,
        selected_tfo_azure_network_id: Optional[str] = None,
        selected_source_nic_id: Optional[str] = None,
        discovery_type: Optional[str] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        datastores: Optional[List[str]] = None,
        target_vm_id: Optional[str] = None,
        recovery_azure_resource_group_id: Optional[str] = None,
        recovery_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        license_type: Optional[str] = None,
        sql_server_license_type: Optional[str] = None,
        validation_errors: Optional[List["HealthError"]] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        last_update_received_time: Optional[datetime.datetime] = None,
        replica_id: Optional[str] = None,
        os_version: Optional[str] = None,
        protected_managed_disks: Optional[List["InMageAzureV2ManagedDiskDetails"]] = None,
        firmware_type: Optional[str] = None,
        azure_vm_generation: Optional[str] = None,
        is_additional_stats_available: Optional[bool] = None,
        total_data_transferred: Optional[int] = None,
        total_progress_health: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(InMageAzureV2ReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.infrastructure_vm_id = infrastructure_vm_id
        self.v_center_infrastructure_id = v_center_infrastructure_id
        self.protection_stage = protection_stage
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.resync_progress_percentage = resync_progress_percentage
        self.rpo_in_seconds = rpo_in_seconds
        self.compressed_data_rate_in_mb = compressed_data_rate_in_mb
        self.uncompressed_data_rate_in_mb = uncompressed_data_rate_in_mb
        self.ip_address = ip_address
        self.agent_version = agent_version
        self.agent_expiry_date = agent_expiry_date
        self.is_agent_update_required = is_agent_update_required
        self.is_reboot_after_update_required = is_reboot_after_update_required
        self.last_heartbeat = last_heartbeat
        self.process_server_id = process_server_id
        self.process_server_name = process_server_name
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_sync_status = multi_vm_sync_status
        self.protected_disks = protected_disks
        self.disk_resized = disk_resized
        self.master_target_id = master_target_id
        self.source_vm_cpu_count = source_vm_cpu_count
        self.source_vm_ram_size_in_mb = source_vm_ram_size_in_mb
        self.os_type = os_type
        self.vhd_name = vhd_name
        self.os_disk_id = os_disk_id
        self.azure_vm_disk_details = azure_vm_disk_details
        self.recovery_azure_vm_name = recovery_azure_vm_name
        self.recovery_azure_vm_size = recovery_azure_vm_size
        self.recovery_azure_storage_account = recovery_azure_storage_account
        self.recovery_azure_log_storage_account_id = recovery_azure_log_storage_account_id
        self.vm_nics = vm_nics
        self.selected_recovery_azure_network_id = selected_recovery_azure_network_id
        self.selected_tfo_azure_network_id = selected_tfo_azure_network_id
        self.selected_source_nic_id = selected_source_nic_id
        self.discovery_type = discovery_type
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.datastores = datastores
        self.target_vm_id = target_vm_id
        self.recovery_azure_resource_group_id = recovery_azure_resource_group_id
        self.recovery_availability_set_id = recovery_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.use_managed_disks = use_managed_disks
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.validation_errors = validation_errors
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.last_update_received_time = last_update_received_time
        self.replica_id = replica_id
        self.os_version = os_version
        self.protected_managed_disks = protected_managed_disks
        self.last_recovery_point_received = None
        self.firmware_type = firmware_type
        self.azure_vm_generation = azure_vm_generation
        self.is_additional_stats_available = is_additional_stats_available
        self.total_data_transferred = total_data_transferred
        self.total_progress_health = total_progress_health
        self.target_vm_tags = target_vm_tags
        self.seed_managed_disk_tags = seed_managed_disk_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags


class InMageAzureV2ReprotectInput(ReverseReplicationProviderSpecificInput):
    """InMageAzureV2 specific provider input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param master_target_id: The Master target Id.
    :type master_target_id: str
    :param process_server_id: The Process Server Id.
    :type process_server_id: str
    :param storage_account_id: The storage account id.
    :type storage_account_id: str
    :param run_as_account_id: The CS account Id.
    :type run_as_account_id: str
    :param policy_id: The Policy Id.
    :type policy_id: str
    :param log_storage_account_id: The storage account to be used for logging during replication.
    :type log_storage_account_id: str
    :param disks_to_include: The disks to include list.
    :type disks_to_include: list[str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'master_target_id': {'key': 'masterTargetId', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'disks_to_include': {'key': 'disksToInclude', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        master_target_id: Optional[str] = None,
        process_server_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        log_storage_account_id: Optional[str] = None,
        disks_to_include: Optional[List[str]] = None,
        **kwargs
    ):
        super(InMageAzureV2ReprotectInput, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.master_target_id = master_target_id
        self.process_server_id = process_server_id
        self.storage_account_id = storage_account_id
        self.run_as_account_id = run_as_account_id
        self.policy_id = policy_id
        self.log_storage_account_id = log_storage_account_id
        self.disks_to_include = disks_to_include


class InMageAzureV2TestFailoverInput(TestFailoverProviderSpecificInput):
    """InMageAzureV2 provider specific input for test failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageAzureV2TestFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.recovery_point_id = recovery_point_id


class InMageAzureV2UnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """InMageAzureV2 provider specific input for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageAzureV2UnplannedFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.recovery_point_id = recovery_point_id


class InMageAzureV2UpdateReplicationProtectedItemInput(UpdateReplicationProtectedItemProviderInput):
    """InMage Azure V2 input to update replication protected item.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_azure_v1_resource_group_id: The recovery Azure resource group Id for classic
     deployment.
    :type recovery_azure_v1_resource_group_id: str
    :param recovery_azure_v2_resource_group_id: The recovery Azure resource group Id for resource
     manager deployment.
    :type recovery_azure_v2_resource_group_id: str
    :param use_managed_disks: A value indicating whether managed disks should be used during
     failover.
    :type use_managed_disks: str
    :param target_proximity_placement_group_id: The target proximity placement group Id.
    :type target_proximity_placement_group_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param target_managed_disk_tags: The tags for the target managed disks.
    :type target_managed_disk_tags: dict[str, str]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    :param sql_server_license_type: The SQL Server license type. Possible values include:
     "NotSpecified", "NoLicenseType", "PAYG", "AHUB".
    :type sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :param vm_disks: The list of disk update properties.
    :type vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.UpdateDiskInput]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_azure_v1_resource_group_id': {'key': 'recoveryAzureV1ResourceGroupId', 'type': 'str'},
        'recovery_azure_v2_resource_group_id': {'key': 'recoveryAzureV2ResourceGroupId', 'type': 'str'},
        'use_managed_disks': {'key': 'useManagedDisks', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'target_managed_disk_tags': {'key': 'targetManagedDiskTags', 'type': '{str}'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'vm_disks': {'key': 'vmDisks', 'type': '[UpdateDiskInput]'},
    }

    def __init__(
        self,
        *,
        recovery_azure_v1_resource_group_id: Optional[str] = None,
        recovery_azure_v2_resource_group_id: Optional[str] = None,
        use_managed_disks: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        target_managed_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        sql_server_license_type: Optional[Union[str, "SqlServerLicenseType"]] = None,
        vm_disks: Optional[List["UpdateDiskInput"]] = None,
        **kwargs
    ):
        super(InMageAzureV2UpdateReplicationProtectedItemInput, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.recovery_azure_v1_resource_group_id = recovery_azure_v1_resource_group_id
        self.recovery_azure_v2_resource_group_id = recovery_azure_v2_resource_group_id
        self.use_managed_disks = use_managed_disks
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_availability_zone = target_availability_zone
        self.target_vm_tags = target_vm_tags
        self.target_managed_disk_tags = target_managed_disk_tags
        self.target_nic_tags = target_nic_tags
        self.sql_server_license_type = sql_server_license_type
        self.vm_disks = vm_disks


class InMageBasePolicyDetails(PolicyProviderSpecificDetails):
    """Base class for the policies of providers using InMage replication.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :type recovery_point_threshold_in_minutes: int
    :param recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :type recovery_point_history: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :type app_consistent_frequency_in_minutes: int
    :param multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
    :type multi_vm_sync_status: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_threshold_in_minutes': {'key': 'recoveryPointThresholdInMinutes', 'type': 'int'},
        'recovery_point_history': {'key': 'recoveryPointHistory', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        multi_vm_sync_status: Optional[str] = None,
        **kwargs
    ):
        super(InMageBasePolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageBasePolicyDetails'  # type: str
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMageDisableProtectionProviderSpecificInput(DisableProtectionProviderSpecificInput):
    """InMage disable protection provider specific input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param replica_vm_deletion_status: A value indicating whether the replica VM should be
     destroyed or retained. Values from Delete and Retain.
    :type replica_vm_deletion_status: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'replica_vm_deletion_status': {'key': 'replicaVmDeletionStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        replica_vm_deletion_status: Optional[str] = None,
        **kwargs
    ):
        super(InMageDisableProtectionProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.replica_vm_deletion_status = replica_vm_deletion_status


class InMageDiskDetails(msrest.serialization.Model):
    """VMware/Physical specific Disk Details.

    :param disk_id: The disk Id.
    :type disk_id: str
    :param disk_name: The disk name.
    :type disk_name: str
    :param disk_size_in_mb: The disk size in MB.
    :type disk_size_in_mb: str
    :param disk_type: Whether disk is system disk or data disk.
    :type disk_type: str
    :param disk_configuration: Whether disk is dynamic disk or basic disk.
    :type disk_configuration: str
    :param volume_list: Volumes of the disk.
    :type volume_list: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskVolumeDetails]
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'disk_size_in_mb': {'key': 'diskSizeInMB', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'disk_configuration': {'key': 'diskConfiguration', 'type': 'str'},
        'volume_list': {'key': 'volumeList', 'type': '[DiskVolumeDetails]'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        disk_name: Optional[str] = None,
        disk_size_in_mb: Optional[str] = None,
        disk_type: Optional[str] = None,
        disk_configuration: Optional[str] = None,
        volume_list: Optional[List["DiskVolumeDetails"]] = None,
        **kwargs
    ):
        super(InMageDiskDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.disk_name = disk_name
        self.disk_size_in_mb = disk_size_in_mb
        self.disk_type = disk_type
        self.disk_configuration = disk_configuration
        self.volume_list = volume_list


class InMageDiskExclusionInput(msrest.serialization.Model):
    """DiskExclusionInput when doing enable protection of virtual machine in InMage provider.

    :param volume_options: The volume label based option for disk exclusion.
    :type volume_options:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageVolumeExclusionOptions]
    :param disk_signature_options: The guest disk signature based option for disk exclusion.
    :type disk_signature_options:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskSignatureExclusionOptions]
    """

    _attribute_map = {
        'volume_options': {'key': 'volumeOptions', 'type': '[InMageVolumeExclusionOptions]'},
        'disk_signature_options': {'key': 'diskSignatureOptions', 'type': '[InMageDiskSignatureExclusionOptions]'},
    }

    def __init__(
        self,
        *,
        volume_options: Optional[List["InMageVolumeExclusionOptions"]] = None,
        disk_signature_options: Optional[List["InMageDiskSignatureExclusionOptions"]] = None,
        **kwargs
    ):
        super(InMageDiskExclusionInput, self).__init__(**kwargs)
        self.volume_options = volume_options
        self.disk_signature_options = disk_signature_options


class InMageDiskSignatureExclusionOptions(msrest.serialization.Model):
    """Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider.

    :param disk_signature: The guest signature of disk to be excluded from replication.
    :type disk_signature: str
    """

    _attribute_map = {
        'disk_signature': {'key': 'diskSignature', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_signature: Optional[str] = None,
        **kwargs
    ):
        super(InMageDiskSignatureExclusionOptions, self).__init__(**kwargs)
        self.disk_signature = disk_signature


class InMageEnableProtectionInput(EnableProtectionProviderSpecificInput):
    """VMware Azure specific enable protection input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param vm_friendly_name: The VM Name.
    :type vm_friendly_name: str
    :param master_target_id: Required. The Master Target Id.
    :type master_target_id: str
    :param process_server_id: Required. The Process Server Id.
    :type process_server_id: str
    :param retention_drive: Required. The retention drive to use on the MT.
    :type retention_drive: str
    :param run_as_account_id: The CS account Id.
    :type run_as_account_id: str
    :param multi_vm_group_id: Required. The multi VM group Id.
    :type multi_vm_group_id: str
    :param multi_vm_group_name: Required. The multi VM group name.
    :type multi_vm_group_name: str
    :param datastore_name: The target datastore name.
    :type datastore_name: str
    :param disk_exclusion_input: The enable disk exclusion input.
    :type disk_exclusion_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskExclusionInput
    :param disks_to_include: The disks to include list.
    :type disks_to_include: list[str]
    """

    _validation = {
        'instance_type': {'required': True},
        'master_target_id': {'required': True},
        'process_server_id': {'required': True},
        'retention_drive': {'required': True},
        'multi_vm_group_id': {'required': True},
        'multi_vm_group_name': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vm_friendly_name': {'key': 'vmFriendlyName', 'type': 'str'},
        'master_target_id': {'key': 'masterTargetId', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'retention_drive': {'key': 'retentionDrive', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
        'multi_vm_group_id': {'key': 'multiVmGroupId', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'datastore_name': {'key': 'datastoreName', 'type': 'str'},
        'disk_exclusion_input': {'key': 'diskExclusionInput', 'type': 'InMageDiskExclusionInput'},
        'disks_to_include': {'key': 'disksToInclude', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        master_target_id: str,
        process_server_id: str,
        retention_drive: str,
        multi_vm_group_id: str,
        multi_vm_group_name: str,
        vm_friendly_name: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        datastore_name: Optional[str] = None,
        disk_exclusion_input: Optional["InMageDiskExclusionInput"] = None,
        disks_to_include: Optional[List[str]] = None,
        **kwargs
    ):
        super(InMageEnableProtectionInput, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.vm_friendly_name = vm_friendly_name
        self.master_target_id = master_target_id
        self.process_server_id = process_server_id
        self.retention_drive = retention_drive
        self.run_as_account_id = run_as_account_id
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.datastore_name = datastore_name
        self.disk_exclusion_input = disk_exclusion_input
        self.disks_to_include = disks_to_include


class InMagePolicyDetails(PolicyProviderSpecificDetails):
    """InMage specific protection profile details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :type recovery_point_threshold_in_minutes: int
    :param recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :type recovery_point_history: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :type app_consistent_frequency_in_minutes: int
    :param multi_vm_sync_status: A value indicating whether multi-VM sync has to be enabled.
    :type multi_vm_sync_status: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_threshold_in_minutes': {'key': 'recoveryPointThresholdInMinutes', 'type': 'int'},
        'recovery_point_history': {'key': 'recoveryPointHistory', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        multi_vm_sync_status: Optional[str] = None,
        **kwargs
    ):
        super(InMagePolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMagePolicyInput(PolicyProviderSpecificInput):
    """VMWare Azure specific protection profile Input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_threshold_in_minutes: The recovery point threshold in minutes.
    :type recovery_point_threshold_in_minutes: int
    :param recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :type recovery_point_history: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :type app_consistent_frequency_in_minutes: int
    :param multi_vm_sync_status: Required. A value indicating whether multi-VM sync has to be
     enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: "Enable", "Disable".
    :type multi_vm_sync_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
    """

    _validation = {
        'instance_type': {'required': True},
        'multi_vm_sync_status': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_threshold_in_minutes': {'key': 'recoveryPointThresholdInMinutes', 'type': 'int'},
        'recovery_point_history': {'key': 'recoveryPointHistory', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        multi_vm_sync_status: Union[str, "SetMultiVmSyncStatus"],
        recovery_point_threshold_in_minutes: Optional[int] = None,
        recovery_point_history: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(InMagePolicyInput, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.recovery_point_threshold_in_minutes = recovery_point_threshold_in_minutes
        self.recovery_point_history = recovery_point_history
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class InMageProtectedDiskDetails(msrest.serialization.Model):
    """InMage protected disk details.

    :param disk_id: The disk id.
    :type disk_id: str
    :param disk_name: The disk name.
    :type disk_name: str
    :param protection_stage: The protection stage.
    :type protection_stage: str
    :param health_error_code: The health error code for the disk.
    :type health_error_code: str
    :param rpo_in_seconds: The RPO in seconds.
    :type rpo_in_seconds: long
    :param resync_required: A value indicating whether resync is required for this disk.
    :type resync_required: str
    :param resync_progress_percentage: The resync progress percentage.
    :type resync_progress_percentage: int
    :param resync_duration_in_seconds: The resync duration in seconds.
    :type resync_duration_in_seconds: long
    :param disk_capacity_in_bytes: The disk capacity in bytes.
    :type disk_capacity_in_bytes: long
    :param file_system_capacity_in_bytes: The file system capacity in bytes.
    :type file_system_capacity_in_bytes: long
    :param source_data_in_mb: The source data transit in MB.
    :type source_data_in_mb: float
    :param ps_data_in_mb: The PS data transit in MB.
    :type ps_data_in_mb: float
    :param target_data_in_mb: The target data transit in MB.
    :type target_data_in_mb: float
    :param disk_resized: A value indicating whether disk is resized.
    :type disk_resized: str
    :param last_rpo_calculated_time: The last RPO calculated time.
    :type last_rpo_calculated_time: ~datetime.datetime
    :param resync_processed_bytes: The resync processed bytes.
    :type resync_processed_bytes: long
    :param resync_total_transferred_bytes: The resync total transferred bytes.
    :type resync_total_transferred_bytes: long
    :param resync_last15_minutes_transferred_bytes: The resync last 15 minutes transferred bytes.
    :type resync_last15_minutes_transferred_bytes: long
    :param resync_last_data_transfer_time_utc: The last data transfer time in UTC.
    :type resync_last_data_transfer_time_utc: ~datetime.datetime
    :param resync_start_time: The resync start time.
    :type resync_start_time: ~datetime.datetime
    :param progress_health: The Progress Health.
    :type progress_health: str
    :param progress_status: The Progress Status.
    :type progress_status: str
    """

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'protection_stage': {'key': 'protectionStage', 'type': 'str'},
        'health_error_code': {'key': 'healthErrorCode', 'type': 'str'},
        'rpo_in_seconds': {'key': 'rpoInSeconds', 'type': 'long'},
        'resync_required': {'key': 'resyncRequired', 'type': 'str'},
        'resync_progress_percentage': {'key': 'resyncProgressPercentage', 'type': 'int'},
        'resync_duration_in_seconds': {'key': 'resyncDurationInSeconds', 'type': 'long'},
        'disk_capacity_in_bytes': {'key': 'diskCapacityInBytes', 'type': 'long'},
        'file_system_capacity_in_bytes': {'key': 'fileSystemCapacityInBytes', 'type': 'long'},
        'source_data_in_mb': {'key': 'sourceDataInMB', 'type': 'float'},
        'ps_data_in_mb': {'key': 'psDataInMB', 'type': 'float'},
        'target_data_in_mb': {'key': 'targetDataInMB', 'type': 'float'},
        'disk_resized': {'key': 'diskResized', 'type': 'str'},
        'last_rpo_calculated_time': {'key': 'lastRpoCalculatedTime', 'type': 'iso-8601'},
        'resync_processed_bytes': {'key': 'resyncProcessedBytes', 'type': 'long'},
        'resync_total_transferred_bytes': {'key': 'resyncTotalTransferredBytes', 'type': 'long'},
        'resync_last15_minutes_transferred_bytes': {'key': 'resyncLast15MinutesTransferredBytes', 'type': 'long'},
        'resync_last_data_transfer_time_utc': {'key': 'resyncLastDataTransferTimeUTC', 'type': 'iso-8601'},
        'resync_start_time': {'key': 'resyncStartTime', 'type': 'iso-8601'},
        'progress_health': {'key': 'progressHealth', 'type': 'str'},
        'progress_status': {'key': 'progressStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        disk_name: Optional[str] = None,
        protection_stage: Optional[str] = None,
        health_error_code: Optional[str] = None,
        rpo_in_seconds: Optional[int] = None,
        resync_required: Optional[str] = None,
        resync_progress_percentage: Optional[int] = None,
        resync_duration_in_seconds: Optional[int] = None,
        disk_capacity_in_bytes: Optional[int] = None,
        file_system_capacity_in_bytes: Optional[int] = None,
        source_data_in_mb: Optional[float] = None,
        ps_data_in_mb: Optional[float] = None,
        target_data_in_mb: Optional[float] = None,
        disk_resized: Optional[str] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        resync_processed_bytes: Optional[int] = None,
        resync_total_transferred_bytes: Optional[int] = None,
        resync_last15_minutes_transferred_bytes: Optional[int] = None,
        resync_last_data_transfer_time_utc: Optional[datetime.datetime] = None,
        resync_start_time: Optional[datetime.datetime] = None,
        progress_health: Optional[str] = None,
        progress_status: Optional[str] = None,
        **kwargs
    ):
        super(InMageProtectedDiskDetails, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.disk_name = disk_name
        self.protection_stage = protection_stage
        self.health_error_code = health_error_code
        self.rpo_in_seconds = rpo_in_seconds
        self.resync_required = resync_required
        self.resync_progress_percentage = resync_progress_percentage
        self.resync_duration_in_seconds = resync_duration_in_seconds
        self.disk_capacity_in_bytes = disk_capacity_in_bytes
        self.file_system_capacity_in_bytes = file_system_capacity_in_bytes
        self.source_data_in_mb = source_data_in_mb
        self.ps_data_in_mb = ps_data_in_mb
        self.target_data_in_mb = target_data_in_mb
        self.disk_resized = disk_resized
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.resync_processed_bytes = resync_processed_bytes
        self.resync_total_transferred_bytes = resync_total_transferred_bytes
        self.resync_last15_minutes_transferred_bytes = resync_last15_minutes_transferred_bytes
        self.resync_last_data_transfer_time_utc = resync_last_data_transfer_time_utc
        self.resync_start_time = resync_start_time
        self.progress_health = progress_health
        self.progress_status = progress_status


class InMageRcmAgentUpgradeBlockingErrorDetails(msrest.serialization.Model):
    """InMageRcm source agent upgrade blocking error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar possible_causes: The possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: The recommended action.
    :vartype recommended_action: str
    :ivar error_message_parameters: The error message parameters.
    :vartype error_message_parameters: dict[str, str]
    :ivar error_tags: The error tags.
    :vartype error_tags: dict[str, str]
    """

    _validation = {
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'possible_causes': {'readonly': True},
        'recommended_action': {'readonly': True},
        'error_message_parameters': {'readonly': True},
        'error_tags': {'readonly': True},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'possible_causes': {'key': 'possibleCauses', 'type': 'str'},
        'recommended_action': {'key': 'recommendedAction', 'type': 'str'},
        'error_message_parameters': {'key': 'errorMessageParameters', 'type': '{str}'},
        'error_tags': {'key': 'errorTags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmAgentUpgradeBlockingErrorDetails, self).__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.possible_causes = None
        self.recommended_action = None
        self.error_message_parameters = None
        self.error_tags = None


class InMageRcmApplyRecoveryPointInput(ApplyRecoveryPointProviderSpecificInput):
    """ApplyRecoveryPoint input specific to InMageRcm provider.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_id: Required. The recovery point Id.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_point_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_id: str,
        **kwargs
    ):
        super(InMageRcmApplyRecoveryPointInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.recovery_point_id = recovery_point_id


class InMageRcmDiscoveredProtectedVmDetails(msrest.serialization.Model):
    """InMageRcm discovered protected VM details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar v_center_id: The VCenter Id.
    :vartype v_center_id: str
    :ivar v_center_fqdn: The VCenter fqdn.
    :vartype v_center_fqdn: str
    :ivar datastores: The list of datastores.
    :vartype datastores: list[str]
    :ivar ip_addresses: The list of IP addresses.
    :vartype ip_addresses: list[str]
    :ivar vmware_tools_status: The VMware tools status.
    :vartype vmware_tools_status: str
    :ivar power_status: The VM power status.
    :vartype power_status: str
    :ivar vm_fqdn: The VM fqdn.
    :vartype vm_fqdn: str
    :ivar os_name: The VM's OS name.
    :vartype os_name: str
    :ivar created_timestamp: The SDS created timestamp.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: The SDS updated timestamp.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar is_deleted: A value indicating whether the VM is deleted.
    :vartype is_deleted: bool
    :ivar last_discovery_time_in_utc: The last time when SDS information discovered in SRS.
    :vartype last_discovery_time_in_utc: ~datetime.datetime
    """

    _validation = {
        'v_center_id': {'readonly': True},
        'v_center_fqdn': {'readonly': True},
        'datastores': {'readonly': True},
        'ip_addresses': {'readonly': True},
        'vmware_tools_status': {'readonly': True},
        'power_status': {'readonly': True},
        'vm_fqdn': {'readonly': True},
        'os_name': {'readonly': True},
        'created_timestamp': {'readonly': True},
        'updated_timestamp': {'readonly': True},
        'is_deleted': {'readonly': True},
        'last_discovery_time_in_utc': {'readonly': True},
    }

    _attribute_map = {
        'v_center_id': {'key': 'vCenterId', 'type': 'str'},
        'v_center_fqdn': {'key': 'vCenterFqdn', 'type': 'str'},
        'datastores': {'key': 'datastores', 'type': '[str]'},
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
        'vmware_tools_status': {'key': 'vmwareToolsStatus', 'type': 'str'},
        'power_status': {'key': 'powerStatus', 'type': 'str'},
        'vm_fqdn': {'key': 'vmFqdn', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'created_timestamp': {'key': 'createdTimestamp', 'type': 'iso-8601'},
        'updated_timestamp': {'key': 'updatedTimestamp', 'type': 'iso-8601'},
        'is_deleted': {'key': 'isDeleted', 'type': 'bool'},
        'last_discovery_time_in_utc': {'key': 'lastDiscoveryTimeInUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmDiscoveredProtectedVmDetails, self).__init__(**kwargs)
        self.v_center_id = None
        self.v_center_fqdn = None
        self.datastores = None
        self.ip_addresses = None
        self.vmware_tools_status = None
        self.power_status = None
        self.vm_fqdn = None
        self.os_name = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.is_deleted = None
        self.last_discovery_time_in_utc = None


class InMageRcmDiskInput(msrest.serialization.Model):
    """InMageRcm disk input.

    All required parameters must be populated in order to send to Azure.

    :param disk_id: Required. The disk Id.
    :type disk_id: str
    :param log_storage_account_id: Required. The log storage account ARM Id.
    :type log_storage_account_id: str
    :param disk_type: Required. The disk type. Possible values include: "Standard_LRS",
     "Premium_LRS", "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :param disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :type disk_encryption_set_id: str
    """

    _validation = {
        'disk_id': {'required': True},
        'log_storage_account_id': {'required': True},
        'disk_type': {'required': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        log_storage_account_id: str,
        disk_type: Union[str, "DiskAccountType"],
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmDiskInput, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.log_storage_account_id = log_storage_account_id
        self.disk_type = disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class InMageRcmDisksDefaultInput(msrest.serialization.Model):
    """InMageRcm disk input.

    All required parameters must be populated in order to send to Azure.

    :param log_storage_account_id: Required. The log storage account ARM Id.
    :type log_storage_account_id: str
    :param disk_type: Required. The disk type. Possible values include: "Standard_LRS",
     "Premium_LRS", "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :param disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :type disk_encryption_set_id: str
    """

    _validation = {
        'log_storage_account_id': {'required': True},
        'disk_type': {'required': True},
    }

    _attribute_map = {
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        log_storage_account_id: str,
        disk_type: Union[str, "DiskAccountType"],
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmDisksDefaultInput, self).__init__(**kwargs)
        self.log_storage_account_id = log_storage_account_id
        self.disk_type = disk_type
        self.disk_encryption_set_id = disk_encryption_set_id


class InMageRcmEnableProtectionInput(EnableProtectionProviderSpecificInput):
    """InMageRcm specific enable protection input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param fabric_discovery_machine_id: Required. The ARM Id of discovered machine.
    :type fabric_discovery_machine_id: str
    :param disks_to_include: The disks to include list.
    :type disks_to_include:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDiskInput]
    :param disks_default: The default disk input.
    :type disks_default: ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDisksDefaultInput
    :param target_resource_group_id: Required. The target resource group ARM Id.
    :type target_resource_group_id: str
    :param target_network_id: The selected target network ARM Id.
    :type target_network_id: str
    :param test_network_id: The selected test network ARM Id.
    :type test_network_id: str
    :param target_subnet_name: The selected target subnet name.
    :type target_subnet_name: str
    :param test_subnet_name: The selected test subnet name.
    :type test_subnet_name: str
    :param target_vm_name: The target VM name.
    :type target_vm_name: str
    :param target_vm_size: The target VM size.
    :type target_vm_size: str
    :param license_type: The license type. Possible values include: "NotSpecified",
     "NoLicenseType", "WindowsServer".
    :type license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :param target_availability_set_id: The target availability set ARM Id.
    :type target_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The target proximity placement group Id.
    :type target_proximity_placement_group_id: str
    :param target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :type target_boot_diagnostics_storage_account_id: str
    :param run_as_account_id: The run-as account Id.
    :type run_as_account_id: str
    :param process_server_id: Required. The process server Id.
    :type process_server_id: str
    :param multi_vm_group_name: The multi VM group name.
    :type multi_vm_group_name: str
    """

    _validation = {
        'instance_type': {'required': True},
        'fabric_discovery_machine_id': {'required': True},
        'target_resource_group_id': {'required': True},
        'process_server_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'fabric_discovery_machine_id': {'key': 'fabricDiscoveryMachineId', 'type': 'str'},
        'disks_to_include': {'key': 'disksToInclude', 'type': '[InMageRcmDiskInput]'},
        'disks_default': {'key': 'disksDefault', 'type': 'InMageRcmDisksDefaultInput'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'target_network_id': {'key': 'targetNetworkId', 'type': 'str'},
        'test_network_id': {'key': 'testNetworkId', 'type': 'str'},
        'target_subnet_name': {'key': 'targetSubnetName', 'type': 'str'},
        'test_subnet_name': {'key': 'testSubnetName', 'type': 'str'},
        'target_vm_name': {'key': 'targetVmName', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'target_boot_diagnostics_storage_account_id': {'key': 'targetBootDiagnosticsStorageAccountId', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fabric_discovery_machine_id: str,
        target_resource_group_id: str,
        process_server_id: str,
        disks_to_include: Optional[List["InMageRcmDiskInput"]] = None,
        disks_default: Optional["InMageRcmDisksDefaultInput"] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        target_subnet_name: Optional[str] = None,
        test_subnet_name: Optional[str] = None,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        license_type: Optional[Union[str, "LicenseType"]] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmEnableProtectionInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.fabric_discovery_machine_id = fabric_discovery_machine_id
        self.disks_to_include = disks_to_include
        self.disks_default = disks_default
        self.target_resource_group_id = target_resource_group_id
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.target_subnet_name = target_subnet_name
        self.test_subnet_name = test_subnet_name
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.license_type = license_type
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.run_as_account_id = run_as_account_id
        self.process_server_id = process_server_id
        self.multi_vm_group_name = multi_vm_group_name


class InMageRcmEventDetails(EventProviderSpecificDetails):
    """Event details for InMageRcm provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :ivar protected_item_name: The protected item name.
    :vartype protected_item_name: str
    :ivar vm_name: The protected item name.
    :vartype vm_name: str
    :ivar latest_agent_version: The latest agent version.
    :vartype latest_agent_version: str
    :ivar job_id: The job Id.
    :vartype job_id: str
    :ivar fabric_name: The fabric name.
    :vartype fabric_name: str
    :ivar appliance_name: The appliance name.
    :vartype appliance_name: str
    :ivar server_type: The server type.
    :vartype server_type: str
    :ivar component_display_name: The component display name.
    :vartype component_display_name: str
    """

    _validation = {
        'instance_type': {'required': True},
        'protected_item_name': {'readonly': True},
        'vm_name': {'readonly': True},
        'latest_agent_version': {'readonly': True},
        'job_id': {'readonly': True},
        'fabric_name': {'readonly': True},
        'appliance_name': {'readonly': True},
        'server_type': {'readonly': True},
        'component_display_name': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'protected_item_name': {'key': 'protectedItemName', 'type': 'str'},
        'vm_name': {'key': 'vmName', 'type': 'str'},
        'latest_agent_version': {'key': 'latestAgentVersion', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'fabric_name': {'key': 'fabricName', 'type': 'str'},
        'appliance_name': {'key': 'applianceName', 'type': 'str'},
        'server_type': {'key': 'serverType', 'type': 'str'},
        'component_display_name': {'key': 'componentDisplayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmEventDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.protected_item_name = None
        self.vm_name = None
        self.latest_agent_version = None
        self.job_id = None
        self.fabric_name = None
        self.appliance_name = None
        self.server_type = None
        self.component_display_name = None


class InMageRcmFabricCreationInput(FabricSpecificCreationInput):
    """InMageRcm fabric provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type.Constant filled by server.
    :type instance_type: str
    :param vmware_site_id: Required. The ARM Id of the VMware site.
    :type vmware_site_id: str
    :param physical_site_id: Required. The ARM Id of the physical site.
    :type physical_site_id: str
    :param source_agent_identity: Required. The identity provider input for source agent
     authentication.
    :type source_agent_identity:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderInput
    """

    _validation = {
        'instance_type': {'required': True},
        'vmware_site_id': {'required': True},
        'physical_site_id': {'required': True},
        'source_agent_identity': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vmware_site_id': {'key': 'vmwareSiteId', 'type': 'str'},
        'physical_site_id': {'key': 'physicalSiteId', 'type': 'str'},
        'source_agent_identity': {'key': 'sourceAgentIdentity', 'type': 'IdentityProviderInput'},
    }

    def __init__(
        self,
        *,
        vmware_site_id: str,
        physical_site_id: str,
        source_agent_identity: "IdentityProviderInput",
        **kwargs
    ):
        super(InMageRcmFabricCreationInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.vmware_site_id = vmware_site_id
        self.physical_site_id = physical_site_id
        self.source_agent_identity = source_agent_identity


class InMageRcmFabricSpecificDetails(FabricSpecificDetails):
    """InMageRcm fabric specific details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :ivar vmware_site_id: The ARM Id of the VMware site.
    :vartype vmware_site_id: str
    :ivar physical_site_id: The ARM Id of the physical site.
    :vartype physical_site_id: str
    :ivar service_endpoint: The service endpoint.
    :vartype service_endpoint: str
    :ivar service_resource_id: The service resource Id.
    :vartype service_resource_id: str
    :ivar service_container_id: The service container Id.
    :vartype service_container_id: str
    :ivar data_plane_uri: The data plane Uri.
    :vartype data_plane_uri: str
    :ivar control_plane_uri: The control plane Uri.
    :vartype control_plane_uri: str
    :param source_agent_identity_details: The source agent identity details.
    :type source_agent_identity_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderDetails
    :ivar process_servers: The list of process servers.
    :vartype process_servers:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ProcessServerDetails]
    :ivar rcm_proxies: The list of RCM proxies.
    :vartype rcm_proxies: list[~azure.mgmt.recoveryservicessiterecovery.models.RcmProxyDetails]
    :ivar push_installers: The list of push installers.
    :vartype push_installers:
     list[~azure.mgmt.recoveryservicessiterecovery.models.PushInstallerDetails]
    :ivar replication_agents: The list of replication agents.
    :vartype replication_agents:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationAgentDetails]
    :ivar reprotect_agents: The list of reprotect agents.
    :vartype reprotect_agents:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ReprotectAgentDetails]
    :ivar mars_agents: The list of Mars agents.
    :vartype mars_agents: list[~azure.mgmt.recoveryservicessiterecovery.models.MarsAgentDetails]
    :ivar dras: The list of DRAs.
    :vartype dras: list[~azure.mgmt.recoveryservicessiterecovery.models.DraDetails]
    :ivar agent_details: The list of agent details.
    :vartype agent_details: list[~azure.mgmt.recoveryservicessiterecovery.models.AgentDetails]
    """

    _validation = {
        'instance_type': {'required': True},
        'vmware_site_id': {'readonly': True},
        'physical_site_id': {'readonly': True},
        'service_endpoint': {'readonly': True},
        'service_resource_id': {'readonly': True},
        'service_container_id': {'readonly': True},
        'data_plane_uri': {'readonly': True},
        'control_plane_uri': {'readonly': True},
        'process_servers': {'readonly': True},
        'rcm_proxies': {'readonly': True},
        'push_installers': {'readonly': True},
        'replication_agents': {'readonly': True},
        'reprotect_agents': {'readonly': True},
        'mars_agents': {'readonly': True},
        'dras': {'readonly': True},
        'agent_details': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vmware_site_id': {'key': 'vmwareSiteId', 'type': 'str'},
        'physical_site_id': {'key': 'physicalSiteId', 'type': 'str'},
        'service_endpoint': {'key': 'serviceEndpoint', 'type': 'str'},
        'service_resource_id': {'key': 'serviceResourceId', 'type': 'str'},
        'service_container_id': {'key': 'serviceContainerId', 'type': 'str'},
        'data_plane_uri': {'key': 'dataPlaneUri', 'type': 'str'},
        'control_plane_uri': {'key': 'controlPlaneUri', 'type': 'str'},
        'source_agent_identity_details': {'key': 'sourceAgentIdentityDetails', 'type': 'IdentityProviderDetails'},
        'process_servers': {'key': 'processServers', 'type': '[ProcessServerDetails]'},
        'rcm_proxies': {'key': 'rcmProxies', 'type': '[RcmProxyDetails]'},
        'push_installers': {'key': 'pushInstallers', 'type': '[PushInstallerDetails]'},
        'replication_agents': {'key': 'replicationAgents', 'type': '[ReplicationAgentDetails]'},
        'reprotect_agents': {'key': 'reprotectAgents', 'type': '[ReprotectAgentDetails]'},
        'mars_agents': {'key': 'marsAgents', 'type': '[MarsAgentDetails]'},
        'dras': {'key': 'dras', 'type': '[DraDetails]'},
        'agent_details': {'key': 'agentDetails', 'type': '[AgentDetails]'},
    }

    def __init__(
        self,
        *,
        source_agent_identity_details: Optional["IdentityProviderDetails"] = None,
        **kwargs
    ):
        super(InMageRcmFabricSpecificDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.vmware_site_id = None
        self.physical_site_id = None
        self.service_endpoint = None
        self.service_resource_id = None
        self.service_container_id = None
        self.data_plane_uri = None
        self.control_plane_uri = None
        self.source_agent_identity_details = source_agent_identity_details
        self.process_servers = None
        self.rcm_proxies = None
        self.push_installers = None
        self.replication_agents = None
        self.reprotect_agents = None
        self.mars_agents = None
        self.dras = None
        self.agent_details = None


class InMageRcmFailbackDiscoveredProtectedVmDetails(msrest.serialization.Model):
    """InMageRcmFailback discovered VM details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar v_center_id: The VCenter Id.
    :vartype v_center_id: str
    :ivar v_center_fqdn: The VCenter fqdn.
    :vartype v_center_fqdn: str
    :ivar datastores: The list of datastores.
    :vartype datastores: list[str]
    :ivar ip_addresses: The list of IP addresses.
    :vartype ip_addresses: list[str]
    :ivar vmware_tools_status: The VMware tools status.
    :vartype vmware_tools_status: str
    :ivar power_status: The VM power status.
    :vartype power_status: str
    :ivar vm_fqdn: The VM fqdn.
    :vartype vm_fqdn: str
    :ivar os_name: The VM's OS name.
    :vartype os_name: str
    :ivar created_timestamp: The SDS created timestamp.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: The SDS updated timestamp.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar is_deleted: A value indicating whether the VM is deleted.
    :vartype is_deleted: bool
    :ivar last_discovery_time_in_utc: The last time when SDS information discovered in SRS.
    :vartype last_discovery_time_in_utc: ~datetime.datetime
    """

    _validation = {
        'v_center_id': {'readonly': True},
        'v_center_fqdn': {'readonly': True},
        'datastores': {'readonly': True},
        'ip_addresses': {'readonly': True},
        'vmware_tools_status': {'readonly': True},
        'power_status': {'readonly': True},
        'vm_fqdn': {'readonly': True},
        'os_name': {'readonly': True},
        'created_timestamp': {'readonly': True},
        'updated_timestamp': {'readonly': True},
        'is_deleted': {'readonly': True},
        'last_discovery_time_in_utc': {'readonly': True},
    }

    _attribute_map = {
        'v_center_id': {'key': 'vCenterId', 'type': 'str'},
        'v_center_fqdn': {'key': 'vCenterFqdn', 'type': 'str'},
        'datastores': {'key': 'datastores', 'type': '[str]'},
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
        'vmware_tools_status': {'key': 'vmwareToolsStatus', 'type': 'str'},
        'power_status': {'key': 'powerStatus', 'type': 'str'},
        'vm_fqdn': {'key': 'vmFqdn', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'created_timestamp': {'key': 'createdTimestamp', 'type': 'iso-8601'},
        'updated_timestamp': {'key': 'updatedTimestamp', 'type': 'iso-8601'},
        'is_deleted': {'key': 'isDeleted', 'type': 'bool'},
        'last_discovery_time_in_utc': {'key': 'lastDiscoveryTimeInUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmFailbackDiscoveredProtectedVmDetails, self).__init__(**kwargs)
        self.v_center_id = None
        self.v_center_fqdn = None
        self.datastores = None
        self.ip_addresses = None
        self.vmware_tools_status = None
        self.power_status = None
        self.vm_fqdn = None
        self.os_name = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.is_deleted = None
        self.last_discovery_time_in_utc = None


class InMageRcmFailbackEventDetails(EventProviderSpecificDetails):
    """Event details for InMageRcmFailback provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :ivar protected_item_name: The protected item name.
    :vartype protected_item_name: str
    :ivar vm_name: The protected item name.
    :vartype vm_name: str
    :ivar appliance_name: The appliance name.
    :vartype appliance_name: str
    :ivar server_type: The server type.
    :vartype server_type: str
    :ivar component_display_name: The component display name.
    :vartype component_display_name: str
    """

    _validation = {
        'instance_type': {'required': True},
        'protected_item_name': {'readonly': True},
        'vm_name': {'readonly': True},
        'appliance_name': {'readonly': True},
        'server_type': {'readonly': True},
        'component_display_name': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'protected_item_name': {'key': 'protectedItemName', 'type': 'str'},
        'vm_name': {'key': 'vmName', 'type': 'str'},
        'appliance_name': {'key': 'applianceName', 'type': 'str'},
        'server_type': {'key': 'serverType', 'type': 'str'},
        'component_display_name': {'key': 'componentDisplayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmFailbackEventDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcmFailback'  # type: str
        self.protected_item_name = None
        self.vm_name = None
        self.appliance_name = None
        self.server_type = None
        self.component_display_name = None


class InMageRcmFailbackMobilityAgentDetails(msrest.serialization.Model):
    """InMageRcmFailback mobility agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The agent version.
    :vartype version: str
    :ivar latest_version: The latest agent version available.
    :vartype latest_version: str
    :ivar driver_version: The driver version.
    :vartype driver_version: str
    :ivar latest_upgradable_version_without_reboot: The latest upgradeable version available
     without reboot.
    :vartype latest_upgradable_version_without_reboot: str
    :ivar agent_version_expiry_date: The agent version expiry date.
    :vartype agent_version_expiry_date: ~datetime.datetime
    :ivar driver_version_expiry_date: The driver version expiry date.
    :vartype driver_version_expiry_date: ~datetime.datetime
    :ivar last_heartbeat_utc: The time of the last heartbeat received from the agent.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar reasons_blocking_upgrade: The whether update is possible or not.
    :vartype reasons_blocking_upgrade: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentUpgradeBlockedReason]
    :ivar is_upgradeable: A value indicating whether agent is upgradeable or not.
    :vartype is_upgradeable: str
    """

    _validation = {
        'version': {'readonly': True},
        'latest_version': {'readonly': True},
        'driver_version': {'readonly': True},
        'latest_upgradable_version_without_reboot': {'readonly': True},
        'agent_version_expiry_date': {'readonly': True},
        'driver_version_expiry_date': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'reasons_blocking_upgrade': {'readonly': True},
        'is_upgradeable': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'driver_version': {'key': 'driverVersion', 'type': 'str'},
        'latest_upgradable_version_without_reboot': {'key': 'latestUpgradableVersionWithoutReboot', 'type': 'str'},
        'agent_version_expiry_date': {'key': 'agentVersionExpiryDate', 'type': 'iso-8601'},
        'driver_version_expiry_date': {'key': 'driverVersionExpiryDate', 'type': 'iso-8601'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'reasons_blocking_upgrade': {'key': 'reasonsBlockingUpgrade', 'type': '[str]'},
        'is_upgradeable': {'key': 'isUpgradeable', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmFailbackMobilityAgentDetails, self).__init__(**kwargs)
        self.version = None
        self.latest_version = None
        self.driver_version = None
        self.latest_upgradable_version_without_reboot = None
        self.agent_version_expiry_date = None
        self.driver_version_expiry_date = None
        self.last_heartbeat_utc = None
        self.reasons_blocking_upgrade = None
        self.is_upgradeable = None


class InMageRcmFailbackNicDetails(msrest.serialization.Model):
    """InMageRcmFailback NIC details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mac_address: The mac address.
    :vartype mac_address: str
    :ivar network_name: The network name.
    :vartype network_name: str
    :ivar adapter_type: The adapter type.
    :vartype adapter_type: str
    :ivar source_ip_address: The IP address.
    :vartype source_ip_address: str
    """

    _validation = {
        'mac_address': {'readonly': True},
        'network_name': {'readonly': True},
        'adapter_type': {'readonly': True},
        'source_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'mac_address': {'key': 'macAddress', 'type': 'str'},
        'network_name': {'key': 'networkName', 'type': 'str'},
        'adapter_type': {'key': 'adapterType', 'type': 'str'},
        'source_ip_address': {'key': 'sourceIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmFailbackNicDetails, self).__init__(**kwargs)
        self.mac_address = None
        self.network_name = None
        self.adapter_type = None
        self.source_ip_address = None


class InMageRcmFailbackPlannedFailoverProviderInput(PlannedFailoverProviderSpecificFailoverInput):
    """Provider specific input for InMageRcmFailback failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_type: Required. The recovery point type. Possible values include:
     "ApplicationConsistent", "CrashConsistent".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackRecoveryPointType
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_point_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "InMageRcmFailbackRecoveryPointType"],
        **kwargs
    ):
        super(InMageRcmFailbackPlannedFailoverProviderInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcmFailback'  # type: str
        self.recovery_point_type = recovery_point_type


class InMageRcmFailbackPolicyCreationInput(PolicyProviderSpecificInput):
    """InMageRcmFailback policy creation input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :type crash_consistent_frequency_in_minutes: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :type app_consistent_frequency_in_minutes: int
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(InMageRcmFailbackPolicyCreationInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcmFailback'  # type: str
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes


class InMageRcmFailbackPolicyDetails(PolicyProviderSpecificDetails):
    """InMageRcm failback specific policy details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :type app_consistent_frequency_in_minutes: int
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :type crash_consistent_frequency_in_minutes: int
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(InMageRcmFailbackPolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcmFailback'  # type: str
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes


class InMageRcmFailbackProtectedDiskDetails(msrest.serialization.Model):
    """InMageRcmFailback protected disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_id: The disk Id (reported by source agent).
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar is_os_disk: A value indicating whether the disk is the OS disk.
    :vartype is_os_disk: str
    :ivar capacity_in_bytes: The disk capacity in bytes.
    :vartype capacity_in_bytes: long
    :ivar disk_uuid: The disk Uuid (reported by vCenter).
    :vartype disk_uuid: str
    :ivar data_pending_in_log_data_store_in_mb: The data pending in log data store in MB.
    :vartype data_pending_in_log_data_store_in_mb: float
    :ivar data_pending_at_source_agent_in_mb: The data pending at source agent in MB.
    :vartype data_pending_at_source_agent_in_mb: float
    :ivar is_initial_replication_complete: A value indicating whether initial replication is
     complete or not.
    :vartype is_initial_replication_complete: str
    :param ir_details: The initial replication details.
    :type ir_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackSyncDetails
    :param resync_details: The resync details.
    :type resync_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackSyncDetails
    :ivar last_sync_time: The last sync time.
    :vartype last_sync_time: ~datetime.datetime
    """

    _validation = {
        'disk_id': {'readonly': True},
        'disk_name': {'readonly': True},
        'is_os_disk': {'readonly': True},
        'capacity_in_bytes': {'readonly': True},
        'disk_uuid': {'readonly': True},
        'data_pending_in_log_data_store_in_mb': {'readonly': True},
        'data_pending_at_source_agent_in_mb': {'readonly': True},
        'is_initial_replication_complete': {'readonly': True},
        'last_sync_time': {'readonly': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'is_os_disk': {'key': 'isOSDisk', 'type': 'str'},
        'capacity_in_bytes': {'key': 'capacityInBytes', 'type': 'long'},
        'disk_uuid': {'key': 'diskUuid', 'type': 'str'},
        'data_pending_in_log_data_store_in_mb': {'key': 'dataPendingInLogDataStoreInMB', 'type': 'float'},
        'data_pending_at_source_agent_in_mb': {'key': 'dataPendingAtSourceAgentInMB', 'type': 'float'},
        'is_initial_replication_complete': {'key': 'isInitialReplicationComplete', 'type': 'str'},
        'ir_details': {'key': 'irDetails', 'type': 'InMageRcmFailbackSyncDetails'},
        'resync_details': {'key': 'resyncDetails', 'type': 'InMageRcmFailbackSyncDetails'},
        'last_sync_time': {'key': 'lastSyncTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        ir_details: Optional["InMageRcmFailbackSyncDetails"] = None,
        resync_details: Optional["InMageRcmFailbackSyncDetails"] = None,
        **kwargs
    ):
        super(InMageRcmFailbackProtectedDiskDetails, self).__init__(**kwargs)
        self.disk_id = None
        self.disk_name = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.disk_uuid = None
        self.data_pending_in_log_data_store_in_mb = None
        self.data_pending_at_source_agent_in_mb = None
        self.is_initial_replication_complete = None
        self.ir_details = ir_details
        self.resync_details = resync_details
        self.last_sync_time = None


class InMageRcmFailbackReplicationDetails(ReplicationProviderSpecificSettings):
    """InMageRcmFailback provider specific details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :ivar internal_identifier: The virtual machine internal identifier.
    :vartype internal_identifier: str
    :ivar azure_virtual_machine_id: The ARM Id of the azure VM.
    :vartype azure_virtual_machine_id: str
    :ivar multi_vm_group_name: The multi VM group name.
    :vartype multi_vm_group_name: str
    :ivar reprotect_agent_id: The reprotect agent Id.
    :vartype reprotect_agent_id: str
    :ivar reprotect_agent_name: The reprotect agent name.
    :vartype reprotect_agent_name: str
    :ivar os_type: The type of the OS on the VM.
    :vartype os_type: str
    :ivar log_storage_account_id: The log storage account ARM Id.
    :vartype log_storage_account_id: str
    :ivar targetv_center_id: The target vCenter Id.
    :vartype targetv_center_id: str
    :ivar target_data_store_name: The target datastore name.
    :vartype target_data_store_name: str
    :ivar target_vm_name: The target VM name.
    :vartype target_vm_name: str
    :ivar initial_replication_progress_percentage: The initial replication progress percentage.
    :vartype initial_replication_progress_percentage: int
    :ivar initial_replication_processed_bytes: The initial replication processed bytes. This
     includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
    :vartype initial_replication_processed_bytes: long
    :ivar initial_replication_transferred_bytes: The initial replication transferred bytes from
     source VM to target for all selected disks on source VM.
    :vartype initial_replication_transferred_bytes: long
    :ivar initial_replication_progress_health: The initial replication progress health. Possible
     values include: "None", "InProgress", "SlowProgress", "NoProgress".
    :vartype initial_replication_progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmReplicationProgressHealth
    :ivar resync_progress_percentage: The resync progress percentage.
    :vartype resync_progress_percentage: int
    :ivar resync_processed_bytes: The resync processed bytes. This includes sum of total bytes
     transferred and matched bytes on all selected disks in source VM.
    :vartype resync_processed_bytes: long
    :ivar resync_transferred_bytes: The resync transferred bytes from source VM to target for all
     selected disks on source VM.
    :vartype resync_transferred_bytes: long
    :ivar resync_progress_health: The resync progress health. Possible values include: "None",
     "InProgress", "SlowProgress", "NoProgress".
    :vartype resync_progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmReplicationProgressHealth
    :ivar resync_required: A value indicating whether resync is required.
    :vartype resync_required: str
    :ivar resync_state: The resync state. Possible values include: "None",
     "PreparedForResynchronization", "StartedResynchronization".
    :vartype resync_state: str or ~azure.mgmt.recoveryservicessiterecovery.models.ResyncState
    :param protected_disks: The list of protected disks.
    :type protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackProtectedDiskDetails]
    :param mobility_agent_details: The mobility agent information.
    :type mobility_agent_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackMobilityAgentDetails
    :param vm_nics: The network details.
    :type vm_nics:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackNicDetails]
    :ivar last_planned_failover_start_time: The last planned failover start time.
    :vartype last_planned_failover_start_time: ~datetime.datetime
    :ivar last_planned_failover_status: The last planned failover status. Possible values include:
     "Succeeded", "Failed", "Cancelled", "Unknown".
    :vartype last_planned_failover_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverStatus
    :param discovered_vm_details: The discovered VM information.
    :type discovered_vm_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackDiscoveredProtectedVmDetails
    :ivar last_used_policy_id: The policy Id used by the forward replication.
    :vartype last_used_policy_id: str
    :ivar last_used_policy_friendly_name: The policy friendly name used by the forward replication.
    :vartype last_used_policy_friendly_name: str
    :ivar is_agent_registration_successful_after_failover: A value indicating whether agent
     registration was successful after failover.
    :vartype is_agent_registration_successful_after_failover: bool
    """

    _validation = {
        'instance_type': {'required': True},
        'internal_identifier': {'readonly': True},
        'azure_virtual_machine_id': {'readonly': True},
        'multi_vm_group_name': {'readonly': True},
        'reprotect_agent_id': {'readonly': True},
        'reprotect_agent_name': {'readonly': True},
        'os_type': {'readonly': True},
        'log_storage_account_id': {'readonly': True},
        'targetv_center_id': {'readonly': True},
        'target_data_store_name': {'readonly': True},
        'target_vm_name': {'readonly': True},
        'initial_replication_progress_percentage': {'readonly': True},
        'initial_replication_processed_bytes': {'readonly': True},
        'initial_replication_transferred_bytes': {'readonly': True},
        'initial_replication_progress_health': {'readonly': True},
        'resync_progress_percentage': {'readonly': True},
        'resync_processed_bytes': {'readonly': True},
        'resync_transferred_bytes': {'readonly': True},
        'resync_progress_health': {'readonly': True},
        'resync_required': {'readonly': True},
        'resync_state': {'readonly': True},
        'last_planned_failover_start_time': {'readonly': True},
        'last_planned_failover_status': {'readonly': True},
        'last_used_policy_id': {'readonly': True},
        'last_used_policy_friendly_name': {'readonly': True},
        'is_agent_registration_successful_after_failover': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'internal_identifier': {'key': 'internalIdentifier', 'type': 'str'},
        'azure_virtual_machine_id': {'key': 'azureVirtualMachineId', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'reprotect_agent_id': {'key': 'reprotectAgentId', 'type': 'str'},
        'reprotect_agent_name': {'key': 'reprotectAgentName', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'targetv_center_id': {'key': 'targetvCenterId', 'type': 'str'},
        'target_data_store_name': {'key': 'targetDataStoreName', 'type': 'str'},
        'target_vm_name': {'key': 'targetVmName', 'type': 'str'},
        'initial_replication_progress_percentage': {'key': 'initialReplicationProgressPercentage', 'type': 'int'},
        'initial_replication_processed_bytes': {'key': 'initialReplicationProcessedBytes', 'type': 'long'},
        'initial_replication_transferred_bytes': {'key': 'initialReplicationTransferredBytes', 'type': 'long'},
        'initial_replication_progress_health': {'key': 'initialReplicationProgressHealth', 'type': 'str'},
        'resync_progress_percentage': {'key': 'resyncProgressPercentage', 'type': 'int'},
        'resync_processed_bytes': {'key': 'resyncProcessedBytes', 'type': 'long'},
        'resync_transferred_bytes': {'key': 'resyncTransferredBytes', 'type': 'long'},
        'resync_progress_health': {'key': 'resyncProgressHealth', 'type': 'str'},
        'resync_required': {'key': 'resyncRequired', 'type': 'str'},
        'resync_state': {'key': 'resyncState', 'type': 'str'},
        'protected_disks': {'key': 'protectedDisks', 'type': '[InMageRcmFailbackProtectedDiskDetails]'},
        'mobility_agent_details': {'key': 'mobilityAgentDetails', 'type': 'InMageRcmFailbackMobilityAgentDetails'},
        'vm_nics': {'key': 'vmNics', 'type': '[InMageRcmFailbackNicDetails]'},
        'last_planned_failover_start_time': {'key': 'lastPlannedFailoverStartTime', 'type': 'iso-8601'},
        'last_planned_failover_status': {'key': 'lastPlannedFailoverStatus', 'type': 'str'},
        'discovered_vm_details': {'key': 'discoveredVmDetails', 'type': 'InMageRcmFailbackDiscoveredProtectedVmDetails'},
        'last_used_policy_id': {'key': 'lastUsedPolicyId', 'type': 'str'},
        'last_used_policy_friendly_name': {'key': 'lastUsedPolicyFriendlyName', 'type': 'str'},
        'is_agent_registration_successful_after_failover': {'key': 'isAgentRegistrationSuccessfulAfterFailover', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        protected_disks: Optional[List["InMageRcmFailbackProtectedDiskDetails"]] = None,
        mobility_agent_details: Optional["InMageRcmFailbackMobilityAgentDetails"] = None,
        vm_nics: Optional[List["InMageRcmFailbackNicDetails"]] = None,
        discovered_vm_details: Optional["InMageRcmFailbackDiscoveredProtectedVmDetails"] = None,
        **kwargs
    ):
        super(InMageRcmFailbackReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcmFailback'  # type: str
        self.internal_identifier = None
        self.azure_virtual_machine_id = None
        self.multi_vm_group_name = None
        self.reprotect_agent_id = None
        self.reprotect_agent_name = None
        self.os_type = None
        self.log_storage_account_id = None
        self.targetv_center_id = None
        self.target_data_store_name = None
        self.target_vm_name = None
        self.initial_replication_progress_percentage = None
        self.initial_replication_processed_bytes = None
        self.initial_replication_transferred_bytes = None
        self.initial_replication_progress_health = None
        self.resync_progress_percentage = None
        self.resync_processed_bytes = None
        self.resync_transferred_bytes = None
        self.resync_progress_health = None
        self.resync_required = None
        self.resync_state = None
        self.protected_disks = protected_disks
        self.mobility_agent_details = mobility_agent_details
        self.vm_nics = vm_nics
        self.last_planned_failover_start_time = None
        self.last_planned_failover_status = None
        self.discovered_vm_details = discovered_vm_details
        self.last_used_policy_id = None
        self.last_used_policy_friendly_name = None
        self.is_agent_registration_successful_after_failover = None


class InMageRcmFailbackReprotectInput(ReverseReplicationProviderSpecificInput):
    """InMageRcmFailback specific provider input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param process_server_id: Required. The process server Id.
    :type process_server_id: str
    :param run_as_account_id: The run as account Id.
    :type run_as_account_id: str
    :param policy_id: Required. The Policy Id.
    :type policy_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'process_server_id': {'required': True},
        'policy_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        process_server_id: str,
        policy_id: str,
        run_as_account_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmFailbackReprotectInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcmFailback'  # type: str
        self.process_server_id = process_server_id
        self.run_as_account_id = run_as_account_id
        self.policy_id = policy_id


class InMageRcmFailbackSyncDetails(msrest.serialization.Model):
    """InMageRcmFailback disk level sync details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar progress_health: The progress health. Possible values include: "None", "InProgress",
     "SlowProgress", "NoProgress", "Queued".
    :vartype progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskReplicationProgressHealth
    :ivar transferred_bytes: The transferred bytes from source VM to azure for the disk.
    :vartype transferred_bytes: long
    :ivar last15_minutes_transferred_bytes: The bytes transferred in last 15 minutes from source VM
     to target.
    :vartype last15_minutes_transferred_bytes: long
    :ivar last_data_transfer_time_utc: The time of the last data transfer from source VM to target.
    :vartype last_data_transfer_time_utc: str
    :ivar processed_bytes: The total processed bytes. This includes bytes that are transferred from
     source VM to target and matched bytes.
    :vartype processed_bytes: long
    :ivar start_time: The start time.
    :vartype start_time: str
    :ivar last_refresh_time: The last refresh time.
    :vartype last_refresh_time: str
    :ivar progress_percentage: Progress in percentage. Progress percentage is calculated based on
     processed bytes.
    :vartype progress_percentage: int
    """

    _validation = {
        'progress_health': {'readonly': True},
        'transferred_bytes': {'readonly': True},
        'last15_minutes_transferred_bytes': {'readonly': True},
        'last_data_transfer_time_utc': {'readonly': True},
        'processed_bytes': {'readonly': True},
        'start_time': {'readonly': True},
        'last_refresh_time': {'readonly': True},
        'progress_percentage': {'readonly': True},
    }

    _attribute_map = {
        'progress_health': {'key': 'progressHealth', 'type': 'str'},
        'transferred_bytes': {'key': 'transferredBytes', 'type': 'long'},
        'last15_minutes_transferred_bytes': {'key': 'last15MinutesTransferredBytes', 'type': 'long'},
        'last_data_transfer_time_utc': {'key': 'lastDataTransferTimeUtc', 'type': 'str'},
        'processed_bytes': {'key': 'processedBytes', 'type': 'long'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'last_refresh_time': {'key': 'lastRefreshTime', 'type': 'str'},
        'progress_percentage': {'key': 'progressPercentage', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmFailbackSyncDetails, self).__init__(**kwargs)
        self.progress_health = None
        self.transferred_bytes = None
        self.last15_minutes_transferred_bytes = None
        self.last_data_transfer_time_utc = None
        self.processed_bytes = None
        self.start_time = None
        self.last_refresh_time = None
        self.progress_percentage = None


class InMageRcmLastAgentUpgradeErrorDetails(msrest.serialization.Model):
    """InMageRcm last source agent upgrade error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar error_message: The error message.
    :vartype error_message: str
    :ivar possible_causes: The possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: The recommended action.
    :vartype recommended_action: str
    :ivar error_message_parameters: The error message parameters.
    :vartype error_message_parameters: dict[str, str]
    :ivar error_tags: The error tags.
    :vartype error_tags: dict[str, str]
    """

    _validation = {
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'possible_causes': {'readonly': True},
        'recommended_action': {'readonly': True},
        'error_message_parameters': {'readonly': True},
        'error_tags': {'readonly': True},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'possible_causes': {'key': 'possibleCauses', 'type': 'str'},
        'recommended_action': {'key': 'recommendedAction', 'type': 'str'},
        'error_message_parameters': {'key': 'errorMessageParameters', 'type': '{str}'},
        'error_tags': {'key': 'errorTags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmLastAgentUpgradeErrorDetails, self).__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.possible_causes = None
        self.recommended_action = None
        self.error_message_parameters = None
        self.error_tags = None


class InMageRcmMobilityAgentDetails(msrest.serialization.Model):
    """InMageRcm mobility agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The agent version.
    :vartype version: str
    :ivar latest_version: The latest agent version available.
    :vartype latest_version: str
    :ivar latest_agent_release_date: The latest agent version release date.
    :vartype latest_agent_release_date: str
    :ivar driver_version: The driver version.
    :vartype driver_version: str
    :ivar latest_upgradable_version_without_reboot: The latest upgradeable version available
     without reboot.
    :vartype latest_upgradable_version_without_reboot: str
    :ivar agent_version_expiry_date: The agent version expiry date.
    :vartype agent_version_expiry_date: ~datetime.datetime
    :ivar driver_version_expiry_date: The driver version expiry date.
    :vartype driver_version_expiry_date: ~datetime.datetime
    :ivar last_heartbeat_utc: The time of the last heartbeat received from the agent.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar reasons_blocking_upgrade: The whether update is possible or not.
    :vartype reasons_blocking_upgrade: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AgentUpgradeBlockedReason]
    :ivar is_upgradeable: A value indicating whether agent is upgradeable or not.
    :vartype is_upgradeable: str
    """

    _validation = {
        'version': {'readonly': True},
        'latest_version': {'readonly': True},
        'latest_agent_release_date': {'readonly': True},
        'driver_version': {'readonly': True},
        'latest_upgradable_version_without_reboot': {'readonly': True},
        'agent_version_expiry_date': {'readonly': True},
        'driver_version_expiry_date': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'reasons_blocking_upgrade': {'readonly': True},
        'is_upgradeable': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'latest_agent_release_date': {'key': 'latestAgentReleaseDate', 'type': 'str'},
        'driver_version': {'key': 'driverVersion', 'type': 'str'},
        'latest_upgradable_version_without_reboot': {'key': 'latestUpgradableVersionWithoutReboot', 'type': 'str'},
        'agent_version_expiry_date': {'key': 'agentVersionExpiryDate', 'type': 'iso-8601'},
        'driver_version_expiry_date': {'key': 'driverVersionExpiryDate', 'type': 'iso-8601'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'reasons_blocking_upgrade': {'key': 'reasonsBlockingUpgrade', 'type': '[str]'},
        'is_upgradeable': {'key': 'isUpgradeable', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmMobilityAgentDetails, self).__init__(**kwargs)
        self.version = None
        self.latest_version = None
        self.latest_agent_release_date = None
        self.driver_version = None
        self.latest_upgradable_version_without_reboot = None
        self.agent_version_expiry_date = None
        self.driver_version_expiry_date = None
        self.last_heartbeat_utc = None
        self.reasons_blocking_upgrade = None
        self.is_upgradeable = None


class InMageRcmNicDetails(msrest.serialization.Model):
    """InMageRcm NIC details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nic_id: The NIC Id.
    :vartype nic_id: str
    :param is_primary_nic: A value indicating whether this is the primary NIC.
    :type is_primary_nic: str
    :param is_selected_for_failover: A value indicating whether this NIC is selected for failover.
    :type is_selected_for_failover: str
    :ivar source_ip_address: The source IP address.
    :vartype source_ip_address: str
    :ivar source_ip_address_type: The source IP address type. Possible values include: "Dynamic",
     "Static".
    :vartype source_ip_address_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
    :ivar source_network_id: Source network Id.
    :vartype source_network_id: str
    :ivar source_subnet_name: Source subnet name.
    :vartype source_subnet_name: str
    :param target_ip_address: The target IP address.
    :type target_ip_address: str
    :param target_ip_address_type: The target IP address type. Possible values include: "Dynamic",
     "Static".
    :type target_ip_address_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
    :param target_subnet_name: Target subnet name.
    :type target_subnet_name: str
    :param test_subnet_name: Test subnet name.
    :type test_subnet_name: str
    :param test_ip_address: The test IP address.
    :type test_ip_address: str
    :param test_ip_address_type: The test IP address type. Possible values include: "Dynamic",
     "Static".
    :type test_ip_address_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
    """

    _validation = {
        'nic_id': {'readonly': True},
        'source_ip_address': {'readonly': True},
        'source_ip_address_type': {'readonly': True},
        'source_network_id': {'readonly': True},
        'source_subnet_name': {'readonly': True},
    }

    _attribute_map = {
        'nic_id': {'key': 'nicId', 'type': 'str'},
        'is_primary_nic': {'key': 'isPrimaryNic', 'type': 'str'},
        'is_selected_for_failover': {'key': 'isSelectedForFailover', 'type': 'str'},
        'source_ip_address': {'key': 'sourceIPAddress', 'type': 'str'},
        'source_ip_address_type': {'key': 'sourceIPAddressType', 'type': 'str'},
        'source_network_id': {'key': 'sourceNetworkId', 'type': 'str'},
        'source_subnet_name': {'key': 'sourceSubnetName', 'type': 'str'},
        'target_ip_address': {'key': 'targetIPAddress', 'type': 'str'},
        'target_ip_address_type': {'key': 'targetIPAddressType', 'type': 'str'},
        'target_subnet_name': {'key': 'targetSubnetName', 'type': 'str'},
        'test_subnet_name': {'key': 'testSubnetName', 'type': 'str'},
        'test_ip_address': {'key': 'testIPAddress', 'type': 'str'},
        'test_ip_address_type': {'key': 'testIPAddressType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_primary_nic: Optional[str] = None,
        is_selected_for_failover: Optional[str] = None,
        target_ip_address: Optional[str] = None,
        target_ip_address_type: Optional[Union[str, "EthernetAddressType"]] = None,
        target_subnet_name: Optional[str] = None,
        test_subnet_name: Optional[str] = None,
        test_ip_address: Optional[str] = None,
        test_ip_address_type: Optional[Union[str, "EthernetAddressType"]] = None,
        **kwargs
    ):
        super(InMageRcmNicDetails, self).__init__(**kwargs)
        self.nic_id = None
        self.is_primary_nic = is_primary_nic
        self.is_selected_for_failover = is_selected_for_failover
        self.source_ip_address = None
        self.source_ip_address_type = None
        self.source_network_id = None
        self.source_subnet_name = None
        self.target_ip_address = target_ip_address
        self.target_ip_address_type = target_ip_address_type
        self.target_subnet_name = target_subnet_name
        self.test_subnet_name = test_subnet_name
        self.test_ip_address = test_ip_address
        self.test_ip_address_type = test_ip_address_type


class InMageRcmNicInput(msrest.serialization.Model):
    """InMageRcm NIC input.

    All required parameters must be populated in order to send to Azure.

    :param nic_id: Required. The NIC Id.
    :type nic_id: str
    :param is_primary_nic: Required. A value indicating whether this is the primary NIC.
    :type is_primary_nic: str
    :param is_selected_for_failover: A value indicating whether this NIC is selected for failover.
    :type is_selected_for_failover: str
    :param target_subnet_name: Target subnet name.
    :type target_subnet_name: str
    :param target_static_ip_address: The target static IP address.
    :type target_static_ip_address: str
    :param test_subnet_name: The test subnet name.
    :type test_subnet_name: str
    :param test_static_ip_address: The test static IP address.
    :type test_static_ip_address: str
    """

    _validation = {
        'nic_id': {'required': True},
        'is_primary_nic': {'required': True},
    }

    _attribute_map = {
        'nic_id': {'key': 'nicId', 'type': 'str'},
        'is_primary_nic': {'key': 'isPrimaryNic', 'type': 'str'},
        'is_selected_for_failover': {'key': 'isSelectedForFailover', 'type': 'str'},
        'target_subnet_name': {'key': 'targetSubnetName', 'type': 'str'},
        'target_static_ip_address': {'key': 'targetStaticIPAddress', 'type': 'str'},
        'test_subnet_name': {'key': 'testSubnetName', 'type': 'str'},
        'test_static_ip_address': {'key': 'testStaticIPAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        nic_id: str,
        is_primary_nic: str,
        is_selected_for_failover: Optional[str] = None,
        target_subnet_name: Optional[str] = None,
        target_static_ip_address: Optional[str] = None,
        test_subnet_name: Optional[str] = None,
        test_static_ip_address: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmNicInput, self).__init__(**kwargs)
        self.nic_id = nic_id
        self.is_primary_nic = is_primary_nic
        self.is_selected_for_failover = is_selected_for_failover
        self.target_subnet_name = target_subnet_name
        self.target_static_ip_address = target_static_ip_address
        self.test_subnet_name = test_subnet_name
        self.test_static_ip_address = test_static_ip_address


class InMageRcmPolicyCreationInput(PolicyProviderSpecificInput):
    """InMageRcm policy creation input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_history_in_minutes: The duration in minutes until which the recovery
     points need to be stored.
    :type recovery_point_history_in_minutes: int
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :type crash_consistent_frequency_in_minutes: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :type app_consistent_frequency_in_minutes: int
    :param enable_multi_vm_sync: A value indicating whether multi-VM sync has to be enabled.
    :type enable_multi_vm_sync: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_history_in_minutes': {'key': 'recoveryPointHistoryInMinutes', 'type': 'int'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'enable_multi_vm_sync': {'key': 'enableMultiVmSync', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        enable_multi_vm_sync: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmPolicyCreationInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.recovery_point_history_in_minutes = recovery_point_history_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.enable_multi_vm_sync = enable_multi_vm_sync


class InMageRcmPolicyDetails(PolicyProviderSpecificDetails):
    """InMageRcm specific policy details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param recovery_point_history_in_minutes: The duration in minutes until which the recovery
     points need to be stored.
    :type recovery_point_history_in_minutes: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :type app_consistent_frequency_in_minutes: int
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :type crash_consistent_frequency_in_minutes: int
    :param enable_multi_vm_sync: A value indicating whether multi-VM sync has to be enabled.
    :type enable_multi_vm_sync: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_history_in_minutes': {'key': 'recoveryPointHistoryInMinutes', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
        'enable_multi_vm_sync': {'key': 'enableMultiVmSync', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        enable_multi_vm_sync: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmPolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.recovery_point_history_in_minutes = recovery_point_history_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.enable_multi_vm_sync = enable_multi_vm_sync


class InMageRcmProtectedDiskDetails(msrest.serialization.Model):
    """InMageRcm protected disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_id: The disk Id.
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :ivar is_os_disk: A value indicating whether the disk is the OS disk.
    :vartype is_os_disk: str
    :ivar capacity_in_bytes: The disk capacity in bytes.
    :vartype capacity_in_bytes: long
    :ivar log_storage_account_id: The log storage account ARM Id.
    :vartype log_storage_account_id: str
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :vartype disk_encryption_set_id: str
    :ivar seed_managed_disk_id: The ARM Id of the seed managed disk.
    :vartype seed_managed_disk_id: str
    :ivar target_managed_disk_id: The ARM Id of the target managed disk.
    :vartype target_managed_disk_id: str
    :param disk_type: The disk type. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar data_pending_in_log_data_store_in_mb: The data pending in log data store in MB.
    :vartype data_pending_in_log_data_store_in_mb: float
    :ivar data_pending_at_source_agent_in_mb: The data pending at source agent in MB.
    :vartype data_pending_at_source_agent_in_mb: float
    :ivar is_initial_replication_complete: A value indicating whether initial replication is
     complete or not.
    :vartype is_initial_replication_complete: str
    :param ir_details: The initial replication details.
    :type ir_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmSyncDetails
    :param resync_details: The resync details.
    :type resync_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmSyncDetails
    """

    _validation = {
        'disk_id': {'readonly': True},
        'disk_name': {'readonly': True},
        'is_os_disk': {'readonly': True},
        'capacity_in_bytes': {'readonly': True},
        'log_storage_account_id': {'readonly': True},
        'disk_encryption_set_id': {'readonly': True},
        'seed_managed_disk_id': {'readonly': True},
        'target_managed_disk_id': {'readonly': True},
        'data_pending_in_log_data_store_in_mb': {'readonly': True},
        'data_pending_at_source_agent_in_mb': {'readonly': True},
        'is_initial_replication_complete': {'readonly': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'is_os_disk': {'key': 'isOSDisk', 'type': 'str'},
        'capacity_in_bytes': {'key': 'capacityInBytes', 'type': 'long'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'seed_managed_disk_id': {'key': 'seedManagedDiskId', 'type': 'str'},
        'target_managed_disk_id': {'key': 'targetManagedDiskId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'data_pending_in_log_data_store_in_mb': {'key': 'dataPendingInLogDataStoreInMB', 'type': 'float'},
        'data_pending_at_source_agent_in_mb': {'key': 'dataPendingAtSourceAgentInMB', 'type': 'float'},
        'is_initial_replication_complete': {'key': 'isInitialReplicationComplete', 'type': 'str'},
        'ir_details': {'key': 'irDetails', 'type': 'InMageRcmSyncDetails'},
        'resync_details': {'key': 'resyncDetails', 'type': 'InMageRcmSyncDetails'},
    }

    def __init__(
        self,
        *,
        disk_type: Optional[Union[str, "DiskAccountType"]] = None,
        ir_details: Optional["InMageRcmSyncDetails"] = None,
        resync_details: Optional["InMageRcmSyncDetails"] = None,
        **kwargs
    ):
        super(InMageRcmProtectedDiskDetails, self).__init__(**kwargs)
        self.disk_id = None
        self.disk_name = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.log_storage_account_id = None
        self.disk_encryption_set_id = None
        self.seed_managed_disk_id = None
        self.target_managed_disk_id = None
        self.disk_type = disk_type
        self.data_pending_in_log_data_store_in_mb = None
        self.data_pending_at_source_agent_in_mb = None
        self.is_initial_replication_complete = None
        self.ir_details = ir_details
        self.resync_details = resync_details


class InMageRcmProtectionContainerMappingDetails(ProtectionContainerMappingProviderSpecificDetails):
    """InMageRcm provider specific container mapping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :ivar enable_agent_auto_upgrade: A value indicating whether the flag for enable agent auto
     upgrade.
    :vartype enable_agent_auto_upgrade: str
    """

    _validation = {
        'instance_type': {'required': True},
        'enable_agent_auto_upgrade': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'enable_agent_auto_upgrade': {'key': 'enableAgentAutoUpgrade', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmProtectionContainerMappingDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.enable_agent_auto_upgrade = None


class InMageRcmRecoveryPointDetails(ProviderSpecificRecoveryPointDetails):
    """InMageRcm provider specific recovery point details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the provider type.Constant filled by server.
    :type instance_type: str
    :ivar is_multi_vm_sync_point: A value indicating whether the recovery point is multi VM
     consistent.
    :vartype is_multi_vm_sync_point: str
    """

    _validation = {
        'instance_type': {'required': True},
        'is_multi_vm_sync_point': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'is_multi_vm_sync_point': {'key': 'isMultiVmSyncPoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmRecoveryPointDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.is_multi_vm_sync_point = None


class InMageRcmReplicationDetails(ReplicationProviderSpecificSettings):
    """InMageRcm provider specific details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :ivar internal_identifier: The virtual machine internal identifier.
    :vartype internal_identifier: str
    :ivar fabric_discovery_machine_id: The ARM Id of the discovered VM.
    :vartype fabric_discovery_machine_id: str
    :ivar multi_vm_group_name: The multi VM group name.
    :vartype multi_vm_group_name: str
    :ivar discovery_type: The type of the discovered VM.
    :vartype discovery_type: str
    :ivar process_server_id: The process server Id.
    :vartype process_server_id: str
    :ivar processor_core_count: The processor core count.
    :vartype processor_core_count: int
    :ivar allocated_memory_in_mb: The allocated memory in MB.
    :vartype allocated_memory_in_mb: float
    :ivar process_server_name: The process server name.
    :vartype process_server_name: str
    :ivar run_as_account_id: The run-as account Id.
    :vartype run_as_account_id: str
    :ivar os_type: The type of the OS on the VM.
    :vartype os_type: str
    :ivar firmware_type: The firmware type.
    :vartype firmware_type: str
    :ivar primary_nic_ip_address: The IP address of the primary network interface.
    :vartype primary_nic_ip_address: str
    :ivar target_generation: The target generation.
    :vartype target_generation: str
    :param license_type: License Type of the VM to be used.
    :type license_type: str
    :param target_vm_name: Target VM name.
    :type target_vm_name: str
    :param target_vm_size: The target VM size.
    :type target_vm_size: str
    :param target_resource_group_id: The target resource group Id.
    :type target_resource_group_id: str
    :param target_location: The target location.
    :type target_location: str
    :param target_availability_set_id: The target availability set Id.
    :type target_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The target proximity placement group Id.
    :type target_proximity_placement_group_id: str
    :param target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :type target_boot_diagnostics_storage_account_id: str
    :param target_network_id: The target network Id.
    :type target_network_id: str
    :param test_network_id: The test network Id.
    :type test_network_id: str
    :ivar failover_recovery_point_id: The recovery point Id to which the VM was failed over.
    :vartype failover_recovery_point_id: str
    :ivar last_recovery_point_received: The last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar last_rpo_in_seconds: The last recovery point objective value.
    :vartype last_rpo_in_seconds: long
    :ivar last_rpo_calculated_time: The last recovery point objective calculated time.
    :vartype last_rpo_calculated_time: ~datetime.datetime
    :ivar last_recovery_point_id: The last recovery point Id.
    :vartype last_recovery_point_id: str
    :ivar initial_replication_progress_percentage: The initial replication progress percentage.
     This is calculated based on total bytes processed for all disks in the source VM.
    :vartype initial_replication_progress_percentage: int
    :ivar initial_replication_processed_bytes: The initial replication processed bytes. This
     includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
    :vartype initial_replication_processed_bytes: long
    :ivar initial_replication_transferred_bytes: The initial replication transferred bytes from
     source VM to azure for all selected disks on source VM.
    :vartype initial_replication_transferred_bytes: long
    :ivar initial_replication_progress_health: The initial replication progress health. Possible
     values include: "None", "InProgress", "SlowProgress", "NoProgress".
    :vartype initial_replication_progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmReplicationProgressHealth
    :ivar resync_progress_percentage: The resync progress percentage. This is calculated based on
     total bytes processed for all disks in the source VM.
    :vartype resync_progress_percentage: int
    :ivar resync_processed_bytes: The resync processed bytes. This includes sum of total bytes
     transferred and matched bytes on all selected disks in source VM.
    :vartype resync_processed_bytes: long
    :ivar resync_transferred_bytes: The resync transferred bytes from source VM to azure for all
     selected disks on source VM.
    :vartype resync_transferred_bytes: long
    :ivar resync_progress_health: The resync progress health. Possible values include: "None",
     "InProgress", "SlowProgress", "NoProgress".
    :vartype resync_progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.VmReplicationProgressHealth
    :ivar resync_required: A value indicating whether resync is required.
    :vartype resync_required: str
    :ivar resync_state: The resync state. Possible values include: "None",
     "PreparedForResynchronization", "StartedResynchronization".
    :vartype resync_state: str or ~azure.mgmt.recoveryservicessiterecovery.models.ResyncState
    :ivar agent_upgrade_state: The agent auto upgrade state. Possible values include: "None",
     "Started", "Completed", "Commit".
    :vartype agent_upgrade_state: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MobilityAgentUpgradeState
    :ivar last_agent_upgrade_type: The last agent upgrade type.
    :vartype last_agent_upgrade_type: str
    :ivar agent_upgrade_job_id: The agent upgrade job Id.
    :vartype agent_upgrade_job_id: str
    :ivar agent_upgrade_attempt_to_version: The agent version to which last agent upgrade was
     attempted.
    :vartype agent_upgrade_attempt_to_version: str
    :param protected_disks: The list of protected disks.
    :type protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmProtectedDiskDetails]
    :ivar is_last_upgrade_successful: A value indicating whether last agent upgrade was successful
     or not.
    :vartype is_last_upgrade_successful: str
    :ivar is_agent_registration_successful_after_failover: A value indicating whether agent
     registration was successful after failover.
    :vartype is_agent_registration_successful_after_failover: bool
    :param mobility_agent_details: The mobility agent information.
    :type mobility_agent_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmMobilityAgentDetails
    :param last_agent_upgrade_error_details: The last agent upgrade error information.
    :type last_agent_upgrade_error_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmLastAgentUpgradeErrorDetails]
    :param agent_upgrade_blocking_error_details: The agent upgrade blocking error information.
    :type agent_upgrade_blocking_error_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmAgentUpgradeBlockingErrorDetails]
    :param vm_nics: The network details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmNicDetails]
    :param discovered_vm_details: The discovered VM details.
    :type discovered_vm_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmDiscoveredProtectedVmDetails
    """

    _validation = {
        'instance_type': {'required': True},
        'internal_identifier': {'readonly': True},
        'fabric_discovery_machine_id': {'readonly': True},
        'multi_vm_group_name': {'readonly': True},
        'discovery_type': {'readonly': True},
        'process_server_id': {'readonly': True},
        'processor_core_count': {'readonly': True},
        'allocated_memory_in_mb': {'readonly': True},
        'process_server_name': {'readonly': True},
        'run_as_account_id': {'readonly': True},
        'os_type': {'readonly': True},
        'firmware_type': {'readonly': True},
        'primary_nic_ip_address': {'readonly': True},
        'target_generation': {'readonly': True},
        'failover_recovery_point_id': {'readonly': True},
        'last_recovery_point_received': {'readonly': True},
        'last_rpo_in_seconds': {'readonly': True},
        'last_rpo_calculated_time': {'readonly': True},
        'last_recovery_point_id': {'readonly': True},
        'initial_replication_progress_percentage': {'readonly': True},
        'initial_replication_processed_bytes': {'readonly': True},
        'initial_replication_transferred_bytes': {'readonly': True},
        'initial_replication_progress_health': {'readonly': True},
        'resync_progress_percentage': {'readonly': True},
        'resync_processed_bytes': {'readonly': True},
        'resync_transferred_bytes': {'readonly': True},
        'resync_progress_health': {'readonly': True},
        'resync_required': {'readonly': True},
        'resync_state': {'readonly': True},
        'agent_upgrade_state': {'readonly': True},
        'last_agent_upgrade_type': {'readonly': True},
        'agent_upgrade_job_id': {'readonly': True},
        'agent_upgrade_attempt_to_version': {'readonly': True},
        'is_last_upgrade_successful': {'readonly': True},
        'is_agent_registration_successful_after_failover': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'internal_identifier': {'key': 'internalIdentifier', 'type': 'str'},
        'fabric_discovery_machine_id': {'key': 'fabricDiscoveryMachineId', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'discovery_type': {'key': 'discoveryType', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'processor_core_count': {'key': 'processorCoreCount', 'type': 'int'},
        'allocated_memory_in_mb': {'key': 'allocatedMemoryInMB', 'type': 'float'},
        'process_server_name': {'key': 'processServerName', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'firmware_type': {'key': 'firmwareType', 'type': 'str'},
        'primary_nic_ip_address': {'key': 'primaryNicIpAddress', 'type': 'str'},
        'target_generation': {'key': 'targetGeneration', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'target_vm_name': {'key': 'targetVmName', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'target_location': {'key': 'targetLocation', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'target_boot_diagnostics_storage_account_id': {'key': 'targetBootDiagnosticsStorageAccountId', 'type': 'str'},
        'target_network_id': {'key': 'targetNetworkId', 'type': 'str'},
        'test_network_id': {'key': 'testNetworkId', 'type': 'str'},
        'failover_recovery_point_id': {'key': 'failoverRecoveryPointId', 'type': 'str'},
        'last_recovery_point_received': {'key': 'lastRecoveryPointReceived', 'type': 'iso-8601'},
        'last_rpo_in_seconds': {'key': 'lastRpoInSeconds', 'type': 'long'},
        'last_rpo_calculated_time': {'key': 'lastRpoCalculatedTime', 'type': 'iso-8601'},
        'last_recovery_point_id': {'key': 'lastRecoveryPointId', 'type': 'str'},
        'initial_replication_progress_percentage': {'key': 'initialReplicationProgressPercentage', 'type': 'int'},
        'initial_replication_processed_bytes': {'key': 'initialReplicationProcessedBytes', 'type': 'long'},
        'initial_replication_transferred_bytes': {'key': 'initialReplicationTransferredBytes', 'type': 'long'},
        'initial_replication_progress_health': {'key': 'initialReplicationProgressHealth', 'type': 'str'},
        'resync_progress_percentage': {'key': 'resyncProgressPercentage', 'type': 'int'},
        'resync_processed_bytes': {'key': 'resyncProcessedBytes', 'type': 'long'},
        'resync_transferred_bytes': {'key': 'resyncTransferredBytes', 'type': 'long'},
        'resync_progress_health': {'key': 'resyncProgressHealth', 'type': 'str'},
        'resync_required': {'key': 'resyncRequired', 'type': 'str'},
        'resync_state': {'key': 'resyncState', 'type': 'str'},
        'agent_upgrade_state': {'key': 'agentUpgradeState', 'type': 'str'},
        'last_agent_upgrade_type': {'key': 'lastAgentUpgradeType', 'type': 'str'},
        'agent_upgrade_job_id': {'key': 'agentUpgradeJobId', 'type': 'str'},
        'agent_upgrade_attempt_to_version': {'key': 'agentUpgradeAttemptToVersion', 'type': 'str'},
        'protected_disks': {'key': 'protectedDisks', 'type': '[InMageRcmProtectedDiskDetails]'},
        'is_last_upgrade_successful': {'key': 'isLastUpgradeSuccessful', 'type': 'str'},
        'is_agent_registration_successful_after_failover': {'key': 'isAgentRegistrationSuccessfulAfterFailover', 'type': 'bool'},
        'mobility_agent_details': {'key': 'mobilityAgentDetails', 'type': 'InMageRcmMobilityAgentDetails'},
        'last_agent_upgrade_error_details': {'key': 'lastAgentUpgradeErrorDetails', 'type': '[InMageRcmLastAgentUpgradeErrorDetails]'},
        'agent_upgrade_blocking_error_details': {'key': 'agentUpgradeBlockingErrorDetails', 'type': '[InMageRcmAgentUpgradeBlockingErrorDetails]'},
        'vm_nics': {'key': 'vmNics', 'type': '[InMageRcmNicDetails]'},
        'discovered_vm_details': {'key': 'discoveredVmDetails', 'type': 'InMageRcmDiscoveredProtectedVmDetails'},
    }

    def __init__(
        self,
        *,
        license_type: Optional[str] = None,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        target_location: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        protected_disks: Optional[List["InMageRcmProtectedDiskDetails"]] = None,
        mobility_agent_details: Optional["InMageRcmMobilityAgentDetails"] = None,
        last_agent_upgrade_error_details: Optional[List["InMageRcmLastAgentUpgradeErrorDetails"]] = None,
        agent_upgrade_blocking_error_details: Optional[List["InMageRcmAgentUpgradeBlockingErrorDetails"]] = None,
        vm_nics: Optional[List["InMageRcmNicDetails"]] = None,
        discovered_vm_details: Optional["InMageRcmDiscoveredProtectedVmDetails"] = None,
        **kwargs
    ):
        super(InMageRcmReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.internal_identifier = None
        self.fabric_discovery_machine_id = None
        self.multi_vm_group_name = None
        self.discovery_type = None
        self.process_server_id = None
        self.processor_core_count = None
        self.allocated_memory_in_mb = None
        self.process_server_name = None
        self.run_as_account_id = None
        self.os_type = None
        self.firmware_type = None
        self.primary_nic_ip_address = None
        self.target_generation = None
        self.license_type = license_type
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.target_resource_group_id = target_resource_group_id
        self.target_location = target_location
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.failover_recovery_point_id = None
        self.last_recovery_point_received = None
        self.last_rpo_in_seconds = None
        self.last_rpo_calculated_time = None
        self.last_recovery_point_id = None
        self.initial_replication_progress_percentage = None
        self.initial_replication_processed_bytes = None
        self.initial_replication_transferred_bytes = None
        self.initial_replication_progress_health = None
        self.resync_progress_percentage = None
        self.resync_processed_bytes = None
        self.resync_transferred_bytes = None
        self.resync_progress_health = None
        self.resync_required = None
        self.resync_state = None
        self.agent_upgrade_state = None
        self.last_agent_upgrade_type = None
        self.agent_upgrade_job_id = None
        self.agent_upgrade_attempt_to_version = None
        self.protected_disks = protected_disks
        self.is_last_upgrade_successful = None
        self.is_agent_registration_successful_after_failover = None
        self.mobility_agent_details = mobility_agent_details
        self.last_agent_upgrade_error_details = last_agent_upgrade_error_details
        self.agent_upgrade_blocking_error_details = agent_upgrade_blocking_error_details
        self.vm_nics = vm_nics
        self.discovered_vm_details = discovered_vm_details


class InMageRcmReprotectInput(ReverseReplicationProviderSpecificInput):
    """InMageRcm specific provider input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param reprotect_agent_id: Required. The reprotect agent Id.
    :type reprotect_agent_id: str
    :param datastore_name: Required. The target datastore name.
    :type datastore_name: str
    :param log_storage_account_id: Required. The log storage account ARM Id.
    :type log_storage_account_id: str
    :param policy_id: The Policy Id.
    :type policy_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'reprotect_agent_id': {'required': True},
        'datastore_name': {'required': True},
        'log_storage_account_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'reprotect_agent_id': {'key': 'reprotectAgentId', 'type': 'str'},
        'datastore_name': {'key': 'datastoreName', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        reprotect_agent_id: str,
        datastore_name: str,
        log_storage_account_id: str,
        policy_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmReprotectInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.reprotect_agent_id = reprotect_agent_id
        self.datastore_name = datastore_name
        self.log_storage_account_id = log_storage_account_id
        self.policy_id = policy_id


class InMageRcmSyncDetails(msrest.serialization.Model):
    """InMageRcm disk level sync details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar progress_health: The progress health. Possible values include: "None", "InProgress",
     "SlowProgress", "NoProgress", "Queued".
    :vartype progress_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.DiskReplicationProgressHealth
    :ivar transferred_bytes: The transferred bytes from source VM to azure for the disk.
    :vartype transferred_bytes: long
    :ivar last15_minutes_transferred_bytes: The bytes transferred in last 15 minutes from source VM
     to azure.
    :vartype last15_minutes_transferred_bytes: long
    :ivar last_data_transfer_time_utc: The time of the last data transfer from source VM to azure.
    :vartype last_data_transfer_time_utc: str
    :ivar processed_bytes: The total processed bytes. This includes bytes that are transferred from
     source VM to azure and matched bytes.
    :vartype processed_bytes: long
    :ivar start_time: The start time.
    :vartype start_time: str
    :ivar last_refresh_time: The last refresh time.
    :vartype last_refresh_time: str
    :ivar progress_percentage: Progress in percentage. Progress percentage is calculated based on
     processed bytes.
    :vartype progress_percentage: int
    """

    _validation = {
        'progress_health': {'readonly': True},
        'transferred_bytes': {'readonly': True},
        'last15_minutes_transferred_bytes': {'readonly': True},
        'last_data_transfer_time_utc': {'readonly': True},
        'processed_bytes': {'readonly': True},
        'start_time': {'readonly': True},
        'last_refresh_time': {'readonly': True},
        'progress_percentage': {'readonly': True},
    }

    _attribute_map = {
        'progress_health': {'key': 'progressHealth', 'type': 'str'},
        'transferred_bytes': {'key': 'transferredBytes', 'type': 'long'},
        'last15_minutes_transferred_bytes': {'key': 'last15MinutesTransferredBytes', 'type': 'long'},
        'last_data_transfer_time_utc': {'key': 'lastDataTransferTimeUtc', 'type': 'str'},
        'processed_bytes': {'key': 'processedBytes', 'type': 'long'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'last_refresh_time': {'key': 'lastRefreshTime', 'type': 'str'},
        'progress_percentage': {'key': 'progressPercentage', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InMageRcmSyncDetails, self).__init__(**kwargs)
        self.progress_health = None
        self.transferred_bytes = None
        self.last15_minutes_transferred_bytes = None
        self.last_data_transfer_time_utc = None
        self.processed_bytes = None
        self.start_time = None
        self.last_refresh_time = None
        self.progress_percentage = None


class InMageRcmTestFailoverInput(TestFailoverProviderSpecificInput):
    """InMageRcm provider specific input for test failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param network_id: The test network Id.
    :type network_id: str
    :param recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'network_id': {'key': 'networkId', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        network_id: Optional[str] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmTestFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.network_id = network_id
        self.recovery_point_id = recovery_point_id


class InMageRcmUnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """InMageRcm provider specific input for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param perform_shutdown: Required. A value indicating whether VM is to be shutdown.
    :type perform_shutdown: str
    :param recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'perform_shutdown': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'perform_shutdown': {'key': 'performShutdown', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        perform_shutdown: str,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmUnplannedFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.perform_shutdown = perform_shutdown
        self.recovery_point_id = recovery_point_id


class UpdateApplianceForReplicationProtectedItemProviderSpecificInput(msrest.serialization.Model):
    """Update replication protected item provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: InMageRcmUpdateApplianceForReplicationProtectedItemInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'InMageRcm': 'InMageRcmUpdateApplianceForReplicationProtectedItemInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateApplianceForReplicationProtectedItemProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class InMageRcmUpdateApplianceForReplicationProtectedItemInput(UpdateApplianceForReplicationProtectedItemProviderSpecificInput):
    """InMageRcm provider specific input to update appliance for replication protected item.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param run_as_account_id: The run as account Id.
    :type run_as_account_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_as_account_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageRcmUpdateApplianceForReplicationProtectedItemInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.run_as_account_id = run_as_account_id


class InMageRcmUpdateContainerMappingInput(ReplicationProviderSpecificUpdateContainerMappingInput):
    """InMageRcm update protection container mapping.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param enable_agent_auto_upgrade: Required. A value indicating whether agent auto upgrade has
     to be enabled.
    :type enable_agent_auto_upgrade: str
    """

    _validation = {
        'instance_type': {'required': True},
        'enable_agent_auto_upgrade': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'enable_agent_auto_upgrade': {'key': 'enableAgentAutoUpgrade', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enable_agent_auto_upgrade: str,
        **kwargs
    ):
        super(InMageRcmUpdateContainerMappingInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.enable_agent_auto_upgrade = enable_agent_auto_upgrade


class InMageRcmUpdateReplicationProtectedItemInput(UpdateReplicationProtectedItemProviderInput):
    """InMageRcm provider specific input to update replication protected item.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param target_vm_name: The target VM name.
    :type target_vm_name: str
    :param target_vm_size: The target VM size.
    :type target_vm_size: str
    :param target_resource_group_id: The target resource group ARM Id.
    :type target_resource_group_id: str
    :param target_availability_set_id: The target availability set ARM Id.
    :type target_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The target proximity placement group Id.
    :type target_proximity_placement_group_id: str
    :param target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :type target_boot_diagnostics_storage_account_id: str
    :param target_network_id: The target network ARM Id.
    :type target_network_id: str
    :param test_network_id: The test network ARM Id.
    :type test_network_id: str
    :param vm_nics: The list of NIC details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmNicInput]
    :param license_type: The license type. Possible values include: "NotSpecified",
     "NoLicenseType", "WindowsServer".
    :type license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'target_vm_name': {'key': 'targetVmName', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'target_boot_diagnostics_storage_account_id': {'key': 'targetBootDiagnosticsStorageAccountId', 'type': 'str'},
        'target_network_id': {'key': 'targetNetworkId', 'type': 'str'},
        'test_network_id': {'key': 'testNetworkId', 'type': 'str'},
        'vm_nics': {'key': 'vmNics', 'type': '[InMageRcmNicInput]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        target_network_id: Optional[str] = None,
        test_network_id: Optional[str] = None,
        vm_nics: Optional[List["InMageRcmNicInput"]] = None,
        license_type: Optional[Union[str, "LicenseType"]] = None,
        **kwargs
    ):
        super(InMageRcmUpdateReplicationProtectedItemInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.target_resource_group_id = target_resource_group_id
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.target_network_id = target_network_id
        self.test_network_id = test_network_id
        self.vm_nics = vm_nics
        self.license_type = license_type


class InMageReplicationDetails(ReplicationProviderSpecificSettings):
    """InMage provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param active_site_type: The active location of the VM. If the VM is being protected from
     Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between
     two data-centers, this field will be OnPrem always.
    :type active_site_type: str
    :param source_vm_cpu_count: The CPU count of the VM on the primary side.
    :type source_vm_cpu_count: int
    :param source_vm_ram_size_in_mb: The RAM size of the VM on the primary side.
    :type source_vm_ram_size_in_mb: int
    :param os_details: The OS details.
    :type os_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDiskDetails
    :param protection_stage: The protection stage.
    :type protection_stage: str
    :param vm_id: The virtual machine Id.
    :type vm_id: str
    :param vm_protection_state: The protection state for the vm.
    :type vm_protection_state: str
    :param vm_protection_state_description: The protection state description for the vm.
    :type vm_protection_state_description: str
    :param resync_details: The resync details of the machine.
    :type resync_details: ~azure.mgmt.recoveryservicessiterecovery.models.InitialReplicationDetails
    :param retention_window_start: The retention window start time.
    :type retention_window_start: ~datetime.datetime
    :param retention_window_end: The retention window end time.
    :type retention_window_end: ~datetime.datetime
    :param compressed_data_rate_in_mb: The compressed data change rate in MB.
    :type compressed_data_rate_in_mb: float
    :param uncompressed_data_rate_in_mb: The uncompressed data change rate in MB.
    :type uncompressed_data_rate_in_mb: float
    :param rpo_in_seconds: The RPO in seconds.
    :type rpo_in_seconds: long
    :param protected_disks: The list of protected disks.
    :type protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.InMageProtectedDiskDetails]
    :param ip_address: The source IP address.
    :type ip_address: str
    :param last_heartbeat: The last heartbeat received from the source server.
    :type last_heartbeat: ~datetime.datetime
    :param process_server_id: The process server Id.
    :type process_server_id: str
    :param master_target_id: The master target Id.
    :type master_target_id: str
    :param consistency_points: The collection of Consistency points.
    :type consistency_points: dict[str, ~datetime.datetime]
    :param disk_resized: A value indicating whether any disk is resized for this VM.
    :type disk_resized: str
    :param reboot_after_update_status: A value indicating whether the source server requires a
     restart after update.
    :type reboot_after_update_status: str
    :param multi_vm_group_id: The multi vm group Id, if any.
    :type multi_vm_group_id: str
    :param multi_vm_group_name: The multi vm group name, if any.
    :type multi_vm_group_name: str
    :param multi_vm_sync_status: A value indicating whether the multi vm sync is enabled or
     disabled.
    :type multi_vm_sync_status: str
    :param agent_details: The agent details.
    :type agent_details: ~azure.mgmt.recoveryservicessiterecovery.models.InMageAgentDetails
    :param v_center_infrastructure_id: The vCenter infrastructure Id.
    :type v_center_infrastructure_id: str
    :param infrastructure_vm_id: The infrastructure VM Id.
    :type infrastructure_vm_id: str
    :param vm_nics: The PE Network details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicDetails]
    :param discovery_type: A value indicating the discovery type of the machine.
    :type discovery_type: str
    :param azure_storage_account_id: A value indicating the underlying Azure storage account. If
     the VM is not running in Azure, this value shall be set to null.
    :type azure_storage_account_id: str
    :param datastores: The datastores of the on-premise machine Value can be list of strings that
     contain datastore names.
    :type datastores: list[str]
    :param validation_errors: The validation errors of the on-premise machine Value can be list of
     validation errors.
    :type validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param last_rpo_calculated_time: The last RPO calculated time.
    :type last_rpo_calculated_time: ~datetime.datetime
    :param last_update_received_time: The last update time received from on-prem components.
    :type last_update_received_time: ~datetime.datetime
    :param replica_id: The replica id of the protected item.
    :type replica_id: str
    :param os_version: The OS Version of the protected item.
    :type os_version: str
    :param is_additional_stats_available: A value indicating whether additional IR stats are
     available or not.
    :type is_additional_stats_available: bool
    :param total_data_transferred: The total transferred data in bytes.
    :type total_data_transferred: long
    :param total_progress_health: The progress health.
    :type total_progress_health: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'active_site_type': {'key': 'activeSiteType', 'type': 'str'},
        'source_vm_cpu_count': {'key': 'sourceVmCpuCount', 'type': 'int'},
        'source_vm_ram_size_in_mb': {'key': 'sourceVmRamSizeInMB', 'type': 'int'},
        'os_details': {'key': 'osDetails', 'type': 'OSDiskDetails'},
        'protection_stage': {'key': 'protectionStage', 'type': 'str'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'vm_protection_state': {'key': 'vmProtectionState', 'type': 'str'},
        'vm_protection_state_description': {'key': 'vmProtectionStateDescription', 'type': 'str'},
        'resync_details': {'key': 'resyncDetails', 'type': 'InitialReplicationDetails'},
        'retention_window_start': {'key': 'retentionWindowStart', 'type': 'iso-8601'},
        'retention_window_end': {'key': 'retentionWindowEnd', 'type': 'iso-8601'},
        'compressed_data_rate_in_mb': {'key': 'compressedDataRateInMB', 'type': 'float'},
        'uncompressed_data_rate_in_mb': {'key': 'uncompressedDataRateInMB', 'type': 'float'},
        'rpo_in_seconds': {'key': 'rpoInSeconds', 'type': 'long'},
        'protected_disks': {'key': 'protectedDisks', 'type': '[InMageProtectedDiskDetails]'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'last_heartbeat': {'key': 'lastHeartbeat', 'type': 'iso-8601'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'master_target_id': {'key': 'masterTargetId', 'type': 'str'},
        'consistency_points': {'key': 'consistencyPoints', 'type': '{iso-8601}'},
        'disk_resized': {'key': 'diskResized', 'type': 'str'},
        'reboot_after_update_status': {'key': 'rebootAfterUpdateStatus', 'type': 'str'},
        'multi_vm_group_id': {'key': 'multiVmGroupId', 'type': 'str'},
        'multi_vm_group_name': {'key': 'multiVmGroupName', 'type': 'str'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
        'agent_details': {'key': 'agentDetails', 'type': 'InMageAgentDetails'},
        'v_center_infrastructure_id': {'key': 'vCenterInfrastructureId', 'type': 'str'},
        'infrastructure_vm_id': {'key': 'infrastructureVmId', 'type': 'str'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMNicDetails]'},
        'discovery_type': {'key': 'discoveryType', 'type': 'str'},
        'azure_storage_account_id': {'key': 'azureStorageAccountId', 'type': 'str'},
        'datastores': {'key': 'datastores', 'type': '[str]'},
        'validation_errors': {'key': 'validationErrors', 'type': '[HealthError]'},
        'last_rpo_calculated_time': {'key': 'lastRpoCalculatedTime', 'type': 'iso-8601'},
        'last_update_received_time': {'key': 'lastUpdateReceivedTime', 'type': 'iso-8601'},
        'replica_id': {'key': 'replicaId', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'is_additional_stats_available': {'key': 'isAdditionalStatsAvailable', 'type': 'bool'},
        'total_data_transferred': {'key': 'totalDataTransferred', 'type': 'long'},
        'total_progress_health': {'key': 'totalProgressHealth', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        active_site_type: Optional[str] = None,
        source_vm_cpu_count: Optional[int] = None,
        source_vm_ram_size_in_mb: Optional[int] = None,
        os_details: Optional["OSDiskDetails"] = None,
        protection_stage: Optional[str] = None,
        vm_id: Optional[str] = None,
        vm_protection_state: Optional[str] = None,
        vm_protection_state_description: Optional[str] = None,
        resync_details: Optional["InitialReplicationDetails"] = None,
        retention_window_start: Optional[datetime.datetime] = None,
        retention_window_end: Optional[datetime.datetime] = None,
        compressed_data_rate_in_mb: Optional[float] = None,
        uncompressed_data_rate_in_mb: Optional[float] = None,
        rpo_in_seconds: Optional[int] = None,
        protected_disks: Optional[List["InMageProtectedDiskDetails"]] = None,
        ip_address: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        process_server_id: Optional[str] = None,
        master_target_id: Optional[str] = None,
        consistency_points: Optional[Dict[str, datetime.datetime]] = None,
        disk_resized: Optional[str] = None,
        reboot_after_update_status: Optional[str] = None,
        multi_vm_group_id: Optional[str] = None,
        multi_vm_group_name: Optional[str] = None,
        multi_vm_sync_status: Optional[str] = None,
        agent_details: Optional["InMageAgentDetails"] = None,
        v_center_infrastructure_id: Optional[str] = None,
        infrastructure_vm_id: Optional[str] = None,
        vm_nics: Optional[List["VMNicDetails"]] = None,
        discovery_type: Optional[str] = None,
        azure_storage_account_id: Optional[str] = None,
        datastores: Optional[List[str]] = None,
        validation_errors: Optional[List["HealthError"]] = None,
        last_rpo_calculated_time: Optional[datetime.datetime] = None,
        last_update_received_time: Optional[datetime.datetime] = None,
        replica_id: Optional[str] = None,
        os_version: Optional[str] = None,
        is_additional_stats_available: Optional[bool] = None,
        total_data_transferred: Optional[int] = None,
        total_progress_health: Optional[str] = None,
        **kwargs
    ):
        super(InMageReplicationDetails, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.active_site_type = active_site_type
        self.source_vm_cpu_count = source_vm_cpu_count
        self.source_vm_ram_size_in_mb = source_vm_ram_size_in_mb
        self.os_details = os_details
        self.protection_stage = protection_stage
        self.vm_id = vm_id
        self.vm_protection_state = vm_protection_state
        self.vm_protection_state_description = vm_protection_state_description
        self.resync_details = resync_details
        self.retention_window_start = retention_window_start
        self.retention_window_end = retention_window_end
        self.compressed_data_rate_in_mb = compressed_data_rate_in_mb
        self.uncompressed_data_rate_in_mb = uncompressed_data_rate_in_mb
        self.rpo_in_seconds = rpo_in_seconds
        self.protected_disks = protected_disks
        self.ip_address = ip_address
        self.last_heartbeat = last_heartbeat
        self.process_server_id = process_server_id
        self.master_target_id = master_target_id
        self.consistency_points = consistency_points
        self.disk_resized = disk_resized
        self.reboot_after_update_status = reboot_after_update_status
        self.multi_vm_group_id = multi_vm_group_id
        self.multi_vm_group_name = multi_vm_group_name
        self.multi_vm_sync_status = multi_vm_sync_status
        self.agent_details = agent_details
        self.v_center_infrastructure_id = v_center_infrastructure_id
        self.infrastructure_vm_id = infrastructure_vm_id
        self.vm_nics = vm_nics
        self.discovery_type = discovery_type
        self.azure_storage_account_id = azure_storage_account_id
        self.datastores = datastores
        self.validation_errors = validation_errors
        self.last_rpo_calculated_time = last_rpo_calculated_time
        self.last_update_received_time = last_update_received_time
        self.replica_id = replica_id
        self.os_version = os_version
        self.is_additional_stats_available = is_additional_stats_available
        self.total_data_transferred = total_data_transferred
        self.total_progress_health = total_progress_health


class InMageReprotectInput(ReverseReplicationProviderSpecificInput):
    """InMageAzureV2 specific provider input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param master_target_id: Required. The Master Target Id.
    :type master_target_id: str
    :param process_server_id: Required. The Process Server Id.
    :type process_server_id: str
    :param retention_drive: Required. The retention drive to use on the MT.
    :type retention_drive: str
    :param run_as_account_id: The CS account Id.
    :type run_as_account_id: str
    :param datastore_name: The target datastore name.
    :type datastore_name: str
    :param disk_exclusion_input: The enable disk exclusion input.
    :type disk_exclusion_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskExclusionInput
    :param profile_id: Required. The Policy Id.
    :type profile_id: str
    :param disks_to_include: The disks to include list.
    :type disks_to_include: list[str]
    """

    _validation = {
        'instance_type': {'required': True},
        'master_target_id': {'required': True},
        'process_server_id': {'required': True},
        'retention_drive': {'required': True},
        'profile_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'master_target_id': {'key': 'masterTargetId', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'retention_drive': {'key': 'retentionDrive', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
        'datastore_name': {'key': 'datastoreName', 'type': 'str'},
        'disk_exclusion_input': {'key': 'diskExclusionInput', 'type': 'InMageDiskExclusionInput'},
        'profile_id': {'key': 'profileId', 'type': 'str'},
        'disks_to_include': {'key': 'disksToInclude', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        master_target_id: str,
        process_server_id: str,
        retention_drive: str,
        profile_id: str,
        run_as_account_id: Optional[str] = None,
        datastore_name: Optional[str] = None,
        disk_exclusion_input: Optional["InMageDiskExclusionInput"] = None,
        disks_to_include: Optional[List[str]] = None,
        **kwargs
    ):
        super(InMageReprotectInput, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.master_target_id = master_target_id
        self.process_server_id = process_server_id
        self.retention_drive = retention_drive
        self.run_as_account_id = run_as_account_id
        self.datastore_name = datastore_name
        self.disk_exclusion_input = disk_exclusion_input
        self.profile_id = profile_id
        self.disks_to_include = disks_to_include


class InMageTestFailoverInput(TestFailoverProviderSpecificInput):
    """Provider specific input for InMage test failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_type: The recovery point type. Values from LatestTime, LatestTag or
     Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In
     the other two cases, recovery point id will be ignored. Possible values include: "LatestTime",
     "LatestTag", "Custom".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointType
    :param recovery_point_id: The recovery point id to be passed to test failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Optional[Union[str, "RecoveryPointType"]] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageTestFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.recovery_point_type = recovery_point_type
        self.recovery_point_id = recovery_point_id


class InMageUnplannedFailoverInput(UnplannedFailoverProviderSpecificInput):
    """Provider specific input for InMage unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_type: The recovery point type. Values from LatestTime, LatestTag or
     Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In
     the other two cases, recovery point id will be ignored. Possible values include: "LatestTime",
     "LatestTag", "Custom".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointType
    :param recovery_point_id: The recovery point id to be passed to failover to a particular
     recovery point. In case of latest recovery point, null should be passed.
    :type recovery_point_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Optional[Union[str, "RecoveryPointType"]] = None,
        recovery_point_id: Optional[str] = None,
        **kwargs
    ):
        super(InMageUnplannedFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.recovery_point_type = recovery_point_type
        self.recovery_point_id = recovery_point_id


class InMageVolumeExclusionOptions(msrest.serialization.Model):
    """Guest disk signature based disk exclusion option when doing enable protection of virtual machine in InMage provider.

    :param volume_label: The volume label. The disk having any volume with this label will be
     excluded from replication.
    :type volume_label: str
    :param only_exclude_if_single_volume: The value indicating whether to exclude multi volume disk
     or not. If a disk has multiple volumes and one of the volume has label matching with
     VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
    :type only_exclude_if_single_volume: str
    """

    _attribute_map = {
        'volume_label': {'key': 'volumeLabel', 'type': 'str'},
        'only_exclude_if_single_volume': {'key': 'onlyExcludeIfSingleVolume', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        volume_label: Optional[str] = None,
        only_exclude_if_single_volume: Optional[str] = None,
        **kwargs
    ):
        super(InMageVolumeExclusionOptions, self).__init__(**kwargs)
        self.volume_label = volume_label
        self.only_exclude_if_single_volume = only_exclude_if_single_volume


class InnerHealthError(msrest.serialization.Model):
    """Implements InnerHealthError class. HealthError object has a list of InnerHealthErrors as child errors. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.

    :param error_source: Source of error.
    :type error_source: str
    :param error_type: Type of error.
    :type error_type: str
    :param error_level: Level of error.
    :type error_level: str
    :param error_category: Category of error.
    :type error_category: str
    :param error_code: Error code.
    :type error_code: str
    :param summary_message: Summary message of the entity.
    :type summary_message: str
    :param error_message: Error message.
    :type error_message: str
    :param possible_causes: Possible causes of error.
    :type possible_causes: str
    :param recommended_action: Recommended action to resolve error.
    :type recommended_action: str
    :param creation_time_utc: Error creation time (UTC).
    :type creation_time_utc: ~datetime.datetime
    :param recovery_provider_error_message: DRA error message.
    :type recovery_provider_error_message: str
    :param entity_id: ID of the entity.
    :type entity_id: str
    :param error_id: The health error unique id.
    :type error_id: str
    :param customer_resolvability: Value indicating whether the health error is customer
     resolvable. Possible values include: "Allowed", "NotAllowed".
    :type customer_resolvability: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorCustomerResolvability
    """

    _attribute_map = {
        'error_source': {'key': 'errorSource', 'type': 'str'},
        'error_type': {'key': 'errorType', 'type': 'str'},
        'error_level': {'key': 'errorLevel', 'type': 'str'},
        'error_category': {'key': 'errorCategory', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'summary_message': {'key': 'summaryMessage', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'possible_causes': {'key': 'possibleCauses', 'type': 'str'},
        'recommended_action': {'key': 'recommendedAction', 'type': 'str'},
        'creation_time_utc': {'key': 'creationTimeUtc', 'type': 'iso-8601'},
        'recovery_provider_error_message': {'key': 'recoveryProviderErrorMessage', 'type': 'str'},
        'entity_id': {'key': 'entityId', 'type': 'str'},
        'error_id': {'key': 'errorId', 'type': 'str'},
        'customer_resolvability': {'key': 'customerResolvability', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        error_source: Optional[str] = None,
        error_type: Optional[str] = None,
        error_level: Optional[str] = None,
        error_category: Optional[str] = None,
        error_code: Optional[str] = None,
        summary_message: Optional[str] = None,
        error_message: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        creation_time_utc: Optional[datetime.datetime] = None,
        recovery_provider_error_message: Optional[str] = None,
        entity_id: Optional[str] = None,
        error_id: Optional[str] = None,
        customer_resolvability: Optional[Union[str, "HealthErrorCustomerResolvability"]] = None,
        **kwargs
    ):
        super(InnerHealthError, self).__init__(**kwargs)
        self.error_source = error_source
        self.error_type = error_type
        self.error_level = error_level
        self.error_category = error_category
        self.error_code = error_code
        self.summary_message = summary_message
        self.error_message = error_message
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action
        self.creation_time_utc = creation_time_utc
        self.recovery_provider_error_message = recovery_provider_error_message
        self.entity_id = entity_id
        self.error_id = error_id
        self.customer_resolvability = customer_resolvability


class InputEndpoint(msrest.serialization.Model):
    """InputEndpoint.

    :param endpoint_name:
    :type endpoint_name: str
    :param private_port:
    :type private_port: int
    :param public_port:
    :type public_port: int
    :param protocol:
    :type protocol: str
    """

    _attribute_map = {
        'endpoint_name': {'key': 'endpointName', 'type': 'str'},
        'private_port': {'key': 'privatePort', 'type': 'int'},
        'public_port': {'key': 'publicPort', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        endpoint_name: Optional[str] = None,
        private_port: Optional[int] = None,
        public_port: Optional[int] = None,
        protocol: Optional[str] = None,
        **kwargs
    ):
        super(InputEndpoint, self).__init__(**kwargs)
        self.endpoint_name = endpoint_name
        self.private_port = private_port
        self.public_port = public_port
        self.protocol = protocol


class IPConfigDetails(msrest.serialization.Model):
    """IPConfigDetails.

    :param name:
    :type name: str
    :param is_primary:
    :type is_primary: bool
    :param subnet_name:
    :type subnet_name: str
    :param static_ip_address:
    :type static_ip_address: str
    :param ip_address_type:
    :type ip_address_type: str
    :param is_seleted_for_failover:
    :type is_seleted_for_failover: bool
    :param recovery_subnet_name:
    :type recovery_subnet_name: str
    :param recovery_static_ip_address:
    :type recovery_static_ip_address: str
    :param recovery_ip_address_type:
    :type recovery_ip_address_type: str
    :param recovery_public_ip_address_id:
    :type recovery_public_ip_address_id: str
    :param recovery_lb_backend_address_pool_ids:
    :type recovery_lb_backend_address_pool_ids: list[str]
    :param tfo_subnet_name:
    :type tfo_subnet_name: str
    :param tfo_static_ip_address:
    :type tfo_static_ip_address: str
    :param tfo_public_ip_address_id:
    :type tfo_public_ip_address_id: str
    :param tfo_lb_backend_address_pool_ids:
    :type tfo_lb_backend_address_pool_ids: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_primary': {'key': 'isPrimary', 'type': 'bool'},
        'subnet_name': {'key': 'subnetName', 'type': 'str'},
        'static_ip_address': {'key': 'staticIPAddress', 'type': 'str'},
        'ip_address_type': {'key': 'ipAddressType', 'type': 'str'},
        'is_seleted_for_failover': {'key': 'isSeletedForFailover', 'type': 'bool'},
        'recovery_subnet_name': {'key': 'recoverySubnetName', 'type': 'str'},
        'recovery_static_ip_address': {'key': 'recoveryStaticIPAddress', 'type': 'str'},
        'recovery_ip_address_type': {'key': 'recoveryIPAddressType', 'type': 'str'},
        'recovery_public_ip_address_id': {'key': 'recoveryPublicIPAddressId', 'type': 'str'},
        'recovery_lb_backend_address_pool_ids': {'key': 'recoveryLBBackendAddressPoolIds', 'type': '[str]'},
        'tfo_subnet_name': {'key': 'tfoSubnetName', 'type': 'str'},
        'tfo_static_ip_address': {'key': 'tfoStaticIPAddress', 'type': 'str'},
        'tfo_public_ip_address_id': {'key': 'tfoPublicIPAddressId', 'type': 'str'},
        'tfo_lb_backend_address_pool_ids': {'key': 'tfoLBBackendAddressPoolIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_primary: Optional[bool] = None,
        subnet_name: Optional[str] = None,
        static_ip_address: Optional[str] = None,
        ip_address_type: Optional[str] = None,
        is_seleted_for_failover: Optional[bool] = None,
        recovery_subnet_name: Optional[str] = None,
        recovery_static_ip_address: Optional[str] = None,
        recovery_ip_address_type: Optional[str] = None,
        recovery_public_ip_address_id: Optional[str] = None,
        recovery_lb_backend_address_pool_ids: Optional[List[str]] = None,
        tfo_subnet_name: Optional[str] = None,
        tfo_static_ip_address: Optional[str] = None,
        tfo_public_ip_address_id: Optional[str] = None,
        tfo_lb_backend_address_pool_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(IPConfigDetails, self).__init__(**kwargs)
        self.name = name
        self.is_primary = is_primary
        self.subnet_name = subnet_name
        self.static_ip_address = static_ip_address
        self.ip_address_type = ip_address_type
        self.is_seleted_for_failover = is_seleted_for_failover
        self.recovery_subnet_name = recovery_subnet_name
        self.recovery_static_ip_address = recovery_static_ip_address
        self.recovery_ip_address_type = recovery_ip_address_type
        self.recovery_public_ip_address_id = recovery_public_ip_address_id
        self.recovery_lb_backend_address_pool_ids = recovery_lb_backend_address_pool_ids
        self.tfo_subnet_name = tfo_subnet_name
        self.tfo_static_ip_address = tfo_static_ip_address
        self.tfo_public_ip_address_id = tfo_public_ip_address_id
        self.tfo_lb_backend_address_pool_ids = tfo_lb_backend_address_pool_ids


class IPConfigInputDetails(msrest.serialization.Model):
    """IPConfigInputDetails.

    :param ip_config_name:
    :type ip_config_name: str
    :param is_primary:
    :type is_primary: bool
    :param is_seleted_for_failover:
    :type is_seleted_for_failover: bool
    :param recovery_subnet_name:
    :type recovery_subnet_name: str
    :param recovery_static_ip_address:
    :type recovery_static_ip_address: str
    :param recovery_public_ip_address_id:
    :type recovery_public_ip_address_id: str
    :param recovery_lb_backend_address_pool_ids:
    :type recovery_lb_backend_address_pool_ids: list[str]
    :param tfo_subnet_name:
    :type tfo_subnet_name: str
    :param tfo_static_ip_address:
    :type tfo_static_ip_address: str
    :param tfo_public_ip_address_id:
    :type tfo_public_ip_address_id: str
    :param tfo_lb_backend_address_pool_ids:
    :type tfo_lb_backend_address_pool_ids: list[str]
    """

    _attribute_map = {
        'ip_config_name': {'key': 'ipConfigName', 'type': 'str'},
        'is_primary': {'key': 'isPrimary', 'type': 'bool'},
        'is_seleted_for_failover': {'key': 'isSeletedForFailover', 'type': 'bool'},
        'recovery_subnet_name': {'key': 'recoverySubnetName', 'type': 'str'},
        'recovery_static_ip_address': {'key': 'recoveryStaticIPAddress', 'type': 'str'},
        'recovery_public_ip_address_id': {'key': 'recoveryPublicIPAddressId', 'type': 'str'},
        'recovery_lb_backend_address_pool_ids': {'key': 'recoveryLBBackendAddressPoolIds', 'type': '[str]'},
        'tfo_subnet_name': {'key': 'tfoSubnetName', 'type': 'str'},
        'tfo_static_ip_address': {'key': 'tfoStaticIPAddress', 'type': 'str'},
        'tfo_public_ip_address_id': {'key': 'tfoPublicIPAddressId', 'type': 'str'},
        'tfo_lb_backend_address_pool_ids': {'key': 'tfoLBBackendAddressPoolIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        ip_config_name: Optional[str] = None,
        is_primary: Optional[bool] = None,
        is_seleted_for_failover: Optional[bool] = None,
        recovery_subnet_name: Optional[str] = None,
        recovery_static_ip_address: Optional[str] = None,
        recovery_public_ip_address_id: Optional[str] = None,
        recovery_lb_backend_address_pool_ids: Optional[List[str]] = None,
        tfo_subnet_name: Optional[str] = None,
        tfo_static_ip_address: Optional[str] = None,
        tfo_public_ip_address_id: Optional[str] = None,
        tfo_lb_backend_address_pool_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(IPConfigInputDetails, self).__init__(**kwargs)
        self.ip_config_name = ip_config_name
        self.is_primary = is_primary
        self.is_seleted_for_failover = is_seleted_for_failover
        self.recovery_subnet_name = recovery_subnet_name
        self.recovery_static_ip_address = recovery_static_ip_address
        self.recovery_public_ip_address_id = recovery_public_ip_address_id
        self.recovery_lb_backend_address_pool_ids = recovery_lb_backend_address_pool_ids
        self.tfo_subnet_name = tfo_subnet_name
        self.tfo_static_ip_address = tfo_static_ip_address
        self.tfo_public_ip_address_id = tfo_public_ip_address_id
        self.tfo_lb_backend_address_pool_ids = tfo_lb_backend_address_pool_ids


class Job(Resource):
    """Job details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The custom data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.JobProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'JobProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["JobProperties"] = None,
        **kwargs
    ):
        super(Job, self).__init__(location=location, **kwargs)
        self.properties = properties


class JobCollection(msrest.serialization.Model):
    """Collection of jobs.

    :param value: The list of jobs.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.Job]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Job]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Job"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(JobCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JobEntity(msrest.serialization.Model):
    """This class contains the minimal job details required to navigate to the desired drill down.

    :param job_id: The job id.
    :type job_id: str
    :param job_friendly_name: The job display name.
    :type job_friendly_name: str
    :param target_object_id: The object id.
    :type target_object_id: str
    :param target_object_name: The object name.
    :type target_object_name: str
    :param target_instance_type: The workflow affected object type.
    :type target_instance_type: str
    :param job_scenario_name: The job name. Enum type ScenarioName.
    :type job_scenario_name: str
    """

    _attribute_map = {
        'job_id': {'key': 'jobId', 'type': 'str'},
        'job_friendly_name': {'key': 'jobFriendlyName', 'type': 'str'},
        'target_object_id': {'key': 'targetObjectId', 'type': 'str'},
        'target_object_name': {'key': 'targetObjectName', 'type': 'str'},
        'target_instance_type': {'key': 'targetInstanceType', 'type': 'str'},
        'job_scenario_name': {'key': 'jobScenarioName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_id: Optional[str] = None,
        job_friendly_name: Optional[str] = None,
        target_object_id: Optional[str] = None,
        target_object_name: Optional[str] = None,
        target_instance_type: Optional[str] = None,
        job_scenario_name: Optional[str] = None,
        **kwargs
    ):
        super(JobEntity, self).__init__(**kwargs)
        self.job_id = job_id
        self.job_friendly_name = job_friendly_name
        self.target_object_id = target_object_id
        self.target_object_name = target_object_name
        self.target_instance_type = target_instance_type
        self.job_scenario_name = job_scenario_name


class JobErrorDetails(msrest.serialization.Model):
    """This class contains the error details per object.

    :param service_error_details: The Service error details.
    :type service_error_details: ~azure.mgmt.recoveryservicessiterecovery.models.ServiceError
    :param provider_error_details: The Provider error details.
    :type provider_error_details: ~azure.mgmt.recoveryservicessiterecovery.models.ProviderError
    :param error_level: Error level of error.
    :type error_level: str
    :param creation_time: The creation time of job error.
    :type creation_time: ~datetime.datetime
    :param task_id: The Id of the task.
    :type task_id: str
    """

    _attribute_map = {
        'service_error_details': {'key': 'serviceErrorDetails', 'type': 'ServiceError'},
        'provider_error_details': {'key': 'providerErrorDetails', 'type': 'ProviderError'},
        'error_level': {'key': 'errorLevel', 'type': 'str'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'task_id': {'key': 'taskId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_error_details: Optional["ServiceError"] = None,
        provider_error_details: Optional["ProviderError"] = None,
        error_level: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        task_id: Optional[str] = None,
        **kwargs
    ):
        super(JobErrorDetails, self).__init__(**kwargs)
        self.service_error_details = service_error_details
        self.provider_error_details = provider_error_details
        self.error_level = error_level
        self.creation_time = creation_time
        self.task_id = task_id


class JobProperties(msrest.serialization.Model):
    """Job custom data details.

    :param activity_id: The activity id.
    :type activity_id: str
    :param scenario_name: The ScenarioName.
    :type scenario_name: str
    :param friendly_name: The DisplayName.
    :type friendly_name: str
    :param state: The status of the Job. It is one of these values - NotStarted, InProgress,
     Succeeded, Failed, Cancelled, Suspended or Other.
    :type state: str
    :param state_description: The description of the state of the Job. For e.g. - For Succeeded
     state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
    :type state_description: str
    :param tasks: The tasks.
    :type tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    :param errors: The errors.
    :type errors: list[~azure.mgmt.recoveryservicessiterecovery.models.JobErrorDetails]
    :param start_time: The start time.
    :type start_time: ~datetime.datetime
    :param end_time: The end time.
    :type end_time: ~datetime.datetime
    :param allowed_actions: The Allowed action the job.
    :type allowed_actions: list[str]
    :param target_object_id: The affected Object Id.
    :type target_object_id: str
    :param target_object_name: The name of the affected object.
    :type target_object_name: str
    :param target_instance_type: The type of the affected object which is of
     Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType class.
    :type target_instance_type: str
    :param custom_details: The custom job details like test failover job details.
    :type custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.JobDetails
    """

    _attribute_map = {
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'scenario_name': {'key': 'scenarioName', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'state_description': {'key': 'stateDescription', 'type': 'str'},
        'tasks': {'key': 'tasks', 'type': '[ASRTask]'},
        'errors': {'key': 'errors', 'type': '[JobErrorDetails]'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'allowed_actions': {'key': 'allowedActions', 'type': '[str]'},
        'target_object_id': {'key': 'targetObjectId', 'type': 'str'},
        'target_object_name': {'key': 'targetObjectName', 'type': 'str'},
        'target_instance_type': {'key': 'targetInstanceType', 'type': 'str'},
        'custom_details': {'key': 'customDetails', 'type': 'JobDetails'},
    }

    def __init__(
        self,
        *,
        activity_id: Optional[str] = None,
        scenario_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        state: Optional[str] = None,
        state_description: Optional[str] = None,
        tasks: Optional[List["ASRTask"]] = None,
        errors: Optional[List["JobErrorDetails"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        allowed_actions: Optional[List[str]] = None,
        target_object_id: Optional[str] = None,
        target_object_name: Optional[str] = None,
        target_instance_type: Optional[str] = None,
        custom_details: Optional["JobDetails"] = None,
        **kwargs
    ):
        super(JobProperties, self).__init__(**kwargs)
        self.activity_id = activity_id
        self.scenario_name = scenario_name
        self.friendly_name = friendly_name
        self.state = state
        self.state_description = state_description
        self.tasks = tasks
        self.errors = errors
        self.start_time = start_time
        self.end_time = end_time
        self.allowed_actions = allowed_actions
        self.target_object_id = target_object_id
        self.target_object_name = target_object_name
        self.target_instance_type = target_instance_type
        self.custom_details = custom_details


class JobQueryParameter(msrest.serialization.Model):
    """Query parameter to enumerate jobs.

    :param start_time: Date time to get jobs from.
    :type start_time: str
    :param end_time: Date time to get jobs upto.
    :type end_time: str
    :param fabric_id: The Id of the fabric to search jobs under.
    :type fabric_id: str
    :param affected_object_types: The type of objects.
    :type affected_object_types: str
    :param job_status: The states of the job to be filtered can be in.
    :type job_status: str
    :param job_output_type: The output type of the jobs. Possible values include: "Json", "Xml",
     "Excel".
    :type job_output_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.ExportJobOutputSerializationType
    :param job_name: The job Name.
    :type job_name: str
    :param timezone_offset: The timezone offset for the location of the request (in minutes).
    :type timezone_offset: float
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'fabric_id': {'key': 'fabricId', 'type': 'str'},
        'affected_object_types': {'key': 'affectedObjectTypes', 'type': 'str'},
        'job_status': {'key': 'jobStatus', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
        'job_name': {'key': 'jobName', 'type': 'str'},
        'timezone_offset': {'key': 'timezoneOffset', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        fabric_id: Optional[str] = None,
        affected_object_types: Optional[str] = None,
        job_status: Optional[str] = None,
        job_output_type: Optional[Union[str, "ExportJobOutputSerializationType"]] = None,
        job_name: Optional[str] = None,
        timezone_offset: Optional[float] = None,
        **kwargs
    ):
        super(JobQueryParameter, self).__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.fabric_id = fabric_id
        self.affected_object_types = affected_object_types
        self.job_status = job_status
        self.job_output_type = job_output_type
        self.job_name = job_name
        self.timezone_offset = timezone_offset


class JobStatusEventDetails(EventSpecificDetails):
    """Model class for event details of a job status event.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param job_id: Job arm id for the event.
    :type job_id: str
    :param job_friendly_name: JobName for the Event.
    :type job_friendly_name: str
    :param job_status: JobStatus for the Event.
    :type job_status: str
    :param affected_object_type: AffectedObjectType for the event.
    :type affected_object_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'job_friendly_name': {'key': 'jobFriendlyName', 'type': 'str'},
        'job_status': {'key': 'jobStatus', 'type': 'str'},
        'affected_object_type': {'key': 'affectedObjectType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_id: Optional[str] = None,
        job_friendly_name: Optional[str] = None,
        job_status: Optional[str] = None,
        affected_object_type: Optional[str] = None,
        **kwargs
    ):
        super(JobStatusEventDetails, self).__init__(**kwargs)
        self.instance_type = 'JobStatus'  # type: str
        self.job_id = job_id
        self.job_friendly_name = job_friendly_name
        self.job_status = job_status
        self.affected_object_type = affected_object_type


class KeyEncryptionKeyInfo(msrest.serialization.Model):
    """Key Encryption Key (KEK) information.

    :param key_identifier: The key URL / identifier.
    :type key_identifier: str
    :param key_vault_resource_arm_id: The KeyVault resource ARM Id for key.
    :type key_vault_resource_arm_id: str
    """

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'key_vault_resource_arm_id': {'key': 'keyVaultResourceArmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_identifier: Optional[str] = None,
        key_vault_resource_arm_id: Optional[str] = None,
        **kwargs
    ):
        super(KeyEncryptionKeyInfo, self).__init__(**kwargs)
        self.key_identifier = key_identifier
        self.key_vault_resource_arm_id = key_vault_resource_arm_id


class LogicalNetwork(Resource):
    """Logical network data model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The Logical Network Properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.LogicalNetworkProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'LogicalNetworkProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["LogicalNetworkProperties"] = None,
        **kwargs
    ):
        super(LogicalNetwork, self).__init__(location=location, **kwargs)
        self.properties = properties


class LogicalNetworkCollection(msrest.serialization.Model):
    """List of logical networks.

    :param value: The Logical Networks list details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.LogicalNetwork]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LogicalNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LogicalNetwork"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(LogicalNetworkCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogicalNetworkProperties(msrest.serialization.Model):
    """Logical Network Properties.

    :param friendly_name: The Friendly Name.
    :type friendly_name: str
    :param network_virtualization_status: A value indicating whether Network Virtualization is
     enabled for the logical network.
    :type network_virtualization_status: str
    :param logical_network_usage: A value indicating whether logical network is used as private
     test network by test failover.
    :type logical_network_usage: str
    :param logical_network_definitions_status: A value indicating whether logical network
     definitions are isolated.
    :type logical_network_definitions_status: str
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'network_virtualization_status': {'key': 'networkVirtualizationStatus', 'type': 'str'},
        'logical_network_usage': {'key': 'logicalNetworkUsage', 'type': 'str'},
        'logical_network_definitions_status': {'key': 'logicalNetworkDefinitionsStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        network_virtualization_status: Optional[str] = None,
        logical_network_usage: Optional[str] = None,
        logical_network_definitions_status: Optional[str] = None,
        **kwargs
    ):
        super(LogicalNetworkProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.network_virtualization_status = network_virtualization_status
        self.logical_network_usage = logical_network_usage
        self.logical_network_definitions_status = logical_network_definitions_status


class ManualActionTaskDetails(TaskTypeDetails):
    """This class represents the manual action task details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param name: The name.
    :type name: str
    :param instructions: The instructions.
    :type instructions: str
    :param observation: The observation.
    :type observation: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'instructions': {'key': 'instructions', 'type': 'str'},
        'observation': {'key': 'observation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        instructions: Optional[str] = None,
        observation: Optional[str] = None,
        **kwargs
    ):
        super(ManualActionTaskDetails, self).__init__(**kwargs)
        self.instance_type = 'ManualActionTaskDetails'  # type: str
        self.name = name
        self.instructions = instructions
        self.observation = observation


class MarsAgentDetails(msrest.serialization.Model):
    """Mars agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Mars agent Id.
    :vartype id: str
    :ivar name: The Mars agent name.
    :vartype name: str
    :ivar bios_id: The Mars agent Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The Mars agent Fqdn.
    :vartype fqdn: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the Mars agent.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health of the Mars agent. Possible values include: "None", "Normal",
     "Warning", "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'bios_id': {'readonly': True},
        'fabric_object_id': {'readonly': True},
        'fqdn': {'readonly': True},
        'version': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'health': {'readonly': True},
        'health_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'health': {'key': 'health', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MarsAgentDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None


class MasterTargetServer(msrest.serialization.Model):
    """Details of a Master Target Server.

    :param id: The server Id.
    :type id: str
    :param ip_address: The IP address of the server.
    :type ip_address: str
    :param name: The server name.
    :type name: str
    :param os_type: The OS type of the server.
    :type os_type: str
    :param agent_version: The version of the scout component on the server.
    :type agent_version: str
    :param last_heartbeat: The last heartbeat received from the server.
    :type last_heartbeat: ~datetime.datetime
    :param version_status: Version status.
    :type version_status: str
    :param retention_volumes: The retention volumes of Master target Server.
    :type retention_volumes: list[~azure.mgmt.recoveryservicessiterecovery.models.RetentionVolume]
    :param data_stores: The list of data stores in the fabric.
    :type data_stores: list[~azure.mgmt.recoveryservicessiterecovery.models.DataStore]
    :param validation_errors: Validation errors.
    :type validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param health_errors: Health errors.
    :type health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param disk_count: Disk count of the master target.
    :type disk_count: int
    :param os_version: OS Version of the master target.
    :type os_version: str
    :param agent_expiry_date: Agent expiry date.
    :type agent_expiry_date: ~datetime.datetime
    :param mars_agent_version: MARS agent version.
    :type mars_agent_version: str
    :param mars_agent_expiry_date: MARS agent expiry date.
    :type mars_agent_expiry_date: ~datetime.datetime
    :param agent_version_details: Agent version details.
    :type agent_version_details: ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
    :param mars_agent_version_details: Mars agent version details.
    :type mars_agent_version_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'last_heartbeat': {'key': 'lastHeartbeat', 'type': 'iso-8601'},
        'version_status': {'key': 'versionStatus', 'type': 'str'},
        'retention_volumes': {'key': 'retentionVolumes', 'type': '[RetentionVolume]'},
        'data_stores': {'key': 'dataStores', 'type': '[DataStore]'},
        'validation_errors': {'key': 'validationErrors', 'type': '[HealthError]'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
        'disk_count': {'key': 'diskCount', 'type': 'int'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'agent_expiry_date': {'key': 'agentExpiryDate', 'type': 'iso-8601'},
        'mars_agent_version': {'key': 'marsAgentVersion', 'type': 'str'},
        'mars_agent_expiry_date': {'key': 'marsAgentExpiryDate', 'type': 'iso-8601'},
        'agent_version_details': {'key': 'agentVersionDetails', 'type': 'VersionDetails'},
        'mars_agent_version_details': {'key': 'marsAgentVersionDetails', 'type': 'VersionDetails'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        ip_address: Optional[str] = None,
        name: Optional[str] = None,
        os_type: Optional[str] = None,
        agent_version: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        version_status: Optional[str] = None,
        retention_volumes: Optional[List["RetentionVolume"]] = None,
        data_stores: Optional[List["DataStore"]] = None,
        validation_errors: Optional[List["HealthError"]] = None,
        health_errors: Optional[List["HealthError"]] = None,
        disk_count: Optional[int] = None,
        os_version: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        mars_agent_version: Optional[str] = None,
        mars_agent_expiry_date: Optional[datetime.datetime] = None,
        agent_version_details: Optional["VersionDetails"] = None,
        mars_agent_version_details: Optional["VersionDetails"] = None,
        **kwargs
    ):
        super(MasterTargetServer, self).__init__(**kwargs)
        self.id = id
        self.ip_address = ip_address
        self.name = name
        self.os_type = os_type
        self.agent_version = agent_version
        self.last_heartbeat = last_heartbeat
        self.version_status = version_status
        self.retention_volumes = retention_volumes
        self.data_stores = data_stores
        self.validation_errors = validation_errors
        self.health_errors = health_errors
        self.disk_count = disk_count
        self.os_version = os_version
        self.agent_expiry_date = agent_expiry_date
        self.mars_agent_version = mars_agent_version
        self.mars_agent_expiry_date = mars_agent_expiry_date
        self.agent_version_details = agent_version_details
        self.mars_agent_version_details = mars_agent_version_details


class MigrateInput(msrest.serialization.Model):
    """Input for migrate.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Migrate input properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.MigrateInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'MigrateInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "MigrateInputProperties",
        **kwargs
    ):
        super(MigrateInput, self).__init__(**kwargs)
        self.properties = properties


class MigrateInputProperties(msrest.serialization.Model):
    """Migrate input properties.

    All required parameters must be populated in order to send to Azure.

    :param provider_specific_details: Required. The provider specific details.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrateProviderSpecificInput
    """

    _validation = {
        'provider_specific_details': {'required': True},
    }

    _attribute_map = {
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'MigrateProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: "MigrateProviderSpecificInput",
        **kwargs
    ):
        super(MigrateInputProperties, self).__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class MigrateProviderSpecificInput(msrest.serialization.Model):
    """Migrate provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VMwareCbtMigrateInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'VMwareCbt': 'VMwareCbtMigrateInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class MigrationItem(Resource):
    """Migration item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The migration item properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.MigrationItemProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MigrationItemProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["MigrationItemProperties"] = None,
        **kwargs
    ):
        super(MigrationItem, self).__init__(location=location, **kwargs)
        self.properties = properties


class MigrationItemCollection(msrest.serialization.Model):
    """Migration item collection.

    :param value: The list of migration items.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.MigrationItem]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MigrationItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MigrationItem"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(MigrationItemCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MigrationItemProperties(msrest.serialization.Model):
    """Migration item properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar machine_name: The on-premise virtual machine name.
    :vartype machine_name: str
    :ivar policy_id: The ARM Id of policy governing this item.
    :vartype policy_id: str
    :ivar policy_friendly_name: The name of policy governing this item.
    :vartype policy_friendly_name: str
    :ivar migration_state: The migration status. Possible values include: "None",
     "EnableMigrationInProgress", "EnableMigrationFailed", "DisableMigrationInProgress",
     "DisableMigrationFailed", "InitialSeedingInProgress", "InitialSeedingFailed", "Replicating",
     "MigrationInProgress", "MigrationSucceeded", "MigrationFailed".
    :vartype migration_state: str or ~azure.mgmt.recoveryservicessiterecovery.models.MigrationState
    :ivar migration_state_description: The migration state description.
    :vartype migration_state_description: str
    :ivar last_test_migration_time: The last test migration time.
    :vartype last_test_migration_time: ~datetime.datetime
    :ivar last_test_migration_status: The status of the last test migration.
    :vartype last_test_migration_status: str
    :ivar test_migrate_state: The test migrate state. Possible values include: "None",
     "TestMigrationInProgress", "TestMigrationSucceeded", "TestMigrationFailed",
     "TestMigrationCleanupInProgress".
    :vartype test_migrate_state: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.TestMigrationState
    :ivar test_migrate_state_description: The test migrate state description.
    :vartype test_migrate_state_description: str
    :ivar health: The consolidated health. Possible values include: "None", "Normal", "Warning",
     "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The list of health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar allowed_operations: The allowed operations on the migration item based on the current
     migration state of the item.
    :vartype allowed_operations: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrationItemOperation]
    :ivar current_job: The current job details.
    :vartype current_job: ~azure.mgmt.recoveryservicessiterecovery.models.CurrentJobDetails
    :ivar event_correlation_id: The correlation Id for events associated with this migration item.
    :vartype event_correlation_id: str
    :param provider_specific_details: The migration provider custom settings.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrationProviderSpecificSettings
    """

    _validation = {
        'machine_name': {'readonly': True},
        'policy_id': {'readonly': True},
        'policy_friendly_name': {'readonly': True},
        'migration_state': {'readonly': True},
        'migration_state_description': {'readonly': True},
        'last_test_migration_time': {'readonly': True},
        'last_test_migration_status': {'readonly': True},
        'test_migrate_state': {'readonly': True},
        'test_migrate_state_description': {'readonly': True},
        'health': {'readonly': True},
        'health_errors': {'readonly': True},
        'allowed_operations': {'readonly': True},
        'current_job': {'readonly': True},
        'event_correlation_id': {'readonly': True},
    }

    _attribute_map = {
        'machine_name': {'key': 'machineName', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'policy_friendly_name': {'key': 'policyFriendlyName', 'type': 'str'},
        'migration_state': {'key': 'migrationState', 'type': 'str'},
        'migration_state_description': {'key': 'migrationStateDescription', 'type': 'str'},
        'last_test_migration_time': {'key': 'lastTestMigrationTime', 'type': 'iso-8601'},
        'last_test_migration_status': {'key': 'lastTestMigrationStatus', 'type': 'str'},
        'test_migrate_state': {'key': 'testMigrateState', 'type': 'str'},
        'test_migrate_state_description': {'key': 'testMigrateStateDescription', 'type': 'str'},
        'health': {'key': 'health', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
        'allowed_operations': {'key': 'allowedOperations', 'type': '[str]'},
        'current_job': {'key': 'currentJob', 'type': 'CurrentJobDetails'},
        'event_correlation_id': {'key': 'eventCorrelationId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'MigrationProviderSpecificSettings'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: Optional["MigrationProviderSpecificSettings"] = None,
        **kwargs
    ):
        super(MigrationItemProperties, self).__init__(**kwargs)
        self.machine_name = None
        self.policy_id = None
        self.policy_friendly_name = None
        self.migration_state = None
        self.migration_state_description = None
        self.last_test_migration_time = None
        self.last_test_migration_status = None
        self.test_migrate_state = None
        self.test_migrate_state_description = None
        self.health = None
        self.health_errors = None
        self.allowed_operations = None
        self.current_job = None
        self.event_correlation_id = None
        self.provider_specific_details = provider_specific_details


class MigrationItemsQueryParameter(msrest.serialization.Model):
    """Query parameter to enumerate migration items.

    :param source_fabric_name: The source fabric name filter.
    :type source_fabric_name: str
    :param source_container_name: The source container name filter.
    :type source_container_name: str
    :param instance_type: The replication provider type.
    :type instance_type: str
    """

    _attribute_map = {
        'source_fabric_name': {'key': 'sourceFabricName', 'type': 'str'},
        'source_container_name': {'key': 'sourceContainerName', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_fabric_name: Optional[str] = None,
        source_container_name: Optional[str] = None,
        instance_type: Optional[str] = None,
        **kwargs
    ):
        super(MigrationItemsQueryParameter, self).__init__(**kwargs)
        self.source_fabric_name = source_fabric_name
        self.source_container_name = source_container_name
        self.instance_type = instance_type


class MigrationProviderSpecificSettings(msrest.serialization.Model):
    """Migration provider specific settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VMwareCbtMigrationDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'VMwareCbt': 'VMwareCbtMigrationDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationProviderSpecificSettings, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class MigrationRecoveryPoint(Resource):
    """Recovery point for a migration item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: Recovery point properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrationRecoveryPointProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MigrationRecoveryPointProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["MigrationRecoveryPointProperties"] = None,
        **kwargs
    ):
        super(MigrationRecoveryPoint, self).__init__(location=location, **kwargs)
        self.properties = properties


class MigrationRecoveryPointCollection(msrest.serialization.Model):
    """Collection of migration recovery points.

    :param value: The migration recovery point details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.MigrationRecoveryPoint]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MigrationRecoveryPoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MigrationRecoveryPoint"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(MigrationRecoveryPointCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MigrationRecoveryPointProperties(msrest.serialization.Model):
    """Migration item recovery point properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recovery_point_time: The recovery point time.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_type: The recovery point type. Possible values include: "NotSpecified",
     "ApplicationConsistent", "CrashConsistent".
    :vartype recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MigrationRecoveryPointType
    """

    _validation = {
        'recovery_point_time': {'readonly': True},
        'recovery_point_type': {'readonly': True},
    }

    _attribute_map = {
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationRecoveryPointProperties, self).__init__(**kwargs)
        self.recovery_point_time = None
        self.recovery_point_type = None


class MobilityServiceUpdate(msrest.serialization.Model):
    """The Mobility Service update details.

    :param version: The version of the latest update.
    :type version: str
    :param reboot_status: The reboot status of the update - whether it is required or not.
    :type reboot_status: str
    :param os_type: The OS type.
    :type os_type: str
    """

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'reboot_status': {'key': 'rebootStatus', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        reboot_status: Optional[str] = None,
        os_type: Optional[str] = None,
        **kwargs
    ):
        super(MobilityServiceUpdate, self).__init__(**kwargs)
        self.version = version
        self.reboot_status = reboot_status
        self.os_type = os_type


class Network(Resource):
    """Network model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The Network Properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.NetworkProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'NetworkProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["NetworkProperties"] = None,
        **kwargs
    ):
        super(Network, self).__init__(location=location, **kwargs)
        self.properties = properties


class NetworkCollection(msrest.serialization.Model):
    """List of networks.

    :param value: The Networks list details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.Network]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Network]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Network"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NetworkCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkMapping(Resource):
    """Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The Network Mapping Properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.NetworkMappingProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'NetworkMappingProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["NetworkMappingProperties"] = None,
        **kwargs
    ):
        super(NetworkMapping, self).__init__(location=location, **kwargs)
        self.properties = properties


class NetworkMappingCollection(msrest.serialization.Model):
    """List of network mappings. As with NetworkMapping, it should be possible to reuse a prev version of this class. It doesn't seem likely this class could be anything more than a slightly bespoke collection of NetworkMapping. Hence it makes sense to override Load with Base.NetworkMapping instead of existing CurrentVersion.NetworkMapping.

    :param value: The Network Mappings list.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.NetworkMapping]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkMapping]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NetworkMapping"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NetworkMappingCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkMappingProperties(msrest.serialization.Model):
    """Network Mapping Properties.

    :param state: The pairing state for network mapping.
    :type state: str
    :param primary_network_friendly_name: The primary network friendly name.
    :type primary_network_friendly_name: str
    :param primary_network_id: The primary network id for network mapping.
    :type primary_network_id: str
    :param primary_fabric_friendly_name: The primary fabric friendly name.
    :type primary_fabric_friendly_name: str
    :param recovery_network_friendly_name: The recovery network friendly name.
    :type recovery_network_friendly_name: str
    :param recovery_network_id: The recovery network id for network mapping.
    :type recovery_network_id: str
    :param recovery_fabric_arm_id: The recovery fabric ARM id.
    :type recovery_fabric_arm_id: str
    :param recovery_fabric_friendly_name: The recovery fabric friendly name.
    :type recovery_fabric_friendly_name: str
    :param fabric_specific_settings: The fabric specific settings.
    :type fabric_specific_settings:
     ~azure.mgmt.recoveryservicessiterecovery.models.NetworkMappingFabricSpecificSettings
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'primary_network_friendly_name': {'key': 'primaryNetworkFriendlyName', 'type': 'str'},
        'primary_network_id': {'key': 'primaryNetworkId', 'type': 'str'},
        'primary_fabric_friendly_name': {'key': 'primaryFabricFriendlyName', 'type': 'str'},
        'recovery_network_friendly_name': {'key': 'recoveryNetworkFriendlyName', 'type': 'str'},
        'recovery_network_id': {'key': 'recoveryNetworkId', 'type': 'str'},
        'recovery_fabric_arm_id': {'key': 'recoveryFabricArmId', 'type': 'str'},
        'recovery_fabric_friendly_name': {'key': 'recoveryFabricFriendlyName', 'type': 'str'},
        'fabric_specific_settings': {'key': 'fabricSpecificSettings', 'type': 'NetworkMappingFabricSpecificSettings'},
    }

    def __init__(
        self,
        *,
        state: Optional[str] = None,
        primary_network_friendly_name: Optional[str] = None,
        primary_network_id: Optional[str] = None,
        primary_fabric_friendly_name: Optional[str] = None,
        recovery_network_friendly_name: Optional[str] = None,
        recovery_network_id: Optional[str] = None,
        recovery_fabric_arm_id: Optional[str] = None,
        recovery_fabric_friendly_name: Optional[str] = None,
        fabric_specific_settings: Optional["NetworkMappingFabricSpecificSettings"] = None,
        **kwargs
    ):
        super(NetworkMappingProperties, self).__init__(**kwargs)
        self.state = state
        self.primary_network_friendly_name = primary_network_friendly_name
        self.primary_network_id = primary_network_id
        self.primary_fabric_friendly_name = primary_fabric_friendly_name
        self.recovery_network_friendly_name = recovery_network_friendly_name
        self.recovery_network_id = recovery_network_id
        self.recovery_fabric_arm_id = recovery_fabric_arm_id
        self.recovery_fabric_friendly_name = recovery_fabric_friendly_name
        self.fabric_specific_settings = fabric_specific_settings


class NetworkProperties(msrest.serialization.Model):
    """Network Properties.

    :param fabric_type: The Fabric Type.
    :type fabric_type: str
    :param subnets: The List of subnets.
    :type subnets: list[~azure.mgmt.recoveryservicessiterecovery.models.Subnet]
    :param friendly_name: The Friendly Name.
    :type friendly_name: str
    :param network_type: The Network Type.
    :type network_type: str
    """

    _attribute_map = {
        'fabric_type': {'key': 'fabricType', 'type': 'str'},
        'subnets': {'key': 'subnets', 'type': '[Subnet]'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'network_type': {'key': 'networkType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fabric_type: Optional[str] = None,
        subnets: Optional[List["Subnet"]] = None,
        friendly_name: Optional[str] = None,
        network_type: Optional[str] = None,
        **kwargs
    ):
        super(NetworkProperties, self).__init__(**kwargs)
        self.fabric_type = fabric_type
        self.subnets = subnets
        self.friendly_name = friendly_name
        self.network_type = network_type


class NewProtectionProfile(ProtectionProfileCustomDetails):
    """New Protection profile input.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    :param policy_name: Required. The protection profile input.
    :type policy_name: str
    :param recovery_point_history: The duration in minutes until which the recovery points need to
     be stored.
    :type recovery_point_history: int
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :type crash_consistent_frequency_in_minutes: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :type app_consistent_frequency_in_minutes: int
    :param multi_vm_sync_status: Required. A value indicating whether multi-VM sync has to be
     enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: "Enable", "Disable".
    :type multi_vm_sync_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SetMultiVmSyncStatus
    """

    _validation = {
        'resource_type': {'required': True},
        'policy_name': {'required': True},
        'multi_vm_sync_status': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'recovery_point_history': {'key': 'recoveryPointHistory', 'type': 'int'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'multi_vm_sync_status': {'key': 'multiVmSyncStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        policy_name: str,
        multi_vm_sync_status: Union[str, "SetMultiVmSyncStatus"],
        recovery_point_history: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(NewProtectionProfile, self).__init__(**kwargs)
        self.resource_type = 'New'  # type: str
        self.policy_name = policy_name
        self.recovery_point_history = recovery_point_history
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.multi_vm_sync_status = multi_vm_sync_status


class NewRecoveryVirtualNetwork(RecoveryVirtualNetworkCustomDetails):
    """Recovery virtual network input to create new virtual network from given source network.

    All required parameters must be populated in order to send to Azure.

    :param resource_type: Required. The class type.Constant filled by server.
    :type resource_type: str
    :param recovery_virtual_network_resource_group_name: The name of the resource group to be used
     to create the recovery virtual network. If absent, target network would be created in the same
     resource group as target VM.
    :type recovery_virtual_network_resource_group_name: str
    :param recovery_virtual_network_name: The recovery virtual network name.
    :type recovery_virtual_network_name: str
    """

    _validation = {
        'resource_type': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'recovery_virtual_network_resource_group_name': {'key': 'recoveryVirtualNetworkResourceGroupName', 'type': 'str'},
        'recovery_virtual_network_name': {'key': 'recoveryVirtualNetworkName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_virtual_network_resource_group_name: Optional[str] = None,
        recovery_virtual_network_name: Optional[str] = None,
        **kwargs
    ):
        super(NewRecoveryVirtualNetwork, self).__init__(**kwargs)
        self.resource_type = 'New'  # type: str
        self.recovery_virtual_network_resource_group_name = recovery_virtual_network_resource_group_name
        self.recovery_virtual_network_name = recovery_virtual_network_name


class OperationsDiscovery(msrest.serialization.Model):
    """Operations discovery class.

    :param name: Name of the API. The name of the operation being performed on this particular
     object. It should match the action name that appears in RBAC / the event service. Examples of
     operations include: * Microsoft.Compute/virtualMachine/capture/action *
     Microsoft.Compute/virtualMachine/restart/action * Microsoft.Compute/virtualMachine/write *
     Microsoft.Compute/virtualMachine/read * Microsoft.Compute/virtualMachine/delete Each action
     should include, in order: (1) Resource Provider Namespace (2) Type hierarchy for which the
     action applies (e.g. server/databases for a SQL Azure database) (3) Read, Write, Action or
     Delete indicating which type applies. If it is a PUT/PATCH on a collection or named value,
     Write should be used. If it is a GET, Read should be used. If it is a DELETE, Delete should be
     used. If it is a POST, Action should be used. As a note: all resource providers would need to
     include the "{Resource Provider Namespace}/register/action" operation in their response. This
     API is used to register for their service, and should include details about the operation (e.g.
     a localized name for the resource provider + any special considerations like PII release).
    :type name: str
    :param display: Object type.
    :type display: ~azure.mgmt.recoveryservicessiterecovery.models.Display
    :param origin: Origin. The intended executor of the operation; governs the display of the
     operation in the RBAC UX and the audit logs UX. Default value is "user,system".
    :type origin: str
    :param properties: Properties. Reserved for future use.
    :type properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'Display'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["Display"] = None,
        origin: Optional[str] = None,
        properties: Optional[Any] = None,
        **kwargs
    ):
        super(OperationsDiscovery, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationsDiscoveryCollection(msrest.serialization.Model):
    """Collection of ClientDiscovery details.

    :param value: The ClientDiscovery details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.OperationsDiscovery]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationsDiscovery]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OperationsDiscovery"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationsDiscoveryCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSDetails(msrest.serialization.Model):
    """Disk Details.

    :param os_type: VM Disk details.
    :type os_type: str
    :param product_type: Product type.
    :type product_type: str
    :param os_edition: The OSEdition.
    :type os_edition: str
    :param o_s_version: The OS Version.
    :type o_s_version: str
    :param o_s_major_version: The OS Major Version.
    :type o_s_major_version: str
    :param o_s_minor_version: The OS Minor Version.
    :type o_s_minor_version: str
    """

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'product_type': {'key': 'productType', 'type': 'str'},
        'os_edition': {'key': 'osEdition', 'type': 'str'},
        'o_s_version': {'key': 'oSVersion', 'type': 'str'},
        'o_s_major_version': {'key': 'oSMajorVersion', 'type': 'str'},
        'o_s_minor_version': {'key': 'oSMinorVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_type: Optional[str] = None,
        product_type: Optional[str] = None,
        os_edition: Optional[str] = None,
        o_s_version: Optional[str] = None,
        o_s_major_version: Optional[str] = None,
        o_s_minor_version: Optional[str] = None,
        **kwargs
    ):
        super(OSDetails, self).__init__(**kwargs)
        self.os_type = os_type
        self.product_type = product_type
        self.os_edition = os_edition
        self.o_s_version = o_s_version
        self.o_s_major_version = o_s_major_version
        self.o_s_minor_version = o_s_minor_version


class OSDiskDetails(msrest.serialization.Model):
    """Details of the OS Disk.

    :param os_vhd_id: The id of the disk containing the OS.
    :type os_vhd_id: str
    :param os_type: The type of the OS on the VM.
    :type os_type: str
    :param vhd_name: The OS disk VHD name.
    :type vhd_name: str
    """

    _attribute_map = {
        'os_vhd_id': {'key': 'osVhdId', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vhd_name': {'key': 'vhdName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_vhd_id: Optional[str] = None,
        os_type: Optional[str] = None,
        vhd_name: Optional[str] = None,
        **kwargs
    ):
        super(OSDiskDetails, self).__init__(**kwargs)
        self.os_vhd_id = os_vhd_id
        self.os_type = os_type
        self.vhd_name = vhd_name


class OSVersionWrapper(msrest.serialization.Model):
    """Wrapper model for OSVersion to include version and service pack info.

    :param version: The version.
    :type version: str
    :param service_pack: The service pack.
    :type service_pack: str
    """

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'service_pack': {'key': 'servicePack', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        service_pack: Optional[str] = None,
        **kwargs
    ):
        super(OSVersionWrapper, self).__init__(**kwargs)
        self.version = version
        self.service_pack = service_pack


class PlannedFailoverInput(msrest.serialization.Model):
    """Input definition for planned failover.

    :param properties: Planned failover input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'PlannedFailoverInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["PlannedFailoverInputProperties"] = None,
        **kwargs
    ):
        super(PlannedFailoverInput, self).__init__(**kwargs)
        self.properties = properties


class PlannedFailoverInputProperties(msrest.serialization.Model):
    """Input definition for planned failover input properties.

    :param failover_direction: Failover direction.
    :type failover_direction: str
    :param provider_specific_details: Provider specific settings.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverProviderSpecificFailoverInput
    """

    _attribute_map = {
        'failover_direction': {'key': 'failoverDirection', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'PlannedFailoverProviderSpecificFailoverInput'},
    }

    def __init__(
        self,
        *,
        failover_direction: Optional[str] = None,
        provider_specific_details: Optional["PlannedFailoverProviderSpecificFailoverInput"] = None,
        **kwargs
    ):
        super(PlannedFailoverInputProperties, self).__init__(**kwargs)
        self.failover_direction = failover_direction
        self.provider_specific_details = provider_specific_details


class Policy(Resource):
    """Protection profile details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The custom data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PolicyProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["PolicyProperties"] = None,
        **kwargs
    ):
        super(Policy, self).__init__(location=location, **kwargs)
        self.properties = properties


class PolicyCollection(msrest.serialization.Model):
    """Protection Profile Collection details.

    :param value: The policy details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.Policy]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Policy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Policy"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PolicyCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyProperties(msrest.serialization.Model):
    """Protection profile custom data details.

    :param friendly_name: The FriendlyName.
    :type friendly_name: str
    :param provider_specific_details: The ReplicationChannelSetting.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProviderSpecificDetails
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'PolicyProviderSpecificDetails'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        provider_specific_details: Optional["PolicyProviderSpecificDetails"] = None,
        **kwargs
    ):
        super(PolicyProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.provider_specific_details = provider_specific_details


class ProcessServer(msrest.serialization.Model):
    """Details of the Process Server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param friendly_name: The Process Server's friendly name.
    :type friendly_name: str
    :param id: The Process Server Id.
    :type id: str
    :param ip_address: The IP address of the server.
    :type ip_address: str
    :param os_type: The OS type of the server.
    :type os_type: str
    :param agent_version: The version of the scout component on the server.
    :type agent_version: str
    :param last_heartbeat: The last heartbeat received from the server.
    :type last_heartbeat: ~datetime.datetime
    :param version_status: Version status.
    :type version_status: str
    :param mobility_service_updates: The list of the mobility service updates available on the
     Process Server.
    :type mobility_service_updates:
     list[~azure.mgmt.recoveryservicessiterecovery.models.MobilityServiceUpdate]
    :param host_id: The agent generated Id.
    :type host_id: str
    :param machine_count: The servers configured with this PS.
    :type machine_count: str
    :param replication_pair_count: The number of replication pairs configured in this PS.
    :type replication_pair_count: str
    :param system_load: The percentage of the system load.
    :type system_load: str
    :param system_load_status: The system load status.
    :type system_load_status: str
    :param cpu_load: The percentage of the CPU load.
    :type cpu_load: str
    :param cpu_load_status: The CPU load status.
    :type cpu_load_status: str
    :param total_memory_in_bytes: The total memory.
    :type total_memory_in_bytes: long
    :param available_memory_in_bytes: The available memory.
    :type available_memory_in_bytes: long
    :param memory_usage_status: The memory usage status.
    :type memory_usage_status: str
    :param total_space_in_bytes: The total space.
    :type total_space_in_bytes: long
    :param available_space_in_bytes: The available space.
    :type available_space_in_bytes: long
    :param space_usage_status: The space usage status.
    :type space_usage_status: str
    :param ps_service_status: The PS service status.
    :type ps_service_status: str
    :param ssl_cert_expiry_date: The PS SSL cert expiry date.
    :type ssl_cert_expiry_date: ~datetime.datetime
    :param ssl_cert_expiry_remaining_days: CS SSL cert expiry date.
    :type ssl_cert_expiry_remaining_days: int
    :param os_version: OS Version of the process server. Note: This will get populated if user has
     CS version greater than 9.12.0.0.
    :type os_version: str
    :param health_errors: Health errors.
    :type health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param agent_expiry_date: Agent expiry date.
    :type agent_expiry_date: ~datetime.datetime
    :param agent_version_details: The agent version details.
    :type agent_version_details: ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
    :ivar health: The health of Process Server. Possible values include: "None", "Normal",
     "Warning", "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar ps_stats_refresh_time: The process server stats refresh time.
    :vartype ps_stats_refresh_time: ~datetime.datetime
    :ivar throughput_upload_pending_data_in_bytes: The uploading pending data in bytes.
    :vartype throughput_upload_pending_data_in_bytes: long
    :ivar throughput_in_m_bps: The throughput in MBps.
    :vartype throughput_in_m_bps: long
    :ivar throughput_in_bytes: The throughput in bytes.
    :vartype throughput_in_bytes: long
    :ivar throughput_status: The throughput status.
    :vartype throughput_status: str
    :ivar mars_communication_status: The MARS communication status.
    :vartype mars_communication_status: str
    :ivar mars_registration_status: The MARS registration status.
    :vartype mars_registration_status: str
    """

    _validation = {
        'health': {'readonly': True},
        'ps_stats_refresh_time': {'readonly': True},
        'throughput_upload_pending_data_in_bytes': {'readonly': True},
        'throughput_in_m_bps': {'readonly': True},
        'throughput_in_bytes': {'readonly': True},
        'throughput_status': {'readonly': True},
        'mars_communication_status': {'readonly': True},
        'mars_registration_status': {'readonly': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'last_heartbeat': {'key': 'lastHeartbeat', 'type': 'iso-8601'},
        'version_status': {'key': 'versionStatus', 'type': 'str'},
        'mobility_service_updates': {'key': 'mobilityServiceUpdates', 'type': '[MobilityServiceUpdate]'},
        'host_id': {'key': 'hostId', 'type': 'str'},
        'machine_count': {'key': 'machineCount', 'type': 'str'},
        'replication_pair_count': {'key': 'replicationPairCount', 'type': 'str'},
        'system_load': {'key': 'systemLoad', 'type': 'str'},
        'system_load_status': {'key': 'systemLoadStatus', 'type': 'str'},
        'cpu_load': {'key': 'cpuLoad', 'type': 'str'},
        'cpu_load_status': {'key': 'cpuLoadStatus', 'type': 'str'},
        'total_memory_in_bytes': {'key': 'totalMemoryInBytes', 'type': 'long'},
        'available_memory_in_bytes': {'key': 'availableMemoryInBytes', 'type': 'long'},
        'memory_usage_status': {'key': 'memoryUsageStatus', 'type': 'str'},
        'total_space_in_bytes': {'key': 'totalSpaceInBytes', 'type': 'long'},
        'available_space_in_bytes': {'key': 'availableSpaceInBytes', 'type': 'long'},
        'space_usage_status': {'key': 'spaceUsageStatus', 'type': 'str'},
        'ps_service_status': {'key': 'psServiceStatus', 'type': 'str'},
        'ssl_cert_expiry_date': {'key': 'sslCertExpiryDate', 'type': 'iso-8601'},
        'ssl_cert_expiry_remaining_days': {'key': 'sslCertExpiryRemainingDays', 'type': 'int'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
        'agent_expiry_date': {'key': 'agentExpiryDate', 'type': 'iso-8601'},
        'agent_version_details': {'key': 'agentVersionDetails', 'type': 'VersionDetails'},
        'health': {'key': 'health', 'type': 'str'},
        'ps_stats_refresh_time': {'key': 'psStatsRefreshTime', 'type': 'iso-8601'},
        'throughput_upload_pending_data_in_bytes': {'key': 'throughputUploadPendingDataInBytes', 'type': 'long'},
        'throughput_in_m_bps': {'key': 'throughputInMBps', 'type': 'long'},
        'throughput_in_bytes': {'key': 'throughputInBytes', 'type': 'long'},
        'throughput_status': {'key': 'throughputStatus', 'type': 'str'},
        'mars_communication_status': {'key': 'marsCommunicationStatus', 'type': 'str'},
        'mars_registration_status': {'key': 'marsRegistrationStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        id: Optional[str] = None,
        ip_address: Optional[str] = None,
        os_type: Optional[str] = None,
        agent_version: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        version_status: Optional[str] = None,
        mobility_service_updates: Optional[List["MobilityServiceUpdate"]] = None,
        host_id: Optional[str] = None,
        machine_count: Optional[str] = None,
        replication_pair_count: Optional[str] = None,
        system_load: Optional[str] = None,
        system_load_status: Optional[str] = None,
        cpu_load: Optional[str] = None,
        cpu_load_status: Optional[str] = None,
        total_memory_in_bytes: Optional[int] = None,
        available_memory_in_bytes: Optional[int] = None,
        memory_usage_status: Optional[str] = None,
        total_space_in_bytes: Optional[int] = None,
        available_space_in_bytes: Optional[int] = None,
        space_usage_status: Optional[str] = None,
        ps_service_status: Optional[str] = None,
        ssl_cert_expiry_date: Optional[datetime.datetime] = None,
        ssl_cert_expiry_remaining_days: Optional[int] = None,
        os_version: Optional[str] = None,
        health_errors: Optional[List["HealthError"]] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        agent_version_details: Optional["VersionDetails"] = None,
        **kwargs
    ):
        super(ProcessServer, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.id = id
        self.ip_address = ip_address
        self.os_type = os_type
        self.agent_version = agent_version
        self.last_heartbeat = last_heartbeat
        self.version_status = version_status
        self.mobility_service_updates = mobility_service_updates
        self.host_id = host_id
        self.machine_count = machine_count
        self.replication_pair_count = replication_pair_count
        self.system_load = system_load
        self.system_load_status = system_load_status
        self.cpu_load = cpu_load
        self.cpu_load_status = cpu_load_status
        self.total_memory_in_bytes = total_memory_in_bytes
        self.available_memory_in_bytes = available_memory_in_bytes
        self.memory_usage_status = memory_usage_status
        self.total_space_in_bytes = total_space_in_bytes
        self.available_space_in_bytes = available_space_in_bytes
        self.space_usage_status = space_usage_status
        self.ps_service_status = ps_service_status
        self.ssl_cert_expiry_date = ssl_cert_expiry_date
        self.ssl_cert_expiry_remaining_days = ssl_cert_expiry_remaining_days
        self.os_version = os_version
        self.health_errors = health_errors
        self.agent_expiry_date = agent_expiry_date
        self.agent_version_details = agent_version_details
        self.health = None
        self.ps_stats_refresh_time = None
        self.throughput_upload_pending_data_in_bytes = None
        self.throughput_in_m_bps = None
        self.throughput_in_bytes = None
        self.throughput_status = None
        self.mars_communication_status = None
        self.mars_registration_status = None


class ProcessServerDetails(msrest.serialization.Model):
    """Process server details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The process server Id.
    :vartype id: str
    :ivar name: The process server name.
    :vartype name: str
    :ivar bios_id: The process server Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The process server Fqdn.
    :vartype fqdn: str
    :ivar ip_addresses: The list of IP addresses for communicating with the RCM component.
    :vartype ip_addresses: list[str]
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the process server.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar total_memory_in_bytes: The total memory.
    :vartype total_memory_in_bytes: long
    :ivar available_memory_in_bytes: The available memory.
    :vartype available_memory_in_bytes: long
    :ivar used_memory_in_bytes: The used memory.
    :vartype used_memory_in_bytes: long
    :ivar memory_usage_percentage: The memory usage percentage.
    :vartype memory_usage_percentage: float
    :ivar total_space_in_bytes: The total disk space.
    :vartype total_space_in_bytes: long
    :ivar available_space_in_bytes: The available disk space.
    :vartype available_space_in_bytes: long
    :ivar used_space_in_bytes: The used disk space.
    :vartype used_space_in_bytes: long
    :ivar free_space_percentage: The free disk space percentage.
    :vartype free_space_percentage: float
    :ivar throughput_upload_pending_data_in_bytes: The uploading pending data in bytes.
    :vartype throughput_upload_pending_data_in_bytes: long
    :ivar throughput_in_bytes: The throughput in bytes.
    :vartype throughput_in_bytes: long
    :ivar processor_usage_percentage: The processor usage percentage.
    :vartype processor_usage_percentage: float
    :ivar throughput_status: The throughput status. Possible values include: "Healthy", "Warning",
     "Critical", "Unknown".
    :vartype throughput_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar system_load: The system load.
    :vartype system_load: long
    :ivar system_load_status: The system load status. Possible values include: "Healthy",
     "Warning", "Critical", "Unknown".
    :vartype system_load_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar disk_usage_status: The disk usage status. Possible values include: "Healthy", "Warning",
     "Critical", "Unknown".
    :vartype disk_usage_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar memory_usage_status: The memory usage status. Possible values include: "Healthy",
     "Warning", "Critical", "Unknown".
    :vartype memory_usage_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar processor_usage_status: The processor usage status. Possible values include: "Healthy",
     "Warning", "Critical", "Unknown".
    :vartype processor_usage_status: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RcmComponentStatus
    :ivar health: The health of the process server. Possible values include: "None", "Normal",
     "Warning", "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar protected_item_count: The protected item count.
    :vartype protected_item_count: int
    :ivar historic_health: The historic health of the process server based on the health in last 24
     hours. Possible values include: "None", "Normal", "Warning", "Critical".
    :vartype historic_health: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'bios_id': {'readonly': True},
        'fabric_object_id': {'readonly': True},
        'fqdn': {'readonly': True},
        'ip_addresses': {'readonly': True},
        'version': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'total_memory_in_bytes': {'readonly': True},
        'available_memory_in_bytes': {'readonly': True},
        'used_memory_in_bytes': {'readonly': True},
        'memory_usage_percentage': {'readonly': True},
        'total_space_in_bytes': {'readonly': True},
        'available_space_in_bytes': {'readonly': True},
        'used_space_in_bytes': {'readonly': True},
        'free_space_percentage': {'readonly': True},
        'throughput_upload_pending_data_in_bytes': {'readonly': True},
        'throughput_in_bytes': {'readonly': True},
        'processor_usage_percentage': {'readonly': True},
        'throughput_status': {'readonly': True},
        'system_load': {'readonly': True},
        'system_load_status': {'readonly': True},
        'disk_usage_status': {'readonly': True},
        'memory_usage_status': {'readonly': True},
        'processor_usage_status': {'readonly': True},
        'health': {'readonly': True},
        'health_errors': {'readonly': True},
        'protected_item_count': {'readonly': True},
        'historic_health': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
        'version': {'key': 'version', 'type': 'str'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'total_memory_in_bytes': {'key': 'totalMemoryInBytes', 'type': 'long'},
        'available_memory_in_bytes': {'key': 'availableMemoryInBytes', 'type': 'long'},
        'used_memory_in_bytes': {'key': 'usedMemoryInBytes', 'type': 'long'},
        'memory_usage_percentage': {'key': 'memoryUsagePercentage', 'type': 'float'},
        'total_space_in_bytes': {'key': 'totalSpaceInBytes', 'type': 'long'},
        'available_space_in_bytes': {'key': 'availableSpaceInBytes', 'type': 'long'},
        'used_space_in_bytes': {'key': 'usedSpaceInBytes', 'type': 'long'},
        'free_space_percentage': {'key': 'freeSpacePercentage', 'type': 'float'},
        'throughput_upload_pending_data_in_bytes': {'key': 'throughputUploadPendingDataInBytes', 'type': 'long'},
        'throughput_in_bytes': {'key': 'throughputInBytes', 'type': 'long'},
        'processor_usage_percentage': {'key': 'processorUsagePercentage', 'type': 'float'},
        'throughput_status': {'key': 'throughputStatus', 'type': 'str'},
        'system_load': {'key': 'systemLoad', 'type': 'long'},
        'system_load_status': {'key': 'systemLoadStatus', 'type': 'str'},
        'disk_usage_status': {'key': 'diskUsageStatus', 'type': 'str'},
        'memory_usage_status': {'key': 'memoryUsageStatus', 'type': 'str'},
        'processor_usage_status': {'key': 'processorUsageStatus', 'type': 'str'},
        'health': {'key': 'health', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'int'},
        'historic_health': {'key': 'historicHealth', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessServerDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.ip_addresses = None
        self.version = None
        self.last_heartbeat_utc = None
        self.total_memory_in_bytes = None
        self.available_memory_in_bytes = None
        self.used_memory_in_bytes = None
        self.memory_usage_percentage = None
        self.total_space_in_bytes = None
        self.available_space_in_bytes = None
        self.used_space_in_bytes = None
        self.free_space_percentage = None
        self.throughput_upload_pending_data_in_bytes = None
        self.throughput_in_bytes = None
        self.processor_usage_percentage = None
        self.throughput_status = None
        self.system_load = None
        self.system_load_status = None
        self.disk_usage_status = None
        self.memory_usage_status = None
        self.processor_usage_status = None
        self.health = None
        self.health_errors = None
        self.protected_item_count = None
        self.historic_health = None


class ProtectableItem(Resource):
    """Replication protected item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The custom data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.ProtectableItemProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectableItemProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["ProtectableItemProperties"] = None,
        **kwargs
    ):
        super(ProtectableItem, self).__init__(location=location, **kwargs)
        self.properties = properties


class ProtectableItemCollection(msrest.serialization.Model):
    """Protectable item collection.

    :param value: The Protectable item details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectableItem]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProtectableItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ProtectableItem"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProtectableItemCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProtectableItemProperties(msrest.serialization.Model):
    """Replication protected item custom data details.

    :param friendly_name: The name.
    :type friendly_name: str
    :param protection_status: The protection status.
    :type protection_status: str
    :param replication_protected_item_id: The ARM resource of protected items.
    :type replication_protected_item_id: str
    :param recovery_services_provider_id: The recovery provider ARM Id.
    :type recovery_services_provider_id: str
    :param protection_readiness_errors: The Current protection readiness errors.
    :type protection_readiness_errors: list[str]
    :param supported_replication_providers: The list of replication providers supported for the
     protectable item.
    :type supported_replication_providers: list[str]
    :param custom_details: The Replication provider custom settings.
    :type custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.ConfigurationSettings
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protection_status': {'key': 'protectionStatus', 'type': 'str'},
        'replication_protected_item_id': {'key': 'replicationProtectedItemId', 'type': 'str'},
        'recovery_services_provider_id': {'key': 'recoveryServicesProviderId', 'type': 'str'},
        'protection_readiness_errors': {'key': 'protectionReadinessErrors', 'type': '[str]'},
        'supported_replication_providers': {'key': 'supportedReplicationProviders', 'type': '[str]'},
        'custom_details': {'key': 'customDetails', 'type': 'ConfigurationSettings'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        protection_status: Optional[str] = None,
        replication_protected_item_id: Optional[str] = None,
        recovery_services_provider_id: Optional[str] = None,
        protection_readiness_errors: Optional[List[str]] = None,
        supported_replication_providers: Optional[List[str]] = None,
        custom_details: Optional["ConfigurationSettings"] = None,
        **kwargs
    ):
        super(ProtectableItemProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.protection_status = protection_status
        self.replication_protected_item_id = replication_protected_item_id
        self.recovery_services_provider_id = recovery_services_provider_id
        self.protection_readiness_errors = protection_readiness_errors
        self.supported_replication_providers = supported_replication_providers
        self.custom_details = custom_details


class ProtectableItemQueryParameter(msrest.serialization.Model):
    """Query parameter to enumerate Protectable items.

    :param state: State of the Protectable item query filter.
    :type state: str
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[str] = None,
        **kwargs
    ):
        super(ProtectableItemQueryParameter, self).__init__(**kwargs)
        self.state = state


class ProtectedItemsQueryParameter(msrest.serialization.Model):
    """Query parameter to enumerate protected items.

    :param source_fabric_name: The source fabric name filter.
    :type source_fabric_name: str
    :param recovery_plan_name: The recovery plan filter.
    :type recovery_plan_name: str
    :param source_fabric_location: The source fabric location filter.
    :type source_fabric_location: str
    :param fabric_object_id: The fabric object Id filter.
    :type fabric_object_id: str
    :param v_center_name: The vCenter name filter.
    :type v_center_name: str
    :param instance_type: The replication provider type.
    :type instance_type: str
    :param multi_vm_group_create_option: Whether Multi VM group is auto created or specified by
     user. Possible values include: "AutoCreated", "UserSpecified".
    :type multi_vm_group_create_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmGroupCreateOption
    :param process_server_id: The process server Id filter.
    :type process_server_id: str
    """

    _attribute_map = {
        'source_fabric_name': {'key': 'sourceFabricName', 'type': 'str'},
        'recovery_plan_name': {'key': 'recoveryPlanName', 'type': 'str'},
        'source_fabric_location': {'key': 'sourceFabricLocation', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'v_center_name': {'key': 'vCenterName', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'multi_vm_group_create_option': {'key': 'multiVmGroupCreateOption', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_fabric_name: Optional[str] = None,
        recovery_plan_name: Optional[str] = None,
        source_fabric_location: Optional[str] = None,
        fabric_object_id: Optional[str] = None,
        v_center_name: Optional[str] = None,
        instance_type: Optional[str] = None,
        multi_vm_group_create_option: Optional[Union[str, "MultiVmGroupCreateOption"]] = None,
        process_server_id: Optional[str] = None,
        **kwargs
    ):
        super(ProtectedItemsQueryParameter, self).__init__(**kwargs)
        self.source_fabric_name = source_fabric_name
        self.recovery_plan_name = recovery_plan_name
        self.source_fabric_location = source_fabric_location
        self.fabric_object_id = fabric_object_id
        self.v_center_name = v_center_name
        self.instance_type = instance_type
        self.multi_vm_group_create_option = multi_vm_group_create_option
        self.process_server_id = process_server_id


class ProtectionContainer(Resource):
    """Protection container details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The custom data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectionContainerProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["ProtectionContainerProperties"] = None,
        **kwargs
    ):
        super(ProtectionContainer, self).__init__(location=location, **kwargs)
        self.properties = properties


class ProtectionContainerCollection(msrest.serialization.Model):
    """Protection Container collection.

    :param value: The Protection Container details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainer]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProtectionContainer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ProtectionContainer"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProtectionContainerCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProtectionContainerFabricSpecificDetails(msrest.serialization.Model):
    """Base class for fabric specific details of container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar instance_type: Gets the class type. Overridden in derived classes.
    :vartype instance_type: str
    """

    _validation = {
        'instance_type': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProtectionContainerFabricSpecificDetails, self).__init__(**kwargs)
        self.instance_type = None


class ProtectionContainerMapping(Resource):
    """Protection container mapping object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The custom data.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMappingProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ProtectionContainerMappingProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["ProtectionContainerMappingProperties"] = None,
        **kwargs
    ):
        super(ProtectionContainerMapping, self).__init__(location=location, **kwargs)
        self.properties = properties


class ProtectionContainerMappingCollection(msrest.serialization.Model):
    """Protection container mapping collection class.

    :param value: List of container mappings.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMapping]
    :param next_link: Link to fetch rest of the data.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProtectionContainerMapping]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ProtectionContainerMapping"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProtectionContainerMappingCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProtectionContainerMappingProperties(msrest.serialization.Model):
    """Protection container mapping properties.

    :param target_protection_container_id: Paired protection container ARM ID.
    :type target_protection_container_id: str
    :param target_protection_container_friendly_name: Friendly name of paired container.
    :type target_protection_container_friendly_name: str
    :param provider_specific_details: Provider specific provider details.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerMappingProviderSpecificDetails
    :param health: Health of pairing.
    :type health: str
    :param health_error_details: Health error.
    :type health_error_details: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param policy_id: Policy ARM Id.
    :type policy_id: str
    :param state: Association Status.
    :type state: str
    :param source_protection_container_friendly_name: Friendly name of source protection container.
    :type source_protection_container_friendly_name: str
    :param source_fabric_friendly_name: Friendly name of source fabric.
    :type source_fabric_friendly_name: str
    :param target_fabric_friendly_name: Friendly name of target fabric.
    :type target_fabric_friendly_name: str
    :param policy_friendly_name: Friendly name of replication policy.
    :type policy_friendly_name: str
    """

    _attribute_map = {
        'target_protection_container_id': {'key': 'targetProtectionContainerId', 'type': 'str'},
        'target_protection_container_friendly_name': {'key': 'targetProtectionContainerFriendlyName', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'ProtectionContainerMappingProviderSpecificDetails'},
        'health': {'key': 'health', 'type': 'str'},
        'health_error_details': {'key': 'healthErrorDetails', 'type': '[HealthError]'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'source_protection_container_friendly_name': {'key': 'sourceProtectionContainerFriendlyName', 'type': 'str'},
        'source_fabric_friendly_name': {'key': 'sourceFabricFriendlyName', 'type': 'str'},
        'target_fabric_friendly_name': {'key': 'targetFabricFriendlyName', 'type': 'str'},
        'policy_friendly_name': {'key': 'policyFriendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_protection_container_id: Optional[str] = None,
        target_protection_container_friendly_name: Optional[str] = None,
        provider_specific_details: Optional["ProtectionContainerMappingProviderSpecificDetails"] = None,
        health: Optional[str] = None,
        health_error_details: Optional[List["HealthError"]] = None,
        policy_id: Optional[str] = None,
        state: Optional[str] = None,
        source_protection_container_friendly_name: Optional[str] = None,
        source_fabric_friendly_name: Optional[str] = None,
        target_fabric_friendly_name: Optional[str] = None,
        policy_friendly_name: Optional[str] = None,
        **kwargs
    ):
        super(ProtectionContainerMappingProperties, self).__init__(**kwargs)
        self.target_protection_container_id = target_protection_container_id
        self.target_protection_container_friendly_name = target_protection_container_friendly_name
        self.provider_specific_details = provider_specific_details
        self.health = health
        self.health_error_details = health_error_details
        self.policy_id = policy_id
        self.state = state
        self.source_protection_container_friendly_name = source_protection_container_friendly_name
        self.source_fabric_friendly_name = source_fabric_friendly_name
        self.target_fabric_friendly_name = target_fabric_friendly_name
        self.policy_friendly_name = policy_friendly_name


class ProtectionContainerProperties(msrest.serialization.Model):
    """Protection profile custom data details.

    :param fabric_friendly_name: Fabric friendly name.
    :type fabric_friendly_name: str
    :param friendly_name: The name.
    :type friendly_name: str
    :param fabric_type: The fabric type.
    :type fabric_type: str
    :param protected_item_count: Number of protected PEs.
    :type protected_item_count: int
    :param pairing_status: The pairing status of this cloud.
    :type pairing_status: str
    :param role: The role of this cloud.
    :type role: str
    :param fabric_specific_details: Fabric specific details.
    :type fabric_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionContainerFabricSpecificDetails
    """

    _attribute_map = {
        'fabric_friendly_name': {'key': 'fabricFriendlyName', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'fabric_type': {'key': 'fabricType', 'type': 'str'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'int'},
        'pairing_status': {'key': 'pairingStatus', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
        'fabric_specific_details': {'key': 'fabricSpecificDetails', 'type': 'ProtectionContainerFabricSpecificDetails'},
    }

    def __init__(
        self,
        *,
        fabric_friendly_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        fabric_type: Optional[str] = None,
        protected_item_count: Optional[int] = None,
        pairing_status: Optional[str] = None,
        role: Optional[str] = None,
        fabric_specific_details: Optional["ProtectionContainerFabricSpecificDetails"] = None,
        **kwargs
    ):
        super(ProtectionContainerProperties, self).__init__(**kwargs)
        self.fabric_friendly_name = fabric_friendly_name
        self.friendly_name = friendly_name
        self.fabric_type = fabric_type
        self.protected_item_count = protected_item_count
        self.pairing_status = pairing_status
        self.role = role
        self.fabric_specific_details = fabric_specific_details


class ProviderError(msrest.serialization.Model):
    """This class contains the error details per object.

    :param error_code: The Error code.
    :type error_code: int
    :param error_message: The Error message.
    :type error_message: str
    :param error_id: The Provider error Id.
    :type error_id: str
    :param possible_causes: The possible causes for the error.
    :type possible_causes: str
    :param recommended_action: The recommended action to resolve the error.
    :type recommended_action: str
    """

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'error_id': {'key': 'errorId', 'type': 'str'},
        'possible_causes': {'key': 'possibleCauses', 'type': 'str'},
        'recommended_action': {'key': 'recommendedAction', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        error_code: Optional[int] = None,
        error_message: Optional[str] = None,
        error_id: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        **kwargs
    ):
        super(ProviderError, self).__init__(**kwargs)
        self.error_code = error_code
        self.error_message = error_message
        self.error_id = error_id
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action


class PushInstallerDetails(msrest.serialization.Model):
    """Push installer details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The push installer Id.
    :vartype id: str
    :ivar name: The push installer name.
    :vartype name: str
    :ivar bios_id: The push installer Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The push installer Fqdn.
    :vartype fqdn: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the push installer.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health of the push installer. Possible values include: "None", "Normal",
     "Warning", "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'bios_id': {'readonly': True},
        'fabric_object_id': {'readonly': True},
        'fqdn': {'readonly': True},
        'version': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'health': {'readonly': True},
        'health_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'health': {'key': 'health', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PushInstallerDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None


class RcmProxyDetails(msrest.serialization.Model):
    """RCM proxy details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The RCM proxy Id.
    :vartype id: str
    :ivar name: The RCM proxy name.
    :vartype name: str
    :ivar bios_id: The RCM proxy Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The RCM proxy Fqdn.
    :vartype fqdn: str
    :ivar client_authentication_type: The client authentication type.
    :vartype client_authentication_type: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the RCM proxy.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health of the RCM proxy. Possible values include: "None", "Normal",
     "Warning", "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'bios_id': {'readonly': True},
        'fabric_object_id': {'readonly': True},
        'fqdn': {'readonly': True},
        'client_authentication_type': {'readonly': True},
        'version': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'health': {'readonly': True},
        'health_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'client_authentication_type': {'key': 'clientAuthenticationType', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'health': {'key': 'health', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RcmProxyDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.client_authentication_type = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None


class RecoveryPlan(Resource):
    """Recovery plan details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The custom details.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RecoveryPlanProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["RecoveryPlanProperties"] = None,
        **kwargs
    ):
        super(RecoveryPlan, self).__init__(location=location, **kwargs)
        self.properties = properties


class RecoveryPlanProviderSpecificDetails(msrest.serialization.Model):
    """Recovery plan provider specific details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RecoveryPlanA2ADetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'RecoveryPlanA2ADetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryPlanProviderSpecificDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class RecoveryPlanA2ADetails(RecoveryPlanProviderSpecificDetails):
    """Recovery plan A2A specific details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param primary_zone: The primary zone.
    :type primary_zone: str
    :param recovery_zone: The recovery zone.
    :type recovery_zone: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_zone': {'key': 'primaryZone', 'type': 'str'},
        'recovery_zone': {'key': 'recoveryZone', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_zone: Optional[str] = None,
        recovery_zone: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanA2ADetails, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.primary_zone = primary_zone
        self.recovery_zone = recovery_zone


class RecoveryPlanProviderSpecificFailoverInput(msrest.serialization.Model):
    """Recovery plan provider specific failover input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RecoveryPlanA2AFailoverInput, RecoveryPlanHyperVReplicaAzureFailoverInput, RecoveryPlanHyperVReplicaAzureFailbackInput, RecoveryPlanInMageFailoverInput, RecoveryPlanInMageAzureV2FailoverInput, RecoveryPlanInMageRcmFailoverInput, RecoveryPlanInMageRcmFailbackFailoverInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'RecoveryPlanA2AFailoverInput', 'HyperVReplicaAzure': 'RecoveryPlanHyperVReplicaAzureFailoverInput', 'HyperVReplicaAzureFailback': 'RecoveryPlanHyperVReplicaAzureFailbackInput', 'InMage': 'RecoveryPlanInMageFailoverInput', 'InMageAzureV2': 'RecoveryPlanInMageAzureV2FailoverInput', 'InMageRcm': 'RecoveryPlanInMageRcmFailoverInput', 'InMageRcmFailback': 'RecoveryPlanInMageRcmFailbackFailoverInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryPlanProviderSpecificFailoverInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class RecoveryPlanA2AFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan A2A failover input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_type: Required. The recovery point type. Possible values include:
     "Latest", "LatestApplicationConsistent", "LatestCrashConsistent", "LatestProcessed".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.A2ARpRecoveryPointType
    :param cloud_service_creation_option: A value indicating whether to use recovery cloud service
     for TFO or not.
    :type cloud_service_creation_option: str
    :param multi_vm_sync_point_option: A value indicating whether multi VM sync enabled VMs should
     use multi VM sync points for failover. Possible values include: "UseMultiVmSyncRecoveryPoint",
     "UsePerVmRecoveryPoint".
    :type multi_vm_sync_point_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.MultiVmSyncPointOption
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_point_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'cloud_service_creation_option': {'key': 'cloudServiceCreationOption', 'type': 'str'},
        'multi_vm_sync_point_option': {'key': 'multiVmSyncPointOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "A2ARpRecoveryPointType"],
        cloud_service_creation_option: Optional[str] = None,
        multi_vm_sync_point_option: Optional[Union[str, "MultiVmSyncPointOption"]] = None,
        **kwargs
    ):
        super(RecoveryPlanA2AFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.recovery_point_type = recovery_point_type
        self.cloud_service_creation_option = cloud_service_creation_option
        self.multi_vm_sync_point_option = multi_vm_sync_point_option


class RecoveryPlanProviderSpecificInput(msrest.serialization.Model):
    """Recovery plan provider specific input base class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RecoveryPlanA2AInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'A2A': 'RecoveryPlanA2AInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryPlanProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class RecoveryPlanA2AInput(RecoveryPlanProviderSpecificInput):
    """Recovery plan A2A input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    :param primary_zone: The primary zone.
    :type primary_zone: str
    :param recovery_zone: The recovery zone.
    :type recovery_zone: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_zone': {'key': 'primaryZone', 'type': 'str'},
        'recovery_zone': {'key': 'recoveryZone', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_zone: Optional[str] = None,
        recovery_zone: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanA2AInput, self).__init__(**kwargs)
        self.instance_type = 'A2A'  # type: str
        self.primary_zone = primary_zone
        self.recovery_zone = recovery_zone


class RecoveryPlanAction(msrest.serialization.Model):
    """Recovery plan action details.

    All required parameters must be populated in order to send to Azure.

    :param action_name: Required. The action name.
    :type action_name: str
    :param failover_types: Required. The list of failover types.
    :type failover_types: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItemOperation]
    :param failover_directions: Required. The list of failover directions.
    :type failover_directions: list[str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections]
    :param custom_details: Required. The custom details.
    :type custom_details: ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionDetails
    """

    _validation = {
        'action_name': {'required': True},
        'failover_types': {'required': True},
        'failover_directions': {'required': True},
        'custom_details': {'required': True},
    }

    _attribute_map = {
        'action_name': {'key': 'actionName', 'type': 'str'},
        'failover_types': {'key': 'failoverTypes', 'type': '[str]'},
        'failover_directions': {'key': 'failoverDirections', 'type': '[str]'},
        'custom_details': {'key': 'customDetails', 'type': 'RecoveryPlanActionDetails'},
    }

    def __init__(
        self,
        *,
        action_name: str,
        failover_types: List[Union[str, "ReplicationProtectedItemOperation"]],
        failover_directions: List[Union[str, "PossibleOperationsDirections"]],
        custom_details: "RecoveryPlanActionDetails",
        **kwargs
    ):
        super(RecoveryPlanAction, self).__init__(**kwargs)
        self.action_name = action_name
        self.failover_types = failover_types
        self.failover_directions = failover_directions
        self.custom_details = custom_details


class RecoveryPlanActionDetails(msrest.serialization.Model):
    """Recovery plan action custom details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RecoveryPlanAutomationRunbookActionDetails, RecoveryPlanManualActionDetails, RecoveryPlanScriptActionDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of action details (see
     RecoveryPlanActionDetailsTypes enum for possible values).Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'AutomationRunbookActionDetails': 'RecoveryPlanAutomationRunbookActionDetails', 'ManualActionDetails': 'RecoveryPlanManualActionDetails', 'ScriptActionDetails': 'RecoveryPlanScriptActionDetails'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryPlanActionDetails, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class RecoveryPlanAutomationRunbookActionDetails(RecoveryPlanActionDetails):
    """Recovery plan Automation runbook action details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of action details (see
     RecoveryPlanActionDetailsTypes enum for possible values).Constant filled by server.
    :type instance_type: str
    :param runbook_id: The runbook ARM Id.
    :type runbook_id: str
    :param timeout: The runbook timeout.
    :type timeout: str
    :param fabric_location: Required. The fabric location. Possible values include: "Primary",
     "Recovery".
    :type fabric_location: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionLocation
    """

    _validation = {
        'instance_type': {'required': True},
        'fabric_location': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'runbook_id': {'key': 'runbookId', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'str'},
        'fabric_location': {'key': 'fabricLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fabric_location: Union[str, "RecoveryPlanActionLocation"],
        runbook_id: Optional[str] = None,
        timeout: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanAutomationRunbookActionDetails, self).__init__(**kwargs)
        self.instance_type = 'AutomationRunbookActionDetails'  # type: str
        self.runbook_id = runbook_id
        self.timeout = timeout
        self.fabric_location = fabric_location


class RecoveryPlanCollection(msrest.serialization.Model):
    """Recovery plan collection details.

    :param value: The list of recovery plans.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlan]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecoveryPlan]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RecoveryPlan"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RecoveryPlanGroup(msrest.serialization.Model):
    """Recovery plan group details.

    All required parameters must be populated in order to send to Azure.

    :param group_type: Required. The group type. Possible values include: "Shutdown", "Boot",
     "Failover".
    :type group_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroupType
    :param replication_protected_items: The list of protected items.
    :type replication_protected_items:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProtectedItem]
    :param start_group_actions: The start group actions.
    :type start_group_actions:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanAction]
    :param end_group_actions: The end group actions.
    :type end_group_actions:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanAction]
    """

    _validation = {
        'group_type': {'required': True},
    }

    _attribute_map = {
        'group_type': {'key': 'groupType', 'type': 'str'},
        'replication_protected_items': {'key': 'replicationProtectedItems', 'type': '[RecoveryPlanProtectedItem]'},
        'start_group_actions': {'key': 'startGroupActions', 'type': '[RecoveryPlanAction]'},
        'end_group_actions': {'key': 'endGroupActions', 'type': '[RecoveryPlanAction]'},
    }

    def __init__(
        self,
        *,
        group_type: Union[str, "RecoveryPlanGroupType"],
        replication_protected_items: Optional[List["RecoveryPlanProtectedItem"]] = None,
        start_group_actions: Optional[List["RecoveryPlanAction"]] = None,
        end_group_actions: Optional[List["RecoveryPlanAction"]] = None,
        **kwargs
    ):
        super(RecoveryPlanGroup, self).__init__(**kwargs)
        self.group_type = group_type
        self.replication_protected_items = replication_protected_items
        self.start_group_actions = start_group_actions
        self.end_group_actions = end_group_actions


class RecoveryPlanGroupTaskDetails(GroupTaskDetails):
    """This class represents the recovery plan group task.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RecoveryPlanShutdownGroupTaskDetails.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param child_tasks: The child tasks.
    :type child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    :param name: The name.
    :type name: str
    :param group_id: The group identifier.
    :type group_id: str
    :param rp_group_type: The group type.
    :type rp_group_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'child_tasks': {'key': 'childTasks', 'type': '[ASRTask]'},
        'name': {'key': 'name', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'rp_group_type': {'key': 'rpGroupType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'RecoveryPlanShutdownGroupTaskDetails': 'RecoveryPlanShutdownGroupTaskDetails'}
    }

    def __init__(
        self,
        *,
        child_tasks: Optional[List["ASRTask"]] = None,
        name: Optional[str] = None,
        group_id: Optional[str] = None,
        rp_group_type: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanGroupTaskDetails, self).__init__(child_tasks=child_tasks, **kwargs)
        self.instance_type = 'RecoveryPlanGroupTaskDetails'  # type: str
        self.name = name
        self.group_id = group_id
        self.rp_group_type = rp_group_type


class RecoveryPlanHyperVReplicaAzureFailbackInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan HVR Azure failback input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param data_sync_option: Required. The data sync option. Possible values include:
     "ForDownTime", "ForSynchronization".
    :type data_sync_option: str or ~azure.mgmt.recoveryservicessiterecovery.models.DataSyncStatus
    :param recovery_vm_creation_option: Required. The ALR option. Possible values include:
     "CreateVmIfNotFound", "NoAction".
    :type recovery_vm_creation_option: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.AlternateLocationRecoveryOption
    """

    _validation = {
        'instance_type': {'required': True},
        'data_sync_option': {'required': True},
        'recovery_vm_creation_option': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'data_sync_option': {'key': 'dataSyncOption', 'type': 'str'},
        'recovery_vm_creation_option': {'key': 'recoveryVmCreationOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_sync_option: Union[str, "DataSyncStatus"],
        recovery_vm_creation_option: Union[str, "AlternateLocationRecoveryOption"],
        **kwargs
    ):
        super(RecoveryPlanHyperVReplicaAzureFailbackInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzureFailback'  # type: str
        self.data_sync_option = data_sync_option
        self.recovery_vm_creation_option = recovery_vm_creation_option


class RecoveryPlanHyperVReplicaAzureFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan HVR Azure failover input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param primary_kek_certificate_pfx: The primary KEK certificate PFX.
    :type primary_kek_certificate_pfx: str
    :param secondary_kek_certificate_pfx: The secondary KEK certificate PFX.
    :type secondary_kek_certificate_pfx: str
    :param recovery_point_type: The recovery point type. Possible values include: "Latest",
     "LatestApplicationConsistent", "LatestProcessed".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.HyperVReplicaAzureRpRecoveryPointType
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'primary_kek_certificate_pfx': {'key': 'primaryKekCertificatePfx', 'type': 'str'},
        'secondary_kek_certificate_pfx': {'key': 'secondaryKekCertificatePfx', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        primary_kek_certificate_pfx: Optional[str] = None,
        secondary_kek_certificate_pfx: Optional[str] = None,
        recovery_point_type: Optional[Union[str, "HyperVReplicaAzureRpRecoveryPointType"]] = None,
        **kwargs
    ):
        super(RecoveryPlanHyperVReplicaAzureFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'HyperVReplicaAzure'  # type: str
        self.primary_kek_certificate_pfx = primary_kek_certificate_pfx
        self.secondary_kek_certificate_pfx = secondary_kek_certificate_pfx
        self.recovery_point_type = recovery_point_type


class RecoveryPlanInMageAzureV2FailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan InMageAzureV2 failover input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_type: Required. The recovery point type. Possible values include:
     "Latest", "LatestApplicationConsistent", "LatestCrashConsistent", "LatestProcessed".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageV2RpRecoveryPointType
    :param use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should use
     multi VM sync points for failover.
    :type use_multi_vm_sync_point: str
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_point_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'use_multi_vm_sync_point': {'key': 'useMultiVmSyncPoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "InMageV2RpRecoveryPointType"],
        use_multi_vm_sync_point: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanInMageAzureV2FailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMageAzureV2'  # type: str
        self.recovery_point_type = recovery_point_type
        self.use_multi_vm_sync_point = use_multi_vm_sync_point


class RecoveryPlanInMageFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan InMage failover input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_type: Required. The recovery point type. Possible values include:
     "LatestTime", "LatestTag", "Custom".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RpInMageRecoveryPointType
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_point_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "RpInMageRecoveryPointType"],
        **kwargs
    ):
        super(RecoveryPlanInMageFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMage'  # type: str
        self.recovery_point_type = recovery_point_type


class RecoveryPlanInMageRcmFailbackFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan InMageRcmFailback failover input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_type: Required. The recovery point type. Possible values include:
     "ApplicationConsistent", "CrashConsistent".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.InMageRcmFailbackRecoveryPointType
    :param use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should use
     multi VM sync points for failover.
    :type use_multi_vm_sync_point: str
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_point_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'use_multi_vm_sync_point': {'key': 'useMultiVmSyncPoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "InMageRcmFailbackRecoveryPointType"],
        use_multi_vm_sync_point: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanInMageRcmFailbackFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcmFailback'  # type: str
        self.recovery_point_type = recovery_point_type
        self.use_multi_vm_sync_point = use_multi_vm_sync_point


class RecoveryPlanInMageRcmFailoverInput(RecoveryPlanProviderSpecificFailoverInput):
    """Recovery plan InMageRcm failover input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_type: Required. The recovery point type. Possible values include:
     "Latest", "LatestApplicationConsistent", "LatestCrashConsistent", "LatestProcessed".
    :type recovery_point_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanPointType
    :param use_multi_vm_sync_point: A value indicating whether multi VM sync enabled VMs should use
     multi VM sync points for failover.
    :type use_multi_vm_sync_point: str
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_point_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'use_multi_vm_sync_point': {'key': 'useMultiVmSyncPoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Union[str, "RecoveryPlanPointType"],
        use_multi_vm_sync_point: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanInMageRcmFailoverInput, self).__init__(**kwargs)
        self.instance_type = 'InMageRcm'  # type: str
        self.recovery_point_type = recovery_point_type
        self.use_multi_vm_sync_point = use_multi_vm_sync_point


class RecoveryPlanManualActionDetails(RecoveryPlanActionDetails):
    """Recovery plan manual action details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of action details (see
     RecoveryPlanActionDetailsTypes enum for possible values).Constant filled by server.
    :type instance_type: str
    :param description: The manual action description.
    :type description: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanManualActionDetails, self).__init__(**kwargs)
        self.instance_type = 'ManualActionDetails'  # type: str
        self.description = description


class RecoveryPlanPlannedFailoverInput(msrest.serialization.Model):
    """Recovery plan planned failover input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. The recovery plan planned failover input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanPlannedFailoverInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RecoveryPlanPlannedFailoverInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "RecoveryPlanPlannedFailoverInputProperties",
        **kwargs
    ):
        super(RecoveryPlanPlannedFailoverInput, self).__init__(**kwargs)
        self.properties = properties


class RecoveryPlanPlannedFailoverInputProperties(msrest.serialization.Model):
    """Recovery plan planned failover input properties.

    All required parameters must be populated in order to send to Azure.

    :param failover_direction: Required. The failover direction. Possible values include:
     "PrimaryToRecovery", "RecoveryToPrimary".
    :type failover_direction: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
    :param provider_specific_details: The provider specific properties.
    :type provider_specific_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
    """

    _validation = {
        'failover_direction': {'required': True},
    }

    _attribute_map = {
        'failover_direction': {'key': 'failoverDirection', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': '[RecoveryPlanProviderSpecificFailoverInput]'},
    }

    def __init__(
        self,
        *,
        failover_direction: Union[str, "PossibleOperationsDirections"],
        provider_specific_details: Optional[List["RecoveryPlanProviderSpecificFailoverInput"]] = None,
        **kwargs
    ):
        super(RecoveryPlanPlannedFailoverInputProperties, self).__init__(**kwargs)
        self.failover_direction = failover_direction
        self.provider_specific_details = provider_specific_details


class RecoveryPlanProperties(msrest.serialization.Model):
    """Recovery plan properties.

    :param friendly_name: The friendly name.
    :type friendly_name: str
    :param primary_fabric_id: The primary fabric Id.
    :type primary_fabric_id: str
    :param primary_fabric_friendly_name: The primary fabric friendly name.
    :type primary_fabric_friendly_name: str
    :param recovery_fabric_id: The recovery fabric Id.
    :type recovery_fabric_id: str
    :param recovery_fabric_friendly_name: The recovery fabric friendly name.
    :type recovery_fabric_friendly_name: str
    :param failover_deployment_model: The failover deployment model.
    :type failover_deployment_model: str
    :param replication_providers: The list of replication providers.
    :type replication_providers: list[str]
    :param allowed_operations: The list of allowed operations.
    :type allowed_operations: list[str]
    :param last_planned_failover_time: The start time of the last planned failover.
    :type last_planned_failover_time: ~datetime.datetime
    :param last_unplanned_failover_time: The start time of the last unplanned failover.
    :type last_unplanned_failover_time: ~datetime.datetime
    :param last_test_failover_time: The start time of the last test failover.
    :type last_test_failover_time: ~datetime.datetime
    :param current_scenario: The current scenario details.
    :type current_scenario: ~azure.mgmt.recoveryservicessiterecovery.models.CurrentScenarioDetails
    :param current_scenario_status: The recovery plan status.
    :type current_scenario_status: str
    :param current_scenario_status_description: The recovery plan status description.
    :type current_scenario_status_description: str
    :param groups: The recovery plan groups.
    :type groups: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroup]
    :param provider_specific_details: The provider id and provider specific details.
    :type provider_specific_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificDetails]
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'primary_fabric_id': {'key': 'primaryFabricId', 'type': 'str'},
        'primary_fabric_friendly_name': {'key': 'primaryFabricFriendlyName', 'type': 'str'},
        'recovery_fabric_id': {'key': 'recoveryFabricId', 'type': 'str'},
        'recovery_fabric_friendly_name': {'key': 'recoveryFabricFriendlyName', 'type': 'str'},
        'failover_deployment_model': {'key': 'failoverDeploymentModel', 'type': 'str'},
        'replication_providers': {'key': 'replicationProviders', 'type': '[str]'},
        'allowed_operations': {'key': 'allowedOperations', 'type': '[str]'},
        'last_planned_failover_time': {'key': 'lastPlannedFailoverTime', 'type': 'iso-8601'},
        'last_unplanned_failover_time': {'key': 'lastUnplannedFailoverTime', 'type': 'iso-8601'},
        'last_test_failover_time': {'key': 'lastTestFailoverTime', 'type': 'iso-8601'},
        'current_scenario': {'key': 'currentScenario', 'type': 'CurrentScenarioDetails'},
        'current_scenario_status': {'key': 'currentScenarioStatus', 'type': 'str'},
        'current_scenario_status_description': {'key': 'currentScenarioStatusDescription', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[RecoveryPlanGroup]'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': '[RecoveryPlanProviderSpecificDetails]'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        primary_fabric_id: Optional[str] = None,
        primary_fabric_friendly_name: Optional[str] = None,
        recovery_fabric_id: Optional[str] = None,
        recovery_fabric_friendly_name: Optional[str] = None,
        failover_deployment_model: Optional[str] = None,
        replication_providers: Optional[List[str]] = None,
        allowed_operations: Optional[List[str]] = None,
        last_planned_failover_time: Optional[datetime.datetime] = None,
        last_unplanned_failover_time: Optional[datetime.datetime] = None,
        last_test_failover_time: Optional[datetime.datetime] = None,
        current_scenario: Optional["CurrentScenarioDetails"] = None,
        current_scenario_status: Optional[str] = None,
        current_scenario_status_description: Optional[str] = None,
        groups: Optional[List["RecoveryPlanGroup"]] = None,
        provider_specific_details: Optional[List["RecoveryPlanProviderSpecificDetails"]] = None,
        **kwargs
    ):
        super(RecoveryPlanProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.primary_fabric_id = primary_fabric_id
        self.primary_fabric_friendly_name = primary_fabric_friendly_name
        self.recovery_fabric_id = recovery_fabric_id
        self.recovery_fabric_friendly_name = recovery_fabric_friendly_name
        self.failover_deployment_model = failover_deployment_model
        self.replication_providers = replication_providers
        self.allowed_operations = allowed_operations
        self.last_planned_failover_time = last_planned_failover_time
        self.last_unplanned_failover_time = last_unplanned_failover_time
        self.last_test_failover_time = last_test_failover_time
        self.current_scenario = current_scenario
        self.current_scenario_status = current_scenario_status
        self.current_scenario_status_description = current_scenario_status_description
        self.groups = groups
        self.provider_specific_details = provider_specific_details


class RecoveryPlanProtectedItem(msrest.serialization.Model):
    """Recovery plan protected item.

    :param id: The ARM Id of the recovery plan protected item.
    :type id: str
    :param virtual_machine_id: The virtual machine Id.
    :type virtual_machine_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'virtual_machine_id': {'key': 'virtualMachineId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanProtectedItem, self).__init__(**kwargs)
        self.id = id
        self.virtual_machine_id = virtual_machine_id


class RecoveryPlanScriptActionDetails(RecoveryPlanActionDetails):
    """Recovery plan script action details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of action details (see
     RecoveryPlanActionDetailsTypes enum for possible values).Constant filled by server.
    :type instance_type: str
    :param path: Required. The script path.
    :type path: str
    :param timeout: The script timeout.
    :type timeout: str
    :param fabric_location: Required. The fabric location. Possible values include: "Primary",
     "Recovery".
    :type fabric_location: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanActionLocation
    """

    _validation = {
        'instance_type': {'required': True},
        'path': {'required': True},
        'fabric_location': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'str'},
        'fabric_location': {'key': 'fabricLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: str,
        fabric_location: Union[str, "RecoveryPlanActionLocation"],
        timeout: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanScriptActionDetails, self).__init__(**kwargs)
        self.instance_type = 'ScriptActionDetails'  # type: str
        self.path = path
        self.timeout = timeout
        self.fabric_location = fabric_location


class RecoveryPlanShutdownGroupTaskDetails(RecoveryPlanGroupTaskDetails):
    """This class represents the recovery plan shutdown group task details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param child_tasks: The child tasks.
    :type child_tasks: list[~azure.mgmt.recoveryservicessiterecovery.models.ASRTask]
    :param name: The name.
    :type name: str
    :param group_id: The group identifier.
    :type group_id: str
    :param rp_group_type: The group type.
    :type rp_group_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'child_tasks': {'key': 'childTasks', 'type': '[ASRTask]'},
        'name': {'key': 'name', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'rp_group_type': {'key': 'rpGroupType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        child_tasks: Optional[List["ASRTask"]] = None,
        name: Optional[str] = None,
        group_id: Optional[str] = None,
        rp_group_type: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanShutdownGroupTaskDetails, self).__init__(child_tasks=child_tasks, name=name, group_id=group_id, rp_group_type=rp_group_type, **kwargs)
        self.instance_type = 'RecoveryPlanShutdownGroupTaskDetails'  # type: str


class RecoveryPlanTestFailoverCleanupInput(msrest.serialization.Model):
    """Recovery plan test failover cleanup input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. The recovery plan test failover cleanup input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanTestFailoverCleanupInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RecoveryPlanTestFailoverCleanupInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "RecoveryPlanTestFailoverCleanupInputProperties",
        **kwargs
    ):
        super(RecoveryPlanTestFailoverCleanupInput, self).__init__(**kwargs)
        self.properties = properties


class RecoveryPlanTestFailoverCleanupInputProperties(msrest.serialization.Model):
    """Recovery plan test failover cleanup input properties.

    :param comments: The test failover cleanup comments.
    :type comments: str
    """

    _validation = {
        'comments': {'max_length': 1024, 'min_length': 0},
    }

    _attribute_map = {
        'comments': {'key': 'comments', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        comments: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPlanTestFailoverCleanupInputProperties, self).__init__(**kwargs)
        self.comments = comments


class RecoveryPlanTestFailoverInput(msrest.serialization.Model):
    """Recovery plan test failover input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. The recovery plan test failover input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanTestFailoverInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RecoveryPlanTestFailoverInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "RecoveryPlanTestFailoverInputProperties",
        **kwargs
    ):
        super(RecoveryPlanTestFailoverInput, self).__init__(**kwargs)
        self.properties = properties


class RecoveryPlanTestFailoverInputProperties(msrest.serialization.Model):
    """Recovery plan test failover input properties.

    All required parameters must be populated in order to send to Azure.

    :param failover_direction: Required. The failover direction. Possible values include:
     "PrimaryToRecovery", "RecoveryToPrimary".
    :type failover_direction: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
    :param network_type: Required. The network type to be used for test failover.
    :type network_type: str
    :param network_id: The Id of the network to be used for test failover.
    :type network_id: str
    :param provider_specific_details: The provider specific properties.
    :type provider_specific_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
    """

    _validation = {
        'failover_direction': {'required': True},
        'network_type': {'required': True},
    }

    _attribute_map = {
        'failover_direction': {'key': 'failoverDirection', 'type': 'str'},
        'network_type': {'key': 'networkType', 'type': 'str'},
        'network_id': {'key': 'networkId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': '[RecoveryPlanProviderSpecificFailoverInput]'},
    }

    def __init__(
        self,
        *,
        failover_direction: Union[str, "PossibleOperationsDirections"],
        network_type: str,
        network_id: Optional[str] = None,
        provider_specific_details: Optional[List["RecoveryPlanProviderSpecificFailoverInput"]] = None,
        **kwargs
    ):
        super(RecoveryPlanTestFailoverInputProperties, self).__init__(**kwargs)
        self.failover_direction = failover_direction
        self.network_type = network_type
        self.network_id = network_id
        self.provider_specific_details = provider_specific_details


class RecoveryPlanUnplannedFailoverInput(msrest.serialization.Model):
    """Recovery plan unplanned failover input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. The recovery plan unplanned failover input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanUnplannedFailoverInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RecoveryPlanUnplannedFailoverInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "RecoveryPlanUnplannedFailoverInputProperties",
        **kwargs
    ):
        super(RecoveryPlanUnplannedFailoverInput, self).__init__(**kwargs)
        self.properties = properties


class RecoveryPlanUnplannedFailoverInputProperties(msrest.serialization.Model):
    """Recovery plan unplanned failover input properties.

    All required parameters must be populated in order to send to Azure.

    :param failover_direction: Required. The failover direction. Possible values include:
     "PrimaryToRecovery", "RecoveryToPrimary".
    :type failover_direction: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PossibleOperationsDirections
    :param source_site_operations: Required. A value indicating whether source site operations are
     required. Possible values include: "Required", "NotRequired".
    :type source_site_operations: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SourceSiteOperations
    :param provider_specific_details: The provider specific properties.
    :type provider_specific_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanProviderSpecificFailoverInput]
    """

    _validation = {
        'failover_direction': {'required': True},
        'source_site_operations': {'required': True},
    }

    _attribute_map = {
        'failover_direction': {'key': 'failoverDirection', 'type': 'str'},
        'source_site_operations': {'key': 'sourceSiteOperations', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': '[RecoveryPlanProviderSpecificFailoverInput]'},
    }

    def __init__(
        self,
        *,
        failover_direction: Union[str, "PossibleOperationsDirections"],
        source_site_operations: Union[str, "SourceSiteOperations"],
        provider_specific_details: Optional[List["RecoveryPlanProviderSpecificFailoverInput"]] = None,
        **kwargs
    ):
        super(RecoveryPlanUnplannedFailoverInputProperties, self).__init__(**kwargs)
        self.failover_direction = failover_direction
        self.source_site_operations = source_site_operations
        self.provider_specific_details = provider_specific_details


class RecoveryPoint(Resource):
    """Recovery point.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The recovery point properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPointProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RecoveryPointProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["RecoveryPointProperties"] = None,
        **kwargs
    ):
        super(RecoveryPoint, self).__init__(location=location, **kwargs)
        self.properties = properties


class RecoveryPointCollection(msrest.serialization.Model):
    """Collection of recovery point details.

    :param value: The recovery point details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPoint]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecoveryPoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RecoveryPoint"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryPointCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RecoveryPointProperties(msrest.serialization.Model):
    """Recovery point properties.

    :param recovery_point_time: The recovery point time.
    :type recovery_point_time: ~datetime.datetime
    :param recovery_point_type: The recovery point type: ApplicationConsistent, CrashConsistent.
    :type recovery_point_type: str
    :param provider_specific_details: The provider specific details for the recovery point.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ProviderSpecificRecoveryPointDetails
    """

    _attribute_map = {
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'ProviderSpecificRecoveryPointDetails'},
    }

    def __init__(
        self,
        *,
        recovery_point_time: Optional[datetime.datetime] = None,
        recovery_point_type: Optional[str] = None,
        provider_specific_details: Optional["ProviderSpecificRecoveryPointDetails"] = None,
        **kwargs
    ):
        super(RecoveryPointProperties, self).__init__(**kwargs)
        self.recovery_point_time = recovery_point_time
        self.recovery_point_type = recovery_point_type
        self.provider_specific_details = provider_specific_details


class RecoveryServicesProvider(Resource):
    """Provider details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: Provider properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RecoveryServicesProviderProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RecoveryServicesProviderProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["RecoveryServicesProviderProperties"] = None,
        **kwargs
    ):
        super(RecoveryServicesProvider, self).__init__(location=location, **kwargs)
        self.properties = properties


class RecoveryServicesProviderCollection(msrest.serialization.Model):
    """Collection of providers.

    :param value: The Servers details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryServicesProvider]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecoveryServicesProvider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RecoveryServicesProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RecoveryServicesProviderCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RecoveryServicesProviderProperties(msrest.serialization.Model):
    """Recovery services provider properties.

    :param fabric_type: Type of the site.
    :type fabric_type: str
    :param friendly_name: Friendly name of the DRA.
    :type friendly_name: str
    :param provider_version: The provider version.
    :type provider_version: str
    :param server_version: The fabric provider.
    :type server_version: str
    :param provider_version_state: DRA version status.
    :type provider_version_state: str
    :param provider_version_expiry_date: Expiry date of the version.
    :type provider_version_expiry_date: ~datetime.datetime
    :param fabric_friendly_name: The fabric friendly name.
    :type fabric_friendly_name: str
    :param last_heart_beat: Time when last heartbeat was sent by the DRA.
    :type last_heart_beat: ~datetime.datetime
    :param connection_status: A value indicating whether DRA is responsive.
    :type connection_status: str
    :param protected_item_count: Number of protected VMs currently managed by the DRA.
    :type protected_item_count: int
    :param allowed_scenarios: The scenarios allowed on this provider.
    :type allowed_scenarios: list[str]
    :param health_error_details: The recovery services provider health error details.
    :type health_error_details: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param dra_identifier: The DRA Id.
    :type dra_identifier: str
    :param machine_id: The machine Id.
    :type machine_id: str
    :param machine_name: The machine name.
    :type machine_name: str
    :param bios_id: The Bios Id.
    :type bios_id: str
    :param authentication_identity_details: The authentication identity details.
    :type authentication_identity_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderDetails
    :param resource_access_identity_details: The resource access identity details.
    :type resource_access_identity_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderDetails
    :param data_plane_authentication_identity_details: The data plane authentication identity
     details.
    :type data_plane_authentication_identity_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.IdentityProviderDetails
    :param provider_version_details: The provider version details.
    :type provider_version_details: ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
    """

    _attribute_map = {
        'fabric_type': {'key': 'fabricType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'provider_version': {'key': 'providerVersion', 'type': 'str'},
        'server_version': {'key': 'serverVersion', 'type': 'str'},
        'provider_version_state': {'key': 'providerVersionState', 'type': 'str'},
        'provider_version_expiry_date': {'key': 'providerVersionExpiryDate', 'type': 'iso-8601'},
        'fabric_friendly_name': {'key': 'fabricFriendlyName', 'type': 'str'},
        'last_heart_beat': {'key': 'lastHeartBeat', 'type': 'iso-8601'},
        'connection_status': {'key': 'connectionStatus', 'type': 'str'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'int'},
        'allowed_scenarios': {'key': 'allowedScenarios', 'type': '[str]'},
        'health_error_details': {'key': 'healthErrorDetails', 'type': '[HealthError]'},
        'dra_identifier': {'key': 'draIdentifier', 'type': 'str'},
        'machine_id': {'key': 'machineId', 'type': 'str'},
        'machine_name': {'key': 'machineName', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'authentication_identity_details': {'key': 'authenticationIdentityDetails', 'type': 'IdentityProviderDetails'},
        'resource_access_identity_details': {'key': 'resourceAccessIdentityDetails', 'type': 'IdentityProviderDetails'},
        'data_plane_authentication_identity_details': {'key': 'dataPlaneAuthenticationIdentityDetails', 'type': 'IdentityProviderDetails'},
        'provider_version_details': {'key': 'providerVersionDetails', 'type': 'VersionDetails'},
    }

    def __init__(
        self,
        *,
        fabric_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        provider_version: Optional[str] = None,
        server_version: Optional[str] = None,
        provider_version_state: Optional[str] = None,
        provider_version_expiry_date: Optional[datetime.datetime] = None,
        fabric_friendly_name: Optional[str] = None,
        last_heart_beat: Optional[datetime.datetime] = None,
        connection_status: Optional[str] = None,
        protected_item_count: Optional[int] = None,
        allowed_scenarios: Optional[List[str]] = None,
        health_error_details: Optional[List["HealthError"]] = None,
        dra_identifier: Optional[str] = None,
        machine_id: Optional[str] = None,
        machine_name: Optional[str] = None,
        bios_id: Optional[str] = None,
        authentication_identity_details: Optional["IdentityProviderDetails"] = None,
        resource_access_identity_details: Optional["IdentityProviderDetails"] = None,
        data_plane_authentication_identity_details: Optional["IdentityProviderDetails"] = None,
        provider_version_details: Optional["VersionDetails"] = None,
        **kwargs
    ):
        super(RecoveryServicesProviderProperties, self).__init__(**kwargs)
        self.fabric_type = fabric_type
        self.friendly_name = friendly_name
        self.provider_version = provider_version
        self.server_version = server_version
        self.provider_version_state = provider_version_state
        self.provider_version_expiry_date = provider_version_expiry_date
        self.fabric_friendly_name = fabric_friendly_name
        self.last_heart_beat = last_heart_beat
        self.connection_status = connection_status
        self.protected_item_count = protected_item_count
        self.allowed_scenarios = allowed_scenarios
        self.health_error_details = health_error_details
        self.dra_identifier = dra_identifier
        self.machine_id = machine_id
        self.machine_name = machine_name
        self.bios_id = bios_id
        self.authentication_identity_details = authentication_identity_details
        self.resource_access_identity_details = resource_access_identity_details
        self.data_plane_authentication_identity_details = data_plane_authentication_identity_details
        self.provider_version_details = provider_version_details


class RemoveDisksInput(msrest.serialization.Model):
    """Input for remove disk(s) operation.

    :param properties: Remove disk input properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.RemoveDisksInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RemoveDisksInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["RemoveDisksInputProperties"] = None,
        **kwargs
    ):
        super(RemoveDisksInput, self).__init__(**kwargs)
        self.properties = properties


class RemoveDisksInputProperties(msrest.serialization.Model):
    """Remove Disk input properties.

    :param provider_specific_details: The ReplicationProviderInput. For HyperVReplicaAzure
     provider, it will be AzureEnableProtectionInput object. For San provider, it will be
     SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.RemoveDisksProviderSpecificInput
    """

    _attribute_map = {
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'RemoveDisksProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: Optional["RemoveDisksProviderSpecificInput"] = None,
        **kwargs
    ):
        super(RemoveDisksInputProperties, self).__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class RemoveProtectionContainerMappingInput(msrest.serialization.Model):
    """Container unpairing input.

    :param properties: Configure protection input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RemoveProtectionContainerMappingInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RemoveProtectionContainerMappingInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["RemoveProtectionContainerMappingInputProperties"] = None,
        **kwargs
    ):
        super(RemoveProtectionContainerMappingInput, self).__init__(**kwargs)
        self.properties = properties


class RemoveProtectionContainerMappingInputProperties(msrest.serialization.Model):
    """Unpairing input properties.

    :param provider_specific_input: Provider specific input for unpairing.
    :type provider_specific_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderContainerUnmappingInput
    """

    _attribute_map = {
        'provider_specific_input': {'key': 'providerSpecificInput', 'type': 'ReplicationProviderContainerUnmappingInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_input: Optional["ReplicationProviderContainerUnmappingInput"] = None,
        **kwargs
    ):
        super(RemoveProtectionContainerMappingInputProperties, self).__init__(**kwargs)
        self.provider_specific_input = provider_specific_input


class RenewCertificateInput(msrest.serialization.Model):
    """Certificate renewal input.

    :param properties: Renew certificate input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.RenewCertificateInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RenewCertificateInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["RenewCertificateInputProperties"] = None,
        **kwargs
    ):
        super(RenewCertificateInput, self).__init__(**kwargs)
        self.properties = properties


class RenewCertificateInputProperties(msrest.serialization.Model):
    """Renew Certificate input properties.

    :param renew_certificate_type: Renew certificate type.
    :type renew_certificate_type: str
    """

    _attribute_map = {
        'renew_certificate_type': {'key': 'renewCertificateType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        renew_certificate_type: Optional[str] = None,
        **kwargs
    ):
        super(RenewCertificateInputProperties, self).__init__(**kwargs)
        self.renew_certificate_type = renew_certificate_type


class ReplicationAgentDetails(msrest.serialization.Model):
    """Replication agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The replication agent Id.
    :vartype id: str
    :ivar name: The replication agent name.
    :vartype name: str
    :ivar bios_id: The replication agent Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The replication agent Fqdn.
    :vartype fqdn: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the replication agent.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health of the replication agent. Possible values include: "None", "Normal",
     "Warning", "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'bios_id': {'readonly': True},
        'fabric_object_id': {'readonly': True},
        'fqdn': {'readonly': True},
        'version': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'health': {'readonly': True},
        'health_errors': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'health': {'key': 'health', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationAgentDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None


class ReplicationEligibilityResults(msrest.serialization.Model):
    """Replication eligibility results response model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets the name of this object.
    :vartype name: str
    :ivar type: Gets the object type.
    :vartype type: str
    :ivar id: Gets Unique ARM identifier for this object.
    :vartype id: str
    :ivar properties: Gets properties model for replication eligibility results API.
    :vartype properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationEligibilityResultsProperties
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ReplicationEligibilityResultsProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationEligibilityResults, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.id = None
        self.properties = None


class ReplicationEligibilityResultsCollection(msrest.serialization.Model):
    """Replication eligibility results collection response model.

    :param value: The replication eligibility results details.
    :type value:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationEligibilityResults]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReplicationEligibilityResults]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ReplicationEligibilityResults"]] = None,
        **kwargs
    ):
        super(ReplicationEligibilityResultsCollection, self).__init__(**kwargs)
        self.value = value


class ReplicationEligibilityResultsErrorInfo(msrest.serialization.Model):
    """Error model that can be exposed to the user.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    :param possible_causes: The possible causes.
    :type possible_causes: str
    :param recommended_action: The recommended action.
    :type recommended_action: str
    :ivar status: The error status.
    :vartype status: str
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'possible_causes': {'key': 'possibleCauses', 'type': 'str'},
        'recommended_action': {'key': 'recommendedAction', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        **kwargs
    ):
        super(ReplicationEligibilityResultsErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action
        self.status = None


class ReplicationEligibilityResultsProperties(msrest.serialization.Model):
    """Properties model for replication eligibility results API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar client_request_id: The client request Id.
    :vartype client_request_id: str
    :param errors: The error details.
    :type errors:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationEligibilityResultsErrorInfo]
    """

    _validation = {
        'client_request_id': {'readonly': True},
    }

    _attribute_map = {
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ReplicationEligibilityResultsErrorInfo]'},
    }

    def __init__(
        self,
        *,
        errors: Optional[List["ReplicationEligibilityResultsErrorInfo"]] = None,
        **kwargs
    ):
        super(ReplicationEligibilityResultsProperties, self).__init__(**kwargs)
        self.client_request_id = None
        self.errors = errors


class ReplicationGroupDetails(ConfigurationSettings):
    """Replication group details. This will be used in case of San.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationGroupDetails, self).__init__(**kwargs)
        self.instance_type = 'ReplicationGroupDetails'  # type: str


class ReplicationProtectedItem(Resource):
    """Replication protected item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The custom data.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItemProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ReplicationProtectedItemProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["ReplicationProtectedItemProperties"] = None,
        **kwargs
    ):
        super(ReplicationProtectedItem, self).__init__(location=location, **kwargs)
        self.properties = properties


class ReplicationProtectedItemCollection(msrest.serialization.Model):
    """Replication protected item collection.

    :param value: The Replication protected item details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReplicationProtectedItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ReplicationProtectedItem"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ReplicationProtectedItemCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ReplicationProtectedItemProperties(msrest.serialization.Model):
    """Replication protected item custom data details.

    :param friendly_name: The name.
    :type friendly_name: str
    :param protected_item_type: The type of protected item type.
    :type protected_item_type: str
    :param protectable_item_id: The protected item ARM Id.
    :type protectable_item_id: str
    :param recovery_services_provider_id: The recovery provider ARM Id.
    :type recovery_services_provider_id: str
    :param primary_fabric_friendly_name: The friendly name of the primary fabric.
    :type primary_fabric_friendly_name: str
    :param primary_fabric_provider: The fabric provider of the primary fabric.
    :type primary_fabric_provider: str
    :param recovery_fabric_friendly_name: The friendly name of recovery fabric.
    :type recovery_fabric_friendly_name: str
    :param recovery_fabric_id: The Arm Id of recovery fabric.
    :type recovery_fabric_id: str
    :param primary_protection_container_friendly_name: The name of primary protection container
     friendly name.
    :type primary_protection_container_friendly_name: str
    :param recovery_protection_container_friendly_name: The name of recovery container friendly
     name.
    :type recovery_protection_container_friendly_name: str
    :param protection_state: The protection status.
    :type protection_state: str
    :param protection_state_description: The protection state description.
    :type protection_state_description: str
    :param active_location: The Current active location of the PE.
    :type active_location: str
    :param test_failover_state: The Test failover state.
    :type test_failover_state: str
    :param test_failover_state_description: The Test failover state description.
    :type test_failover_state_description: str
    :param allowed_operations: The allowed operations on the Replication protected item.
    :type allowed_operations: list[str]
    :param replication_health: The consolidated protection health for the VM taking any issues with
     SRS as well as all the replication units associated with the VM's replication group into
     account. This is a string representation of the ProtectionHealth enumeration.
    :type replication_health: str
    :param failover_health: The consolidated failover health for the VM.
    :type failover_health: str
    :param health_errors: List of health errors.
    :type health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param policy_id: The ID of Policy governing this PE.
    :type policy_id: str
    :param policy_friendly_name: The name of Policy governing this PE.
    :type policy_friendly_name: str
    :param last_successful_failover_time: The Last successful failover time.
    :type last_successful_failover_time: ~datetime.datetime
    :param last_successful_test_failover_time: The Last successful test failover time.
    :type last_successful_test_failover_time: ~datetime.datetime
    :param current_scenario: The current scenario.
    :type current_scenario: ~azure.mgmt.recoveryservicessiterecovery.models.CurrentScenarioDetails
    :param failover_recovery_point_id: The recovery point ARM Id to which the Vm was failed over.
    :type failover_recovery_point_id: str
    :param provider_specific_details: The Replication provider custom settings.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderSpecificSettings
    :param recovery_container_id: The recovery container Id.
    :type recovery_container_id: str
    :param event_correlation_id: The correlation Id for events associated with this protected item.
    :type event_correlation_id: str
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'protected_item_type': {'key': 'protectedItemType', 'type': 'str'},
        'protectable_item_id': {'key': 'protectableItemId', 'type': 'str'},
        'recovery_services_provider_id': {'key': 'recoveryServicesProviderId', 'type': 'str'},
        'primary_fabric_friendly_name': {'key': 'primaryFabricFriendlyName', 'type': 'str'},
        'primary_fabric_provider': {'key': 'primaryFabricProvider', 'type': 'str'},
        'recovery_fabric_friendly_name': {'key': 'recoveryFabricFriendlyName', 'type': 'str'},
        'recovery_fabric_id': {'key': 'recoveryFabricId', 'type': 'str'},
        'primary_protection_container_friendly_name': {'key': 'primaryProtectionContainerFriendlyName', 'type': 'str'},
        'recovery_protection_container_friendly_name': {'key': 'recoveryProtectionContainerFriendlyName', 'type': 'str'},
        'protection_state': {'key': 'protectionState', 'type': 'str'},
        'protection_state_description': {'key': 'protectionStateDescription', 'type': 'str'},
        'active_location': {'key': 'activeLocation', 'type': 'str'},
        'test_failover_state': {'key': 'testFailoverState', 'type': 'str'},
        'test_failover_state_description': {'key': 'testFailoverStateDescription', 'type': 'str'},
        'allowed_operations': {'key': 'allowedOperations', 'type': '[str]'},
        'replication_health': {'key': 'replicationHealth', 'type': 'str'},
        'failover_health': {'key': 'failoverHealth', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'policy_friendly_name': {'key': 'policyFriendlyName', 'type': 'str'},
        'last_successful_failover_time': {'key': 'lastSuccessfulFailoverTime', 'type': 'iso-8601'},
        'last_successful_test_failover_time': {'key': 'lastSuccessfulTestFailoverTime', 'type': 'iso-8601'},
        'current_scenario': {'key': 'currentScenario', 'type': 'CurrentScenarioDetails'},
        'failover_recovery_point_id': {'key': 'failoverRecoveryPointId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'ReplicationProviderSpecificSettings'},
        'recovery_container_id': {'key': 'recoveryContainerId', 'type': 'str'},
        'event_correlation_id': {'key': 'eventCorrelationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        protected_item_type: Optional[str] = None,
        protectable_item_id: Optional[str] = None,
        recovery_services_provider_id: Optional[str] = None,
        primary_fabric_friendly_name: Optional[str] = None,
        primary_fabric_provider: Optional[str] = None,
        recovery_fabric_friendly_name: Optional[str] = None,
        recovery_fabric_id: Optional[str] = None,
        primary_protection_container_friendly_name: Optional[str] = None,
        recovery_protection_container_friendly_name: Optional[str] = None,
        protection_state: Optional[str] = None,
        protection_state_description: Optional[str] = None,
        active_location: Optional[str] = None,
        test_failover_state: Optional[str] = None,
        test_failover_state_description: Optional[str] = None,
        allowed_operations: Optional[List[str]] = None,
        replication_health: Optional[str] = None,
        failover_health: Optional[str] = None,
        health_errors: Optional[List["HealthError"]] = None,
        policy_id: Optional[str] = None,
        policy_friendly_name: Optional[str] = None,
        last_successful_failover_time: Optional[datetime.datetime] = None,
        last_successful_test_failover_time: Optional[datetime.datetime] = None,
        current_scenario: Optional["CurrentScenarioDetails"] = None,
        failover_recovery_point_id: Optional[str] = None,
        provider_specific_details: Optional["ReplicationProviderSpecificSettings"] = None,
        recovery_container_id: Optional[str] = None,
        event_correlation_id: Optional[str] = None,
        **kwargs
    ):
        super(ReplicationProtectedItemProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.protected_item_type = protected_item_type
        self.protectable_item_id = protectable_item_id
        self.recovery_services_provider_id = recovery_services_provider_id
        self.primary_fabric_friendly_name = primary_fabric_friendly_name
        self.primary_fabric_provider = primary_fabric_provider
        self.recovery_fabric_friendly_name = recovery_fabric_friendly_name
        self.recovery_fabric_id = recovery_fabric_id
        self.primary_protection_container_friendly_name = primary_protection_container_friendly_name
        self.recovery_protection_container_friendly_name = recovery_protection_container_friendly_name
        self.protection_state = protection_state
        self.protection_state_description = protection_state_description
        self.active_location = active_location
        self.test_failover_state = test_failover_state
        self.test_failover_state_description = test_failover_state_description
        self.allowed_operations = allowed_operations
        self.replication_health = replication_health
        self.failover_health = failover_health
        self.health_errors = health_errors
        self.policy_id = policy_id
        self.policy_friendly_name = policy_friendly_name
        self.last_successful_failover_time = last_successful_failover_time
        self.last_successful_test_failover_time = last_successful_test_failover_time
        self.current_scenario = current_scenario
        self.failover_recovery_point_id = failover_recovery_point_id
        self.provider_specific_details = provider_specific_details
        self.recovery_container_id = recovery_container_id
        self.event_correlation_id = event_correlation_id


class ReplicationProtectionIntent(Resource):
    """Replication protection intent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The custom data.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionIntentProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ReplicationProtectionIntentProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["ReplicationProtectionIntentProperties"] = None,
        **kwargs
    ):
        super(ReplicationProtectionIntent, self).__init__(location=location, **kwargs)
        self.properties = properties


class ReplicationProtectionIntentCollection(msrest.serialization.Model):
    """Replication protection intent objects collection.

    :param value: The Replication protection intent details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionIntent]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReplicationProtectionIntent]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ReplicationProtectionIntent"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ReplicationProtectionIntentCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ReplicationProtectionIntentProperties(msrest.serialization.Model):
    """Replication protection intent custom data details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param friendly_name: The name.
    :type friendly_name: str
    :ivar job_id: The job Id.
    :vartype job_id: str
    :ivar job_state: The job state.
    :vartype job_state: str
    :ivar is_active: A value indicating whether the intent object is active.
    :vartype is_active: bool
    :ivar creation_time_utc: The creation time in UTC.
    :vartype creation_time_utc: str
    :param provider_specific_details: The Replication provider custom settings.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectionIntentProviderSpecificSettings
    """

    _validation = {
        'job_id': {'readonly': True},
        'job_state': {'readonly': True},
        'is_active': {'readonly': True},
        'creation_time_utc': {'readonly': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'job_state': {'key': 'jobState', 'type': 'str'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
        'creation_time_utc': {'key': 'creationTimeUTC', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'ReplicationProtectionIntentProviderSpecificSettings'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        provider_specific_details: Optional["ReplicationProtectionIntentProviderSpecificSettings"] = None,
        **kwargs
    ):
        super(ReplicationProtectionIntentProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.job_id = None
        self.job_state = None
        self.is_active = None
        self.creation_time_utc = None
        self.provider_specific_details = provider_specific_details


class ReplicationProviderContainerUnmappingInput(msrest.serialization.Model):
    """Provider specific input for unpairing operations.

    :param instance_type: The class type.
    :type instance_type: str
    """

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        instance_type: Optional[str] = None,
        **kwargs
    ):
        super(ReplicationProviderContainerUnmappingInput, self).__init__(**kwargs)
        self.instance_type = instance_type


class ReprotectAgentDetails(msrest.serialization.Model):
    """Reprotect agent details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The reprotect agent Id.
    :vartype id: str
    :ivar name: The reprotect agent name.
    :vartype name: str
    :ivar bios_id: The reprotect agent Bios Id.
    :vartype bios_id: str
    :ivar fabric_object_id: The fabric object Id.
    :vartype fabric_object_id: str
    :ivar fqdn: The reprotect agent Fqdn.
    :vartype fqdn: str
    :ivar version: The version.
    :vartype version: str
    :ivar last_heartbeat_utc: The last heartbeat received from the reprotect agent.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar health: The health of the reprotect agent. Possible values include: "None", "Normal",
     "Warning", "Critical".
    :vartype health: str or ~azure.mgmt.recoveryservicessiterecovery.models.ProtectionHealth
    :ivar health_errors: The health errors.
    :vartype health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :ivar protected_item_count: The protected item count.
    :vartype protected_item_count: int
    :ivar accessible_datastores: The list of accessible datastores fetched from discovery.
    :vartype accessible_datastores: list[str]
    :ivar vcenter_id: The Vcenter Id.
    :vartype vcenter_id: str
    :ivar last_discovery_in_utc: The last time when SDS information discovered in SRS.
    :vartype last_discovery_in_utc: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'bios_id': {'readonly': True},
        'fabric_object_id': {'readonly': True},
        'fqdn': {'readonly': True},
        'version': {'readonly': True},
        'last_heartbeat_utc': {'readonly': True},
        'health': {'readonly': True},
        'health_errors': {'readonly': True},
        'protected_item_count': {'readonly': True},
        'accessible_datastores': {'readonly': True},
        'vcenter_id': {'readonly': True},
        'last_discovery_in_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'bios_id': {'key': 'biosId', 'type': 'str'},
        'fabric_object_id': {'key': 'fabricObjectId', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'last_heartbeat_utc': {'key': 'lastHeartbeatUtc', 'type': 'iso-8601'},
        'health': {'key': 'health', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
        'protected_item_count': {'key': 'protectedItemCount', 'type': 'int'},
        'accessible_datastores': {'key': 'accessibleDatastores', 'type': '[str]'},
        'vcenter_id': {'key': 'vcenterId', 'type': 'str'},
        'last_discovery_in_utc': {'key': 'lastDiscoveryInUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReprotectAgentDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.bios_id = None
        self.fabric_object_id = None
        self.fqdn = None
        self.version = None
        self.last_heartbeat_utc = None
        self.health = None
        self.health_errors = None
        self.protected_item_count = None
        self.accessible_datastores = None
        self.vcenter_id = None
        self.last_discovery_in_utc = None


class ResolveHealthError(msrest.serialization.Model):
    """Resolve health errors input properties.

    :param health_error_id: Health error id.
    :type health_error_id: str
    """

    _attribute_map = {
        'health_error_id': {'key': 'healthErrorId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_error_id: Optional[str] = None,
        **kwargs
    ):
        super(ResolveHealthError, self).__init__(**kwargs)
        self.health_error_id = health_error_id


class ResolveHealthInput(msrest.serialization.Model):
    """Resolve health input.

    :param properties: Disable resolve health input properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.ResolveHealthInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ResolveHealthInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ResolveHealthInputProperties"] = None,
        **kwargs
    ):
        super(ResolveHealthInput, self).__init__(**kwargs)
        self.properties = properties


class ResolveHealthInputProperties(msrest.serialization.Model):
    """Resolve health input properties.

    :param health_errors: Health errors.
    :type health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.ResolveHealthError]
    """

    _attribute_map = {
        'health_errors': {'key': 'healthErrors', 'type': '[ResolveHealthError]'},
    }

    def __init__(
        self,
        *,
        health_errors: Optional[List["ResolveHealthError"]] = None,
        **kwargs
    ):
        super(ResolveHealthInputProperties, self).__init__(**kwargs)
        self.health_errors = health_errors


class ResourceHealthSummary(msrest.serialization.Model):
    """Base class to define the health summary of the resources contained under an Arm resource.

    :param resource_count: The count of total resources under the container.
    :type resource_count: int
    :param issues: The list of summary of health errors across the resources under the container.
    :type issues: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthErrorSummary]
    :param categorized_resource_counts: The categorized resource counts.
    :type categorized_resource_counts: dict[str, int]
    """

    _attribute_map = {
        'resource_count': {'key': 'resourceCount', 'type': 'int'},
        'issues': {'key': 'issues', 'type': '[HealthErrorSummary]'},
        'categorized_resource_counts': {'key': 'categorizedResourceCounts', 'type': '{int}'},
    }

    def __init__(
        self,
        *,
        resource_count: Optional[int] = None,
        issues: Optional[List["HealthErrorSummary"]] = None,
        categorized_resource_counts: Optional[Dict[str, int]] = None,
        **kwargs
    ):
        super(ResourceHealthSummary, self).__init__(**kwargs)
        self.resource_count = resource_count
        self.issues = issues
        self.categorized_resource_counts = categorized_resource_counts


class ResumeJobParams(msrest.serialization.Model):
    """Resume job params.

    :param properties: Resume job properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.ResumeJobParamsProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ResumeJobParamsProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ResumeJobParamsProperties"] = None,
        **kwargs
    ):
        super(ResumeJobParams, self).__init__(**kwargs)
        self.properties = properties


class ResumeJobParamsProperties(msrest.serialization.Model):
    """Resume job properties.

    :param comments: Resume job comments.
    :type comments: str
    """

    _attribute_map = {
        'comments': {'key': 'comments', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        comments: Optional[str] = None,
        **kwargs
    ):
        super(ResumeJobParamsProperties, self).__init__(**kwargs)
        self.comments = comments


class ResyncInput(msrest.serialization.Model):
    """Resync input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Resync input properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.ResyncInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ResyncInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ResyncInputProperties",
        **kwargs
    ):
        super(ResyncInput, self).__init__(**kwargs)
        self.properties = properties


class ResyncInputProperties(msrest.serialization.Model):
    """Resync input properties.

    All required parameters must be populated in order to send to Azure.

    :param provider_specific_details: Required. The provider specific details.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ResyncProviderSpecificInput
    """

    _validation = {
        'provider_specific_details': {'required': True},
    }

    _attribute_map = {
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'ResyncProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: "ResyncProviderSpecificInput",
        **kwargs
    ):
        super(ResyncInputProperties, self).__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class ResyncProviderSpecificInput(msrest.serialization.Model):
    """Resync provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VMwareCbtResyncInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'VMwareCbt': 'VMwareCbtResyncInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResyncProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class RetentionVolume(msrest.serialization.Model):
    """The retention details of the MT.

    :param volume_name: The volume name.
    :type volume_name: str
    :param capacity_in_bytes: The volume capacity.
    :type capacity_in_bytes: long
    :param free_space_in_bytes: The free space available in this volume.
    :type free_space_in_bytes: long
    :param threshold_percentage: The threshold percentage.
    :type threshold_percentage: int
    """

    _attribute_map = {
        'volume_name': {'key': 'volumeName', 'type': 'str'},
        'capacity_in_bytes': {'key': 'capacityInBytes', 'type': 'long'},
        'free_space_in_bytes': {'key': 'freeSpaceInBytes', 'type': 'long'},
        'threshold_percentage': {'key': 'thresholdPercentage', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        volume_name: Optional[str] = None,
        capacity_in_bytes: Optional[int] = None,
        free_space_in_bytes: Optional[int] = None,
        threshold_percentage: Optional[int] = None,
        **kwargs
    ):
        super(RetentionVolume, self).__init__(**kwargs)
        self.volume_name = volume_name
        self.capacity_in_bytes = capacity_in_bytes
        self.free_space_in_bytes = free_space_in_bytes
        self.threshold_percentage = threshold_percentage


class ReverseReplicationInput(msrest.serialization.Model):
    """Reverse replication input.

    :param properties: Reverse replication properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReverseReplicationInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ReverseReplicationInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ReverseReplicationInputProperties"] = None,
        **kwargs
    ):
        super(ReverseReplicationInput, self).__init__(**kwargs)
        self.properties = properties


class ReverseReplicationInputProperties(msrest.serialization.Model):
    """Reverse replication input properties.

    :param failover_direction: Failover direction.
    :type failover_direction: str
    :param provider_specific_details: Provider specific reverse replication input.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReverseReplicationProviderSpecificInput
    """

    _attribute_map = {
        'failover_direction': {'key': 'failoverDirection', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'ReverseReplicationProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        failover_direction: Optional[str] = None,
        provider_specific_details: Optional["ReverseReplicationProviderSpecificInput"] = None,
        **kwargs
    ):
        super(ReverseReplicationInputProperties, self).__init__(**kwargs)
        self.failover_direction = failover_direction
        self.provider_specific_details = provider_specific_details


class RoleAssignment(msrest.serialization.Model):
    """Azure role assignment details.

    :param id: The ARM Id of the role assignment.
    :type id: str
    :param name: The name of the role assignment.
    :type name: str
    :param scope: Role assignment scope.
    :type scope: str
    :param principal_id: Principal Id.
    :type principal_id: str
    :param role_definition_id: Role definition id.
    :type role_definition_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        scope: Optional[str] = None,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignment, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.scope = scope
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id


class RunAsAccount(msrest.serialization.Model):
    """CS Accounts Details.

    :param account_id: The CS RunAs account Id.
    :type account_id: str
    :param account_name: The CS RunAs account name.
    :type account_name: str
    """

    _attribute_map = {
        'account_id': {'key': 'accountId', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_id: Optional[str] = None,
        account_name: Optional[str] = None,
        **kwargs
    ):
        super(RunAsAccount, self).__init__(**kwargs)
        self.account_id = account_id
        self.account_name = account_name


class ScriptActionTaskDetails(TaskTypeDetails):
    """This class represents the script action task details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param name: The name.
    :type name: str
    :param path: The path.
    :type path: str
    :param output: The output.
    :type output: str
    :param is_primary_side_script: A value indicating whether it is a primary side script or not.
    :type is_primary_side_script: bool
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'output': {'key': 'output', 'type': 'str'},
        'is_primary_side_script': {'key': 'isPrimarySideScript', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        path: Optional[str] = None,
        output: Optional[str] = None,
        is_primary_side_script: Optional[bool] = None,
        **kwargs
    ):
        super(ScriptActionTaskDetails, self).__init__(**kwargs)
        self.instance_type = 'ScriptActionTaskDetails'  # type: str
        self.name = name
        self.path = path
        self.output = output
        self.is_primary_side_script = is_primary_side_script


class ServiceError(msrest.serialization.Model):
    """ASR error model.

    :param code: Error code.
    :type code: str
    :param message: Error message.
    :type message: str
    :param possible_causes: Possible causes of error.
    :type possible_causes: str
    :param recommended_action: Recommended action to resolve error.
    :type recommended_action: str
    :param activity_id: Activity Id.
    :type activity_id: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'possible_causes': {'key': 'possibleCauses', 'type': 'str'},
        'recommended_action': {'key': 'recommendedAction', 'type': 'str'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        possible_causes: Optional[str] = None,
        recommended_action: Optional[str] = None,
        activity_id: Optional[str] = None,
        **kwargs
    ):
        super(ServiceError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.possible_causes = possible_causes
        self.recommended_action = recommended_action
        self.activity_id = activity_id


class StorageClassification(Resource):
    """Storage object definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: Properties of the storage object.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageClassificationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'StorageClassificationProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["StorageClassificationProperties"] = None,
        **kwargs
    ):
        super(StorageClassification, self).__init__(location=location, **kwargs)
        self.properties = properties


class StorageClassificationCollection(msrest.serialization.Model):
    """Collection of storage details.

    :param value: The storage details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.StorageClassification]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageClassification]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["StorageClassification"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(StorageClassificationCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class StorageClassificationMapping(Resource):
    """Storage mapping object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: Properties of the storage mapping object.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.StorageClassificationMappingProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'StorageClassificationMappingProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["StorageClassificationMappingProperties"] = None,
        **kwargs
    ):
        super(StorageClassificationMapping, self).__init__(location=location, **kwargs)
        self.properties = properties


class StorageClassificationMappingCollection(msrest.serialization.Model):
    """Collection of storage mapping details.

    :param value: The storage details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.StorageClassificationMapping]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageClassificationMapping]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["StorageClassificationMapping"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(StorageClassificationMappingCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class StorageClassificationMappingInput(msrest.serialization.Model):
    """Storage mapping input.

    :param properties: Storage mapping input properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.StorageMappingInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'StorageMappingInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["StorageMappingInputProperties"] = None,
        **kwargs
    ):
        super(StorageClassificationMappingInput, self).__init__(**kwargs)
        self.properties = properties


class StorageClassificationMappingProperties(msrest.serialization.Model):
    """Storage mapping properties.

    :param target_storage_classification_id: Target storage object Id.
    :type target_storage_classification_id: str
    """

    _attribute_map = {
        'target_storage_classification_id': {'key': 'targetStorageClassificationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_storage_classification_id: Optional[str] = None,
        **kwargs
    ):
        super(StorageClassificationMappingProperties, self).__init__(**kwargs)
        self.target_storage_classification_id = target_storage_classification_id


class StorageClassificationProperties(msrest.serialization.Model):
    """Storage object properties.

    :param friendly_name: Friendly name of the Storage classification.
    :type friendly_name: str
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        **kwargs
    ):
        super(StorageClassificationProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name


class StorageMappingInputProperties(msrest.serialization.Model):
    """Storage mapping input properties.

    :param target_storage_classification_id: The ID of the storage object.
    :type target_storage_classification_id: str
    """

    _attribute_map = {
        'target_storage_classification_id': {'key': 'targetStorageClassificationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_storage_classification_id: Optional[str] = None,
        **kwargs
    ):
        super(StorageMappingInputProperties, self).__init__(**kwargs)
        self.target_storage_classification_id = target_storage_classification_id


class Subnet(msrest.serialization.Model):
    """Subnets of the network.

    :param name: The subnet name.
    :type name: str
    :param friendly_name: The subnet friendly name.
    :type friendly_name: str
    :param address_list: The list of addresses for the subnet.
    :type address_list: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'address_list': {'key': 'addressList', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        address_list: Optional[List[str]] = None,
        **kwargs
    ):
        super(Subnet, self).__init__(**kwargs)
        self.name = name
        self.friendly_name = friendly_name
        self.address_list = address_list


class SupportedOperatingSystems(Resource):
    """Supported operating systems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The supported operating systems properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.SupportedOSProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'SupportedOSProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["SupportedOSProperties"] = None,
        **kwargs
    ):
        super(SupportedOperatingSystems, self).__init__(location=location, **kwargs)
        self.properties = properties


class SupportedOSDetails(msrest.serialization.Model):
    """Supported operating system details.

    :param os_name: The name.
    :type os_name: str
    :param os_type: The type.
    :type os_type: str
    :param os_versions: The list of version for operating system.
    :type os_versions: list[~azure.mgmt.recoveryservicessiterecovery.models.OSVersionWrapper]
    """

    _attribute_map = {
        'os_name': {'key': 'osName', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_versions': {'key': 'osVersions', 'type': '[OSVersionWrapper]'},
    }

    def __init__(
        self,
        *,
        os_name: Optional[str] = None,
        os_type: Optional[str] = None,
        os_versions: Optional[List["OSVersionWrapper"]] = None,
        **kwargs
    ):
        super(SupportedOSDetails, self).__init__(**kwargs)
        self.os_name = os_name
        self.os_type = os_type
        self.os_versions = os_versions


class SupportedOSProperties(msrest.serialization.Model):
    """Supported operating systems properties.

    :param supported_os_list: The supported operating systems property list.
    :type supported_os_list:
     list[~azure.mgmt.recoveryservicessiterecovery.models.SupportedOSProperty]
    """

    _attribute_map = {
        'supported_os_list': {'key': 'supportedOsList', 'type': '[SupportedOSProperty]'},
    }

    def __init__(
        self,
        *,
        supported_os_list: Optional[List["SupportedOSProperty"]] = None,
        **kwargs
    ):
        super(SupportedOSProperties, self).__init__(**kwargs)
        self.supported_os_list = supported_os_list


class SupportedOSProperty(msrest.serialization.Model):
    """Supported operating systems property.

    :param instance_type: The replication provider type.
    :type instance_type: str
    :param supported_os: The list of supported operating systems.
    :type supported_os: list[~azure.mgmt.recoveryservicessiterecovery.models.SupportedOSDetails]
    """

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'supported_os': {'key': 'supportedOs', 'type': '[SupportedOSDetails]'},
    }

    def __init__(
        self,
        *,
        instance_type: Optional[str] = None,
        supported_os: Optional[List["SupportedOSDetails"]] = None,
        **kwargs
    ):
        super(SupportedOSProperty, self).__init__(**kwargs)
        self.instance_type = instance_type
        self.supported_os = supported_os


class SwitchProtectionInput(msrest.serialization.Model):
    """Switch protection input.

    :param properties: Switch protection properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.SwitchProtectionInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'SwitchProtectionInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["SwitchProtectionInputProperties"] = None,
        **kwargs
    ):
        super(SwitchProtectionInput, self).__init__(**kwargs)
        self.properties = properties


class SwitchProtectionInputProperties(msrest.serialization.Model):
    """Switch protection input properties.

    :param replication_protected_item_name: The unique replication protected item name.
    :type replication_protected_item_name: str
    :param provider_specific_details: Provider specific switch protection input.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.SwitchProtectionProviderSpecificInput
    """

    _attribute_map = {
        'replication_protected_item_name': {'key': 'replicationProtectedItemName', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'SwitchProtectionProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        replication_protected_item_name: Optional[str] = None,
        provider_specific_details: Optional["SwitchProtectionProviderSpecificInput"] = None,
        **kwargs
    ):
        super(SwitchProtectionInputProperties, self).__init__(**kwargs)
        self.replication_protected_item_name = replication_protected_item_name
        self.provider_specific_details = provider_specific_details


class SwitchProtectionJobDetails(JobDetails):
    """This class represents details for switch protection job.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of job details (see JobDetailsTypes enum for
     possible values).Constant filled by server.
    :type instance_type: str
    :param affected_object_details: The affected object properties like source server, source
     cloud, target server, target cloud etc. based on the workflow object details.
    :type affected_object_details: dict[str, str]
    :param new_replication_protected_item_id: ARM Id of the new replication protected item.
    :type new_replication_protected_item_id: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'affected_object_details': {'key': 'affectedObjectDetails', 'type': '{str}'},
        'new_replication_protected_item_id': {'key': 'newReplicationProtectedItemId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        affected_object_details: Optional[Dict[str, str]] = None,
        new_replication_protected_item_id: Optional[str] = None,
        **kwargs
    ):
        super(SwitchProtectionJobDetails, self).__init__(affected_object_details=affected_object_details, **kwargs)
        self.instance_type = 'SwitchProtectionJobDetails'  # type: str
        self.new_replication_protected_item_id = new_replication_protected_item_id


class TargetComputeSize(msrest.serialization.Model):
    """Represents applicable recovery vm sizes.

    :param id: The Id.
    :type id: str
    :param name: The name.
    :type name: str
    :param type: The Type of the object.
    :type type: str
    :param properties: The custom data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.TargetComputeSizeProperties
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'TargetComputeSizeProperties'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        properties: Optional["TargetComputeSizeProperties"] = None,
        **kwargs
    ):
        super(TargetComputeSize, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.properties = properties


class TargetComputeSizeCollection(msrest.serialization.Model):
    """Target compute size collection.

    :param value: The list of target compute sizes.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.TargetComputeSize]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TargetComputeSize]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TargetComputeSize"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(TargetComputeSizeCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TargetComputeSizeProperties(msrest.serialization.Model):
    """Represents applicable recovery vm sizes properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Target compute size name.
    :type name: str
    :param friendly_name: Target compute size display name.
    :type friendly_name: str
    :param cpu_cores_count: The maximum cpu cores count supported by target compute size.
    :type cpu_cores_count: int
    :ivar v_cpus_available: The Available vCPUs supported by target compute size.
    :vartype v_cpus_available: int
    :param memory_in_gb: The maximum memory in GB supported by target compute size.
    :type memory_in_gb: float
    :param max_data_disk_count: The maximum data disks count supported by target compute size.
    :type max_data_disk_count: int
    :param max_nics_count: The maximum Nics count supported by target compute size.
    :type max_nics_count: int
    :param errors: The reasons why the target compute size is not applicable for the protected
     item.
    :type errors: list[~azure.mgmt.recoveryservicessiterecovery.models.ComputeSizeErrorDetails]
    :param high_iops_supported: The value indicating whether the target compute size supports high
     Iops.
    :type high_iops_supported: str
    :param hyper_v_generations: The supported HyperV Generations.
    :type hyper_v_generations: list[str]
    """

    _validation = {
        'v_cpus_available': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'cpu_cores_count': {'key': 'cpuCoresCount', 'type': 'int'},
        'v_cpus_available': {'key': 'vCPUsAvailable', 'type': 'int'},
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'max_data_disk_count': {'key': 'maxDataDiskCount', 'type': 'int'},
        'max_nics_count': {'key': 'maxNicsCount', 'type': 'int'},
        'errors': {'key': 'errors', 'type': '[ComputeSizeErrorDetails]'},
        'high_iops_supported': {'key': 'highIopsSupported', 'type': 'str'},
        'hyper_v_generations': {'key': 'hyperVGenerations', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        cpu_cores_count: Optional[int] = None,
        memory_in_gb: Optional[float] = None,
        max_data_disk_count: Optional[int] = None,
        max_nics_count: Optional[int] = None,
        errors: Optional[List["ComputeSizeErrorDetails"]] = None,
        high_iops_supported: Optional[str] = None,
        hyper_v_generations: Optional[List[str]] = None,
        **kwargs
    ):
        super(TargetComputeSizeProperties, self).__init__(**kwargs)
        self.name = name
        self.friendly_name = friendly_name
        self.cpu_cores_count = cpu_cores_count
        self.v_cpus_available = None
        self.memory_in_gb = memory_in_gb
        self.max_data_disk_count = max_data_disk_count
        self.max_nics_count = max_nics_count
        self.errors = errors
        self.high_iops_supported = high_iops_supported
        self.hyper_v_generations = hyper_v_generations


class TestFailoverCleanupInput(msrest.serialization.Model):
    """Input definition for test failover cleanup.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Test failover cleanup input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverCleanupInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'TestFailoverCleanupInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "TestFailoverCleanupInputProperties",
        **kwargs
    ):
        super(TestFailoverCleanupInput, self).__init__(**kwargs)
        self.properties = properties


class TestFailoverCleanupInputProperties(msrest.serialization.Model):
    """Input definition for test failover cleanup input properties.

    :param comments: Test failover cleanup comments.
    :type comments: str
    """

    _validation = {
        'comments': {'max_length': 1024, 'min_length': 0},
    }

    _attribute_map = {
        'comments': {'key': 'comments', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        comments: Optional[str] = None,
        **kwargs
    ):
        super(TestFailoverCleanupInputProperties, self).__init__(**kwargs)
        self.comments = comments


class TestFailoverInput(msrest.serialization.Model):
    """Input definition for test failover.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Test failover input properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'TestFailoverInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "TestFailoverInputProperties",
        **kwargs
    ):
        super(TestFailoverInput, self).__init__(**kwargs)
        self.properties = properties


class TestFailoverInputProperties(msrest.serialization.Model):
    """Input definition for test failover input properties.

    :param failover_direction: Test failover direction.
    :type failover_direction: str
    :param network_type: Network type to be used for test failover.
    :type network_type: str
    :param network_id: The id of the network to be used for test failover.
    :type network_id: str
    :param provider_specific_details: Provider specific settings.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverProviderSpecificInput
    """

    _attribute_map = {
        'failover_direction': {'key': 'failoverDirection', 'type': 'str'},
        'network_type': {'key': 'networkType', 'type': 'str'},
        'network_id': {'key': 'networkId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'TestFailoverProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        failover_direction: Optional[str] = None,
        network_type: Optional[str] = None,
        network_id: Optional[str] = None,
        provider_specific_details: Optional["TestFailoverProviderSpecificInput"] = None,
        **kwargs
    ):
        super(TestFailoverInputProperties, self).__init__(**kwargs)
        self.failover_direction = failover_direction
        self.network_type = network_type
        self.network_id = network_id
        self.provider_specific_details = provider_specific_details


class TestFailoverJobDetails(JobDetails):
    """This class represents the details for a test failover job.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the type of job details (see JobDetailsTypes enum for
     possible values).Constant filled by server.
    :type instance_type: str
    :param affected_object_details: The affected object properties like source server, source
     cloud, target server, target cloud etc. based on the workflow object details.
    :type affected_object_details: dict[str, str]
    :param test_failover_status: The test failover status.
    :type test_failover_status: str
    :param comments: The test failover comments.
    :type comments: str
    :param network_name: The test network name.
    :type network_name: str
    :param network_friendly_name: The test network friendly name.
    :type network_friendly_name: str
    :param network_type: The test network type (see TestFailoverInput enum for possible values).
    :type network_type: str
    :param protected_item_details: The test VM details.
    :type protected_item_details:
     list[~azure.mgmt.recoveryservicessiterecovery.models.FailoverReplicationProtectedItemDetails]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'affected_object_details': {'key': 'affectedObjectDetails', 'type': '{str}'},
        'test_failover_status': {'key': 'testFailoverStatus', 'type': 'str'},
        'comments': {'key': 'comments', 'type': 'str'},
        'network_name': {'key': 'networkName', 'type': 'str'},
        'network_friendly_name': {'key': 'networkFriendlyName', 'type': 'str'},
        'network_type': {'key': 'networkType', 'type': 'str'},
        'protected_item_details': {'key': 'protectedItemDetails', 'type': '[FailoverReplicationProtectedItemDetails]'},
    }

    def __init__(
        self,
        *,
        affected_object_details: Optional[Dict[str, str]] = None,
        test_failover_status: Optional[str] = None,
        comments: Optional[str] = None,
        network_name: Optional[str] = None,
        network_friendly_name: Optional[str] = None,
        network_type: Optional[str] = None,
        protected_item_details: Optional[List["FailoverReplicationProtectedItemDetails"]] = None,
        **kwargs
    ):
        super(TestFailoverJobDetails, self).__init__(affected_object_details=affected_object_details, **kwargs)
        self.instance_type = 'TestFailoverJobDetails'  # type: str
        self.test_failover_status = test_failover_status
        self.comments = comments
        self.network_name = network_name
        self.network_friendly_name = network_friendly_name
        self.network_type = network_type
        self.protected_item_details = protected_item_details


class TestMigrateCleanupInput(msrest.serialization.Model):
    """Input for test migrate cleanup.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Test migrate cleanup input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.TestMigrateCleanupInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'TestMigrateCleanupInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "TestMigrateCleanupInputProperties",
        **kwargs
    ):
        super(TestMigrateCleanupInput, self).__init__(**kwargs)
        self.properties = properties


class TestMigrateCleanupInputProperties(msrest.serialization.Model):
    """Test migrate cleanup input properties.

    :param comments: Test migrate cleanup comments.
    :type comments: str
    """

    _validation = {
        'comments': {'max_length': 1024, 'min_length': 0},
    }

    _attribute_map = {
        'comments': {'key': 'comments', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        comments: Optional[str] = None,
        **kwargs
    ):
        super(TestMigrateCleanupInputProperties, self).__init__(**kwargs)
        self.comments = comments


class TestMigrateInput(msrest.serialization.Model):
    """Input for test migrate.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Test migrate input properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.TestMigrateInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'TestMigrateInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "TestMigrateInputProperties",
        **kwargs
    ):
        super(TestMigrateInput, self).__init__(**kwargs)
        self.properties = properties


class TestMigrateInputProperties(msrest.serialization.Model):
    """Test migrate input properties.

    All required parameters must be populated in order to send to Azure.

    :param provider_specific_details: Required. The provider specific details.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.TestMigrateProviderSpecificInput
    """

    _validation = {
        'provider_specific_details': {'required': True},
    }

    _attribute_map = {
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'TestMigrateProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: "TestMigrateProviderSpecificInput",
        **kwargs
    ):
        super(TestMigrateInputProperties, self).__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class TestMigrateProviderSpecificInput(msrest.serialization.Model):
    """Test migrate provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VMwareCbtTestMigrateInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'VMwareCbt': 'VMwareCbtTestMigrateInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TestMigrateProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class UnplannedFailoverInput(msrest.serialization.Model):
    """Input definition for unplanned failover.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Unplanned failover input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UnplannedFailoverInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UnplannedFailoverInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "UnplannedFailoverInputProperties",
        **kwargs
    ):
        super(UnplannedFailoverInput, self).__init__(**kwargs)
        self.properties = properties


class UnplannedFailoverInputProperties(msrest.serialization.Model):
    """Input definition for unplanned failover input properties.

    :param failover_direction: Failover direction.
    :type failover_direction: str
    :param source_site_operations: Source site operations status.
    :type source_site_operations: str
    :param provider_specific_details: Provider specific settings.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.UnplannedFailoverProviderSpecificInput
    """

    _attribute_map = {
        'failover_direction': {'key': 'failoverDirection', 'type': 'str'},
        'source_site_operations': {'key': 'sourceSiteOperations', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'UnplannedFailoverProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        failover_direction: Optional[str] = None,
        source_site_operations: Optional[str] = None,
        provider_specific_details: Optional["UnplannedFailoverProviderSpecificInput"] = None,
        **kwargs
    ):
        super(UnplannedFailoverInputProperties, self).__init__(**kwargs)
        self.failover_direction = failover_direction
        self.source_site_operations = source_site_operations
        self.provider_specific_details = provider_specific_details


class UpdateApplianceForReplicationProtectedItemInput(msrest.serialization.Model):
    """Update appliance for replication protected item input.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Update appliance replication protected item properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateApplianceForReplicationProtectedItemInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdateApplianceForReplicationProtectedItemInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "UpdateApplianceForReplicationProtectedItemInputProperties",
        **kwargs
    ):
        super(UpdateApplianceForReplicationProtectedItemInput, self).__init__(**kwargs)
        self.properties = properties


class UpdateApplianceForReplicationProtectedItemInputProperties(msrest.serialization.Model):
    """Update appliance for protected item input properties.

    All required parameters must be populated in order to send to Azure.

    :param target_appliance_id: Required. The target appliance Id.
    :type target_appliance_id: str
    :param provider_specific_details: Required. The provider specific input to update replication
     protected item.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateApplianceForReplicationProtectedItemProviderSpecificInput
    """

    _validation = {
        'target_appliance_id': {'required': True},
        'provider_specific_details': {'required': True},
    }

    _attribute_map = {
        'target_appliance_id': {'key': 'targetApplianceId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'UpdateApplianceForReplicationProtectedItemProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        target_appliance_id: str,
        provider_specific_details: "UpdateApplianceForReplicationProtectedItemProviderSpecificInput",
        **kwargs
    ):
        super(UpdateApplianceForReplicationProtectedItemInputProperties, self).__init__(**kwargs)
        self.target_appliance_id = target_appliance_id
        self.provider_specific_details = provider_specific_details


class UpdateDiskInput(msrest.serialization.Model):
    """Disk input for update.

    All required parameters must be populated in order to send to Azure.

    :param disk_id: Required. The disk Id.
    :type disk_id: str
    :param target_disk_name: The target disk name.
    :type target_disk_name: str
    """

    _validation = {
        'disk_id': {'required': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'target_disk_name': {'key': 'targetDiskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        target_disk_name: Optional[str] = None,
        **kwargs
    ):
        super(UpdateDiskInput, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.target_disk_name = target_disk_name


class UpdateMigrationItemInput(msrest.serialization.Model):
    """Update migration item input.

    :param properties: Update migration item input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateMigrationItemInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdateMigrationItemInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["UpdateMigrationItemInputProperties"] = None,
        **kwargs
    ):
        super(UpdateMigrationItemInput, self).__init__(**kwargs)
        self.properties = properties


class UpdateMigrationItemInputProperties(msrest.serialization.Model):
    """Update migration item input properties.

    All required parameters must be populated in order to send to Azure.

    :param provider_specific_details: Required. The provider specific input to update migration
     item.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateMigrationItemProviderSpecificInput
    """

    _validation = {
        'provider_specific_details': {'required': True},
    }

    _attribute_map = {
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'UpdateMigrationItemProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_details: "UpdateMigrationItemProviderSpecificInput",
        **kwargs
    ):
        super(UpdateMigrationItemInputProperties, self).__init__(**kwargs)
        self.provider_specific_details = provider_specific_details


class UpdateMigrationItemProviderSpecificInput(msrest.serialization.Model):
    """Update migration item provider specific input.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VMwareCbtUpdateMigrationItemInput.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    _subtype_map = {
        'instance_type': {'VMwareCbt': 'VMwareCbtUpdateMigrationItemInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateMigrationItemProviderSpecificInput, self).__init__(**kwargs)
        self.instance_type = None  # type: Optional[str]


class UpdateMobilityServiceRequest(msrest.serialization.Model):
    """Request to update the mobility service on a protected item.

    :param properties: The properties of the update mobility service request.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateMobilityServiceRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdateMobilityServiceRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["UpdateMobilityServiceRequestProperties"] = None,
        **kwargs
    ):
        super(UpdateMobilityServiceRequest, self).__init__(**kwargs)
        self.properties = properties


class UpdateMobilityServiceRequestProperties(msrest.serialization.Model):
    """The properties of an update mobility service request.

    :param run_as_account_id: The CS run as account Id.
    :type run_as_account_id: str
    """

    _attribute_map = {
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        run_as_account_id: Optional[str] = None,
        **kwargs
    ):
        super(UpdateMobilityServiceRequestProperties, self).__init__(**kwargs)
        self.run_as_account_id = run_as_account_id


class UpdateNetworkMappingInput(msrest.serialization.Model):
    """Update network mapping input.

    :param properties: The input properties needed to update network mapping.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateNetworkMappingInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdateNetworkMappingInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["UpdateNetworkMappingInputProperties"] = None,
        **kwargs
    ):
        super(UpdateNetworkMappingInput, self).__init__(**kwargs)
        self.properties = properties


class UpdateNetworkMappingInputProperties(msrest.serialization.Model):
    """Common input details for network mapping operation.

    :param recovery_fabric_name: Recovery fabric name.
    :type recovery_fabric_name: str
    :param recovery_network_id: Recovery network Id.
    :type recovery_network_id: str
    :param fabric_specific_details: Fabrics specific input network Id.
    :type fabric_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.FabricSpecificUpdateNetworkMappingInput
    """

    _attribute_map = {
        'recovery_fabric_name': {'key': 'recoveryFabricName', 'type': 'str'},
        'recovery_network_id': {'key': 'recoveryNetworkId', 'type': 'str'},
        'fabric_specific_details': {'key': 'fabricSpecificDetails', 'type': 'FabricSpecificUpdateNetworkMappingInput'},
    }

    def __init__(
        self,
        *,
        recovery_fabric_name: Optional[str] = None,
        recovery_network_id: Optional[str] = None,
        fabric_specific_details: Optional["FabricSpecificUpdateNetworkMappingInput"] = None,
        **kwargs
    ):
        super(UpdateNetworkMappingInputProperties, self).__init__(**kwargs)
        self.recovery_fabric_name = recovery_fabric_name
        self.recovery_network_id = recovery_network_id
        self.fabric_specific_details = fabric_specific_details


class UpdatePolicyInput(msrest.serialization.Model):
    """Update policy input.

    :param properties: The ReplicationProviderSettings.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.UpdatePolicyInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdatePolicyInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["UpdatePolicyInputProperties"] = None,
        **kwargs
    ):
        super(UpdatePolicyInput, self).__init__(**kwargs)
        self.properties = properties


class UpdatePolicyInputProperties(msrest.serialization.Model):
    """Policy update properties.

    :param replication_provider_settings: The ReplicationProviderSettings.
    :type replication_provider_settings:
     ~azure.mgmt.recoveryservicessiterecovery.models.PolicyProviderSpecificInput
    """

    _attribute_map = {
        'replication_provider_settings': {'key': 'replicationProviderSettings', 'type': 'PolicyProviderSpecificInput'},
    }

    def __init__(
        self,
        *,
        replication_provider_settings: Optional["PolicyProviderSpecificInput"] = None,
        **kwargs
    ):
        super(UpdatePolicyInputProperties, self).__init__(**kwargs)
        self.replication_provider_settings = replication_provider_settings


class UpdateProtectionContainerMappingInput(msrest.serialization.Model):
    """Container pairing update input.

    :param properties: Update protection container mapping input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateProtectionContainerMappingInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdateProtectionContainerMappingInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["UpdateProtectionContainerMappingInputProperties"] = None,
        **kwargs
    ):
        super(UpdateProtectionContainerMappingInput, self).__init__(**kwargs)
        self.properties = properties


class UpdateProtectionContainerMappingInputProperties(msrest.serialization.Model):
    """Container pairing update input.

    :param provider_specific_input: Provider specific input for updating protection container
     mapping.
    :type provider_specific_input:
     ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProviderSpecificUpdateContainerMappingInput
    """

    _attribute_map = {
        'provider_specific_input': {'key': 'providerSpecificInput', 'type': 'ReplicationProviderSpecificUpdateContainerMappingInput'},
    }

    def __init__(
        self,
        *,
        provider_specific_input: Optional["ReplicationProviderSpecificUpdateContainerMappingInput"] = None,
        **kwargs
    ):
        super(UpdateProtectionContainerMappingInputProperties, self).__init__(**kwargs)
        self.provider_specific_input = provider_specific_input


class UpdateRecoveryPlanInput(msrest.serialization.Model):
    """Update recovery plan input class.

    :param properties: Recovery plan update properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateRecoveryPlanInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdateRecoveryPlanInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["UpdateRecoveryPlanInputProperties"] = None,
        **kwargs
    ):
        super(UpdateRecoveryPlanInput, self).__init__(**kwargs)
        self.properties = properties


class UpdateRecoveryPlanInputProperties(msrest.serialization.Model):
    """Recovery plan update properties.

    :param groups: The recovery plan groups.
    :type groups: list[~azure.mgmt.recoveryservicessiterecovery.models.RecoveryPlanGroup]
    """

    _attribute_map = {
        'groups': {'key': 'groups', 'type': '[RecoveryPlanGroup]'},
    }

    def __init__(
        self,
        *,
        groups: Optional[List["RecoveryPlanGroup"]] = None,
        **kwargs
    ):
        super(UpdateRecoveryPlanInputProperties, self).__init__(**kwargs)
        self.groups = groups


class UpdateReplicationProtectedItemInput(msrest.serialization.Model):
    """Update replication protected item input.

    :param properties: Update replication protected item properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateReplicationProtectedItemInputProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdateReplicationProtectedItemInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["UpdateReplicationProtectedItemInputProperties"] = None,
        **kwargs
    ):
        super(UpdateReplicationProtectedItemInput, self).__init__(**kwargs)
        self.properties = properties


class UpdateReplicationProtectedItemInputProperties(msrest.serialization.Model):
    """Update protected item input properties.

    :param recovery_azure_vm_name: Target Azure VM name given by the user.
    :type recovery_azure_vm_name: str
    :param recovery_azure_vm_size: Target Azure VM size.
    :type recovery_azure_vm_size: str
    :param selected_recovery_azure_network_id: Target Azure Network Id.
    :type selected_recovery_azure_network_id: str
    :param selected_tfo_azure_network_id: The Azure Network Id for test failover.
    :type selected_tfo_azure_network_id: str
    :param selected_source_nic_id: The selected source nic Id which will be used as the primary nic
     during failover.
    :type selected_source_nic_id: str
    :param enable_rdp_on_target_option: The selected option to enable RDP\SSH on target vm after
     failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
    :type enable_rdp_on_target_option: str
    :param vm_nics: The list of VM nic details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMNicInputDetails]
    :param license_type: License type. Possible values include: "NotSpecified", "NoLicenseType",
     "WindowsServer".
    :type license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :param recovery_availability_set_id: The target availability set Id.
    :type recovery_availability_set_id: str
    :param provider_specific_details: The provider specific input to update replication protected
     item.
    :type provider_specific_details:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateReplicationProtectedItemProviderInput
    """

    _attribute_map = {
        'recovery_azure_vm_name': {'key': 'recoveryAzureVMName', 'type': 'str'},
        'recovery_azure_vm_size': {'key': 'recoveryAzureVMSize', 'type': 'str'},
        'selected_recovery_azure_network_id': {'key': 'selectedRecoveryAzureNetworkId', 'type': 'str'},
        'selected_tfo_azure_network_id': {'key': 'selectedTfoAzureNetworkId', 'type': 'str'},
        'selected_source_nic_id': {'key': 'selectedSourceNicId', 'type': 'str'},
        'enable_rdp_on_target_option': {'key': 'enableRdpOnTargetOption', 'type': 'str'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMNicInputDetails]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'recovery_availability_set_id': {'key': 'recoveryAvailabilitySetId', 'type': 'str'},
        'provider_specific_details': {'key': 'providerSpecificDetails', 'type': 'UpdateReplicationProtectedItemProviderInput'},
    }

    def __init__(
        self,
        *,
        recovery_azure_vm_name: Optional[str] = None,
        recovery_azure_vm_size: Optional[str] = None,
        selected_recovery_azure_network_id: Optional[str] = None,
        selected_tfo_azure_network_id: Optional[str] = None,
        selected_source_nic_id: Optional[str] = None,
        enable_rdp_on_target_option: Optional[str] = None,
        vm_nics: Optional[List["VMNicInputDetails"]] = None,
        license_type: Optional[Union[str, "LicenseType"]] = None,
        recovery_availability_set_id: Optional[str] = None,
        provider_specific_details: Optional["UpdateReplicationProtectedItemProviderInput"] = None,
        **kwargs
    ):
        super(UpdateReplicationProtectedItemInputProperties, self).__init__(**kwargs)
        self.recovery_azure_vm_name = recovery_azure_vm_name
        self.recovery_azure_vm_size = recovery_azure_vm_size
        self.selected_recovery_azure_network_id = selected_recovery_azure_network_id
        self.selected_tfo_azure_network_id = selected_tfo_azure_network_id
        self.selected_source_nic_id = selected_source_nic_id
        self.enable_rdp_on_target_option = enable_rdp_on_target_option
        self.vm_nics = vm_nics
        self.license_type = license_type
        self.recovery_availability_set_id = recovery_availability_set_id
        self.provider_specific_details = provider_specific_details


class UpdateVCenterRequest(msrest.serialization.Model):
    """Input required to update vCenter.

    :param properties: The update VCenter Request Properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.UpdateVCenterRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpdateVCenterRequestProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["UpdateVCenterRequestProperties"] = None,
        **kwargs
    ):
        super(UpdateVCenterRequest, self).__init__(**kwargs)
        self.properties = properties


class UpdateVCenterRequestProperties(msrest.serialization.Model):
    """The properties of an update vCenter request.

    :param friendly_name: The friendly name of the vCenter.
    :type friendly_name: str
    :param ip_address: The IP address of the vCenter to be discovered.
    :type ip_address: str
    :param process_server_id: The process server Id from where the update can be orchestrated.
    :type process_server_id: str
    :param port: The port number for discovery.
    :type port: str
    :param run_as_account_id: The CS account Id which has privileges to update the vCenter.
    :type run_as_account_id: str
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        ip_address: Optional[str] = None,
        process_server_id: Optional[str] = None,
        port: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        **kwargs
    ):
        super(UpdateVCenterRequestProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.ip_address = ip_address
        self.process_server_id = process_server_id
        self.port = port
        self.run_as_account_id = run_as_account_id


class VaultHealthDetails(Resource):
    """Vault health details definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The vault health related data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.VaultHealthProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'VaultHealthProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["VaultHealthProperties"] = None,
        **kwargs
    ):
        super(VaultHealthDetails, self).__init__(location=location, **kwargs)
        self.properties = properties


class VaultHealthProperties(msrest.serialization.Model):
    """class to define the health summary of the Vault.

    :param vault_errors: The list of errors on the vault.
    :type vault_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    :param protected_items_health: The list of the health detail of the protected items in the
     vault.
    :type protected_items_health:
     ~azure.mgmt.recoveryservicessiterecovery.models.ResourceHealthSummary
    :param fabrics_health: The list of the health detail of the fabrics in the vault.
    :type fabrics_health: ~azure.mgmt.recoveryservicessiterecovery.models.ResourceHealthSummary
    :param containers_health: The list of the health detail of the containers in the vault.
    :type containers_health: ~azure.mgmt.recoveryservicessiterecovery.models.ResourceHealthSummary
    """

    _attribute_map = {
        'vault_errors': {'key': 'vaultErrors', 'type': '[HealthError]'},
        'protected_items_health': {'key': 'protectedItemsHealth', 'type': 'ResourceHealthSummary'},
        'fabrics_health': {'key': 'fabricsHealth', 'type': 'ResourceHealthSummary'},
        'containers_health': {'key': 'containersHealth', 'type': 'ResourceHealthSummary'},
    }

    def __init__(
        self,
        *,
        vault_errors: Optional[List["HealthError"]] = None,
        protected_items_health: Optional["ResourceHealthSummary"] = None,
        fabrics_health: Optional["ResourceHealthSummary"] = None,
        containers_health: Optional["ResourceHealthSummary"] = None,
        **kwargs
    ):
        super(VaultHealthProperties, self).__init__(**kwargs)
        self.vault_errors = vault_errors
        self.protected_items_health = protected_items_health
        self.fabrics_health = fabrics_health
        self.containers_health = containers_health


class VaultSetting(Resource):
    """Vault setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: The vault setting properties.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.VaultSettingProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'VaultSettingProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["VaultSettingProperties"] = None,
        **kwargs
    ):
        super(VaultSetting, self).__init__(location=location, **kwargs)
        self.properties = properties


class VaultSettingCollection(msrest.serialization.Model):
    """Vault setting collection.

    :param value: The list of vault setting.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.VaultSetting]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VaultSetting]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VaultSetting"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VaultSettingCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VaultSettingCreationInput(msrest.serialization.Model):
    """Input to create vault setting.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Vault setting creation input properties.
    :type properties:
     ~azure.mgmt.recoveryservicessiterecovery.models.VaultSettingCreationInputProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'VaultSettingCreationInputProperties'},
    }

    def __init__(
        self,
        *,
        properties: "VaultSettingCreationInputProperties",
        **kwargs
    ):
        super(VaultSettingCreationInput, self).__init__(**kwargs)
        self.properties = properties


class VaultSettingCreationInputProperties(msrest.serialization.Model):
    """Input to create vault setting.

    :param migration_solution_id: The migration solution Id.
    :type migration_solution_id: str
    :param vmware_to_azure_provider_type: VMware to Azure provider type.
    :type vmware_to_azure_provider_type: str
    """

    _attribute_map = {
        'migration_solution_id': {'key': 'migrationSolutionId', 'type': 'str'},
        'vmware_to_azure_provider_type': {'key': 'vmwareToAzureProviderType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        migration_solution_id: Optional[str] = None,
        vmware_to_azure_provider_type: Optional[str] = None,
        **kwargs
    ):
        super(VaultSettingCreationInputProperties, self).__init__(**kwargs)
        self.migration_solution_id = migration_solution_id
        self.vmware_to_azure_provider_type = vmware_to_azure_provider_type


class VaultSettingProperties(msrest.serialization.Model):
    """Vault setting properties.

    :param migration_solution_id: The migration solution ARM Id.
    :type migration_solution_id: str
    :param vmware_to_azure_provider_type: VMware to Azure provider type.
    :type vmware_to_azure_provider_type: str
    """

    _attribute_map = {
        'migration_solution_id': {'key': 'migrationSolutionId', 'type': 'str'},
        'vmware_to_azure_provider_type': {'key': 'vmwareToAzureProviderType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        migration_solution_id: Optional[str] = None,
        vmware_to_azure_provider_type: Optional[str] = None,
        **kwargs
    ):
        super(VaultSettingProperties, self).__init__(**kwargs)
        self.migration_solution_id = migration_solution_id
        self.vmware_to_azure_provider_type = vmware_to_azure_provider_type


class VCenter(Resource):
    """vCenter definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :param location: Resource Location.
    :type location: str
    :param properties: VCenter related data.
    :type properties: ~azure.mgmt.recoveryservicessiterecovery.models.VCenterProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'VCenterProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["VCenterProperties"] = None,
        **kwargs
    ):
        super(VCenter, self).__init__(location=location, **kwargs)
        self.properties = properties


class VCenterCollection(msrest.serialization.Model):
    """Collection of vCenter details.

    :param value: The vCenter details.
    :type value: list[~azure.mgmt.recoveryservicessiterecovery.models.VCenter]
    :param next_link: The value of next link.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VCenter]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VCenter"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VCenterCollection, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VCenterProperties(msrest.serialization.Model):
    """vCenter properties.

    :param friendly_name: Friendly name of the vCenter.
    :type friendly_name: str
    :param internal_id: VCenter internal ID.
    :type internal_id: str
    :param last_heartbeat: The time when the last heartbeat was received by vCenter.
    :type last_heartbeat: ~datetime.datetime
    :param discovery_status: The VCenter discovery status.
    :type discovery_status: str
    :param process_server_id: The process server Id.
    :type process_server_id: str
    :param ip_address: The IP address of the vCenter.
    :type ip_address: str
    :param infrastructure_id: The infrastructure Id of vCenter.
    :type infrastructure_id: str
    :param port: The port number for discovery.
    :type port: str
    :param run_as_account_id: The account Id which has privileges to discover the vCenter.
    :type run_as_account_id: str
    :param fabric_arm_resource_name: The ARM resource name of the fabric containing this VCenter.
    :type fabric_arm_resource_name: str
    :param health_errors: The health errors for this VCenter.
    :type health_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'internal_id': {'key': 'internalId', 'type': 'str'},
        'last_heartbeat': {'key': 'lastHeartbeat', 'type': 'iso-8601'},
        'discovery_status': {'key': 'discoveryStatus', 'type': 'str'},
        'process_server_id': {'key': 'processServerId', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'infrastructure_id': {'key': 'infrastructureId', 'type': 'str'},
        'port': {'key': 'port', 'type': 'str'},
        'run_as_account_id': {'key': 'runAsAccountId', 'type': 'str'},
        'fabric_arm_resource_name': {'key': 'fabricArmResourceName', 'type': 'str'},
        'health_errors': {'key': 'healthErrors', 'type': '[HealthError]'},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        internal_id: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        discovery_status: Optional[str] = None,
        process_server_id: Optional[str] = None,
        ip_address: Optional[str] = None,
        infrastructure_id: Optional[str] = None,
        port: Optional[str] = None,
        run_as_account_id: Optional[str] = None,
        fabric_arm_resource_name: Optional[str] = None,
        health_errors: Optional[List["HealthError"]] = None,
        **kwargs
    ):
        super(VCenterProperties, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.internal_id = internal_id
        self.last_heartbeat = last_heartbeat
        self.discovery_status = discovery_status
        self.process_server_id = process_server_id
        self.ip_address = ip_address
        self.infrastructure_id = infrastructure_id
        self.port = port
        self.run_as_account_id = run_as_account_id
        self.fabric_arm_resource_name = fabric_arm_resource_name
        self.health_errors = health_errors


class VersionDetails(msrest.serialization.Model):
    """Version related details.

    :param version: The agent version.
    :type version: str
    :param expiry_date: Version expiry date.
    :type expiry_date: ~datetime.datetime
    :param status: A value indicating whether security update required. Possible values include:
     "Supported", "NotSupported", "Deprecated", "UpdateRequired", "SecurityUpdateRequired".
    :type status: str or ~azure.mgmt.recoveryservicessiterecovery.models.AgentVersionStatus
    """

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'expiry_date': {'key': 'expiryDate', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        expiry_date: Optional[datetime.datetime] = None,
        status: Optional[Union[str, "AgentVersionStatus"]] = None,
        **kwargs
    ):
        super(VersionDetails, self).__init__(**kwargs)
        self.version = version
        self.expiry_date = expiry_date
        self.status = status


class VirtualMachineTaskDetails(JobTaskDetails):
    """This class represents the virtual machine task details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param job_task: The job entity.
    :type job_task: ~azure.mgmt.recoveryservicessiterecovery.models.JobEntity
    :param skipped_reason: The skipped reason.
    :type skipped_reason: str
    :param skipped_reason_string: The skipped reason string.
    :type skipped_reason_string: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'job_task': {'key': 'jobTask', 'type': 'JobEntity'},
        'skipped_reason': {'key': 'skippedReason', 'type': 'str'},
        'skipped_reason_string': {'key': 'skippedReasonString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        job_task: Optional["JobEntity"] = None,
        skipped_reason: Optional[str] = None,
        skipped_reason_string: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineTaskDetails, self).__init__(job_task=job_task, **kwargs)
        self.instance_type = 'VirtualMachineTaskDetails'  # type: str
        self.skipped_reason = skipped_reason
        self.skipped_reason_string = skipped_reason_string


class VmmDetails(FabricSpecificDetails):
    """VMM fabric specific details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmmDetails, self).__init__(**kwargs)
        self.instance_type = 'VMM'  # type: str


class VmmToAzureCreateNetworkMappingInput(FabricSpecificCreateNetworkMappingInput):
    """Create network mappings input properties/behavior specific to Vmm to Azure Network mapping.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmmToAzureCreateNetworkMappingInput, self).__init__(**kwargs)
        self.instance_type = 'VmmToAzure'  # type: str


class VmmToAzureNetworkMappingSettings(NetworkMappingFabricSpecificSettings):
    """E2A Network Mapping fabric specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmmToAzureNetworkMappingSettings, self).__init__(**kwargs)
        self.instance_type = 'VmmToAzure'  # type: str


class VmmToAzureUpdateNetworkMappingInput(FabricSpecificUpdateNetworkMappingInput):
    """Update network mappings input properties/behavior specific to vmm to azure.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmmToAzureUpdateNetworkMappingInput, self).__init__(**kwargs)
        self.instance_type = 'VmmToAzure'  # type: str


class VmmToVmmCreateNetworkMappingInput(FabricSpecificCreateNetworkMappingInput):
    """Create network mappings input properties/behavior specific to vmm to vmm Network mapping.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmmToVmmCreateNetworkMappingInput, self).__init__(**kwargs)
        self.instance_type = 'VmmToVmm'  # type: str


class VmmToVmmNetworkMappingSettings(NetworkMappingFabricSpecificSettings):
    """E2E Network Mapping fabric specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the Instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmmToVmmNetworkMappingSettings, self).__init__(**kwargs)
        self.instance_type = 'VmmToVmm'  # type: str


class VmmToVmmUpdateNetworkMappingInput(FabricSpecificUpdateNetworkMappingInput):
    """Update network mappings input properties/behavior specific to vmm to vmm.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The instance type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VmmToVmmUpdateNetworkMappingInput, self).__init__(**kwargs)
        self.instance_type = 'VmmToVmm'  # type: str


class VmmVirtualMachineDetails(HyperVVirtualMachineDetails):
    """VMM fabric provider specific VM settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param source_item_id: The source id of the object.
    :type source_item_id: str
    :param generation: The id of the object in fabric.
    :type generation: str
    :param os_details: The Last replication time.
    :type os_details: ~azure.mgmt.recoveryservicessiterecovery.models.OSDetails
    :param disk_details: The Last successful failover time.
    :type disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.DiskDetails]
    :param has_physical_disk: A value indicating whether the VM has a physical disk attached.
     String value of SrsDataContract.PresenceStatus enum. Possible values include: "Unknown",
     "Present", "NotPresent".
    :type has_physical_disk: str or ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    :param has_fibre_channel_adapter: A value indicating whether the VM has a fibre channel adapter
     attached. String value of SrsDataContract.PresenceStatus enum. Possible values include:
     "Unknown", "Present", "NotPresent".
    :type has_fibre_channel_adapter: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    :param has_shared_vhd: A value indicating whether the VM has a shared VHD attached. String
     value of SrsDataContract.PresenceStatus enum. Possible values include: "Unknown", "Present",
     "NotPresent".
    :type has_shared_vhd: str or ~azure.mgmt.recoveryservicessiterecovery.models.PresenceStatus
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'source_item_id': {'key': 'sourceItemId', 'type': 'str'},
        'generation': {'key': 'generation', 'type': 'str'},
        'os_details': {'key': 'osDetails', 'type': 'OSDetails'},
        'disk_details': {'key': 'diskDetails', 'type': '[DiskDetails]'},
        'has_physical_disk': {'key': 'hasPhysicalDisk', 'type': 'str'},
        'has_fibre_channel_adapter': {'key': 'hasFibreChannelAdapter', 'type': 'str'},
        'has_shared_vhd': {'key': 'hasSharedVhd', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_item_id: Optional[str] = None,
        generation: Optional[str] = None,
        os_details: Optional["OSDetails"] = None,
        disk_details: Optional[List["DiskDetails"]] = None,
        has_physical_disk: Optional[Union[str, "PresenceStatus"]] = None,
        has_fibre_channel_adapter: Optional[Union[str, "PresenceStatus"]] = None,
        has_shared_vhd: Optional[Union[str, "PresenceStatus"]] = None,
        **kwargs
    ):
        super(VmmVirtualMachineDetails, self).__init__(source_item_id=source_item_id, generation=generation, os_details=os_details, disk_details=disk_details, has_physical_disk=has_physical_disk, has_fibre_channel_adapter=has_fibre_channel_adapter, has_shared_vhd=has_shared_vhd, **kwargs)
        self.instance_type = 'VmmVirtualMachine'  # type: str


class VMNicDetails(msrest.serialization.Model):
    """Hyper V VM network details.

    :param nic_id: The nic Id.
    :type nic_id: str
    :param replica_nic_id: The replica nic Id.
    :type replica_nic_id: str
    :param source_nic_arm_id: The source nic ARM Id.
    :type source_nic_arm_id: str
    :param v_m_network_name: VM network name.
    :type v_m_network_name: str
    :param recovery_vm_network_id: Recovery VM network Id.
    :type recovery_vm_network_id: str
    :param ip_configs: The IP configurations of the NIC.
    :type ip_configs: list[~azure.mgmt.recoveryservicessiterecovery.models.IPConfigDetails]
    :param selection_type: Selection type for failover.
    :type selection_type: str
    :param recovery_network_security_group_id: The id of the NSG associated with the NIC.
    :type recovery_network_security_group_id: str
    :param enable_accelerated_networking_on_recovery: A value indicating whether the NIC has
     accelerated networking enabled.
    :type enable_accelerated_networking_on_recovery: bool
    :param tfo_vm_network_id: The network to be used by NIC during test failover.
    :type tfo_vm_network_id: str
    :param tfo_network_security_group_id: The NSG to be used by NIC during test failover.
    :type tfo_network_security_group_id: str
    :param enable_accelerated_networking_on_tfo: Whether the TFO NIC has accelerated networking
     enabled.
    :type enable_accelerated_networking_on_tfo: bool
    :param recovery_nic_name: The name of the NIC to be used when creating target NICs.
    :type recovery_nic_name: str
    :param recovery_nic_resource_group_name: The resource group of the NIC to be used when creating
     target NICs.
    :type recovery_nic_resource_group_name: str
    :param reuse_existing_nic: A value indicating whether an existing NIC is allowed to be reused
     during failover subject to availability.
    :type reuse_existing_nic: bool
    :param tfo_recovery_nic_name: The name of the NIC to be used when creating target NICs in TFO.
    :type tfo_recovery_nic_name: str
    :param tfo_recovery_nic_resource_group_name: The resource group of the NIC to be used when
     creating target NICs in TFO.
    :type tfo_recovery_nic_resource_group_name: str
    :param tfo_reuse_existing_nic: A value indicating whether an existing NIC is allowed to be
     reused during test failover subject to availability.
    :type tfo_reuse_existing_nic: bool
    :param target_nic_name: Target NIC name.
    :type target_nic_name: str
    """

    _attribute_map = {
        'nic_id': {'key': 'nicId', 'type': 'str'},
        'replica_nic_id': {'key': 'replicaNicId', 'type': 'str'},
        'source_nic_arm_id': {'key': 'sourceNicArmId', 'type': 'str'},
        'v_m_network_name': {'key': 'vMNetworkName', 'type': 'str'},
        'recovery_vm_network_id': {'key': 'recoveryVMNetworkId', 'type': 'str'},
        'ip_configs': {'key': 'ipConfigs', 'type': '[IPConfigDetails]'},
        'selection_type': {'key': 'selectionType', 'type': 'str'},
        'recovery_network_security_group_id': {'key': 'recoveryNetworkSecurityGroupId', 'type': 'str'},
        'enable_accelerated_networking_on_recovery': {'key': 'enableAcceleratedNetworkingOnRecovery', 'type': 'bool'},
        'tfo_vm_network_id': {'key': 'tfoVMNetworkId', 'type': 'str'},
        'tfo_network_security_group_id': {'key': 'tfoNetworkSecurityGroupId', 'type': 'str'},
        'enable_accelerated_networking_on_tfo': {'key': 'enableAcceleratedNetworkingOnTfo', 'type': 'bool'},
        'recovery_nic_name': {'key': 'recoveryNicName', 'type': 'str'},
        'recovery_nic_resource_group_name': {'key': 'recoveryNicResourceGroupName', 'type': 'str'},
        'reuse_existing_nic': {'key': 'reuseExistingNic', 'type': 'bool'},
        'tfo_recovery_nic_name': {'key': 'tfoRecoveryNicName', 'type': 'str'},
        'tfo_recovery_nic_resource_group_name': {'key': 'tfoRecoveryNicResourceGroupName', 'type': 'str'},
        'tfo_reuse_existing_nic': {'key': 'tfoReuseExistingNic', 'type': 'bool'},
        'target_nic_name': {'key': 'targetNicName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        nic_id: Optional[str] = None,
        replica_nic_id: Optional[str] = None,
        source_nic_arm_id: Optional[str] = None,
        v_m_network_name: Optional[str] = None,
        recovery_vm_network_id: Optional[str] = None,
        ip_configs: Optional[List["IPConfigDetails"]] = None,
        selection_type: Optional[str] = None,
        recovery_network_security_group_id: Optional[str] = None,
        enable_accelerated_networking_on_recovery: Optional[bool] = None,
        tfo_vm_network_id: Optional[str] = None,
        tfo_network_security_group_id: Optional[str] = None,
        enable_accelerated_networking_on_tfo: Optional[bool] = None,
        recovery_nic_name: Optional[str] = None,
        recovery_nic_resource_group_name: Optional[str] = None,
        reuse_existing_nic: Optional[bool] = False,
        tfo_recovery_nic_name: Optional[str] = None,
        tfo_recovery_nic_resource_group_name: Optional[str] = None,
        tfo_reuse_existing_nic: Optional[bool] = False,
        target_nic_name: Optional[str] = None,
        **kwargs
    ):
        super(VMNicDetails, self).__init__(**kwargs)
        self.nic_id = nic_id
        self.replica_nic_id = replica_nic_id
        self.source_nic_arm_id = source_nic_arm_id
        self.v_m_network_name = v_m_network_name
        self.recovery_vm_network_id = recovery_vm_network_id
        self.ip_configs = ip_configs
        self.selection_type = selection_type
        self.recovery_network_security_group_id = recovery_network_security_group_id
        self.enable_accelerated_networking_on_recovery = enable_accelerated_networking_on_recovery
        self.tfo_vm_network_id = tfo_vm_network_id
        self.tfo_network_security_group_id = tfo_network_security_group_id
        self.enable_accelerated_networking_on_tfo = enable_accelerated_networking_on_tfo
        self.recovery_nic_name = recovery_nic_name
        self.recovery_nic_resource_group_name = recovery_nic_resource_group_name
        self.reuse_existing_nic = reuse_existing_nic
        self.tfo_recovery_nic_name = tfo_recovery_nic_name
        self.tfo_recovery_nic_resource_group_name = tfo_recovery_nic_resource_group_name
        self.tfo_reuse_existing_nic = tfo_reuse_existing_nic
        self.target_nic_name = target_nic_name


class VMNicInputDetails(msrest.serialization.Model):
    """Hyper V VM network input details.

    :param nic_id: The nic Id.
    :type nic_id: str
    :param ip_configs: The IP configurations to be used by NIC during test failover and failover.
    :type ip_configs: list[~azure.mgmt.recoveryservicessiterecovery.models.IPConfigInputDetails]
    :param selection_type: Selection type for failover.
    :type selection_type: str
    :param recovery_network_security_group_id: The id of the NSG associated with the NIC.
    :type recovery_network_security_group_id: str
    :param enable_accelerated_networking_on_recovery: Whether the NIC has accelerated networking
     enabled.
    :type enable_accelerated_networking_on_recovery: bool
    :param tfo_network_security_group_id: The NSG to be used by NIC during test failover.
    :type tfo_network_security_group_id: str
    :param enable_accelerated_networking_on_tfo: Whether the test NIC has accelerated networking
     enabled.
    :type enable_accelerated_networking_on_tfo: bool
    :param recovery_nic_name: The name of the NIC to be used when creating target NICs.
    :type recovery_nic_name: str
    :param recovery_nic_resource_group_name: The resource group of the NIC to be used when creating
     target NICs.
    :type recovery_nic_resource_group_name: str
    :param reuse_existing_nic: A value indicating whether an existing NIC is allowed to be reused
     during failover subject to availability.
    :type reuse_existing_nic: bool
    :param tfo_nic_name: The name of the NIC to be used when creating target NICs in TFO.
    :type tfo_nic_name: str
    :param tfo_nic_resource_group_name: The resource group of the NIC to be used when creating
     target NICs in TFO.
    :type tfo_nic_resource_group_name: str
    :param tfo_reuse_existing_nic: A value indicating whether an existing NIC is allowed to be
     reused during test failover subject to availability.
    :type tfo_reuse_existing_nic: bool
    :param target_nic_name: Target NIC name.
    :type target_nic_name: str
    """

    _attribute_map = {
        'nic_id': {'key': 'nicId', 'type': 'str'},
        'ip_configs': {'key': 'ipConfigs', 'type': '[IPConfigInputDetails]'},
        'selection_type': {'key': 'selectionType', 'type': 'str'},
        'recovery_network_security_group_id': {'key': 'recoveryNetworkSecurityGroupId', 'type': 'str'},
        'enable_accelerated_networking_on_recovery': {'key': 'enableAcceleratedNetworkingOnRecovery', 'type': 'bool'},
        'tfo_network_security_group_id': {'key': 'tfoNetworkSecurityGroupId', 'type': 'str'},
        'enable_accelerated_networking_on_tfo': {'key': 'enableAcceleratedNetworkingOnTfo', 'type': 'bool'},
        'recovery_nic_name': {'key': 'recoveryNicName', 'type': 'str'},
        'recovery_nic_resource_group_name': {'key': 'recoveryNicResourceGroupName', 'type': 'str'},
        'reuse_existing_nic': {'key': 'reuseExistingNic', 'type': 'bool'},
        'tfo_nic_name': {'key': 'tfoNicName', 'type': 'str'},
        'tfo_nic_resource_group_name': {'key': 'tfoNicResourceGroupName', 'type': 'str'},
        'tfo_reuse_existing_nic': {'key': 'tfoReuseExistingNic', 'type': 'bool'},
        'target_nic_name': {'key': 'targetNicName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        nic_id: Optional[str] = None,
        ip_configs: Optional[List["IPConfigInputDetails"]] = None,
        selection_type: Optional[str] = None,
        recovery_network_security_group_id: Optional[str] = None,
        enable_accelerated_networking_on_recovery: Optional[bool] = None,
        tfo_network_security_group_id: Optional[str] = None,
        enable_accelerated_networking_on_tfo: Optional[bool] = None,
        recovery_nic_name: Optional[str] = None,
        recovery_nic_resource_group_name: Optional[str] = None,
        reuse_existing_nic: Optional[bool] = None,
        tfo_nic_name: Optional[str] = None,
        tfo_nic_resource_group_name: Optional[str] = None,
        tfo_reuse_existing_nic: Optional[bool] = None,
        target_nic_name: Optional[str] = None,
        **kwargs
    ):
        super(VMNicInputDetails, self).__init__(**kwargs)
        self.nic_id = nic_id
        self.ip_configs = ip_configs
        self.selection_type = selection_type
        self.recovery_network_security_group_id = recovery_network_security_group_id
        self.enable_accelerated_networking_on_recovery = enable_accelerated_networking_on_recovery
        self.tfo_network_security_group_id = tfo_network_security_group_id
        self.enable_accelerated_networking_on_tfo = enable_accelerated_networking_on_tfo
        self.recovery_nic_name = recovery_nic_name
        self.recovery_nic_resource_group_name = recovery_nic_resource_group_name
        self.reuse_existing_nic = reuse_existing_nic
        self.tfo_nic_name = tfo_nic_name
        self.tfo_nic_resource_group_name = tfo_nic_resource_group_name
        self.tfo_reuse_existing_nic = tfo_reuse_existing_nic
        self.target_nic_name = target_nic_name


class VmNicUpdatesTaskDetails(TaskTypeDetails):
    """This class represents the vm NicUpdates task details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The type of task details.Constant filled by server.
    :type instance_type: str
    :param vm_id: Virtual machine Id.
    :type vm_id: str
    :param nic_id: Nic Id.
    :type nic_id: str
    :param name: Name of the Nic.
    :type name: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'nic_id': {'key': 'nicId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vm_id: Optional[str] = None,
        nic_id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(VmNicUpdatesTaskDetails, self).__init__(**kwargs)
        self.instance_type = 'VmNicUpdatesTaskDetails'  # type: str
        self.vm_id = vm_id
        self.nic_id = nic_id
        self.name = name


class VMwareCbtContainerCreationInput(ReplicationProviderSpecificContainerCreationInput):
    """VMwareCbt container creation input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VMwareCbtContainerCreationInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str


class VMwareCbtContainerMappingInput(ReplicationProviderSpecificContainerMappingInput):
    """VMwareCbt container mapping input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param key_vault_id: Required. The target key vault ARM Id.
    :type key_vault_id: str
    :param key_vault_uri: Required. The target key vault URL.
    :type key_vault_uri: str
    :param storage_account_id: Required. The storage account ARM Id.
    :type storage_account_id: str
    :param storage_account_sas_secret_name: Required. The secret name of the storage account.
    :type storage_account_sas_secret_name: str
    :param service_bus_connection_string_secret_name: Required. The secret name of the service bus
     connection string.
    :type service_bus_connection_string_secret_name: str
    :param target_location: Required. The target location.
    :type target_location: str
    """

    _validation = {
        'instance_type': {'required': True},
        'key_vault_id': {'required': True},
        'key_vault_uri': {'required': True},
        'storage_account_id': {'required': True},
        'storage_account_sas_secret_name': {'required': True},
        'service_bus_connection_string_secret_name': {'required': True},
        'target_location': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'storage_account_sas_secret_name': {'key': 'storageAccountSasSecretName', 'type': 'str'},
        'service_bus_connection_string_secret_name': {'key': 'serviceBusConnectionStringSecretName', 'type': 'str'},
        'target_location': {'key': 'targetLocation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_id: str,
        key_vault_uri: str,
        storage_account_id: str,
        storage_account_sas_secret_name: str,
        service_bus_connection_string_secret_name: str,
        target_location: str,
        **kwargs
    ):
        super(VMwareCbtContainerMappingInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.key_vault_id = key_vault_id
        self.key_vault_uri = key_vault_uri
        self.storage_account_id = storage_account_id
        self.storage_account_sas_secret_name = storage_account_sas_secret_name
        self.service_bus_connection_string_secret_name = service_bus_connection_string_secret_name
        self.target_location = target_location


class VMwareCbtDiskInput(msrest.serialization.Model):
    """VMwareCbt disk input.

    All required parameters must be populated in order to send to Azure.

    :param disk_id: Required. The disk Id.
    :type disk_id: str
    :param disk_type: The disk type. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :param is_os_disk: Required. A value indicating whether the disk is the OS disk.
    :type is_os_disk: str
    :param log_storage_account_id: Required. The log storage account ARM Id.
    :type log_storage_account_id: str
    :param log_storage_account_sas_secret_name: Required. The key vault secret name of the log
     storage account.
    :type log_storage_account_sas_secret_name: str
    :param disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :type disk_encryption_set_id: str
    """

    _validation = {
        'disk_id': {'required': True},
        'is_os_disk': {'required': True},
        'log_storage_account_id': {'required': True},
        'log_storage_account_sas_secret_name': {'required': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'is_os_disk': {'key': 'isOSDisk', 'type': 'str'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'log_storage_account_sas_secret_name': {'key': 'logStorageAccountSasSecretName', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        is_os_disk: str,
        log_storage_account_id: str,
        log_storage_account_sas_secret_name: str,
        disk_type: Optional[Union[str, "DiskAccountType"]] = None,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(VMwareCbtDiskInput, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.disk_type = disk_type
        self.is_os_disk = is_os_disk
        self.log_storage_account_id = log_storage_account_id
        self.log_storage_account_sas_secret_name = log_storage_account_sas_secret_name
        self.disk_encryption_set_id = disk_encryption_set_id


class VMwareCbtEnableMigrationInput(EnableMigrationProviderSpecificInput):
    """VMwareCbt specific enable migration input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param vmware_machine_id: Required. The ARM Id of the VM discovered in VMware.
    :type vmware_machine_id: str
    :param disks_to_include: Required. The disks to include list.
    :type disks_to_include:
     list[~azure.mgmt.recoveryservicessiterecovery.models.VMwareCbtDiskInput]
    :param license_type: License type. Possible values include: "NotSpecified", "NoLicenseType",
     "WindowsServer".
    :type license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :param sql_server_license_type: The SQL Server license type. Possible values include:
     "NotSpecified", "NoLicenseType", "PAYG", "AHUB".
    :type sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :param data_mover_run_as_account_id: Required. The data mover run as account Id.
    :type data_mover_run_as_account_id: str
    :param snapshot_run_as_account_id: Required. The snapshot run as account Id.
    :type snapshot_run_as_account_id: str
    :param target_vm_name: The target VM name.
    :type target_vm_name: str
    :param target_vm_size: The target VM size.
    :type target_vm_size: str
    :param target_resource_group_id: Required. The target resource group ARM Id.
    :type target_resource_group_id: str
    :param target_network_id: Required. The target network ARM Id.
    :type target_network_id: str
    :param target_subnet_name: The target subnet name.
    :type target_subnet_name: str
    :param target_availability_set_id: The target availability set ARM Id.
    :type target_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The target proximity placement group ARM Id.
    :type target_proximity_placement_group_id: str
    :param target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :type target_boot_diagnostics_storage_account_id: str
    :param perform_auto_resync: A value indicating whether auto resync is to be done.
    :type perform_auto_resync: str
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param seed_disk_tags: The tags for the seed disks.
    :type seed_disk_tags: dict[str, str]
    :param target_disk_tags: The tags for the target disks.
    :type target_disk_tags: dict[str, str]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    """

    _validation = {
        'instance_type': {'required': True},
        'vmware_machine_id': {'required': True},
        'disks_to_include': {'required': True},
        'data_mover_run_as_account_id': {'required': True},
        'snapshot_run_as_account_id': {'required': True},
        'target_resource_group_id': {'required': True},
        'target_network_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vmware_machine_id': {'key': 'vmwareMachineId', 'type': 'str'},
        'disks_to_include': {'key': 'disksToInclude', 'type': '[VMwareCbtDiskInput]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'data_mover_run_as_account_id': {'key': 'dataMoverRunAsAccountId', 'type': 'str'},
        'snapshot_run_as_account_id': {'key': 'snapshotRunAsAccountId', 'type': 'str'},
        'target_vm_name': {'key': 'targetVmName', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'target_network_id': {'key': 'targetNetworkId', 'type': 'str'},
        'target_subnet_name': {'key': 'targetSubnetName', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'target_boot_diagnostics_storage_account_id': {'key': 'targetBootDiagnosticsStorageAccountId', 'type': 'str'},
        'perform_auto_resync': {'key': 'performAutoResync', 'type': 'str'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'seed_disk_tags': {'key': 'seedDiskTags', 'type': '{str}'},
        'target_disk_tags': {'key': 'targetDiskTags', 'type': '{str}'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        vmware_machine_id: str,
        disks_to_include: List["VMwareCbtDiskInput"],
        data_mover_run_as_account_id: str,
        snapshot_run_as_account_id: str,
        target_resource_group_id: str,
        target_network_id: str,
        license_type: Optional[Union[str, "LicenseType"]] = None,
        sql_server_license_type: Optional[Union[str, "SqlServerLicenseType"]] = None,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        target_subnet_name: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        perform_auto_resync: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        seed_disk_tags: Optional[Dict[str, str]] = None,
        target_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(VMwareCbtEnableMigrationInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.vmware_machine_id = vmware_machine_id
        self.disks_to_include = disks_to_include
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.data_mover_run_as_account_id = data_mover_run_as_account_id
        self.snapshot_run_as_account_id = snapshot_run_as_account_id
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.target_resource_group_id = target_resource_group_id
        self.target_network_id = target_network_id
        self.target_subnet_name = target_subnet_name
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.perform_auto_resync = perform_auto_resync
        self.target_vm_tags = target_vm_tags
        self.seed_disk_tags = seed_disk_tags
        self.target_disk_tags = target_disk_tags
        self.target_nic_tags = target_nic_tags


class VMwareCbtEventDetails(EventProviderSpecificDetails):
    """Event details for VMwareCbt provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :ivar migration_item_name: The migration item name.
    :vartype migration_item_name: str
    """

    _validation = {
        'instance_type': {'required': True},
        'migration_item_name': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'migration_item_name': {'key': 'migrationItemName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VMwareCbtEventDetails, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.migration_item_name = None


class VMwareCbtMigrateInput(MigrateProviderSpecificInput):
    """VMwareCbt specific migrate input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param perform_shutdown: Required. A value indicating whether VM is to be shutdown.
    :type perform_shutdown: str
    """

    _validation = {
        'instance_type': {'required': True},
        'perform_shutdown': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'perform_shutdown': {'key': 'performShutdown', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        perform_shutdown: str,
        **kwargs
    ):
        super(VMwareCbtMigrateInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.perform_shutdown = perform_shutdown


class VMwareCbtMigrationDetails(MigrationProviderSpecificSettings):
    """VMwareCbt provider specific settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the instance type.Constant filled by server.
    :type instance_type: str
    :ivar vmware_machine_id: The ARM Id of the VM discovered in VMware.
    :vartype vmware_machine_id: str
    :ivar os_type: The type of the OS on the VM.
    :vartype os_type: str
    :ivar firmware_type: The firmware type.
    :vartype firmware_type: str
    :ivar target_generation: The target generation.
    :vartype target_generation: str
    :param license_type: License Type of the VM to be used.
    :type license_type: str
    :param sql_server_license_type: The SQL Server license type.
    :type sql_server_license_type: str
    :ivar data_mover_run_as_account_id: The data mover run as account Id.
    :vartype data_mover_run_as_account_id: str
    :ivar snapshot_run_as_account_id: The snapshot run as account Id.
    :vartype snapshot_run_as_account_id: str
    :param target_vm_name: Target VM name.
    :type target_vm_name: str
    :param target_vm_size: The target VM size.
    :type target_vm_size: str
    :ivar target_location: The target location.
    :vartype target_location: str
    :param target_resource_group_id: The target resource group Id.
    :type target_resource_group_id: str
    :param target_availability_set_id: The target availability set Id.
    :type target_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The target proximity placement group Id.
    :type target_proximity_placement_group_id: str
    :param target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :type target_boot_diagnostics_storage_account_id: str
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param protected_disks: The list of protected disks.
    :type protected_disks:
     list[~azure.mgmt.recoveryservicessiterecovery.models.VMwareCbtProtectedDiskDetails]
    :param target_network_id: The target network Id.
    :type target_network_id: str
    :param vm_nics: The network details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMwareCbtNicDetails]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    :ivar migration_recovery_point_id: The recovery point Id to which the VM was migrated.
    :vartype migration_recovery_point_id: str
    :ivar last_recovery_point_received: The last recovery point received time.
    :vartype last_recovery_point_received: ~datetime.datetime
    :ivar last_recovery_point_id: The last recovery point Id.
    :vartype last_recovery_point_id: str
    :ivar initial_seeding_progress_percentage: The initial seeding progress percentage.
    :vartype initial_seeding_progress_percentage: int
    :ivar migration_progress_percentage: The migration progress percentage.
    :vartype migration_progress_percentage: int
    :ivar resync_progress_percentage: The resync progress percentage.
    :vartype resync_progress_percentage: int
    :ivar initial_seeding_retry_count: The initial seeding retry count.
    :vartype initial_seeding_retry_count: long
    :ivar resync_retry_count: The resync retry count.
    :vartype resync_retry_count: long
    :ivar resync_required: A value indicating whether resync is required.
    :vartype resync_required: str
    :ivar resync_state: The resync state. Possible values include: "None",
     "PreparedForResynchronization", "StartedResynchronization".
    :vartype resync_state: str or ~azure.mgmt.recoveryservicessiterecovery.models.ResyncState
    :param perform_auto_resync: A value indicating whether auto resync is to be done.
    :type perform_auto_resync: str
    :param seed_disk_tags: The tags for the seed disks.
    :type seed_disk_tags: dict[str, str]
    :param target_disk_tags: The tags for the target disks.
    :type target_disk_tags: dict[str, str]
    """

    _validation = {
        'instance_type': {'required': True},
        'vmware_machine_id': {'readonly': True},
        'os_type': {'readonly': True},
        'firmware_type': {'readonly': True},
        'target_generation': {'readonly': True},
        'data_mover_run_as_account_id': {'readonly': True},
        'snapshot_run_as_account_id': {'readonly': True},
        'target_location': {'readonly': True},
        'migration_recovery_point_id': {'readonly': True},
        'last_recovery_point_received': {'readonly': True},
        'last_recovery_point_id': {'readonly': True},
        'initial_seeding_progress_percentage': {'readonly': True},
        'migration_progress_percentage': {'readonly': True},
        'resync_progress_percentage': {'readonly': True},
        'initial_seeding_retry_count': {'readonly': True},
        'resync_retry_count': {'readonly': True},
        'resync_required': {'readonly': True},
        'resync_state': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vmware_machine_id': {'key': 'vmwareMachineId', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'firmware_type': {'key': 'firmwareType', 'type': 'str'},
        'target_generation': {'key': 'targetGeneration', 'type': 'str'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'data_mover_run_as_account_id': {'key': 'dataMoverRunAsAccountId', 'type': 'str'},
        'snapshot_run_as_account_id': {'key': 'snapshotRunAsAccountId', 'type': 'str'},
        'target_vm_name': {'key': 'targetVmName', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'target_location': {'key': 'targetLocation', 'type': 'str'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'target_boot_diagnostics_storage_account_id': {'key': 'targetBootDiagnosticsStorageAccountId', 'type': 'str'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'protected_disks': {'key': 'protectedDisks', 'type': '[VMwareCbtProtectedDiskDetails]'},
        'target_network_id': {'key': 'targetNetworkId', 'type': 'str'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMwareCbtNicDetails]'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
        'migration_recovery_point_id': {'key': 'migrationRecoveryPointId', 'type': 'str'},
        'last_recovery_point_received': {'key': 'lastRecoveryPointReceived', 'type': 'iso-8601'},
        'last_recovery_point_id': {'key': 'lastRecoveryPointId', 'type': 'str'},
        'initial_seeding_progress_percentage': {'key': 'initialSeedingProgressPercentage', 'type': 'int'},
        'migration_progress_percentage': {'key': 'migrationProgressPercentage', 'type': 'int'},
        'resync_progress_percentage': {'key': 'resyncProgressPercentage', 'type': 'int'},
        'initial_seeding_retry_count': {'key': 'initialSeedingRetryCount', 'type': 'long'},
        'resync_retry_count': {'key': 'resyncRetryCount', 'type': 'long'},
        'resync_required': {'key': 'resyncRequired', 'type': 'str'},
        'resync_state': {'key': 'resyncState', 'type': 'str'},
        'perform_auto_resync': {'key': 'performAutoResync', 'type': 'str'},
        'seed_disk_tags': {'key': 'seedDiskTags', 'type': '{str}'},
        'target_disk_tags': {'key': 'targetDiskTags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        license_type: Optional[str] = None,
        sql_server_license_type: Optional[str] = None,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        protected_disks: Optional[List["VMwareCbtProtectedDiskDetails"]] = None,
        target_network_id: Optional[str] = None,
        vm_nics: Optional[List["VMwareCbtNicDetails"]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        perform_auto_resync: Optional[str] = None,
        seed_disk_tags: Optional[Dict[str, str]] = None,
        target_disk_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(VMwareCbtMigrationDetails, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.vmware_machine_id = None
        self.os_type = None
        self.firmware_type = None
        self.target_generation = None
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.data_mover_run_as_account_id = None
        self.snapshot_run_as_account_id = None
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.target_location = None
        self.target_resource_group_id = target_resource_group_id
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.target_vm_tags = target_vm_tags
        self.protected_disks = protected_disks
        self.target_network_id = target_network_id
        self.vm_nics = vm_nics
        self.target_nic_tags = target_nic_tags
        self.migration_recovery_point_id = None
        self.last_recovery_point_received = None
        self.last_recovery_point_id = None
        self.initial_seeding_progress_percentage = None
        self.migration_progress_percentage = None
        self.resync_progress_percentage = None
        self.initial_seeding_retry_count = None
        self.resync_retry_count = None
        self.resync_required = None
        self.resync_state = None
        self.perform_auto_resync = perform_auto_resync
        self.seed_disk_tags = seed_disk_tags
        self.target_disk_tags = target_disk_tags


class VMwareCbtNicDetails(msrest.serialization.Model):
    """VMwareCbt NIC details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nic_id: The NIC Id.
    :vartype nic_id: str
    :param is_primary_nic: A value indicating whether this is the primary NIC.
    :type is_primary_nic: str
    :ivar source_ip_address: The source IP address.
    :vartype source_ip_address: str
    :ivar source_ip_address_type: The source IP address type. Possible values include: "Dynamic",
     "Static".
    :vartype source_ip_address_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
    :ivar source_network_id: Source network Id.
    :vartype source_network_id: str
    :param target_ip_address: The target IP address.
    :type target_ip_address: str
    :param target_ip_address_type: The target IP address type. Possible values include: "Dynamic",
     "Static".
    :type target_ip_address_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.EthernetAddressType
    :param target_subnet_name: Target subnet name.
    :type target_subnet_name: str
    :param target_nic_name: Target NIC name.
    :type target_nic_name: str
    :param is_selected_for_migration: A value indicating whether this NIC is selected for
     migration.
    :type is_selected_for_migration: str
    """

    _validation = {
        'nic_id': {'readonly': True},
        'source_ip_address': {'readonly': True},
        'source_ip_address_type': {'readonly': True},
        'source_network_id': {'readonly': True},
    }

    _attribute_map = {
        'nic_id': {'key': 'nicId', 'type': 'str'},
        'is_primary_nic': {'key': 'isPrimaryNic', 'type': 'str'},
        'source_ip_address': {'key': 'sourceIPAddress', 'type': 'str'},
        'source_ip_address_type': {'key': 'sourceIPAddressType', 'type': 'str'},
        'source_network_id': {'key': 'sourceNetworkId', 'type': 'str'},
        'target_ip_address': {'key': 'targetIPAddress', 'type': 'str'},
        'target_ip_address_type': {'key': 'targetIPAddressType', 'type': 'str'},
        'target_subnet_name': {'key': 'targetSubnetName', 'type': 'str'},
        'target_nic_name': {'key': 'targetNicName', 'type': 'str'},
        'is_selected_for_migration': {'key': 'isSelectedForMigration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_primary_nic: Optional[str] = None,
        target_ip_address: Optional[str] = None,
        target_ip_address_type: Optional[Union[str, "EthernetAddressType"]] = None,
        target_subnet_name: Optional[str] = None,
        target_nic_name: Optional[str] = None,
        is_selected_for_migration: Optional[str] = None,
        **kwargs
    ):
        super(VMwareCbtNicDetails, self).__init__(**kwargs)
        self.nic_id = None
        self.is_primary_nic = is_primary_nic
        self.source_ip_address = None
        self.source_ip_address_type = None
        self.source_network_id = None
        self.target_ip_address = target_ip_address
        self.target_ip_address_type = target_ip_address_type
        self.target_subnet_name = target_subnet_name
        self.target_nic_name = target_nic_name
        self.is_selected_for_migration = is_selected_for_migration


class VMwareCbtNicInput(msrest.serialization.Model):
    """VMwareCbt NIC input.

    All required parameters must be populated in order to send to Azure.

    :param nic_id: Required. The NIC Id.
    :type nic_id: str
    :param is_primary_nic: Required. A value indicating whether this is the primary NIC.
    :type is_primary_nic: str
    :param target_subnet_name: Target subnet name.
    :type target_subnet_name: str
    :param target_static_ip_address: The static IP address.
    :type target_static_ip_address: str
    :param is_selected_for_migration: A value indicating whether this NIC is selected for
     migration.
    :type is_selected_for_migration: str
    :param target_nic_name: Target NIC name.
    :type target_nic_name: str
    """

    _validation = {
        'nic_id': {'required': True},
        'is_primary_nic': {'required': True},
    }

    _attribute_map = {
        'nic_id': {'key': 'nicId', 'type': 'str'},
        'is_primary_nic': {'key': 'isPrimaryNic', 'type': 'str'},
        'target_subnet_name': {'key': 'targetSubnetName', 'type': 'str'},
        'target_static_ip_address': {'key': 'targetStaticIPAddress', 'type': 'str'},
        'is_selected_for_migration': {'key': 'isSelectedForMigration', 'type': 'str'},
        'target_nic_name': {'key': 'targetNicName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        nic_id: str,
        is_primary_nic: str,
        target_subnet_name: Optional[str] = None,
        target_static_ip_address: Optional[str] = None,
        is_selected_for_migration: Optional[str] = None,
        target_nic_name: Optional[str] = None,
        **kwargs
    ):
        super(VMwareCbtNicInput, self).__init__(**kwargs)
        self.nic_id = nic_id
        self.is_primary_nic = is_primary_nic
        self.target_subnet_name = target_subnet_name
        self.target_static_ip_address = target_static_ip_address
        self.is_selected_for_migration = is_selected_for_migration
        self.target_nic_name = target_nic_name


class VMwareCbtPolicyCreationInput(PolicyProviderSpecificInput):
    """VMware Cbt policy creation input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_history_in_minutes: The duration in minutes until which the recovery
     points need to be stored.
    :type recovery_point_history_in_minutes: int
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency (in
     minutes).
    :type crash_consistent_frequency_in_minutes: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency (in minutes).
    :type app_consistent_frequency_in_minutes: int
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_history_in_minutes': {'key': 'recoveryPointHistoryInMinutes', 'type': 'int'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(VMwareCbtPolicyCreationInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.recovery_point_history_in_minutes = recovery_point_history_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes


class VmwareCbtPolicyDetails(PolicyProviderSpecificDetails):
    """VMware Cbt specific policy details.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param recovery_point_history_in_minutes: The duration in minutes until which the recovery
     points need to be stored.
    :type recovery_point_history_in_minutes: int
    :param app_consistent_frequency_in_minutes: The app consistent snapshot frequency in minutes.
    :type app_consistent_frequency_in_minutes: int
    :param crash_consistent_frequency_in_minutes: The crash consistent snapshot frequency in
     minutes.
    :type crash_consistent_frequency_in_minutes: int
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_history_in_minutes': {'key': 'recoveryPointHistoryInMinutes', 'type': 'int'},
        'app_consistent_frequency_in_minutes': {'key': 'appConsistentFrequencyInMinutes', 'type': 'int'},
        'crash_consistent_frequency_in_minutes': {'key': 'crashConsistentFrequencyInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        recovery_point_history_in_minutes: Optional[int] = None,
        app_consistent_frequency_in_minutes: Optional[int] = None,
        crash_consistent_frequency_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(VmwareCbtPolicyDetails, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.recovery_point_history_in_minutes = recovery_point_history_in_minutes
        self.app_consistent_frequency_in_minutes = app_consistent_frequency_in_minutes
        self.crash_consistent_frequency_in_minutes = crash_consistent_frequency_in_minutes


class VMwareCbtProtectedDiskDetails(msrest.serialization.Model):
    """VMwareCbt protected disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_id: The disk id.
    :vartype disk_id: str
    :ivar disk_name: The disk name.
    :vartype disk_name: str
    :param disk_type: The disk type. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS".
    :type disk_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.DiskAccountType
    :ivar disk_path: The disk path.
    :vartype disk_path: str
    :ivar is_os_disk: A value indicating whether the disk is the OS disk.
    :vartype is_os_disk: str
    :ivar capacity_in_bytes: The disk capacity in bytes.
    :vartype capacity_in_bytes: long
    :ivar log_storage_account_id: The log storage account ARM Id.
    :vartype log_storage_account_id: str
    :ivar log_storage_account_sas_secret_name: The key vault secret name of the log storage
     account.
    :vartype log_storage_account_sas_secret_name: str
    :ivar disk_encryption_set_id: The DiskEncryptionSet ARM Id.
    :vartype disk_encryption_set_id: str
    :ivar seed_managed_disk_id: The ARM Id of the seed managed disk.
    :vartype seed_managed_disk_id: str
    :ivar target_managed_disk_id: The ARM Id of the target managed disk.
    :vartype target_managed_disk_id: str
    :param target_disk_name: The name for the target managed disk.
    :type target_disk_name: str
    """

    _validation = {
        'disk_id': {'readonly': True},
        'disk_name': {'readonly': True},
        'disk_path': {'readonly': True},
        'is_os_disk': {'readonly': True},
        'capacity_in_bytes': {'readonly': True},
        'log_storage_account_id': {'readonly': True},
        'log_storage_account_sas_secret_name': {'readonly': True},
        'disk_encryption_set_id': {'readonly': True},
        'seed_managed_disk_id': {'readonly': True},
        'target_managed_disk_id': {'readonly': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
        'disk_path': {'key': 'diskPath', 'type': 'str'},
        'is_os_disk': {'key': 'isOSDisk', 'type': 'str'},
        'capacity_in_bytes': {'key': 'capacityInBytes', 'type': 'long'},
        'log_storage_account_id': {'key': 'logStorageAccountId', 'type': 'str'},
        'log_storage_account_sas_secret_name': {'key': 'logStorageAccountSasSecretName', 'type': 'str'},
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'seed_managed_disk_id': {'key': 'seedManagedDiskId', 'type': 'str'},
        'target_managed_disk_id': {'key': 'targetManagedDiskId', 'type': 'str'},
        'target_disk_name': {'key': 'targetDiskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_type: Optional[Union[str, "DiskAccountType"]] = None,
        target_disk_name: Optional[str] = None,
        **kwargs
    ):
        super(VMwareCbtProtectedDiskDetails, self).__init__(**kwargs)
        self.disk_id = None
        self.disk_name = None
        self.disk_type = disk_type
        self.disk_path = None
        self.is_os_disk = None
        self.capacity_in_bytes = None
        self.log_storage_account_id = None
        self.log_storage_account_sas_secret_name = None
        self.disk_encryption_set_id = None
        self.seed_managed_disk_id = None
        self.target_managed_disk_id = None
        self.target_disk_name = target_disk_name


class VMwareCbtProtectionContainerMappingDetails(ProtectionContainerMappingProviderSpecificDetails):
    """VMwareCbt provider specific container mapping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :ivar key_vault_id: The target key vault ARM Id.
    :vartype key_vault_id: str
    :ivar key_vault_uri: The target key vault URI.
    :vartype key_vault_uri: str
    :ivar storage_account_id: The storage account ARM Id.
    :vartype storage_account_id: str
    :ivar storage_account_sas_secret_name: The secret name of the storage account.
    :vartype storage_account_sas_secret_name: str
    :ivar service_bus_connection_string_secret_name: The secret name of the service bus connection
     string.
    :vartype service_bus_connection_string_secret_name: str
    :ivar target_location: The target location.
    :vartype target_location: str
    """

    _validation = {
        'instance_type': {'required': True},
        'key_vault_id': {'readonly': True},
        'key_vault_uri': {'readonly': True},
        'storage_account_id': {'readonly': True},
        'storage_account_sas_secret_name': {'readonly': True},
        'service_bus_connection_string_secret_name': {'readonly': True},
        'target_location': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'storage_account_sas_secret_name': {'key': 'storageAccountSasSecretName', 'type': 'str'},
        'service_bus_connection_string_secret_name': {'key': 'serviceBusConnectionStringSecretName', 'type': 'str'},
        'target_location': {'key': 'targetLocation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VMwareCbtProtectionContainerMappingDetails, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.key_vault_id = None
        self.key_vault_uri = None
        self.storage_account_id = None
        self.storage_account_sas_secret_name = None
        self.service_bus_connection_string_secret_name = None
        self.target_location = None


class VMwareCbtResyncInput(ResyncProviderSpecificInput):
    """VMwareCbt specific resync input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param skip_cbt_reset: Required. A value indicating whether CBT is to be reset.
    :type skip_cbt_reset: str
    """

    _validation = {
        'instance_type': {'required': True},
        'skip_cbt_reset': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'skip_cbt_reset': {'key': 'skipCbtReset', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        skip_cbt_reset: str,
        **kwargs
    ):
        super(VMwareCbtResyncInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.skip_cbt_reset = skip_cbt_reset


class VMwareCbtTestMigrateInput(TestMigrateProviderSpecificInput):
    """VMwareCbt specific test migrate input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param recovery_point_id: Required. The recovery point Id.
    :type recovery_point_id: str
    :param network_id: Required. The test network Id.
    :type network_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'recovery_point_id': {'required': True},
        'network_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'network_id': {'key': 'networkId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        recovery_point_id: str,
        network_id: str,
        **kwargs
    ):
        super(VMwareCbtTestMigrateInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.recovery_point_id = recovery_point_id
        self.network_id = network_id


class VMwareCbtUpdateDiskInput(msrest.serialization.Model):
    """VMwareCbt disk input for update.

    All required parameters must be populated in order to send to Azure.

    :param disk_id: Required. The disk Id.
    :type disk_id: str
    :param target_disk_name: The target disk name.
    :type target_disk_name: str
    """

    _validation = {
        'disk_id': {'required': True},
    }

    _attribute_map = {
        'disk_id': {'key': 'diskId', 'type': 'str'},
        'target_disk_name': {'key': 'targetDiskName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_id: str,
        target_disk_name: Optional[str] = None,
        **kwargs
    ):
        super(VMwareCbtUpdateDiskInput, self).__init__(**kwargs)
        self.disk_id = disk_id
        self.target_disk_name = target_disk_name


class VMwareCbtUpdateMigrationItemInput(UpdateMigrationItemProviderSpecificInput):
    """VMwareCbt specific update migration item input.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. The class type.Constant filled by server.
    :type instance_type: str
    :param target_vm_name: The target VM name.
    :type target_vm_name: str
    :param target_vm_size: The target VM size.
    :type target_vm_size: str
    :param target_resource_group_id: The target resource group ARM Id.
    :type target_resource_group_id: str
    :param target_availability_set_id: The target availability set ARM Id.
    :type target_availability_set_id: str
    :param target_availability_zone: The target availability zone.
    :type target_availability_zone: str
    :param target_proximity_placement_group_id: The target proximity placement group ARM Id.
    :type target_proximity_placement_group_id: str
    :param target_boot_diagnostics_storage_account_id: The target boot diagnostics storage account
     ARM Id.
    :type target_boot_diagnostics_storage_account_id: str
    :param target_network_id: The target network ARM Id.
    :type target_network_id: str
    :param vm_nics: The list of NIC details.
    :type vm_nics: list[~azure.mgmt.recoveryservicessiterecovery.models.VMwareCbtNicInput]
    :param vm_disks: The list of disk update properties.
    :type vm_disks: list[~azure.mgmt.recoveryservicessiterecovery.models.VMwareCbtUpdateDiskInput]
    :param license_type: The license type. Possible values include: "NotSpecified",
     "NoLicenseType", "WindowsServer".
    :type license_type: str or ~azure.mgmt.recoveryservicessiterecovery.models.LicenseType
    :param sql_server_license_type: The SQL Server license type. Possible values include:
     "NotSpecified", "NoLicenseType", "PAYG", "AHUB".
    :type sql_server_license_type: str or
     ~azure.mgmt.recoveryservicessiterecovery.models.SqlServerLicenseType
    :param perform_auto_resync: A value indicating whether auto resync is to be done.
    :type perform_auto_resync: str
    :param target_vm_tags: The target VM tags.
    :type target_vm_tags: dict[str, str]
    :param target_disk_tags: The tags for the target disks.
    :type target_disk_tags: dict[str, str]
    :param target_nic_tags: The tags for the target NICs.
    :type target_nic_tags: dict[str, str]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'target_vm_name': {'key': 'targetVmName', 'type': 'str'},
        'target_vm_size': {'key': 'targetVmSize', 'type': 'str'},
        'target_resource_group_id': {'key': 'targetResourceGroupId', 'type': 'str'},
        'target_availability_set_id': {'key': 'targetAvailabilitySetId', 'type': 'str'},
        'target_availability_zone': {'key': 'targetAvailabilityZone', 'type': 'str'},
        'target_proximity_placement_group_id': {'key': 'targetProximityPlacementGroupId', 'type': 'str'},
        'target_boot_diagnostics_storage_account_id': {'key': 'targetBootDiagnosticsStorageAccountId', 'type': 'str'},
        'target_network_id': {'key': 'targetNetworkId', 'type': 'str'},
        'vm_nics': {'key': 'vmNics', 'type': '[VMwareCbtNicInput]'},
        'vm_disks': {'key': 'vmDisks', 'type': '[VMwareCbtUpdateDiskInput]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'sql_server_license_type': {'key': 'sqlServerLicenseType', 'type': 'str'},
        'perform_auto_resync': {'key': 'performAutoResync', 'type': 'str'},
        'target_vm_tags': {'key': 'targetVmTags', 'type': '{str}'},
        'target_disk_tags': {'key': 'targetDiskTags', 'type': '{str}'},
        'target_nic_tags': {'key': 'targetNicTags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        target_vm_name: Optional[str] = None,
        target_vm_size: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        target_availability_set_id: Optional[str] = None,
        target_availability_zone: Optional[str] = None,
        target_proximity_placement_group_id: Optional[str] = None,
        target_boot_diagnostics_storage_account_id: Optional[str] = None,
        target_network_id: Optional[str] = None,
        vm_nics: Optional[List["VMwareCbtNicInput"]] = None,
        vm_disks: Optional[List["VMwareCbtUpdateDiskInput"]] = None,
        license_type: Optional[Union[str, "LicenseType"]] = None,
        sql_server_license_type: Optional[Union[str, "SqlServerLicenseType"]] = None,
        perform_auto_resync: Optional[str] = None,
        target_vm_tags: Optional[Dict[str, str]] = None,
        target_disk_tags: Optional[Dict[str, str]] = None,
        target_nic_tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(VMwareCbtUpdateMigrationItemInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareCbt'  # type: str
        self.target_vm_name = target_vm_name
        self.target_vm_size = target_vm_size
        self.target_resource_group_id = target_resource_group_id
        self.target_availability_set_id = target_availability_set_id
        self.target_availability_zone = target_availability_zone
        self.target_proximity_placement_group_id = target_proximity_placement_group_id
        self.target_boot_diagnostics_storage_account_id = target_boot_diagnostics_storage_account_id
        self.target_network_id = target_network_id
        self.vm_nics = vm_nics
        self.vm_disks = vm_disks
        self.license_type = license_type
        self.sql_server_license_type = sql_server_license_type
        self.perform_auto_resync = perform_auto_resync
        self.target_vm_tags = target_vm_tags
        self.target_disk_tags = target_disk_tags
        self.target_nic_tags = target_nic_tags


class VMwareDetails(FabricSpecificDetails):
    """Store the fabric details specific to the VMware fabric.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param process_servers: The list of Process Servers associated with the fabric.
    :type process_servers: list[~azure.mgmt.recoveryservicessiterecovery.models.ProcessServer]
    :param master_target_servers: The list of Master Target servers associated with the fabric.
    :type master_target_servers:
     list[~azure.mgmt.recoveryservicessiterecovery.models.MasterTargetServer]
    :param run_as_accounts: The list of run as accounts created on the server.
    :type run_as_accounts: list[~azure.mgmt.recoveryservicessiterecovery.models.RunAsAccount]
    :param replication_pair_count: The number of replication pairs configured in this CS.
    :type replication_pair_count: str
    :param process_server_count: The number of process servers.
    :type process_server_count: str
    :param agent_count: The number of source and target servers configured to talk to this CS.
    :type agent_count: str
    :param protected_servers: The number of protected servers.
    :type protected_servers: str
    :param system_load: The percentage of the system load.
    :type system_load: str
    :param system_load_status: The system load status.
    :type system_load_status: str
    :param cpu_load: The percentage of the CPU load.
    :type cpu_load: str
    :param cpu_load_status: The CPU load status.
    :type cpu_load_status: str
    :param total_memory_in_bytes: The total memory.
    :type total_memory_in_bytes: long
    :param available_memory_in_bytes: The available memory.
    :type available_memory_in_bytes: long
    :param memory_usage_status: The memory usage status.
    :type memory_usage_status: str
    :param total_space_in_bytes: The total space.
    :type total_space_in_bytes: long
    :param available_space_in_bytes: The available space.
    :type available_space_in_bytes: long
    :param space_usage_status: The space usage status.
    :type space_usage_status: str
    :param web_load: The web load.
    :type web_load: str
    :param web_load_status: The web load status.
    :type web_load_status: str
    :param database_server_load: The database server load.
    :type database_server_load: str
    :param database_server_load_status: The database server load status.
    :type database_server_load_status: str
    :param cs_service_status: The CS service status.
    :type cs_service_status: str
    :param ip_address: The IP address.
    :type ip_address: str
    :param agent_version: The agent Version.
    :type agent_version: str
    :param host_name: The host name.
    :type host_name: str
    :param last_heartbeat: The last heartbeat received from CS server.
    :type last_heartbeat: ~datetime.datetime
    :param version_status: Version status.
    :type version_status: str
    :param ssl_cert_expiry_date: CS SSL cert expiry date.
    :type ssl_cert_expiry_date: ~datetime.datetime
    :param ssl_cert_expiry_remaining_days: CS SSL cert expiry date.
    :type ssl_cert_expiry_remaining_days: int
    :param ps_template_version: PS template version.
    :type ps_template_version: str
    :param agent_expiry_date: Agent expiry date.
    :type agent_expiry_date: ~datetime.datetime
    :param agent_version_details: The agent version details.
    :type agent_version_details: ~azure.mgmt.recoveryservicessiterecovery.models.VersionDetails
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'process_servers': {'key': 'processServers', 'type': '[ProcessServer]'},
        'master_target_servers': {'key': 'masterTargetServers', 'type': '[MasterTargetServer]'},
        'run_as_accounts': {'key': 'runAsAccounts', 'type': '[RunAsAccount]'},
        'replication_pair_count': {'key': 'replicationPairCount', 'type': 'str'},
        'process_server_count': {'key': 'processServerCount', 'type': 'str'},
        'agent_count': {'key': 'agentCount', 'type': 'str'},
        'protected_servers': {'key': 'protectedServers', 'type': 'str'},
        'system_load': {'key': 'systemLoad', 'type': 'str'},
        'system_load_status': {'key': 'systemLoadStatus', 'type': 'str'},
        'cpu_load': {'key': 'cpuLoad', 'type': 'str'},
        'cpu_load_status': {'key': 'cpuLoadStatus', 'type': 'str'},
        'total_memory_in_bytes': {'key': 'totalMemoryInBytes', 'type': 'long'},
        'available_memory_in_bytes': {'key': 'availableMemoryInBytes', 'type': 'long'},
        'memory_usage_status': {'key': 'memoryUsageStatus', 'type': 'str'},
        'total_space_in_bytes': {'key': 'totalSpaceInBytes', 'type': 'long'},
        'available_space_in_bytes': {'key': 'availableSpaceInBytes', 'type': 'long'},
        'space_usage_status': {'key': 'spaceUsageStatus', 'type': 'str'},
        'web_load': {'key': 'webLoad', 'type': 'str'},
        'web_load_status': {'key': 'webLoadStatus', 'type': 'str'},
        'database_server_load': {'key': 'databaseServerLoad', 'type': 'str'},
        'database_server_load_status': {'key': 'databaseServerLoadStatus', 'type': 'str'},
        'cs_service_status': {'key': 'csServiceStatus', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'last_heartbeat': {'key': 'lastHeartbeat', 'type': 'iso-8601'},
        'version_status': {'key': 'versionStatus', 'type': 'str'},
        'ssl_cert_expiry_date': {'key': 'sslCertExpiryDate', 'type': 'iso-8601'},
        'ssl_cert_expiry_remaining_days': {'key': 'sslCertExpiryRemainingDays', 'type': 'int'},
        'ps_template_version': {'key': 'psTemplateVersion', 'type': 'str'},
        'agent_expiry_date': {'key': 'agentExpiryDate', 'type': 'iso-8601'},
        'agent_version_details': {'key': 'agentVersionDetails', 'type': 'VersionDetails'},
    }

    def __init__(
        self,
        *,
        process_servers: Optional[List["ProcessServer"]] = None,
        master_target_servers: Optional[List["MasterTargetServer"]] = None,
        run_as_accounts: Optional[List["RunAsAccount"]] = None,
        replication_pair_count: Optional[str] = None,
        process_server_count: Optional[str] = None,
        agent_count: Optional[str] = None,
        protected_servers: Optional[str] = None,
        system_load: Optional[str] = None,
        system_load_status: Optional[str] = None,
        cpu_load: Optional[str] = None,
        cpu_load_status: Optional[str] = None,
        total_memory_in_bytes: Optional[int] = None,
        available_memory_in_bytes: Optional[int] = None,
        memory_usage_status: Optional[str] = None,
        total_space_in_bytes: Optional[int] = None,
        available_space_in_bytes: Optional[int] = None,
        space_usage_status: Optional[str] = None,
        web_load: Optional[str] = None,
        web_load_status: Optional[str] = None,
        database_server_load: Optional[str] = None,
        database_server_load_status: Optional[str] = None,
        cs_service_status: Optional[str] = None,
        ip_address: Optional[str] = None,
        agent_version: Optional[str] = None,
        host_name: Optional[str] = None,
        last_heartbeat: Optional[datetime.datetime] = None,
        version_status: Optional[str] = None,
        ssl_cert_expiry_date: Optional[datetime.datetime] = None,
        ssl_cert_expiry_remaining_days: Optional[int] = None,
        ps_template_version: Optional[str] = None,
        agent_expiry_date: Optional[datetime.datetime] = None,
        agent_version_details: Optional["VersionDetails"] = None,
        **kwargs
    ):
        super(VMwareDetails, self).__init__(**kwargs)
        self.instance_type = 'VMware'  # type: str
        self.process_servers = process_servers
        self.master_target_servers = master_target_servers
        self.run_as_accounts = run_as_accounts
        self.replication_pair_count = replication_pair_count
        self.process_server_count = process_server_count
        self.agent_count = agent_count
        self.protected_servers = protected_servers
        self.system_load = system_load
        self.system_load_status = system_load_status
        self.cpu_load = cpu_load
        self.cpu_load_status = cpu_load_status
        self.total_memory_in_bytes = total_memory_in_bytes
        self.available_memory_in_bytes = available_memory_in_bytes
        self.memory_usage_status = memory_usage_status
        self.total_space_in_bytes = total_space_in_bytes
        self.available_space_in_bytes = available_space_in_bytes
        self.space_usage_status = space_usage_status
        self.web_load = web_load
        self.web_load_status = web_load_status
        self.database_server_load = database_server_load
        self.database_server_load_status = database_server_load_status
        self.cs_service_status = cs_service_status
        self.ip_address = ip_address
        self.agent_version = agent_version
        self.host_name = host_name
        self.last_heartbeat = last_heartbeat
        self.version_status = version_status
        self.ssl_cert_expiry_date = ssl_cert_expiry_date
        self.ssl_cert_expiry_remaining_days = ssl_cert_expiry_remaining_days
        self.ps_template_version = ps_template_version
        self.agent_expiry_date = agent_expiry_date
        self.agent_version_details = agent_version_details


class VMwareV2FabricCreationInput(FabricSpecificCreationInput):
    """VMwareV2 fabric provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type.Constant filled by server.
    :type instance_type: str
    :param vmware_site_id: The ARM Id of the VMware site.
    :type vmware_site_id: str
    :param physical_site_id: The ARM Id of the physical site.
    :type physical_site_id: str
    :param migration_solution_id: Required. The ARM Id of the migration solution.
    :type migration_solution_id: str
    """

    _validation = {
        'instance_type': {'required': True},
        'migration_solution_id': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vmware_site_id': {'key': 'vmwareSiteId', 'type': 'str'},
        'physical_site_id': {'key': 'physicalSiteId', 'type': 'str'},
        'migration_solution_id': {'key': 'migrationSolutionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        migration_solution_id: str,
        vmware_site_id: Optional[str] = None,
        physical_site_id: Optional[str] = None,
        **kwargs
    ):
        super(VMwareV2FabricCreationInput, self).__init__(**kwargs)
        self.instance_type = 'VMwareV2'  # type: str
        self.vmware_site_id = vmware_site_id
        self.physical_site_id = physical_site_id
        self.migration_solution_id = migration_solution_id


class VMwareV2FabricSpecificDetails(FabricSpecificDetails):
    """VMwareV2 fabric specific details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :ivar vmware_site_id: The ARM Id of the VMware site.
    :vartype vmware_site_id: str
    :ivar physical_site_id: The ARM Id of the physical site.
    :vartype physical_site_id: str
    :ivar migration_solution_id: The Migration solution ARM Id.
    :vartype migration_solution_id: str
    :ivar service_endpoint: The service endpoint.
    :vartype service_endpoint: str
    :ivar service_resource_id: The service resource Id.
    :vartype service_resource_id: str
    :ivar service_container_id: The service container Id.
    :vartype service_container_id: str
    :ivar process_servers: The list of process servers.
    :vartype process_servers:
     list[~azure.mgmt.recoveryservicessiterecovery.models.ProcessServerDetails]
    """

    _validation = {
        'instance_type': {'required': True},
        'vmware_site_id': {'readonly': True},
        'physical_site_id': {'readonly': True},
        'migration_solution_id': {'readonly': True},
        'service_endpoint': {'readonly': True},
        'service_resource_id': {'readonly': True},
        'service_container_id': {'readonly': True},
        'process_servers': {'readonly': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'vmware_site_id': {'key': 'vmwareSiteId', 'type': 'str'},
        'physical_site_id': {'key': 'physicalSiteId', 'type': 'str'},
        'migration_solution_id': {'key': 'migrationSolutionId', 'type': 'str'},
        'service_endpoint': {'key': 'serviceEndpoint', 'type': 'str'},
        'service_resource_id': {'key': 'serviceResourceId', 'type': 'str'},
        'service_container_id': {'key': 'serviceContainerId', 'type': 'str'},
        'process_servers': {'key': 'processServers', 'type': '[ProcessServerDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VMwareV2FabricSpecificDetails, self).__init__(**kwargs)
        self.instance_type = 'VMwareV2'  # type: str
        self.vmware_site_id = None
        self.physical_site_id = None
        self.migration_solution_id = None
        self.service_endpoint = None
        self.service_resource_id = None
        self.service_container_id = None
        self.process_servers = None


class VMwareVirtualMachineDetails(ConfigurationSettings):
    """VMware provider specific settings.

    All required parameters must be populated in order to send to Azure.

    :param instance_type: Required. Gets the class type. Overridden in derived classes.Constant
     filled by server.
    :type instance_type: str
    :param agent_generated_id: The ID generated by the InMage agent after it gets installed on
     guest. This is the ID to be used during InMage CreateProtection.
    :type agent_generated_id: str
    :param agent_installed: The value indicating if InMage scout agent is installed on guest.
    :type agent_installed: str
    :param os_type: The OsType installed on VM.
    :type os_type: str
    :param agent_version: The agent version.
    :type agent_version: str
    :param ip_address: The IP address.
    :type ip_address: str
    :param powered_on: The value indicating whether VM is powered on.
    :type powered_on: str
    :param v_center_infrastructure_id: The VCenter infrastructure Id.
    :type v_center_infrastructure_id: str
    :param discovery_type: A value indicating the discovery type of the machine. Value can be
     vCenter or physical.
    :type discovery_type: str
    :param disk_details: The disk details.
    :type disk_details: list[~azure.mgmt.recoveryservicessiterecovery.models.InMageDiskDetails]
    :param validation_errors: The validation errors.
    :type validation_errors: list[~azure.mgmt.recoveryservicessiterecovery.models.HealthError]
    """

    _validation = {
        'instance_type': {'required': True},
    }

    _attribute_map = {
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'agent_generated_id': {'key': 'agentGeneratedId', 'type': 'str'},
        'agent_installed': {'key': 'agentInstalled', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'powered_on': {'key': 'poweredOn', 'type': 'str'},
        'v_center_infrastructure_id': {'key': 'vCenterInfrastructureId', 'type': 'str'},
        'discovery_type': {'key': 'discoveryType', 'type': 'str'},
        'disk_details': {'key': 'diskDetails', 'type': '[InMageDiskDetails]'},
        'validation_errors': {'key': 'validationErrors', 'type': '[HealthError]'},
    }

    def __init__(
        self,
        *,
        agent_generated_id: Optional[str] = None,
        agent_installed: Optional[str] = None,
        os_type: Optional[str] = None,
        agent_version: Optional[str] = None,
        ip_address: Optional[str] = None,
        powered_on: Optional[str] = None,
        v_center_infrastructure_id: Optional[str] = None,
        discovery_type: Optional[str] = None,
        disk_details: Optional[List["InMageDiskDetails"]] = None,
        validation_errors: Optional[List["HealthError"]] = None,
        **kwargs
    ):
        super(VMwareVirtualMachineDetails, self).__init__(**kwargs)
        self.instance_type = 'VMwareVirtualMachine'  # type: str
        self.agent_generated_id = agent_generated_id
        self.agent_installed = agent_installed
        self.os_type = os_type
        self.agent_version = agent_version
        self.ip_address = ip_address
        self.powered_on = powered_on
        self.v_center_infrastructure_id = v_center_infrastructure_id
        self.discovery_type = discovery_type
        self.disk_details = disk_details
        self.validation_errors = validation_errors
