# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class DataSource(msrest.serialization.Model):
    """Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Datasource kind. Possible values include: "PerformanceCounter",
     "ETWProviders", "WindowsEventLogs".
    :type kind: str or ~$(python-base-namespace).v2018_06_01_preview.models.DataSourceKind
    :param configuration: Required.
    :type configuration: ~$(python-base-
     namespace).v2018_06_01_preview.models.DataSourceConfiguration
    :param sinks: Required.
    :type sinks: list[~$(python-base-namespace).v2018_06_01_preview.models.SinkConfiguration]
    """

    _validation = {
        'kind': {'required': True},
        'configuration': {'required': True},
        'sinks': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'DataSourceConfiguration'},
        'sinks': {'key': 'sinks', 'type': '[SinkConfiguration]'},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "DataSourceKind"],
        configuration: "DataSourceConfiguration",
        sinks: List["SinkConfiguration"],
        **kwargs
    ):
        super(DataSource, self).__init__(**kwargs)
        self.kind = kind
        self.configuration = configuration
        self.sinks = sinks


class DataSourceConfiguration(msrest.serialization.Model):
    """DataSourceConfiguration.

    :param providers: ETW providers configuration.
    :type providers: list[~$(python-base-
     namespace).v2018_06_01_preview.models.EtwProviderConfiguration]
    :param perf_counters: Performance counter configuration.
    :type perf_counters: list[~$(python-base-
     namespace).v2018_06_01_preview.models.PerformanceCounterConfiguration]
    :param event_logs: Windows event logs configuration.
    :type event_logs: list[~$(python-base-
     namespace).v2018_06_01_preview.models.EventLogConfiguration]
    """

    _attribute_map = {
        'providers': {'key': 'providers', 'type': '[EtwProviderConfiguration]'},
        'perf_counters': {'key': 'perfCounters', 'type': '[PerformanceCounterConfiguration]'},
        'event_logs': {'key': 'eventLogs', 'type': '[EventLogConfiguration]'},
    }

    def __init__(
        self,
        *,
        providers: Optional[List["EtwProviderConfiguration"]] = None,
        perf_counters: Optional[List["PerformanceCounterConfiguration"]] = None,
        event_logs: Optional[List["EventLogConfiguration"]] = None,
        **kwargs
    ):
        super(DataSourceConfiguration, self).__init__(**kwargs)
        self.providers = providers
        self.perf_counters = perf_counters
        self.event_logs = event_logs


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class EtwEventConfiguration(msrest.serialization.Model):
    """EtwEventConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param id: Required.
    :type id: int
    :param filter:
    :type filter: str
    """

    _validation = {
        'name': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'int'},
        'filter': {'key': 'filter', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        id: int,
        filter: Optional[str] = None,
        **kwargs
    ):
        super(EtwEventConfiguration, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.filter = filter


class EtwProviderConfiguration(msrest.serialization.Model):
    """EtwProviderConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param events: Required.
    :type events: list[~$(python-base-namespace).v2018_06_01_preview.models.EtwEventConfiguration]
    """

    _validation = {
        'id': {'required': True},
        'events': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'events': {'key': 'events', 'type': '[EtwEventConfiguration]'},
    }

    def __init__(
        self,
        *,
        id: str,
        events: List["EtwEventConfiguration"],
        **kwargs
    ):
        super(EtwProviderConfiguration, self).__init__(**kwargs)
        self.id = id
        self.events = events


class EventLogConfiguration(msrest.serialization.Model):
    """EventLogConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param log_name: Required.
    :type log_name: str
    :param filter:
    :type filter: str
    """

    _validation = {
        'log_name': {'required': True},
    }

    _attribute_map = {
        'log_name': {'key': 'logName', 'type': 'str'},
        'filter': {'key': 'filter', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        log_name: str,
        filter: Optional[str] = None,
        **kwargs
    ):
        super(EventLogConfiguration, self).__init__(**kwargs)
        self.log_name = log_name
        self.filter = filter


class GuestDiagnosticSettingsAssociationList(msrest.serialization.Model):
    """A list of guest diagnostic settings association.

    :param value: The list of guest diagnostic settings association.
    :type value: list[~$(python-base-
     namespace).v2018_06_01_preview.models.GuestDiagnosticSettingsAssociationResource]
    :param next_link: Provides the link to retrieve the next set of elements.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GuestDiagnosticSettingsAssociationResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GuestDiagnosticSettingsAssociationResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GuestDiagnosticSettingsAssociationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class GuestDiagnosticSettingsAssociationResource(Resource):
    """Virtual machine guest diagnostic settings resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param guest_diagnostic_settings_name: Required. The guest diagnostic settings name.
    :type guest_diagnostic_settings_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'guest_diagnostic_settings_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'guest_diagnostic_settings_name': {'key': 'properties.guestDiagnosticSettingsName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        guest_diagnostic_settings_name: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(GuestDiagnosticSettingsAssociationResource, self).__init__(location=location, tags=tags, **kwargs)
        self.guest_diagnostic_settings_name = guest_diagnostic_settings_name


class GuestDiagnosticSettingsAssociationResourcePatch(msrest.serialization.Model):
    """Guest diagnostic setting resource for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param guest_diagnostic_settings_name: The guest diagnostic settings name.
    :type guest_diagnostic_settings_name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'guest_diagnostic_settings_name': {'key': 'properties.guestDiagnosticSettingsName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        guest_diagnostic_settings_name: Optional[str] = None,
        **kwargs
    ):
        super(GuestDiagnosticSettingsAssociationResourcePatch, self).__init__(**kwargs)
        self.tags = tags
        self.guest_diagnostic_settings_name = guest_diagnostic_settings_name


class GuestDiagnosticSettingsList(msrest.serialization.Model):
    """A list of guest diagnostic settings.

    :param value: The list of guest diagnostic settings.
    :type value: list[~$(python-base-
     namespace).v2018_06_01_preview.models.GuestDiagnosticSettingsResource]
    :param next_link: Provides the link to retrieve the next set of elements.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GuestDiagnosticSettingsResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GuestDiagnosticSettingsResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GuestDiagnosticSettingsList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GuestDiagnosticSettingsPatchResource(msrest.serialization.Model):
    """An diagnostic settings object for the body of patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param os_type: Operating system type for the configuration. Possible values include:
     "Windows", "Linux".
    :type os_type: str or ~$(python-base-
     namespace).v2018_06_01_preview.models.GuestDiagnosticSettingsOsType
    :param data_sources: the array of data source object which are configured to collect and send
     data.
    :type data_sources: list[~$(python-base-namespace).v2018_06_01_preview.models.DataSource]
    :param proxy_setting:
    :type proxy_setting: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': '[DataSource]'},
        'proxy_setting': {'key': 'properties.proxySetting', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        os_type: Optional[Union[str, "GuestDiagnosticSettingsOsType"]] = None,
        data_sources: Optional[List["DataSource"]] = None,
        proxy_setting: Optional[str] = None,
        **kwargs
    ):
        super(GuestDiagnosticSettingsPatchResource, self).__init__(**kwargs)
        self.tags = tags
        self.os_type = os_type
        self.data_sources = data_sources
        self.proxy_setting = proxy_setting


class GuestDiagnosticSettingsResource(Resource):
    """Virtual machine guest diagnostics settings resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param os_type: Operating system type for the configuration. Possible values include:
     "Windows", "Linux".
    :type os_type: str or ~$(python-base-
     namespace).v2018_06_01_preview.models.GuestDiagnosticSettingsOsType
    :param data_sources: the array of data source object which are configured to collect and send
     data.
    :type data_sources: list[~$(python-base-namespace).v2018_06_01_preview.models.DataSource]
    :param proxy_setting:
    :type proxy_setting: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': '[DataSource]'},
        'proxy_setting': {'key': 'properties.proxySetting', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        os_type: Optional[Union[str, "GuestDiagnosticSettingsOsType"]] = None,
        data_sources: Optional[List["DataSource"]] = None,
        proxy_setting: Optional[str] = None,
        **kwargs
    ):
        super(GuestDiagnosticSettingsResource, self).__init__(location=location, tags=tags, **kwargs)
        self.os_type = os_type
        self.data_sources = data_sources
        self.proxy_setting = proxy_setting


class PerformanceCounterConfiguration(msrest.serialization.Model):
    """PerformanceCounterConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param sampling_period: Required.
    :type sampling_period: str
    :param instance:
    :type instance: str
    """

    _validation = {
        'name': {'required': True},
        'sampling_period': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sampling_period': {'key': 'samplingPeriod', 'type': 'str'},
        'instance': {'key': 'instance', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        sampling_period: str,
        instance: Optional[str] = None,
        **kwargs
    ):
        super(PerformanceCounterConfiguration, self).__init__(**kwargs)
        self.name = name
        self.sampling_period = sampling_period
        self.instance = instance


class SinkConfiguration(msrest.serialization.Model):
    """SinkConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required.  Possible values include: "EventHub", "ApplicationInsights",
     "LogAnalytics".
    :type kind: str or ~$(python-base-namespace).v2018_06_01_preview.models.SinkConfigurationKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "SinkConfigurationKind"],
        **kwargs
    ):
        super(SinkConfiguration, self).__init__(**kwargs)
        self.kind = kind
