# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import EventGridManagementClientConfiguration
from .operations import DomainsOperations
from .operations import DomainTopicsOperations
from .operations import EventChannelsOperations
from .operations import EventSubscriptionsOperations
from .operations import SystemTopicEventSubscriptionsOperations
from .operations import PartnerTopicEventSubscriptionsOperations
from .operations import Operations
from .operations import PartnerNamespacesOperations
from .operations import PartnerRegistrationsOperations
from .operations import PartnerTopicsOperations
from .operations import PrivateEndpointConnectionsOperations
from .operations import PrivateLinkResourcesOperations
from .operations import SystemTopicsOperations
from .operations import TopicsOperations
from .operations import ExtensionTopicsOperations
from .operations import TopicTypesOperations
from .. import models


class EventGridManagementClient(object):
    """Azure EventGrid Management Client.

    :ivar domains: DomainsOperations operations
    :vartype domains: azure.mgmt.eventgrid.aio.operations.DomainsOperations
    :ivar domain_topics: DomainTopicsOperations operations
    :vartype domain_topics: azure.mgmt.eventgrid.aio.operations.DomainTopicsOperations
    :ivar event_channels: EventChannelsOperations operations
    :vartype event_channels: azure.mgmt.eventgrid.aio.operations.EventChannelsOperations
    :ivar event_subscriptions: EventSubscriptionsOperations operations
    :vartype event_subscriptions: azure.mgmt.eventgrid.aio.operations.EventSubscriptionsOperations
    :ivar system_topic_event_subscriptions: SystemTopicEventSubscriptionsOperations operations
    :vartype system_topic_event_subscriptions: azure.mgmt.eventgrid.aio.operations.SystemTopicEventSubscriptionsOperations
    :ivar partner_topic_event_subscriptions: PartnerTopicEventSubscriptionsOperations operations
    :vartype partner_topic_event_subscriptions: azure.mgmt.eventgrid.aio.operations.PartnerTopicEventSubscriptionsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.eventgrid.aio.operations.Operations
    :ivar partner_namespaces: PartnerNamespacesOperations operations
    :vartype partner_namespaces: azure.mgmt.eventgrid.aio.operations.PartnerNamespacesOperations
    :ivar partner_registrations: PartnerRegistrationsOperations operations
    :vartype partner_registrations: azure.mgmt.eventgrid.aio.operations.PartnerRegistrationsOperations
    :ivar partner_topics: PartnerTopicsOperations operations
    :vartype partner_topics: azure.mgmt.eventgrid.aio.operations.PartnerTopicsOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections: azure.mgmt.eventgrid.aio.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources: azure.mgmt.eventgrid.aio.operations.PrivateLinkResourcesOperations
    :ivar system_topics: SystemTopicsOperations operations
    :vartype system_topics: azure.mgmt.eventgrid.aio.operations.SystemTopicsOperations
    :ivar topics: TopicsOperations operations
    :vartype topics: azure.mgmt.eventgrid.aio.operations.TopicsOperations
    :ivar extension_topics: ExtensionTopicsOperations operations
    :vartype extension_topics: azure.mgmt.eventgrid.aio.operations.ExtensionTopicsOperations
    :ivar topic_types: TopicTypesOperations operations
    :vartype topic_types: azure.mgmt.eventgrid.aio.operations.TopicTypesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Subscription credentials that uniquely identify a Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = EventGridManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.domains = DomainsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.domain_topics = DomainTopicsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.event_channels = EventChannelsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.event_subscriptions = EventSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.system_topic_event_subscriptions = SystemTopicEventSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.partner_topic_event_subscriptions = PartnerTopicEventSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.partner_namespaces = PartnerNamespacesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.partner_registrations = PartnerRegistrationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.partner_topics = PartnerTopicsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.system_topics = SystemTopicsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.topics = TopicsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.extension_topics = ExtensionTopicsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.topic_types = TopicTypesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def _send_request(self, http_request: HttpRequest, **kwargs: Any) -> AsyncHttpResponse:
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.AsyncHttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = await self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "EventGridManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
