# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from .operations.metrics_operations import MetricsOperations
from .operations.events_operations import EventsOperations
from .operations.query_operations import QueryOperations
from . import models


class ApplicationInsightsDataClientConfiguration(Configuration):
    """Configuration for ApplicationInsightsDataClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if not base_url:
            base_url = 'https://api.applicationinsights.io/v1'

        super(ApplicationInsightsDataClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-applicationinsights/{}'.format(VERSION))

        self.credentials = credentials


class ApplicationInsightsDataClient(SDKClient):
    """Composite Swagger for Application Insights Data Client

    :ivar config: Configuration for client.
    :vartype config: ApplicationInsightsDataClientConfiguration

    :ivar metrics: Metrics operations
    :vartype metrics: azure.applicationinsights.operations.MetricsOperations
    :ivar events: Events operations
    :vartype events: azure.applicationinsights.operations.EventsOperations
    :ivar query: Query operations
    :vartype query: azure.applicationinsights.operations.QueryOperations

    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, base_url=None):

        self.config = ApplicationInsightsDataClientConfiguration(credentials, base_url)
        super(ApplicationInsightsDataClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v1'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.metrics = MetricsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.events = EventsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.query = QueryOperations(
            self._client, self.config, self._serialize, self._deserialize)
