# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Sku(Model):
    """SKU of the namespace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name of this SKU. Default value: "Standard" .
    :vartype name: str
    :param tier: The tier of this SKU. Possible values include: 'Standard'
    :type tier: str or ~azure.mgmt.relay.models.SkuTier
    """

    _validation = {
        'name': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'SkuTier'},
    }

    name = "Standard"

    def __init__(self, *, tier=None, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.tier = tier
