# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class X12ProtocolSettings(Model):
    """The X12 agreement protocol settings.

    All required parameters must be populated in order to send to Azure.

    :param validation_settings: Required. The X12 validation settings.
    :type validation_settings: ~azure.mgmt.logic.models.X12ValidationSettings
    :param framing_settings: Required. The X12 framing settings.
    :type framing_settings: ~azure.mgmt.logic.models.X12FramingSettings
    :param envelope_settings: Required. The X12 envelope settings.
    :type envelope_settings: ~azure.mgmt.logic.models.X12EnvelopeSettings
    :param acknowledgement_settings: Required. The X12 acknowledgment
     settings.
    :type acknowledgement_settings:
     ~azure.mgmt.logic.models.X12AcknowledgementSettings
    :param message_filter: Required. The X12 message filter.
    :type message_filter: ~azure.mgmt.logic.models.X12MessageFilter
    :param security_settings: Required. The X12 security settings.
    :type security_settings: ~azure.mgmt.logic.models.X12SecuritySettings
    :param processing_settings: Required. The X12 processing settings.
    :type processing_settings: ~azure.mgmt.logic.models.X12ProcessingSettings
    :param envelope_overrides: The X12 envelope override settings.
    :type envelope_overrides:
     list[~azure.mgmt.logic.models.X12EnvelopeOverride]
    :param validation_overrides: The X12 validation override settings.
    :type validation_overrides:
     list[~azure.mgmt.logic.models.X12ValidationOverride]
    :param message_filter_list: The X12 message filter list.
    :type message_filter_list:
     list[~azure.mgmt.logic.models.X12MessageIdentifier]
    :param schema_references: Required. The X12 schema references.
    :type schema_references: list[~azure.mgmt.logic.models.X12SchemaReference]
    :param x12_delimiter_overrides: The X12 delimiter override settings.
    :type x12_delimiter_overrides:
     list[~azure.mgmt.logic.models.X12DelimiterOverrides]
    """

    _validation = {
        'validation_settings': {'required': True},
        'framing_settings': {'required': True},
        'envelope_settings': {'required': True},
        'acknowledgement_settings': {'required': True},
        'message_filter': {'required': True},
        'security_settings': {'required': True},
        'processing_settings': {'required': True},
        'schema_references': {'required': True},
    }

    _attribute_map = {
        'validation_settings': {'key': 'validationSettings', 'type': 'X12ValidationSettings'},
        'framing_settings': {'key': 'framingSettings', 'type': 'X12FramingSettings'},
        'envelope_settings': {'key': 'envelopeSettings', 'type': 'X12EnvelopeSettings'},
        'acknowledgement_settings': {'key': 'acknowledgementSettings', 'type': 'X12AcknowledgementSettings'},
        'message_filter': {'key': 'messageFilter', 'type': 'X12MessageFilter'},
        'security_settings': {'key': 'securitySettings', 'type': 'X12SecuritySettings'},
        'processing_settings': {'key': 'processingSettings', 'type': 'X12ProcessingSettings'},
        'envelope_overrides': {'key': 'envelopeOverrides', 'type': '[X12EnvelopeOverride]'},
        'validation_overrides': {'key': 'validationOverrides', 'type': '[X12ValidationOverride]'},
        'message_filter_list': {'key': 'messageFilterList', 'type': '[X12MessageIdentifier]'},
        'schema_references': {'key': 'schemaReferences', 'type': '[X12SchemaReference]'},
        'x12_delimiter_overrides': {'key': 'x12DelimiterOverrides', 'type': '[X12DelimiterOverrides]'},
    }

    def __init__(self, **kwargs):
        super(X12ProtocolSettings, self).__init__(**kwargs)
        self.validation_settings = kwargs.get('validation_settings', None)
        self.framing_settings = kwargs.get('framing_settings', None)
        self.envelope_settings = kwargs.get('envelope_settings', None)
        self.acknowledgement_settings = kwargs.get('acknowledgement_settings', None)
        self.message_filter = kwargs.get('message_filter', None)
        self.security_settings = kwargs.get('security_settings', None)
        self.processing_settings = kwargs.get('processing_settings', None)
        self.envelope_overrides = kwargs.get('envelope_overrides', None)
        self.validation_overrides = kwargs.get('validation_overrides', None)
        self.message_filter_list = kwargs.get('message_filter_list', None)
        self.schema_references = kwargs.get('schema_references', None)
        self.x12_delimiter_overrides = kwargs.get('x12_delimiter_overrides', None)
