# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VmStateDetails(Model):
    """Details about the state of the reference virtual machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar rdp_authority: The RdpAuthority property is a server DNS host name
     or IP address followed by the service port number for RDP (Remote Desktop
     Protocol).
    :vartype rdp_authority: str
    :ivar ssh_authority: The SshAuthority property is a server DNS host name
     or IP address followed by the service port number for SSH.
    :vartype ssh_authority: str
    :ivar power_state: The power state of the reference virtual machine.
    :vartype power_state: str
    :ivar last_known_power_state: Last known compute power state captured in
     DTL
    :vartype last_known_power_state: str
    """

    _validation = {
        'rdp_authority': {'readonly': True},
        'ssh_authority': {'readonly': True},
        'power_state': {'readonly': True},
        'last_known_power_state': {'readonly': True},
    }

    _attribute_map = {
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'power_state': {'key': 'powerState', 'type': 'str'},
        'last_known_power_state': {'key': 'lastKnownPowerState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VmStateDetails, self).__init__(**kwargs)
        self.rdp_authority = None
        self.ssh_authority = None
        self.power_state = None
        self.last_known_power_state = None
