# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceSettingsFragment(Model):
    """Represents resource specific settings.

    :param gallery_image_resource_id: The resource id of the gallery image
     used for creating the virtual machine
    :type gallery_image_resource_id: str
    :param size: The size of the virtual machine. Possible values include:
     'Basic', 'Standard', 'Performance'
    :type size: str or ~azure.mgmt.labservices.models.ManagedLabVmSize
    :param reference_vm: Details specific to Reference Vm
    :type reference_vm: ~azure.mgmt.labservices.models.ReferenceVmFragment
    """

    _attribute_map = {
        'gallery_image_resource_id': {'key': 'galleryImageResourceId', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'reference_vm': {'key': 'referenceVm', 'type': 'ReferenceVmFragment'},
    }

    def __init__(self, **kwargs):
        super(ResourceSettingsFragment, self).__init__(**kwargs)
        self.gallery_image_resource_id = kwargs.get('gallery_image_resource_id', None)
        self.size = kwargs.get('size', None)
        self.reference_vm = kwargs.get('reference_vm', None)
