# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ReferenceVm(Model):
    """Details of a Reference Vm.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param user_name: Required. The username of the virtual machine
    :type user_name: str
    :param password: The password of the virtual machine. This will be set to
     null in GET resource API
    :type password: str
    :ivar vm_state_details: The state details for the reference virtual
     machine.
    :vartype vm_state_details: ~azure.mgmt.labservices.models.VmStateDetails
    :ivar vm_resource_id: VM resource Id for the environment
    :vartype vm_resource_id: str
    """

    _validation = {
        'user_name': {'required': True},
        'vm_state_details': {'readonly': True},
        'vm_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'vm_state_details': {'key': 'vmStateDetails', 'type': 'VmStateDetails'},
        'vm_resource_id': {'key': 'vmResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReferenceVm, self).__init__(**kwargs)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.vm_state_details = None
        self.vm_resource_id = None
