# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class GalleryImage(Resource):
    """Represents an image from the Azure Marketplace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :ivar author: The author of the gallery image.
    :vartype author: str
    :ivar created_date: The creation date of the gallery image.
    :vartype created_date: datetime
    :ivar description: The description of the gallery image.
    :vartype description: str
    :ivar image_reference: The image reference of the gallery image.
    :vartype image_reference:
     ~azure.mgmt.labservices.models.GalleryImageReference
    :ivar icon: The icon of the gallery image.
    :vartype icon: str
    :param is_enabled: Indicates whether this gallery image is enabled.
    :type is_enabled: bool
    :param is_override: Indicates whether this gallery has been overridden for
     this lab account
    :type is_override: bool
    :ivar plan_id: The third party plan that applies to this image
    :vartype plan_id: str
    :param is_plan_authorized: Indicates if the plan has been authorized for
     programmatic deployment.
    :type is_plan_authorized: bool
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex:
     status, error
    :vartype latest_operation_result:
     ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'author': {'readonly': True},
        'created_date': {'readonly': True},
        'description': {'readonly': True},
        'image_reference': {'readonly': True},
        'icon': {'readonly': True},
        'plan_id': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'image_reference': {'key': 'properties.imageReference', 'type': 'GalleryImageReference'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'is_override': {'key': 'properties.isOverride', 'type': 'bool'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(self, **kwargs):
        super(GalleryImage, self).__init__(**kwargs)
        self.author = None
        self.created_date = None
        self.description = None
        self.image_reference = None
        self.icon = None
        self.is_enabled = kwargs.get('is_enabled', None)
        self.is_override = kwargs.get('is_override', None)
        self.plan_id = None
        self.is_plan_authorized = kwargs.get('is_plan_authorized', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None
