# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserAccessRight(Model):
    """The mapping between a particular user and the access type on the SMB share.

    All required parameters must be populated in order to send to Azure.

    :param user_id: Required. User ID (already existing in the device).
    :type user_id: str
    :param access_type: Required. Type of access to be allowed for the user.
     Possible values include: 'Change', 'Read', 'Custom'
    :type access_type: str or ~azure.mgmt.edgegateway.models.ShareAccessType
    """

    _validation = {
        'user_id': {'required': True},
        'access_type': {'required': True},
    }

    _attribute_map = {
        'user_id': {'key': 'userId', 'type': 'str'},
        'access_type': {'key': 'accessType', 'type': 'str'},
    }

    def __init__(self, *, user_id: str, access_type, **kwargs) -> None:
        super(UserAccessRight, self).__init__(**kwargs)
        self.user_id = user_id
        self.access_type = access_type
