# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset import Dataset


class SapOpenHubTableDataset(Dataset):
    """Sap Business Warehouse Open Hub Destination Table properties.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type:
     array (or Expression with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the
     dataset. Type: array (or Expression with resultType array), itemType:
     DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str,
     ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the
     Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified,
     Dataset will appear at the root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param type: Required. Constant filled by server.
    :type type: str
    :param open_hub_destination_name: Required. The name of the Open Hub
     Destination with destination type as Database Table. Type: string (or
     Expression with resultType string).
    :type open_hub_destination_name: object
    :param exclude_last_request: Whether to exclude the records of the last
     request. The default value is true. Type: boolean (or Expression with
     resultType boolean).
    :type exclude_last_request: object
    :param base_request_id: The ID of request for delta loading. Once it is
     set, only data with requestId larger than the value of this property will
     be retrieved. The default value is 0. Type: integer (or Expression with
     resultType integer ).
    :type base_request_id: object
    """

    _validation = {
        'linked_service_name': {'required': True},
        'type': {'required': True},
        'open_hub_destination_name': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'type': {'key': 'type', 'type': 'str'},
        'open_hub_destination_name': {'key': 'typeProperties.openHubDestinationName', 'type': 'object'},
        'exclude_last_request': {'key': 'typeProperties.excludeLastRequest', 'type': 'object'},
        'base_request_id': {'key': 'typeProperties.baseRequestId', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(SapOpenHubTableDataset, self).__init__(**kwargs)
        self.open_hub_destination_name = kwargs.get('open_hub_destination_name', None)
        self.exclude_last_request = kwargs.get('exclude_last_request', None)
        self.base_request_id = kwargs.get('base_request_id', None)
        self.type = 'SapOpenHubTable'
