# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset import Dataset


class DelimitedTextDataset(Dataset):
    """Delimited text dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type:
     array (or Expression with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param schema: Columns that define the physical type schema of the
     dataset. Type: array (or Expression with resultType array), itemType:
     DatasetSchemaDataElement.
    :type schema: object
    :param linked_service_name: Required. Linked service reference.
    :type linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str,
     ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param annotations: List of tags that can be used for describing the
     Dataset.
    :type annotations: list[object]
    :param folder: The folder that this Dataset is in. If not specified,
     Dataset will appear at the root level.
    :type folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :param type: Required. Constant filled by server.
    :type type: str
    :param location: Required. The location of the delimited text storage.
    :type location: ~azure.mgmt.datafactory.models.DatasetLocation
    :param column_delimiter: The column delimiter. Type: string (or Expression
     with resultType string).
    :type column_delimiter: object
    :param row_delimiter: The row delimiter. Type: string (or Expression with
     resultType string).
    :type row_delimiter: object
    :param encoding_name: The code page name of the preferred encoding. If
     miss, the default value is UTF-8, unless BOM denotes another Unicode
     encoding. Refer to the name column of the table in the following link to
     set supported values:
     https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string
     (or Expression with resultType string).
    :type encoding_name: object
    :param compression_codec:
    :type compression_codec: object
    :param compression_level: The data compression method used for
     DelimitedText.
    :type compression_level: object
    :param quote_char: The quote character. Type: string (or Expression with
     resultType string).
    :type quote_char: object
    :param escape_char: The escape character. Type: string (or Expression with
     resultType string).
    :type escape_char: object
    :param first_row_as_header: When used as input, treat the first row of
     data as headers. When used as output,write the headers into the output as
     the first row of data. The default value is false. Type: boolean (or
     Expression with resultType boolean).
    :type first_row_as_header: object
    :param null_value: The null value string. Type: string (or Expression with
     resultType string).
    :type null_value: object
    """

    _validation = {
        'linked_service_name': {'required': True},
        'type': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'schema': {'key': 'schema', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'folder': {'key': 'folder', 'type': 'DatasetFolder'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'typeProperties.location', 'type': 'DatasetLocation'},
        'column_delimiter': {'key': 'typeProperties.columnDelimiter', 'type': 'object'},
        'row_delimiter': {'key': 'typeProperties.rowDelimiter', 'type': 'object'},
        'encoding_name': {'key': 'typeProperties.encodingName', 'type': 'object'},
        'compression_codec': {'key': 'typeProperties.compressionCodec', 'type': 'object'},
        'compression_level': {'key': 'typeProperties.compressionLevel', 'type': 'object'},
        'quote_char': {'key': 'typeProperties.quoteChar', 'type': 'object'},
        'escape_char': {'key': 'typeProperties.escapeChar', 'type': 'object'},
        'first_row_as_header': {'key': 'typeProperties.firstRowAsHeader', 'type': 'object'},
        'null_value': {'key': 'typeProperties.nullValue', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(DelimitedTextDataset, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.column_delimiter = kwargs.get('column_delimiter', None)
        self.row_delimiter = kwargs.get('row_delimiter', None)
        self.encoding_name = kwargs.get('encoding_name', None)
        self.compression_codec = kwargs.get('compression_codec', None)
        self.compression_level = kwargs.get('compression_level', None)
        self.quote_char = kwargs.get('quote_char', None)
        self.escape_char = kwargs.get('escape_char', None)
        self.first_row_as_header = kwargs.get('first_row_as_header', None)
        self.null_value = kwargs.get('null_value', None)
        self.type = 'DelimitedText'
