# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import AzureStackManagementClientConfiguration
from .operations import Operations
from .operations import ProductsOperations
from .operations import RegistrationsOperations
from .operations import CustomerSubscriptionsOperations
from . import models


class AzureStackManagementClient(SDKClient):
    """Azure Stack

    :ivar config: Configuration for client.
    :vartype config: AzureStackManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.azurestack.operations.Operations
    :ivar products: Products operations
    :vartype products: azure.mgmt.azurestack.operations.ProductsOperations
    :ivar registrations: Registrations operations
    :vartype registrations: azure.mgmt.azurestack.operations.RegistrationsOperations
    :ivar customer_subscriptions: CustomerSubscriptions operations
    :vartype customer_subscriptions: azure.mgmt.azurestack.operations.CustomerSubscriptionsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials that uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = AzureStackManagementClientConfiguration(credentials, subscription_id, base_url)
        super(AzureStackManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2017-06-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.products = ProductsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.registrations = RegistrationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.customer_subscriptions = CustomerSubscriptionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
