# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserEntityBaseParameters(Model):
    """User Entity Base Parameters set.

    :param state: Account state. Specifies whether the user is active or not.
     Blocked users are unable to sign into the developer portal or call any
     APIs of subscribed products. Default state is Active. Possible values
     include: 'active', 'blocked', 'pending', 'deleted'. Default value:
     "active" .
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities:
     list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
    }

    def __init__(self, **kwargs):
        super(UserEntityBaseParameters, self).__init__(**kwargs)
        self.state = kwargs.get('state', "active")
        self.note = kwargs.get('note', None)
        self.identities = kwargs.get('identities', None)
