
%{
/*#define YYSTYPE 	char**/
/*#define DEBUG*/
#include "macro.h"
#include "string.h"
%}

%union {
	char *text;
	char c;
}

%token <text> VARID
%token <text> VALID
%token <text> OWNERID

%token ERROR
%token EOFTOK


%{
char left[80], right[80], owner[80];
char type = 0; /*unused*/
%}

%%


block:
	blockstatement
	| block  blockstatement
	;
	
blockstatement:
	owner '{' commandline '}'
	;	
	
commandline: 
	command | commandline command
	;
	
command:
	varpart '=' valpart { found(left,right,owner); }
	;
	
owner:
	OWNERID	{
			DBG("Owner %s\n",$1);
			strncpy(owner,$1,strlen($1)+1);
		}
	;

varpart:
	VARID	{
			DBG("Left %s\n",$1);
			strncpy(left,$1,strlen($1)+1);
		}
	;
	
valpart:
	VALID	{
			DBG("Right %s\n",$1);
			strncpy(right,$1,strlen($1)+1);
		}
	;

%%

#include <ctype.h>
#include <stdio.h>
#include "structs.h"

extern struct wlp_list_t *list;

int yyerror (char *s)  /* Called by yyparse on error */
{
	printf ("error: %s\n", s);
	return 1;
}

int found(const char* left, const char* right, const char *owner)
{
	static struct wlp_node_t *node;

	/* alloc node with non-empty fields (ie alloc them too)*/
	node = wlpn_alloc(FALSE);
	if(!node) {
		DBG("wlpn_alloc in found returned NULL\n");
	}
	
	strncpy(node->right,right,strlen(right));
	strncpy(node->left,left,strlen(left));
	strncpy(node->owner,owner,strlen(owner));

	#ifndef WITHQUOTES
	/* remove quotes of value part */
	node->right += 1;
	node->right[strlen(node->right)-1] = '\0';
	#endif
	#ifndef WITHANGBRACKETS
	/* remove angle brackets of owner part */
	node->owner += 1;
	node->owner[strlen(node->owner)-1] = '\0';
	#endif

	if(!list)
		list = wlpl_init(node);
	else
		wlpn_add(list,node);
}
