/* primax_scan -- linux driver for Primax scanners

   Authors:
   Marco Foglia <Marco.Foglia@switzerland.org>
   Thomas Schano <schano@t-online.de>
   Christian Ordig <chr.ordig@gmx.net>

   Copyright (C) 1999 Marco Foglia, Thomas Schano, Christian Ordig

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*/

/* size of scanner area in inch */
#define MAX_WIDTH                 8.5    // inch
#define MAX_HEIGHT                11.7  // inch

/* table for transfer funktion, 30 Bit to 24 Bit */
#define color_table_size  0x400 // 10 Bit form DAC

/* Calibration uses an image of the array under the */
/* top scale */
#define CALIBRATION_ARRAY_SIZE 0.4           // inch
#define CALIBRATION_WHITE_ARRAY_START 0.1    // inch
#define CALIBRATION_BLACK_ARRAY_START 0.3    // inch
#define CALIBRATION_SCAN_SIZE 0.1            // inch

#define X_RESOLUTION RESOLUTION  
#define Y_RESOLUTION RESOLUTION    

/* offset of colors in lines (distance 1/75 inch each)*/
#define COLOR_SPACING 1 / 75 // inch

#define RED_OFFSET    0 * RESOLUTION * COLOR_SPACING
#define GREEN_OFFSET  1 * RESOLUTION * COLOR_SPACING           
#define BLUE_OFFSET   2 * RESOLUTION * COLOR_SPACING           

#define XRES    X_RESOLUTION * MAX_WIDTH
#define YRES    Y_RESOLUTION * MAX_HEIGHT

#define x_table_size XRES
#define y_table_size YRES
#define LM9811_PGA_array_size 3 * x_table_size

/* resolution of scanner */
extern int RESOLUTION;

void calc_color_table (scan_image *image);
void calc_x_table(scan_image *image);
void calc_y_table(scan_image *image);






