use Wx;
use strict;

use Wx qw( wxDefaultSize wxDefaultPosition wxNullAnimation wxNullFont wxBLACK );
use Wx qw( wxID_OK wxID_APPLY wxID_SAVE wxID_SAVEAS wxID_CANCEL wxID_YES wxID_NO wxID_EXIT wxID_ABOUT wxID_HELP );
use Wx qw( wxVERTICAL wxHORIZONTAL wxALL wxLEFT wxRIGHT wxTOP wxBOTTOM wxCENTRE wxGROW );
use Wx qw( wxALIGN_RIGHT wxALIGN_BOTTOM wxALIGN_CENTER wxALIGN_CENTER_VERTICAL wxALIGN_CENTER_HORIZONTAL );
use Wx qw( wxRA_SPECIFY_COLS );

# Bitmap functions

use Wx qw( wxNullBitmap wxBITMAP_TYPE_PNG );

# Window functions

use vars qw($ID_REUPLOAD_TEXT); $ID_REUPLOAD_TEXT = 10000;
use vars qw($ID_REUPLOAD_ACTION_FILES); $ID_REUPLOAD_ACTION_FILES = 10001;
use vars qw($ID_REUPLOAD_ACTION_PROPERTIES); $ID_REUPLOAD_ACTION_PROPERTIES = 10002;
use vars qw($ID_REUPLOAD_ACTION_PROPERTIES_M); $ID_REUPLOAD_ACTION_PROPERTIES_M = 10003;
use vars qw($ID_REUPLOAD_NOT_ASK); $ID_REUPLOAD_NOT_ASK = 10004;
use vars qw($ID_REUPLOAD_OK); $ID_REUPLOAD_OK = 10005;

sub Reupload {
    my( $parent ) = $_[0];
    my( $item0 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item1 ) = Wx::StaticText->new( $parent, $main::ID_REUPLOAD_TEXT, "Some photos in the selection have already been uploaded. What do you want to do ?", wxDefaultPosition, wxDefaultSize, 0 );
    $item0->AddWindow( $item1, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item2 ) = Wx::RadioBox->new( $parent, $main::ID_REUPLOAD_ACTION_FILES, "Thumbnail, web size, high definition files", wxDefaultPosition, [600,-1], 
        ["nothing","replace"] , 1, wxRA_SPECIFY_COLS );
    $item0->AddWindow( $item2, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item3 ) = Wx::RadioBox->new( $parent, $main::ID_REUPLOAD_ACTION_PROPERTIES, "Title, description, author, created date )", wxDefaultPosition, [600,-1], 
        ["nothing","append ( keep existing and set if not defined in Piwigo )","replace"] , 1, wxRA_SPECIFY_COLS );
    $item0->AddWindow( $item3, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item4 ) = Wx::RadioBox->new( $parent, $main::ID_REUPLOAD_ACTION_PROPERTIES_M, "Categories, tags", wxDefaultPosition, [600,-1], 
        ["nothing","append ( keep existing and add new )","replace"] , 1, wxRA_SPECIFY_COLS );
    $item0->AddWindow( $item4, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item5 ) = Wx::CheckBox->new( $parent, $main::ID_REUPLOAD_NOT_ASK, "Do not ask me again", wxDefaultPosition, wxDefaultSize, 0 );
    $item0->AddWindow( $item5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item6 ) = Wx::Button->new( $parent, $main::ID_REUPLOAD_OK, "OK", wxDefaultPosition, wxDefaultSize, 0 );
    $item0->AddWindow( $item6, 0, wxALIGN_CENTER|wxALL, 5 );

    $_[0]->SetSizer( $item0 );
    $item0->SetSizeHints( $_[0] );

    $item0;
}

use Wx qw( wxITEM_NORMAL wxITEM_RADIO wxITEM_CHECK );


