#!/bin/bash
# Bundles required boost headers into pxc-5.7 release tarball

set -ex

version=$1
boost_version=1_59_0

TMPDIR=$(mktemp -d)

echo "Installing to $TMPDIR for percona-xtradb-cluster-5.7 $version"

mkdir -p $TMPDIR/lib

wget -O $TMPDIR/boost_${boost_version}.tar.gz http://jenkins.percona.com/downloads/boost/boost_${boost_version}.tar.gz
tar -xzf $TMPDIR/boost_${boost_version}.tar.gz --directory $TMPDIR/lib
mkdir -p $TMPDIR/lib/percona-xtradb-cluster-${version}
tar -xzf ../percona-xtradb-cluster-5.7_${version}.orig.tar.gz --strip-components=1 \
    --directory $TMPDIR/lib/percona-xtradb-cluster-${version}

(
    cd $TMPDIR/lib
    mkdir -p $TMPDIR/lib/percona-xtradb-cluster-${version}/boost/boost_${boost_version}
    mv boost_${boost_version}/boost $TMPDIR/lib/percona-xtradb-cluster-${version}/boost/boost_${boost_version}
    tar -cJf percona-xtradb-cluster-5.7_${version}.orig.tar.xz percona-xtradb-cluster-${version}
)

mv  $TMPDIR/lib/percona-xtradb-cluster-5.7_${version}.orig.tar.xz ..
rm -rf $TMPDIR
