/* Copyright (c) 2003-2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA */


#include <kernel_types.h>
#include <BlockNumbers.h>
#include <signaldata/SystemError.hpp>

bool
printSYSTEM_ERROR(FILE * output, const Uint32 * theData, Uint32 len, 
		  Uint16 receiverBlockNo){

  const SystemError * const sig = (SystemError *) theData;

  fprintf(output, "errorRef: H\'%.8x\n", 
	  sig->errorRef);   
  fprintf(output, "errorCode: %d\n", 
	  sig->errorCode);  
  fprintf(output, "data1: H\'%.8x\n", 
	  sig->data1);   
  fprintf(output, "data2: H\'%.8x\n", 
	  sig->data2);    

  return true;
}


