/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <AppearanceAttributes.h>
#include <DataNode.h>

// Type map format string
const char *AppearanceAttributes::TypeMapFormatString = "bssssissssi";

// ****************************************************************************
// Method: AppearanceAttributes::AppearanceAttributes
//
// Purpose: 
//   Constructor for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AppearanceAttributes::AppearanceAttributes() : 
    AttributeSubject(AppearanceAttributes::TypeMapFormatString)
{
    useSystemDefault = true;
    background = "#c0c0c0";
    foreground = "#000000";
    fontName = "Helvetica,12,-1,5,50,0,0,0,0,0";
    InitializeStyle();
    orientation = 0;
}

// ****************************************************************************
// Method: AppearanceAttributes::AppearanceAttributes
//
// Purpose: 
//   Copy constructor for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AppearanceAttributes::AppearanceAttributes(const AppearanceAttributes &obj) : 
    AttributeSubject(AppearanceAttributes::TypeMapFormatString)
{
    useSystemDefault = obj.useSystemDefault;
    background = obj.background;
    foreground = obj.foreground;
    fontName = obj.fontName;
    style = obj.style;
    orientation = obj.orientation;
    defaultForeground = obj.defaultForeground;
    defaultBackground = obj.defaultBackground;
    defaultFontName = obj.defaultFontName;
    defaultStyle = obj.defaultStyle;
    defaultOrientation = obj.defaultOrientation;

    SelectAll();
}

// ****************************************************************************
// Method: AppearanceAttributes::~AppearanceAttributes
//
// Purpose: 
//   Destructor for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AppearanceAttributes::~AppearanceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: AppearanceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AppearanceAttributes& 
AppearanceAttributes::operator = (const AppearanceAttributes &obj)
{
    if (this == &obj) return *this;
    useSystemDefault = obj.useSystemDefault;
    background = obj.background;
    foreground = obj.foreground;
    fontName = obj.fontName;
    style = obj.style;
    orientation = obj.orientation;
    defaultForeground = obj.defaultForeground;
    defaultBackground = obj.defaultBackground;
    defaultFontName = obj.defaultFontName;
    defaultStyle = obj.defaultStyle;
    defaultOrientation = obj.defaultOrientation;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: AppearanceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AppearanceAttributes::operator == (const AppearanceAttributes &obj) const
{
    // Create the return value
    return ((useSystemDefault == obj.useSystemDefault) &&
            (background == obj.background) &&
            (foreground == obj.foreground) &&
            (fontName == obj.fontName) &&
            (style == obj.style) &&
            (orientation == obj.orientation) &&
            (defaultForeground == obj.defaultForeground) &&
            (defaultBackground == obj.defaultBackground) &&
            (defaultFontName == obj.defaultFontName) &&
            (defaultStyle == obj.defaultStyle) &&
            (defaultOrientation == obj.defaultOrientation));
}

// ****************************************************************************
// Method: AppearanceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AppearanceAttributes::operator != (const AppearanceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AppearanceAttributes::TypeName
//
// Purpose: 
//   Type name method for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
AppearanceAttributes::TypeName() const
{
    return "AppearanceAttributes";
}

// ****************************************************************************
// Method: AppearanceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AppearanceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AppearanceAttributes *tmp = (const AppearanceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AppearanceAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AppearanceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AppearanceAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AppearanceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the AppearanceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AppearanceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AppearanceAttributes(*this);
    else
        retval = new AppearanceAttributes;

    return retval;
}

// ****************************************************************************
// Method: AppearanceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AppearanceAttributes::SelectAll()
{
    Select(ID_useSystemDefault,   (void *)&useSystemDefault);
    Select(ID_background,         (void *)&background);
    Select(ID_foreground,         (void *)&foreground);
    Select(ID_fontName,           (void *)&fontName);
    Select(ID_style,              (void *)&style);
    Select(ID_orientation,        (void *)&orientation);
    Select(ID_defaultForeground,  (void *)&defaultForeground);
    Select(ID_defaultBackground,  (void *)&defaultBackground);
    Select(ID_defaultFontName,    (void *)&defaultFontName);
    Select(ID_defaultStyle,       (void *)&defaultStyle);
    Select(ID_defaultOrientation, (void *)&defaultOrientation);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AppearanceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AppearanceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AppearanceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for AppearanceAttributes.
    DataNode *node = new DataNode("AppearanceAttributes");

    if(completeSave || !FieldsEqual(ID_useSystemDefault, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useSystemDefault", useSystemDefault));
    }

    if(completeSave || !FieldsEqual(ID_background, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("background", background));
    }

    if(completeSave || !FieldsEqual(ID_foreground, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("foreground", foreground));
    }

    if(completeSave || !FieldsEqual(ID_fontName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontName", fontName));
    }

    if(completeSave || !FieldsEqual(ID_style, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("style", style));
    }

    if(completeSave || !FieldsEqual(ID_orientation, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("orientation", orientation));
    }

    if(completeSave || !FieldsEqual(ID_defaultForeground, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("defaultForeground", defaultForeground));
    }

    if(completeSave || !FieldsEqual(ID_defaultBackground, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("defaultBackground", defaultBackground));
    }

    if(completeSave || !FieldsEqual(ID_defaultFontName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("defaultFontName", defaultFontName));
    }

    if(completeSave || !FieldsEqual(ID_defaultStyle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("defaultStyle", defaultStyle));
    }

    if(completeSave || !FieldsEqual(ID_defaultOrientation, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("defaultOrientation", defaultOrientation));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AppearanceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AppearanceAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AppearanceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useSystemDefault")) != 0)
        SetUseSystemDefault(node->AsBool());
    if((node = searchNode->GetNode("background")) != 0)
        SetBackground(node->AsString());
    if((node = searchNode->GetNode("foreground")) != 0)
        SetForeground(node->AsString());
    if((node = searchNode->GetNode("fontName")) != 0)
        SetFontName(node->AsString());
    if((node = searchNode->GetNode("style")) != 0)
        SetStyle(node->AsString());
    if((node = searchNode->GetNode("orientation")) != 0)
        SetOrientation(node->AsInt());
    if((node = searchNode->GetNode("defaultForeground")) != 0)
        SetDefaultForeground(node->AsString());
    if((node = searchNode->GetNode("defaultBackground")) != 0)
        SetDefaultBackground(node->AsString());
    if((node = searchNode->GetNode("defaultFontName")) != 0)
        SetDefaultFontName(node->AsString());
    if((node = searchNode->GetNode("defaultStyle")) != 0)
        SetDefaultStyle(node->AsString());
    if((node = searchNode->GetNode("defaultOrientation")) != 0)
        SetDefaultOrientation(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AppearanceAttributes::SetUseSystemDefault(bool useSystemDefault_)
{
    useSystemDefault = useSystemDefault_;
    Select(ID_useSystemDefault, (void *)&useSystemDefault);
}

void
AppearanceAttributes::SetBackground(const std::string &background_)
{
    background = background_;
    Select(ID_background, (void *)&background);
}

void
AppearanceAttributes::SetForeground(const std::string &foreground_)
{
    foreground = foreground_;
    Select(ID_foreground, (void *)&foreground);
}

void
AppearanceAttributes::SetFontName(const std::string &fontName_)
{
    fontName = fontName_;
    Select(ID_fontName, (void *)&fontName);
}

void
AppearanceAttributes::SetStyle(const std::string &style_)
{
    style = style_;
    Select(ID_style, (void *)&style);
}

void
AppearanceAttributes::SetOrientation(int orientation_)
{
    orientation = orientation_;
    Select(ID_orientation, (void *)&orientation);
}

void
AppearanceAttributes::SetDefaultForeground(const std::string &defaultForeground_)
{
    defaultForeground = defaultForeground_;
    Select(ID_defaultForeground, (void *)&defaultForeground);
}

void
AppearanceAttributes::SetDefaultBackground(const std::string &defaultBackground_)
{
    defaultBackground = defaultBackground_;
    Select(ID_defaultBackground, (void *)&defaultBackground);
}

void
AppearanceAttributes::SetDefaultFontName(const std::string &defaultFontName_)
{
    defaultFontName = defaultFontName_;
    Select(ID_defaultFontName, (void *)&defaultFontName);
}

void
AppearanceAttributes::SetDefaultStyle(const std::string &defaultStyle_)
{
    defaultStyle = defaultStyle_;
    Select(ID_defaultStyle, (void *)&defaultStyle);
}

void
AppearanceAttributes::SetDefaultOrientation(int defaultOrientation_)
{
    defaultOrientation = defaultOrientation_;
    Select(ID_defaultOrientation, (void *)&defaultOrientation);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
AppearanceAttributes::GetUseSystemDefault() const
{
    return useSystemDefault;
}

const std::string &
AppearanceAttributes::GetBackground() const
{
    return background;
}

std::string &
AppearanceAttributes::GetBackground()
{
    return background;
}

const std::string &
AppearanceAttributes::GetForeground() const
{
    return foreground;
}

std::string &
AppearanceAttributes::GetForeground()
{
    return foreground;
}

const std::string &
AppearanceAttributes::GetFontName() const
{
    return fontName;
}

std::string &
AppearanceAttributes::GetFontName()
{
    return fontName;
}

const std::string &
AppearanceAttributes::GetStyle() const
{
    return style;
}

std::string &
AppearanceAttributes::GetStyle()
{
    return style;
}

int
AppearanceAttributes::GetOrientation() const
{
    return orientation;
}

const std::string &
AppearanceAttributes::GetDefaultForeground() const
{
    return defaultForeground;
}

std::string &
AppearanceAttributes::GetDefaultForeground()
{
    return defaultForeground;
}

const std::string &
AppearanceAttributes::GetDefaultBackground() const
{
    return defaultBackground;
}

std::string &
AppearanceAttributes::GetDefaultBackground()
{
    return defaultBackground;
}

const std::string &
AppearanceAttributes::GetDefaultFontName() const
{
    return defaultFontName;
}

std::string &
AppearanceAttributes::GetDefaultFontName()
{
    return defaultFontName;
}

const std::string &
AppearanceAttributes::GetDefaultStyle() const
{
    return defaultStyle;
}

std::string &
AppearanceAttributes::GetDefaultStyle()
{
    return defaultStyle;
}

int
AppearanceAttributes::GetDefaultOrientation() const
{
    return defaultOrientation;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AppearanceAttributes::SelectBackground()
{
    Select(ID_background, (void *)&background);
}

void
AppearanceAttributes::SelectForeground()
{
    Select(ID_foreground, (void *)&foreground);
}

void
AppearanceAttributes::SelectFontName()
{
    Select(ID_fontName, (void *)&fontName);
}

void
AppearanceAttributes::SelectStyle()
{
    Select(ID_style, (void *)&style);
}

void
AppearanceAttributes::SelectDefaultForeground()
{
    Select(ID_defaultForeground, (void *)&defaultForeground);
}

void
AppearanceAttributes::SelectDefaultBackground()
{
    Select(ID_defaultBackground, (void *)&defaultBackground);
}

void
AppearanceAttributes::SelectDefaultFontName()
{
    Select(ID_defaultFontName, (void *)&defaultFontName);
}

void
AppearanceAttributes::SelectDefaultStyle()
{
    Select(ID_defaultStyle, (void *)&defaultStyle);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AppearanceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AppearanceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_useSystemDefault:   return "useSystemDefault";
    case ID_background:         return "background";
    case ID_foreground:         return "foreground";
    case ID_fontName:           return "fontName";
    case ID_style:              return "style";
    case ID_orientation:        return "orientation";
    case ID_defaultForeground:  return "defaultForeground";
    case ID_defaultBackground:  return "defaultBackground";
    case ID_defaultFontName:    return "defaultFontName";
    case ID_defaultStyle:       return "defaultStyle";
    case ID_defaultOrientation: return "defaultOrientation";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AppearanceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AppearanceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_useSystemDefault:   return FieldType_bool;
    case ID_background:         return FieldType_string;
    case ID_foreground:         return FieldType_string;
    case ID_fontName:           return FieldType_string;
    case ID_style:              return FieldType_string;
    case ID_orientation:        return FieldType_int;
    case ID_defaultForeground:  return FieldType_string;
    case ID_defaultBackground:  return FieldType_string;
    case ID_defaultFontName:    return FieldType_string;
    case ID_defaultStyle:       return FieldType_string;
    case ID_defaultOrientation: return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AppearanceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AppearanceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_useSystemDefault:   return "bool";
    case ID_background:         return "string";
    case ID_foreground:         return "string";
    case ID_fontName:           return "string";
    case ID_style:              return "string";
    case ID_orientation:        return "int";
    case ID_defaultForeground:  return "string";
    case ID_defaultBackground:  return "string";
    case ID_defaultFontName:    return "string";
    case ID_defaultStyle:       return "string";
    case ID_defaultOrientation: return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AppearanceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AppearanceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AppearanceAttributes &obj = *((const AppearanceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_useSystemDefault:
        {  // new scope
        retval = (useSystemDefault == obj.useSystemDefault);
        }
        break;
    case ID_background:
        {  // new scope
        retval = (background == obj.background);
        }
        break;
    case ID_foreground:
        {  // new scope
        retval = (foreground == obj.foreground);
        }
        break;
    case ID_fontName:
        {  // new scope
        retval = (fontName == obj.fontName);
        }
        break;
    case ID_style:
        {  // new scope
        retval = (style == obj.style);
        }
        break;
    case ID_orientation:
        {  // new scope
        retval = (orientation == obj.orientation);
        }
        break;
    case ID_defaultForeground:
        {  // new scope
        retval = (defaultForeground == obj.defaultForeground);
        }
        break;
    case ID_defaultBackground:
        {  // new scope
        retval = (defaultBackground == obj.defaultBackground);
        }
        break;
    case ID_defaultFontName:
        {  // new scope
        retval = (defaultFontName == obj.defaultFontName);
        }
        break;
    case ID_defaultStyle:
        {  // new scope
        retval = (defaultStyle == obj.defaultStyle);
        }
        break;
    case ID_defaultOrientation:
        {  // new scope
        retval = (defaultOrientation == obj.defaultOrientation);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

#if defined(_WIN32)
#include <windows.h>
#endif
void
AppearanceAttributes::InitializeStyle()
{
#if defined(_WIN32)
    char  tmp[20];
    DWORD c;
    unsigned char *cptr = (unsigned char *)&c;

    c = GetSysColor(COLOR_BTNFACE);
    sprintf(tmp, "#%02x%02x%02x", int(cptr[0]), int(cptr[1]), int(cptr[2]));
    background = tmp;

    c = GetSysColor(COLOR_WINDOWTEXT);
    sprintf(tmp, "#%02x%02x%02x", int(cptr[0]), int(cptr[1]), int(cptr[2]));
    foreground = tmp;

    style = "windows";
#elif defined(__APPLE__)
    style = "macintosh";
#else
    style = "motif";
#endif
}

