/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;

public abstract class BaseNormal
extends BaseGeometricPropertyNode
implements VRMLNormalNodeType {
    protected static final int FIELD_VECTOR = 1;
    protected static final int LAST_NORMAL_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfVector = FieldConstants.EMPTY_MFVEC3F;
    protected int numVector;

    protected BaseNormal() {
        super("Normal");
        this.hasChanged = new boolean[2];
    }

    public BaseNormal(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("vector");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfVector = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfVector, 0, vRMLFieldData.numElements * 3);
                this.numVector = vRMLFieldData.numElements * 3;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setVector(float[] fArray, int n) {
        if (n > this.vfVector.length) {
            this.vfVector = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfVector, 0, fArray.length);
        this.numVector = n;
        if (!this.inSetup) {
            this.fireComponentChanged(1);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public int getNumNormals() {
        return this.numVector;
    }

    public void getVector(float[] fArray) {
        System.arraycopy(this.vfVector, 0, fArray, 0, this.numVector);
    }

    public float[] getVectorRef() {
        return this.vfVector;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 34;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfVector;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numVector / 3;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfVector, this.numVector);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setVector(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseNormal.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseNormal.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFVec3f", "vector");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("vector", n);
        fieldMap.put("set_vector", n);
        fieldMap.put("vector_changed", n);
    }
}

