///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/******************************************************************************
* Defines macros for debugging purposes.
******************************************************************************/

#ifndef __OVITO_DEBUGGING_H
#define __OVITO_DEBUGGING_H

/******************************************************************************
* Activate the debug heap.
******************************************************************************/
#if defined(_DEBUG) && defined(Q_CC_MSVC)  // Microsoft Visual C++
#include <crtdbg.h>
#ifndef DEBUG_NEW
#define DEBUG_NEW new(_NORMAL_BLOCK, __FILE__, __LINE__)
#endif
#else
#ifndef DEBUG_NEW
#define DEBUG_NEW new
#endif
#endif

namespace Base {

/******************************************************************************
* This macro performs a runtime-time check.
******************************************************************************/
#define OVITO_ASSERT Q_ASSERT

/******************************************************************************
* This macro performs a runtime-time check.
******************************************************************************/
#define OVITO_ASSERT_MSG Q_ASSERT_X

/******************************************************************************
* This macro performs a compile-time check.
******************************************************************************/
#define OVITO_STATIC_ASSERT(condition) BOOST_STATIC_ASSERT(condition)

/******************************************************************************
* This macro validates a memory pointer in debug mode.
* If the given pointer does not point to a valid position in memory then
* the debugger is activated.
******************************************************************************/
#ifdef _DEBUG

	#ifdef Q_CC_MSVC  // Microsoft Visual C++

		template <typename T>
		inline bool _IsValidPointer(T* objPointer) { 
			return _CrtIsValidPointer(objPointer, sizeof(T), true); 
		}
		
		#define CHECK_POINTER(pointer) OVITO_ASSERT_MSG(_IsValidPointer(pointer), "CHECK_POINTER", "Invalid object pointer.");

	#else		// Non Microsoft compiler

		#define CHECK_POINTER(pointer) OVITO_ASSERT_MSG((pointer) != NULL, "CHECK_POINTER", "Invalid object pointer.");

	#endif

#else	// in release mode

	#define CHECK_POINTER(pointer)

#endif

};	// End of namespace Base

#endif // __OVITO_DEBUGGING_H
