/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SOFTWAREUPDATECONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_SOFTWAREUPDATECONFORMSTOPROFILEACCESS_H_

#include "SoftwareUpdate_Common.h"

#include "OpenDRIM_SoftwareUpdateConformsToProfile.h"
#include "assocOpenDRIM_SoftwareUpdateConformsToProfile.h"

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_unload(string& errorMessage);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SoftwareUpdateConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SoftwareUpdateConformsToProfile& instance, const char** properties, string& errorMessage);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareUpdateConformsToProfile& newInstance, const OpenDRIM_SoftwareUpdateConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareUpdateConformsToProfile& instance, string& errorMessage);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareUpdateConformsToProfile& instance, string& errorMessage);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SoftwareUpdateConformsToProfile>& OpenDRIM_SoftwareUpdateConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_SoftwareUpdateConformsToProfile>& OpenDRIM_SoftwareUpdateConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareUpdate_OpenDRIM_SoftwareUpdateConformsToProfile_populate(OpenDRIM_SoftwareUpdateConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_SOFTWAREUPDATECONFORMSTOPROFILEACCESS_H_*/
