Code of Conduct
===============

OpenAPI Initiative Code of Conduct

*The Linux Foundation*

*Effective November 24, 2020*

The OpenAPI Initiative (OAI) is an open source Linux Foundation project
and home of the OpenAPI Specification (OAS) released under the Apache
2.0 license. As contributors, maintainers, and participants in this
project, we want to foster an open and welcoming environment. We pledge
to make participation in our project and our community a harassment-free
experience for everyone, regardless of age, body size, disability,
ethnicity, gender identity and expression, level of experience,
education, socio-economic status, nationality, personal appearance,
race, religion, or sexual identity and orientation.

Our Standards
-------------

Examples of behaviors that contribute to creating a positive environment
include:

-   Using welcoming and inclusive language

-   Being respectful of differing viewpoints and experiences

-   Gracefully accepting constructive criticism

-   Focusing on what is best for the community

-   Showing empathy towards other community members

-   Assuming the best intent from others

Examples of unacceptable behavior by participants include:

-   The use of sexualized language or imagery and unwelcome sexual attention or advances

-   Making unsolicited, insulting or derogatory comments, including personal (i.e., ad hominem) or political attacks to create conflict (e.g., trolling)

-   Public or private harassment

-   Publishing others' private information, such as a physical or electronic address, without explicit permission (e.g., doxxing)

-   Threatening, offensive, harmful comments, or behavior

-   Other conduct which could reasonably be considered inappropriate in a professional setting

Our Responsibilities
--------------------

The Code of Conduct Committee is responsible for clarifying the
standards of acceptable behavior and is expected to take appropriate and
fair corrective action in response to any instances of unacceptable
behavior.

Scope
-----

This Code of Conduct applies to OAI project spaces, as well as
interactions in public spaces. Project spaces include, but are not
limited to, official OAI code repositories, Slack, mailing lists,
meetings, and events. Public spaces may include venues where an
individual is representing the project or its community. Examples of
this include a community member's email communication, forum posts,
social media activity, or acting as a representative at an online or
offline event. In addition, violations of this code of conduct outside
of these spaces may affect a person's ability to participate in them.

Enforcement
-----------

To report instances of abuse, harassment, or otherwise unacceptable
behavior, contact
[conduct\@openapis.org](mailto:conduct@openapis.org). **We
are committed to maintaining the confidentiality of anyone reporting an
incident**. The Code of Conduct Committee will review and investigate
all complaints, responding as deemed necessary and appropriate to the
circumstances. For incidents relating to offline events, we aim to
respond to reports within 24 hours, and for incidents relating to online
activities, we aim to respond to reports within 7 days.

The Code of Conduct Committee has the right and responsibility to
remove, edit, or reject comments, commits, code, wiki edits, issues, and
other contributions that are not aligned to this Code of Conduct, or
take other appropriate action as deemed necessary for behaviors contrary
to the standards listed above. In the case of offline or in-person
events, if a participant engages in behavior that is not aligned to this
Code of Conduct, the committee may take action, such as warning the
offender, banning the offender from various online spaces (temporary or
permanent), removing the offender from an event with no refund, or other
options deemed appropriate.

Enforcement Guidelines
----------------------

The Code of Conduct committee will follow these Enforcement Guidelines in 
determining the consequences for any action they deem in violation of this 
Code of Conduct:

#### 1. Correction
Community Impact: Use of inappropriate language or other behavior deemed 
unprofessional or unwelcome in the community.

Consequence: A private, written warning from the Code of Conduct committee, 
providing clarity around the nature of the violation and an explanation of 
why the behavior was inappropriate. A public apology may be requested.

#### 2. Warning
Community Impact: A violation through a single incident or series of 
actions.

Consequence: A warning with consequences for continued behavior. No 
interaction with the people involved, including unsolicited interaction 
with the Code of Conduct committee, for a specified period of time. This 
includes avoiding interactions in community spaces as well as external 
channels like social media. Violating these terms may lead to a temporary 
or permanent ban.

#### 3. Temporary Ban
Community Impact: A serious violation of community standards, including 
sustained inappropriate behavior.

Consequence: A temporary ban from any sort of interaction or public 
communication with the community for a specified period of time. No 
public or private interaction with the people involved, including 
unsolicited interaction with the Code of Conduct committee, is allowed 
during this period. Violating these terms may lead to a permanent ban.

#### 4. Permanent Ban
Community Impact: Demonstrating a pattern of violation of community 
standards, including sustained inappropriate behavior, harassment of 
an individual, or aggression toward or disparagement of classes of 
individuals.

Consequence: A permanent ban from any sort of public interaction 
within the community.

### Events

Some OpenAPI events are governed by the [Linux Foundation Code of
Conduct](https://events.linuxfoundation.org/about/code-of-conduct/)
(E.g. API Specifications Conference) and will be listed on the event
page. The OAI Code of Conduct is designed to be compatible with the
above policy and also includes more details on responding to incidents.

### Attribution

This code of conduct is adapted from the [Contributor Covenant, version
1.4](https://www.contributor-covenant.org/version/1/4/code-of-conduct)
and the [PyCon 2019 Code of
Conduct](https://us.pycon.org/2019/about/code-of-conduct/).
