(* TEST *)

open Printf

(* By making the field "f" mutable, we prevent the creation of structured
   constants and force the FP values to be loaded in an FP register,
   then stored in memory and passed to the "test" function. *)

type t = { mutable f : float }

let test x y =
  if Int64.bits_of_float x.f <> y then
    printf "Error: bits_of_float %h <> 0x%Lx\n" x.f y
[@@inline never]

(* The values tested include
     - those that are loaded by special x87 instructions on i386:
         +0.0, -0.0, +1.0, -1.0
     - those that are loaded by xorpd on amd64:
         +0.0;
     - those that are loaded by "fmov immediate" on arm64:
         see list below
*)
let _ =
  test { f = 0.0 } 0L;
  test { f = (-0.0) } 0x8000000000000000L;
  (* The following are the "fmov immediate" of arm64 *)
  (* They include +1.0 and -1.0 *)
  test { f = 0x1p-3 } 0x3fc0000000000000L;
  test { f = 0x1.1p-3 } 0x3fc1000000000000L;
  test { f = 0x1.2p-3 } 0x3fc2000000000000L;
  test { f = 0x1.3p-3 } 0x3fc3000000000000L;
  test { f = 0x1.4p-3 } 0x3fc4000000000000L;
  test { f = 0x1.5p-3 } 0x3fc5000000000000L;
  test { f = 0x1.6p-3 } 0x3fc6000000000000L;
  test { f = 0x1.7p-3 } 0x3fc7000000000000L;
  test { f = 0x1.8p-3 } 0x3fc8000000000000L;
  test { f = 0x1.9p-3 } 0x3fc9000000000000L;
  test { f = 0x1.ap-3 } 0x3fca000000000000L;
  test { f = 0x1.bp-3 } 0x3fcb000000000000L;
  test { f = 0x1.cp-3 } 0x3fcc000000000000L;
  test { f = 0x1.dp-3 } 0x3fcd000000000000L;
  test { f = 0x1.ep-3 } 0x3fce000000000000L;
  test { f = 0x1.fp-3 } 0x3fcf000000000000L;
  test { f = 0x1p-2 } 0x3fd0000000000000L;
  test { f = 0x1.1p-2 } 0x3fd1000000000000L;
  test { f = 0x1.2p-2 } 0x3fd2000000000000L;
  test { f = 0x1.3p-2 } 0x3fd3000000000000L;
  test { f = 0x1.4p-2 } 0x3fd4000000000000L;
  test { f = 0x1.5p-2 } 0x3fd5000000000000L;
  test { f = 0x1.6p-2 } 0x3fd6000000000000L;
  test { f = 0x1.7p-2 } 0x3fd7000000000000L;
  test { f = 0x1.8p-2 } 0x3fd8000000000000L;
  test { f = 0x1.9p-2 } 0x3fd9000000000000L;
  test { f = 0x1.ap-2 } 0x3fda000000000000L;
  test { f = 0x1.bp-2 } 0x3fdb000000000000L;
  test { f = 0x1.cp-2 } 0x3fdc000000000000L;
  test { f = 0x1.dp-2 } 0x3fdd000000000000L;
  test { f = 0x1.ep-2 } 0x3fde000000000000L;
  test { f = 0x1.fp-2 } 0x3fdf000000000000L;
  test { f = 0x1p-1 } 0x3fe0000000000000L;
  test { f = 0x1.1p-1 } 0x3fe1000000000000L;
  test { f = 0x1.2p-1 } 0x3fe2000000000000L;
  test { f = 0x1.3p-1 } 0x3fe3000000000000L;
  test { f = 0x1.4p-1 } 0x3fe4000000000000L;
  test { f = 0x1.5p-1 } 0x3fe5000000000000L;
  test { f = 0x1.6p-1 } 0x3fe6000000000000L;
  test { f = 0x1.7p-1 } 0x3fe7000000000000L;
  test { f = 0x1.8p-1 } 0x3fe8000000000000L;
  test { f = 0x1.9p-1 } 0x3fe9000000000000L;
  test { f = 0x1.ap-1 } 0x3fea000000000000L;
  test { f = 0x1.bp-1 } 0x3feb000000000000L;
  test { f = 0x1.cp-1 } 0x3fec000000000000L;
  test { f = 0x1.dp-1 } 0x3fed000000000000L;
  test { f = 0x1.ep-1 } 0x3fee000000000000L;
  test { f = 0x1.fp-1 } 0x3fef000000000000L;
  test { f = 0x1p+0 } 0x3ff0000000000000L;
  test { f = 0x1.1p+0 } 0x3ff1000000000000L;
  test { f = 0x1.2p+0 } 0x3ff2000000000000L;
  test { f = 0x1.3p+0 } 0x3ff3000000000000L;
  test { f = 0x1.4p+0 } 0x3ff4000000000000L;
  test { f = 0x1.5p+0 } 0x3ff5000000000000L;
  test { f = 0x1.6p+0 } 0x3ff6000000000000L;
  test { f = 0x1.7p+0 } 0x3ff7000000000000L;
  test { f = 0x1.8p+0 } 0x3ff8000000000000L;
  test { f = 0x1.9p+0 } 0x3ff9000000000000L;
  test { f = 0x1.ap+0 } 0x3ffa000000000000L;
  test { f = 0x1.bp+0 } 0x3ffb000000000000L;
  test { f = 0x1.cp+0 } 0x3ffc000000000000L;
  test { f = 0x1.dp+0 } 0x3ffd000000000000L;
  test { f = 0x1.ep+0 } 0x3ffe000000000000L;
  test { f = 0x1.fp+0 } 0x3fff000000000000L;
  test { f = 0x1p+1 } 0x4000000000000000L;
  test { f = 0x1.1p+1 } 0x4001000000000000L;
  test { f = 0x1.2p+1 } 0x4002000000000000L;
  test { f = 0x1.3p+1 } 0x4003000000000000L;
  test { f = 0x1.4p+1 } 0x4004000000000000L;
  test { f = 0x1.5p+1 } 0x4005000000000000L;
  test { f = 0x1.6p+1 } 0x4006000000000000L;
  test { f = 0x1.7p+1 } 0x4007000000000000L;
  test { f = 0x1.8p+1 } 0x4008000000000000L;
  test { f = 0x1.9p+1 } 0x4009000000000000L;
  test { f = 0x1.ap+1 } 0x400a000000000000L;
  test { f = 0x1.bp+1 } 0x400b000000000000L;
  test { f = 0x1.cp+1 } 0x400c000000000000L;
  test { f = 0x1.dp+1 } 0x400d000000000000L;
  test { f = 0x1.ep+1 } 0x400e000000000000L;
  test { f = 0x1.fp+1 } 0x400f000000000000L;
  test { f = 0x1p+2 } 0x4010000000000000L;
  test { f = 0x1.1p+2 } 0x4011000000000000L;
  test { f = 0x1.2p+2 } 0x4012000000000000L;
  test { f = 0x1.3p+2 } 0x4013000000000000L;
  test { f = 0x1.4p+2 } 0x4014000000000000L;
  test { f = 0x1.5p+2 } 0x4015000000000000L;
  test { f = 0x1.6p+2 } 0x4016000000000000L;
  test { f = 0x1.7p+2 } 0x4017000000000000L;
  test { f = 0x1.8p+2 } 0x4018000000000000L;
  test { f = 0x1.9p+2 } 0x4019000000000000L;
  test { f = 0x1.ap+2 } 0x401a000000000000L;
  test { f = 0x1.bp+2 } 0x401b000000000000L;
  test { f = 0x1.cp+2 } 0x401c000000000000L;
  test { f = 0x1.dp+2 } 0x401d000000000000L;
  test { f = 0x1.ep+2 } 0x401e000000000000L;
  test { f = 0x1.fp+2 } 0x401f000000000000L;
  test { f = 0x1p+3 } 0x4020000000000000L;
  test { f = 0x1.1p+3 } 0x4021000000000000L;
  test { f = 0x1.2p+3 } 0x4022000000000000L;
  test { f = 0x1.3p+3 } 0x4023000000000000L;
  test { f = 0x1.4p+3 } 0x4024000000000000L;
  test { f = 0x1.5p+3 } 0x4025000000000000L;
  test { f = 0x1.6p+3 } 0x4026000000000000L;
  test { f = 0x1.7p+3 } 0x4027000000000000L;
  test { f = 0x1.8p+3 } 0x4028000000000000L;
  test { f = 0x1.9p+3 } 0x4029000000000000L;
  test { f = 0x1.ap+3 } 0x402a000000000000L;
  test { f = 0x1.bp+3 } 0x402b000000000000L;
  test { f = 0x1.cp+3 } 0x402c000000000000L;
  test { f = 0x1.dp+3 } 0x402d000000000000L;
  test { f = 0x1.ep+3 } 0x402e000000000000L;
  test { f = 0x1.fp+3 } 0x402f000000000000L;
  test { f = 0x1p+4 } 0x4030000000000000L;
  test { f = 0x1.1p+4 } 0x4031000000000000L;
  test { f = 0x1.2p+4 } 0x4032000000000000L;
  test { f = 0x1.3p+4 } 0x4033000000000000L;
  test { f = 0x1.4p+4 } 0x4034000000000000L;
  test { f = 0x1.5p+4 } 0x4035000000000000L;
  test { f = 0x1.6p+4 } 0x4036000000000000L;
  test { f = 0x1.7p+4 } 0x4037000000000000L;
  test { f = 0x1.8p+4 } 0x4038000000000000L;
  test { f = 0x1.9p+4 } 0x4039000000000000L;
  test { f = 0x1.ap+4 } 0x403a000000000000L;
  test { f = 0x1.bp+4 } 0x403b000000000000L;
  test { f = 0x1.cp+4 } 0x403c000000000000L;
  test { f = 0x1.dp+4 } 0x403d000000000000L;
  test { f = 0x1.ep+4 } 0x403e000000000000L;
  test { f = 0x1.fp+4 } 0x403f000000000000L;
  test { f = (-0x1p-3) } 0xbfc0000000000000L;
  test { f = (-0x1.1p-3) } 0xbfc1000000000000L;
  test { f = (-0x1.2p-3) } 0xbfc2000000000000L;
  test { f = (-0x1.3p-3) } 0xbfc3000000000000L;
  test { f = (-0x1.4p-3) } 0xbfc4000000000000L;
  test { f = (-0x1.5p-3) } 0xbfc5000000000000L;
  test { f = (-0x1.6p-3) } 0xbfc6000000000000L;
  test { f = (-0x1.7p-3) } 0xbfc7000000000000L;
  test { f = (-0x1.8p-3) } 0xbfc8000000000000L;
  test { f = (-0x1.9p-3) } 0xbfc9000000000000L;
  test { f = (-0x1.ap-3) } 0xbfca000000000000L;
  test { f = (-0x1.bp-3) } 0xbfcb000000000000L;
  test { f = (-0x1.cp-3) } 0xbfcc000000000000L;
  test { f = (-0x1.dp-3) } 0xbfcd000000000000L;
  test { f = (-0x1.ep-3) } 0xbfce000000000000L;
  test { f = (-0x1.fp-3) } 0xbfcf000000000000L;
  test { f = (-0x1p-2) } 0xbfd0000000000000L;
  test { f = (-0x1.1p-2) } 0xbfd1000000000000L;
  test { f = (-0x1.2p-2) } 0xbfd2000000000000L;
  test { f = (-0x1.3p-2) } 0xbfd3000000000000L;
  test { f = (-0x1.4p-2) } 0xbfd4000000000000L;
  test { f = (-0x1.5p-2) } 0xbfd5000000000000L;
  test { f = (-0x1.6p-2) } 0xbfd6000000000000L;
  test { f = (-0x1.7p-2) } 0xbfd7000000000000L;
  test { f = (-0x1.8p-2) } 0xbfd8000000000000L;
  test { f = (-0x1.9p-2) } 0xbfd9000000000000L;
  test { f = (-0x1.ap-2) } 0xbfda000000000000L;
  test { f = (-0x1.bp-2) } 0xbfdb000000000000L;
  test { f = (-0x1.cp-2) } 0xbfdc000000000000L;
  test { f = (-0x1.dp-2) } 0xbfdd000000000000L;
  test { f = (-0x1.ep-2) } 0xbfde000000000000L;
  test { f = (-0x1.fp-2) } 0xbfdf000000000000L;
  test { f = (-0x1p-1) } 0xbfe0000000000000L;
  test { f = (-0x1.1p-1) } 0xbfe1000000000000L;
  test { f = (-0x1.2p-1) } 0xbfe2000000000000L;
  test { f = (-0x1.3p-1) } 0xbfe3000000000000L;
  test { f = (-0x1.4p-1) } 0xbfe4000000000000L;
  test { f = (-0x1.5p-1) } 0xbfe5000000000000L;
  test { f = (-0x1.6p-1) } 0xbfe6000000000000L;
  test { f = (-0x1.7p-1) } 0xbfe7000000000000L;
  test { f = (-0x1.8p-1) } 0xbfe8000000000000L;
  test { f = (-0x1.9p-1) } 0xbfe9000000000000L;
  test { f = (-0x1.ap-1) } 0xbfea000000000000L;
  test { f = (-0x1.bp-1) } 0xbfeb000000000000L;
  test { f = (-0x1.cp-1) } 0xbfec000000000000L;
  test { f = (-0x1.dp-1) } 0xbfed000000000000L;
  test { f = (-0x1.ep-1) } 0xbfee000000000000L;
  test { f = (-0x1.fp-1) } 0xbfef000000000000L;
  test { f = (-0x1p+0) } 0xbff0000000000000L;
  test { f = (-0x1.1p+0) } 0xbff1000000000000L;
  test { f = (-0x1.2p+0) } 0xbff2000000000000L;
  test { f = (-0x1.3p+0) } 0xbff3000000000000L;
  test { f = (-0x1.4p+0) } 0xbff4000000000000L;
  test { f = (-0x1.5p+0) } 0xbff5000000000000L;
  test { f = (-0x1.6p+0) } 0xbff6000000000000L;
  test { f = (-0x1.7p+0) } 0xbff7000000000000L;
  test { f = (-0x1.8p+0) } 0xbff8000000000000L;
  test { f = (-0x1.9p+0) } 0xbff9000000000000L;
  test { f = (-0x1.ap+0) } 0xbffa000000000000L;
  test { f = (-0x1.bp+0) } 0xbffb000000000000L;
  test { f = (-0x1.cp+0) } 0xbffc000000000000L;
  test { f = (-0x1.dp+0) } 0xbffd000000000000L;
  test { f = (-0x1.ep+0) } 0xbffe000000000000L;
  test { f = (-0x1.fp+0) } 0xbfff000000000000L;
  test { f = (-0x1p+1) } 0xc000000000000000L;
  test { f = (-0x1.1p+1) } 0xc001000000000000L;
  test { f = (-0x1.2p+1) } 0xc002000000000000L;
  test { f = (-0x1.3p+1) } 0xc003000000000000L;
  test { f = (-0x1.4p+1) } 0xc004000000000000L;
  test { f = (-0x1.5p+1) } 0xc005000000000000L;
  test { f = (-0x1.6p+1) } 0xc006000000000000L;
  test { f = (-0x1.7p+1) } 0xc007000000000000L;
  test { f = (-0x1.8p+1) } 0xc008000000000000L;
  test { f = (-0x1.9p+1) } 0xc009000000000000L;
  test { f = (-0x1.ap+1) } 0xc00a000000000000L;
  test { f = (-0x1.bp+1) } 0xc00b000000000000L;
  test { f = (-0x1.cp+1) } 0xc00c000000000000L;
  test { f = (-0x1.dp+1) } 0xc00d000000000000L;
  test { f = (-0x1.ep+1) } 0xc00e000000000000L;
  test { f = (-0x1.fp+1) } 0xc00f000000000000L;
  test { f = (-0x1p+2) } 0xc010000000000000L;
  test { f = (-0x1.1p+2) } 0xc011000000000000L;
  test { f = (-0x1.2p+2) } 0xc012000000000000L;
  test { f = (-0x1.3p+2) } 0xc013000000000000L;
  test { f = (-0x1.4p+2) } 0xc014000000000000L;
  test { f = (-0x1.5p+2) } 0xc015000000000000L;
  test { f = (-0x1.6p+2) } 0xc016000000000000L;
  test { f = (-0x1.7p+2) } 0xc017000000000000L;
  test { f = (-0x1.8p+2) } 0xc018000000000000L;
  test { f = (-0x1.9p+2) } 0xc019000000000000L;
  test { f = (-0x1.ap+2) } 0xc01a000000000000L;
  test { f = (-0x1.bp+2) } 0xc01b000000000000L;
  test { f = (-0x1.cp+2) } 0xc01c000000000000L;
  test { f = (-0x1.dp+2) } 0xc01d000000000000L;
  test { f = (-0x1.ep+2) } 0xc01e000000000000L;
  test { f = (-0x1.fp+2) } 0xc01f000000000000L;
  test { f = (-0x1p+3) } 0xc020000000000000L;
  test { f = (-0x1.1p+3) } 0xc021000000000000L;
  test { f = (-0x1.2p+3) } 0xc022000000000000L;
  test { f = (-0x1.3p+3) } 0xc023000000000000L;
  test { f = (-0x1.4p+3) } 0xc024000000000000L;
  test { f = (-0x1.5p+3) } 0xc025000000000000L;
  test { f = (-0x1.6p+3) } 0xc026000000000000L;
  test { f = (-0x1.7p+3) } 0xc027000000000000L;
  test { f = (-0x1.8p+3) } 0xc028000000000000L;
  test { f = (-0x1.9p+3) } 0xc029000000000000L;
  test { f = (-0x1.ap+3) } 0xc02a000000000000L;
  test { f = (-0x1.bp+3) } 0xc02b000000000000L;
  test { f = (-0x1.cp+3) } 0xc02c000000000000L;
  test { f = (-0x1.dp+3) } 0xc02d000000000000L;
  test { f = (-0x1.ep+3) } 0xc02e000000000000L;
  test { f = (-0x1.fp+3) } 0xc02f000000000000L;
  test { f = (-0x1p+4) } 0xc030000000000000L;
  test { f = (-0x1.1p+4) } 0xc031000000000000L;
  test { f = (-0x1.2p+4) } 0xc032000000000000L;
  test { f = (-0x1.3p+4) } 0xc033000000000000L;
  test { f = (-0x1.4p+4) } 0xc034000000000000L;
  test { f = (-0x1.5p+4) } 0xc035000000000000L;
  test { f = (-0x1.6p+4) } 0xc036000000000000L;
  test { f = (-0x1.7p+4) } 0xc037000000000000L;
  test { f = (-0x1.8p+4) } 0xc038000000000000L;
  test { f = (-0x1.9p+4) } 0xc039000000000000L;
  test { f = (-0x1.ap+4) } 0xc03a000000000000L;
  test { f = (-0x1.bp+4) } 0xc03b000000000000L;
  test { f = (-0x1.cp+4) } 0xc03c000000000000L;
  test { f = (-0x1.dp+4) } 0xc03d000000000000L;
  test { f = (-0x1.ep+4) } 0xc03e000000000000L;
  test { f = (-0x1.fp+4) } 0xc03f000000000000L;
  ()
