Support (explain) field in (menhir) stanza to produce .conflicts file:

  $ cat >dune <<EOF
  > (menhir (modules parser) (explain true))
  > (library (name lib))
  > EOF

First we check the version guards:

  $ cat >dune-project <<EOF
  > (lang dune 3.12)
  > (using menhir 2.1)
  > EOF

  $ dune build
  File "dune", line 1, characters 25-39:
  1 | (menhir (modules parser) (explain true))
                               ^^^^^^^^^^^^^^
  Error: 'explain' is only available since version 3.0 of the menhir extension.
  Please update your dune-project file to have (using menhir 3.0).
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.12)
  > (using menhir 3.0)
  > EOF

  $ dune build
  File "dune-project", line 2, characters 14-17:
  2 | (using menhir 3.0)
                    ^^^
  Error: Version 3.0 of the menhir extension is not supported until version
  3.13 of the dune language.
  Supported versions of this extension in version 3.12 of the dune language:
  - 1.0 to 1.1
  - 2.0 to 2.1
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.13)
  > (using menhir 3.0)
  > EOF

  $ dune build

Let's check that the conflicts file has been generated successfully:

  $ test -f _build/default/parser.conflicts

Let's check we can also pass `(explain false)`:

  $ cat >dune <<EOF
  > (menhir (modules parser) (explain false))
  > (library (name lib))
  > EOF

  $ dune build

  $ ! test -f _build/default/parser.conflicts

Let's check that it is generated by default if we omit the (explain) field:

  $ cat >dune <<EOF
  > (menhir (modules parser))
  > (library (name lib))
  > EOF

  $ dune build

  $ test -f _build/default/parser.conflicts

... but only if the Dune version is recent enough:

  $ cat >dune-project <<EOF
  > (lang dune 3.13)
  > (using menhir 2.1)
  > EOF

  $ dune build

  $ ! test -f _build/default/parser.conflicts

Let's check that the argument to (explain) can be a blang:

  $ cat >dune-project <<EOF
  > (lang dune 3.13)
  > (using menhir 3.0)
  > EOF

  $ cat >dune <<EOF
  > (menhir (modules parser) (explain (= true false)))
  > (library (name lib))
  > EOF

  $ dune build

  $ ! test -f _build/default/parser.conflicts

Let's check that we get a warning if we use --explain with the new mode

  $ cat >dune-project <<EOF
  > (lang dune 3.13)
  > (using menhir 3.0)
  > EOF

  $ cat >dune <<EOF
  > (menhir (modules parser) (flags --explain))
  > (library (name lib))
  > EOF

  $ dune build
  File "dune", line 1, characters 32-41:
  1 | (menhir (modules parser) (flags --explain))
                                      ^^^^^^^^^
  Error: The Menhir '.conflicts' file is generated by default, so '--explain'
  should not be explicitly added to the list of Menhir flags.
  [1]

Let's now test the new field of (env), (menhir):

  $ cat >dune-project <<EOF
  > (lang dune 3.12)
  > (using menhir 2.1)
  > EOF

  $ cat >dune <<EOF
  > (env (_ (menhir (explain false))))
  > (menhir (modules parser))
  > (library (name lib))
  > EOF

  $ dune build
  File "dune", line 1, characters 8-32:
  1 | (env (_ (menhir (explain false))))
              ^^^^^^^^^^^^^^^^^^^^^^^^
  Error: 'menhir' is only available since version 3.0 of the menhir extension.
  Please update your dune-project file to have (using menhir 3.0).
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.13)
  > (using menhir 3.0)
  > EOF

  $ cat >dune <<EOF
  > (env (_ (menhir_flags --explain)))
  > (menhir (modules parser))
  > (library (name lib))
  > EOF

  $ dune build
  File "dune", line 1, characters 8-32:
  1 | (env (_ (menhir_flags --explain)))
              ^^^^^^^^^^^^^^^^^^^^^^^^
  Error: 'menhir_flags' was deleted in version 3.0 of the menhir extension. Use
  (menhir (flags ...)) instead.
  [1]

  $ cat >dune <<EOF
  > (env (_ (menhir (explain false))))
  > (menhir (modules parser))
  > (library (name lib))
  > EOF

  $ dune build

  $ ! test -f _build/default/parser.conflicts

  $ cat >dune <<EOF
  > (env (_ (menhir (explain false))))
  > (menhir (modules parser) (explain true))
  > (library (name lib))
  > EOF

  $ dune build

  $ test -f _build/default/parser.conflicts

Also in subdirectories:

  $ mkdir -p sub
  $ cp parser.mly sub/parser2.mly

  $ cat >sub/dune <<EOF
  > (menhir (modules parser2))
  > (library (name lib2))
  > EOF

  $ dune printenv sub | grep menhir
  (menhir_flags ())
  (menhir_explain (false))

  $ dune build @sub/all

  $ ! test -f _build/default/sub/parser2.conflicts

  $ true >dune

  $ dune printenv sub | grep menhir
  (menhir_flags ())
  (menhir_explain ())

  $ dune build @sub/all

  $ test _build/default/sub/parser2.conflicts
