/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_UI_TREE_VIEW_H__
#define __NB_UI_TREE_VIEW_H__ 

#include <glib.h>
#include <gtk/gtk.h>

#include "../nb_note.h"

enum
{
	TITLE_COLUMN,
	TYPE_COLUMN,
	STATUS_COLUMN,
	DATE_COLUMN,
	LAST_UPDATE_COLUMN,
	NOTE_POINTER_COLUMN,
	N_COLUMNS
};

typedef struct _remove_cb_args RemoveCbArgs;

struct _remove_cb_args 
{
	gchar * query;
	GList * rr_list;
};

typedef struct _note_match NoteMatch;

struct _note_match
{
	Note * n;
	GtkTreeIter * iter;
};

void			nb_ui_treeview_create (void);
void			nb_ui_treeview_set_sort_func (GtkListStore * store);

/* update tree */
GtkTreeIter		* nb_ui_treeview_add_note (gchar * title, gchar * type, gchar * status, gchar * date, gchar * update, Note * n, gboolean scroll);
void			nb_ui_treeview_update_note (gchar * title, gchar * type, gchar * status, gchar * last_update, Note * n);
void			nb_ui_treeview_update (gchar * query);

GtkTreeSelection	* nb_ui_treeview_get_selection (void);
void			nb_ui_treeview_select_iter (GtkTreeIter * iter);

/* public callbacks */
void			nb_ui_treeview_cb_selection_changed (GtkTreeSelection * selection, gpointer user_data);

#endif
