## Usage 

```js
const normalize = require('{%= name %}');

console.log(normalize('\\foo\\bar\\baz\\')); 
//=> '/foo/bar/baz'
```

**win32 namespaces**



```js
console.log(normalize('\\\\?\\UNC\\Server01\\user\\docs\\Letter.txt')); 
//=> '//?/UNC/Server01/user/docs/Letter.txt'

console.log(normalize('\\\\.\\CdRomX')); 
//=> '//./CdRomX'
```

**Consecutive slashes**

Condenses multiple consecutive forward slashes (except for leading slashes in win32 namespaces) to a single slash.

```js
console.log(normalize('.//foo//bar///////baz/')); 
//=> './foo/bar/baz'
```

### Trailing slashes

By default trailing slashes are removed. Pass `false` as the last argument to disable this behavior and _**keep** trailing slashes_:

```js
console.log(normalize('foo\\bar\\baz\\', false)); //=> 'foo/bar/baz/'
console.log(normalize('./foo/bar/baz/', false)); //=> './foo/bar/baz/'
```

## Release history

### v3.0

No breaking changes in this release. 

- a check was added to ensure that [win32 namespaces][ns] are handled properly by win32 `path.parse()` after a path has been normalized by this library.
- a minor optimization was made to simplify how the trailing separator was handled


[ns]: https://msdn.microsoft.com/library/windows/desktop/aa365247(v=vs.85).aspx#namespaces