# -*- coding: utf-8 -*-
#
#  metamagic.py - unknown unknowns
#  Copyright (C) 2011, 2012 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import abc


class Meme(object):
    __metaclass__ = abc.ABCMeta

    def __init__(self, key):
        self.__key = key
        self.__baseinfo = None
        self.__menuitem = None

    @abc.abstractmethod
    def create_menuitem(self, data):
        pass

    @abc.abstractmethod
    def delete_by_myself(self):
        pass

    @property
    def key(self): # read only
        return self.__key

    @property
    def baseinfo(self):
        return self.__baseinfo

    @baseinfo.setter
    def baseinfo(self, data): ## FIXME
        self.__baseinfo = data
        menuitem = self.create_menuitem(data)
        if menuitem is None:
            self.delete_by_myself()
            return
        self.__menuitem = menuitem

    @property
    def menuitem(self): # read only
        return self.__menuitem


class Holon(object):
    __metaclass__ = abc.ABCMeta

    def __init__(self, key):
        self.__key = key
        self.__baseinfo = None
        self.__menuitem = None
        self.__instance = None
        
    @abc.abstractmethod
    def create_menuitem(self, data):
        pass

    @abc.abstractmethod
    def delete_by_myself(self):
        pass

    @abc.abstractmethod
    def create_instance(self, data):
        pass

    @property
    def key(self): # read only
        return self.__key

    @property
    def baseinfo(self): # forbidden
        return None

    @baseinfo.setter
    def baseinfo(self, data):
        self.__baseinfo = data
        if self.__instance is None:
            self.__instance = self.create_instance(data)
            if self.__instance is None:
                self.delete_by_myself()
                return
        else:
            self.__instance.new(*data) # reset
        menuitem = self.create_menuitem(data)
        if menuitem is None:
            self.delete_by_myself()
            return
        self.__menuitem = menuitem

    @property
    def menuitem(self): # read only
        return self.__menuitem

    @property
    def instance(self): # read only
        return self.__instance
