/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.log4j.FileAppender;
import org.apache.log4j.spi.LoggingEvent;

public class TaskLogAppender
extends FileAppender {
    private String taskId;
    private int maxEvents;
    private Queue<LoggingEvent> tail = null;
    private boolean isCleanup;
    private static final int EVENT_SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateOptions() {
        TaskLogAppender taskLogAppender = this;
        synchronized (taskLogAppender) {
            if (this.maxEvents > 0) {
                this.tail = new LinkedList<LoggingEvent>();
            }
            this.setFile(TaskLog.getTaskLogFile(TaskAttemptID.forName(this.taskId), this.isCleanup, TaskLog.LogName.SYSLOG).toString());
            this.setAppend(true);
            super.activateOptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        TaskLogAppender taskLogAppender = this;
        synchronized (taskLogAppender) {
            if (this.tail == null) {
                super.append(event);
            } else {
                if (this.tail.size() >= this.maxEvents) {
                    this.tail.remove();
                }
                this.tail.add(event);
            }
        }
    }

    public void flush() {
        this.qw.flush();
    }

    public synchronized void close() {
        if (this.tail != null) {
            for (LoggingEvent event : this.tail) {
                super.append(event);
            }
        }
        super.close();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public long getTotalLogFileSize() {
        return this.maxEvents * 100;
    }

    public void setTotalLogFileSize(long logSize) {
        this.maxEvents = (int)logSize / 100;
    }

    public void setIsCleanup(boolean isCleanup) {
        this.isCleanup = isCleanup;
    }

    public boolean getIsCleanup() {
        return this.isCleanup;
    }
}

