# Security Policy

## Supported Versions

We provide security updates for the last stable release of Modules and for a
given list of stable releases listed below. Security updates will be made
available as patch (`x.y.1`, `x.y.2`, etc.) releases.

| Version      | Supported          |
| ------------ | ------------------ |
| 5.6.x        | :white_check_mark: |
| > 5.3, < 5.6 | :x:                |
| 5.3.x        | :white_check_mark: |
| > 4.5, < 5.3 | :x:                |
| 4.5.x        | :white_check_mark: |
| < 4.5        | :x:                |

## Reporting a Vulnerability

You can report a vulnerability using GitHub's private reporting feature:

1. Go to [github.com/envmodules/modules/security](https://github.com/envmodules/modules/security).
2. Click "Report a vulnerability" in the upper right corner of that page.
3. Fill out the form and submit your draft security advisory.

More details are available in
[GitHub's docs](https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability).

You can expect to hear back about security issues within five working days. If
your security issue is accepted, we will do our best to release a fix within
two weeks. If fixing the issue will take longer than this, we will discuss
timeline options with you.
