/* This file generated from tools/Generate-Collation-Data.p6 */
struct collation_key {
    MVMuint32 primary :16;
    MVMuint32 tertiary :5;
    MVMuint32 special :1;
    MVMuint32 secondary :9;
};
struct sub_node {
    MVMuint32 codepoint :18;
    MVMuint32 collation_key_link :14;
    MVMuint32 sub_node_link :13;
    MVMuint32 sub_node_elems :13;
    MVMuint32 collation_key_elems :5;
};
typedef struct sub_node sub_node;
#define main_nodes_elems 4697
#define starter_main_nodes_elems 3803
#define codepoint_sequence_no_max 3
#define special_collation_keys_elems 10435
/* Data from PropList.txt */
MVM_STATIC_INLINE MVMuint32 is_unified_ideograph (MVMCodepoint cp) {
    return
       (0x3400  <= cp && cp <= 0x4DB5 ) /* 3400..4DB5 Unified_Ideograph # Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5 */
    || (0x4E00  <= cp && cp <= 0x9FEA ) /* 4E00..9FEA Unified_Ideograph # Lo [20971] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FEA */
    || (0xFA0E  <= cp && cp <= 0xFA0F ) /* FA0E..FA0F Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA0E..CJK COMPATIBILITY IDEOGRAPH-FA0F */
    || (0xFA11                   == cp) /* FA11..FA11 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA11 */
    || (0xFA13  <= cp && cp <= 0xFA14 ) /* FA13..FA14 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA13..CJK COMPATIBILITY IDEOGRAPH-FA14 */
    || (0xFA1F                   == cp) /* FA1F..FA1F Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA1F */
    || (0xFA21                   == cp) /* FA21..FA21 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA21 */
    || (0xFA23  <= cp && cp <= 0xFA24 ) /* FA23..FA24 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA23..CJK COMPATIBILITY IDEOGRAPH-FA24 */
    || (0xFA27  <= cp && cp <= 0xFA29 ) /* FA27..FA29 Unified_Ideograph # Lo   [3] CJK COMPATIBILITY IDEOGRAPH-FA27..CJK COMPATIBILITY IDEOGRAPH-FA29 */
    || (0x20000 <= cp && cp <= 0x2A6D6) /* 20000..2A6D6 Unified_Ideograph # Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6 */
    || (0x2A700 <= cp && cp <= 0x2B734) /* 2A700..2B734 Unified_Ideograph # Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734 */
    || (0x2B740 <= cp && cp <= 0x2B81D) /* 2B740..2B81D Unified_Ideograph # Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D */
    || (0x2B820 <= cp && cp <= 0x2CEA1) /* 2B820..2CEA1 Unified_Ideograph # Lo [5762] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEA1 */
    || (0x2CEB0 <= cp && cp <= 0x2EBE0) /* 2CEB0..2EBE0 Unified_Ideograph # Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0 */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Assigned_Block_Nushu (MVMCodepoint cp) {
    return
       (0x1B170 <= cp && cp <= 0x1B2FF) /* 1B170..1B2FF Nushu                              */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_Tangut (MVMCodepoint cp) {
    return
       (0x17000 <= cp && cp <= 0x187FF) /* 17000..187FF Tangut                             */
    || (0x18800 <= cp && cp <= 0x18AFF) /* 18800..18AFF Tangut Components                  */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_CJK_Unified_Ideographs_OR_CJK_Compatibility_Ideographs (MVMCodepoint cp) {
    return
       (0x4E00  <= cp && cp <= 0x9FFF ) /* 4E00..9FFF CJK Unified Ideographs             */
    || (0xF900  <= cp && cp <= 0xFAFF ) /* F900..FAFF CJK Compatibility Ideographs       */
    ;
}

sub_node main_nodes[4697] = {
{76,0,3803,1,0},{108,0,3804,1,0},{188,4,0,0,3},{189,7,0,0,3},{190,10,0,0,3},
{192,13,0,0,2},{193,15,0,0,2},{194,17,0,0,2},{195,19,0,0,2},{196,21,0,0,2},{197,
23,0,0,2},{198,25,0,0,3},{199,28,0,0,2},{200,30,0,0,2},{201,32,0,0,2},{202,34,0,
0,2},{203,36,0,0,2},{204,38,0,0,2},{205,40,0,0,2},{206,42,0,0,2},{207,44,0,0,2},
{208,46,0,0,2},{209,48,0,0,2},{210,50,0,0,2},{211,52,0,0,2},{212,54,0,0,2},{213,
56,0,0,2},{214,58,0,0,2},{216,60,0,0,2},{217,62,0,0,2},{218,64,0,0,2},{219,66,0,
0,2},{220,68,0,0,2},{221,70,0,0,2},{223,72,0,0,3},{224,75,0,0,2},{225,77,0,0,2},
{226,79,0,0,2},{227,81,0,0,2},{228,83,0,0,2},{229,85,0,0,2},{230,87,0,0,3},{231,
90,0,0,2},{232,92,0,0,2},{233,94,0,0,2},{234,96,0,0,2},{235,98,0,0,2},{236,100,
0,0,2},{237,102,0,0,2},{238,104,0,0,2},{239,106,0,0,2},{240,108,0,0,2},{241,110,
0,0,2},{242,112,0,0,2},{243,114,0,0,2},{244,116,0,0,2},{245,118,0,0,2},{246,120,
0,0,2},{248,122,0,0,2},{249,124,0,0,2},{250,126,0,0,2},{251,128,0,0,2},{252,130,
0,0,2},{253,132,0,0,2},{255,134,0,0,2},{256,136,0,0,2},{257,138,0,0,2},{258,140,
0,0,2},{259,142,0,0,2},{260,144,0,0,2},{261,146,0,0,2},{262,148,0,0,2},{263,150,
0,0,2},{264,152,0,0,2},{265,154,0,0,2},{266,156,0,0,2},{267,158,0,0,2},{268,160,
0,0,2},{269,162,0,0,2},{270,164,0,0,2},{271,166,0,0,2},{272,168,0,0,2},{273,170,
0,0,2},{274,172,0,0,2},{275,174,0,0,2},{276,176,0,0,2},{277,178,0,0,2},{278,180,
0,0,2},{279,182,0,0,2},{280,184,0,0,2},{281,186,0,0,2},{282,188,0,0,2},{283,190,
0,0,2},{284,192,0,0,2},{285,194,0,0,2},{286,196,0,0,2},{287,198,0,0,2},{288,200,
0,0,2},{289,202,0,0,2},{290,204,0,0,2},{291,206,0,0,2},{292,208,0,0,2},{293,210,
0,0,2},{294,212,0,0,2},{295,214,0,0,2},{296,216,0,0,2},{297,218,0,0,2},{298,220,
0,0,2},{299,222,0,0,2},{300,224,0,0,2},{301,226,0,0,2},{302,228,0,0,2},{303,230,
0,0,2},{304,232,0,0,2},{306,234,0,0,2},{307,236,0,0,2},{308,238,0,0,2},{309,240,
0,0,2},{310,242,0,0,2},{311,244,0,0,2},{313,246,0,0,2},{314,248,0,0,2},{315,250,
0,0,2},{316,252,0,0,2},{317,254,0,0,2},{318,256,0,0,2},{319,258,0,0,2},{320,260,
0,0,2},{321,262,0,0,2},{322,264,0,0,2},{323,266,0,0,2},{324,268,0,0,2},{325,270,
0,0,2},{326,272,0,0,2},{327,274,0,0,2},{328,276,0,0,2},{329,278,0,0,2},{332,280,
0,0,2},{333,282,0,0,2},{334,284,0,0,2},{335,286,0,0,2},{336,288,0,0,2},{337,290,
0,0,2},{338,292,0,0,3},{339,295,0,0,3},{340,298,0,0,2},{341,300,0,0,2},{342,302,
0,0,2},{343,304,0,0,2},{344,306,0,0,2},{345,308,0,0,2},{346,310,0,0,2},{347,312,
0,0,2},{348,314,0,0,2},{349,316,0,0,2},{350,318,0,0,2},{351,320,0,0,2},{352,322,
0,0,2},{353,324,0,0,2},{354,326,0,0,2},{355,328,0,0,2},{356,330,0,0,2},{357,332,
0,0,2},{360,334,0,0,2},{361,336,0,0,2},{362,338,0,0,2},{363,340,0,0,2},{364,342,
0,0,2},{365,344,0,0,2},{366,346,0,0,2},{367,348,0,0,2},{368,350,0,0,2},{369,352,
0,0,2},{370,354,0,0,2},{371,356,0,0,2},{372,358,0,0,2},{373,360,0,0,2},{374,362,
0,0,2},{375,364,0,0,2},{376,366,0,0,2},{377,368,0,0,2},{378,370,0,0,2},{379,372,
0,0,2},{380,374,0,0,2},{381,376,0,0,2},{382,378,0,0,2},{383,380,0,0,2},{397,382,
0,0,2},{416,384,0,0,2},{417,386,0,0,2},{431,388,0,0,2},{432,390,0,0,2},{446,392,
0,0,2},{452,394,0,0,3},{453,397,0,0,3},{454,400,0,0,3},{455,403,0,0,2},{456,405,
0,0,2},{457,407,0,0,2},{458,409,0,0,2},{459,411,0,0,2},{460,413,0,0,2},{461,415,
0,0,2},{462,417,0,0,2},{463,419,0,0,2},{464,421,0,0,2},{465,423,0,0,2},{466,425,
0,0,2},{467,427,0,0,2},{468,429,0,0,2},{469,431,0,0,3},{470,434,0,0,3},{471,437,
0,0,3},{472,440,0,0,3},{473,443,0,0,3},{474,446,0,0,3},{475,449,0,0,3},{476,452,
0,0,3},{478,455,0,0,3},{479,458,0,0,3},{480,461,0,0,3},{481,464,0,0,3},{482,467,
0,0,4},{483,471,0,0,4},{486,475,0,0,2},{487,477,0,0,2},{488,479,0,0,2},{489,481,
0,0,2},{490,483,0,0,2},{491,485,0,0,2},{492,487,0,0,3},{493,490,0,0,3},{494,493,
0,0,2},{495,495,0,0,2},{496,497,0,0,2},{497,499,0,0,2},{498,501,0,0,2},{499,503,
0,0,2},{500,505,0,0,2},{501,507,0,0,2},{504,509,0,0,2},{505,511,0,0,2},{506,513,
0,0,3},{507,516,0,0,3},{508,519,0,0,4},{509,523,0,0,4},{510,527,0,0,3},{511,530,
0,0,3},{512,533,0,0,2},{513,535,0,0,2},{514,537,0,0,2},{515,539,0,0,2},{516,541,
0,0,2},{517,543,0,0,2},{518,545,0,0,2},{519,547,0,0,2},{520,549,0,0,2},{521,551,
0,0,2},{522,553,0,0,2},{523,555,0,0,2},{524,557,0,0,2},{525,559,0,0,2},{526,561,
0,0,2},{527,563,0,0,2},{528,565,0,0,2},{529,567,0,0,2},{530,569,0,0,2},{531,571,
0,0,2},{532,573,0,0,2},{533,575,0,0,2},{534,577,0,0,2},{535,579,0,0,2},{536,581,
0,0,2},{537,583,0,0,2},{538,585,0,0,2},{539,587,0,0,2},{542,589,0,0,2},{543,591,
0,0,2},{550,593,0,0,2},{551,595,0,0,2},{552,597,0,0,2},{553,599,0,0,2},{554,601,
0,0,3},{555,604,0,0,3},{556,607,0,0,3},{557,610,0,0,3},{558,613,0,0,2},{559,615,
0,0,2},{560,617,0,0,3},{561,620,0,0,3},{562,623,0,0,2},{563,625,0,0,2},{568,627,
0,0,2},{569,629,0,0,2},{675,631,0,0,2},{676,633,0,0,2},{677,635,0,0,2},{678,637,
0,0,2},{679,639,0,0,2},{680,641,0,0,2},{681,643,0,0,2},{682,645,0,0,2},{683,647,
0,0,2},{776,0,3805,1,0},{901,651,0,0,2},{902,653,0,0,2},{904,655,0,0,2},{905,
657,0,0,2},{906,659,0,0,2},{908,661,0,0,2},{910,663,0,0,2},{911,665,0,0,2},{912,
667,0,0,3},{938,670,0,0,2},{939,672,0,0,2},{940,674,0,0,2},{941,676,0,0,2},{942,
678,0,0,2},{943,680,0,0,2},{944,682,0,0,3},{970,685,0,0,2},{971,687,0,0,2},{972,
689,0,0,2},{973,691,0,0,2},{974,693,0,0,2},{975,695,0,0,3},{979,698,0,0,2},{980,
700,0,0,2},{983,702,0,0,3},{1024,705,0,0,2},{1025,707,0,0,2},{1027,709,0,0,2},
{1031,711,0,0,2},{1036,713,0,0,2},{1037,715,0,0,2},{1038,717,0,0,2},{1104,719,0,
0,2},{1105,721,0,0,2},{1107,723,0,0,2},{1111,725,0,0,2},{1116,727,0,0,2},{1117,
729,0,0,2},{1118,731,0,0,2},{1142,733,0,0,2},{1143,735,0,0,2},{1168,737,0,0,2},
{1169,739,0,0,2},{1217,741,0,0,2},{1218,743,0,0,2},{1232,745,0,0,2},{1233,747,0,
0,2},{1234,749,0,0,2},{1235,751,0,0,2},{1238,753,0,0,2},{1239,755,0,0,2},{1242,
757,0,0,2},{1243,759,0,0,2},{1244,761,0,0,2},{1245,763,0,0,2},{1246,765,0,0,2},
{1247,767,0,0,2},{1250,769,0,0,2},{1251,771,0,0,2},{1252,773,0,0,2},{1253,775,0,
0,2},{1254,777,0,0,2},{1255,779,0,0,2},{1258,781,0,0,2},{1259,783,0,0,2},{1260,
785,0,0,2},{1261,787,0,0,2},{1262,789,0,0,2},{1263,791,0,0,2},{1264,793,0,0,2},
{1265,795,0,0,2},{1266,797,0,0,2},{1267,799,0,0,2},{1268,801,0,0,2},{1269,803,0,
0,2},{1272,805,0,0,2},{1273,807,0,0,2},{1415,809,0,0,2},{1488,0,3806,3,0},{1489,
0,3809,2,0},{1490,0,3811,1,0},{1491,0,3812,1,0},{1492,0,3813,1,0},{1493,0,3814,
2,0},{1494,0,3816,1,0},{1496,0,3817,1,0},{1497,0,3818,2,0},{1498,0,3820,1,0},
{1499,0,3821,2,0},{1500,0,3823,1,0},{1502,0,3824,1,0},{1504,0,3825,1,0},{1505,0,
3826,1,0},{1507,0,3827,1,0},{1508,0,3828,2,0},{1510,0,3830,1,0},{1511,0,3831,1,
0},{1512,0,3832,1,0},{1513,0,3833,3,0},{1514,0,3838,1,0},{1520,879,0,0,2},{1521,
881,0,0,2},{1522,883,3839,1,2},{1653,888,0,0,2},{1654,890,0,0,2},{1655,892,0,0,
2},{1656,894,0,0,2},{1728,896,0,0,2},{1730,898,0,0,2},{1747,900,0,0,2},{1789,
902,0,0,2},{1790,904,0,0,2},{1812,906,0,0,2},{1820,908,0,0,2},{1831,910,0,0,2},
{1837,912,0,0,2},{1838,914,0,0,2},{1839,916,0,0,2},{2024,918,0,0,2},{2025,920,0,
0,2},{2026,922,0,0,2},{2325,0,3840,1,0},{2326,0,3841,1,0},{2327,0,3842,1,0},
{2332,0,3843,1,0},{2337,0,3844,1,0},{2338,0,3845,1,0},{2345,936,0,0,2},{2347,0,
3846,1,0},{2351,0,3847,1,0},{2353,942,0,0,2},{2356,944,0,0,2},{2465,0,3848,1,0},
{2466,0,3849,1,0},{2479,0,3850,1,0},{2510,952,0,0,2},{2582,0,3851,1,0},{2583,0,
3852,1,0},{2588,0,3853,1,0},{2603,0,3854,1,0},{2610,0,3855,1,0},{2616,0,3856,1,
0},{2849,0,3857,1,0},{2850,0,3858,1,0},{3406,970,0,0,2},{3412,972,0,0,2},{3413,
974,0,0,2},{3414,976,0,0,2},{3450,978,0,0,2},{3451,980,0,0,2},{3452,982,0,0,2},
{3453,984,0,0,2},{3454,986,0,0,2},{3455,988,0,0,2},{3648,0,3859,46,0},{3649,0,
3905,46,0},{3650,0,3951,46,0},{3651,0,3997,46,0},{3652,0,4043,46,0},{3661,0,
4089,1,0},{3776,0,4090,31,0},{3777,0,4121,31,0},{3778,0,4152,31,0},{3779,0,4183,
31,0},{3780,0,4214,31,0},{3789,0,4245,1,0},{3804,1772,0,0,2},{3805,1774,0,0,2},
{3840,1776,0,0,3},{3904,0,4246,1,0},{3906,0,4247,1,0},{3916,0,4248,1,0},{3921,0,
4249,1,0},{3926,0,4250,1,0},{3931,0,4251,1,0},{3946,1791,0,0,2},{3953,0,4252,3,
0},{3984,0,4255,1,0},{3986,0,4256,1,0},{3996,0,4257,1,0},{4001,0,4258,1,0},
{4006,0,4259,1,0},{4011,0,4260,1,0},{4018,0,4261,2,0},{4019,0,4264,2,0},{4026,
1812,0,0,2},{4027,1814,0,0,2},{4028,1816,0,0,2},{4159,1818,0,0,3},{5793,1821,0,
0,2},{5796,1823,0,0,2},{5797,1825,0,0,2},{5799,1827,0,0,2},{5801,1829,0,0,2},
{5804,1831,0,0,2},{5805,1833,0,0,2},{5806,1835,0,0,2},{5811,1837,0,0,2},{5812,
1839,0,0,2},{5813,1841,0,0,2},{5814,1843,0,0,2},{5819,1845,0,0,2},{5820,1847,0,
0,2},{5821,1849,0,0,2},{5823,1851,0,0,2},{5824,1853,0,0,2},{5826,1855,0,0,2},
{5828,1857,0,0,2},{5830,1859,0,0,2},{5835,1861,0,0,2},{5836,1863,0,0,2},{5837,
1865,0,0,2},{5838,1867,0,0,2},{5840,1869,0,0,2},{5841,1871,0,0,2},{5843,1873,0,
0,2},{5844,1875,0,0,2},{5845,1877,0,0,2},{5848,1879,0,0,2},{5849,1881,0,0,2},
{5851,1883,0,0,2},{5853,1885,0,0,2},{5863,1887,0,0,2},{5864,1889,0,0,2},{5865,
1891,0,0,2},{5866,1893,0,0,2},{5870,1895,0,0,2},{5871,1897,0,0,4},{5872,1901,0,
0,2},{6429,1903,0,0,2},{6430,1905,0,0,2},{6581,0,4267,44,0},{6582,0,4311,44,0},
{6583,0,4355,44,0},{6586,0,4399,44,0},{6622,2259,0,0,2},{6623,2261,0,0,3},{6740,
2264,0,0,3},{7469,2267,0,0,3},{7545,2270,0,0,2},{7546,2272,0,0,3},{7582,2275,0,
0,2},{7635,2277,0,0,2},{7636,2279,0,0,3},{7637,2282,0,0,2},{7638,2284,0,0,2},
{7639,2286,0,0,2},{7640,2288,0,0,2},{7641,2290,0,0,2},{7653,2292,0,0,2},{7661,
2294,0,0,2},{7664,2296,0,0,2},{7666,2298,0,0,2},{7667,2300,0,0,2},{7668,2302,0,
0,2},{7680,2304,0,0,2},{7681,2306,0,0,2},{7682,2308,0,0,2},{7683,2310,0,0,2},
{7684,2312,0,0,2},{7685,2314,0,0,2},{7686,2316,0,0,2},{7687,2318,0,0,2},{7688,
2320,0,0,3},{7689,2323,0,0,3},{7690,2326,0,0,2},{7691,2328,0,0,2},{7692,2330,0,
0,2},{7693,2332,0,0,2},{7694,2334,0,0,2},{7695,2336,0,0,2},{7696,2338,0,0,2},
{7697,2340,0,0,2},{7698,2342,0,0,2},{7699,2344,0,0,2},{7700,2346,0,0,3},{7701,
2349,0,0,3},{7702,2352,0,0,3},{7703,2355,0,0,3},{7704,2358,0,0,2},{7705,2360,0,
0,2},{7706,2362,0,0,2},{7707,2364,0,0,2},{7708,2366,0,0,3},{7709,2369,0,0,3},
{7710,2372,0,0,2},{7711,2374,0,0,2},{7712,2376,0,0,2},{7713,2378,0,0,2},{7714,
2380,0,0,2},{7715,2382,0,0,2},{7716,2384,0,0,2},{7717,2386,0,0,2},{7718,2388,0,
0,2},{7719,2390,0,0,2},{7720,2392,0,0,2},{7721,2394,0,0,2},{7722,2396,0,0,2},
{7723,2398,0,0,2},{7724,2400,0,0,2},{7725,2402,0,0,2},{7726,2404,0,0,3},{7727,
2407,0,0,3},{7728,2410,0,0,2},{7729,2412,0,0,2},{7730,2414,0,0,2},{7731,2416,0,
0,2},{7732,2418,0,0,2},{7733,2420,0,0,2},{7734,2422,0,0,2},{7735,2424,0,0,2},
{7736,2426,0,0,3},{7737,2429,0,0,3},{7738,2432,0,0,2},{7739,2434,0,0,2},{7740,
2436,0,0,2},{7741,2438,0,0,2},{7742,2440,0,0,2},{7743,2442,0,0,2},{7744,2444,0,
0,2},{7745,2446,0,0,2},{7746,2448,0,0,2},{7747,2450,0,0,2},{7748,2452,0,0,2},
{7749,2454,0,0,2},{7750,2456,0,0,2},{7751,2458,0,0,2},{7752,2460,0,0,2},{7753,
2462,0,0,2},{7754,2464,0,0,2},{7755,2466,0,0,2},{7756,2468,0,0,3},{7757,2471,0,
0,3},{7758,2474,0,0,3},{7759,2477,0,0,3},{7760,2480,0,0,3},{7761,2483,0,0,3},
{7762,2486,0,0,3},{7763,2489,0,0,3},{7764,2492,0,0,2},{7765,2494,0,0,2},{7766,
2496,0,0,2},{7767,2498,0,0,2},{7768,2500,0,0,2},{7769,2502,0,0,2},{7770,2504,0,
0,2},{7771,2506,0,0,2},{7772,2508,0,0,3},{7773,2511,0,0,3},{7774,2514,0,0,2},
{7775,2516,0,0,2},{7776,2518,0,0,2},{7777,2520,0,0,2},{7778,2522,0,0,2},{7779,
2524,0,0,2},{7780,2526,0,0,3},{7781,2529,0,0,3},{7782,2532,0,0,3},{7783,2535,0,
0,3},{7784,2538,0,0,3},{7785,2541,0,0,3},{7786,2544,0,0,2},{7787,2546,0,0,2},
{7788,2548,0,0,2},{7789,2550,0,0,2},{7790,2552,0,0,2},{7791,2554,0,0,2},{7792,
2556,0,0,2},{7793,2558,0,0,2},{7794,2560,0,0,2},{7795,2562,0,0,2},{7796,2564,0,
0,2},{7797,2566,0,0,2},{7798,2568,0,0,2},{7799,2570,0,0,2},{7800,2572,0,0,3},
{7801,2575,0,0,3},{7802,2578,0,0,3},{7803,2581,0,0,3},{7804,2584,0,0,2},{7805,
2586,0,0,2},{7806,2588,0,0,2},{7807,2590,0,0,2},{7808,2592,0,0,2},{7809,2594,0,
0,2},{7810,2596,0,0,2},{7811,2598,0,0,2},{7812,2600,0,0,2},{7813,2602,0,0,2},
{7814,2604,0,0,2},{7815,2606,0,0,2},{7816,2608,0,0,2},{7817,2610,0,0,2},{7818,
2612,0,0,2},{7819,2614,0,0,2},{7820,2616,0,0,2},{7821,2618,0,0,2},{7822,2620,0,
0,2},{7823,2622,0,0,2},{7824,2624,0,0,2},{7825,2626,0,0,2},{7826,2628,0,0,2},
{7827,2630,0,0,2},{7828,2632,0,0,2},{7829,2634,0,0,2},{7830,2636,0,0,2},{7831,
2638,0,0,2},{7832,2640,0,0,2},{7833,2642,0,0,2},{7834,2644,0,0,2},{7835,2646,0,
0,3},{7838,2649,0,0,3},{7840,2652,0,0,2},{7841,2654,0,0,2},{7842,2656,0,0,2},
{7843,2658,0,0,2},{7844,2660,0,0,3},{7845,2663,0,0,3},{7846,2666,0,0,3},{7847,
2669,0,0,3},{7848,2672,0,0,3},{7849,2675,0,0,3},{7850,2678,0,0,3},{7851,2681,0,
0,3},{7852,2684,0,0,3},{7853,2687,0,0,3},{7854,2690,0,0,3},{7855,2693,0,0,3},
{7856,2696,0,0,3},{7857,2699,0,0,3},{7858,2702,0,0,3},{7859,2705,0,0,3},{7860,
2708,0,0,3},{7861,2711,0,0,3},{7862,2714,0,0,3},{7863,2717,0,0,3},{7864,2720,0,
0,2},{7865,2722,0,0,2},{7866,2724,0,0,2},{7867,2726,0,0,2},{7868,2728,0,0,2},
{7869,2730,0,0,2},{7870,2732,0,0,3},{7871,2735,0,0,3},{7872,2738,0,0,3},{7873,
2741,0,0,3},{7874,2744,0,0,3},{7875,2747,0,0,3},{7876,2750,0,0,3},{7877,2753,0,
0,3},{7878,2756,0,0,3},{7879,2759,0,0,3},{7880,2762,0,0,2},{7881,2764,0,0,2},
{7882,2766,0,0,2},{7883,2768,0,0,2},{7884,2770,0,0,2},{7885,2772,0,0,2},{7886,
2774,0,0,2},{7887,2776,0,0,2},{7888,2778,0,0,3},{7889,2781,0,0,3},{7890,2784,0,
0,3},{7891,2787,0,0,3},{7892,2790,0,0,3},{7893,2793,0,0,3},{7894,2796,0,0,3},
{7895,2799,0,0,3},{7896,2802,0,0,3},{7897,2805,0,0,3},{7898,2808,0,0,3},{7899,
2811,0,0,3},{7900,2814,0,0,3},{7901,2817,0,0,3},{7902,2820,0,0,3},{7903,2823,0,
0,3},{7904,2826,0,0,3},{7905,2829,0,0,3},{7906,2832,0,0,3},{7907,2835,0,0,3},
{7908,2838,0,0,2},{7909,2840,0,0,2},{7910,2842,0,0,2},{7911,2844,0,0,2},{7912,
2846,0,0,3},{7913,2849,0,0,3},{7914,2852,0,0,3},{7915,2855,0,0,3},{7916,2858,0,
0,3},{7917,2861,0,0,3},{7918,2864,0,0,3},{7919,2867,0,0,3},{7920,2870,0,0,3},
{7921,2873,0,0,3},{7922,2876,0,0,2},{7923,2878,0,0,2},{7924,2880,0,0,2},{7925,
2882,0,0,2},{7926,2884,0,0,2},{7927,2886,0,0,2},{7928,2888,0,0,2},{7929,2890,0,
0,2},{7930,2892,0,0,2},{7931,2894,0,0,2},{7936,2896,0,0,2},{7937,2898,0,0,2},
{7938,2900,0,0,3},{7939,2903,0,0,3},{7940,2906,0,0,3},{7941,2909,0,0,3},{7942,
2912,0,0,3},{7943,2915,0,0,3},{7944,2918,0,0,2},{7945,2920,0,0,2},{7946,2922,0,
0,3},{7947,2925,0,0,3},{7948,2928,0,0,3},{7949,2931,0,0,3},{7950,2934,0,0,3},
{7951,2937,0,0,3},{7952,2940,0,0,2},{7953,2942,0,0,2},{7954,2944,0,0,3},{7955,
2947,0,0,3},{7956,2950,0,0,3},{7957,2953,0,0,3},{7960,2956,0,0,2},{7961,2958,0,
0,2},{7962,2960,0,0,3},{7963,2963,0,0,3},{7964,2966,0,0,3},{7965,2969,0,0,3},
{7968,2972,0,0,2},{7969,2974,0,0,2},{7970,2976,0,0,3},{7971,2979,0,0,3},{7972,
2982,0,0,3},{7973,2985,0,0,3},{7974,2988,0,0,3},{7975,2991,0,0,3},{7976,2994,0,
0,2},{7977,2996,0,0,2},{7978,2998,0,0,3},{7979,3001,0,0,3},{7980,3004,0,0,3},
{7981,3007,0,0,3},{7982,3010,0,0,3},{7983,3013,0,0,3},{7984,3016,0,0,2},{7985,
3018,0,0,2},{7986,3020,0,0,3},{7987,3023,0,0,3},{7988,3026,0,0,3},{7989,3029,0,
0,3},{7990,3032,0,0,3},{7991,3035,0,0,3},{7992,3038,0,0,2},{7993,3040,0,0,2},
{7994,3042,0,0,3},{7995,3045,0,0,3},{7996,3048,0,0,3},{7997,3051,0,0,3},{7998,
3054,0,0,3},{7999,3057,0,0,3},{8000,3060,0,0,2},{8001,3062,0,0,2},{8002,3064,0,
0,3},{8003,3067,0,0,3},{8004,3070,0,0,3},{8005,3073,0,0,3},{8008,3076,0,0,2},
{8009,3078,0,0,2},{8010,3080,0,0,3},{8011,3083,0,0,3},{8012,3086,0,0,3},{8013,
3089,0,0,3},{8016,3092,0,0,2},{8017,3094,0,0,2},{8018,3096,0,0,3},{8019,3099,0,
0,3},{8020,3102,0,0,3},{8021,3105,0,0,3},{8022,3108,0,0,3},{8023,3111,0,0,3},
{8025,3114,0,0,2},{8027,3116,0,0,3},{8029,3119,0,0,3},{8031,3122,0,0,3},{8032,
3125,0,0,2},{8033,3127,0,0,2},{8034,3129,0,0,3},{8035,3132,0,0,3},{8036,3135,0,
0,3},{8037,3138,0,0,3},{8038,3141,0,0,3},{8039,3144,0,0,3},{8040,3147,0,0,2},
{8041,3149,0,0,2},{8042,3151,0,0,3},{8043,3154,0,0,3},{8044,3157,0,0,3},{8045,
3160,0,0,3},{8046,3163,0,0,3},{8047,3166,0,0,3},{8048,3169,0,0,2},{8050,3171,0,
0,2},{8052,3173,0,0,2},{8054,3175,0,0,2},{8056,3177,0,0,2},{8058,3179,0,0,2},
{8060,3181,0,0,2},{8064,3183,0,0,3},{8065,3186,0,0,3},{8066,3189,0,0,4},{8067,
3193,0,0,4},{8068,3197,0,0,4},{8069,3201,0,0,4},{8070,3205,0,0,4},{8071,3209,0,
0,4},{8072,3213,0,0,3},{8073,3216,0,0,3},{8074,3219,0,0,4},{8075,3223,0,0,4},
{8076,3227,0,0,4},{8077,3231,0,0,4},{8078,3235,0,0,4},{8079,3239,0,0,4},{8080,
3243,0,0,3},{8081,3246,0,0,3},{8082,3249,0,0,4},{8083,3253,0,0,4},{8084,3257,0,
0,4},{8085,3261,0,0,4},{8086,3265,0,0,4},{8087,3269,0,0,4},{8088,3273,0,0,3},
{8089,3276,0,0,3},{8090,3279,0,0,4},{8091,3283,0,0,4},{8092,3287,0,0,4},{8093,
3291,0,0,4},{8094,3295,0,0,4},{8095,3299,0,0,4},{8096,3303,0,0,3},{8097,3306,0,
0,3},{8098,3309,0,0,4},{8099,3313,0,0,4},{8100,3317,0,0,4},{8101,3321,0,0,4},
{8102,3325,0,0,4},{8103,3329,0,0,4},{8104,3333,0,0,3},{8105,3336,0,0,3},{8106,
3339,0,0,4},{8107,3343,0,0,4},{8108,3347,0,0,4},{8109,3351,0,0,4},{8110,3355,0,
0,4},{8111,3359,0,0,4},{8112,3363,0,0,2},{8113,3365,0,0,2},{8114,3367,0,0,3},
{8115,3370,0,0,2},{8116,3372,0,0,3},{8118,3375,0,0,2},{8119,3377,0,0,3},{8120,
3380,0,0,2},{8121,3382,0,0,2},{8122,3384,0,0,2},{8124,3386,0,0,2},{8129,3388,0,
0,2},{8130,3390,0,0,3},{8131,3393,0,0,2},{8132,3395,0,0,3},{8134,3398,0,0,2},
{8135,3400,0,0,3},{8136,3403,0,0,2},{8138,3405,0,0,2},{8140,3407,0,0,2},{8141,
3409,0,0,2},{8142,3411,0,0,2},{8143,3413,0,0,2},{8144,3415,0,0,2},{8145,3417,0,
0,2},{8146,3419,0,0,3},{8150,3422,0,0,2},{8151,3424,0,0,3},{8152,3427,0,0,2},
{8153,3429,0,0,2},{8154,3431,0,0,2},{8157,3433,0,0,2},{8158,3435,0,0,2},{8159,
3437,0,0,2},{8160,3439,0,0,2},{8161,3441,0,0,2},{8162,3443,0,0,3},{8164,3446,0,
0,2},{8165,3448,0,0,2},{8166,3450,0,0,2},{8167,3452,0,0,3},{8168,3455,0,0,2},
{8169,3457,0,0,2},{8170,3459,0,0,2},{8172,3461,0,0,2},{8173,3463,0,0,2},{8178,
3465,0,0,3},{8179,3468,0,0,2},{8180,3470,0,0,3},{8182,3473,0,0,2},{8183,3475,0,
0,3},{8184,3478,0,0,2},{8186,3480,0,0,2},{8188,3482,0,0,2},{8229,3484,0,0,2},
{8230,3486,0,0,3},{8243,3489,0,0,2},{8244,3491,0,0,3},{8246,3494,0,0,2},{8247,
3496,0,0,3},{8252,3499,0,0,2},{8263,3501,0,0,2},{8264,3503,0,0,2},{8265,3505,0,
0,2},{8279,3507,0,0,4},{8360,3511,0,0,2},{8448,3513,0,0,3},{8449,3516,0,0,3},
{8451,3519,0,0,2},{8453,3521,0,0,3},{8454,3524,0,0,3},{8457,3527,0,0,2},{8463,
3529,0,0,2},{8470,3531,0,0,2},{8480,3533,0,0,2},{8481,3535,0,0,3},{8482,3538,0,
0,2},{8507,3540,0,0,3},{8525,3543,0,0,3},{8528,3546,0,0,3},{8529,3549,0,0,3},
{8530,3552,0,0,4},{8531,3556,0,0,3},{8532,3559,0,0,3},{8533,3562,0,0,3},{8534,
3565,0,0,3},{8535,3568,0,0,3},{8536,3571,0,0,3},{8537,3574,0,0,3},{8538,3577,0,
0,3},{8539,3580,0,0,3},{8540,3583,0,0,3},{8541,3586,0,0,3},{8542,3589,0,0,3},
{8543,3592,0,0,2},{8545,3594,0,0,2},{8546,3596,0,0,3},{8547,3599,0,0,2},{8549,
3601,0,0,2},{8550,3603,0,0,3},{8551,3606,0,0,4},{8552,3610,0,0,2},{8554,3612,0,
0,2},{8555,3614,0,0,3},{8561,3617,0,0,2},{8562,3619,0,0,3},{8563,3622,0,0,2},
{8565,3624,0,0,2},{8566,3626,0,0,3},{8567,3629,0,0,4},{8568,3633,0,0,2},{8570,
3635,0,0,2},{8571,3637,0,0,3},{8585,3640,0,0,3},{8602,3643,0,0,2},{8603,3645,0,
0,2},{8622,3647,0,0,2},{8653,3649,0,0,2},{8654,3651,0,0,2},{8655,3653,0,0,2},
{8708,3655,0,0,2},{8713,3657,0,0,2},{8716,3659,0,0,2},{8740,3661,0,0,2},{8742,
3663,0,0,2},{8748,3665,0,0,2},{8749,3667,0,0,3},{8751,3670,0,0,2},{8752,3672,0,
0,3},{8769,3675,0,0,2},{8772,3677,0,0,2},{8775,3679,0,0,2},{8777,3681,0,0,2},
{8800,3683,0,0,2},{8802,3685,0,0,2},{8813,3687,0,0,2},{8814,3689,0,0,2},{8815,
3691,0,0,2},{8816,3693,0,0,2},{8817,3695,0,0,2},{8820,3697,0,0,2},{8821,3699,0,
0,2},{8824,3701,0,0,2},{8825,3703,0,0,2},{8832,3705,0,0,2},{8833,3707,0,0,2},
{8836,3709,0,0,2},{8837,3711,0,0,2},{8840,3713,0,0,2},{8841,3715,0,0,2},{8876,
3717,0,0,2},{8877,3719,0,0,2},{8878,3721,0,0,2},{8879,3723,0,0,2},{8928,3725,0,
0,2},{8929,3727,0,0,2},{8930,3729,0,0,2},{8931,3731,0,0,2},{8938,3733,0,0,2},
{8939,3735,0,0,2},{8940,3737,0,0,2},{8941,3739,0,0,2},{9321,3741,0,0,2},{9322,
3743,0,0,2},{9323,3745,0,0,2},{9324,3747,0,0,2},{9325,3749,0,0,2},{9326,3751,0,
0,2},{9327,3753,0,0,2},{9328,3755,0,0,2},{9329,3757,0,0,2},{9330,3759,0,0,2},
{9331,3761,0,0,2},{9332,3763,0,0,3},{9333,3766,0,0,3},{9334,3769,0,0,3},{9335,
3772,0,0,3},{9336,3775,0,0,3},{9337,3778,0,0,3},{9338,3781,0,0,3},{9339,3784,0,
0,3},{9340,3787,0,0,3},{9341,3790,0,0,4},{9342,3794,0,0,4},{9343,3798,0,0,4},
{9344,3802,0,0,4},{9345,3806,0,0,4},{9346,3810,0,0,4},{9347,3814,0,0,4},{9348,
3818,0,0,4},{9349,3822,0,0,4},{9350,3826,0,0,4},{9351,3830,0,0,4},{9352,3834,0,
0,2},{9353,3836,0,0,2},{9354,3838,0,0,2},{9355,3840,0,0,2},{9356,3842,0,0,2},
{9357,3844,0,0,2},{9358,3846,0,0,2},{9359,3848,0,0,2},{9360,3850,0,0,2},{9361,
3852,0,0,3},{9362,3855,0,0,3},{9363,3858,0,0,3},{9364,3861,0,0,3},{9365,3864,0,
0,3},{9366,3867,0,0,3},{9367,3870,0,0,3},{9368,3873,0,0,3},{9369,3876,0,0,3},
{9370,3879,0,0,3},{9371,3882,0,0,3},{9372,3885,0,0,3},{9373,3888,0,0,3},{9374,
3891,0,0,3},{9375,3894,0,0,3},{9376,3897,0,0,3},{9377,3900,0,0,3},{9378,3903,0,
0,3},{9379,3906,0,0,3},{9380,3909,0,0,3},{9381,3912,0,0,3},{9382,3915,0,0,3},
{9383,3918,0,0,3},{9384,3921,0,0,3},{9385,3924,0,0,3},{9386,3927,0,0,3},{9387,
3930,0,0,3},{9388,3933,0,0,3},{9389,3936,0,0,3},{9390,3939,0,0,3},{9391,3942,0,
0,3},{9392,3945,0,0,3},{9393,3948,0,0,3},{9394,3951,0,0,3},{9395,3954,0,0,3},
{9396,3957,0,0,3},{9397,3960,0,0,3},{9451,3963,0,0,2},{9452,3965,0,0,2},{9453,
3967,0,0,2},{9454,3969,0,0,2},{9455,3971,0,0,2},{9456,3973,0,0,2},{9457,3975,0,
0,2},{9458,3977,0,0,2},{9459,3979,0,0,2},{9460,3981,0,0,2},{9470,3983,0,0,2},
{10111,3985,0,0,2},{10121,3987,0,0,2},{10131,3989,0,0,2},{10764,3991,0,0,4},
{10868,3995,0,0,3},{10869,3998,0,0,2},{10870,4000,0,0,3},{10973,0,4443,1,0},
{11492,4005,0,0,3},{11765,4008,0,0,2},{11904,4010,0,0,3},{11905,4013,0,0,3},
{11906,4016,0,0,2},{11907,4018,0,0,2},{11908,4020,0,0,3},{11909,4023,0,0,2},
{11910,4025,0,0,3},{11911,4028,0,0,3},{11912,4031,0,0,3},{11913,4034,0,0,2},
{11914,4036,0,0,3},{11915,4039,0,0,3},{11916,4042,0,0,3},{11917,4045,0,0,3},
{11918,4048,0,0,3},{11919,4051,0,0,2},{11920,4053,0,0,2},{11921,4055,0,0,3},
{11922,4058,0,0,2},{11923,4060,0,0,2},{11924,4062,0,0,2},{11925,4064,0,0,3},
{11926,4067,0,0,2},{11927,4069,0,0,3},{11928,4072,0,0,2},{11929,4074,0,0,2},
{11931,4076,0,0,2},{11932,4078,0,0,3},{11933,4081,0,0,3},{11934,4084,0,0,3},
{11935,4087,0,0,2},{11936,4089,0,0,2},{11937,4091,0,0,2},{11938,4093,0,0,2},
{11939,4095,0,0,2},{11940,4097,0,0,2},{11941,4099,0,0,3},{11942,4102,0,0,2},
{11943,4104,0,0,3},{11944,4107,0,0,2},{11945,4109,0,0,3},{11946,4112,0,0,3},
{11947,4115,0,0,3},{11948,4118,0,0,3},{11949,4121,0,0,2},{11950,4123,0,0,3},
{11951,4126,0,0,2},{11952,4128,0,0,2},{11953,4130,0,0,2},{11954,4132,0,0,2},
{11955,4134,0,0,3},{11956,4137,0,0,3},{11957,4140,0,0,3},{11958,4143,0,0,3},
{11959,4146,0,0,3},{11960,4149,0,0,2},{11961,4151,0,0,2},{11962,4153,0,0,2},
{11963,4155,0,0,3},{11964,4158,0,0,3},{11965,4161,0,0,3},{11966,4164,0,0,2},
{11967,4166,0,0,3},{11968,4169,0,0,3},{11969,4172,0,0,2},{11970,4174,0,0,2},
{11971,4176,0,0,2},{11972,4178,0,0,2},{11973,4180,0,0,2},{11974,4182,0,0,2},
{11975,4184,0,0,3},{11976,4187,0,0,2},{11977,4189,0,0,2},{11978,4191,0,0,3},
{11979,4194,0,0,2},{11980,4196,0,0,2},{11981,4198,0,0,3},{11982,4201,0,0,3},
{11983,4204,0,0,3},{11984,4207,0,0,2},{11985,4209,0,0,2},{11986,4211,0,0,2},
{11987,4213,0,0,2},{11988,4215,0,0,2},{11989,4217,0,0,3},{11990,4220,0,0,2},
{11991,4222,0,0,3},{11992,4225,0,0,2},{11993,4227,0,0,2},{11994,4229,0,0,2},
{11995,4231,0,0,2},{11996,4233,0,0,2},{11997,4235,0,0,2},{11998,4237,0,0,3},
{11999,4240,0,0,2},{12000,4242,0,0,2},{12001,4244,0,0,3},{12002,4247,0,0,2},
{12003,4249,0,0,3},{12004,4252,0,0,3},{12005,4255,0,0,2},{12006,4257,0,0,2},
{12007,4259,0,0,3},{12008,4262,0,0,2},{12009,4264,0,0,2},{12010,4266,0,0,2},
{12011,4268,0,0,3},{12012,4271,0,0,2},{12013,4273,0,0,3},{12014,4276,0,0,2},
{12015,4278,0,0,3},{12016,4281,0,0,2},{12017,4283,0,0,3},{12018,4286,0,0,3},
{12019,4289,0,0,2},{12032,4291,0,0,2},{12033,4293,0,0,2},{12034,4295,0,0,2},
{12035,4297,0,0,2},{12036,4299,0,0,2},{12037,4301,0,0,2},{12038,4303,0,0,2},
{12039,4305,0,0,2},{12040,4307,0,0,2},{12041,4309,0,0,2},{12042,4311,0,0,2},
{12043,4313,0,0,2},{12044,4315,0,0,2},{12045,4317,0,0,2},{12046,4319,0,0,2},
{12047,4321,0,0,2},{12048,4323,0,0,2},{12049,4325,0,0,2},{12050,4327,0,0,2},
{12051,4329,0,0,2},{12052,4331,0,0,2},{12053,4333,0,0,2},{12054,4335,0,0,2},
{12055,4337,0,0,2},{12056,4339,0,0,2},{12057,4341,0,0,2},{12058,4343,0,0,2},
{12059,4345,0,0,2},{12060,4347,0,0,2},{12061,4349,0,0,2},{12062,4351,0,0,2},
{12063,4353,0,0,2},{12064,4355,0,0,2},{12065,4357,0,0,2},{12066,4359,0,0,2},
{12067,4361,0,0,2},{12068,4363,0,0,2},{12069,4365,0,0,2},{12070,4367,0,0,2},
{12071,4369,0,0,2},{12072,4371,0,0,2},{12073,4373,0,0,2},{12074,4375,0,0,2},
{12075,4377,0,0,2},{12076,4379,0,0,2},{12077,4381,0,0,2},{12078,4383,0,0,2},
{12079,4385,0,0,2},{12080,4387,0,0,2},{12081,4389,0,0,2},{12082,4391,0,0,2},
{12083,4393,0,0,2},{12084,4395,0,0,2},{12085,4397,0,0,2},{12086,4399,0,0,2},
{12087,4401,0,0,2},{12088,4403,0,0,2},{12089,4405,0,0,2},{12090,4407,0,0,2},
{12091,4409,0,0,2},{12092,4411,0,0,2},{12093,4413,0,0,2},{12094,4415,0,0,2},
{12095,4417,0,0,2},{12096,4419,0,0,2},{12097,4421,0,0,2},{12098,4423,0,0,2},
{12099,4425,0,0,2},{12100,4427,0,0,2},{12101,4429,0,0,2},{12102,4431,0,0,2},
{12103,4433,0,0,2},{12104,4435,0,0,2},{12105,4437,0,0,2},{12106,4439,0,0,2},
{12107,4441,0,0,2},{12108,4443,0,0,2},{12109,4445,0,0,2},{12110,4447,0,0,2},
{12111,4449,0,0,2},{12112,4451,0,0,2},{12113,4453,0,0,2},{12114,4455,0,0,2},
{12115,4457,0,0,2},{12116,4459,0,0,2},{12117,4461,0,0,2},{12118,4463,0,0,2},
{12119,4465,0,0,2},{12120,4467,0,0,2},{12121,4469,0,0,2},{12122,4471,0,0,2},
{12123,4473,0,0,2},{12124,4475,0,0,2},{12125,4477,0,0,2},{12126,4479,0,0,2},
{12127,4481,0,0,2},{12128,4483,0,0,2},{12129,4485,0,0,2},{12130,4487,0,0,2},
{12131,4489,0,0,2},{12132,4491,0,0,2},{12133,4493,0,0,2},{12134,4495,0,0,2},
{12135,4497,0,0,2},{12136,4499,0,0,2},{12137,4501,0,0,2},{12138,4503,0,0,2},
{12139,4505,0,0,2},{12140,4507,0,0,2},{12141,4509,0,0,2},{12142,4511,0,0,2},
{12143,4513,0,0,2},{12144,4515,0,0,2},{12145,4517,0,0,2},{12146,4519,0,0,2},
{12147,4521,0,0,2},{12148,4523,0,0,2},{12149,4525,0,0,2},{12150,4527,0,0,2},
{12151,4529,0,0,2},{12152,4531,0,0,2},{12153,4533,0,0,2},{12154,4535,0,0,2},
{12155,4537,0,0,2},{12156,4539,0,0,2},{12157,4541,0,0,2},{12158,4543,0,0,2},
{12159,4545,0,0,2},{12160,4547,0,0,2},{12161,4549,0,0,2},{12162,4551,0,0,2},
{12163,4553,0,0,2},{12164,4555,0,0,2},{12165,4557,0,0,2},{12166,4559,0,0,2},
{12167,4561,0,0,2},{12168,4563,0,0,2},{12169,4565,0,0,2},{12170,4567,0,0,2},
{12171,4569,0,0,2},{12172,4571,0,0,2},{12173,4573,0,0,2},{12174,4575,0,0,2},
{12175,4577,0,0,2},{12176,4579,0,0,2},{12177,4581,0,0,2},{12178,4583,0,0,2},
{12179,4585,0,0,2},{12180,4587,0,0,2},{12181,4589,0,0,2},{12182,4591,0,0,2},
{12183,4593,0,0,2},{12184,4595,0,0,2},{12185,4597,0,0,2},{12186,4599,0,0,2},
{12187,4601,0,0,2},{12188,4603,0,0,2},{12189,4605,0,0,2},{12190,4607,0,0,2},
{12191,4609,0,0,2},{12192,4611,0,0,2},{12193,4613,0,0,2},{12194,4615,0,0,2},
{12195,4617,0,0,2},{12196,4619,0,0,2},{12197,4621,0,0,2},{12198,4623,0,0,2},
{12199,4625,0,0,2},{12200,4627,0,0,2},{12201,4629,0,0,2},{12202,4631,0,0,2},
{12203,4633,0,0,2},{12204,4635,0,0,2},{12205,4637,0,0,2},{12206,4639,0,0,2},
{12207,4641,0,0,2},{12208,4643,0,0,2},{12209,4645,0,0,2},{12210,4647,0,0,2},
{12211,4649,0,0,2},{12212,4651,0,0,2},{12213,4653,0,0,2},{12214,4655,0,0,2},
{12215,4657,0,0,2},{12216,4659,0,0,2},{12217,4661,0,0,2},{12218,4663,0,0,2},
{12219,4665,0,0,2},{12220,4667,0,0,2},{12221,4669,0,0,2},{12222,4671,0,0,2},
{12223,4673,0,0,2},{12224,4675,0,0,2},{12225,4677,0,0,2},{12226,4679,0,0,2},
{12227,4681,0,0,2},{12228,4683,0,0,2},{12229,4685,0,0,2},{12230,4687,0,0,2},
{12231,4689,0,0,2},{12232,4691,0,0,2},{12233,4693,0,0,2},{12234,4695,0,0,2},
{12235,4697,0,0,2},{12236,4699,0,0,2},{12237,4701,0,0,2},{12238,4703,0,0,2},
{12239,4705,0,0,2},{12240,4707,0,0,2},{12241,4709,0,0,2},{12242,4711,0,0,2},
{12243,4713,0,0,2},{12244,4715,0,0,2},{12245,4717,0,0,2},{12294,4719,0,0,2},
{12338,4721,0,0,2},{12340,4723,0,0,2},{12344,4725,0,0,2},{12345,4727,0,0,2},
{12346,4729,0,0,2},{12348,4731,0,0,2},{12364,4733,0,0,2},{12366,4735,0,0,2},
{12368,4737,0,0,2},{12370,4739,0,0,2},{12372,4741,0,0,2},{12374,4743,0,0,2},
{12376,4745,0,0,2},{12378,4747,0,0,2},{12380,4749,0,0,2},{12382,4751,0,0,2},
{12384,4753,0,0,2},{12386,4755,0,0,2},{12389,4757,0,0,2},{12391,4759,0,0,2},
{12393,4761,0,0,2},{12400,4763,0,0,2},{12401,4765,0,0,2},{12403,4767,0,0,2},
{12404,4769,0,0,2},{12406,4771,0,0,2},{12407,4773,0,0,2},{12409,4775,0,0,2},
{12410,4777,0,0,2},{12412,4779,0,0,2},{12413,4781,0,0,2},{12436,4783,0,0,2},
{12446,4785,0,0,2},{12447,4787,0,0,2},{12460,4789,0,0,2},{12462,4791,0,0,2},
{12464,4793,0,0,2},{12466,4795,0,0,2},{12468,4797,0,0,2},{12470,4799,0,0,2},
{12472,4801,0,0,2},{12474,4803,0,0,2},{12476,4805,0,0,2},{12478,4807,0,0,2},
{12480,4809,0,0,2},{12482,4811,0,0,2},{12485,4813,0,0,2},{12487,4815,0,0,2},
{12489,4817,0,0,2},{12496,4819,0,0,2},{12497,4821,0,0,2},{12499,4823,0,0,2},
{12500,4825,0,0,2},{12502,4827,0,0,2},{12503,4829,0,0,2},{12505,4831,0,0,2},
{12506,4833,0,0,2},{12508,4835,0,0,2},{12509,4837,0,0,2},{12532,4839,0,0,2},
{12535,4841,0,0,2},{12536,4843,0,0,2},{12537,4845,0,0,2},{12538,4847,0,0,2},
{12542,4849,0,0,2},{12543,4851,0,0,2},{12690,4853,0,0,2},{12691,4855,0,0,2},
{12692,4857,0,0,2},{12693,4859,0,0,2},{12694,4861,0,0,2},{12695,4863,0,0,2},
{12696,4865,0,0,2},{12697,4867,0,0,2},{12698,4869,0,0,2},{12699,4871,0,0,2},
{12700,4873,0,0,2},{12701,4875,0,0,2},{12702,4877,0,0,2},{12703,4879,0,0,2},
{12704,4881,0,0,2},{12705,4883,0,0,2},{12706,4885,0,0,2},{12707,4887,0,0,2},
{12709,4889,0,0,2},{12711,4891,0,0,2},{12712,4893,0,0,2},{12713,4895,0,0,2},
{12714,4897,0,0,2},{12715,4899,0,0,2},{12718,4901,0,0,2},{12719,4903,0,0,2},
{12723,4905,0,0,2},{12800,4907,0,0,3},{12801,4910,0,0,3},{12802,4913,0,0,3},
{12803,4916,0,0,3},{12804,4919,0,0,3},{12805,4922,0,0,3},{12806,4925,0,0,3},
{12807,4928,0,0,3},{12808,4931,0,0,3},{12809,4934,0,0,3},{12810,4937,0,0,3},
{12811,4940,0,0,3},{12812,4943,0,0,3},{12813,4946,0,0,3},{12814,4949,0,0,4},
{12815,4953,0,0,4},{12816,4957,0,0,4},{12817,4961,0,0,4},{12818,4965,0,0,4},
{12819,4969,0,0,4},{12820,4973,0,0,4},{12821,4977,0,0,4},{12822,4981,0,0,4},
{12823,4985,0,0,4},{12824,4989,0,0,4},{12825,4993,0,0,4},{12826,4997,0,0,4},
{12827,5001,0,0,4},{12828,5005,0,0,4},{12829,5009,0,0,7},{12830,5016,0,0,6},
{12832,5022,0,0,4},{12833,5026,0,0,4},{12834,5030,0,0,4},{12835,5034,0,0,4},
{12836,5038,0,0,4},{12837,5042,0,0,4},{12838,5046,0,0,4},{12839,5050,0,0,4},
{12840,5054,0,0,4},{12841,5058,0,0,4},{12842,5062,0,0,4},{12843,5066,0,0,4},
{12844,5070,0,0,4},{12845,5074,0,0,4},{12846,5078,0,0,4},{12847,5082,0,0,4},
{12848,5086,0,0,4},{12849,5090,0,0,4},{12850,5094,0,0,4},{12851,5098,0,0,4},
{12852,5102,0,0,4},{12853,5106,0,0,4},{12854,5110,0,0,4},{12855,5114,0,0,4},
{12856,5118,0,0,4},{12857,5122,0,0,4},{12858,5126,0,0,4},{12859,5130,0,0,4},
{12860,5134,0,0,4},{12861,5138,0,0,4},{12862,5142,0,0,4},{12863,5146,0,0,4},
{12864,5150,0,0,4},{12865,5154,0,0,4},{12866,5158,0,0,4},{12867,5162,0,0,4},
{12868,5166,0,0,2},{12869,5168,0,0,2},{12870,5170,0,0,2},{12871,5172,0,0,2},
{12872,5174,0,0,2},{12873,5176,0,0,2},{12874,5178,0,0,2},{12875,5180,0,0,2},
{12876,5182,0,0,2},{12877,5184,0,0,2},{12878,5186,0,0,2},{12879,5188,0,0,2},
{12880,5190,0,0,3},{12881,5193,0,0,2},{12882,5195,0,0,2},{12883,5197,0,0,2},
{12884,5199,0,0,2},{12885,5201,0,0,2},{12886,5203,0,0,2},{12887,5205,0,0,2},
{12888,5207,0,0,2},{12889,5209,0,0,2},{12890,5211,0,0,2},{12891,5213,0,0,2},
{12892,5215,0,0,2},{12893,5217,0,0,2},{12894,5219,0,0,2},{12895,5221,0,0,2},
{12910,5223,0,0,2},{12911,5225,0,0,2},{12912,5227,0,0,2},{12913,5229,0,0,2},
{12914,5231,0,0,2},{12915,5233,0,0,2},{12916,5235,0,0,2},{12917,5237,0,0,2},
{12918,5239,0,0,2},{12919,5241,0,0,2},{12920,5243,0,0,2},{12921,5245,0,0,2},
{12922,5247,0,0,2},{12923,5249,0,0,2},{12924,5251,0,0,5},{12925,5256,0,0,4},
{12926,5260,0,0,2},{12928,5262,0,0,2},{12929,5264,0,0,2},{12930,5266,0,0,2},
{12931,5268,0,0,2},{12932,5270,0,0,2},{12933,5272,0,0,2},{12934,5274,0,0,2},
{12935,5276,0,0,2},{12936,5278,0,0,2},{12937,5280,0,0,2},{12938,5282,0,0,2},
{12939,5284,0,0,2},{12940,5286,0,0,2},{12941,5288,0,0,2},{12942,5290,0,0,2},
{12943,5292,0,0,2},{12944,5294,0,0,2},{12945,5296,0,0,2},{12946,5298,0,0,2},
{12947,5300,0,0,2},{12948,5302,0,0,2},{12949,5304,0,0,2},{12950,5306,0,0,2},
{12951,5308,0,0,2},{12952,5310,0,0,2},{12953,5312,0,0,2},{12954,5314,0,0,2},
{12955,5316,0,0,2},{12956,5318,0,0,2},{12957,5320,0,0,2},{12958,5322,0,0,2},
{12959,5324,0,0,2},{12960,5326,0,0,2},{12961,5328,0,0,2},{12962,5330,0,0,2},
{12963,5332,0,0,2},{12964,5334,0,0,2},{12965,5336,0,0,2},{12966,5338,0,0,2},
{12967,5340,0,0,2},{12968,5342,0,0,2},{12969,5344,0,0,2},{12970,5346,0,0,2},
{12971,5348,0,0,2},{12972,5350,0,0,2},{12973,5352,0,0,2},{12974,5354,0,0,2},
{12975,5356,0,0,2},{12976,5358,0,0,2},{12977,5360,0,0,2},{12978,5362,0,0,2},
{12979,5364,0,0,2},{12980,5366,0,0,2},{12981,5368,0,0,2},{12982,5370,0,0,2},
{12983,5372,0,0,2},{12984,5374,0,0,2},{12985,5376,0,0,2},{12986,5378,0,0,2},
{12987,5380,0,0,2},{12988,5382,0,0,2},{12989,5384,0,0,2},{12990,5386,0,0,2},
{12991,5388,0,0,2},{12992,5390,0,0,3},{12993,5393,0,0,3},{12994,5396,0,0,3},
{12995,5399,0,0,3},{12996,5402,0,0,3},{12997,5405,0,0,3},{12998,5408,0,0,3},
{12999,5411,0,0,3},{13000,5414,0,0,3},{13001,5417,0,0,4},{13002,5421,0,0,4},
{13003,5425,0,0,4},{13004,5429,0,0,2},{13005,5431,0,0,3},{13006,5434,0,0,2},
{13007,5436,0,0,3},{13056,5439,0,0,5},{13057,5444,0,0,4},{13058,5448,0,0,5},
{13059,5453,0,0,3},{13060,5456,0,0,5},{13061,5461,0,0,3},{13062,5464,0,0,3},
{13063,5467,0,0,6},{13064,5473,0,0,4},{13065,5477,0,0,3},{13066,5480,0,0,3},
{13067,5483,0,0,3},{13068,5486,0,0,4},{13069,5490,0,0,4},{13070,5494,0,0,4},
{13071,5498,0,0,4},{13072,5502,0,0,4},{13073,5506,0,0,4},{13074,5510,0,0,4},
{13075,5514,0,0,6},{13076,5520,0,0,2},{13077,5522,0,0,6},{13078,5528,0,0,6},
{13079,5534,0,0,5},{13080,5539,0,0,4},{13081,5543,0,0,6},{13082,5549,0,0,6},
{13083,5555,0,0,4},{13084,5559,0,0,3},{13085,5562,0,0,3},{13086,5565,0,0,4},
{13087,5569,0,0,4},{13088,5573,0,0,5},{13089,5578,0,0,5},{13090,5583,0,0,3},
{13091,5586,0,0,3},{13092,5589,0,0,4},{13093,5593,0,0,3},{13094,5596,0,0,3},
{13095,5599,0,0,2},{13096,5601,0,0,2},{13097,5603,0,0,3},{13098,5606,0,0,3},
{13099,5609,0,0,6},{13100,5615,0,0,4},{13101,5619,0,0,5},{13102,5624,0,0,6},
{13103,5630,0,0,4},{13104,5634,0,0,3},{13105,5637,0,0,3},{13106,5640,0,0,6},
{13107,5646,0,0,4},{13108,5650,0,0,6},{13109,5656,0,0,3},{13110,5659,0,0,5},
{13111,5664,0,0,3},{13112,5667,0,0,4},{13113,5671,0,0,3},{13114,5674,0,0,4},
{13115,5678,0,0,5},{13116,5683,0,0,4},{13117,5687,0,0,5},{13118,5692,0,0,4},
{13119,5696,0,0,2},{13120,5698,0,0,5},{13121,5703,0,0,3},{13122,5706,0,0,3},
{13123,5709,0,0,4},{13124,5713,0,0,3},{13125,5716,0,0,3},{13126,5719,0,0,3},
{13127,5722,0,0,5},{13128,5727,0,0,4},{13129,5731,0,0,2},{13130,5733,0,0,6},
{13131,5739,0,0,3},{13132,5742,0,0,5},{13133,5747,0,0,4},{13134,5751,0,0,4},
{13135,5755,0,0,3},{13136,5758,0,0,3},{13137,5761,0,0,4},{13138,5765,0,0,2},
{13139,5767,0,0,4},{13140,5771,0,0,5},{13141,5776,0,0,2},{13142,5778,0,0,6},
{13143,5784,0,0,3},{13144,5787,0,0,3},{13145,5790,0,0,3},{13146,5793,0,0,3},
{13147,5796,0,0,3},{13148,5799,0,0,3},{13149,5802,0,0,3},{13150,5805,0,0,3},
{13151,5808,0,0,3},{13152,5811,0,0,3},{13153,5814,0,0,3},{13154,5817,0,0,4},
{13155,5821,0,0,4},{13156,5825,0,0,4},{13157,5829,0,0,4},{13158,5833,0,0,4},
{13159,5837,0,0,4},{13160,5841,0,0,4},{13161,5845,0,0,4},{13162,5849,0,0,4},
{13163,5853,0,0,4},{13164,5857,0,0,4},{13165,5861,0,0,4},{13166,5865,0,0,4},
{13167,5869,0,0,4},{13168,5873,0,0,4},{13169,5877,0,0,3},{13170,5880,0,0,2},
{13171,5882,0,0,2},{13172,5884,0,0,3},{13173,5887,0,0,2},{13174,5889,0,0,2},
{13175,5891,0,0,2},{13176,5893,0,0,3},{13177,5896,0,0,3},{13178,5899,0,0,2},
{13179,5901,0,0,4},{13180,5905,0,0,4},{13181,5909,0,0,4},{13182,5913,0,0,4},
{13183,5917,0,0,8},{13184,5925,0,0,2},{13185,5927,0,0,2},{13186,5929,0,0,2},
{13187,5931,0,0,2},{13188,5933,0,0,2},{13189,5935,0,0,2},{13190,5937,0,0,2},
{13191,5939,0,0,2},{13192,5941,0,0,3},{13193,5944,0,0,4},{13194,5948,0,0,2},
{13195,5950,0,0,2},{13196,5952,0,0,2},{13197,5954,0,0,2},{13198,5956,0,0,2},
{13199,5958,0,0,2},{13200,5960,0,0,2},{13201,5962,0,0,3},{13202,5965,0,0,3},
{13203,5968,0,0,3},{13204,5971,0,0,3},{13205,5974,0,0,2},{13206,5976,0,0,2},
{13207,5978,0,0,2},{13208,5980,0,0,2},{13209,5982,0,0,2},{13210,5984,0,0,2},
{13211,5986,0,0,2},{13212,5988,0,0,2},{13213,5990,0,0,2},{13214,5992,0,0,2},
{13215,5994,0,0,3},{13216,5997,0,0,3},{13217,6000,0,0,2},{13218,6002,0,0,3},
{13219,6005,0,0,3},{13220,6008,0,0,3},{13221,6011,0,0,2},{13222,6013,0,0,3},
{13223,6016,0,0,3},{13224,6019,0,0,4},{13225,6023,0,0,2},{13226,6025,0,0,3},
{13227,6028,0,0,3},{13228,6031,0,0,3},{13229,6034,0,0,3},{13230,6037,0,0,5},
{13231,6042,0,0,6},{13232,6048,0,0,2},{13233,6050,0,0,2},{13234,6052,0,0,2},
{13235,6054,0,0,2},{13236,6056,0,0,2},{13237,6058,0,0,2},{13238,6060,0,0,2},
{13239,6062,0,0,2},{13240,6064,0,0,2},{13241,6066,0,0,2},{13242,6068,0,0,2},
{13243,6070,0,0,2},{13244,6072,0,0,2},{13245,6074,0,0,2},{13246,6076,0,0,2},
{13247,6078,0,0,2},{13248,6080,0,0,2},{13249,6082,0,0,2},{13250,6084,0,0,4},
{13251,6088,0,0,2},{13252,6090,0,0,2},{13253,6092,0,0,2},{13254,6094,0,0,4},
{13255,6098,0,0,3},{13256,6101,0,0,2},{13257,6103,0,0,2},{13258,6105,0,0,2},
{13259,6107,0,0,2},{13260,6109,0,0,2},{13261,6111,0,0,2},{13262,6113,0,0,2},
{13263,6115,0,0,2},{13264,6117,0,0,2},{13265,6119,0,0,2},{13266,6121,0,0,3},
{13267,6124,0,0,2},{13268,6126,0,0,2},{13269,6128,0,0,3},{13270,6131,0,0,3},
{13271,6134,0,0,2},{13272,6136,0,0,4},{13273,6140,0,0,3},{13274,6143,0,0,2},
{13275,6145,0,0,2},{13276,6147,0,0,2},{13277,6149,0,0,2},{13278,6151,0,0,3},
{13279,6154,0,0,3},{13280,6157,0,0,3},{13281,6160,0,0,3},{13282,6163,0,0,3},
{13283,6166,0,0,3},{13284,6169,0,0,3},{13285,6172,0,0,3},{13286,6175,0,0,3},
{13287,6178,0,0,3},{13288,6181,0,0,3},{13289,6184,0,0,4},{13290,6188,0,0,4},
{13291,6192,0,0,4},{13292,6196,0,0,4},{13293,6200,0,0,4},{13294,6204,0,0,4},
{13295,6208,0,0,4},{13296,6212,0,0,4},{13297,6216,0,0,4},{13298,6220,0,0,4},
{13299,6224,0,0,4},{13300,6228,0,0,4},{13301,6232,0,0,4},{13302,6236,0,0,4},
{13303,6240,0,0,4},{13304,6244,0,0,4},{13305,6248,0,0,4},{13306,6252,0,0,4},
{13307,6256,0,0,4},{13308,6260,0,0,4},{13309,6264,0,0,4},{13310,6268,0,0,4},
{13311,6272,0,0,3},{13470,6275,0,0,2},{13497,6277,0,0,2},{13499,6279,0,0,2},
{13535,6281,0,0,2},{13589,6283,0,0,2},{14062,6285,0,0,2},{14076,6287,0,0,2},
{14209,6289,0,0,2},{14383,6291,0,0,2},{14434,6293,0,0,2},{14460,6295,0,0,2},
{14535,6297,0,0,2},{14563,6299,0,0,2},{14620,6301,0,0,2},{14650,6303,0,0,2},
{14894,6305,0,0,2},{14956,6307,0,0,2},{15076,6309,0,0,2},{15112,6311,0,0,2},
{15129,6313,0,0,2},{15177,6315,0,0,2},{15261,6317,0,0,2},{15384,6319,0,0,2},
{15438,6321,0,0,2},{15667,6323,0,0,2},{15766,6325,0,0,2},{16044,6327,0,0,2},
{16056,6329,0,0,2},{16155,6331,0,0,2},{16380,6333,0,0,2},{16392,6335,0,0,2},
{16408,6337,0,0,2},{16441,6339,0,0,2},{16454,6341,0,0,2},{16534,6343,0,0,2},
{16611,6345,0,0,2},{16687,6347,0,0,2},{16898,6349,0,0,2},{16935,6351,0,0,2},
{17056,6353,0,0,2},{17153,6355,0,0,2},{17204,6357,0,0,2},{17241,6359,0,0,2},
{17365,6361,0,0,2},{17369,6363,0,0,2},{17419,6365,0,0,2},{17515,6367,0,0,2},
{17707,6369,0,0,2},{17757,6371,0,0,2},{17761,6373,0,0,2},{17771,6375,0,0,2},
{17879,6377,0,0,2},{17913,6379,0,0,2},{17973,6381,0,0,2},{18110,6383,0,0,2},
{18119,6385,0,0,2},{18837,6387,0,0,2},{18918,6389,0,0,2},{19054,6391,0,0,2},
{19062,6393,0,0,2},{19122,6395,0,0,2},{19251,6397,0,0,2},{19406,6399,0,0,2},
{19662,6401,0,0,2},{19693,6403,0,0,2},{19704,6405,0,0,2},{19798,6407,0,0,2},
{19981,6409,0,0,2},{20006,6411,0,0,2},{20018,6413,0,0,2},{20024,6415,0,0,2},
{20025,6417,0,0,2},{20029,6419,0,0,2},{20033,6421,0,0,2},{20098,6423,0,0,2},
{20102,6425,0,0,2},{20142,6427,0,0,2},{20160,6429,0,0,2},{20172,6431,0,0,2},
{20196,6433,0,0,2},{20320,6435,0,0,2},{20352,6437,0,0,2},{20358,6439,0,0,2},
{20363,6441,0,0,2},{20398,6443,0,0,2},{20411,6445,0,0,2},{20415,6447,0,0,2},
{20482,6449,0,0,2},{20523,6451,0,0,2},{20602,6453,0,0,2},{20633,6455,0,0,2},
{20687,6457,0,0,2},{20698,6459,0,0,2},{20711,6461,0,0,2},{20800,6463,0,0,2},
{20805,6465,0,0,2},{20813,6467,0,0,2},{20820,6469,0,0,2},{20836,6471,0,0,2},
{20839,6473,0,0,2},{20840,6475,0,0,2},{20841,6477,0,0,2},{20845,6479,0,0,2},
{20855,6481,0,0,2},{20864,6483,0,0,2},{20877,6485,0,0,2},{20882,6487,0,0,2},
{20885,6489,0,0,2},{20887,6491,0,0,2},{20900,6493,0,0,2},{20908,6495,0,0,2},
{20917,6497,0,0,2},{20919,6499,0,0,2},{20937,6501,0,0,2},{20940,6503,0,0,2},
{20956,6505,0,0,2},{20958,6507,0,0,2},{20981,6509,0,0,2},{20995,6511,0,0,2},
{20999,6513,0,0,2},{21015,6515,0,0,2},{21033,6517,0,0,2},{21050,6519,0,0,2},
{21051,6521,0,0,2},{21062,6523,0,0,2},{21106,6525,0,0,2},{21111,6527,0,0,2},
{21129,6529,0,0,2},{21147,6531,0,0,2},{21155,6533,0,0,2},{21171,6535,0,0,2},
{21191,6537,0,0,2},{21193,6539,0,0,2},{21202,6541,0,0,2},{21214,6543,0,0,2},
{21220,6545,0,0,2},{21237,6547,0,0,2},{21242,6549,0,0,2},{21253,6551,0,0,2},
{21254,6553,0,0,2},{21271,6555,0,0,2},{21311,6557,0,0,2},{21321,6559,0,0,2},
{21329,6561,0,0,2},{21338,6563,0,0,2},{21363,6565,0,0,2},{21365,6567,0,0,2},
{21373,6569,0,0,2},{21375,6571,0,0,2},{21443,6573,0,0,2},{21450,6575,0,0,2},
{21471,6577,0,0,2},{21477,6579,0,0,2},{21483,6581,0,0,2},{21489,6583,0,0,2},
{21510,6585,0,0,2},{21519,6587,0,0,2},{21533,6589,0,0,2},{21560,6591,0,0,2},
{21570,6593,0,0,2},{21576,6595,0,0,2},{21608,6597,0,0,2},{21662,6599,0,0,2},
{21666,6601,0,0,2},{21693,6603,0,0,2},{21750,6605,0,0,2},{21776,6607,0,0,2},
{21843,6609,0,0,2},{21845,6611,0,0,2},{21859,6613,0,0,2},{21892,6615,0,0,2},
{21895,6617,0,0,2},{21913,6619,0,0,2},{21917,6621,0,0,2},{21931,6623,0,0,2},
{21939,6625,0,0,2},{21952,6627,0,0,2},{21954,6629,0,0,2},{21986,6631,0,0,2},
{22022,6633,0,0,2},{22097,6635,0,0,2},{22120,6637,0,0,2},{22132,6639,0,0,2},
{22265,6641,0,0,2},{22294,6643,0,0,2},{22295,6645,0,0,2},{22411,6647,0,0,2},
{22478,6649,0,0,2},{22516,6651,0,0,2},{22541,6653,0,0,2},{22577,6655,0,0,2},
{22578,6657,0,0,2},{22592,6659,0,0,2},{22618,6661,0,0,2},{22622,6663,0,0,2},
{22696,6665,0,0,2},{22700,6667,0,0,2},{22707,6669,0,0,2},{22744,6671,0,0,2},
{22751,6673,0,0,2},{22766,6675,0,0,2},{22770,6677,0,0,2},{22775,6679,0,0,2},
{22790,6681,0,0,2},{22810,6683,0,0,2},{22818,6685,0,0,2},{22852,6687,0,0,2},
{22856,6689,0,0,2},{22865,6691,0,0,2},{22868,6693,0,0,2},{22882,6695,0,0,2},
{22899,6697,0,0,2},{23000,6699,0,0,2},{23020,6701,0,0,2},{23067,6703,0,0,2},
{23079,6705,0,0,2},{23138,6707,0,0,2},{23142,6709,0,0,2},{23221,6711,0,0,2},
{23304,6713,0,0,2},{23336,6715,0,0,2},{23358,6717,0,0,2},{23429,6719,0,0,2},
{23491,6721,0,0,2},{23512,6723,0,0,2},{23527,6725,0,0,2},{23534,6727,0,0,2},
{23539,6729,0,0,2},{23551,6731,0,0,2},{23558,6733,0,0,2},{23586,6735,0,0,2},
{23615,6737,0,0,2},{23648,6739,0,0,2},{23650,6741,0,0,2},{23652,6743,0,0,2},
{23653,6745,0,0,2},{23662,6747,0,0,2},{23693,6749,0,0,2},{23744,6751,0,0,2},
{23833,6753,0,0,2},{23875,6755,0,0,2},{23888,6757,0,0,2},{23915,6759,0,0,2},
{23918,6761,0,0,2},{23932,6763,0,0,2},{23986,6765,0,0,2},{23994,6767,0,0,2},
{24033,6769,0,0,2},{24034,6771,0,0,2},{24061,6773,0,0,2},{24104,6775,0,0,2},
{24125,6777,0,0,2},{24169,6779,0,0,2},{24180,6781,0,0,2},{24230,6783,0,0,2},
{24240,6785,0,0,2},{24243,6787,0,0,2},{24246,6789,0,0,2},{24265,6791,0,0,2},
{24266,6793,0,0,2},{24274,6795,0,0,2},{24275,6797,0,0,2},{24281,6799,0,0,2},
{24300,6801,0,0,2},{24318,6803,0,0,2},{24324,6805,0,0,2},{24354,6807,0,0,2},
{24403,6809,0,0,2},{24418,6811,0,0,2},{24425,6813,0,0,2},{24427,6815,0,0,2},
{24459,6817,0,0,2},{24474,6819,0,0,2},{24489,6821,0,0,2},{24493,6823,0,0,2},
{24525,6825,0,0,2},{24535,6827,0,0,2},{24565,6829,0,0,2},{24569,6831,0,0,2},
{24594,6833,0,0,2},{24604,6835,0,0,2},{24693,6837,0,0,2},{24705,6839,0,0,2},
{24724,6841,0,0,2},{24775,6843,0,0,2},{24792,6845,0,0,2},{24801,6847,0,0,2},
{24840,6849,0,0,2},{24900,6851,0,0,2},{24904,6853,0,0,2},{24908,6855,0,0,2},
{24910,6857,0,0,2},{24928,6859,0,0,2},{24936,6861,0,0,2},{24954,6863,0,0,2},
{24974,6865,0,0,2},{24976,6867,0,0,2},{24996,6869,0,0,2},{25007,6871,0,0,2},
{25010,6873,0,0,2},{25054,6875,0,0,2},{25074,6877,0,0,2},{25078,6879,0,0,2},
{25088,6881,0,0,2},{25104,6883,0,0,2},{25115,6885,0,0,2},{25134,6887,0,0,2},
{25140,6889,0,0,2},{25181,6891,0,0,2},{25265,6893,0,0,2},{25289,6895,0,0,2},
{25295,6897,0,0,2},{25299,6899,0,0,2},{25300,6901,0,0,2},{25340,6903,0,0,2},
{25342,6905,0,0,2},{25405,6907,0,0,2},{25424,6909,0,0,2},{25448,6911,0,0,2},
{25467,6913,0,0,2},{25475,6915,0,0,2},{25504,6917,0,0,2},{25513,6919,0,0,2},
{25540,6921,0,0,2},{25541,6923,0,0,2},{25572,6925,0,0,2},{25628,6927,0,0,2},
{25634,6929,0,0,2},{25682,6931,0,0,2},{25705,6933,0,0,2},{25719,6935,0,0,2},
{25726,6937,0,0,2},{25754,6939,0,0,2},{25757,6941,0,0,2},{25796,6943,0,0,2},
{25935,6945,0,0,2},{25942,6947,0,0,2},{25964,6949,0,0,2},{25976,6951,0,0,2},
{26009,6953,0,0,2},{26053,6955,0,0,2},{26082,6957,0,0,2},{26083,6959,0,0,2},
{26131,6961,0,0,2},{26185,6963,0,0,2},{26228,6965,0,0,2},{26248,6967,0,0,2},
{26257,6969,0,0,2},{26268,6971,0,0,2},{26292,6973,0,0,2},{26310,6975,0,0,2},
{26356,6977,0,0,2},{26360,6979,0,0,2},{26368,6981,0,0,2},{26391,6983,0,0,2},
{26395,6985,0,0,2},{26401,6987,0,0,2},{26446,6989,0,0,2},{26451,6991,0,0,2},
{26454,6993,0,0,2},{26462,6995,0,0,2},{26491,6997,0,0,2},{26501,6999,0,0,2},
{26519,7001,0,0,2},{26611,7003,0,0,2},{26618,7005,0,0,2},{26647,7007,0,0,2},
{26655,7009,0,0,2},{26706,7011,0,0,2},{26753,7013,0,0,2},{26757,7015,0,0,2},
{26766,7017,0,0,2},{26792,7019,0,0,2},{26900,7021,0,0,2},{26946,7023,0,0,2},
{27043,7025,0,0,2},{27114,7027,0,0,2},{27138,7029,0,0,2},{27155,7031,0,0,2},
{27304,7033,0,0,2},{27347,7035,0,0,2},{27355,7037,0,0,2},{27396,7039,0,0,2},
{27425,7041,0,0,2},{27476,7043,0,0,2},{27506,7045,0,0,2},{27511,7047,0,0,2},
{27513,7049,0,0,2},{27551,7051,0,0,2},{27566,7053,0,0,2},{27578,7055,0,0,2},
{27579,7057,0,0,2},{27726,7059,0,0,2},{27751,7061,0,0,2},{27784,7063,0,0,2},
{27839,7065,0,0,2},{27852,7067,0,0,2},{27853,7069,0,0,2},{27877,7071,0,0,2},
{27926,7073,0,0,2},{27931,7075,0,0,2},{27934,7077,0,0,2},{27956,7079,0,0,2},
{27966,7081,0,0,2},{27969,7083,0,0,2},{28009,7085,0,0,2},{28010,7087,0,0,2},
{28023,7089,0,0,2},{28024,7091,0,0,2},{28037,7093,0,0,2},{28107,7095,0,0,2},
{28122,7097,0,0,2},{28138,7099,0,0,2},{28153,7101,0,0,2},{28186,7103,0,0,2},
{28207,7105,0,0,2},{28270,7107,0,0,2},{28316,7109,0,0,2},{28346,7111,0,0,2},
{28359,7113,0,0,2},{28363,7115,0,0,2},{28369,7117,0,0,2},{28379,7119,0,0,2},
{28431,7121,0,0,2},{28450,7123,0,0,2},{28451,7125,0,0,2},{28526,7127,0,0,2},
{28614,7129,0,0,2},{28651,7131,0,0,2},{28670,7133,0,0,2},{28699,7135,0,0,2},
{28702,7137,0,0,2},{28729,7139,0,0,2},{28746,7141,0,0,2},{28784,7143,0,0,2},
{28791,7145,0,0,2},{28797,7147,0,0,2},{28825,7149,0,0,2},{28845,7151,0,0,2},
{28872,7153,0,0,2},{28889,7155,0,0,2},{28997,7157,0,0,2},{29001,7159,0,0,2},
{29038,7161,0,0,2},{29084,7163,0,0,2},{29134,7165,0,0,2},{29136,7167,0,0,2},
{29200,7169,0,0,2},{29211,7171,0,0,2},{29224,7173,0,0,2},{29227,7175,0,0,2},
{29237,7177,0,0,2},{29264,7179,0,0,2},{29282,7181,0,0,2},{29312,7183,0,0,2},
{29333,7185,0,0,2},{29359,7187,0,0,2},{29376,7189,0,0,2},{29436,7191,0,0,2},
{29482,7193,0,0,2},{29557,7195,0,0,2},{29562,7197,0,0,2},{29575,7199,0,0,2},
{29579,7201,0,0,2},{29605,7203,0,0,2},{29618,7205,0,0,2},{29662,7207,0,0,2},
{29702,7209,0,0,2},{29705,7211,0,0,2},{29730,7213,0,0,2},{29767,7215,0,0,2},
{29788,7217,0,0,2},{29801,7219,0,0,2},{29809,7221,0,0,2},{29829,7223,0,0,2},
{29833,7225,0,0,2},{29848,7227,0,0,2},{29898,7229,0,0,2},{29958,7231,0,0,2},
{29988,7233,0,0,2},{30011,7235,0,0,2},{30014,7237,0,0,2},{30041,7239,0,0,2},
{30053,7241,0,0,2},{30064,7243,0,0,2},{30178,7245,0,0,2},{30224,7247,0,0,2},
{30237,7249,0,0,2},{30239,7251,0,0,2},{30274,7253,0,0,2},{30313,7255,0,0,2},
{30410,7257,0,0,2},{30427,7259,0,0,2},{30439,7261,0,0,2},{30452,7263,0,0,2},
{30465,7265,0,0,2},{30494,7267,0,0,2},{30495,7269,0,0,2},{30528,7271,0,0,2},
{30538,7273,0,0,2},{30603,7275,0,0,2},{30631,7277,0,0,2},{30798,7279,0,0,2},
{30827,7281,0,0,2},{30860,7283,0,0,2},{30865,7285,0,0,2},{30922,7287,0,0,2},
{30924,7289,0,0,2},{30971,7291,0,0,2},{31018,7293,0,0,2},{31036,7295,0,0,2},
{31038,7297,0,0,2},{31048,7299,0,0,2},{31049,7301,0,0,2},{31056,7303,0,0,2},
{31062,7305,0,0,2},{31069,7307,0,0,2},{31070,7309,0,0,2},{31077,7311,0,0,2},
{31103,7313,0,0,2},{31117,7315,0,0,2},{31118,7317,0,0,2},{31119,7319,0,0,2},
{31150,7321,0,0,2},{31178,7323,0,0,2},{31211,7325,0,0,2},{31260,7327,0,0,2},
{31296,7329,0,0,2},{31306,7331,0,0,2},{31311,7333,0,0,2},{31361,7335,0,0,2},
{31409,7337,0,0,2},{31435,7339,0,0,2},{31470,7341,0,0,2},{31520,7343,0,0,2},
{31680,7345,0,0,2},{31686,7347,0,0,2},{31689,7349,0,0,2},{31806,7351,0,0,2},
{31840,7353,0,0,2},{31867,7355,0,0,2},{31890,7357,0,0,2},{31934,7359,0,0,2},
{31954,7361,0,0,2},{31958,7363,0,0,2},{31971,7365,0,0,2},{31975,7367,0,0,2},
{31976,7369,0,0,2},{32000,7371,0,0,2},{32016,7373,0,0,2},{32034,7375,0,0,2},
{32047,7377,0,0,2},{32091,7379,0,0,2},{32099,7381,0,0,2},{32160,7383,0,0,2},
{32190,7385,0,0,2},{32199,7387,0,0,2},{32244,7389,0,0,2},{32258,7391,0,0,2},
{32265,7393,0,0,2},{32311,7395,0,0,2},{32321,7397,0,0,2},{32325,7399,0,0,2},
{32574,7401,0,0,2},{32626,7403,0,0,2},{32633,7405,0,0,2},{32634,7407,0,0,2},
{32645,7409,0,0,2},{32661,7411,0,0,2},{32666,7413,0,0,2},{32701,7415,0,0,2},
{32762,7417,0,0,2},{32769,7419,0,0,2},{32773,7421,0,0,2},{32838,7423,0,0,2},
{32864,7425,0,0,2},{32879,7427,0,0,2},{32880,7429,0,0,2},{32894,7431,0,0,2},
{32907,7433,0,0,2},{32941,7435,0,0,2},{32946,7437,0,0,2},{33027,7439,0,0,2},
{33086,7441,0,0,2},{33240,7443,0,0,2},{33256,7445,0,0,2},{33261,7447,0,0,2},
{33281,7449,0,0,2},{33284,7451,0,0,2},{33304,7453,0,0,2},{33391,7455,0,0,2},
{33401,7457,0,0,2},{33419,7459,0,0,2},{33425,7461,0,0,2},{33437,7463,0,0,2},
{33457,7465,0,0,2},{33459,7467,0,0,2},{33469,7469,0,0,2},{33509,7471,0,0,2},
{33510,7473,0,0,2},{33565,7475,0,0,2},{33571,7477,0,0,2},{33590,7479,0,0,2},
{33618,7481,0,0,2},{33619,7483,0,0,2},{33635,7485,0,0,2},{33709,7487,0,0,2},
{33725,7489,0,0,2},{33737,7491,0,0,2},{33738,7493,0,0,2},{33740,7495,0,0,2},
{33756,7497,0,0,2},{33767,7499,0,0,2},{33775,7501,0,0,2},{33777,7503,0,0,2},
{33853,7505,0,0,2},{33865,7507,0,0,2},{33879,7509,0,0,2},{34030,7511,0,0,2},
{34033,7513,0,0,2},{34035,7515,0,0,2},{34044,7517,0,0,2},{34070,7519,0,0,2},
{34148,7521,0,0,2},{34253,7523,0,0,2},{34298,7525,0,0,2},{34310,7527,0,0,2},
{34322,7529,0,0,2},{34349,7531,0,0,2},{34367,7533,0,0,2},{34384,7535,0,0,2},
{34396,7537,0,0,2},{34407,7539,0,0,2},{34409,7541,0,0,2},{34440,7543,0,0,2},
{34473,7545,0,0,2},{34530,7547,0,0,2},{34574,7549,0,0,2},{34600,7551,0,0,2},
{34667,7553,0,0,2},{34681,7555,0,0,2},{34694,7557,0,0,2},{34746,7559,0,0,2},
{34785,7561,0,0,2},{34817,7563,0,0,2},{34847,7565,0,0,2},{34892,7567,0,0,2},
{34912,7569,0,0,2},{34915,7571,0,0,2},{35010,7573,0,0,2},{35023,7575,0,0,2},
{35031,7577,0,0,2},{35038,7579,0,0,2},{35041,7581,0,0,2},{35064,7583,0,0,2},
{35066,7585,0,0,2},{35088,7587,0,0,2},{35137,7589,0,0,2},{35172,7591,0,0,2},
{35206,7593,0,0,2},{35211,7595,0,0,2},{35222,7597,0,0,2},{35488,7599,0,0,2},
{35498,7601,0,0,2},{35519,7603,0,0,2},{35531,7605,0,0,2},{35538,7607,0,0,2},
{35542,7609,0,0,2},{35565,7611,0,0,2},{35576,7613,0,0,2},{35582,7615,0,0,2},
{35585,7617,0,0,2},{35641,7619,0,0,2},{35672,7621,0,0,2},{35712,7623,0,0,2},
{35722,7625,0,0,2},{35912,7627,0,0,2},{35925,7629,0,0,2},{36011,7631,0,0,2},
{36033,7633,0,0,2},{36034,7635,0,0,2},{36040,7637,0,0,2},{36051,7639,0,0,2},
{36104,7641,0,0,2},{36123,7643,0,0,2},{36215,7645,0,0,2},{36284,7647,0,0,2},
{36299,7649,0,0,2},{36335,7651,0,0,2},{36336,7653,0,0,2},{36554,7655,0,0,2},
{36564,7657,0,0,2},{36646,7659,0,0,2},{36650,7661,0,0,2},{36664,7663,0,0,2},
{36667,7665,0,0,2},{36706,7667,0,0,2},{36766,7669,0,0,2},{36784,7671,0,0,2},
{36790,7673,0,0,2},{36899,7675,0,0,2},{36920,7677,0,0,2},{36978,7679,0,0,2},
{36988,7681,0,0,2},{37007,7683,0,0,2},{37012,7685,0,0,2},{37070,7687,0,0,2},
{37086,7689,0,0,2},{37105,7691,0,0,2},{37117,7693,0,0,2},{37137,7695,0,0,2},
{37147,7697,0,0,2},{37226,7699,0,0,2},{37273,7701,0,0,2},{37300,7703,0,0,2},
{37324,7705,0,0,2},{37327,7707,0,0,2},{37329,7709,0,0,2},{37428,7711,0,0,2},
{37432,7713,0,0,2},{37494,7715,0,0,2},{37500,7717,0,0,2},{37591,7719,0,0,2},
{37592,7721,0,0,2},{37636,7723,0,0,2},{37706,7725,0,0,2},{37881,7727,0,0,2},
{37909,7729,0,0,2},{38283,7731,0,0,2},{38317,7733,0,0,2},{38327,7735,0,0,2},
{38446,7737,0,0,2},{38475,7739,0,0,2},{38477,7741,0,0,2},{38517,7743,0,0,2},
{38520,7745,0,0,2},{38524,7747,0,0,2},{38534,7749,0,0,2},{38563,7751,0,0,2},
{38583,7753,0,0,2},{38584,7755,0,0,2},{38595,7757,0,0,2},{38626,7759,0,0,2},
{38627,7761,0,0,2},{38646,7763,0,0,2},{38647,7765,0,0,2},{38691,7767,0,0,2},
{38706,7769,0,0,2},{38728,7771,0,0,2},{38742,7773,0,0,2},{38875,7775,0,0,2},
{38880,7777,0,0,2},{38911,7779,0,0,2},{38923,7781,0,0,2},{38936,7783,0,0,2},
{38953,7785,0,0,2},{38971,7787,0,0,2},{39006,7789,0,0,2},{39138,7791,0,0,2},
{39151,7793,0,0,2},{39164,7795,0,0,2},{39208,7797,0,0,2},{39209,7799,0,0,2},
{39335,7801,0,0,2},{39362,7803,0,0,2},{39409,7805,0,0,2},{39422,7807,0,0,2},
{39530,7809,0,0,2},{39698,7811,0,0,2},{39791,7813,0,0,2},{40000,7815,0,0,2},
{40023,7817,0,0,2},{40189,7819,0,0,2},{40295,7821,0,0,2},{40372,7823,0,0,2},
{40442,7825,0,0,2},{40478,7827,0,0,2},{40575,7829,0,0,2},{40599,7831,0,0,2},
{40607,7833,0,0,2},{40635,7835,0,0,2},{40654,7837,0,0,2},{40697,7839,0,0,2},
{40702,7841,0,0,2},{40709,7843,0,0,2},{40719,7845,0,0,2},{40726,7847,0,0,2},
{40763,7849,0,0,2},{40771,7851,0,0,2},{40845,7853,0,0,2},{40846,7855,0,0,2},
{40860,7857,0,0,2},{42515,7859,0,0,2},{42516,7861,0,0,2},{42517,7863,0,0,2},
{42518,7865,0,0,2},{42519,7867,0,0,2},{42520,7869,0,0,2},{42521,7871,0,0,2},
{42522,7873,0,0,2},{42523,7875,0,0,2},{42524,7877,0,0,2},{42525,7879,0,0,2},
{42526,7881,0,0,2},{42527,7883,0,0,2},{42614,7885,0,0,2},{42792,7887,0,0,2},
{42793,7889,0,0,2},{42802,7891,0,0,2},{42803,7893,0,0,2},{42804,7895,0,0,2},
{42805,7897,0,0,2},{42806,7899,0,0,2},{42807,7901,0,0,2},{42808,7903,0,0,2},
{42809,7905,0,0,2},{42810,7907,0,0,3},{42811,7910,0,0,3},{42812,7913,0,0,2},
{42813,7915,0,0,2},{42830,7917,0,0,2},{42831,7919,0,0,2},{42848,7921,0,0,2},
{42849,7923,0,0,2},{42873,7925,0,0,2},{42874,7927,0,0,2},{42875,7929,0,0,2},
{42876,7931,0,0,2},{42877,7933,0,0,2},{42882,7935,0,0,2},{42883,7937,0,0,2},
{42884,7939,0,0,2},{42885,7941,0,0,2},{42886,7943,0,0,2},{42887,7945,0,0,2},
{42906,7947,0,0,2},{42907,7949,0,0,2},{42908,7951,0,0,2},{42909,7953,0,0,2},
{42910,7955,0,0,2},{42911,7957,0,0,2},{42912,7959,0,0,2},{42913,7961,0,0,2},
{42914,7963,0,0,2},{42915,7965,0,0,2},{42916,7967,0,0,2},{42917,7969,0,0,2},
{42918,7971,0,0,2},{42919,7973,0,0,2},{42920,7975,0,0,2},{42921,7977,0,0,2},
{43000,7979,0,0,2},{43001,7981,0,0,3},{43701,0,4444,48,0},{43702,0,4492,48,0},
{43705,0,4540,48,0},{43707,0,4588,48,0},{43708,0,4636,48,0},{64014,8464,0,0,2},
{64015,8466,0,0,2},{64017,8468,0,0,2},{64019,8470,0,0,2},{64020,8472,0,0,2},
{64031,8474,0,0,2},{64033,8476,0,0,2},{64035,8478,0,0,2},{64036,8480,0,0,2},
{64039,8482,0,0,2},{64040,8484,0,0,2},{64041,8486,0,0,2},{64256,8488,0,0,2},
{64257,8490,0,0,2},{64258,8492,0,0,2},{64259,8494,0,0,3},{64260,8497,0,0,3},
{64261,8500,0,0,3},{64262,8503,0,0,2},{64275,8505,0,0,2},{64276,8507,0,0,2},
{64277,8509,0,0,2},{64278,8511,0,0,2},{64279,8513,0,0,2},{64335,8515,0,0,2},
{64420,8517,0,0,2},{64421,8519,0,0,2},{64432,8521,0,0,2},{64433,8523,0,0,2},
{64477,8525,0,0,2},{64490,8527,0,0,2},{64491,8529,0,0,2},{64492,8531,0,0,2},
{64493,8533,0,0,2},{64494,8535,0,0,2},{64495,8537,0,0,2},{64496,8539,0,0,2},
{64497,8541,0,0,2},{64498,8543,0,0,2},{64499,8545,0,0,2},{64500,8547,0,0,2},
{64501,8549,0,0,2},{64502,8551,0,0,2},{64503,8553,0,0,2},{64504,8555,0,0,2},
{64505,8557,0,0,2},{64506,8559,0,0,2},{64507,8561,0,0,2},{64512,8563,0,0,2},
{64513,8565,0,0,2},{64514,8567,0,0,2},{64515,8569,0,0,2},{64516,8571,0,0,2},
{64517,8573,0,0,2},{64518,8575,0,0,2},{64519,8577,0,0,2},{64520,8579,0,0,2},
{64521,8581,0,0,2},{64522,8583,0,0,2},{64523,8585,0,0,2},{64524,8587,0,0,2},
{64525,8589,0,0,2},{64526,8591,0,0,2},{64527,8593,0,0,2},{64528,8595,0,0,2},
{64529,8597,0,0,2},{64530,8599,0,0,2},{64531,8601,0,0,2},{64532,8603,0,0,2},
{64533,8605,0,0,2},{64534,8607,0,0,2},{64535,8609,0,0,2},{64536,8611,0,0,2},
{64537,8613,0,0,2},{64538,8615,0,0,2},{64539,8617,0,0,2},{64540,8619,0,0,2},
{64541,8621,0,0,2},{64542,8623,0,0,2},{64543,8625,0,0,2},{64544,8627,0,0,2},
{64545,8629,0,0,2},{64546,8631,0,0,2},{64547,8633,0,0,2},{64548,8635,0,0,2},
{64549,8637,0,0,2},{64550,8639,0,0,2},{64551,8641,0,0,2},{64552,8643,0,0,2},
{64553,8645,0,0,2},{64554,8647,0,0,2},{64555,8649,0,0,2},{64556,8651,0,0,2},
{64557,8653,0,0,2},{64558,8655,0,0,2},{64559,8657,0,0,2},{64560,8659,0,0,2},
{64561,8661,0,0,2},{64562,8663,0,0,2},{64563,8665,0,0,2},{64564,8667,0,0,2},
{64565,8669,0,0,2},{64566,8671,0,0,2},{64567,8673,0,0,2},{64568,8675,0,0,2},
{64569,8677,0,0,2},{64570,8679,0,0,2},{64571,8681,0,0,2},{64572,8683,0,0,2},
{64573,8685,0,0,2},{64574,8687,0,0,2},{64575,8689,0,0,2},{64576,8691,0,0,2},
{64577,8693,0,0,2},{64578,8695,0,0,2},{64579,8697,0,0,2},{64580,8699,0,0,2},
{64581,8701,0,0,2},{64582,8703,0,0,2},{64583,8705,0,0,2},{64584,8707,0,0,2},
{64585,8709,0,0,2},{64586,8711,0,0,2},{64587,8713,0,0,2},{64588,8715,0,0,2},
{64589,8717,0,0,2},{64590,8719,0,0,2},{64591,8721,0,0,2},{64592,8723,0,0,2},
{64593,8725,0,0,2},{64594,8727,0,0,2},{64595,8729,0,0,2},{64596,8731,0,0,2},
{64597,8733,0,0,2},{64598,8735,0,0,2},{64599,8737,0,0,2},{64600,8739,0,0,2},
{64601,8741,0,0,2},{64602,8743,0,0,2},{64603,8745,0,0,2},{64604,8747,0,0,2},
{64605,8749,0,0,2},{64606,8751,0,0,2},{64607,8753,0,0,2},{64608,8755,0,0,2},
{64609,8757,0,0,2},{64610,8759,0,0,2},{64611,8761,0,0,2},{64612,8763,0,0,2},
{64613,8765,0,0,2},{64614,8767,0,0,2},{64615,8769,0,0,2},{64616,8771,0,0,2},
{64617,8773,0,0,2},{64618,8775,0,0,2},{64619,8777,0,0,2},{64620,8779,0,0,2},
{64621,8781,0,0,2},{64622,8783,0,0,2},{64623,8785,0,0,2},{64624,8787,0,0,2},
{64625,8789,0,0,2},{64626,8791,0,0,2},{64627,8793,0,0,2},{64628,8795,0,0,2},
{64629,8797,0,0,2},{64630,8799,0,0,2},{64631,8801,0,0,2},{64632,8803,0,0,2},
{64633,8805,0,0,2},{64634,8807,0,0,2},{64635,8809,0,0,2},{64636,8811,0,0,2},
{64637,8813,0,0,2},{64638,8815,0,0,2},{64639,8817,0,0,2},{64640,8819,0,0,2},
{64641,8821,0,0,2},{64642,8823,0,0,2},{64643,8825,0,0,2},{64644,8827,0,0,2},
{64645,8829,0,0,2},{64646,8831,0,0,2},{64647,8833,0,0,2},{64648,8835,0,0,2},
{64649,8837,0,0,2},{64650,8839,0,0,2},{64651,8841,0,0,2},{64652,8843,0,0,2},
{64653,8845,0,0,2},{64654,8847,0,0,2},{64655,8849,0,0,2},{64656,8851,0,0,2},
{64657,8853,0,0,2},{64658,8855,0,0,2},{64659,8857,0,0,2},{64660,8859,0,0,2},
{64661,8861,0,0,2},{64662,8863,0,0,2},{64663,8865,0,0,2},{64664,8867,0,0,2},
{64665,8869,0,0,2},{64666,8871,0,0,2},{64667,8873,0,0,2},{64668,8875,0,0,2},
{64669,8877,0,0,2},{64670,8879,0,0,2},{64671,8881,0,0,2},{64672,8883,0,0,2},
{64673,8885,0,0,2},{64674,8887,0,0,2},{64675,8889,0,0,2},{64676,8891,0,0,2},
{64677,8893,0,0,2},{64678,8895,0,0,2},{64679,8897,0,0,2},{64680,8899,0,0,2},
{64681,8901,0,0,2},{64682,8903,0,0,2},{64683,8905,0,0,2},{64684,8907,0,0,2},
{64685,8909,0,0,2},{64686,8911,0,0,2},{64687,8913,0,0,2},{64688,8915,0,0,2},
{64689,8917,0,0,2},{64690,8919,0,0,2},{64691,8921,0,0,2},{64692,8923,0,0,2},
{64693,8925,0,0,2},{64694,8927,0,0,2},{64695,8929,0,0,2},{64696,8931,0,0,2},
{64697,8933,0,0,2},{64698,8935,0,0,2},{64699,8937,0,0,2},{64700,8939,0,0,2},
{64701,8941,0,0,2},{64702,8943,0,0,2},{64703,8945,0,0,2},{64704,8947,0,0,2},
{64705,8949,0,0,2},{64706,8951,0,0,2},{64707,8953,0,0,2},{64708,8955,0,0,2},
{64709,8957,0,0,2},{64710,8959,0,0,2},{64711,8961,0,0,2},{64712,8963,0,0,2},
{64713,8965,0,0,2},{64714,8967,0,0,2},{64715,8969,0,0,2},{64716,8971,0,0,2},
{64717,8973,0,0,2},{64718,8975,0,0,2},{64719,8977,0,0,2},{64720,8979,0,0,2},
{64721,8981,0,0,2},{64722,8983,0,0,2},{64723,8985,0,0,2},{64724,8987,0,0,2},
{64725,8989,0,0,2},{64726,8991,0,0,2},{64727,8993,0,0,2},{64728,8995,0,0,2},
{64729,8997,0,0,2},{64730,8999,0,0,2},{64731,9001,0,0,2},{64732,9003,0,0,2},
{64733,9005,0,0,2},{64734,9007,0,0,2},{64735,9009,0,0,2},{64736,9011,0,0,2},
{64737,9013,0,0,2},{64738,9015,0,0,2},{64739,9017,0,0,2},{64740,9019,0,0,2},
{64741,9021,0,0,2},{64742,9023,0,0,2},{64743,9025,0,0,2},{64744,9027,0,0,2},
{64745,9029,0,0,2},{64746,9031,0,0,2},{64747,9033,0,0,2},{64748,9035,0,0,2},
{64749,9037,0,0,2},{64750,9039,0,0,2},{64751,9041,0,0,2},{64752,9043,0,0,2},
{64753,9045,0,0,2},{64754,9047,0,0,2},{64755,9049,0,0,2},{64756,9051,0,0,2},
{64757,9053,0,0,2},{64758,9055,0,0,2},{64759,9057,0,0,2},{64760,9059,0,0,2},
{64761,9061,0,0,2},{64762,9063,0,0,2},{64763,9065,0,0,2},{64764,9067,0,0,2},
{64765,9069,0,0,2},{64766,9071,0,0,2},{64767,9073,0,0,2},{64768,9075,0,0,2},
{64769,9077,0,0,2},{64770,9079,0,0,2},{64771,9081,0,0,2},{64772,9083,0,0,2},
{64773,9085,0,0,2},{64774,9087,0,0,2},{64775,9089,0,0,2},{64776,9091,0,0,2},
{64777,9093,0,0,2},{64778,9095,0,0,2},{64779,9097,0,0,2},{64780,9099,0,0,2},
{64781,9101,0,0,2},{64782,9103,0,0,2},{64783,9105,0,0,2},{64784,9107,0,0,2},
{64785,9109,0,0,2},{64786,9111,0,0,2},{64787,9113,0,0,2},{64788,9115,0,0,2},
{64789,9117,0,0,2},{64790,9119,0,0,2},{64791,9121,0,0,2},{64792,9123,0,0,2},
{64793,9125,0,0,2},{64794,9127,0,0,2},{64795,9129,0,0,2},{64796,9131,0,0,2},
{64797,9133,0,0,2},{64798,9135,0,0,2},{64799,9137,0,0,2},{64800,9139,0,0,2},
{64801,9141,0,0,2},{64802,9143,0,0,2},{64803,9145,0,0,2},{64804,9147,0,0,2},
{64805,9149,0,0,2},{64806,9151,0,0,2},{64807,9153,0,0,2},{64808,9155,0,0,2},
{64809,9157,0,0,2},{64810,9159,0,0,2},{64811,9161,0,0,2},{64812,9163,0,0,2},
{64813,9165,0,0,2},{64814,9167,0,0,2},{64815,9169,0,0,2},{64816,9171,0,0,2},
{64817,9173,0,0,2},{64818,9175,0,0,2},{64819,9177,0,0,2},{64820,9179,0,0,2},
{64821,9181,0,0,2},{64822,9183,0,0,2},{64823,9185,0,0,2},{64824,9187,0,0,2},
{64825,9189,0,0,2},{64826,9191,0,0,2},{64827,9193,0,0,2},{64828,9195,0,0,2},
{64829,9197,0,0,2},{64848,9199,0,0,3},{64849,9202,0,0,3},{64850,9205,0,0,3},
{64851,9208,0,0,3},{64852,9211,0,0,3},{64853,9214,0,0,3},{64854,9217,0,0,3},
{64855,9220,0,0,3},{64856,9223,0,0,3},{64857,9226,0,0,3},{64858,9229,0,0,3},
{64859,9232,0,0,3},{64860,9235,0,0,3},{64861,9238,0,0,3},{64862,9241,0,0,3},
{64863,9244,0,0,3},{64864,9247,0,0,3},{64865,9250,0,0,3},{64866,9253,0,0,3},
{64867,9256,0,0,3},{64868,9259,0,0,3},{64869,9262,0,0,3},{64870,9265,0,0,3},
{64871,9268,0,0,3},{64872,9271,0,0,3},{64873,9274,0,0,3},{64874,9277,0,0,3},
{64875,9280,0,0,3},{64876,9283,0,0,3},{64877,9286,0,0,3},{64878,9289,0,0,3},
{64879,9292,0,0,3},{64880,9295,0,0,3},{64881,9298,0,0,3},{64882,9301,0,0,3},
{64883,9304,0,0,3},{64884,9307,0,0,3},{64885,9310,0,0,3},{64886,9313,0,0,3},
{64887,9316,0,0,3},{64888,9319,0,0,3},{64889,9322,0,0,3},{64890,9325,0,0,3},
{64891,9328,0,0,3},{64892,9331,0,0,3},{64893,9334,0,0,3},{64894,9337,0,0,3},
{64895,9340,0,0,3},{64896,9343,0,0,3},{64897,9346,0,0,3},{64898,9349,0,0,3},
{64899,9352,0,0,3},{64900,9355,0,0,3},{64901,9358,0,0,3},{64902,9361,0,0,3},
{64903,9364,0,0,3},{64904,9367,0,0,3},{64905,9370,0,0,3},{64906,9373,0,0,3},
{64907,9376,0,0,3},{64908,9379,0,0,3},{64909,9382,0,0,3},{64910,9385,0,0,3},
{64911,9388,0,0,3},{64914,9391,0,0,3},{64915,9394,0,0,3},{64916,9397,0,0,3},
{64917,9400,0,0,3},{64918,9403,0,0,3},{64919,9406,0,0,3},{64920,9409,0,0,3},
{64921,9412,0,0,3},{64922,9415,0,0,3},{64923,9418,0,0,3},{64924,9421,0,0,3},
{64925,9424,0,0,3},{64926,9427,0,0,3},{64927,9430,0,0,3},{64928,9433,0,0,3},
{64929,9436,0,0,3},{64930,9439,0,0,3},{64931,9442,0,0,3},{64932,9445,0,0,3},
{64933,9448,0,0,3},{64934,9451,0,0,3},{64935,9454,0,0,3},{64936,9457,0,0,3},
{64937,9460,0,0,3},{64938,9463,0,0,3},{64939,9466,0,0,3},{64940,9469,0,0,3},
{64941,9472,0,0,3},{64942,9475,0,0,3},{64943,9478,0,0,3},{64944,9481,0,0,3},
{64945,9484,0,0,3},{64946,9487,0,0,3},{64947,9490,0,0,3},{64948,9493,0,0,3},
{64949,9496,0,0,3},{64950,9499,0,0,3},{64951,9502,0,0,3},{64952,9505,0,0,3},
{64953,9508,0,0,3},{64954,9511,0,0,3},{64955,9514,0,0,3},{64956,9517,0,0,3},
{64957,9520,0,0,3},{64958,9523,0,0,3},{64959,9526,0,0,3},{64960,9529,0,0,3},
{64961,9532,0,0,3},{64962,9535,0,0,3},{64963,9538,0,0,3},{64964,9541,0,0,3},
{64965,9544,0,0,3},{64966,9547,0,0,3},{64967,9550,0,0,3},{65008,9553,0,0,3},
{65009,9556,0,0,3},{65010,9559,0,0,4},{65011,9563,0,0,4},{65012,9567,0,0,4},
{65013,9571,0,0,4},{65014,9575,0,0,4},{65015,9579,0,0,4},{65016,9583,0,0,4},
{65017,9587,0,0,3},{65018,9590,0,0,18},{65019,9608,0,0,8},{65020,9616,0,0,4},
{65049,9620,0,0,3},{65072,9623,0,0,2},{65269,9625,0,0,2},{65270,9627,0,0,2},
{65271,9629,0,0,2},{65272,9631,0,0,2},{65273,9633,0,0,2},{65274,9635,0,0,2},
{65275,9637,0,0,2},{65276,9639,0,0,2},{67968,9641,0,0,2},{67969,9643,0,0,2},
{67970,9645,0,0,2},{67971,9647,0,0,2},{67972,9649,0,0,2},{67973,9651,0,0,2},
{67974,9653,0,0,2},{67975,9655,0,0,2},{67976,9657,0,0,2},{67977,9659,0,0,2},
{67978,9661,0,0,2},{67979,9663,0,0,2},{67980,9665,0,0,2},{67981,9667,0,0,2},
{67982,9669,0,0,2},{67983,9671,0,0,2},{67984,9673,0,0,2},{67985,9675,0,0,2},
{67986,9677,0,0,2},{67987,9679,0,0,2},{67988,9681,0,0,2},{67989,9683,0,0,2},
{67990,9685,0,0,2},{67991,9687,0,0,2},{67992,9689,0,0,2},{67993,9691,0,0,2},
{67994,9693,0,0,2},{67995,9695,0,0,2},{67996,9697,0,0,2},{67997,9699,0,0,2},
{68016,9701,0,0,2},{68296,9703,0,0,2},{68398,9705,0,0,2},{68609,9707,0,0,2},
{68612,9709,0,0,2},{68616,9711,0,0,2},{68618,9713,0,0,2},{68620,9715,0,0,2},
{68622,9717,0,0,2},{68624,9719,0,0,2},{68626,9721,0,0,2},{68629,9723,0,0,2},
{68631,9725,0,0,2},{68633,9727,0,0,2},{68635,9729,0,0,2},{68637,9731,0,0,2},
{68639,9733,0,0,2},{68645,9735,0,0,2},{68647,9737,0,0,2},{68649,9739,0,0,2},
{68651,9741,0,0,2},{68654,9743,0,0,2},{68659,9745,0,0,2},{68661,9747,0,0,2},
{68663,9749,0,0,2},{68665,9751,0,0,2},{68667,9753,0,0,2},{68672,9755,0,0,2},
{68674,9757,0,0,2},{68676,9759,0,0,2},{68678,9761,0,0,2},{68737,9763,0,0,2},
{68746,9765,0,0,2},{68747,9767,0,0,2},{68753,9769,0,0,2},{68764,9771,0,0,2},
{68766,9773,0,0,2},{68767,9775,0,0,2},{68771,9777,0,0,2},{68779,9779,0,0,2},
{68781,9781,0,0,2},{68801,9783,0,0,2},{68810,9785,0,0,2},{68811,9787,0,0,2},
{68817,9789,0,0,2},{68828,9791,0,0,2},{68830,9793,0,0,2},{68831,9795,0,0,2},
{68835,9797,0,0,2},{68843,9799,0,0,2},{68845,9801,0,0,2},{69786,9803,0,0,2},
{69788,9805,0,0,2},{69803,9807,0,0,2},{71128,9809,0,0,2},{71129,9811,0,0,2},
{71130,9813,0,0,2},{71131,9815,0,0,2},{71132,9817,0,0,2},{71133,9819,0,0,2},
{71429,9821,0,0,2},{71446,9823,0,0,2},{119127,0,4684,1,0},{119128,0,4685,1,0},
{119225,0,4691,1,0},{119226,0,4694,1,0},{127232,9860,0,0,2},{127233,9862,0,0,2},
{127234,9864,0,0,2},{127235,9866,0,0,2},{127236,9868,0,0,2},{127237,9870,0,0,2},
{127238,9872,0,0,2},{127239,9874,0,0,2},{127240,9876,0,0,2},{127241,9878,0,0,2},
{127242,9880,0,0,2},{127248,9882,0,0,3},{127249,9885,0,0,3},{127250,9888,0,0,3},
{127251,9891,0,0,3},{127252,9894,0,0,3},{127253,9897,0,0,3},{127254,9900,0,0,3},
{127255,9903,0,0,3},{127256,9906,0,0,3},{127257,9909,0,0,3},{127258,9912,0,0,3},
{127259,9915,0,0,3},{127260,9918,0,0,3},{127261,9921,0,0,3},{127262,9924,0,0,3},
{127263,9927,0,0,3},{127264,9930,0,0,3},{127265,9933,0,0,3},{127266,9936,0,0,3},
{127267,9939,0,0,3},{127268,9942,0,0,3},{127269,9945,0,0,3},{127270,9948,0,0,3},
{127271,9951,0,0,3},{127272,9954,0,0,3},{127273,9957,0,0,3},{127274,9960,0,0,3},
{127277,9963,0,0,2},{127278,9965,0,0,2},{127306,9967,0,0,2},{127307,9969,0,0,2},
{127308,9971,0,0,2},{127309,9973,0,0,2},{127310,9975,0,0,3},{127311,9978,0,0,2},
{127338,9980,0,0,2},{127339,9982,0,0,2},{127371,9984,0,0,2},{127372,9986,0,0,2},
{127373,9988,0,0,2},{127374,9990,0,0,2},{127375,9992,0,0,2},{127376,9994,0,0,2},
{127377,9996,0,0,2},{127378,9998,0,0,4},{127379,10002,0,0,4},{127380,10006,0,0,
2},{127381,10008,0,0,3},{127382,10011,0,0,2},{127383,10013,0,0,2},{127384,10015,
0,0,3},{127385,10018,0,0,3},{127386,10021,0,0,2},{127387,10023,0,0,2},{127388,
10025,0,0,7},{127389,10032,0,0,2},{127390,10034,0,0,2},{127391,10036,0,0,2},
{127392,10038,0,0,3},{127393,10041,0,0,3},{127394,10044,0,0,4},{127395,10048,0,
0,3},{127396,10051,0,0,4},{127398,10055,0,0,2},{127399,10057,0,0,3},{127400,
10060,0,0,6},{127401,10066,0,0,8},{127402,10074,0,0,3},{127403,10077,0,0,3},
{127404,10080,0,0,3},{127488,10083,0,0,2},{127489,10085,0,0,2},{127504,10087,0,
0,2},{127505,10089,0,0,2},{127506,10091,0,0,2},{127507,10093,0,0,2},{127508,
10095,0,0,2},{127509,10097,0,0,2},{127510,10099,0,0,2},{127511,10101,0,0,2},
{127512,10103,0,0,2},{127513,10105,0,0,2},{127514,10107,0,0,2},{127515,10109,0,
0,2},{127516,10111,0,0,2},{127517,10113,0,0,2},{127518,10115,0,0,2},{127519,
10117,0,0,2},{127520,10119,0,0,2},{127521,10121,0,0,2},{127522,10123,0,0,2},
{127523,10125,0,0,2},{127524,10127,0,0,2},{127525,10129,0,0,2},{127526,10131,0,
0,2},{127527,10133,0,0,2},{127528,10135,0,0,2},{127529,10137,0,0,2},{127530,
10139,0,0,2},{127531,10141,0,0,2},{127532,10143,0,0,2},{127533,10145,0,0,2},
{127534,10147,0,0,2},{127535,10149,0,0,2},{127536,10151,0,0,2},{127537,10153,0,
0,2},{127538,10155,0,0,2},{127539,10157,0,0,2},{127540,10159,0,0,2},{127541,
10161,0,0,2},{127542,10163,0,0,2},{127543,10165,0,0,2},{127544,10167,0,0,2},
{127545,10169,0,0,2},{127546,10171,0,0,2},{127547,10173,0,0,2},{127552,10175,0,
0,4},{127553,10179,0,0,4},{127554,10183,0,0,4},{127555,10187,0,0,4},{127556,
10191,0,0,4},{127557,10195,0,0,4},{127558,10199,0,0,4},{127559,10203,0,0,4},
{127560,10207,0,0,4},{127568,10211,0,0,2},{127569,10213,0,0,2},{131362,10215,0,
0,2},{132380,10217,0,0,2},{132389,10219,0,0,2},{132427,10221,0,0,2},{132666,
10223,0,0,2},{133124,10225,0,0,2},{133342,10227,0,0,2},{133676,10229,0,0,2},
{133987,10231,0,0,2},{136420,10233,0,0,2},{136872,10235,0,0,2},{136938,10237,0,
0,2},{137672,10239,0,0,2},{138008,10241,0,0,2},{138507,10243,0,0,2},{138724,
10245,0,0,2},{138726,10247,0,0,2},{139651,10249,0,0,2},{139679,10251,0,0,2},
{140081,10253,0,0,2},{141012,10255,0,0,2},{141380,10257,0,0,2},{141386,10259,0,
0,2},{142092,10261,0,0,2},{142321,10263,0,0,2},{143370,10265,0,0,2},{144056,
10267,0,0,2},{144223,10269,0,0,2},{144275,10271,0,0,2},{144284,10273,0,0,2},
{144323,10275,0,0,2},{144341,10277,0,0,2},{144493,10279,0,0,2},{145059,10281,0,
0,2},{145575,10283,0,0,2},{146061,10285,0,0,2},{146170,10287,0,0,2},{146620,
10289,0,0,2},{146718,10291,0,0,2},{147153,10293,0,0,2},{147294,10295,0,0,2},
{147342,10297,0,0,2},{148067,10299,0,0,2},{148206,10301,0,0,2},{148395,10303,0,
0,2},{149000,10305,0,0,2},{149301,10307,0,0,2},{149524,10309,0,0,2},{150582,
10311,0,0,2},{150674,10313,0,0,2},{151457,10315,0,0,2},{151480,10317,0,0,2},
{151620,10319,0,0,2},{151794,10321,0,0,2},{151795,10323,0,0,2},{151833,10325,0,
0,2},{151859,10327,0,0,2},{152137,10329,0,0,2},{152605,10331,0,0,2},{153126,
10333,0,0,2},{153242,10335,0,0,2},{153285,10337,0,0,2},{153980,10339,0,0,2},
{154279,10341,0,0,2},{154539,10343,0,0,2},{154752,10345,0,0,2},{154832,10347,0,
0,2},{155526,10349,0,0,2},{156122,10351,0,0,2},{156200,10353,0,0,2},{156231,
10355,0,0,2},{156377,10357,0,0,2},{156478,10359,0,0,2},{156890,10361,0,0,2},
{156963,10363,0,0,2},{157096,10365,0,0,2},{157607,10367,0,0,2},{157621,10369,0,
0,2},{158524,10371,0,0,2},{158774,10373,0,0,2},{158933,10375,0,0,2},{159083,
10377,0,0,2},{159532,10379,0,0,2},{159665,10381,0,0,2},{159954,10383,0,0,2},
{160714,10385,0,0,2},{161383,10387,0,0,2},{161966,10389,0,0,2},{162150,10391,0,
0,2},{162984,10393,0,0,2},{163539,10395,0,0,2},{163631,10397,0,0,2},{165330,
10399,0,0,2},{165357,10401,0,0,2},{165678,10403,0,0,2},{166906,10405,0,0,2},
{167287,10407,0,0,2},{168261,10409,0,0,2},{168415,10411,0,0,2},{168474,10413,0,
0,2},{168970,10415,0,0,2},{169110,10417,0,0,2},{169398,10419,0,0,2},{170800,
10421,0,0,2},{172238,10423,0,0,2},{172293,10425,0,0,2},{172558,10427,0,0,2},
{172689,10429,0,0,2},{172946,10431,0,0,2},{173568,10433,0,0,2},{183,0,0,0,2},
{183,2,0,0,2},{769,649,0,0,2},{1463,811,0,0,2},{1464,813,0,0,2},{1468,815,0,0,
2},{1468,817,0,0,2},{1471,819,0,0,2},{1468,821,0,0,2},{1468,823,0,0,2},{1468,
825,0,0,2},{1465,827,0,0,2},{1468,829,0,0,2},{1468,831,0,0,2},{1468,833,0,0,2},
{1460,835,0,0,2},{1468,837,0,0,2},{1468,839,0,0,2},{1468,841,0,0,2},{1471,843,0,
0,2},{1468,845,0,0,2},{1468,847,0,0,2},{1468,849,0,0,2},{1468,851,0,0,2},{1468,
853,0,0,2},{1468,855,0,0,2},{1471,857,0,0,2},{1468,859,0,0,2},{1468,861,0,0,2},
{1468,863,0,0,2},{1468,865,3834,2,2},{1473,867,0,0,3},{1474,870,0,0,3},{1473,
873,0,0,2},{1474,875,0,0,2},{1468,877,0,0,2},{1463,885,0,0,3},{2364,924,0,0,2},
{2364,926,0,0,2},{2364,928,0,0,2},{2364,930,0,0,2},{2364,932,0,0,2},{2364,934,0,
0,2},{2364,938,0,0,2},{2364,940,0,0,2},{2492,946,0,0,2},{2492,948,0,0,2},{2492,
950,0,0,2},{2620,954,0,0,2},{2620,956,0,0,2},{2620,958,0,0,2},{2620,960,0,0,2},
{2620,962,0,0,2},{2620,964,0,0,2},{2876,966,0,0,2},{2876,968,0,0,2},{3585,990,0,
0,2},{3586,992,0,0,2},{3587,994,0,0,2},{3588,996,0,0,2},{3589,998,0,0,2},{3590,
1000,0,0,2},{3591,1002,0,0,2},{3592,1004,0,0,2},{3593,1006,0,0,2},{3594,1008,0,
0,2},{3595,1010,0,0,2},{3596,1012,0,0,2},{3597,1014,0,0,2},{3598,1016,0,0,2},
{3599,1018,0,0,2},{3600,1020,0,0,2},{3601,1022,0,0,2},{3602,1024,0,0,2},{3603,
1026,0,0,2},{3604,1028,0,0,2},{3605,1030,0,0,2},{3606,1032,0,0,2},{3607,1034,0,
0,2},{3608,1036,0,0,2},{3609,1038,0,0,2},{3610,1040,0,0,2},{3611,1042,0,0,2},
{3612,1044,0,0,2},{3613,1046,0,0,2},{3614,1048,0,0,2},{3615,1050,0,0,2},{3616,
1052,0,0,2},{3617,1054,0,0,2},{3618,1056,0,0,2},{3619,1058,0,0,2},{3620,1060,0,
0,2},{3621,1062,0,0,2},{3622,1064,0,0,2},{3623,1066,0,0,2},{3624,1068,0,0,2},
{3625,1070,0,0,2},{3626,1072,0,0,2},{3627,1074,0,0,2},{3628,1076,0,0,2},{3629,
1078,0,0,2},{3630,1080,0,0,2},{3585,1082,0,0,2},{3586,1084,0,0,2},{3587,1086,0,
0,2},{3588,1088,0,0,2},{3589,1090,0,0,2},{3590,1092,0,0,2},{3591,1094,0,0,2},
{3592,1096,0,0,2},{3593,1098,0,0,2},{3594,1100,0,0,2},{3595,1102,0,0,2},{3596,
1104,0,0,2},{3597,1106,0,0,2},{3598,1108,0,0,2},{3599,1110,0,0,2},{3600,1112,0,
0,2},{3601,1114,0,0,2},{3602,1116,0,0,2},{3603,1118,0,0,2},{3604,1120,0,0,2},
{3605,1122,0,0,2},{3606,1124,0,0,2},{3607,1126,0,0,2},{3608,1128,0,0,2},{3609,
1130,0,0,2},{3610,1132,0,0,2},{3611,1134,0,0,2},{3612,1136,0,0,2},{3613,1138,0,
0,2},{3614,1140,0,0,2},{3615,1142,0,0,2},{3616,1144,0,0,2},{3617,1146,0,0,2},
{3618,1148,0,0,2},{3619,1150,0,0,2},{3620,1152,0,0,2},{3621,1154,0,0,2},{3622,
1156,0,0,2},{3623,1158,0,0,2},{3624,1160,0,0,2},{3625,1162,0,0,2},{3626,1164,0,
0,2},{3627,1166,0,0,2},{3628,1168,0,0,2},{3629,1170,0,0,2},{3630,1172,0,0,2},
{3585,1174,0,0,2},{3586,1176,0,0,2},{3587,1178,0,0,2},{3588,1180,0,0,2},{3589,
1182,0,0,2},{3590,1184,0,0,2},{3591,1186,0,0,2},{3592,1188,0,0,2},{3593,1190,0,
0,2},{3594,1192,0,0,2},{3595,1194,0,0,2},{3596,1196,0,0,2},{3597,1198,0,0,2},
{3598,1200,0,0,2},{3599,1202,0,0,2},{3600,1204,0,0,2},{3601,1206,0,0,2},{3602,
1208,0,0,2},{3603,1210,0,0,2},{3604,1212,0,0,2},{3605,1214,0,0,2},{3606,1216,0,
0,2},{3607,1218,0,0,2},{3608,1220,0,0,2},{3609,1222,0,0,2},{3610,1224,0,0,2},
{3611,1226,0,0,2},{3612,1228,0,0,2},{3613,1230,0,0,2},{3614,1232,0,0,2},{3615,
1234,0,0,2},{3616,1236,0,0,2},{3617,1238,0,0,2},{3618,1240,0,0,2},{3619,1242,0,
0,2},{3620,1244,0,0,2},{3621,1246,0,0,2},{3622,1248,0,0,2},{3623,1250,0,0,2},
{3624,1252,0,0,2},{3625,1254,0,0,2},{3626,1256,0,0,2},{3627,1258,0,0,2},{3628,
1260,0,0,2},{3629,1262,0,0,2},{3630,1264,0,0,2},{3585,1266,0,0,2},{3586,1268,0,
0,2},{3587,1270,0,0,2},{3588,1272,0,0,2},{3589,1274,0,0,2},{3590,1276,0,0,2},
{3591,1278,0,0,2},{3592,1280,0,0,2},{3593,1282,0,0,2},{3594,1284,0,0,2},{3595,
1286,0,0,2},{3596,1288,0,0,2},{3597,1290,0,0,2},{3598,1292,0,0,2},{3599,1294,0,
0,2},{3600,1296,0,0,2},{3601,1298,0,0,2},{3602,1300,0,0,2},{3603,1302,0,0,2},
{3604,1304,0,0,2},{3605,1306,0,0,2},{3606,1308,0,0,2},{3607,1310,0,0,2},{3608,
1312,0,0,2},{3609,1314,0,0,2},{3610,1316,0,0,2},{3611,1318,0,0,2},{3612,1320,0,
0,2},{3613,1322,0,0,2},{3614,1324,0,0,2},{3615,1326,0,0,2},{3616,1328,0,0,2},
{3617,1330,0,0,2},{3618,1332,0,0,2},{3619,1334,0,0,2},{3620,1336,0,0,2},{3621,
1338,0,0,2},{3622,1340,0,0,2},{3623,1342,0,0,2},{3624,1344,0,0,2},{3625,1346,0,
0,2},{3626,1348,0,0,2},{3627,1350,0,0,2},{3628,1352,0,0,2},{3629,1354,0,0,2},
{3630,1356,0,0,2},{3585,1358,0,0,2},{3586,1360,0,0,2},{3587,1362,0,0,2},{3588,
1364,0,0,2},{3589,1366,0,0,2},{3590,1368,0,0,2},{3591,1370,0,0,2},{3592,1372,0,
0,2},{3593,1374,0,0,2},{3594,1376,0,0,2},{3595,1378,0,0,2},{3596,1380,0,0,2},
{3597,1382,0,0,2},{3598,1384,0,0,2},{3599,1386,0,0,2},{3600,1388,0,0,2},{3601,
1390,0,0,2},{3602,1392,0,0,2},{3603,1394,0,0,2},{3604,1396,0,0,2},{3605,1398,0,
0,2},{3606,1400,0,0,2},{3607,1402,0,0,2},{3608,1404,0,0,2},{3609,1406,0,0,2},
{3610,1408,0,0,2},{3611,1410,0,0,2},{3612,1412,0,0,2},{3613,1414,0,0,2},{3614,
1416,0,0,2},{3615,1418,0,0,2},{3616,1420,0,0,2},{3617,1422,0,0,2},{3618,1424,0,
0,2},{3619,1426,0,0,2},{3620,1428,0,0,2},{3621,1430,0,0,2},{3622,1432,0,0,2},
{3623,1434,0,0,2},{3624,1436,0,0,2},{3625,1438,0,0,2},{3626,1440,0,0,2},{3627,
1442,0,0,2},{3628,1444,0,0,2},{3629,1446,0,0,2},{3630,1448,0,0,2},{3634,1450,0,
0,1},{3713,1451,0,0,2},{3714,1453,0,0,2},{3716,1455,0,0,2},{3719,1457,0,0,2},
{3720,1459,0,0,2},{3722,1461,0,0,2},{3725,1463,0,0,2},{3732,1465,0,0,2},{3733,
1467,0,0,2},{3734,1469,0,0,2},{3735,1471,0,0,2},{3737,1473,0,0,2},{3738,1475,0,
0,2},{3739,1477,0,0,2},{3740,1479,0,0,2},{3741,1481,0,0,2},{3742,1483,0,0,2},
{3743,1485,0,0,2},{3745,1487,0,0,2},{3746,1489,0,0,2},{3747,1491,0,0,2},{3749,
1493,0,0,2},{3751,1495,0,0,2},{3754,1497,0,0,2},{3755,1499,0,0,2},{3757,1501,0,
0,2},{3758,1503,0,0,2},{3804,1505,0,0,3},{3805,1508,0,0,3},{3806,1511,0,0,2},
{3807,1513,0,0,2},{3713,1515,0,0,2},{3714,1517,0,0,2},{3716,1519,0,0,2},{3719,
1521,0,0,2},{3720,1523,0,0,2},{3722,1525,0,0,2},{3725,1527,0,0,2},{3732,1529,0,
0,2},{3733,1531,0,0,2},{3734,1533,0,0,2},{3735,1535,0,0,2},{3737,1537,0,0,2},
{3738,1539,0,0,2},{3739,1541,0,0,2},{3740,1543,0,0,2},{3741,1545,0,0,2},{3742,
1547,0,0,2},{3743,1549,0,0,2},{3745,1551,0,0,2},{3746,1553,0,0,2},{3747,1555,0,
0,2},{3749,1557,0,0,2},{3751,1559,0,0,2},{3754,1561,0,0,2},{3755,1563,0,0,2},
{3757,1565,0,0,2},{3758,1567,0,0,2},{3804,1569,0,0,3},{3805,1572,0,0,3},{3806,
1575,0,0,2},{3807,1577,0,0,2},{3713,1579,0,0,2},{3714,1581,0,0,2},{3716,1583,0,
0,2},{3719,1585,0,0,2},{3720,1587,0,0,2},{3722,1589,0,0,2},{3725,1591,0,0,2},
{3732,1593,0,0,2},{3733,1595,0,0,2},{3734,1597,0,0,2},{3735,1599,0,0,2},{3737,
1601,0,0,2},{3738,1603,0,0,2},{3739,1605,0,0,2},{3740,1607,0,0,2},{3741,1609,0,
0,2},{3742,1611,0,0,2},{3743,1613,0,0,2},{3745,1615,0,0,2},{3746,1617,0,0,2},
{3747,1619,0,0,2},{3749,1621,0,0,2},{3751,1623,0,0,2},{3754,1625,0,0,2},{3755,
1627,0,0,2},{3757,1629,0,0,2},{3758,1631,0,0,2},{3804,1633,0,0,3},{3805,1636,0,
0,3},{3806,1639,0,0,2},{3807,1641,0,0,2},{3713,1643,0,0,2},{3714,1645,0,0,2},
{3716,1647,0,0,2},{3719,1649,0,0,2},{3720,1651,0,0,2},{3722,1653,0,0,2},{3725,
1655,0,0,2},{3732,1657,0,0,2},{3733,1659,0,0,2},{3734,1661,0,0,2},{3735,1663,0,
0,2},{3737,1665,0,0,2},{3738,1667,0,0,2},{3739,1669,0,0,2},{3740,1671,0,0,2},
{3741,1673,0,0,2},{3742,1675,0,0,2},{3743,1677,0,0,2},{3745,1679,0,0,2},{3746,
1681,0,0,2},{3747,1683,0,0,2},{3749,1685,0,0,2},{3751,1687,0,0,2},{3754,1689,0,
0,2},{3755,1691,0,0,2},{3757,1693,0,0,2},{3758,1695,0,0,2},{3804,1697,0,0,3},
{3805,1700,0,0,3},{3806,1703,0,0,2},{3807,1705,0,0,2},{3713,1707,0,0,2},{3714,
1709,0,0,2},{3716,1711,0,0,2},{3719,1713,0,0,2},{3720,1715,0,0,2},{3722,1717,0,
0,2},{3725,1719,0,0,2},{3732,1721,0,0,2},{3733,1723,0,0,2},{3734,1725,0,0,2},
{3735,1727,0,0,2},{3737,1729,0,0,2},{3738,1731,0,0,2},{3739,1733,0,0,2},{3740,
1735,0,0,2},{3741,1737,0,0,2},{3742,1739,0,0,2},{3743,1741,0,0,2},{3745,1743,0,
0,2},{3746,1745,0,0,2},{3747,1747,0,0,2},{3749,1749,0,0,2},{3751,1751,0,0,2},
{3754,1753,0,0,2},{3755,1755,0,0,2},{3757,1757,0,0,2},{3758,1759,0,0,2},{3804,
1761,0,0,3},{3805,1764,0,0,3},{3806,1767,0,0,2},{3807,1769,0,0,2},{3762,1771,0,
0,1},{4021,1779,0,0,2},{4023,1781,0,0,2},{4023,1783,0,0,2},{4023,1785,0,0,2},
{4023,1787,0,0,2},{4023,1789,0,0,2},{3954,1793,0,0,1},{3956,1794,0,0,1},{3968,
1795,0,0,1},{4021,1796,0,0,2},{4023,1798,0,0,2},{4023,1800,0,0,2},{4023,1802,0,
0,2},{4023,1804,0,0,2},{4023,1806,0,0,2},{3953,0,4262,1,0},{3968,1808,0,0,1},
{3968,1809,0,0,1},{3953,0,4265,1,0},{3968,1810,0,0,1},{3968,1811,0,0,1},{6528,
1907,0,0,2},{6529,1909,0,0,2},{6530,1911,0,0,2},{6531,1913,0,0,2},{6532,1915,0,
0,2},{6533,1917,0,0,2},{6534,1919,0,0,2},{6535,1921,0,0,2},{6536,1923,0,0,2},
{6537,1925,0,0,2},{6538,1927,0,0,2},{6539,1929,0,0,2},{6540,1931,0,0,2},{6541,
1933,0,0,2},{6542,1935,0,0,2},{6543,1937,0,0,2},{6544,1939,0,0,2},{6545,1941,0,
0,2},{6546,1943,0,0,2},{6547,1945,0,0,2},{6548,1947,0,0,2},{6549,1949,0,0,2},
{6550,1951,0,0,2},{6551,1953,0,0,2},{6552,1955,0,0,2},{6553,1957,0,0,2},{6554,
1959,0,0,2},{6555,1961,0,0,2},{6556,1963,0,0,2},{6557,1965,0,0,2},{6558,1967,0,
0,2},{6559,1969,0,0,2},{6560,1971,0,0,2},{6561,1973,0,0,2},{6562,1975,0,0,2},
{6563,1977,0,0,2},{6564,1979,0,0,2},{6565,1981,0,0,2},{6566,1983,0,0,2},{6567,
1985,0,0,2},{6568,1987,0,0,2},{6569,1989,0,0,2},{6570,1991,0,0,2},{6571,1993,0,
0,2},{6528,1995,0,0,2},{6529,1997,0,0,2},{6530,1999,0,0,2},{6531,2001,0,0,2},
{6532,2003,0,0,2},{6533,2005,0,0,2},{6534,2007,0,0,2},{6535,2009,0,0,2},{6536,
2011,0,0,2},{6537,2013,0,0,2},{6538,2015,0,0,2},{6539,2017,0,0,2},{6540,2019,0,
0,2},{6541,2021,0,0,2},{6542,2023,0,0,2},{6543,2025,0,0,2},{6544,2027,0,0,2},
{6545,2029,0,0,2},{6546,2031,0,0,2},{6547,2033,0,0,2},{6548,2035,0,0,2},{6549,
2037,0,0,2},{6550,2039,0,0,2},{6551,2041,0,0,2},{6552,2043,0,0,2},{6553,2045,0,
0,2},{6554,2047,0,0,2},{6555,2049,0,0,2},{6556,2051,0,0,2},{6557,2053,0,0,2},
{6558,2055,0,0,2},{6559,2057,0,0,2},{6560,2059,0,0,2},{6561,2061,0,0,2},{6562,
2063,0,0,2},{6563,2065,0,0,2},{6564,2067,0,0,2},{6565,2069,0,0,2},{6566,2071,0,
0,2},{6567,2073,0,0,2},{6568,2075,0,0,2},{6569,2077,0,0,2},{6570,2079,0,0,2},
{6571,2081,0,0,2},{6528,2083,0,0,2},{6529,2085,0,0,2},{6530,2087,0,0,2},{6531,
2089,0,0,2},{6532,2091,0,0,2},{6533,2093,0,0,2},{6534,2095,0,0,2},{6535,2097,0,
0,2},{6536,2099,0,0,2},{6537,2101,0,0,2},{6538,2103,0,0,2},{6539,2105,0,0,2},
{6540,2107,0,0,2},{6541,2109,0,0,2},{6542,2111,0,0,2},{6543,2113,0,0,2},{6544,
2115,0,0,2},{6545,2117,0,0,2},{6546,2119,0,0,2},{6547,2121,0,0,2},{6548,2123,0,
0,2},{6549,2125,0,0,2},{6550,2127,0,0,2},{6551,2129,0,0,2},{6552,2131,0,0,2},
{6553,2133,0,0,2},{6554,2135,0,0,2},{6555,2137,0,0,2},{6556,2139,0,0,2},{6557,
2141,0,0,2},{6558,2143,0,0,2},{6559,2145,0,0,2},{6560,2147,0,0,2},{6561,2149,0,
0,2},{6562,2151,0,0,2},{6563,2153,0,0,2},{6564,2155,0,0,2},{6565,2157,0,0,2},
{6566,2159,0,0,2},{6567,2161,0,0,2},{6568,2163,0,0,2},{6569,2165,0,0,2},{6570,
2167,0,0,2},{6571,2169,0,0,2},{6528,2171,0,0,2},{6529,2173,0,0,2},{6530,2175,0,
0,2},{6531,2177,0,0,2},{6532,2179,0,0,2},{6533,2181,0,0,2},{6534,2183,0,0,2},
{6535,2185,0,0,2},{6536,2187,0,0,2},{6537,2189,0,0,2},{6538,2191,0,0,2},{6539,
2193,0,0,2},{6540,2195,0,0,2},{6541,2197,0,0,2},{6542,2199,0,0,2},{6543,2201,0,
0,2},{6544,2203,0,0,2},{6545,2205,0,0,2},{6546,2207,0,0,2},{6547,2209,0,0,2},
{6548,2211,0,0,2},{6549,2213,0,0,2},{6550,2215,0,0,2},{6551,2217,0,0,2},{6552,
2219,0,0,2},{6553,2221,0,0,2},{6554,2223,0,0,2},{6555,2225,0,0,2},{6556,2227,0,
0,2},{6557,2229,0,0,2},{6558,2231,0,0,2},{6559,2233,0,0,2},{6560,2235,0,0,2},
{6561,2237,0,0,2},{6562,2239,0,0,2},{6563,2241,0,0,2},{6564,2243,0,0,2},{6565,
2245,0,0,2},{6566,2247,0,0,2},{6567,2249,0,0,2},{6568,2251,0,0,2},{6569,2253,0,
0,2},{6570,2255,0,0,2},{6571,2257,0,0,2},{824,4003,0,0,2},{43648,7984,0,0,2},
{43649,7986,0,0,2},{43650,7988,0,0,2},{43651,7990,0,0,2},{43652,7992,0,0,2},
{43653,7994,0,0,2},{43654,7996,0,0,2},{43655,7998,0,0,2},{43656,8000,0,0,2},
{43657,8002,0,0,2},{43658,8004,0,0,2},{43659,8006,0,0,2},{43660,8008,0,0,2},
{43661,8010,0,0,2},{43662,8012,0,0,2},{43663,8014,0,0,2},{43664,8016,0,0,2},
{43665,8018,0,0,2},{43666,8020,0,0,2},{43667,8022,0,0,2},{43668,8024,0,0,2},
{43669,8026,0,0,2},{43670,8028,0,0,2},{43671,8030,0,0,2},{43672,8032,0,0,2},
{43673,8034,0,0,2},{43674,8036,0,0,2},{43675,8038,0,0,2},{43676,8040,0,0,2},
{43677,8042,0,0,2},{43678,8044,0,0,2},{43679,8046,0,0,2},{43680,8048,0,0,2},
{43681,8050,0,0,2},{43682,8052,0,0,2},{43683,8054,0,0,2},{43684,8056,0,0,2},
{43685,8058,0,0,2},{43686,8060,0,0,2},{43687,8062,0,0,2},{43688,8064,0,0,2},
{43689,8066,0,0,2},{43690,8068,0,0,2},{43691,8070,0,0,2},{43692,8072,0,0,2},
{43693,8074,0,0,2},{43694,8076,0,0,2},{43695,8078,0,0,2},{43648,8080,0,0,2},
{43649,8082,0,0,2},{43650,8084,0,0,2},{43651,8086,0,0,2},{43652,8088,0,0,2},
{43653,8090,0,0,2},{43654,8092,0,0,2},{43655,8094,0,0,2},{43656,8096,0,0,2},
{43657,8098,0,0,2},{43658,8100,0,0,2},{43659,8102,0,0,2},{43660,8104,0,0,2},
{43661,8106,0,0,2},{43662,8108,0,0,2},{43663,8110,0,0,2},{43664,8112,0,0,2},
{43665,8114,0,0,2},{43666,8116,0,0,2},{43667,8118,0,0,2},{43668,8120,0,0,2},
{43669,8122,0,0,2},{43670,8124,0,0,2},{43671,8126,0,0,2},{43672,8128,0,0,2},
{43673,8130,0,0,2},{43674,8132,0,0,2},{43675,8134,0,0,2},{43676,8136,0,0,2},
{43677,8138,0,0,2},{43678,8140,0,0,2},{43679,8142,0,0,2},{43680,8144,0,0,2},
{43681,8146,0,0,2},{43682,8148,0,0,2},{43683,8150,0,0,2},{43684,8152,0,0,2},
{43685,8154,0,0,2},{43686,8156,0,0,2},{43687,8158,0,0,2},{43688,8160,0,0,2},
{43689,8162,0,0,2},{43690,8164,0,0,2},{43691,8166,0,0,2},{43692,8168,0,0,2},
{43693,8170,0,0,2},{43694,8172,0,0,2},{43695,8174,0,0,2},{43648,8176,0,0,2},
{43649,8178,0,0,2},{43650,8180,0,0,2},{43651,8182,0,0,2},{43652,8184,0,0,2},
{43653,8186,0,0,2},{43654,8188,0,0,2},{43655,8190,0,0,2},{43656,8192,0,0,2},
{43657,8194,0,0,2},{43658,8196,0,0,2},{43659,8198,0,0,2},{43660,8200,0,0,2},
{43661,8202,0,0,2},{43662,8204,0,0,2},{43663,8206,0,0,2},{43664,8208,0,0,2},
{43665,8210,0,0,2},{43666,8212,0,0,2},{43667,8214,0,0,2},{43668,8216,0,0,2},
{43669,8218,0,0,2},{43670,8220,0,0,2},{43671,8222,0,0,2},{43672,8224,0,0,2},
{43673,8226,0,0,2},{43674,8228,0,0,2},{43675,8230,0,0,2},{43676,8232,0,0,2},
{43677,8234,0,0,2},{43678,8236,0,0,2},{43679,8238,0,0,2},{43680,8240,0,0,2},
{43681,8242,0,0,2},{43682,8244,0,0,2},{43683,8246,0,0,2},{43684,8248,0,0,2},
{43685,8250,0,0,2},{43686,8252,0,0,2},{43687,8254,0,0,2},{43688,8256,0,0,2},
{43689,8258,0,0,2},{43690,8260,0,0,2},{43691,8262,0,0,2},{43692,8264,0,0,2},
{43693,8266,0,0,2},{43694,8268,0,0,2},{43695,8270,0,0,2},{43648,8272,0,0,2},
{43649,8274,0,0,2},{43650,8276,0,0,2},{43651,8278,0,0,2},{43652,8280,0,0,2},
{43653,8282,0,0,2},{43654,8284,0,0,2},{43655,8286,0,0,2},{43656,8288,0,0,2},
{43657,8290,0,0,2},{43658,8292,0,0,2},{43659,8294,0,0,2},{43660,8296,0,0,2},
{43661,8298,0,0,2},{43662,8300,0,0,2},{43663,8302,0,0,2},{43664,8304,0,0,2},
{43665,8306,0,0,2},{43666,8308,0,0,2},{43667,8310,0,0,2},{43668,8312,0,0,2},
{43669,8314,0,0,2},{43670,8316,0,0,2},{43671,8318,0,0,2},{43672,8320,0,0,2},
{43673,8322,0,0,2},{43674,8324,0,0,2},{43675,8326,0,0,2},{43676,8328,0,0,2},
{43677,8330,0,0,2},{43678,8332,0,0,2},{43679,8334,0,0,2},{43680,8336,0,0,2},
{43681,8338,0,0,2},{43682,8340,0,0,2},{43683,8342,0,0,2},{43684,8344,0,0,2},
{43685,8346,0,0,2},{43686,8348,0,0,2},{43687,8350,0,0,2},{43688,8352,0,0,2},
{43689,8354,0,0,2},{43690,8356,0,0,2},{43691,8358,0,0,2},{43692,8360,0,0,2},
{43693,8362,0,0,2},{43694,8364,0,0,2},{43695,8366,0,0,2},{43648,8368,0,0,2},
{43649,8370,0,0,2},{43650,8372,0,0,2},{43651,8374,0,0,2},{43652,8376,0,0,2},
{43653,8378,0,0,2},{43654,8380,0,0,2},{43655,8382,0,0,2},{43656,8384,0,0,2},
{43657,8386,0,0,2},{43658,8388,0,0,2},{43659,8390,0,0,2},{43660,8392,0,0,2},
{43661,8394,0,0,2},{43662,8396,0,0,2},{43663,8398,0,0,2},{43664,8400,0,0,2},
{43665,8402,0,0,2},{43666,8404,0,0,2},{43667,8406,0,0,2},{43668,8408,0,0,2},
{43669,8410,0,0,2},{43670,8412,0,0,2},{43671,8414,0,0,2},{43672,8416,0,0,2},
{43673,8418,0,0,2},{43674,8420,0,0,2},{43675,8422,0,0,2},{43676,8424,0,0,2},
{43677,8426,0,0,2},{43678,8428,0,0,2},{43679,8430,0,0,2},{43680,8432,0,0,2},
{43681,8434,0,0,2},{43682,8436,0,0,2},{43683,8438,0,0,2},{43684,8440,0,0,2},
{43685,8442,0,0,2},{43686,8444,0,0,2},{43687,8446,0,0,2},{43688,8448,0,0,2},
{43689,8450,0,0,2},{43690,8452,0,0,2},{43691,8454,0,0,2},{43692,8456,0,0,2},
{43693,8458,0,0,2},{43694,8460,0,0,2},{43695,8462,0,0,2},{119141,9825,0,0,2},
{119141,9827,4686,5,2},{119150,9829,0,0,3},{119151,9832,0,0,3},{119152,9835,0,0,
3},{119153,9838,0,0,3},{119154,9841,0,0,3},{119141,9844,4692,2,2},{119150,9846,
0,0,3},{119151,9849,0,0,3},{119141,9852,4695,2,2},{119150,9854,0,0,3},{119151,
9857,0,0,3}};

struct collation_key special_collation_keys[10435] = {
{7645,8,0,32},{0,2,0,273},{7645,2,0,32},{0,2,0,273},{7332,30,0,32},{1596,30,1,
32},{7335,30,0,32},{7332,30,0,32},{1596,30,1,32},{7333,30,0,32},{7334,30,0,32},
{1596,30,1,32},{7335,30,0,32},{7341,8,0,32},{0,2,0,37},{7341,8,0,32},{0,2,0,36},
{7341,8,0,32},{0,2,0,39},{7341,8,0,32},{0,2,0,45},{7341,8,0,32},{0,2,0,43},
{7341,8,0,32},{0,2,0,41},{7341,10,0,32},{0,4,0,273},{7440,10,0,32},{7392,8,0,
32},{0,2,0,48},{7440,8,0,32},{0,2,0,37},{7440,8,0,32},{0,2,0,36},{7440,8,0,32},
{0,2,0,39},{7440,8,0,32},{0,2,0,43},{7576,8,0,32},{0,2,0,37},{7576,8,0,32},{0,2,
0,36},{7576,8,0,32},{0,2,0,39},{7576,8,0,32},{0,2,0,43},{7413,10,0,32},{0,4,0,
273},{7711,8,0,32},{0,2,0,45},{7747,8,0,32},{0,2,0,37},{7747,8,0,32},{0,2,0,36},
{7747,8,0,32},{0,2,0,39},{7747,8,0,32},{0,2,0,45},{7747,8,0,32},{0,2,0,43},
{7747,8,0,32},{0,2,0,47},{7963,8,0,32},{0,2,0,37},{7963,8,0,32},{0,2,0,36},
{7963,8,0,32},{0,2,0,39},{7963,8,0,32},{0,2,0,43},{8049,8,0,32},{0,2,0,36},
{7895,4,0,32},{0,4,0,273},{7895,4,0,32},{7341,2,0,32},{0,2,0,37},{7341,2,0,32},
{0,2,0,36},{7341,2,0,32},{0,2,0,39},{7341,2,0,32},{0,2,0,45},{7341,2,0,32},{0,2,
0,43},{7341,2,0,32},{0,2,0,41},{7341,4,0,32},{0,4,0,273},{7440,4,0,32},{7392,2,
0,32},{0,2,0,48},{7440,2,0,32},{0,2,0,37},{7440,2,0,32},{0,2,0,36},{7440,2,0,
32},{0,2,0,39},{7440,2,0,32},{0,2,0,43},{7576,2,0,32},{0,2,0,37},{7576,2,0,32},
{0,2,0,36},{7576,2,0,32},{0,2,0,39},{7576,2,0,32},{0,2,0,43},{7413,4,0,32},{0,4,
0,273},{7711,2,0,32},{0,2,0,45},{7747,2,0,32},{0,2,0,37},{7747,2,0,32},{0,2,0,
36},{7747,2,0,32},{0,2,0,39},{7747,2,0,32},{0,2,0,45},{7747,2,0,32},{0,2,0,43},
{7747,2,0,32},{0,2,0,47},{7963,2,0,32},{0,2,0,37},{7963,2,0,32},{0,2,0,36},
{7963,2,0,32},{0,2,0,39},{7963,2,0,32},{0,2,0,43},{8049,2,0,32},{0,2,0,36},
{8049,2,0,32},{0,2,0,43},{7341,8,0,32},{0,2,0,50},{7341,2,0,32},{0,2,0,50},
{7341,8,0,32},{0,2,0,38},{7341,2,0,32},{0,2,0,38},{7341,8,0,32},{0,2,0,49},
{7341,2,0,32},{0,2,0,49},{7392,8,0,32},{0,2,0,36},{7392,2,0,32},{0,2,0,36},
{7392,8,0,32},{0,2,0,39},{7392,2,0,32},{0,2,0,39},{7392,8,0,32},{0,2,0,46},
{7392,2,0,32},{0,2,0,46},{7392,8,0,32},{0,2,0,40},{7392,2,0,32},{0,2,0,40},
{7413,8,0,32},{0,2,0,40},{7413,2,0,32},{0,2,0,40},{7413,8,0,32},{0,2,0,57},
{7413,2,0,32},{0,2,0,57},{7440,8,0,32},{0,2,0,50},{7440,2,0,32},{0,2,0,50},
{7440,8,0,32},{0,2,0,38},{7440,2,0,32},{0,2,0,38},{7440,8,0,32},{0,2,0,46},
{7440,2,0,32},{0,2,0,46},{7440,8,0,32},{0,2,0,49},{7440,2,0,32},{0,2,0,49},
{7440,8,0,32},{0,2,0,40},{7440,2,0,32},{0,2,0,40},{7514,8,0,32},{0,2,0,39},
{7514,2,0,32},{0,2,0,39},{7514,8,0,32},{0,2,0,38},{7514,2,0,32},{0,2,0,38},
{7514,8,0,32},{0,2,0,46},{7514,2,0,32},{0,2,0,46},{7514,8,0,32},{0,2,0,48},
{7514,2,0,32},{0,2,0,48},{7550,8,0,32},{0,2,0,39},{7550,2,0,32},{0,2,0,39},
{7550,8,0,32},{0,2,0,57},{7550,2,0,32},{0,2,0,57},{7576,8,0,32},{0,2,0,45},
{7576,2,0,32},{0,2,0,45},{7576,8,0,32},{0,2,0,50},{7576,2,0,32},{0,2,0,50},
{7576,8,0,32},{0,2,0,38},{7576,2,0,32},{0,2,0,38},{7576,8,0,32},{0,2,0,49},
{7576,2,0,32},{0,2,0,49},{7576,8,0,32},{0,2,0,46},{7576,10,0,32},{7602,10,0,32},
{7576,4,0,32},{7602,4,0,32},{7602,8,0,32},{0,2,0,39},{7602,2,0,32},{0,2,0,39},
{7627,8,0,32},{0,2,0,48},{7627,2,0,32},{0,2,0,48},{7645,8,0,32},{0,2,0,36},
{7645,2,0,32},{0,2,0,36},{7645,8,0,32},{0,2,0,48},{7645,2,0,32},{0,2,0,48},
{7645,8,0,32},{0,2,0,40},{7645,2,0,32},{0,2,0,40},{7645,8,0,32},{0,2,0,273},
{7645,2,0,32},{0,2,0,273},{7645,8,0,32},{0,2,0,57},{7645,2,0,32},{0,2,0,57},
{7711,8,0,32},{0,2,0,36},{7711,2,0,32},{0,2,0,36},{7711,8,0,32},{0,2,0,48},
{7711,2,0,32},{0,2,0,48},{7711,8,0,32},{0,2,0,40},{7711,2,0,32},{0,2,0,40},
{8164,4,0,32},{7711,4,0,32},{7747,8,0,32},{0,2,0,50},{7747,2,0,32},{0,2,0,50},
{7747,8,0,32},{0,2,0,38},{7747,2,0,32},{0,2,0,38},{7747,8,0,32},{0,2,0,44},
{7747,2,0,32},{0,2,0,44},{7747,10,0,32},{0,4,0,273},{7440,10,0,32},{7747,4,0,
32},{0,4,0,273},{7440,4,0,32},{7833,8,0,32},{0,2,0,36},{7833,2,0,32},{0,2,0,36},
{7833,8,0,32},{0,2,0,48},{7833,2,0,32},{0,2,0,48},{7833,8,0,32},{0,2,0,40},
{7833,2,0,32},{0,2,0,40},{7895,8,0,32},{0,2,0,36},{7895,2,0,32},{0,2,0,36},
{7895,8,0,32},{0,2,0,39},{7895,2,0,32},{0,2,0,39},{7895,8,0,32},{0,2,0,48},
{7895,2,0,32},{0,2,0,48},{7895,8,0,32},{0,2,0,40},{7895,2,0,32},{0,2,0,40},
{7931,8,0,32},{0,2,0,48},{7931,2,0,32},{0,2,0,48},{7931,8,0,32},{0,2,0,40},
{7931,2,0,32},{0,2,0,40},{7963,8,0,32},{0,2,0,45},{7963,2,0,32},{0,2,0,45},
{7963,8,0,32},{0,2,0,50},{7963,2,0,32},{0,2,0,50},{7963,8,0,32},{0,2,0,38},
{7963,2,0,32},{0,2,0,38},{7963,8,0,32},{0,2,0,41},{7963,2,0,32},{0,2,0,41},
{7963,8,0,32},{0,2,0,44},{7963,2,0,32},{0,2,0,44},{7963,8,0,32},{0,2,0,49},
{7963,2,0,32},{0,2,0,49},{8027,8,0,32},{0,2,0,39},{8027,2,0,32},{0,2,0,39},
{8049,8,0,32},{0,2,0,39},{8049,2,0,32},{0,2,0,39},{8049,8,0,32},{0,2,0,43},
{8071,8,0,32},{0,2,0,36},{8071,2,0,32},{0,2,0,36},{8071,8,0,32},{0,2,0,46},
{8071,2,0,32},{0,2,0,46},{8071,8,0,32},{0,2,0,40},{8071,2,0,32},{0,2,0,40},
{7895,4,0,32},{0,4,0,274},{8071,4,0,32},{8027,4,0,32},{7747,8,0,32},{0,2,0,63},
{7747,2,0,32},{0,2,0,63},{7963,8,0,32},{0,2,0,63},{7963,2,0,32},{0,2,0,63},
{7931,4,0,32},{7895,4,0,32},{7413,10,0,32},{8071,10,0,32},{0,4,0,40},{7413,10,0,
32},{8071,4,0,32},{0,4,0,40},{7413,4,0,32},{8071,4,0,32},{0,4,0,40},{7645,10,0,
32},{7602,10,0,32},{7645,10,0,32},{7602,4,0,32},{7645,4,0,32},{7602,4,0,32},
{7711,10,0,32},{7602,10,0,32},{7711,10,0,32},{7602,4,0,32},{7711,4,0,32},{7602,
4,0,32},{7341,8,0,32},{0,2,0,40},{7341,2,0,32},{0,2,0,40},{7576,8,0,32},{0,2,0,
40},{7576,2,0,32},{0,2,0,40},{7747,8,0,32},{0,2,0,40},{7747,2,0,32},{0,2,0,40},
{7963,8,0,32},{0,2,0,40},{7963,2,0,32},{0,2,0,40},{7963,8,0,32},{0,2,0,43},{0,2,
0,50},{7963,2,0,32},{0,2,0,43},{0,2,0,50},{7963,8,0,32},{0,2,0,43},{0,2,0,36},
{7963,2,0,32},{0,2,0,43},{0,2,0,36},{7963,8,0,32},{0,2,0,43},{0,2,0,40},{7963,2,
0,32},{0,2,0,43},{0,2,0,40},{7963,8,0,32},{0,2,0,43},{0,2,0,37},{7963,2,0,32},
{0,2,0,43},{0,2,0,37},{7341,8,0,32},{0,2,0,43},{0,2,0,50},{7341,2,0,32},{0,2,0,
43},{0,2,0,50},{7341,8,0,32},{0,2,0,46},{0,2,0,50},{7341,2,0,32},{0,2,0,46},{0,
2,0,50},{7341,10,0,32},{0,4,0,273},{7440,10,0,32},{0,2,0,50},{7341,4,0,32},{0,4,
0,273},{7440,4,0,32},{0,2,0,50},{7514,8,0,32},{0,2,0,40},{7514,2,0,32},{0,2,0,
40},{7627,8,0,32},{0,2,0,40},{7627,2,0,32},{0,2,0,40},{7747,8,0,32},{0,2,0,49},
{7747,2,0,32},{0,2,0,49},{7747,8,0,32},{0,2,0,49},{0,2,0,50},{7747,2,0,32},{0,2,
0,49},{0,2,0,50},{8100,8,0,32},{0,2,0,40},{8100,2,0,32},{0,2,0,40},{7602,2,0,
32},{0,2,0,40},{7413,10,0,32},{8071,10,0,32},{7413,10,0,32},{8071,4,0,32},{7413,
4,0,32},{8071,4,0,32},{7514,8,0,32},{0,2,0,36},{7514,2,0,32},{0,2,0,36},{7711,8,
0,32},{0,2,0,37},{7711,2,0,32},{0,2,0,37},{7341,8,0,32},{0,2,0,41},{0,2,0,36},
{7341,2,0,32},{0,2,0,41},{0,2,0,36},{7341,10,0,32},{0,4,0,273},{7440,10,0,32},
{0,2,0,36},{7341,4,0,32},{0,4,0,273},{7440,4,0,32},{0,2,0,36},{7747,8,0,32},{0,
2,0,47},{0,2,0,36},{7747,2,0,32},{0,2,0,47},{0,2,0,36},{7341,8,0,32},{0,2,0,60},
{7341,2,0,32},{0,2,0,60},{7341,8,0,32},{0,2,0,62},{7341,2,0,32},{0,2,0,62},
{7440,8,0,32},{0,2,0,60},{7440,2,0,32},{0,2,0,60},{7440,8,0,32},{0,2,0,62},
{7440,2,0,32},{0,2,0,62},{7576,8,0,32},{0,2,0,60},{7576,2,0,32},{0,2,0,60},
{7576,8,0,32},{0,2,0,62},{7576,2,0,32},{0,2,0,62},{7747,8,0,32},{0,2,0,60},
{7747,2,0,32},{0,2,0,60},{7747,8,0,32},{0,2,0,62},{7747,2,0,32},{0,2,0,62},
{7833,8,0,32},{0,2,0,60},{7833,2,0,32},{0,2,0,60},{7833,8,0,32},{0,2,0,62},
{7833,2,0,32},{0,2,0,62},{7963,8,0,32},{0,2,0,60},{7963,2,0,32},{0,2,0,60},
{7963,8,0,32},{0,2,0,62},{7963,2,0,32},{0,2,0,62},{7895,8,0,32},{0,2,0,69},
{7895,2,0,32},{0,2,0,69},{7931,8,0,32},{0,2,0,69},{7931,2,0,32},{0,2,0,69},
{7550,8,0,32},{0,2,0,40},{7550,2,0,32},{0,2,0,40},{7341,8,0,32},{0,2,0,46},
{7341,2,0,32},{0,2,0,46},{7440,8,0,32},{0,2,0,48},{7440,2,0,32},{0,2,0,48},
{7747,8,0,32},{0,2,0,43},{0,2,0,50},{7747,2,0,32},{0,2,0,43},{0,2,0,50},{7747,8,
0,32},{0,2,0,45},{0,2,0,50},{7747,2,0,32},{0,2,0,45},{0,2,0,50},{7747,8,0,32},
{0,2,0,46},{7747,2,0,32},{0,2,0,46},{7747,8,0,32},{0,2,0,46},{0,2,0,50},{7747,2,
0,32},{0,2,0,46},{0,2,0,50},{8049,8,0,32},{0,2,0,50},{8049,2,0,32},{0,2,0,50},
{7413,4,0,32},{7366,4,0,32},{7815,4,0,32},{7794,4,0,32},{7413,4,0,32},{8071,4,0,
32},{7413,4,0,32},{8100,4,0,32},{7413,4,0,32},{8090,4,0,32},{7931,4,0,32},{7895,
4,0,32},{7931,4,0,32},{7912,4,0,32},{7931,4,0,32},{7407,4,0,32},{7499,4,0,32},
{7742,4,0,32},{7645,4,0,32},{7895,4,0,32},{7645,4,0,32},{8071,4,0,32},{0,2,0,
43},{0,2,0,36},{1183,2,1,32},{0,2,0,36},{8223,8,0,32},{0,2,0,36},{8228,8,0,32},
{0,2,0,36},{8234,8,0,32},{0,2,0,36},{8236,8,0,32},{0,2,0,36},{8244,8,0,32},{0,2,
0,36},{8258,8,0,32},{0,2,0,36},{8263,8,0,32},{0,2,0,36},{8236,2,0,32},{0,2,0,
43},{0,2,0,36},{8236,8,0,32},{0,2,0,43},{8258,8,0,32},{0,2,0,43},{8223,2,0,32},
{0,2,0,36},{8228,2,0,32},{0,2,0,36},{8234,2,0,32},{0,2,0,36},{8236,2,0,32},{0,2,
0,36},{8258,2,0,32},{0,2,0,43},{0,2,0,36},{8236,2,0,32},{0,2,0,43},{8258,2,0,
32},{0,2,0,43},{8244,2,0,32},{0,2,0,36},{8258,2,0,32},{0,2,0,36},{8263,2,0,32},
{0,2,0,36},{8238,10,0,32},{8223,4,0,32},{8236,4,0,32},{8258,10,0,32},{0,2,0,36},
{8258,10,0,32},{0,2,0,43},{8238,4,0,32},{8223,4,0,32},{8236,4,0,32},{8384,8,0,
32},{0,2,0,37},{8384,8,0,32},{0,2,0,43},{8348,8,0,32},{0,2,0,36},{8430,8,0,32},
{0,2,0,43},{8444,8,0,32},{0,2,0,36},{8422,8,0,32},{0,2,0,37},{8579,8,0,32},{0,2,
0,38},{8384,2,0,32},{0,2,0,37},{8384,2,0,32},{0,2,0,43},{8348,2,0,32},{0,2,0,
36},{8430,2,0,32},{0,2,0,43},{8444,2,0,32},{0,2,0,36},{8422,2,0,32},{0,2,0,37},
{8579,2,0,32},{0,2,0,38},{8765,8,0,32},{0,2,0,60},{8765,2,0,32},{0,2,0,60},
{8348,10,0,32},{0,4,0,274},{8348,4,0,32},{0,4,0,274},{8392,8,0,32},{0,2,0,38},
{8392,2,0,32},{0,2,0,38},{8328,8,0,32},{0,2,0,38},{8328,2,0,32},{0,2,0,38},
{8328,8,0,32},{0,2,0,43},{8328,2,0,32},{0,2,0,43},{8384,8,0,32},{0,2,0,38},
{8384,2,0,32},{0,2,0,38},{8332,8,0,32},{0,2,0,43},{8332,2,0,32},{0,2,0,43},
{8392,8,0,32},{0,2,0,43},{8392,2,0,32},{0,2,0,43},{8402,8,0,32},{0,2,0,43},
{8402,2,0,32},{0,2,0,43},{8422,8,0,32},{0,2,0,50},{8422,2,0,32},{0,2,0,50},
{8422,8,0,32},{0,2,0,43},{8422,2,0,32},{0,2,0,43},{8525,8,0,32},{0,2,0,43},
{8525,2,0,32},{0,2,0,43},{8529,8,0,32},{0,2,0,43},{8529,2,0,32},{0,2,0,43},
{8715,8,0,32},{0,2,0,43},{8715,2,0,32},{0,2,0,43},{8579,8,0,32},{0,2,0,50},
{8579,2,0,32},{0,2,0,50},{8579,8,0,32},{0,2,0,43},{8579,2,0,32},{0,2,0,43},
{8579,8,0,32},{0,2,0,44},{8579,2,0,32},{0,2,0,44},{8650,8,0,32},{0,2,0,43},
{8650,2,0,32},{0,2,0,43},{8698,8,0,32},{0,2,0,43},{8698,2,0,32},{0,2,0,43},
{8954,4,0,32},{8983,4,0,32},{8989,2,0,32},{0,2,0,89},{8989,2,0,32},{0,2,0,90},
{8989,2,0,32},{0,2,0,95},{8990,2,0,32},{0,2,0,95},{8990,2,0,32},{0,2,0,96},
{8991,2,0,32},{0,2,0,95},{8992,2,0,32},{0,2,0,95},{8993,2,0,32},{0,2,0,95},
{8994,2,0,32},{0,2,0,91},{8994,2,0,32},{0,2,0,95},{8995,2,0,32},{0,2,0,95},
{8997,2,0,32},{0,2,0,95},{8998,2,0,32},{0,2,0,86},{8998,2,0,32},{0,2,0,95},
{8999,25,0,32},{0,2,0,95},{8999,2,0,32},{0,2,0,95},{8999,2,0,32},{0,2,0,96},
{9000,2,0,32},{0,2,0,95},{9001,2,0,32},{0,2,0,95},{9002,2,0,32},{0,2,0,95},
{9003,2,0,32},{0,2,0,95},{9005,25,0,32},{0,2,0,95},{9005,2,0,32},{0,2,0,95},
{9005,2,0,32},{0,2,0,96},{9006,2,0,32},{0,2,0,95},{9007,2,0,32},{0,2,0,95},
{9008,2,0,32},{0,2,0,95},{9009,2,0,32},{0,2,0,95},{9009,2,0,32},{0,2,0,95},{0,2,
0,94},{9009,2,0,32},{0,2,0,95},{0,2,0,93},{9009,2,0,32},{0,2,0,94},{9009,2,0,
32},{0,2,0,93},{9010,2,0,32},{0,2,0,95},{8994,4,0,32},{8994,4,0,32},{8994,4,0,
32},{8998,4,0,32},{8998,4,0,32},{8998,4,0,32},{8998,4,0,32},{8998,4,0,32},{0,2,
0,89},{9073,4,0,32},{9059,4,0,32},{9245,4,0,32},{9059,4,0,32},{9249,4,0,32},
{9059,4,0,32},{9260,4,0,32},{9059,4,0,32},{9244,2,0,32},{0,2,0,131},{9241,2,0,
32},{0,2,0,131},{9274,2,0,32},{0,2,0,131},{9059,4,0,32},{0,4,0,274},{9225,4,0,
32},{0,4,0,274},{9279,4,0,32},{0,4,0,274},{9287,4,0,32},{0,4,0,274},{9297,4,0,
32},{0,4,0,274},{9278,4,0,32},{0,4,0,275},{9279,4,0,32},{0,4,0,275},{9281,4,0,
32},{0,4,0,275},{9402,4,0,32},{0,4,0,273},{9403,4,0,32},{0,4,0,273},{9405,4,0,
32},{0,4,0,273},{9959,2,0,32},{0,2,0,194},{9960,2,0,32},{0,2,0,194},{9961,2,0,
32},{0,2,0,194},{9967,2,0,32},{0,2,0,194},{9975,2,0,32},{0,2,0,194},{9977,2,0,
32},{0,2,0,194},{9983,2,0,32},{0,2,0,194},{9985,2,0,32},{0,2,0,194},{9990,2,0,
32},{0,2,0,194},{9992,2,0,32},{0,2,0,194},{9994,2,0,32},{0,2,0,194},{10059,2,0,
32},{0,2,0,194},{10060,2,0,32},{0,2,0,194},{10072,2,0,32},{0,2,0,194},{10062,4,
0,32},{10095,4,0,32},{10115,2,0,32},{0,2,0,194},{10116,2,0,32},{0,2,0,194},
{10121,2,0,32},{0,2,0,194},{10135,2,0,32},{0,2,0,194},{10142,2,0,32},{0,2,0,
194},{10111,2,0,32},{0,2,0,194},{10250,2,0,32},{0,2,0,194},{10251,2,0,32},{0,2,
0,194},{10533,4,0,32},{10561,4,0,32},{10531,4,0,32},{10561,4,0,32},{10532,4,0,
32},{10561,4,0,32},{10541,4,0,32},{10561,4,0,32},{10520,4,0,32},{10561,4,0,32},
{10525,4,0,32},{10561,4,0,32},{10533,4,0,32},{10561,4,0,32},{10534,4,0,32},
{10561,4,0,32},{10540,4,0,32},{10561,4,0,32},{10506,4,0,32},{10561,4,0,32},
{11808,2,0,32},{11866,2,0,32},{11809,2,0,32},{11866,2,0,32},{11810,2,0,32},
{11866,2,0,32},{11811,2,0,32},{11866,2,0,32},{11812,2,0,32},{11866,2,0,32},
{11813,2,0,32},{11866,2,0,32},{11814,2,0,32},{11866,2,0,32},{11815,2,0,32},
{11866,2,0,32},{11816,2,0,32},{11866,2,0,32},{11817,2,0,32},{11866,2,0,32},
{11818,2,0,32},{11866,2,0,32},{11819,2,0,32},{11866,2,0,32},{11820,2,0,32},
{11866,2,0,32},{11821,2,0,32},{11866,2,0,32},{11822,2,0,32},{11866,2,0,32},
{11823,2,0,32},{11866,2,0,32},{11824,2,0,32},{11866,2,0,32},{11825,2,0,32},
{11866,2,0,32},{11826,2,0,32},{11866,2,0,32},{11827,2,0,32},{11866,2,0,32},
{11828,2,0,32},{11866,2,0,32},{11829,2,0,32},{11866,2,0,32},{11830,2,0,32},
{11866,2,0,32},{11831,2,0,32},{11866,2,0,32},{11832,2,0,32},{11866,2,0,32},
{11833,2,0,32},{11866,2,0,32},{11834,2,0,32},{11866,2,0,32},{11835,2,0,32},
{11866,2,0,32},{11836,2,0,32},{11866,2,0,32},{11837,2,0,32},{11866,2,0,32},
{11838,2,0,32},{11866,2,0,32},{11839,2,0,32},{11866,2,0,32},{11840,2,0,32},
{11866,2,0,32},{11841,2,0,32},{11866,2,0,32},{11842,2,0,32},{11866,2,0,32},
{11843,2,0,32},{11866,2,0,32},{11844,2,0,32},{11866,2,0,32},{11845,2,0,32},
{11866,2,0,32},{11846,2,0,32},{11866,2,0,32},{11847,2,0,32},{11866,2,0,32},
{11848,2,0,32},{11866,2,0,32},{11849,2,0,32},{11866,2,0,32},{11850,2,0,32},
{11866,2,0,32},{11851,2,0,32},{11866,2,0,32},{11852,2,0,32},{11866,2,0,32},
{11853,2,0,32},{11866,2,0,32},{11808,2,0,32},{11867,2,0,32},{11809,2,0,32},
{11867,2,0,32},{11810,2,0,32},{11867,2,0,32},{11811,2,0,32},{11867,2,0,32},
{11812,2,0,32},{11867,2,0,32},{11813,2,0,32},{11867,2,0,32},{11814,2,0,32},
{11867,2,0,32},{11815,2,0,32},{11867,2,0,32},{11816,2,0,32},{11867,2,0,32},
{11817,2,0,32},{11867,2,0,32},{11818,2,0,32},{11867,2,0,32},{11819,2,0,32},
{11867,2,0,32},{11820,2,0,32},{11867,2,0,32},{11821,2,0,32},{11867,2,0,32},
{11822,2,0,32},{11867,2,0,32},{11823,2,0,32},{11867,2,0,32},{11824,2,0,32},
{11867,2,0,32},{11825,2,0,32},{11867,2,0,32},{11826,2,0,32},{11867,2,0,32},
{11827,2,0,32},{11867,2,0,32},{11828,2,0,32},{11867,2,0,32},{11829,2,0,32},
{11867,2,0,32},{11830,2,0,32},{11867,2,0,32},{11831,2,0,32},{11867,2,0,32},
{11832,2,0,32},{11867,2,0,32},{11833,2,0,32},{11867,2,0,32},{11834,2,0,32},
{11867,2,0,32},{11835,2,0,32},{11867,2,0,32},{11836,2,0,32},{11867,2,0,32},
{11837,2,0,32},{11867,2,0,32},{11838,2,0,32},{11867,2,0,32},{11839,2,0,32},
{11867,2,0,32},{11840,2,0,32},{11867,2,0,32},{11841,2,0,32},{11867,2,0,32},
{11842,2,0,32},{11867,2,0,32},{11843,2,0,32},{11867,2,0,32},{11844,2,0,32},
{11867,2,0,32},{11845,2,0,32},{11867,2,0,32},{11846,2,0,32},{11867,2,0,32},
{11847,2,0,32},{11867,2,0,32},{11848,2,0,32},{11867,2,0,32},{11849,2,0,32},
{11867,2,0,32},{11850,2,0,32},{11867,2,0,32},{11851,2,0,32},{11867,2,0,32},
{11852,2,0,32},{11867,2,0,32},{11853,2,0,32},{11867,2,0,32},{11808,2,0,32},
{11868,2,0,32},{11809,2,0,32},{11868,2,0,32},{11810,2,0,32},{11868,2,0,32},
{11811,2,0,32},{11868,2,0,32},{11812,2,0,32},{11868,2,0,32},{11813,2,0,32},
{11868,2,0,32},{11814,2,0,32},{11868,2,0,32},{11815,2,0,32},{11868,2,0,32},
{11816,2,0,32},{11868,2,0,32},{11817,2,0,32},{11868,2,0,32},{11818,2,0,32},
{11868,2,0,32},{11819,2,0,32},{11868,2,0,32},{11820,2,0,32},{11868,2,0,32},
{11821,2,0,32},{11868,2,0,32},{11822,2,0,32},{11868,2,0,32},{11823,2,0,32},
{11868,2,0,32},{11824,2,0,32},{11868,2,0,32},{11825,2,0,32},{11868,2,0,32},
{11826,2,0,32},{11868,2,0,32},{11827,2,0,32},{11868,2,0,32},{11828,2,0,32},
{11868,2,0,32},{11829,2,0,32},{11868,2,0,32},{11830,2,0,32},{11868,2,0,32},
{11831,2,0,32},{11868,2,0,32},{11832,2,0,32},{11868,2,0,32},{11833,2,0,32},
{11868,2,0,32},{11834,2,0,32},{11868,2,0,32},{11835,2,0,32},{11868,2,0,32},
{11836,2,0,32},{11868,2,0,32},{11837,2,0,32},{11868,2,0,32},{11838,2,0,32},
{11868,2,0,32},{11839,2,0,32},{11868,2,0,32},{11840,2,0,32},{11868,2,0,32},
{11841,2,0,32},{11868,2,0,32},{11842,2,0,32},{11868,2,0,32},{11843,2,0,32},
{11868,2,0,32},{11844,2,0,32},{11868,2,0,32},{11845,2,0,32},{11868,2,0,32},
{11846,2,0,32},{11868,2,0,32},{11847,2,0,32},{11868,2,0,32},{11848,2,0,32},
{11868,2,0,32},{11849,2,0,32},{11868,2,0,32},{11850,2,0,32},{11868,2,0,32},
{11851,2,0,32},{11868,2,0,32},{11852,2,0,32},{11868,2,0,32},{11853,2,0,32},
{11868,2,0,32},{11808,2,0,32},{11869,2,0,32},{11809,2,0,32},{11869,2,0,32},
{11810,2,0,32},{11869,2,0,32},{11811,2,0,32},{11869,2,0,32},{11812,2,0,32},
{11869,2,0,32},{11813,2,0,32},{11869,2,0,32},{11814,2,0,32},{11869,2,0,32},
{11815,2,0,32},{11869,2,0,32},{11816,2,0,32},{11869,2,0,32},{11817,2,0,32},
{11869,2,0,32},{11818,2,0,32},{11869,2,0,32},{11819,2,0,32},{11869,2,0,32},
{11820,2,0,32},{11869,2,0,32},{11821,2,0,32},{11869,2,0,32},{11822,2,0,32},
{11869,2,0,32},{11823,2,0,32},{11869,2,0,32},{11824,2,0,32},{11869,2,0,32},
{11825,2,0,32},{11869,2,0,32},{11826,2,0,32},{11869,2,0,32},{11827,2,0,32},
{11869,2,0,32},{11828,2,0,32},{11869,2,0,32},{11829,2,0,32},{11869,2,0,32},
{11830,2,0,32},{11869,2,0,32},{11831,2,0,32},{11869,2,0,32},{11832,2,0,32},
{11869,2,0,32},{11833,2,0,32},{11869,2,0,32},{11834,2,0,32},{11869,2,0,32},
{11835,2,0,32},{11869,2,0,32},{11836,2,0,32},{11869,2,0,32},{11837,2,0,32},
{11869,2,0,32},{11838,2,0,32},{11869,2,0,32},{11839,2,0,32},{11869,2,0,32},
{11840,2,0,32},{11869,2,0,32},{11841,2,0,32},{11869,2,0,32},{11842,2,0,32},
{11869,2,0,32},{11843,2,0,32},{11869,2,0,32},{11844,2,0,32},{11869,2,0,32},
{11845,2,0,32},{11869,2,0,32},{11846,2,0,32},{11869,2,0,32},{11847,2,0,32},
{11869,2,0,32},{11848,2,0,32},{11869,2,0,32},{11849,2,0,32},{11869,2,0,32},
{11850,2,0,32},{11869,2,0,32},{11851,2,0,32},{11869,2,0,32},{11852,2,0,32},
{11869,2,0,32},{11853,2,0,32},{11869,2,0,32},{11808,2,0,32},{11870,2,0,32},
{11809,2,0,32},{11870,2,0,32},{11810,2,0,32},{11870,2,0,32},{11811,2,0,32},
{11870,2,0,32},{11812,2,0,32},{11870,2,0,32},{11813,2,0,32},{11870,2,0,32},
{11814,2,0,32},{11870,2,0,32},{11815,2,0,32},{11870,2,0,32},{11816,2,0,32},
{11870,2,0,32},{11817,2,0,32},{11870,2,0,32},{11818,2,0,32},{11870,2,0,32},
{11819,2,0,32},{11870,2,0,32},{11820,2,0,32},{11870,2,0,32},{11821,2,0,32},
{11870,2,0,32},{11822,2,0,32},{11870,2,0,32},{11823,2,0,32},{11870,2,0,32},
{11824,2,0,32},{11870,2,0,32},{11825,2,0,32},{11870,2,0,32},{11826,2,0,32},
{11870,2,0,32},{11827,2,0,32},{11870,2,0,32},{11828,2,0,32},{11870,2,0,32},
{11829,2,0,32},{11870,2,0,32},{11830,2,0,32},{11870,2,0,32},{11831,2,0,32},
{11870,2,0,32},{11832,2,0,32},{11870,2,0,32},{11833,2,0,32},{11870,2,0,32},
{11834,2,0,32},{11870,2,0,32},{11835,2,0,32},{11870,2,0,32},{11836,2,0,32},
{11870,2,0,32},{11837,2,0,32},{11870,2,0,32},{11838,2,0,32},{11870,2,0,32},
{11839,2,0,32},{11870,2,0,32},{11840,2,0,32},{11870,2,0,32},{11841,2,0,32},
{11870,2,0,32},{11842,2,0,32},{11870,2,0,32},{11843,2,0,32},{11870,2,0,32},
{11844,2,0,32},{11870,2,0,32},{11845,2,0,32},{11870,2,0,32},{11846,2,0,32},
{11870,2,0,32},{11847,2,0,32},{11870,2,0,32},{11848,2,0,32},{11870,2,0,32},
{11849,2,0,32},{11870,2,0,32},{11850,2,0,32},{11870,2,0,32},{11851,2,0,32},
{11870,2,0,32},{11852,2,0,32},{11870,2,0,32},{11853,2,0,32},{11870,2,0,32},
{11858,2,0,32},{11873,2,0,32},{11915,2,0,32},{11874,2,0,32},{11915,2,0,32},
{11875,2,0,32},{11915,2,0,32},{11876,2,0,32},{11915,2,0,32},{11877,2,0,32},
{11915,2,0,32},{11879,2,0,32},{11915,2,0,32},{11881,2,0,32},{11915,2,0,32},
{11882,2,0,32},{11915,2,0,32},{11883,2,0,32},{11915,2,0,32},{11884,2,0,32},
{11915,2,0,32},{11885,2,0,32},{11915,2,0,32},{11886,2,0,32},{11915,2,0,32},
{11887,2,0,32},{11915,2,0,32},{11888,2,0,32},{11915,2,0,32},{11889,2,0,32},
{11915,2,0,32},{11890,2,0,32},{11915,2,0,32},{11891,2,0,32},{11915,2,0,32},
{11892,2,0,32},{11915,2,0,32},{11893,2,0,32},{11915,2,0,32},{11894,2,0,32},
{11915,2,0,32},{11895,2,0,32},{11915,2,0,32},{11896,2,0,32},{11915,2,0,32},
{11897,2,0,32},{11915,2,0,32},{11878,2,0,32},{11915,2,0,32},{11898,2,0,32},
{11915,2,0,32},{11899,2,0,32},{11915,2,0,32},{11900,2,0,32},{11915,2,0,32},
{11898,4,0,32},{11886,4,0,32},{11915,2,0,32},{11898,4,0,32},{11893,4,0,32},
{11915,2,0,32},{11872,2,0,32},{11915,2,0,32},{11880,2,0,32},{11915,2,0,32},
{11873,2,0,32},{11916,2,0,32},{11874,2,0,32},{11916,2,0,32},{11875,2,0,32},
{11916,2,0,32},{11876,2,0,32},{11916,2,0,32},{11877,2,0,32},{11916,2,0,32},
{11879,2,0,32},{11916,2,0,32},{11881,2,0,32},{11916,2,0,32},{11882,2,0,32},
{11916,2,0,32},{11883,2,0,32},{11916,2,0,32},{11884,2,0,32},{11916,2,0,32},
{11885,2,0,32},{11916,2,0,32},{11886,2,0,32},{11916,2,0,32},{11887,2,0,32},
{11916,2,0,32},{11888,2,0,32},{11916,2,0,32},{11889,2,0,32},{11916,2,0,32},
{11890,2,0,32},{11916,2,0,32},{11891,2,0,32},{11916,2,0,32},{11892,2,0,32},
{11916,2,0,32},{11893,2,0,32},{11916,2,0,32},{11894,2,0,32},{11916,2,0,32},
{11895,2,0,32},{11916,2,0,32},{11896,2,0,32},{11916,2,0,32},{11897,2,0,32},
{11916,2,0,32},{11878,2,0,32},{11916,2,0,32},{11898,2,0,32},{11916,2,0,32},
{11899,2,0,32},{11916,2,0,32},{11900,2,0,32},{11916,2,0,32},{11898,4,0,32},
{11886,4,0,32},{11916,2,0,32},{11898,4,0,32},{11893,4,0,32},{11916,2,0,32},
{11872,2,0,32},{11916,2,0,32},{11880,2,0,32},{11916,2,0,32},{11873,2,0,32},
{11917,2,0,32},{11874,2,0,32},{11917,2,0,32},{11875,2,0,32},{11917,2,0,32},
{11876,2,0,32},{11917,2,0,32},{11877,2,0,32},{11917,2,0,32},{11879,2,0,32},
{11917,2,0,32},{11881,2,0,32},{11917,2,0,32},{11882,2,0,32},{11917,2,0,32},
{11883,2,0,32},{11917,2,0,32},{11884,2,0,32},{11917,2,0,32},{11885,2,0,32},
{11917,2,0,32},{11886,2,0,32},{11917,2,0,32},{11887,2,0,32},{11917,2,0,32},
{11888,2,0,32},{11917,2,0,32},{11889,2,0,32},{11917,2,0,32},{11890,2,0,32},
{11917,2,0,32},{11891,2,0,32},{11917,2,0,32},{11892,2,0,32},{11917,2,0,32},
{11893,2,0,32},{11917,2,0,32},{11894,2,0,32},{11917,2,0,32},{11895,2,0,32},
{11917,2,0,32},{11896,2,0,32},{11917,2,0,32},{11897,2,0,32},{11917,2,0,32},
{11878,2,0,32},{11917,2,0,32},{11898,2,0,32},{11917,2,0,32},{11899,2,0,32},
{11917,2,0,32},{11900,2,0,32},{11917,2,0,32},{11898,4,0,32},{11886,4,0,32},
{11917,2,0,32},{11898,4,0,32},{11893,4,0,32},{11917,2,0,32},{11872,2,0,32},
{11917,2,0,32},{11880,2,0,32},{11917,2,0,32},{11873,2,0,32},{11918,2,0,32},
{11874,2,0,32},{11918,2,0,32},{11875,2,0,32},{11918,2,0,32},{11876,2,0,32},
{11918,2,0,32},{11877,2,0,32},{11918,2,0,32},{11879,2,0,32},{11918,2,0,32},
{11881,2,0,32},{11918,2,0,32},{11882,2,0,32},{11918,2,0,32},{11883,2,0,32},
{11918,2,0,32},{11884,2,0,32},{11918,2,0,32},{11885,2,0,32},{11918,2,0,32},
{11886,2,0,32},{11918,2,0,32},{11887,2,0,32},{11918,2,0,32},{11888,2,0,32},
{11918,2,0,32},{11889,2,0,32},{11918,2,0,32},{11890,2,0,32},{11918,2,0,32},
{11891,2,0,32},{11918,2,0,32},{11892,2,0,32},{11918,2,0,32},{11893,2,0,32},
{11918,2,0,32},{11894,2,0,32},{11918,2,0,32},{11895,2,0,32},{11918,2,0,32},
{11896,2,0,32},{11918,2,0,32},{11897,2,0,32},{11918,2,0,32},{11878,2,0,32},
{11918,2,0,32},{11898,2,0,32},{11918,2,0,32},{11899,2,0,32},{11918,2,0,32},
{11900,2,0,32},{11918,2,0,32},{11898,4,0,32},{11886,4,0,32},{11918,2,0,32},
{11898,4,0,32},{11893,4,0,32},{11918,2,0,32},{11872,2,0,32},{11918,2,0,32},
{11880,2,0,32},{11918,2,0,32},{11873,2,0,32},{11919,2,0,32},{11874,2,0,32},
{11919,2,0,32},{11875,2,0,32},{11919,2,0,32},{11876,2,0,32},{11919,2,0,32},
{11877,2,0,32},{11919,2,0,32},{11879,2,0,32},{11919,2,0,32},{11881,2,0,32},
{11919,2,0,32},{11882,2,0,32},{11919,2,0,32},{11883,2,0,32},{11919,2,0,32},
{11884,2,0,32},{11919,2,0,32},{11885,2,0,32},{11919,2,0,32},{11886,2,0,32},
{11919,2,0,32},{11887,2,0,32},{11919,2,0,32},{11888,2,0,32},{11919,2,0,32},
{11889,2,0,32},{11919,2,0,32},{11890,2,0,32},{11919,2,0,32},{11891,2,0,32},
{11919,2,0,32},{11892,2,0,32},{11919,2,0,32},{11893,2,0,32},{11919,2,0,32},
{11894,2,0,32},{11919,2,0,32},{11895,2,0,32},{11919,2,0,32},{11896,2,0,32},
{11919,2,0,32},{11897,2,0,32},{11919,2,0,32},{11878,2,0,32},{11919,2,0,32},
{11898,2,0,32},{11919,2,0,32},{11899,2,0,32},{11919,2,0,32},{11900,2,0,32},
{11919,2,0,32},{11898,4,0,32},{11886,4,0,32},{11919,2,0,32},{11898,4,0,32},
{11893,4,0,32},{11919,2,0,32},{11872,2,0,32},{11919,2,0,32},{11880,2,0,32},
{11919,2,0,32},{11905,2,0,32},{11898,4,0,32},{11886,4,0,32},{11898,4,0,32},
{11893,4,0,32},{12057,4,0,32},{12080,4,0,32},{0,4,0,196},{11987,2,0,32},{12052,
2,0,32},{11992,2,0,32},{12056,2,0,32},{12008,2,0,32},{12056,2,0,32},{12016,2,0,
32},{12056,2,0,32},{12024,2,0,32},{12056,2,0,32},{12032,2,0,32},{12056,2,0,32},
{12044,4,0,32},{0,4,0,274},{12069,2,0,32},{12073,2,0,32},{12071,2,0,32},{11988,
2,0,32},{12052,2,0,32},{11993,2,0,32},{12056,2,0,32},{12009,2,0,32},{12056,2,0,
32},{12017,2,0,32},{12056,2,0,32},{12025,2,0,32},{12056,2,0,32},{12033,2,0,32},
{12056,2,0,32},{12075,2,0,32},{12074,2,0,32},{12077,2,0,32},{12076,2,0,32},
{12035,4,0,32},{0,4,0,274},{12043,4,0,32},{0,4,0,274},{12045,4,0,32},{0,4,0,
274},{12713,4,0,32},{12770,4,0,32},{12713,4,0,32},{14317,4,0,32},{0,4,0,273},
{14318,4,0,32},{0,4,0,273},{14318,4,0,32},{0,4,0,274},{14319,4,0,32},{0,4,0,
273},{14320,4,0,32},{0,4,0,273},{14320,4,0,32},{0,4,0,274},{14320,4,0,32},{0,4,
0,275},{14320,4,0,32},{0,4,0,276},{14325,4,0,32},{0,4,0,273},{14325,4,0,32},{0,
4,0,274},{14325,4,0,32},{0,4,0,275},{14325,4,0,32},{0,4,0,276},{14329,4,0,32},
{0,4,0,273},{14329,4,0,32},{0,4,0,274},{14329,4,0,32},{0,4,0,275},{14330,4,0,
32},{0,4,0,273},{14330,4,0,32},{0,4,0,274},{14331,4,0,32},{0,4,0,273},{14333,4,
0,32},{0,4,0,273},{14334,4,0,32},{0,4,0,273},{14338,4,0,32},{0,4,0,273},{14338,
4,0,32},{0,4,0,275},{14338,4,0,32},{0,4,0,276},{14338,4,0,32},{0,4,0,277},
{14340,4,0,32},{0,4,0,273},{14340,4,0,32},{0,4,0,274},{14341,4,0,32},{0,4,0,
273},{14341,4,0,32},{0,4,0,274},{14336,4,0,32},{0,4,0,273},{14344,4,0,32},{0,4,
0,273},{14344,4,0,32},{0,4,0,274},{14345,4,0,32},{0,4,0,273},{14346,4,0,32},{0,
4,0,273},{14362,4,0,32},{0,4,0,273},{14362,4,0,32},{0,4,0,274},{14328,4,0,32},
{0,4,0,273},{14338,4,0,32},{0,4,0,274},{14334,4,0,32},{14345,4,0,32},{14344,4,0,
32},{0,4,0,273},{14344,4,0,32},{0,4,0,273},{14319,4,0,32},{14319,4,0,32},{12371,
4,0,32},{12401,4,0,32},{12374,4,0,32},{12402,4,0,32},{12950,2,0,32},{12999,2,0,
32},{12951,2,0,32},{12999,2,0,32},{12952,2,0,32},{12999,2,0,32},{12953,2,0,32},
{12999,2,0,32},{12954,2,0,32},{12999,2,0,32},{12955,2,0,32},{12999,2,0,32},
{12956,2,0,32},{12999,2,0,32},{12957,2,0,32},{12999,2,0,32},{12958,2,0,32},
{12999,2,0,32},{12959,2,0,32},{12999,2,0,32},{12960,2,0,32},{12999,2,0,32},
{12961,2,0,32},{12999,2,0,32},{12962,2,0,32},{12999,2,0,32},{12963,2,0,32},
{12999,2,0,32},{12964,2,0,32},{12999,2,0,32},{12965,2,0,32},{12999,2,0,32},
{12966,2,0,32},{12999,2,0,32},{12967,2,0,32},{12999,2,0,32},{12968,2,0,32},
{12999,2,0,32},{12969,2,0,32},{12999,2,0,32},{12970,2,0,32},{12999,2,0,32},
{12971,2,0,32},{12999,2,0,32},{12972,2,0,32},{12999,2,0,32},{12973,2,0,32},
{12999,2,0,32},{12974,2,0,32},{12999,2,0,32},{12975,2,0,32},{12999,2,0,32},
{12976,2,0,32},{12999,2,0,32},{12977,2,0,32},{12999,2,0,32},{12978,2,0,32},
{12999,2,0,32},{12979,2,0,32},{12999,2,0,32},{12980,2,0,32},{12999,2,0,32},
{12981,2,0,32},{12999,2,0,32},{12982,2,0,32},{12999,2,0,32},{12983,2,0,32},
{12999,2,0,32},{12984,2,0,32},{12999,2,0,32},{12985,2,0,32},{12999,2,0,32},
{12986,2,0,32},{12999,2,0,32},{12987,2,0,32},{12999,2,0,32},{12988,2,0,32},
{12999,2,0,32},{12989,2,0,32},{12999,2,0,32},{12990,2,0,32},{12999,2,0,32},
{12991,2,0,32},{12999,2,0,32},{12992,2,0,32},{12999,2,0,32},{12993,2,0,32},
{12999,2,0,32},{12950,2,0,32},{13000,2,0,32},{12951,2,0,32},{13000,2,0,32},
{12952,2,0,32},{13000,2,0,32},{12953,2,0,32},{13000,2,0,32},{12954,2,0,32},
{13000,2,0,32},{12955,2,0,32},{13000,2,0,32},{12956,2,0,32},{13000,2,0,32},
{12957,2,0,32},{13000,2,0,32},{12958,2,0,32},{13000,2,0,32},{12959,2,0,32},
{13000,2,0,32},{12960,2,0,32},{13000,2,0,32},{12961,2,0,32},{13000,2,0,32},
{12962,2,0,32},{13000,2,0,32},{12963,2,0,32},{13000,2,0,32},{12964,2,0,32},
{13000,2,0,32},{12965,2,0,32},{13000,2,0,32},{12966,2,0,32},{13000,2,0,32},
{12967,2,0,32},{13000,2,0,32},{12968,2,0,32},{13000,2,0,32},{12969,2,0,32},
{13000,2,0,32},{12970,2,0,32},{13000,2,0,32},{12971,2,0,32},{13000,2,0,32},
{12972,2,0,32},{13000,2,0,32},{12973,2,0,32},{13000,2,0,32},{12974,2,0,32},
{13000,2,0,32},{12975,2,0,32},{13000,2,0,32},{12976,2,0,32},{13000,2,0,32},
{12977,2,0,32},{13000,2,0,32},{12978,2,0,32},{13000,2,0,32},{12979,2,0,32},
{13000,2,0,32},{12980,2,0,32},{13000,2,0,32},{12981,2,0,32},{13000,2,0,32},
{12982,2,0,32},{13000,2,0,32},{12983,2,0,32},{13000,2,0,32},{12984,2,0,32},
{13000,2,0,32},{12985,2,0,32},{13000,2,0,32},{12986,2,0,32},{13000,2,0,32},
{12987,2,0,32},{13000,2,0,32},{12988,2,0,32},{13000,2,0,32},{12989,2,0,32},
{13000,2,0,32},{12990,2,0,32},{13000,2,0,32},{12991,2,0,32},{13000,2,0,32},
{12992,2,0,32},{13000,2,0,32},{12993,2,0,32},{13000,2,0,32},{12950,2,0,32},
{13001,2,0,32},{12951,2,0,32},{13001,2,0,32},{12952,2,0,32},{13001,2,0,32},
{12953,2,0,32},{13001,2,0,32},{12954,2,0,32},{13001,2,0,32},{12955,2,0,32},
{13001,2,0,32},{12956,2,0,32},{13001,2,0,32},{12957,2,0,32},{13001,2,0,32},
{12958,2,0,32},{13001,2,0,32},{12959,2,0,32},{13001,2,0,32},{12960,2,0,32},
{13001,2,0,32},{12961,2,0,32},{13001,2,0,32},{12962,2,0,32},{13001,2,0,32},
{12963,2,0,32},{13001,2,0,32},{12964,2,0,32},{13001,2,0,32},{12965,2,0,32},
{13001,2,0,32},{12966,2,0,32},{13001,2,0,32},{12967,2,0,32},{13001,2,0,32},
{12968,2,0,32},{13001,2,0,32},{12969,2,0,32},{13001,2,0,32},{12970,2,0,32},
{13001,2,0,32},{12971,2,0,32},{13001,2,0,32},{12972,2,0,32},{13001,2,0,32},
{12973,2,0,32},{13001,2,0,32},{12974,2,0,32},{13001,2,0,32},{12975,2,0,32},
{13001,2,0,32},{12976,2,0,32},{13001,2,0,32},{12977,2,0,32},{13001,2,0,32},
{12978,2,0,32},{13001,2,0,32},{12979,2,0,32},{13001,2,0,32},{12980,2,0,32},
{13001,2,0,32},{12981,2,0,32},{13001,2,0,32},{12982,2,0,32},{13001,2,0,32},
{12983,2,0,32},{13001,2,0,32},{12984,2,0,32},{13001,2,0,32},{12985,2,0,32},
{13001,2,0,32},{12986,2,0,32},{13001,2,0,32},{12987,2,0,32},{13001,2,0,32},
{12988,2,0,32},{13001,2,0,32},{12989,2,0,32},{13001,2,0,32},{12990,2,0,32},
{13001,2,0,32},{12991,2,0,32},{13001,2,0,32},{12992,2,0,32},{13001,2,0,32},
{12993,2,0,32},{13001,2,0,32},{12950,2,0,32},{13004,2,0,32},{12951,2,0,32},
{13004,2,0,32},{12952,2,0,32},{13004,2,0,32},{12953,2,0,32},{13004,2,0,32},
{12954,2,0,32},{13004,2,0,32},{12955,2,0,32},{13004,2,0,32},{12956,2,0,32},
{13004,2,0,32},{12957,2,0,32},{13004,2,0,32},{12958,2,0,32},{13004,2,0,32},
{12959,2,0,32},{13004,2,0,32},{12960,2,0,32},{13004,2,0,32},{12961,2,0,32},
{13004,2,0,32},{12962,2,0,32},{13004,2,0,32},{12963,2,0,32},{13004,2,0,32},
{12964,2,0,32},{13004,2,0,32},{12965,2,0,32},{13004,2,0,32},{12966,2,0,32},
{13004,2,0,32},{12967,2,0,32},{13004,2,0,32},{12968,2,0,32},{13004,2,0,32},
{12969,2,0,32},{13004,2,0,32},{12970,2,0,32},{13004,2,0,32},{12971,2,0,32},
{13004,2,0,32},{12972,2,0,32},{13004,2,0,32},{12973,2,0,32},{13004,2,0,32},
{12974,2,0,32},{13004,2,0,32},{12975,2,0,32},{13004,2,0,32},{12976,2,0,32},
{13004,2,0,32},{12977,2,0,32},{13004,2,0,32},{12978,2,0,32},{13004,2,0,32},
{12979,2,0,32},{13004,2,0,32},{12980,2,0,32},{13004,2,0,32},{12981,2,0,32},
{13004,2,0,32},{12982,2,0,32},{13004,2,0,32},{12983,2,0,32},{13004,2,0,32},
{12984,2,0,32},{13004,2,0,32},{12985,2,0,32},{13004,2,0,32},{12986,2,0,32},
{13004,2,0,32},{12987,2,0,32},{13004,2,0,32},{12988,2,0,32},{13004,2,0,32},
{12989,2,0,32},{13004,2,0,32},{12990,2,0,32},{13004,2,0,32},{12991,2,0,32},
{13004,2,0,32},{12992,2,0,32},{13004,2,0,32},{12993,2,0,32},{13004,2,0,32},
{12978,4,0,32},{13000,4,0,32},{12978,4,0,32},{13000,4,0,32},{13011,4,0,32},
{13058,4,0,32},{13096,4,0,32},{13058,4,0,32},{7341,20,0,32},{0,20,0,273},{7440,
20,0,32},{7514,4,0,32},{0,4,0,274},{7931,4,0,32},{0,4,0,273},{7550,4,0,32},
{7413,20,0,32},{0,20,0,273},{7341,4,0,32},{0,4,0,273},{7341,4,0,32},{0,4,0,273},
{7440,4,0,32},{7341,4,0,32},{7747,4,0,32},{7341,4,0,32},{8009,4,0,32},{7392,4,0,
32},{0,4,0,48},{7413,4,0,32},{0,4,0,274},{7413,4,0,32},{0,4,0,273},{7895,4,0,
32},{0,4,0,274},{7747,4,0,32},{0,4,0,52},{7963,4,0,32},{0,4,0,52},{7341,4,0,32},
{0,4,0,43},{7747,4,0,32},{0,4,0,43},{7963,4,0,32},{0,4,0,43},{7341,8,0,32},{0,2,
0,68},{7341,2,0,32},{0,2,0,68},{7366,8,0,32},{0,2,0,46},{7366,2,0,32},{0,2,0,
46},{7366,8,0,32},{0,2,0,66},{7366,2,0,32},{0,2,0,66},{7366,8,0,32},{0,2,0,73},
{7366,2,0,32},{0,2,0,73},{7392,8,0,32},{0,2,0,48},{0,2,0,36},{7392,2,0,32},{0,2,
0,48},{0,2,0,36},{7413,8,0,32},{0,2,0,46},{7413,2,0,32},{0,2,0,46},{7413,8,0,
32},{0,2,0,66},{7413,2,0,32},{0,2,0,66},{7413,8,0,32},{0,2,0,73},{7413,2,0,32},
{0,2,0,73},{7413,8,0,32},{0,2,0,48},{7413,2,0,32},{0,2,0,48},{7413,8,0,32},{0,2,
0,70},{7413,2,0,32},{0,2,0,70},{7440,8,0,32},{0,2,0,50},{0,2,0,37},{7440,2,0,
32},{0,2,0,50},{0,2,0,37},{7440,8,0,32},{0,2,0,50},{0,2,0,36},{7440,2,0,32},{0,
2,0,50},{0,2,0,36},{7440,8,0,32},{0,2,0,70},{7440,2,0,32},{0,2,0,70},{7440,8,0,
32},{0,2,0,72},{7440,2,0,32},{0,2,0,72},{7440,8,0,32},{0,2,0,48},{0,2,0,38},
{7440,2,0,32},{0,2,0,48},{0,2,0,38},{7499,8,0,32},{0,2,0,46},{7499,2,0,32},{0,2,
0,46},{7514,8,0,32},{0,2,0,50},{7514,2,0,32},{0,2,0,50},{7550,8,0,32},{0,2,0,
46},{7550,2,0,32},{0,2,0,46},{7550,8,0,32},{0,2,0,66},{7550,2,0,32},{0,2,0,66},
{7550,8,0,32},{0,2,0,43},{7550,2,0,32},{0,2,0,43},{7550,8,0,32},{0,2,0,48},
{7550,2,0,32},{0,2,0,48},{7550,8,0,32},{0,2,0,71},{7550,2,0,32},{0,2,0,71},
{7576,8,0,32},{0,2,0,72},{7576,2,0,32},{0,2,0,72},{7576,8,0,32},{0,2,0,43},{0,2,
0,36},{7576,2,0,32},{0,2,0,43},{0,2,0,36},{7627,8,0,32},{0,2,0,36},{7627,2,0,
32},{0,2,0,36},{7627,8,0,32},{0,2,0,66},{7627,2,0,32},{0,2,0,66},{7627,8,0,32},
{0,2,0,73},{7627,2,0,32},{0,2,0,73},{7645,8,0,32},{0,2,0,66},{7645,2,0,32},{0,2,
0,66},{7645,8,0,32},{0,2,0,66},{0,2,0,50},{7645,2,0,32},{0,2,0,66},{0,2,0,50},
{7645,8,0,32},{0,2,0,73},{7645,2,0,32},{0,2,0,73},{7645,8,0,32},{0,2,0,70},
{7645,2,0,32},{0,2,0,70},{7696,8,0,32},{0,2,0,36},{7696,2,0,32},{0,2,0,36},
{7696,8,0,32},{0,2,0,46},{7696,2,0,32},{0,2,0,46},{7696,8,0,32},{0,2,0,66},
{7696,2,0,32},{0,2,0,66},{7711,8,0,32},{0,2,0,46},{7711,2,0,32},{0,2,0,46},
{7711,8,0,32},{0,2,0,66},{7711,2,0,32},{0,2,0,66},{7711,8,0,32},{0,2,0,73},
{7711,2,0,32},{0,2,0,73},{7711,8,0,32},{0,2,0,70},{7711,2,0,32},{0,2,0,70},
{7747,8,0,32},{0,2,0,45},{0,2,0,36},{7747,2,0,32},{0,2,0,45},{0,2,0,36},{7747,8,
0,32},{0,2,0,45},{0,2,0,43},{7747,2,0,32},{0,2,0,45},{0,2,0,43},{7747,8,0,32},
{0,2,0,50},{0,2,0,37},{7747,2,0,32},{0,2,0,50},{0,2,0,37},{7747,8,0,32},{0,2,0,
50},{0,2,0,36},{7747,2,0,32},{0,2,0,50},{0,2,0,36},{7794,8,0,32},{0,2,0,36},
{7794,2,0,32},{0,2,0,36},{7794,8,0,32},{0,2,0,46},{7794,2,0,32},{0,2,0,46},
{7833,8,0,32},{0,2,0,46},{7833,2,0,32},{0,2,0,46},{7833,8,0,32},{0,2,0,66},
{7833,2,0,32},{0,2,0,66},{7833,8,0,32},{0,2,0,66},{0,2,0,50},{7833,2,0,32},{0,2,
0,66},{0,2,0,50},{7833,8,0,32},{0,2,0,73},{7833,2,0,32},{0,2,0,73},{7895,8,0,
32},{0,2,0,46},{7895,2,0,32},{0,2,0,46},{7895,8,0,32},{0,2,0,66},{7895,2,0,32},
{0,2,0,66},{7895,8,0,32},{0,2,0,36},{0,2,0,46},{7895,2,0,32},{0,2,0,36},{0,2,0,
46},{7895,8,0,32},{0,2,0,40},{0,2,0,46},{7895,2,0,32},{0,2,0,40},{0,2,0,46},
{7895,8,0,32},{0,2,0,66},{0,2,0,46},{7895,2,0,32},{0,2,0,66},{0,2,0,46},{7931,8,
0,32},{0,2,0,46},{7931,2,0,32},{0,2,0,46},{7931,8,0,32},{0,2,0,66},{7931,2,0,
32},{0,2,0,66},{7931,8,0,32},{0,2,0,73},{7931,2,0,32},{0,2,0,73},{7931,8,0,32},
{0,2,0,70},{7931,2,0,32},{0,2,0,70},{7963,8,0,32},{0,2,0,67},{7963,2,0,32},{0,2,
0,67},{7963,8,0,32},{0,2,0,72},{7963,2,0,32},{0,2,0,72},{7963,8,0,32},{0,2,0,
70},{7963,2,0,32},{0,2,0,70},{7963,8,0,32},{0,2,0,45},{0,2,0,36},{7963,2,0,32},
{0,2,0,45},{0,2,0,36},{7963,8,0,32},{0,2,0,50},{0,2,0,43},{7963,2,0,32},{0,2,0,
50},{0,2,0,43},{8009,8,0,32},{0,2,0,45},{8009,2,0,32},{0,2,0,45},{8009,8,0,32},
{0,2,0,66},{8009,2,0,32},{0,2,0,66},{8027,8,0,32},{0,2,0,37},{8027,2,0,32},{0,2,
0,37},{8027,8,0,32},{0,2,0,36},{8027,2,0,32},{0,2,0,36},{8027,8,0,32},{0,2,0,
43},{8027,2,0,32},{0,2,0,43},{8027,8,0,32},{0,2,0,46},{8027,2,0,32},{0,2,0,46},
{8027,8,0,32},{0,2,0,66},{8027,2,0,32},{0,2,0,66},{8037,8,0,32},{0,2,0,46},
{8037,2,0,32},{0,2,0,46},{8037,8,0,32},{0,2,0,43},{8037,2,0,32},{0,2,0,43},
{8049,8,0,32},{0,2,0,46},{8049,2,0,32},{0,2,0,46},{8071,8,0,32},{0,2,0,39},
{8071,2,0,32},{0,2,0,39},{8071,8,0,32},{0,2,0,66},{8071,2,0,32},{0,2,0,66},
{8071,8,0,32},{0,2,0,73},{8071,2,0,32},{0,2,0,73},{7550,2,0,32},{0,2,0,73},
{7931,2,0,32},{0,2,0,43},{8027,2,0,32},{0,2,0,41},{8049,2,0,32},{0,2,0,41},
{7341,4,0,32},{8166,4,0,32},{7895,4,0,32},{0,4,0,274},{0,2,0,46},{7895,10,0,32},
{0,4,0,273},{7895,10,0,32},{7341,8,0,32},{0,2,0,66},{7341,2,0,32},{0,2,0,66},
{7341,8,0,32},{0,2,0,59},{7341,2,0,32},{0,2,0,59},{7341,8,0,32},{0,2,0,39},{0,2,
0,36},{7341,2,0,32},{0,2,0,39},{0,2,0,36},{7341,8,0,32},{0,2,0,39},{0,2,0,37},
{7341,2,0,32},{0,2,0,39},{0,2,0,37},{7341,8,0,32},{0,2,0,39},{0,2,0,59},{7341,2,
0,32},{0,2,0,39},{0,2,0,59},{7341,8,0,32},{0,2,0,39},{0,2,0,45},{7341,2,0,32},
{0,2,0,39},{0,2,0,45},{7341,8,0,32},{0,2,0,66},{0,2,0,39},{7341,2,0,32},{0,2,0,
66},{0,2,0,39},{7341,8,0,32},{0,2,0,38},{0,2,0,36},{7341,2,0,32},{0,2,0,38},{0,
2,0,36},{7341,8,0,32},{0,2,0,38},{0,2,0,37},{7341,2,0,32},{0,2,0,38},{0,2,0,37},
{7341,8,0,32},{0,2,0,38},{0,2,0,59},{7341,2,0,32},{0,2,0,38},{0,2,0,59},{7341,8,
0,32},{0,2,0,38},{0,2,0,45},{7341,2,0,32},{0,2,0,38},{0,2,0,45},{7341,8,0,32},
{0,2,0,66},{0,2,0,38},{7341,2,0,32},{0,2,0,66},{0,2,0,38},{7440,8,0,32},{0,2,0,
66},{7440,2,0,32},{0,2,0,66},{7440,8,0,32},{0,2,0,59},{7440,2,0,32},{0,2,0,59},
{7440,8,0,32},{0,2,0,45},{7440,2,0,32},{0,2,0,45},{7440,8,0,32},{0,2,0,39},{0,2,
0,36},{7440,2,0,32},{0,2,0,39},{0,2,0,36},{7440,8,0,32},{0,2,0,39},{0,2,0,37},
{7440,2,0,32},{0,2,0,39},{0,2,0,37},{7440,8,0,32},{0,2,0,39},{0,2,0,59},{7440,2,
0,32},{0,2,0,39},{0,2,0,59},{7440,8,0,32},{0,2,0,39},{0,2,0,45},{7440,2,0,32},
{0,2,0,39},{0,2,0,45},{7440,8,0,32},{0,2,0,66},{0,2,0,39},{7440,2,0,32},{0,2,0,
66},{0,2,0,39},{7576,8,0,32},{0,2,0,59},{7576,2,0,32},{0,2,0,59},{7576,8,0,32},
{0,2,0,66},{7576,2,0,32},{0,2,0,66},{7747,8,0,32},{0,2,0,66},{7747,2,0,32},{0,2,
0,66},{7747,8,0,32},{0,2,0,59},{7747,2,0,32},{0,2,0,59},{7747,8,0,32},{0,2,0,
39},{0,2,0,36},{7747,2,0,32},{0,2,0,39},{0,2,0,36},{7747,8,0,32},{0,2,0,39},{0,
2,0,37},{7747,2,0,32},{0,2,0,39},{0,2,0,37},{7747,8,0,32},{0,2,0,39},{0,2,0,59},
{7747,2,0,32},{0,2,0,39},{0,2,0,59},{7747,8,0,32},{0,2,0,39},{0,2,0,45},{7747,2,
0,32},{0,2,0,39},{0,2,0,45},{7747,8,0,32},{0,2,0,66},{0,2,0,39},{7747,2,0,32},
{0,2,0,66},{0,2,0,39},{7747,8,0,32},{0,2,0,63},{0,2,0,36},{7747,2,0,32},{0,2,0,
63},{0,2,0,36},{7747,8,0,32},{0,2,0,63},{0,2,0,37},{7747,2,0,32},{0,2,0,63},{0,
2,0,37},{7747,8,0,32},{0,2,0,63},{0,2,0,59},{7747,2,0,32},{0,2,0,63},{0,2,0,59},
{7747,8,0,32},{0,2,0,63},{0,2,0,45},{7747,2,0,32},{0,2,0,63},{0,2,0,45},{7747,8,
0,32},{0,2,0,63},{0,2,0,66},{7747,2,0,32},{0,2,0,63},{0,2,0,66},{7963,8,0,32},
{0,2,0,66},{7963,2,0,32},{0,2,0,66},{7963,8,0,32},{0,2,0,59},{7963,2,0,32},{0,2,
0,59},{7963,8,0,32},{0,2,0,63},{0,2,0,36},{7963,2,0,32},{0,2,0,63},{0,2,0,36},
{7963,8,0,32},{0,2,0,63},{0,2,0,37},{7963,2,0,32},{0,2,0,63},{0,2,0,37},{7963,8,
0,32},{0,2,0,63},{0,2,0,59},{7963,2,0,32},{0,2,0,63},{0,2,0,59},{7963,8,0,32},
{0,2,0,63},{0,2,0,45},{7963,2,0,32},{0,2,0,63},{0,2,0,45},{7963,8,0,32},{0,2,0,
63},{0,2,0,66},{7963,2,0,32},{0,2,0,63},{0,2,0,66},{8049,8,0,32},{0,2,0,37},
{8049,2,0,32},{0,2,0,37},{8049,8,0,32},{0,2,0,66},{8049,2,0,32},{0,2,0,66},
{8049,8,0,32},{0,2,0,59},{8049,2,0,32},{0,2,0,59},{8049,8,0,32},{0,2,0,45},
{8049,2,0,32},{0,2,0,45},{7645,10,0,32},{7645,10,0,32},{7645,4,0,32},{7645,4,0,
32},{8223,2,0,32},{0,2,0,34},{8223,2,0,32},{0,2,0,35},{8223,2,0,32},{0,2,0,34},
{0,2,0,37},{8223,2,0,32},{0,2,0,35},{0,2,0,37},{8223,2,0,32},{0,2,0,34},{0,2,0,
36},{8223,2,0,32},{0,2,0,35},{0,2,0,36},{8223,2,0,32},{0,2,0,34},{0,2,0,42},
{8223,2,0,32},{0,2,0,35},{0,2,0,42},{8223,8,0,32},{0,2,0,34},{8223,8,0,32},{0,2,
0,35},{8223,8,0,32},{0,2,0,34},{0,2,0,37},{8223,8,0,32},{0,2,0,35},{0,2,0,37},
{8223,8,0,32},{0,2,0,34},{0,2,0,36},{8223,8,0,32},{0,2,0,35},{0,2,0,36},{8223,8,
0,32},{0,2,0,34},{0,2,0,42},{8223,8,0,32},{0,2,0,35},{0,2,0,42},{8228,2,0,32},
{0,2,0,34},{8228,2,0,32},{0,2,0,35},{8228,2,0,32},{0,2,0,34},{0,2,0,37},{8228,2,
0,32},{0,2,0,35},{0,2,0,37},{8228,2,0,32},{0,2,0,34},{0,2,0,36},{8228,2,0,32},
{0,2,0,35},{0,2,0,36},{8228,8,0,32},{0,2,0,34},{8228,8,0,32},{0,2,0,35},{8228,8,
0,32},{0,2,0,34},{0,2,0,37},{8228,8,0,32},{0,2,0,35},{0,2,0,37},{8228,8,0,32},
{0,2,0,34},{0,2,0,36},{8228,8,0,32},{0,2,0,35},{0,2,0,36},{8234,2,0,32},{0,2,0,
34},{8234,2,0,32},{0,2,0,35},{8234,2,0,32},{0,2,0,34},{0,2,0,37},{8234,2,0,32},
{0,2,0,35},{0,2,0,37},{8234,2,0,32},{0,2,0,34},{0,2,0,36},{8234,2,0,32},{0,2,0,
35},{0,2,0,36},{8234,2,0,32},{0,2,0,34},{0,2,0,42},{8234,2,0,32},{0,2,0,35},{0,
2,0,42},{8234,8,0,32},{0,2,0,34},{8234,8,0,32},{0,2,0,35},{8234,8,0,32},{0,2,0,
34},{0,2,0,37},{8234,8,0,32},{0,2,0,35},{0,2,0,37},{8234,8,0,32},{0,2,0,34},{0,
2,0,36},{8234,8,0,32},{0,2,0,35},{0,2,0,36},{8234,8,0,32},{0,2,0,34},{0,2,0,42},
{8234,8,0,32},{0,2,0,35},{0,2,0,42},{8236,2,0,32},{0,2,0,34},{8236,2,0,32},{0,2,
0,35},{8236,2,0,32},{0,2,0,34},{0,2,0,37},{8236,2,0,32},{0,2,0,35},{0,2,0,37},
{8236,2,0,32},{0,2,0,34},{0,2,0,36},{8236,2,0,32},{0,2,0,35},{0,2,0,36},{8236,2,
0,32},{0,2,0,34},{0,2,0,42},{8236,2,0,32},{0,2,0,35},{0,2,0,42},{8236,8,0,32},
{0,2,0,34},{8236,8,0,32},{0,2,0,35},{8236,8,0,32},{0,2,0,34},{0,2,0,37},{8236,8,
0,32},{0,2,0,35},{0,2,0,37},{8236,8,0,32},{0,2,0,34},{0,2,0,36},{8236,8,0,32},
{0,2,0,35},{0,2,0,36},{8236,8,0,32},{0,2,0,34},{0,2,0,42},{8236,8,0,32},{0,2,0,
35},{0,2,0,42},{8244,2,0,32},{0,2,0,34},{8244,2,0,32},{0,2,0,35},{8244,2,0,32},
{0,2,0,34},{0,2,0,37},{8244,2,0,32},{0,2,0,35},{0,2,0,37},{8244,2,0,32},{0,2,0,
34},{0,2,0,36},{8244,2,0,32},{0,2,0,35},{0,2,0,36},{8244,8,0,32},{0,2,0,34},
{8244,8,0,32},{0,2,0,35},{8244,8,0,32},{0,2,0,34},{0,2,0,37},{8244,8,0,32},{0,2,
0,35},{0,2,0,37},{8244,8,0,32},{0,2,0,34},{0,2,0,36},{8244,8,0,32},{0,2,0,35},
{0,2,0,36},{8258,2,0,32},{0,2,0,34},{8258,2,0,32},{0,2,0,35},{8258,2,0,32},{0,2,
0,34},{0,2,0,37},{8258,2,0,32},{0,2,0,35},{0,2,0,37},{8258,2,0,32},{0,2,0,34},
{0,2,0,36},{8258,2,0,32},{0,2,0,35},{0,2,0,36},{8258,2,0,32},{0,2,0,34},{0,2,0,
42},{8258,2,0,32},{0,2,0,35},{0,2,0,42},{8258,8,0,32},{0,2,0,35},{8258,8,0,32},
{0,2,0,35},{0,2,0,37},{8258,8,0,32},{0,2,0,35},{0,2,0,36},{8258,8,0,32},{0,2,0,
35},{0,2,0,42},{8263,2,0,32},{0,2,0,34},{8263,2,0,32},{0,2,0,35},{8263,2,0,32},
{0,2,0,34},{0,2,0,37},{8263,2,0,32},{0,2,0,35},{0,2,0,37},{8263,2,0,32},{0,2,0,
34},{0,2,0,36},{8263,2,0,32},{0,2,0,35},{0,2,0,36},{8263,2,0,32},{0,2,0,34},{0,
2,0,42},{8263,2,0,32},{0,2,0,35},{0,2,0,42},{8263,8,0,32},{0,2,0,34},{8263,8,0,
32},{0,2,0,35},{8263,8,0,32},{0,2,0,34},{0,2,0,37},{8263,8,0,32},{0,2,0,35},{0,
2,0,37},{8263,8,0,32},{0,2,0,34},{0,2,0,36},{8263,8,0,32},{0,2,0,35},{0,2,0,36},
{8263,8,0,32},{0,2,0,34},{0,2,0,42},{8263,8,0,32},{0,2,0,35},{0,2,0,42},{8223,2,
0,32},{0,2,0,37},{8228,2,0,32},{0,2,0,37},{8234,2,0,32},{0,2,0,37},{8236,2,0,
32},{0,2,0,37},{8244,2,0,32},{0,2,0,37},{8258,2,0,32},{0,2,0,37},{8263,2,0,32},
{0,2,0,37},{8223,2,0,32},{0,2,0,34},{0,2,0,76},{8223,2,0,32},{0,2,0,35},{0,2,0,
76},{8223,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{8223,2,0,32},{0,2,0,35},{0,
2,0,37},{0,2,0,76},{8223,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{8223,2,0,32},
{0,2,0,35},{0,2,0,36},{0,2,0,76},{8223,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{8223,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{8223,8,0,32},{0,2,0,34},{0,2,0,
76},{8223,8,0,32},{0,2,0,35},{0,2,0,76},{8223,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{8223,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{8223,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{8223,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{8223,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{8223,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{8234,2,0,32},{0,2,0,34},{0,2,0,76},{8234,2,0,32},{0,2,0,35},{0,2,0,76},
{8234,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{8234,2,0,32},{0,2,0,35},{0,2,0,
37},{0,2,0,76},{8234,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{8234,2,0,32},{0,
2,0,35},{0,2,0,36},{0,2,0,76},{8234,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{8234,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{8234,8,0,32},{0,2,0,34},{0,2,0,
76},{8234,8,0,32},{0,2,0,35},{0,2,0,76},{8234,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{8234,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{8234,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{8234,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{8234,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{8234,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{8263,2,0,32},{0,2,0,34},{0,2,0,76},{8263,2,0,32},{0,2,0,35},{0,2,0,76},
{8263,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{8263,2,0,32},{0,2,0,35},{0,2,0,
37},{0,2,0,76},{8263,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{8263,2,0,32},{0,
2,0,35},{0,2,0,36},{0,2,0,76},{8263,2,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},
{8263,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{8263,8,0,32},{0,2,0,34},{0,2,0,
76},{8263,8,0,32},{0,2,0,35},{0,2,0,76},{8263,8,0,32},{0,2,0,34},{0,2,0,37},{0,
2,0,76},{8263,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{8263,8,0,32},{0,2,0,34},
{0,2,0,36},{0,2,0,76},{8263,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{8263,8,0,
32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{8263,8,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,
76},{8223,2,0,32},{0,2,0,38},{8223,2,0,32},{0,2,0,50},{8223,2,0,32},{0,2,0,37},
{0,2,0,76},{8223,2,0,32},{0,2,0,76},{8223,2,0,32},{0,2,0,36},{0,2,0,76},{8223,2,
0,32},{0,2,0,42},{8223,2,0,32},{0,2,0,42},{0,2,0,76},{8223,8,0,32},{0,2,0,38},
{8223,8,0,32},{0,2,0,50},{8223,8,0,32},{0,2,0,37},{8223,8,0,32},{0,2,0,76},
{1183,2,1,32},{0,2,0,42},{8234,2,0,32},{0,2,0,37},{0,2,0,76},{8234,2,0,32},{0,2,
0,76},{8234,2,0,32},{0,2,0,36},{0,2,0,76},{8234,2,0,32},{0,2,0,42},{8234,2,0,
32},{0,2,0,42},{0,2,0,76},{8228,8,0,32},{0,2,0,37},{8234,8,0,32},{0,2,0,37},
{8234,8,0,32},{0,2,0,76},{1188,2,1,32},{0,2,0,37},{1188,2,1,32},{0,2,0,36},
{1188,2,1,32},{0,2,0,42},{8236,2,0,32},{0,2,0,38},{8236,2,0,32},{0,2,0,50},
{8236,2,0,32},{0,2,0,43},{0,2,0,37},{8236,2,0,32},{0,2,0,42},{8236,2,0,32},{0,2,
0,43},{0,2,0,42},{8236,8,0,32},{0,2,0,38},{8236,8,0,32},{0,2,0,50},{8236,8,0,
32},{0,2,0,37},{1189,2,1,32},{0,2,0,37},{1189,2,1,32},{0,2,0,36},{1189,2,1,32},
{0,2,0,42},{8258,2,0,32},{0,2,0,38},{8258,2,0,32},{0,2,0,50},{8258,2,0,32},{0,2,
0,43},{0,2,0,37},{8250,2,0,32},{0,2,0,34},{8250,2,0,32},{0,2,0,35},{8258,2,0,
32},{0,2,0,42},{8258,2,0,32},{0,2,0,43},{0,2,0,42},{8258,8,0,32},{0,2,0,38},
{8258,8,0,32},{0,2,0,50},{8258,8,0,32},{0,2,0,37},{8250,8,0,32},{0,2,0,35},
{1183,2,1,32},{0,2,0,37},{8263,2,0,32},{0,2,0,37},{0,2,0,76},{8263,2,0,32},{0,2,
0,76},{8263,2,0,32},{0,2,0,36},{0,2,0,76},{8263,2,0,32},{0,2,0,42},{8263,2,0,
32},{0,2,0,42},{0,2,0,76},{8244,8,0,32},{0,2,0,37},{8263,8,0,32},{0,2,0,37},
{8263,8,0,32},{0,2,0,76},{632,4,1,32},{632,4,1,32},{632,4,1,32},{632,4,1,32},
{632,4,1,32},{939,4,1,32},{939,4,1,32},{939,4,1,32},{939,4,1,32},{939,4,1,32},
{940,4,1,32},{940,4,1,32},{940,4,1,32},{940,4,1,32},{940,4,1,32},{609,4,1,32},
{609,4,1,32},{615,4,1,32},{615,4,1,32},{615,4,1,32},{609,4,1,32},{609,4,1,32},
{615,4,1,32},{939,4,1,32},{939,4,1,32},{939,4,1,32},{939,4,1,32},{7833,10,0,32},
{7895,4,0,32},{7341,4,0,32},{917,4,1,32},{7392,4,0,32},{7341,4,0,32},{917,4,1,
32},{7895,4,0,32},{1292,4,1,32},{7392,10,0,32},{7392,4,0,32},{917,4,1,32},{7747,
4,0,32},{7392,4,0,32},{917,4,1,32},{7963,4,0,32},{1292,4,1,32},{7499,10,0,32},
{7550,2,0,32},{0,2,0,57},{7711,10,0,32},{7747,4,0,32},{7895,20,0,32},{7696,20,0,
32},{7931,10,0,32},{7440,10,0,32},{7645,10,0,32},{7931,20,0,32},{7696,20,0,32},
{7499,10,0,32},{7341,10,0,32},{8037,10,0,32},{7341,10,0,32},{917,4,1,32},{7895,
10,0,32},{7332,30,0,32},{1596,30,1,32},{7338,30,0,32},{7332,30,0,32},{1596,30,1,
32},{7340,30,0,32},{7332,30,0,32},{1596,30,1,32},{7332,30,0,32},{7331,30,0,32},
{7332,30,0,32},{1596,30,1,32},{7334,30,0,32},{7333,30,0,32},{1596,30,1,32},
{7334,30,0,32},{7332,30,0,32},{1596,30,1,32},{7336,30,0,32},{7333,30,0,32},
{1596,30,1,32},{7336,30,0,32},{7334,30,0,32},{1596,30,1,32},{7336,30,0,32},
{7335,30,0,32},{1596,30,1,32},{7336,30,0,32},{7332,30,0,32},{1596,30,1,32},
{7337,30,0,32},{7336,30,0,32},{1596,30,1,32},{7337,30,0,32},{7332,30,0,32},
{1596,30,1,32},{7339,30,0,32},{7334,30,0,32},{1596,30,1,32},{7339,30,0,32},
{7336,30,0,32},{1596,30,1,32},{7339,30,0,32},{7338,30,0,32},{1596,30,1,32},
{7339,30,0,32},{7332,30,0,32},{1596,30,1,32},{7576,10,0,32},{7576,10,0,32},
{7576,10,0,32},{7576,10,0,32},{7576,10,0,32},{7576,10,0,32},{8009,10,0,32},
{8009,10,0,32},{7576,10,0,32},{8009,10,0,32},{7576,10,0,32},{7576,10,0,32},
{8009,10,0,32},{7576,10,0,32},{7576,10,0,32},{7576,10,0,32},{7576,10,0,32},
{8037,10,0,32},{8037,10,0,32},{7576,10,0,32},{8037,10,0,32},{7576,10,0,32},
{7576,10,0,32},{7576,4,0,32},{7576,4,0,32},{7576,4,0,32},{7576,4,0,32},{7576,4,
0,32},{7576,4,0,32},{8009,4,0,32},{8009,4,0,32},{7576,4,0,32},{8009,4,0,32},
{7576,4,0,32},{7576,4,0,32},{8009,4,0,32},{7576,4,0,32},{7576,4,0,32},{7576,4,0,
32},{7576,4,0,32},{8037,4,0,32},{8037,4,0,32},{7576,4,0,32},{8037,4,0,32},{7576,
4,0,32},{7576,4,0,32},{7331,30,0,32},{1596,30,1,32},{7334,30,0,32},{1458,2,1,
32},{0,2,0,47},{1459,2,1,32},{0,2,0,47},{1462,2,1,32},{0,2,0,47},{1516,2,1,32},
{0,2,0,47},{1520,2,1,32},{0,2,0,47},{1518,2,1,32},{0,2,0,47},{1567,2,1,32},{0,2,
0,47},{1571,2,1,32},{0,2,0,47},{1573,2,1,32},{0,2,0,47},{1612,2,1,32},{0,2,0,
47},{1613,2,1,32},{0,2,0,47},{1618,4,1,32},{1618,4,1,32},{1618,4,1,32},{1618,4,
1,32},{1618,4,1,32},{1619,4,1,32},{1619,4,1,32},{1619,4,1,32},{1619,4,1,32},
{1619,4,1,32},{1631,2,1,32},{0,2,0,47},{1637,2,1,32},{0,2,0,47},{1638,2,1,32},
{0,2,0,47},{1640,2,1,32},{0,2,0,47},{1585,2,1,32},{0,2,0,47},{1663,2,1,32},{0,2,
0,47},{1644,2,1,32},{0,2,0,47},{1584,2,1,32},{0,2,0,47},{1586,2,1,32},{0,2,0,
47},{1665,2,1,32},{0,2,0,47},{1666,2,1,32},{0,2,0,47},{1674,2,1,32},{0,2,0,47},
{1675,2,1,32},{0,2,0,47},{1676,2,1,32},{0,2,0,47},{1677,2,1,32},{0,2,0,47},
{1678,2,1,32},{0,2,0,47},{1679,2,1,32},{0,2,0,47},{1684,2,1,32},{0,2,0,47},
{1685,2,1,32},{0,2,0,47},{1686,2,1,32},{0,2,0,47},{1687,2,1,32},{0,2,0,47},
{1712,2,1,32},{0,2,0,47},{1718,2,1,32},{0,2,0,47},{1719,2,1,32},{0,2,0,47},
{1721,2,1,32},{0,2,0,47},{1680,2,1,32},{0,2,0,47},{1681,2,1,32},{0,2,0,47},
{1695,2,1,32},{0,2,0,47},{1696,2,1,32},{0,2,0,47},{1724,2,1,32},{0,2,0,47},
{1725,2,1,32},{0,2,0,47},{1726,2,1,32},{0,2,0,47},{1727,2,1,32},{0,2,0,47},
{7332,6,0,32},{7331,6,0,32},{7332,6,0,32},{7332,6,0,32},{7332,6,0,32},{7333,6,0,
32},{7332,6,0,32},{7334,6,0,32},{7332,6,0,32},{7335,6,0,32},{7332,6,0,32},{7336,
6,0,32},{7332,6,0,32},{7337,6,0,32},{7332,6,0,32},{7338,6,0,32},{7332,6,0,32},
{7339,6,0,32},{7332,6,0,32},{7340,6,0,32},{7333,6,0,32},{7331,6,0,32},{792,4,1,
32},{7332,4,0,32},{793,4,1,32},{792,4,1,32},{7333,4,0,32},{793,4,1,32},{792,4,1,
32},{7334,4,0,32},{793,4,1,32},{792,4,1,32},{7335,4,0,32},{793,4,1,32},{792,4,1,
32},{7336,4,0,32},{793,4,1,32},{792,4,1,32},{7337,4,0,32},{793,4,1,32},{792,4,1,
32},{7338,4,0,32},{793,4,1,32},{792,4,1,32},{7339,4,0,32},{793,4,1,32},{792,4,1,
32},{7340,4,0,32},{793,4,1,32},{792,4,1,32},{7332,4,0,32},{7331,4,0,32},{793,4,
1,32},{792,4,1,32},{7332,4,0,32},{7332,4,0,32},{793,4,1,32},{792,4,1,32},{7332,
4,0,32},{7333,4,0,32},{793,4,1,32},{792,4,1,32},{7332,4,0,32},{7334,4,0,32},
{793,4,1,32},{792,4,1,32},{7332,4,0,32},{7335,4,0,32},{793,4,1,32},{792,4,1,32},
{7332,4,0,32},{7336,4,0,32},{793,4,1,32},{792,4,1,32},{7332,4,0,32},{7337,4,0,
32},{793,4,1,32},{792,4,1,32},{7332,4,0,32},{7338,4,0,32},{793,4,1,32},{792,4,1,
32},{7332,4,0,32},{7339,4,0,32},{793,4,1,32},{792,4,1,32},{7332,4,0,32},{7340,4,
0,32},{793,4,1,32},{792,4,1,32},{7333,4,0,32},{7331,4,0,32},{793,4,1,32},{7332,
4,0,32},{632,4,1,32},{7333,4,0,32},{632,4,1,32},{7334,4,0,32},{632,4,1,32},
{7335,4,0,32},{632,4,1,32},{7336,4,0,32},{632,4,1,32},{7337,4,0,32},{632,4,1,
32},{7338,4,0,32},{632,4,1,32},{7339,4,0,32},{632,4,1,32},{7340,4,0,32},{632,4,
1,32},{7332,4,0,32},{7331,4,0,32},{632,4,1,32},{7332,4,0,32},{7332,4,0,32},{632,
4,1,32},{7332,4,0,32},{7333,4,0,32},{632,4,1,32},{7332,4,0,32},{7334,4,0,32},
{632,4,1,32},{7332,4,0,32},{7335,4,0,32},{632,4,1,32},{7332,4,0,32},{7336,4,0,
32},{632,4,1,32},{7332,4,0,32},{7337,4,0,32},{632,4,1,32},{7332,4,0,32},{7338,4,
0,32},{632,4,1,32},{7332,4,0,32},{7339,4,0,32},{632,4,1,32},{7332,4,0,32},{7340,
4,0,32},{632,4,1,32},{7333,4,0,32},{7331,4,0,32},{632,4,1,32},{792,4,1,32},
{7341,4,0,32},{793,4,1,32},{792,4,1,32},{7366,4,0,32},{793,4,1,32},{792,4,1,32},
{7392,4,0,32},{793,4,1,32},{792,4,1,32},{7413,4,0,32},{793,4,1,32},{792,4,1,32},
{7440,4,0,32},{793,4,1,32},{792,4,1,32},{7499,4,0,32},{793,4,1,32},{792,4,1,32},
{7514,4,0,32},{793,4,1,32},{792,4,1,32},{7550,4,0,32},{793,4,1,32},{792,4,1,32},
{7576,4,0,32},{793,4,1,32},{792,4,1,32},{7602,4,0,32},{793,4,1,32},{792,4,1,32},
{7627,4,0,32},{793,4,1,32},{792,4,1,32},{7645,4,0,32},{793,4,1,32},{792,4,1,32},
{7696,4,0,32},{793,4,1,32},{792,4,1,32},{7711,4,0,32},{793,4,1,32},{792,4,1,32},
{7747,4,0,32},{793,4,1,32},{792,4,1,32},{7794,4,0,32},{793,4,1,32},{792,4,1,32},
{7815,4,0,32},{793,4,1,32},{792,4,1,32},{7833,4,0,32},{793,4,1,32},{792,4,1,32},
{7895,4,0,32},{793,4,1,32},{792,4,1,32},{7931,4,0,32},{793,4,1,32},{792,4,1,32},
{7963,4,0,32},{793,4,1,32},{792,4,1,32},{8009,4,0,32},{793,4,1,32},{792,4,1,32},
{8027,4,0,32},{793,4,1,32},{792,4,1,32},{8037,4,0,32},{793,4,1,32},{792,4,1,32},
{8049,4,0,32},{793,4,1,32},{792,4,1,32},{8071,4,0,32},{793,4,1,32},{7332,6,0,
32},{7332,6,0,32},{7332,6,0,32},{7333,6,0,32},{7332,6,0,32},{7334,6,0,32},{7332,
6,0,32},{7335,6,0,32},{7332,6,0,32},{7336,6,0,32},{7332,6,0,32},{7337,6,0,32},
{7332,6,0,32},{7338,6,0,32},{7332,6,0,32},{7339,6,0,32},{7332,6,0,32},{7340,6,0,
32},{7333,6,0,32},{7331,6,0,32},{7332,6,0,32},{7331,6,0,32},{7332,6,0,32},{7331,
6,0,32},{7332,6,0,32},{7331,6,0,32},{7332,6,0,32},{7331,6,0,32},{1618,4,1,32},
{1618,4,1,32},{1618,4,1,32},{1618,4,1,32},{570,4,1,32},{570,4,1,32},{1585,4,1,
32},{1585,4,1,32},{1585,4,1,32},{1585,4,1,32},{1585,4,1,32},{1585,4,1,32},{3260,
2,1,32},{0,2,0,47},{8279,4,0,32},{8268,4,0,32},{8278,4,0,32},{8555,4,0,32},
{8564,4,0,32},{64320,4,0,32},{52790,0,0,0},{0,4,0,273},{64320,4,0,32},{54146,0,
0,0},{0,4,0,273},{64320,4,0,32},{52827,0,0,0},{64320,4,0,32},{52826,0,0,0},
{64320,4,0,32},{52825,0,0,0},{0,4,0,273},{64320,4,0,32},{52923,0,0,0},{64320,4,
0,32},{53634,0,0,0},{0,4,0,273},{64320,4,0,32},{53728,0,0,0},{0,4,0,273},{64320,
4,0,32},{53760,0,0,0},{0,4,0,273},{64320,4,0,32},{53762,0,0,0},{64320,4,0,32},
{54108,0,0,0},{0,4,0,273},{64320,4,0,32},{54121,0,0,0},{0,4,0,273},{64320,4,0,
32},{56335,0,0,0},{0,4,0,273},{64320,4,0,32},{56335,0,0,0},{0,4,0,274},{64320,4,
0,32},{56354,0,0,0},{0,4,0,273},{64320,4,0,32},{56355,0,0,0},{64320,4,0,32},
{56354,0,0,0},{64320,4,0,32},{56355,0,0,0},{0,4,0,273},{64320,4,0,32},{56819,0,
0,0},{64320,4,0,32},{56954,0,0,0},{64320,4,0,32},{57169,0,0,0},{64320,4,0,32},
{57168,0,0,0},{0,4,0,273},{64320,4,0,32},{57284,0,0,0},{64320,4,0,32},{57283,0,
0,0},{0,4,0,273},{64320,4,0,32},{57932,0,0,0},{64320,4,0,32},{58677,0,0,0},
{64320,4,0,32},{58849,0,0,0},{64320,4,0,32},{58853,0,0,0},{0,4,0,273},{64320,4,
0,32},{59144,0,0,0},{0,4,0,273},{64320,4,0,32},{60282,0,0,0},{0,4,0,273},{64320,
4,0,32},{60365,0,0,0},{64320,4,0,32},{60433,0,0,0},{64320,4,0,32},{60469,0,0,0},
{64320,4,0,32},{60474,0,0,0},{64320,4,0,32},{61548,0,0,0},{64320,4,0,32},{61995,
0,0,0},{64320,4,0,32},{61995,0,0,0},{0,4,0,273},{64320,4,0,32},{52780,0,0,0},
{64320,4,0,32},{62043,0,0,0},{0,4,0,273},{64320,4,0,32},{62125,0,0,0},{64320,4,
0,32},{62347,0,0,0},{0,4,0,273},{64320,4,0,32},{62859,0,0,0},{0,4,0,273},{64320,
4,0,32},{63214,0,0,0},{0,4,0,273},{64320,4,0,32},{63802,0,0,0},{0,4,0,273},
{64320,4,0,32},{63803,0,0,0},{64320,4,0,32},{64249,0,0,0},{0,4,0,273},{64320,4,
0,32},{64761,0,0,0},{64320,4,0,32},{65183,0,0,0},{64320,4,0,32},{65363,0,0,0},
{64320,4,0,32},{65362,0,0,0},{64320,4,0,32},{65363,0,0,0},{0,4,0,273},{64320,4,
0,32},{65363,0,0,0},{0,4,0,274},{64320,4,0,32},{65362,0,0,0},{0,4,0,273},{64320,
4,0,32},{65418,0,0,0},{0,4,0,273},{64320,4,0,32},{65418,0,0,0},{0,4,0,274},
{64320,4,0,32},{65419,0,0,0},{64321,4,0,32},{32770,0,0,0},{64321,4,0,32},{32896,
0,0,0},{64321,4,0,32},{32895,0,0,0},{0,4,0,273},{64321,4,0,32},{32905,0,0,0},{0,
4,0,273},{64321,4,0,32},{33276,0,0,0},{0,4,0,273},{64321,4,0,32},{33401,0,0,0},
{64321,4,0,32},{33401,0,0,0},{0,4,0,273},{64321,4,0,32},{33401,0,0,0},{0,4,0,
274},{64321,4,0,32},{34382,0,0,0},{64321,4,0,32},{34916,0,0,0},{64321,4,0,32},
{35200,0,0,0},{64321,4,0,32},{35199,0,0,0},{64321,4,0,32},{35265,0,0,0},{64321,
4,0,32},{35282,0,0,0},{64321,4,0,32},{35282,0,0,0},{0,4,0,273},{64321,4,0,32},
{35744,0,0,0},{64321,4,0,32},{36125,0,0,0},{64321,4,0,32},{36275,0,0,0},{0,4,0,
273},{64321,4,0,32},{36710,0,0,0},{64321,4,0,32},{36790,0,0,0},{64321,4,0,32},
{36790,0,0,0},{0,4,0,273},{64321,4,0,32},{36790,0,0,0},{0,4,0,274},{64321,4,0,
32},{37009,0,0,0},{0,4,0,273},{64321,4,0,32},{38021,0,0,0},{64321,4,0,32},
{38263,0,0,0},{64321,4,0,32},{38264,0,0,0},{64321,4,0,32},{38271,0,0,0},{64321,
4,0,32},{38376,0,0,0},{64321,4,0,32},{38428,0,0,0},{0,4,0,273},{64321,4,0,32},
{38429,0,0,0},{64321,4,0,32},{38632,0,0,0},{0,4,0,273},{64321,4,0,32},{38738,0,
0,0},{64321,4,0,32},{38886,0,0,0},{64321,4,0,32},{39029,0,0,0},{64321,4,0,32},
{39118,0,0,0},{64321,4,0,32},{39134,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,
4,0,32},{39136,0,0,0},{0,4,0,273},{64321,4,0,32},{39136,0,0,0},{64321,4,0,32},
{39267,0,0,0},{64321,4,0,32},{39318,0,0,0},{0,4,0,273},{64321,4,0,32},{39532,0,
0,0},{64321,4,0,32},{39592,0,0,0},{0,4,0,273},{64321,4,0,32},{39740,0,0,0},{0,4,
0,273},{64321,4,0,32},{40060,0,0,0},{64321,4,0,32},{40479,0,0,0},{64321,4,0,32},
{40565,0,0,0},{0,4,0,273},{64321,4,0,32},{40614,0,0,0},{64321,4,0,32},{40644,0,
0,0},{64321,4,0,32},{40702,0,0,0},{64321,4,0,32},{40778,0,0,0},{0,4,0,273},
{64321,4,0,32},{40784,0,0,0},{64321,4,0,32},{40786,0,0,0},{0,4,0,273},{64321,4,
0,32},{40831,0,0,0},{64321,4,0,32},{40845,0,0,0},{0,4,0,273},{64321,4,0,32},
{40857,0,0,0},{64321,4,0,32},{40860,0,0,0},{0,4,0,273},{64321,4,0,32},{40860,0,
0,0},{0,4,0,274},{64321,4,0,32},{40863,0,0,0},{64320,4,0,32},{52736,0,0,0},
{64320,4,0,32},{52776,0,0,0},{64320,4,0,32},{52790,0,0,0},{64320,4,0,32},{52799,
0,0,0},{64320,4,0,32},{52825,0,0,0},{64320,4,0,32},{52869,0,0,0},{64320,4,0,32},
{52876,0,0,0},{64320,4,0,32},{52896,0,0,0},{64320,4,0,32},{52922,0,0,0},{64320,
4,0,32},{53567,0,0,0},{64320,4,0,32},{53605,0,0,0},{64320,4,0,32},{53611,0,0,0},
{64320,4,0,32},{53634,0,0,0},{64320,4,0,32},{53654,0,0,0},{64320,4,0,32},{53675,
0,0,0},{64320,4,0,32},{53728,0,0,0},{64320,4,0,32},{53749,0,0,0},{64320,4,0,32},
{53760,0,0,0},{64320,4,0,32},{53915,0,0,0},{64320,4,0,32},{54009,0,0,0},{64320,
4,0,32},{54037,0,0,0},{64320,4,0,32},{54042,0,0,0},{64320,4,0,32},{54072,0,0,0},
{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},{54108,0,0,0},{64320,4,0,32},{54121,
0,0,0},{64320,4,0,32},{54146,0,0,0},{64320,4,0,32},{54198,0,0,0},{64320,4,0,32},
{54216,0,0,0},{64320,4,0,32},{54243,0,0,0},{64320,4,0,32},{54999,0,0,0},{64320,
4,0,32},{55071,0,0,0},{64320,4,0,32},{55531,0,0,0},{64320,4,0,32},{55554,0,0,0},
{64320,4,0,32},{55562,0,0,0},{64320,4,0,32},{55573,0,0,0},{64320,4,0,32},{55591,
0,0,0},{64320,4,0,32},{55667,0,0,0},{64320,4,0,32},{56144,0,0,0},{64320,4,0,32},
{56192,0,0,0},{64320,4,0,32},{56312,0,0,0},{64320,4,0,32},{56335,0,0,0},{64320,
4,0,32},{56354,0,0,0},{64320,4,0,32},{56376,0,0,0},{64320,4,0,32},{56430,0,0,0},
{64320,4,0,32},{56433,0,0,0},{64320,4,0,32},{56795,0,0,0},{64320,4,0,32},{56805,
0,0,0},{64320,4,0,32},{56817,0,0,0},{64320,4,0,32},{56830,0,0,0},{64320,4,0,32},
{56946,0,0,0},{64320,4,0,32},{56954,0,0,0},{64320,4,0,32},{56959,0,0,0},{64320,
4,0,32},{57076,0,0,0},{64320,4,0,32},{57086,0,0,0},{64320,4,0,32},{57099,0,0,0},
{64320,4,0,32},{57107,0,0,0},{64320,4,0,32},{57168,0,0,0},{64320,4,0,32},{57185,
0,0,0},{64320,4,0,32},{57203,0,0,0},{64320,4,0,32},{57283,0,0,0},{64320,4,0,32},
{57864,0,0,0},{64320,4,0,32},{57910,0,0,0},{64320,4,0,32},{57931,0,0,0},{64320,
4,0,32},{58671,0,0,0},{64320,4,0,32},{58676,0,0,0},{64320,4,0,32},{58759,0,0,0},
{64320,4,0,32},{58775,0,0,0},{64320,4,0,32},{58788,0,0,0},{64320,4,0,32},{58809,
0,0,0},{64320,4,0,32},{58848,0,0,0},{64320,4,0,32},{58853,0,0,0},{64320,4,0,32},
{59120,0,0,0},{64320,4,0,32},{59144,0,0,0},{64320,4,0,32},{59176,0,0,0},{64320,
4,0,32},{60192,0,0,0},{64320,4,0,32},{60258,0,0,0},{64320,4,0,32},{60281,0,0,0},
{64320,4,0,32},{60339,0,0,0},{64320,4,0,32},{60363,0,0,0},{64320,4,0,32},{60372,
0,0,0},{64320,4,0,32},{60379,0,0,0},{64320,4,0,32},{60431,0,0,0},{64320,4,0,32},
{60436,0,0,0},{64320,4,0,32},{60468,0,0,0},{64320,4,0,32},{61547,0,0,0},{64320,
4,0,32},{61994,0,0,0},{64320,4,0,32},{62006,0,0,0},{64320,4,0,32},{62011,0,0,0},
{64320,4,0,32},{62015,0,0,0},{64320,4,0,32},{62023,0,0,0},{64320,4,0,32},{62041,
0,0,0},{64320,4,0,32},{62043,0,0,0},{64320,4,0,32},{62124,0,0,0},{64320,4,0,32},
{62340,0,0,0},{64320,4,0,32},{62345,0,0,0},{64320,4,0,32},{62684,0,0,0},{64320,
4,0,32},{62694,0,0,0},{64320,4,0,32},{62744,0,0,0},{64320,4,0,32},{62751,0,0,0},
{64320,4,0,32},{62760,0,0,0},{64320,4,0,32},{62768,0,0,0},{64320,4,0,32},{62859,
0,0,0},{64320,4,0,32},{62866,0,0,0},{64320,4,0,32},{63094,0,0,0},{64320,4,0,32},
{63101,0,0,0},{64320,4,0,32},{63150,0,0,0},{64320,4,0,32},{63167,0,0,0},{64320,
4,0,32},{63214,0,0,0},{64320,4,0,32},{63451,0,0,0},{64320,4,0,32},{63458,0,0,0},
{64320,4,0,32},{63475,0,0,0},{64320,4,0,32},{63802,0,0,0},{64320,4,0,32},{63928,
0,0,0},{64320,4,0,32},{63934,0,0,0},{64320,4,0,32},{64116,0,0,0},{64320,4,0,32},
{64203,0,0,0},{64320,4,0,32},{64249,0,0,0},{64320,4,0,32},{64627,0,0,0},{64320,
4,0,32},{64760,0,0,0},{64320,4,0,32},{65334,0,0,0},{64320,4,0,32},{65361,0,0,0},
{64320,4,0,32},{65418,0,0,0},{64320,4,0,32},{65469,0,0,0},{64321,4,0,32},{32769,
0,0,0},{64321,4,0,32},{32780,0,0,0},{64321,4,0,32},{32786,0,0,0},{64321,4,0,32},
{32819,0,0,0},{64321,4,0,32},{32895,0,0,0},{64321,4,0,32},{32905,0,0,0},{64321,
4,0,32},{33251,0,0,0},{64321,4,0,32},{33258,0,0,0},{64321,4,0,32},{33267,0,0,0},
{64321,4,0,32},{33276,0,0,0},{64321,4,0,32},{33292,0,0,0},{64321,4,0,32},{33307,
0,0,0},{64321,4,0,32},{33311,0,0,0},{64321,4,0,32},{33390,0,0,0},{64321,4,0,32},
{33394,0,0,0},{64321,4,0,32},{33400,0,0,0},{64321,4,0,32},{34381,0,0,0},{64321,
4,0,32},{34411,0,0,0},{64321,4,0,32},{34880,0,0,0},{64321,4,0,32},{34892,0,0,0},
{64321,4,0,32},{34915,0,0,0},{64321,4,0,32},{35198,0,0,0},{64321,4,0,32},{35211,
0,0,0},{64321,4,0,32},{35282,0,0,0},{64321,4,0,32},{35328,0,0,0},{64321,4,0,32},
{35895,0,0,0},{64321,4,0,32},{35910,0,0,0},{64321,4,0,32},{35925,0,0,0},{64321,
4,0,32},{35960,0,0,0},{64321,4,0,32},{35997,0,0,0},{64321,4,0,32},{36196,0,0,0},
{64321,4,0,32},{36208,0,0,0},{64321,4,0,32},{36275,0,0,0},{64321,4,0,32},{36523,
0,0,0},{64321,4,0,32},{36554,0,0,0},{64321,4,0,32},{36763,0,0,0},{64321,4,0,32},
{36784,0,0,0},{64321,4,0,32},{36789,0,0,0},{64321,4,0,32},{37009,0,0,0},{64321,
4,0,32},{37193,0,0,0},{64321,4,0,32},{37318,0,0,0},{64321,4,0,32},{37324,0,0,0},
{64321,4,0,32},{37329,0,0,0},{64321,4,0,32},{38263,0,0,0},{64321,4,0,32},{38272,
0,0,0},{64321,4,0,32},{38428,0,0,0},{64321,4,0,32},{38582,0,0,0},{64321,4,0,32},
{38585,0,0,0},{64321,4,0,32},{38632,0,0,0},{64321,4,0,32},{38737,0,0,0},{64321,
4,0,32},{38750,0,0,0},{64321,4,0,32},{38754,0,0,0},{64321,4,0,32},{38761,0,0,0},
{64321,4,0,32},{38859,0,0,0},{64321,4,0,32},{38893,0,0,0},{64321,4,0,32},{38899,
0,0,0},{64321,4,0,32},{38913,0,0,0},{64321,4,0,32},{39080,0,0,0},{64321,4,0,32},
{39131,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,4,0,32},{39318,0,0,0},{64321,
4,0,32},{39321,0,0,0},{64321,4,0,32},{39340,0,0,0},{64321,4,0,32},{39592,0,0,0},
{64321,4,0,32},{39640,0,0,0},{64321,4,0,32},{39647,0,0,0},{64321,4,0,32},{39717,
0,0,0},{64321,4,0,32},{39727,0,0,0},{64321,4,0,32},{39730,0,0,0},{64321,4,0,32},
{39740,0,0,0},{64321,4,0,32},{39770,0,0,0},{64321,4,0,32},{40165,0,0,0},{64321,
4,0,32},{40565,0,0,0},{64321,4,0,32},{40575,0,0,0},{64321,4,0,32},{40613,0,0,0},
{64321,4,0,32},{40635,0,0,0},{64321,4,0,32},{40643,0,0,0},{64321,4,0,32},{40653,
0,0,0},{64321,4,0,32},{40657,0,0,0},{64321,4,0,32},{40697,0,0,0},{64321,4,0,32},
{40701,0,0,0},{64321,4,0,32},{40718,0,0,0},{64321,4,0,32},{40723,0,0,0},{64321,
4,0,32},{40736,0,0,0},{64321,4,0,32},{40763,0,0,0},{64321,4,0,32},{40778,0,0,0},
{64321,4,0,32},{40786,0,0,0},{64321,4,0,32},{40845,0,0,0},{64321,4,0,32},{40860,
0,0,0},{64321,4,0,32},{40864,0,0,0},{15997,4,0,32},{16019,4,0,32},{7279,2,0,32},
{0,2,0,55},{7280,2,0,32},{0,2,0,55},{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},
{54084,0,0,0},{64320,4,0,32},{54085,0,0,0},{16016,4,0,32},{15998,4,0,32},{15991,
14,0,32},{0,2,0,55},{15992,14,0,32},{0,2,0,55},{15993,14,0,32},{0,2,0,55},
{15994,14,0,32},{0,2,0,55},{15995,14,0,32},{0,2,0,55},{15996,14,0,32},{0,2,0,
55},{15997,14,0,32},{0,2,0,55},{15998,14,0,32},{0,2,0,55},{15999,14,0,32},{0,2,
0,55},{16000,14,0,32},{0,2,0,55},{16001,14,0,32},{0,2,0,55},{16002,14,0,32},{0,
2,0,55},{16003,14,0,32},{0,2,0,55},{16004,14,0,32},{0,2,0,55},{16005,14,0,32},
{0,2,0,55},{16011,14,0,32},{0,2,0,55},{16011,14,0,32},{0,2,0,56},{16012,14,0,
32},{0,2,0,55},{16012,14,0,32},{0,2,0,56},{16013,14,0,32},{0,2,0,55},{16013,14,
0,32},{0,2,0,56},{16014,14,0,32},{0,2,0,55},{16014,14,0,32},{0,2,0,56},{16015,
14,0,32},{0,2,0,55},{16015,14,0,32},{0,2,0,56},{15987,14,0,32},{0,2,0,55},{7282,
2,0,32},{0,2,0,55},{16023,22,0,32},{16025,22,0,32},{15991,17,0,32},{0,2,0,55},
{15992,17,0,32},{0,2,0,55},{15993,17,0,32},{0,2,0,55},{15994,17,0,32},{0,2,0,
55},{15995,17,0,32},{0,2,0,55},{15996,17,0,32},{0,2,0,55},{15997,17,0,32},{0,2,
0,55},{15998,17,0,32},{0,2,0,55},{15999,17,0,32},{0,2,0,55},{16000,17,0,32},{0,
2,0,55},{16001,17,0,32},{0,2,0,55},{16002,17,0,32},{0,2,0,55},{16003,17,0,32},
{0,2,0,55},{16004,17,0,32},{0,2,0,55},{16005,17,0,32},{0,2,0,55},{16011,17,0,
32},{0,2,0,55},{16011,17,0,32},{0,2,0,56},{16012,17,0,32},{0,2,0,55},{16012,17,
0,32},{0,2,0,56},{16013,17,0,32},{0,2,0,55},{16013,17,0,32},{0,2,0,56},{16014,
17,0,32},{0,2,0,55},{16014,17,0,32},{0,2,0,56},{16015,17,0,32},{0,2,0,55},
{16015,17,0,32},{0,2,0,56},{15987,17,0,32},{0,2,0,55},{16029,17,0,32},{0,2,0,
55},{16030,17,0,32},{0,2,0,55},{16031,17,0,32},{0,2,0,55},{16032,17,0,32},{0,2,
0,55},{7284,2,0,32},{0,2,0,55},{15995,22,0,32},{16005,22,0,32},{64320,20,0,32},
{52736,0,0,0},{64320,20,0,32},{52876,0,0,0},{64320,20,0,32},{52745,0,0,0},
{64320,20,0,32},{55003,0,0,0},{64320,20,0,32},{52746,0,0,0},{64320,20,0,32},
{52781,0,0,0},{64320,20,0,32},{52747,0,0,0},{64320,20,0,32},{62770,0,0,0},
{64320,20,0,32},{52825,0,0,0},{64320,20,0,32},{52761,0,0,0},{64320,20,0,32},
{52737,0,0,0},{64320,20,0,32},{55593,0,0,0},{64320,20,0,32},{55088,0,0,0},
{64320,20,0,32},{52922,0,0,0},{16320,4,0,32},{0,4,0,274},{16342,4,0,32},{0,4,0,
274},{16334,4,0,32},{0,4,0,274},{16329,4,0,32},{0,4,0,274},{16353,4,0,32},{0,4,
0,274},{16349,4,0,32},{0,4,0,274},{16368,4,0,32},{0,4,0,275},{16348,4,0,32},{0,
4,0,274},{16367,4,0,32},{0,4,0,274},{16368,4,0,32},{0,4,0,274},{16354,4,0,32},
{0,4,0,274},{16356,4,0,32},{0,4,0,274},{16367,22,0,32},{0,22,0,274},{792,4,1,
32},{15628,4,0,32},{793,4,1,32},{792,4,1,32},{15630,4,0,32},{793,4,1,32},{792,4,
1,32},{15631,4,0,32},{793,4,1,32},{792,4,1,32},{15633,4,0,32},{793,4,1,32},{792,
4,1,32},{15634,4,0,32},{793,4,1,32},{792,4,1,32},{15635,4,0,32},{793,4,1,32},
{792,4,1,32},{15637,4,0,32},{793,4,1,32},{792,4,1,32},{15639,4,0,32},{793,4,1,
32},{792,4,1,32},{15640,4,0,32},{793,4,1,32},{792,4,1,32},{15642,4,0,32},{793,4,
1,32},{792,4,1,32},{15643,4,0,32},{793,4,1,32},{792,4,1,32},{15644,4,0,32},{793,
4,1,32},{792,4,1,32},{15645,4,0,32},{793,4,1,32},{792,4,1,32},{15646,4,0,32},
{793,4,1,32},{792,4,1,32},{15628,4,0,32},{15754,4,0,32},{793,4,1,32},{792,4,1,
32},{15630,4,0,32},{15754,4,0,32},{793,4,1,32},{792,4,1,32},{15631,4,0,32},
{15754,4,0,32},{793,4,1,32},{792,4,1,32},{15633,4,0,32},{15754,4,0,32},{793,4,1,
32},{792,4,1,32},{15634,4,0,32},{15754,4,0,32},{793,4,1,32},{792,4,1,32},{15635,
4,0,32},{15754,4,0,32},{793,4,1,32},{792,4,1,32},{15637,4,0,32},{15754,4,0,32},
{793,4,1,32},{792,4,1,32},{15639,4,0,32},{15754,4,0,32},{793,4,1,32},{792,4,1,
32},{15640,4,0,32},{15754,4,0,32},{793,4,1,32},{792,4,1,32},{15642,4,0,32},
{15754,4,0,32},{793,4,1,32},{792,4,1,32},{15643,4,0,32},{15754,4,0,32},{793,4,1,
32},{792,4,1,32},{15644,4,0,32},{15754,4,0,32},{793,4,1,32},{792,4,1,32},{15645,
4,0,32},{15754,4,0,32},{793,4,1,32},{792,4,1,32},{15646,4,0,32},{15754,4,0,32},
{793,4,1,32},{792,4,1,32},{15640,4,0,32},{15767,4,0,32},{793,4,1,32},{792,4,1,
32},{15639,4,0,32},{15762,4,0,32},{15640,4,0,32},{15758,4,0,32},{15851,4,0,32},
{793,4,1,32},{792,4,1,32},{15639,4,0,32},{15762,4,0,32},{15646,4,0,32},{15767,4,
0,32},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{52736,0,0,0},{793,4,1,32},{792,
4,1,32},{64320,4,0,32},{52876,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},
{52745,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{55003,0,0,0},{793,4,1,
32},{792,4,1,32},{64320,4,0,32},{52884,0,0,0},{793,4,1,32},{792,4,1,32},{64320,
4,0,32},{53613,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{52739,0,0,0},
{793,4,1,32},{792,4,1,32},{64320,4,0,32},{53611,0,0,0},{793,4,1,32},{792,4,1,
32},{64320,4,0,32},{52829,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},
{54081,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{59144,0,0,0},{793,4,1,
32},{792,4,1,32},{64320,4,0,32},{61547,0,0,0},{793,4,1,32},{792,4,1,32},{64320,
4,0,32},{60468,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{59176,0,0,0},
{793,4,1,32},{792,4,1,32},{64321,4,0,32},{37329,0,0,0},{793,4,1,32},{792,4,1,
32},{64320,4,0,32},{55071,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},
{58853,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{59434,0,0,0},{793,4,1,
32},{792,4,1,32},{64320,4,0,32},{59145,0,0,0},{793,4,1,32},{792,4,1,32},{64320,
4,0,32},{63806,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{54285,0,0,0},
{793,4,1,32},{792,4,1,32},{64320,4,0,32},{62073,0,0,0},{793,4,1,32},{792,4,1,
32},{64321,4,0,32},{36001,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},
{63837,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{53940,0,0,0},{793,4,1,
32},{792,4,1,32},{64320,4,0,32},{52963,0,0,0},{793,4,1,32},{792,4,1,32},{64320,
4,0,32},{54396,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{56166,0,0,0},
{793,4,1,32},{792,4,1,32},{64320,4,0,32},{63203,0,0,0},{793,4,1,32},{792,4,1,
32},{64320,4,0,32},{52993,0,0,0},{793,4,1,32},{792,4,1,32},{64321,4,0,32},
{36039,0,0,0},{793,4,1,32},{792,4,1,32},{64320,4,0,32},{54100,0,0,0},{793,4,1,
32},{792,4,1,32},{64320,4,0,32},{63853,0,0,0},{793,4,1,32},{792,4,1,32},{64320,
4,0,32},{53009,0,0,0},{793,4,1,32},{792,4,1,32},{64321,4,0,32},{33258,0,0,0},
{793,4,1,32},{792,4,1,32},{64321,4,0,32},{33267,0,0,0},{793,4,1,32},{64320,6,0,
32},{54607,0,0,0},{64320,6,0,32},{56956,0,0,0},{64320,6,0,32},{58759,0,0,0},
{64320,6,0,32},{64399,0,0,0},{7332,6,0,32},{7331,6,0,32},{7333,6,0,32},{7331,6,
0,32},{7334,6,0,32},{7331,6,0,32},{7335,6,0,32},{7331,6,0,32},{7336,6,0,32},
{7331,6,0,32},{7337,6,0,32},{7331,6,0,32},{7338,6,0,32},{7331,6,0,32},{7339,6,0,
32},{7331,6,0,32},{7794,29,0,32},{7931,29,0,32},{7440,29,0,32},{7333,6,0,32},
{7332,6,0,32},{7333,6,0,32},{7333,6,0,32},{7333,6,0,32},{7334,6,0,32},{7333,6,0,
32},{7335,6,0,32},{7333,6,0,32},{7336,6,0,32},{7333,6,0,32},{7337,6,0,32},{7333,
6,0,32},{7338,6,0,32},{7333,6,0,32},{7339,6,0,32},{7333,6,0,32},{7340,6,0,32},
{7334,6,0,32},{7331,6,0,32},{7334,6,0,32},{7332,6,0,32},{7334,6,0,32},{7333,6,0,
32},{7334,6,0,32},{7334,6,0,32},{7334,6,0,32},{7335,6,0,32},{7334,6,0,32},{7336,
6,0,32},{15628,6,0,32},{15754,6,0,32},{15630,6,0,32},{15754,6,0,32},{15631,6,0,
32},{15754,6,0,32},{15633,6,0,32},{15754,6,0,32},{15634,6,0,32},{15754,6,0,32},
{15635,6,0,32},{15754,6,0,32},{15637,6,0,32},{15754,6,0,32},{15639,6,0,32},
{15754,6,0,32},{15640,6,0,32},{15754,6,0,32},{15642,6,0,32},{15754,6,0,32},
{15643,6,0,32},{15754,6,0,32},{15644,6,0,32},{15754,6,0,32},{15645,6,0,32},
{15754,6,0,32},{15646,6,0,32},{15754,6,0,32},{15642,6,0,32},{15754,6,0,32},
{15863,6,0,32},{15628,6,0,32},{15762,6,0,32},{15640,6,0,32},{15767,6,0,32},
{15639,6,0,32},{15773,6,0,32},{15639,6,0,32},{15767,6,0,32},{64320,6,0,32},
{52736,0,0,0},{64320,6,0,32},{52876,0,0,0},{64320,6,0,32},{52745,0,0,0},{64320,
6,0,32},{55003,0,0,0},{64320,6,0,32},{52884,0,0,0},{64320,6,0,32},{53613,0,0,0},
{64320,6,0,32},{52739,0,0,0},{64320,6,0,32},{53611,0,0,0},{64320,6,0,32},{52829,
0,0,0},{64320,6,0,32},{54081,0,0,0},{64320,6,0,32},{59144,0,0,0},{64320,6,0,32},
{61547,0,0,0},{64320,6,0,32},{60468,0,0,0},{64320,6,0,32},{59176,0,0,0},{64321,
6,0,32},{37329,0,0,0},{64320,6,0,32},{55071,0,0,0},{64320,6,0,32},{58853,0,0,0},
{64320,6,0,32},{59434,0,0,0},{64320,6,0,32},{59145,0,0,0},{64320,6,0,32},{63806,
0,0,0},{64320,6,0,32},{54285,0,0,0},{64320,6,0,32},{62073,0,0,0},{64321,6,0,32},
{36001,0,0,0},{64320,6,0,32},{63837,0,0,0},{64320,6,0,32},{53940,0,0,0},{64320,
6,0,32},{63960,0,0,0},{64320,6,0,32},{62775,0,0,0},{64320,6,0,32},{55667,0,0,0},
{64321,6,0,32},{36969,0,0,0},{64320,6,0,32},{53546,0,0,0},{64320,6,0,32},{54128,
0,0,0},{64320,6,0,32},{60648,0,0,0},{64321,6,0,32},{38917,0,0,0},{64320,6,0,32},
{53009,0,0,0},{64320,6,0,32},{53657,0,0,0},{64320,6,0,32},{60259,0,0,0},{64320,
6,0,32},{52746,0,0,0},{64320,6,0,32},{52781,0,0,0},{64320,6,0,32},{52747,0,0,0},
{64320,6,0,32},{56806,0,0,0},{64320,6,0,32},{54259,0,0,0},{64320,6,0,32},{54075,
0,0,0},{64320,6,0,32},{56215,0,0,0},{64320,6,0,32},{56166,0,0,0},{64320,6,0,32},
{63203,0,0,0},{64320,6,0,32},{52993,0,0,0},{64321,6,0,32},{36039,0,0,0},{64320,
6,0,32},{54100,0,0,0},{64320,6,0,32},{55580,0,0,0},{7334,6,0,32},{7337,6,0,32},
{7334,6,0,32},{7338,6,0,32},{7334,6,0,32},{7339,6,0,32},{7334,6,0,32},{7340,6,0,
32},{7335,6,0,32},{7331,6,0,32},{7335,6,0,32},{7332,6,0,32},{7335,6,0,32},{7333,
6,0,32},{7335,6,0,32},{7334,6,0,32},{7335,6,0,32},{7335,6,0,32},{7335,6,0,32},
{7336,6,0,32},{7335,6,0,32},{7337,6,0,32},{7335,6,0,32},{7338,6,0,32},{7335,6,0,
32},{7339,6,0,32},{7335,6,0,32},{7340,6,0,32},{7336,6,0,32},{7331,6,0,32},{7332,
4,0,32},{64320,4,0,32},{59144,0,0,0},{7333,4,0,32},{64320,4,0,32},{59144,0,0,0},
{7334,4,0,32},{64320,4,0,32},{59144,0,0,0},{7335,4,0,32},{64320,4,0,32},{59144,
0,0,0},{7336,4,0,32},{64320,4,0,32},{59144,0,0,0},{7337,4,0,32},{64320,4,0,32},
{59144,0,0,0},{7338,4,0,32},{64320,4,0,32},{59144,0,0,0},{7339,4,0,32},{64320,4,
0,32},{59144,0,0,0},{7340,4,0,32},{64320,4,0,32},{59144,0,0,0},{7332,4,0,32},
{7331,4,0,32},{64320,4,0,32},{59144,0,0,0},{7332,4,0,32},{7332,4,0,32},{64320,4,
0,32},{59144,0,0,0},{7332,4,0,32},{7333,4,0,32},{64320,4,0,32},{59144,0,0,0},
{7550,29,0,32},{7514,28,0,32},{7440,28,0,32},{7833,28,0,32},{7514,28,0,32},
{7440,28,0,32},{8009,29,0,32},{7645,29,0,32},{7931,29,0,32},{7413,29,0,32},
{15985,28,0,32},{16011,28,0,32},{0,28,0,56},{7283,28,0,32},{16005,28,0,32},
{15985,28,0,32},{16026,28,0,32},{16013,28,0,32},{15985,28,0,32},{15985,28,0,32},
{16033,28,0,32},{16014,28,0,32},{0,28,0,56},{15985,28,0,32},{15985,28,0,32},
{7283,28,0,32},{16026,28,0,32},{15986,28,0,32},{16007,28,0,32},{16033,28,0,32},
{15993,28,0,32},{0,28,0,55},{15986,28,0,32},{16033,28,0,32},{16002,28,0,32},
{15987,28,0,32},{15990,28,0,32},{16033,28,0,32},{15989,28,0,32},{15998,28,0,32},
{15993,28,0,32},{7283,28,0,32},{16005,28,0,32},{0,28,0,55},{15989,28,0,32},
{7283,28,0,32},{15991,28,0,32},{7283,28,0,32},{15990,28,0,32},{16033,28,0,32},
{15998,28,0,32},{15990,28,0,32},{7283,28,0,32},{16018,28,0,32},{15991,28,0,32},
{15986,28,0,32},{16025,28,0,32},{15991,28,0,32},{16024,28,0,32},{16003,28,0,32},
{16005,28,0,32},{15991,28,0,32},{16028,28,0,32},{16025,28,0,32},{7283,28,0,32},
{15991,28,0,32},{0,28,0,55},{16028,28,0,32},{16033,28,0,32},{15991,28,0,32},{0,
28,0,55},{16033,28,0,32},{16016,28,0,32},{15992,28,0,32},{0,28,0,55},{15991,28,
0,32},{0,28,0,55},{15992,28,0,32},{0,28,0,55},{16007,28,0,32},{7283,28,0,32},
{15992,28,0,32},{16022,28,0,32},{16025,28,0,32},{7283,28,0,32},{15992,28,0,32},
{0,28,0,55},{16026,28,0,32},{16001,28,0,32},{0,28,0,55},{7283,28,0,32},{15992,
28,0,32},{16028,28,0,32},{15992,28,0,32},{16028,28,0,32},{15993,28,0,32},{0,28,
0,55},{16024,28,0,32},{16018,28,0,32},{15992,28,0,32},{16028,28,0,32},{16019,28,
0,32},{7283,28,0,32},{16005,28,0,32},{16026,28,0,32},{15992,28,0,32},{16028,28,
0,32},{16029,28,0,32},{16003,28,0,32},{16005,28,0,32},{15993,28,0,32},{0,28,0,
55},{16024,28,0,32},{16018,28,0,32},{15993,28,0,32},{0,28,0,55},{16024,28,0,32},
{16018,28,0,32},{16005,28,0,32},{16033,28,0,32},{15993,28,0,32},{16026,28,0,32},
{15999,28,0,32},{0,28,0,55},{15986,28,0,32},{16028,28,0,32},{15993,28,0,32},
{16028,28,0,32},{7283,28,0,32},{16009,28,0,32},{15994,28,0,32},{7283,28,0,32},
{15998,28,0,32},{15995,28,0,32},{16026,28,0,32},{16006,28,0,32},{15995,28,0,32},
{7283,28,0,32},{16015,28,0,32},{0,28,0,56},{15996,28,0,32},{15986,28,0,32},
{15993,28,0,32},{16026,28,0,32},{15996,28,0,32},{16033,28,0,32},{16002,28,0,32},
{7283,28,0,32},{16018,28,0,32},{15997,28,0,32},{16025,28,0,32},{16033,28,0,32},
{15993,28,0,32},{0,28,0,55},{15999,28,0,32},{16033,28,0,32},{16002,28,0,32},
{15999,28,0,32},{16033,28,0,32},{16005,28,0,32},{16001,28,0,32},{0,28,0,55},
{7283,28,0,32},{15998,28,0,32},{16004,28,0,32},{0,28,0,55},{15997,28,0,32},
{16005,28,0,32},{0,28,0,55},{16026,28,0,32},{16005,28,0,32},{16033,28,0,32},
{16006,28,0,32},{16010,28,0,32},{16010,28,0,32},{16003,28,0,32},{16005,28,0,32},
{16011,28,0,32},{15986,28,0,32},{16003,28,0,32},{16011,28,0,32},{0,28,0,56},
{7283,28,0,32},{15999,28,0,32},{16033,28,0,32},{16005,28,0,32},{16011,28,0,32},
{0,28,0,56},{7283,28,0,32},{16003,28,0,32},{16011,28,0,32},{0,28,0,55},{7283,28,
0,32},{16027,28,0,32},{16026,28,0,32},{16012,28,0,32},{0,28,0,56},{15985,28,0,
32},{15998,28,0,32},{16005,28,0,32},{16026,28,0,32},{16012,28,0,32},{0,28,0,56},
{15993,28,0,32},{16026,28,0,32},{16012,28,0,32},{0,28,0,56},{15995,28,0,32},
{16012,28,0,32},{0,28,0,55},{16026,28,0,32},{16013,28,0,32},{15985,28,0,32},
{16024,28,0,32},{16003,28,0,32},{16005,28,0,32},{0,28,0,55},{16013,28,0,32},
{15986,28,0,32},{7283,28,0,32},{16005,28,0,32},{16013,28,0,32},{0,28,0,55},
{16003,28,0,32},{15997,28,0,32},{15989,28,0,32},{16026,28,0,32},{16013,28,0,32},
{16024,28,0,32},{16033,28,0,32},{16014,28,0,32},{15993,28,0,32},{16001,28,0,32},
{7283,28,0,32},{16026,28,0,32},{16014,28,0,32},{0,28,0,56},{16000,28,0,32},
{16014,28,0,32},{0,28,0,56},{16007,28,0,32},{16012,28,0,32},{16014,28,0,32},
{16026,28,0,32},{16003,28,0,32},{16014,28,0,32},{0,28,0,56},{16033,28,0,32},
{15998,28,0,32},{16014,28,0,32},{0,28,0,56},{7283,28,0,32},{15997,28,0,32},{0,
28,0,55},{16014,28,0,32},{0,28,0,55},{7283,28,0,32},{16001,28,0,32},{16015,28,0,
32},{0,28,0,56},{15986,28,0,32},{16033,28,0,32},{16005,28,0,32},{16015,28,0,32},
{0,28,0,55},{16026,28,0,32},{16005,28,0,32},{16015,28,0,32},{16033,28,0,32},
{16015,28,0,32},{0,28,0,56},{16033,28,0,32},{16005,28,0,32},{0,28,0,55},{16015,
28,0,32},{7283,28,0,32},{16026,28,0,32},{16015,28,0,32},{7283,28,0,32},{16033,
28,0,32},{16016,28,0,32},{15986,28,0,32},{15993,28,0,32},{16028,28,0,32},{16016,
28,0,32},{15986,28,0,32},{16026,28,0,32},{16016,28,0,32},{16003,28,0,32},{16011,
28,0,32},{16016,28,0,32},{16026,28,0,32},{15993,28,0,32},{16016,28,0,32},{16033,
28,0,32},{15997,28,0,32},{16023,28,0,32},{16033,28,0,32},{16017,28,0,32},{15993,
28,0,32},{16028,28,0,32},{16033,28,0,32},{16017,28,0,32},{16025,28,0,32},{16017,
28,0,32},{16025,28,0,32},{16011,28,0,32},{0,28,0,55},{7283,28,0,32},{16026,28,0,
32},{16019,28,0,32},{15991,28,0,32},{0,28,0,55},{16019,28,0,32},{15991,28,0,32},
{0,28,0,55},{16005,28,0,32},{16033,28,0,32},{16019,28,0,32},{7283,28,0,32},
{16005,28,0,32},{16026,28,0,32},{16021,28,0,32},{7283,28,0,32},{16005,28,0,32},
{0,28,0,55},{16021,28,0,32},{7283,28,0,32},{16026,28,0,32},{16022,28,0,32},
{15985,28,0,32},{16033,28,0,32},{16025,28,0,32},{16003,28,0,32},{16005,28,0,32},
{16026,28,0,32},{16025,28,0,32},{16024,28,0,32},{16026,28,0,32},{16012,28,0,32},
{0,28,0,56},{7283,28,0,32},{16026,28,0,32},{7283,28,0,32},{16013,28,0,32},{0,28,
0,55},{16026,28,0,32},{16027,28,0,32},{16018,28,0,32},{16027,28,0,32},{16033,28,
0,32},{16005,28,0,32},{15994,28,0,32},{0,28,0,55},{16033,28,0,32},{16029,28,0,
32},{16003,28,0,32},{16005,28,0,32},{7331,4,0,32},{64320,4,0,32},{61625,0,0,0},
{7332,4,0,32},{64320,4,0,32},{61625,0,0,0},{7333,4,0,32},{64320,4,0,32},{61625,
0,0,0},{7334,4,0,32},{64320,4,0,32},{61625,0,0,0},{7335,4,0,32},{64320,4,0,32},
{61625,0,0,0},{7336,4,0,32},{64320,4,0,32},{61625,0,0,0},{7337,4,0,32},{64320,4,
0,32},{61625,0,0,0},{7338,4,0,32},{64320,4,0,32},{61625,0,0,0},{7339,4,0,32},
{64320,4,0,32},{61625,0,0,0},{7340,4,0,32},{64320,4,0,32},{61625,0,0,0},{7332,4,
0,32},{7331,4,0,32},{64320,4,0,32},{61625,0,0,0},{7332,4,0,32},{7332,4,0,32},
{64320,4,0,32},{61625,0,0,0},{7332,4,0,32},{7333,4,0,32},{64320,4,0,32},{61625,
0,0,0},{7332,4,0,32},{7334,4,0,32},{64320,4,0,32},{61625,0,0,0},{7332,4,0,32},
{7335,4,0,32},{64320,4,0,32},{61625,0,0,0},{7332,4,0,32},{7336,4,0,32},{64320,4,
0,32},{61625,0,0,0},{7332,4,0,32},{7337,4,0,32},{64320,4,0,32},{61625,0,0,0},
{7332,4,0,32},{7338,4,0,32},{64320,4,0,32},{61625,0,0,0},{7332,4,0,32},{7339,4,
0,32},{64320,4,0,32},{61625,0,0,0},{7332,4,0,32},{7340,4,0,32},{64320,4,0,32},
{61625,0,0,0},{7333,4,0,32},{7331,4,0,32},{64320,4,0,32},{61625,0,0,0},{7333,4,
0,32},{7332,4,0,32},{64320,4,0,32},{61625,0,0,0},{7333,4,0,32},{7333,4,0,32},
{64320,4,0,32},{61625,0,0,0},{7333,4,0,32},{7334,4,0,32},{64320,4,0,32},{61625,
0,0,0},{7333,4,0,32},{7335,4,0,32},{64320,4,0,32},{61625,0,0,0},{7550,28,0,32},
{7794,29,0,32},{7341,28,0,32},{7413,28,0,32},{7341,28,0,32},{7341,29,0,32},
{7963,29,0,32},{7366,28,0,32},{7341,28,0,32},{7833,28,0,32},{7747,28,0,32},
{8009,29,0,32},{7794,28,0,32},{7392,28,0,32},{7413,28,0,32},{7696,28,0,32},
{7413,28,0,32},{7696,28,0,32},{7333,28,0,32},{7413,28,0,32},{7696,28,0,32},
{7334,28,0,32},{7576,29,0,32},{7963,29,0,32},{64320,28,0,32},{56947,0,0,0},
{64320,28,0,32},{57872,0,0,0},{64320,28,0,32},{58925,0,0,0},{64320,28,0,32},
{54412,0,0,0},{64320,28,0,32},{55591,0,0,0},{64320,28,0,32},{60259,0,0,0},
{64320,28,0,32},{58894,0,0,0},{64320,28,0,32},{60603,0,0,0},{64320,28,0,32},
{59434,0,0,0},{64320,28,0,32},{57103,0,0,0},{64320,28,0,32},{53018,0,0,0},
{64320,28,0,32},{63806,0,0,0},{7794,28,0,32},{7341,29,0,32},{7711,28,0,32},
{7341,29,0,32},{8241,28,0,32},{7341,29,0,32},{7696,28,0,32},{7341,29,0,32},
{7627,28,0,32},{7341,29,0,32},{7627,29,0,32},{7366,29,0,32},{7696,29,0,32},
{7366,29,0,32},{7514,29,0,32},{7366,29,0,32},{7392,28,0,32},{7341,28,0,32},
{7645,28,0,32},{7627,28,0,32},{7392,28,0,32},{7341,28,0,32},{7645,28,0,32},
{7794,28,0,32},{7499,29,0,32},{7711,28,0,32},{7499,29,0,32},{8241,28,0,32},
{7499,29,0,32},{8241,28,0,32},{7514,28,0,32},{7696,28,0,32},{7514,28,0,32},
{7627,28,0,32},{7514,28,0,32},{7550,29,0,32},{8071,28,0,32},{7627,28,0,32},
{7550,29,0,32},{8071,28,0,32},{7696,29,0,32},{7550,29,0,32},{8071,28,0,32},
{7514,29,0,32},{7550,29,0,32},{8071,28,0,32},{7931,29,0,32},{7550,29,0,32},
{8071,28,0,32},{8241,28,0,32},{7645,28,0,32},{7696,28,0,32},{7645,28,0,32},
{7413,28,0,32},{7645,28,0,32},{7627,28,0,32},{7645,28,0,32},{7499,28,0,32},
{7696,28,0,32},{7711,28,0,32},{7696,28,0,32},{8241,28,0,32},{7696,28,0,32},
{7696,28,0,32},{7696,28,0,32},{7392,28,0,32},{7696,28,0,32},{7627,28,0,32},
{7696,28,0,32},{7696,28,0,32},{7696,28,0,32},{7333,28,0,32},{7392,28,0,32},
{7696,28,0,32},{7333,28,0,32},{7696,28,0,32},{7333,28,0,32},{7627,28,0,32},
{7696,28,0,32},{7333,28,0,32},{7696,28,0,32},{7696,28,0,32},{7334,28,0,32},
{7392,28,0,32},{7696,28,0,32},{7334,28,0,32},{7696,28,0,32},{7334,28,0,32},
{7627,28,0,32},{7696,28,0,32},{7334,28,0,32},{7696,28,0,32},{1595,28,1,32},
{7895,28,0,32},{7696,28,0,32},{1595,28,1,32},{7895,28,0,32},{7333,28,0,32},
{7794,29,0,32},{7341,28,0,32},{7627,28,0,32},{7794,29,0,32},{7341,28,0,32},
{7696,29,0,32},{7794,29,0,32},{7341,28,0,32},{7514,29,0,32},{7794,29,0,32},
{7341,28,0,32},{7833,28,0,32},{7341,28,0,32},{7413,28,0,32},{7833,28,0,32},
{7341,28,0,32},{7413,28,0,32},{1595,28,1,32},{7895,28,0,32},{7833,28,0,32},
{7341,28,0,32},{7413,28,0,32},{1595,28,1,32},{7895,28,0,32},{7333,28,0,32},
{7794,28,0,32},{7895,28,0,32},{7711,28,0,32},{7895,28,0,32},{8241,28,0,32},
{7895,28,0,32},{7696,28,0,32},{7895,28,0,32},{7794,28,0,32},{8009,29,0,32},
{7711,28,0,32},{8009,29,0,32},{8241,28,0,32},{8009,29,0,32},{7696,28,0,32},
{8009,29,0,32},{7627,28,0,32},{8009,29,0,32},{7696,29,0,32},{8009,29,0,32},
{7794,28,0,32},{8027,29,0,32},{7711,28,0,32},{8027,29,0,32},{8241,28,0,32},
{8027,29,0,32},{7696,28,0,32},{8027,29,0,32},{7627,28,0,32},{8027,29,0,32},
{7696,29,0,32},{8027,29,0,32},{7627,28,0,32},{8263,29,0,32},{7696,29,0,32},
{8263,29,0,32},{7341,28,0,32},{632,28,1,32},{7696,28,0,32},{632,28,1,32},{7366,
29,0,32},{7815,28,0,32},{7392,28,0,32},{7392,28,0,32},{7392,28,0,32},{7413,28,0,
32},{7392,29,0,32},{1595,28,1,32},{7627,28,0,32},{7514,28,0,32},{7392,29,0,32},
{7747,28,0,32},{632,28,1,32},{7413,28,0,32},{7366,29,0,32},{7514,29,0,32},{8049,
28,0,32},{7550,28,0,32},{7341,28,0,32},{7550,29,0,32},{7794,29,0,32},{7576,28,0,
32},{7711,28,0,32},{7627,29,0,32},{7627,29,0,32},{7627,29,0,32},{7696,29,0,32},
{7627,28,0,32},{7931,28,0,32},{7645,28,0,32},{7696,28,0,32},{7645,28,0,32},
{7711,28,0,32},{7645,28,0,32},{7747,28,0,32},{7514,28,0,32},{7645,28,0,32},
{8037,28,0,32},{7696,28,0,32},{7366,28,0,32},{7696,28,0,32},{7576,28,0,32},
{7645,28,0,32},{7696,28,0,32},{7747,28,0,32},{7645,28,0,32},{7794,29,0,32},
{7550,29,0,32},{7794,28,0,32},{632,28,1,32},{7696,28,0,32},{632,28,1,32},{7794,
29,0,32},{7794,29,0,32},{7696,29,0,32},{7794,29,0,32},{7833,29,0,32},{7895,28,0,
32},{7833,28,0,32},{7895,29,0,32},{8009,28,0,32},{8027,29,0,32},{7366,28,0,32},
{8009,29,0,32},{1595,28,1,32},{7696,28,0,32},{7341,29,0,32},{1595,28,1,32},
{7696,28,0,32},{7332,4,0,32},{64320,4,0,32},{58853,0,0,0},{7333,4,0,32},{64320,
4,0,32},{58853,0,0,0},{7334,4,0,32},{64320,4,0,32},{58853,0,0,0},{7335,4,0,32},
{64320,4,0,32},{58853,0,0,0},{7336,4,0,32},{64320,4,0,32},{58853,0,0,0},{7337,4,
0,32},{64320,4,0,32},{58853,0,0,0},{7338,4,0,32},{64320,4,0,32},{58853,0,0,0},
{7339,4,0,32},{64320,4,0,32},{58853,0,0,0},{7340,4,0,32},{64320,4,0,32},{58853,
0,0,0},{7332,4,0,32},{7331,4,0,32},{64320,4,0,32},{58853,0,0,0},{7332,4,0,32},
{7332,4,0,32},{64320,4,0,32},{58853,0,0,0},{7332,4,0,32},{7333,4,0,32},{64320,4,
0,32},{58853,0,0,0},{7332,4,0,32},{7334,4,0,32},{64320,4,0,32},{58853,0,0,0},
{7332,4,0,32},{7335,4,0,32},{64320,4,0,32},{58853,0,0,0},{7332,4,0,32},{7336,4,
0,32},{64320,4,0,32},{58853,0,0,0},{7332,4,0,32},{7337,4,0,32},{64320,4,0,32},
{58853,0,0,0},{7332,4,0,32},{7338,4,0,32},{64320,4,0,32},{58853,0,0,0},{7332,4,
0,32},{7339,4,0,32},{64320,4,0,32},{58853,0,0,0},{7332,4,0,32},{7340,4,0,32},
{64320,4,0,32},{58853,0,0,0},{7333,4,0,32},{7331,4,0,32},{64320,4,0,32},{58853,
0,0,0},{7333,4,0,32},{7332,4,0,32},{64320,4,0,32},{58853,0,0,0},{7333,4,0,32},
{7333,4,0,32},{64320,4,0,32},{58853,0,0,0},{7333,4,0,32},{7334,4,0,32},{64320,4,
0,32},{58853,0,0,0},{7333,4,0,32},{7335,4,0,32},{64320,4,0,32},{58853,0,0,0},
{7333,4,0,32},{7336,4,0,32},{64320,4,0,32},{58853,0,0,0},{7333,4,0,32},{7337,4,
0,32},{64320,4,0,32},{58853,0,0,0},{7333,4,0,32},{7338,4,0,32},{64320,4,0,32},
{58853,0,0,0},{7333,4,0,32},{7339,4,0,32},{64320,4,0,32},{58853,0,0,0},{7333,4,
0,32},{7340,4,0,32},{64320,4,0,32},{58853,0,0,0},{7334,4,0,32},{7331,4,0,32},
{64320,4,0,32},{58853,0,0,0},{7334,4,0,32},{7332,4,0,32},{64320,4,0,32},{58853,
0,0,0},{7514,28,0,32},{7341,28,0,32},{7645,28,0,32},{64384,2,0,32},{46238,0,0,
0},{64384,2,0,32},{46265,0,0,0},{64384,2,0,32},{46267,0,0,0},{64384,2,0,32},
{46303,0,0,0},{64384,2,0,32},{46357,0,0,0},{64384,2,0,32},{46830,0,0,0},{64384,
2,0,32},{46844,0,0,0},{64384,2,0,32},{46977,0,0,0},{64384,2,0,32},{47151,0,0,0},
{64384,2,0,32},{47202,0,0,0},{64384,2,0,32},{47228,0,0,0},{64384,2,0,32},{47303,
0,0,0},{64384,2,0,32},{47331,0,0,0},{64384,2,0,32},{47388,0,0,0},{64384,2,0,32},
{47418,0,0,0},{64384,2,0,32},{47662,0,0,0},{64384,2,0,32},{47724,0,0,0},{64384,
2,0,32},{47844,0,0,0},{64384,2,0,32},{47880,0,0,0},{64384,2,0,32},{47897,0,0,0},
{64384,2,0,32},{47945,0,0,0},{64384,2,0,32},{48029,0,0,0},{64384,2,0,32},{48152,
0,0,0},{64384,2,0,32},{48206,0,0,0},{64384,2,0,32},{48435,0,0,0},{64384,2,0,32},
{48534,0,0,0},{64384,2,0,32},{48812,0,0,0},{64384,2,0,32},{48824,0,0,0},{64384,
2,0,32},{48923,0,0,0},{64384,2,0,32},{49148,0,0,0},{64384,2,0,32},{49160,0,0,0},
{64384,2,0,32},{49176,0,0,0},{64384,2,0,32},{49209,0,0,0},{64384,2,0,32},{49222,
0,0,0},{64384,2,0,32},{49302,0,0,0},{64384,2,0,32},{49379,0,0,0},{64384,2,0,32},
{49455,0,0,0},{64384,2,0,32},{49666,0,0,0},{64384,2,0,32},{49703,0,0,0},{64384,
2,0,32},{49824,0,0,0},{64384,2,0,32},{49921,0,0,0},{64384,2,0,32},{49972,0,0,0},
{64384,2,0,32},{50009,0,0,0},{64384,2,0,32},{50133,0,0,0},{64384,2,0,32},{50137,
0,0,0},{64384,2,0,32},{50187,0,0,0},{64384,2,0,32},{50283,0,0,0},{64384,2,0,32},
{50475,0,0,0},{64384,2,0,32},{50525,0,0,0},{64384,2,0,32},{50529,0,0,0},{64384,
2,0,32},{50539,0,0,0},{64384,2,0,32},{50647,0,0,0},{64384,2,0,32},{50681,0,0,0},
{64384,2,0,32},{50741,0,0,0},{64384,2,0,32},{50878,0,0,0},{64384,2,0,32},{50887,
0,0,0},{64384,2,0,32},{51605,0,0,0},{64384,2,0,32},{51686,0,0,0},{64384,2,0,32},
{51822,0,0,0},{64384,2,0,32},{51830,0,0,0},{64384,2,0,32},{51890,0,0,0},{64384,
2,0,32},{52019,0,0,0},{64384,2,0,32},{52174,0,0,0},{64384,2,0,32},{52430,0,0,0},
{64384,2,0,32},{52461,0,0,0},{64384,2,0,32},{52472,0,0,0},{64384,2,0,32},{52566,
0,0,0},{64320,2,0,32},{52749,0,0,0},{64320,2,0,32},{52774,0,0,0},{64320,2,0,32},
{52786,0,0,0},{64320,2,0,32},{52792,0,0,0},{64320,2,0,32},{52793,0,0,0},{64320,
2,0,32},{52797,0,0,0},{64320,2,0,32},{52801,0,0,0},{64320,2,0,32},{52866,0,0,0},
{64320,2,0,32},{52870,0,0,0},{64320,2,0,32},{52910,0,0,0},{64320,2,0,32},{52928,
0,0,0},{64320,2,0,32},{52940,0,0,0},{64320,2,0,32},{52964,0,0,0},{64320,2,0,32},
{53088,0,0,0},{64320,2,0,32},{53120,0,0,0},{64320,2,0,32},{53126,0,0,0},{64320,
2,0,32},{53131,0,0,0},{64320,2,0,32},{53166,0,0,0},{64320,2,0,32},{53179,0,0,0},
{64320,2,0,32},{53183,0,0,0},{64320,2,0,32},{53250,0,0,0},{64320,2,0,32},{53291,
0,0,0},{64320,2,0,32},{53370,0,0,0},{64320,2,0,32},{53401,0,0,0},{64320,2,0,32},
{53455,0,0,0},{64320,2,0,32},{53466,0,0,0},{64320,2,0,32},{53479,0,0,0},{64320,
2,0,32},{53568,0,0,0},{64320,2,0,32},{53573,0,0,0},{64320,2,0,32},{53581,0,0,0},
{64320,2,0,32},{53588,0,0,0},{64320,2,0,32},{53604,0,0,0},{64320,2,0,32},{53607,
0,0,0},{64320,2,0,32},{53608,0,0,0},{64320,2,0,32},{53609,0,0,0},{64320,2,0,32},
{53613,0,0,0},{64320,2,0,32},{53623,0,0,0},{64320,2,0,32},{53632,0,0,0},{64320,
2,0,32},{53645,0,0,0},{64320,2,0,32},{53650,0,0,0},{64320,2,0,32},{53653,0,0,0},
{64320,2,0,32},{53655,0,0,0},{64320,2,0,32},{53668,0,0,0},{64320,2,0,32},{53676,
0,0,0},{64320,2,0,32},{53685,0,0,0},{64320,2,0,32},{53687,0,0,0},{64320,2,0,32},
{53705,0,0,0},{64320,2,0,32},{53708,0,0,0},{64320,2,0,32},{53724,0,0,0},{64320,
2,0,32},{53726,0,0,0},{64320,2,0,32},{53749,0,0,0},{64320,2,0,32},{53763,0,0,0},
{64320,2,0,32},{53767,0,0,0},{64320,2,0,32},{53783,0,0,0},{64320,2,0,32},{53801,
0,0,0},{64320,2,0,32},{53818,0,0,0},{64320,2,0,32},{53819,0,0,0},{64320,2,0,32},
{53830,0,0,0},{64320,2,0,32},{53874,0,0,0},{64320,2,0,32},{53879,0,0,0},{64320,
2,0,32},{53897,0,0,0},{64320,2,0,32},{53915,0,0,0},{64320,2,0,32},{53923,0,0,0},
{64320,2,0,32},{53939,0,0,0},{64320,2,0,32},{53959,0,0,0},{64320,2,0,32},{53961,
0,0,0},{64320,2,0,32},{53970,0,0,0},{64320,2,0,32},{53982,0,0,0},{64320,2,0,32},
{53988,0,0,0},{64320,2,0,32},{54005,0,0,0},{64320,2,0,32},{54010,0,0,0},{64320,
2,0,32},{54021,0,0,0},{64320,2,0,32},{54022,0,0,0},{64320,2,0,32},{54039,0,0,0},
{64320,2,0,32},{54079,0,0,0},{64320,2,0,32},{54089,0,0,0},{64320,2,0,32},{54097,
0,0,0},{64320,2,0,32},{54106,0,0,0},{64320,2,0,32},{54131,0,0,0},{64320,2,0,32},
{54133,0,0,0},{64320,2,0,32},{54141,0,0,0},{64320,2,0,32},{54143,0,0,0},{64320,
2,0,32},{54211,0,0,0},{64320,2,0,32},{54218,0,0,0},{64320,2,0,32},{54239,0,0,0},
{64320,2,0,32},{54245,0,0,0},{64320,2,0,32},{54251,0,0,0},{64320,2,0,32},{54257,
0,0,0},{64320,2,0,32},{54278,0,0,0},{64320,2,0,32},{54287,0,0,0},{64320,2,0,32},
{54301,0,0,0},{64320,2,0,32},{54328,0,0,0},{64320,2,0,32},{54338,0,0,0},{64320,
2,0,32},{54344,0,0,0},{64320,2,0,32},{54376,0,0,0},{64320,2,0,32},{54430,0,0,0},
{64320,2,0,32},{54434,0,0,0},{64320,2,0,32},{54461,0,0,0},{64320,2,0,32},{54518,
0,0,0},{64320,2,0,32},{54544,0,0,0},{64320,2,0,32},{54611,0,0,0},{64320,2,0,32},
{54613,0,0,0},{64320,2,0,32},{54627,0,0,0},{64320,2,0,32},{54660,0,0,0},{64320,
2,0,32},{54663,0,0,0},{64320,2,0,32},{54681,0,0,0},{64320,2,0,32},{54685,0,0,0},
{64320,2,0,32},{54699,0,0,0},{64320,2,0,32},{54707,0,0,0},{64320,2,0,32},{54720,
0,0,0},{64320,2,0,32},{54722,0,0,0},{64320,2,0,32},{54754,0,0,0},{64320,2,0,32},
{54790,0,0,0},{64320,2,0,32},{54865,0,0,0},{64320,2,0,32},{54888,0,0,0},{64320,
2,0,32},{54900,0,0,0},{64320,2,0,32},{55033,0,0,0},{64320,2,0,32},{55062,0,0,0},
{64320,2,0,32},{55063,0,0,0},{64320,2,0,32},{55179,0,0,0},{64320,2,0,32},{55246,
0,0,0},{64320,2,0,32},{55284,0,0,0},{64320,2,0,32},{55309,0,0,0},{64320,2,0,32},
{55345,0,0,0},{64320,2,0,32},{55346,0,0,0},{64320,2,0,32},{55360,0,0,0},{64320,
2,0,32},{55386,0,0,0},{64320,2,0,32},{55390,0,0,0},{64320,2,0,32},{55464,0,0,0},
{64320,2,0,32},{55468,0,0,0},{64320,2,0,32},{55475,0,0,0},{64320,2,0,32},{55512,
0,0,0},{64320,2,0,32},{55519,0,0,0},{64320,2,0,32},{55534,0,0,0},{64320,2,0,32},
{55538,0,0,0},{64320,2,0,32},{55543,0,0,0},{64320,2,0,32},{55558,0,0,0},{64320,
2,0,32},{55578,0,0,0},{64320,2,0,32},{55586,0,0,0},{64320,2,0,32},{55620,0,0,0},
{64320,2,0,32},{55624,0,0,0},{64320,2,0,32},{55633,0,0,0},{64320,2,0,32},{55636,
0,0,0},{64320,2,0,32},{55650,0,0,0},{64320,2,0,32},{55667,0,0,0},{64320,2,0,32},
{55768,0,0,0},{64320,2,0,32},{55788,0,0,0},{64320,2,0,32},{55835,0,0,0},{64320,
2,0,32},{55847,0,0,0},{64320,2,0,32},{55906,0,0,0},{64320,2,0,32},{55910,0,0,0},
{64320,2,0,32},{55989,0,0,0},{64320,2,0,32},{56072,0,0,0},{64320,2,0,32},{56104,
0,0,0},{64320,2,0,32},{56126,0,0,0},{64320,2,0,32},{56197,0,0,0},{64320,2,0,32},
{56259,0,0,0},{64320,2,0,32},{56280,0,0,0},{64320,2,0,32},{56295,0,0,0},{64320,
2,0,32},{56302,0,0,0},{64320,2,0,32},{56307,0,0,0},{64320,2,0,32},{56319,0,0,0},
{64320,2,0,32},{56326,0,0,0},{64320,2,0,32},{56354,0,0,0},{64320,2,0,32},{56383,
0,0,0},{64320,2,0,32},{56416,0,0,0},{64320,2,0,32},{56418,0,0,0},{64320,2,0,32},
{56420,0,0,0},{64320,2,0,32},{56421,0,0,0},{64320,2,0,32},{56430,0,0,0},{64320,
2,0,32},{56461,0,0,0},{64320,2,0,32},{56512,0,0,0},{64320,2,0,32},{56601,0,0,0},
{64320,2,0,32},{56643,0,0,0},{64320,2,0,32},{56656,0,0,0},{64320,2,0,32},{56683,
0,0,0},{64320,2,0,32},{56686,0,0,0},{64320,2,0,32},{56700,0,0,0},{64320,2,0,32},
{56754,0,0,0},{64320,2,0,32},{56762,0,0,0},{64320,2,0,32},{56801,0,0,0},{64320,
2,0,32},{56802,0,0,0},{64320,2,0,32},{56829,0,0,0},{64320,2,0,32},{56872,0,0,0},
{64320,2,0,32},{56893,0,0,0},{64320,2,0,32},{56937,0,0,0},{64320,2,0,32},{56948,
0,0,0},{64320,2,0,32},{56998,0,0,0},{64320,2,0,32},{57008,0,0,0},{64320,2,0,32},
{57011,0,0,0},{64320,2,0,32},{57014,0,0,0},{64320,2,0,32},{57033,0,0,0},{64320,
2,0,32},{57034,0,0,0},{64320,2,0,32},{57042,0,0,0},{64320,2,0,32},{57043,0,0,0},
{64320,2,0,32},{57049,0,0,0},{64320,2,0,32},{57068,0,0,0},{64320,2,0,32},{57086,
0,0,0},{64320,2,0,32},{57092,0,0,0},{64320,2,0,32},{57122,0,0,0},{64320,2,0,32},
{57171,0,0,0},{64320,2,0,32},{57186,0,0,0},{64320,2,0,32},{57193,0,0,0},{64320,
2,0,32},{57195,0,0,0},{64320,2,0,32},{57227,0,0,0},{64320,2,0,32},{57242,0,0,0},
{64320,2,0,32},{57257,0,0,0},{64320,2,0,32},{57261,0,0,0},{64320,2,0,32},{57293,
0,0,0},{64320,2,0,32},{57303,0,0,0},{64320,2,0,32},{57333,0,0,0},{64320,2,0,32},
{57337,0,0,0},{64320,2,0,32},{57362,0,0,0},{64320,2,0,32},{57372,0,0,0},{64320,
2,0,32},{57461,0,0,0},{64320,2,0,32},{57473,0,0,0},{64320,2,0,32},{57492,0,0,0},
{64320,2,0,32},{57543,0,0,0},{64320,2,0,32},{57560,0,0,0},{64320,2,0,32},{57569,
0,0,0},{64320,2,0,32},{57608,0,0,0},{64320,2,0,32},{57668,0,0,0},{64320,2,0,32},
{57672,0,0,0},{64320,2,0,32},{57676,0,0,0},{64320,2,0,32},{57678,0,0,0},{64320,
2,0,32},{57696,0,0,0},{64320,2,0,32},{57704,0,0,0},{64320,2,0,32},{57722,0,0,0},
{64320,2,0,32},{57742,0,0,0},{64320,2,0,32},{57744,0,0,0},{64320,2,0,32},{57764,
0,0,0},{64320,2,0,32},{57775,0,0,0},{64320,2,0,32},{57778,0,0,0},{64320,2,0,32},
{57822,0,0,0},{64320,2,0,32},{57842,0,0,0},{64320,2,0,32},{57846,0,0,0},{64320,
2,0,32},{57856,0,0,0},{64320,2,0,32},{57872,0,0,0},{64320,2,0,32},{57883,0,0,0},
{64320,2,0,32},{57902,0,0,0},{64320,2,0,32},{57908,0,0,0},{64320,2,0,32},{57949,
0,0,0},{64320,2,0,32},{58033,0,0,0},{64320,2,0,32},{58057,0,0,0},{64320,2,0,32},
{58063,0,0,0},{64320,2,0,32},{58067,0,0,0},{64320,2,0,32},{58068,0,0,0},{64320,
2,0,32},{58108,0,0,0},{64320,2,0,32},{58110,0,0,0},{64320,2,0,32},{58173,0,0,0},
{64320,2,0,32},{58192,0,0,0},{64320,2,0,32},{58216,0,0,0},{64320,2,0,32},{58235,
0,0,0},{64320,2,0,32},{58243,0,0,0},{64320,2,0,32},{58272,0,0,0},{64320,2,0,32},
{58281,0,0,0},{64320,2,0,32},{58308,0,0,0},{64320,2,0,32},{58309,0,0,0},{64320,
2,0,32},{58340,0,0,0},{64320,2,0,32},{58396,0,0,0},{64320,2,0,32},{58402,0,0,0},
{64320,2,0,32},{58450,0,0,0},{64320,2,0,32},{58473,0,0,0},{64320,2,0,32},{58487,
0,0,0},{64320,2,0,32},{58494,0,0,0},{64320,2,0,32},{58522,0,0,0},{64320,2,0,32},
{58525,0,0,0},{64320,2,0,32},{58564,0,0,0},{64320,2,0,32},{58703,0,0,0},{64320,
2,0,32},{58710,0,0,0},{64320,2,0,32},{58732,0,0,0},{64320,2,0,32},{58744,0,0,0},
{64320,2,0,32},{58777,0,0,0},{64320,2,0,32},{58821,0,0,0},{64320,2,0,32},{58850,
0,0,0},{64320,2,0,32},{58851,0,0,0},{64320,2,0,32},{58899,0,0,0},{64320,2,0,32},
{58953,0,0,0},{64320,2,0,32},{58996,0,0,0},{64320,2,0,32},{59016,0,0,0},{64320,
2,0,32},{59025,0,0,0},{64320,2,0,32},{59036,0,0,0},{64320,2,0,32},{59060,0,0,0},
{64320,2,0,32},{59078,0,0,0},{64320,2,0,32},{59124,0,0,0},{64320,2,0,32},{59128,
0,0,0},{64320,2,0,32},{59136,0,0,0},{64320,2,0,32},{59159,0,0,0},{64320,2,0,32},
{59163,0,0,0},{64320,2,0,32},{59169,0,0,0},{64320,2,0,32},{59214,0,0,0},{64320,
2,0,32},{59219,0,0,0},{64320,2,0,32},{59222,0,0,0},{64320,2,0,32},{59230,0,0,0},
{64320,2,0,32},{59259,0,0,0},{64320,2,0,32},{59269,0,0,0},{64320,2,0,32},{59287,
0,0,0},{64320,2,0,32},{59379,0,0,0},{64320,2,0,32},{59386,0,0,0},{64320,2,0,32},
{59415,0,0,0},{64320,2,0,32},{59423,0,0,0},{64320,2,0,32},{59474,0,0,0},{64320,
2,0,32},{59521,0,0,0},{64320,2,0,32},{59525,0,0,0},{64320,2,0,32},{59534,0,0,0},
{64320,2,0,32},{59560,0,0,0},{64320,2,0,32},{59668,0,0,0},{64320,2,0,32},{59714,
0,0,0},{64320,2,0,32},{59811,0,0,0},{64320,2,0,32},{59882,0,0,0},{64320,2,0,32},
{59906,0,0,0},{64320,2,0,32},{59923,0,0,0},{64320,2,0,32},{60072,0,0,0},{64320,
2,0,32},{60115,0,0,0},{64320,2,0,32},{60123,0,0,0},{64320,2,0,32},{60164,0,0,0},
{64320,2,0,32},{60193,0,0,0},{64320,2,0,32},{60244,0,0,0},{64320,2,0,32},{60274,
0,0,0},{64320,2,0,32},{60279,0,0,0},{64320,2,0,32},{60281,0,0,0},{64320,2,0,32},
{60319,0,0,0},{64320,2,0,32},{60334,0,0,0},{64320,2,0,32},{60346,0,0,0},{64320,
2,0,32},{60347,0,0,0},{64320,2,0,32},{60494,0,0,0},{64320,2,0,32},{60519,0,0,0},
{64320,2,0,32},{60552,0,0,0},{64320,2,0,32},{60607,0,0,0},{64320,2,0,32},{60620,
0,0,0},{64320,2,0,32},{60621,0,0,0},{64320,2,0,32},{60645,0,0,0},{64320,2,0,32},
{60694,0,0,0},{64320,2,0,32},{60699,0,0,0},{64320,2,0,32},{60702,0,0,0},{64320,
2,0,32},{60724,0,0,0},{64320,2,0,32},{60734,0,0,0},{64320,2,0,32},{60737,0,0,0},
{64320,2,0,32},{60777,0,0,0},{64320,2,0,32},{60778,0,0,0},{64320,2,0,32},{60791,
0,0,0},{64320,2,0,32},{60792,0,0,0},{64320,2,0,32},{60805,0,0,0},{64320,2,0,32},
{60875,0,0,0},{64320,2,0,32},{60890,0,0,0},{64320,2,0,32},{60906,0,0,0},{64320,
2,0,32},{60921,0,0,0},{64320,2,0,32},{60954,0,0,0},{64320,2,0,32},{60975,0,0,0},
{64320,2,0,32},{61038,0,0,0},{64320,2,0,32},{61084,0,0,0},{64320,2,0,32},{61114,
0,0,0},{64320,2,0,32},{61127,0,0,0},{64320,2,0,32},{61131,0,0,0},{64320,2,0,32},
{61137,0,0,0},{64320,2,0,32},{61147,0,0,0},{64320,2,0,32},{61199,0,0,0},{64320,
2,0,32},{61218,0,0,0},{64320,2,0,32},{61219,0,0,0},{64320,2,0,32},{61294,0,0,0},
{64320,2,0,32},{61382,0,0,0},{64320,2,0,32},{61419,0,0,0},{64320,2,0,32},{61438,
0,0,0},{64320,2,0,32},{61467,0,0,0},{64320,2,0,32},{61470,0,0,0},{64320,2,0,32},
{61497,0,0,0},{64320,2,0,32},{61514,0,0,0},{64320,2,0,32},{61552,0,0,0},{64320,
2,0,32},{61559,0,0,0},{64320,2,0,32},{61565,0,0,0},{64320,2,0,32},{61593,0,0,0},
{64320,2,0,32},{61613,0,0,0},{64320,2,0,32},{61640,0,0,0},{64320,2,0,32},{61657,
0,0,0},{64320,2,0,32},{61765,0,0,0},{64320,2,0,32},{61769,0,0,0},{64320,2,0,32},
{61806,0,0,0},{64320,2,0,32},{61852,0,0,0},{64320,2,0,32},{61902,0,0,0},{64320,
2,0,32},{61904,0,0,0},{64320,2,0,32},{61968,0,0,0},{64320,2,0,32},{61979,0,0,0},
{64320,2,0,32},{61992,0,0,0},{64320,2,0,32},{61995,0,0,0},{64320,2,0,32},{62005,
0,0,0},{64320,2,0,32},{62032,0,0,0},{64320,2,0,32},{62050,0,0,0},{64320,2,0,32},
{62080,0,0,0},{64320,2,0,32},{62101,0,0,0},{64320,2,0,32},{62127,0,0,0},{64320,
2,0,32},{62144,0,0,0},{64320,2,0,32},{62204,0,0,0},{64320,2,0,32},{62250,0,0,0},
{64320,2,0,32},{62325,0,0,0},{64320,2,0,32},{62330,0,0,0},{64320,2,0,32},{62343,
0,0,0},{64320,2,0,32},{62347,0,0,0},{64320,2,0,32},{62373,0,0,0},{64320,2,0,32},
{62386,0,0,0},{64320,2,0,32},{62430,0,0,0},{64320,2,0,32},{62470,0,0,0},{64320,
2,0,32},{62473,0,0,0},{64320,2,0,32},{62498,0,0,0},{64320,2,0,32},{62535,0,0,0},
{64320,2,0,32},{62556,0,0,0},{64320,2,0,32},{62569,0,0,0},{64320,2,0,32},{62577,
0,0,0},{64320,2,0,32},{62597,0,0,0},{64320,2,0,32},{62601,0,0,0},{64320,2,0,32},
{62616,0,0,0},{64320,2,0,32},{62666,0,0,0},{64320,2,0,32},{62726,0,0,0},{64320,
2,0,32},{62756,0,0,0},{64320,2,0,32},{62779,0,0,0},{64320,2,0,32},{62782,0,0,0},
{64320,2,0,32},{62809,0,0,0},{64320,2,0,32},{62821,0,0,0},{64320,2,0,32},{62832,
0,0,0},{64320,2,0,32},{62946,0,0,0},{64320,2,0,32},{62992,0,0,0},{64320,2,0,32},
{63005,0,0,0},{64320,2,0,32},{63007,0,0,0},{64320,2,0,32},{63042,0,0,0},{64320,
2,0,32},{63081,0,0,0},{64320,2,0,32},{63178,0,0,0},{64320,2,0,32},{63195,0,0,0},
{64320,2,0,32},{63207,0,0,0},{64320,2,0,32},{63220,0,0,0},{64320,2,0,32},{63233,
0,0,0},{64320,2,0,32},{63262,0,0,0},{64320,2,0,32},{63263,0,0,0},{64320,2,0,32},
{63296,0,0,0},{64320,2,0,32},{63306,0,0,0},{64320,2,0,32},{63371,0,0,0},{64320,
2,0,32},{63399,0,0,0},{64320,2,0,32},{63566,0,0,0},{64320,2,0,32},{63595,0,0,0},
{64320,2,0,32},{63628,0,0,0},{64320,2,0,32},{63633,0,0,0},{64320,2,0,32},{63690,
0,0,0},{64320,2,0,32},{63692,0,0,0},{64320,2,0,32},{63739,0,0,0},{64320,2,0,32},
{63786,0,0,0},{64320,2,0,32},{63804,0,0,0},{64320,2,0,32},{63806,0,0,0},{64320,
2,0,32},{63816,0,0,0},{64320,2,0,32},{63817,0,0,0},{64320,2,0,32},{63824,0,0,0},
{64320,2,0,32},{63830,0,0,0},{64320,2,0,32},{63837,0,0,0},{64320,2,0,32},{63838,
0,0,0},{64320,2,0,32},{63845,0,0,0},{64320,2,0,32},{63871,0,0,0},{64320,2,0,32},
{63885,0,0,0},{64320,2,0,32},{63886,0,0,0},{64320,2,0,32},{63887,0,0,0},{64320,
2,0,32},{63918,0,0,0},{64320,2,0,32},{63946,0,0,0},{64320,2,0,32},{63979,0,0,0},
{64320,2,0,32},{64028,0,0,0},{64320,2,0,32},{64064,0,0,0},{64320,2,0,32},{64074,
0,0,0},{64320,2,0,32},{64079,0,0,0},{64320,2,0,32},{64129,0,0,0},{64320,2,0,32},
{64177,0,0,0},{64320,2,0,32},{64203,0,0,0},{64320,2,0,32},{64238,0,0,0},{64320,
2,0,32},{64288,0,0,0},{64320,2,0,32},{64448,0,0,0},{64320,2,0,32},{64454,0,0,0},
{64320,2,0,32},{64457,0,0,0},{64320,2,0,32},{64574,0,0,0},{64320,2,0,32},{64608,
0,0,0},{64320,2,0,32},{64635,0,0,0},{64320,2,0,32},{64658,0,0,0},{64320,2,0,32},
{64702,0,0,0},{64320,2,0,32},{64722,0,0,0},{64320,2,0,32},{64726,0,0,0},{64320,
2,0,32},{64739,0,0,0},{64320,2,0,32},{64743,0,0,0},{64320,2,0,32},{64744,0,0,0},
{64320,2,0,32},{64768,0,0,0},{64320,2,0,32},{64784,0,0,0},{64320,2,0,32},{64802,
0,0,0},{64320,2,0,32},{64815,0,0,0},{64320,2,0,32},{64859,0,0,0},{64320,2,0,32},
{64867,0,0,0},{64320,2,0,32},{64928,0,0,0},{64320,2,0,32},{64958,0,0,0},{64320,
2,0,32},{64967,0,0,0},{64320,2,0,32},{65012,0,0,0},{64320,2,0,32},{65026,0,0,0},
{64320,2,0,32},{65033,0,0,0},{64320,2,0,32},{65079,0,0,0},{64320,2,0,32},{65089,
0,0,0},{64320,2,0,32},{65093,0,0,0},{64320,2,0,32},{65342,0,0,0},{64320,2,0,32},
{65394,0,0,0},{64320,2,0,32},{65401,0,0,0},{64320,2,0,32},{65402,0,0,0},{64320,
2,0,32},{65413,0,0,0},{64320,2,0,32},{65429,0,0,0},{64320,2,0,32},{65434,0,0,0},
{64320,2,0,32},{65469,0,0,0},{64320,2,0,32},{65530,0,0,0},{64321,2,0,32},{32769,
0,0,0},{64321,2,0,32},{32773,0,0,0},{64321,2,0,32},{32838,0,0,0},{64321,2,0,32},
{32864,0,0,0},{64321,2,0,32},{32879,0,0,0},{64321,2,0,32},{32880,0,0,0},{64321,
2,0,32},{32894,0,0,0},{64321,2,0,32},{32907,0,0,0},{64321,2,0,32},{32941,0,0,0},
{64321,2,0,32},{32946,0,0,0},{64321,2,0,32},{33027,0,0,0},{64321,2,0,32},{33086,
0,0,0},{64321,2,0,32},{33240,0,0,0},{64321,2,0,32},{33256,0,0,0},{64321,2,0,32},
{33261,0,0,0},{64321,2,0,32},{33281,0,0,0},{64321,2,0,32},{33284,0,0,0},{64321,
2,0,32},{33304,0,0,0},{64321,2,0,32},{33391,0,0,0},{64321,2,0,32},{33401,0,0,0},
{64321,2,0,32},{33419,0,0,0},{64321,2,0,32},{33425,0,0,0},{64321,2,0,32},{33437,
0,0,0},{64321,2,0,32},{33457,0,0,0},{64321,2,0,32},{33459,0,0,0},{64321,2,0,32},
{33469,0,0,0},{64321,2,0,32},{33509,0,0,0},{64321,2,0,32},{33510,0,0,0},{64321,
2,0,32},{33565,0,0,0},{64321,2,0,32},{33571,0,0,0},{64321,2,0,32},{33590,0,0,0},
{64321,2,0,32},{33618,0,0,0},{64321,2,0,32},{33619,0,0,0},{64321,2,0,32},{33635,
0,0,0},{64321,2,0,32},{33709,0,0,0},{64321,2,0,32},{33725,0,0,0},{64321,2,0,32},
{33737,0,0,0},{64321,2,0,32},{33738,0,0,0},{64321,2,0,32},{33740,0,0,0},{64321,
2,0,32},{33756,0,0,0},{64321,2,0,32},{33767,0,0,0},{64321,2,0,32},{33775,0,0,0},
{64321,2,0,32},{33777,0,0,0},{64321,2,0,32},{33853,0,0,0},{64321,2,0,32},{33865,
0,0,0},{64321,2,0,32},{33879,0,0,0},{64321,2,0,32},{34030,0,0,0},{64321,2,0,32},
{34033,0,0,0},{64321,2,0,32},{34035,0,0,0},{64321,2,0,32},{34044,0,0,0},{64321,
2,0,32},{34070,0,0,0},{64321,2,0,32},{34148,0,0,0},{64321,2,0,32},{34253,0,0,0},
{64321,2,0,32},{34298,0,0,0},{64321,2,0,32},{34310,0,0,0},{64321,2,0,32},{34322,
0,0,0},{64321,2,0,32},{34349,0,0,0},{64321,2,0,32},{34367,0,0,0},{64321,2,0,32},
{34384,0,0,0},{64321,2,0,32},{34396,0,0,0},{64321,2,0,32},{34407,0,0,0},{64321,
2,0,32},{34409,0,0,0},{64321,2,0,32},{34440,0,0,0},{64321,2,0,32},{34473,0,0,0},
{64321,2,0,32},{34530,0,0,0},{64321,2,0,32},{34574,0,0,0},{64321,2,0,32},{34600,
0,0,0},{64321,2,0,32},{34667,0,0,0},{64321,2,0,32},{34681,0,0,0},{64321,2,0,32},
{34694,0,0,0},{64321,2,0,32},{34746,0,0,0},{64321,2,0,32},{34785,0,0,0},{64321,
2,0,32},{34817,0,0,0},{64321,2,0,32},{34847,0,0,0},{64321,2,0,32},{34892,0,0,0},
{64321,2,0,32},{34912,0,0,0},{64321,2,0,32},{34915,0,0,0},{64321,2,0,32},{35010,
0,0,0},{64321,2,0,32},{35023,0,0,0},{64321,2,0,32},{35031,0,0,0},{64321,2,0,32},
{35038,0,0,0},{64321,2,0,32},{35041,0,0,0},{64321,2,0,32},{35064,0,0,0},{64321,
2,0,32},{35066,0,0,0},{64321,2,0,32},{35088,0,0,0},{64321,2,0,32},{35137,0,0,0},
{64321,2,0,32},{35172,0,0,0},{64321,2,0,32},{35206,0,0,0},{64321,2,0,32},{35211,
0,0,0},{64321,2,0,32},{35222,0,0,0},{64321,2,0,32},{35488,0,0,0},{64321,2,0,32},
{35498,0,0,0},{64321,2,0,32},{35519,0,0,0},{64321,2,0,32},{35531,0,0,0},{64321,
2,0,32},{35538,0,0,0},{64321,2,0,32},{35542,0,0,0},{64321,2,0,32},{35565,0,0,0},
{64321,2,0,32},{35576,0,0,0},{64321,2,0,32},{35582,0,0,0},{64321,2,0,32},{35585,
0,0,0},{64321,2,0,32},{35641,0,0,0},{64321,2,0,32},{35672,0,0,0},{64321,2,0,32},
{35712,0,0,0},{64321,2,0,32},{35722,0,0,0},{64321,2,0,32},{35912,0,0,0},{64321,
2,0,32},{35925,0,0,0},{64321,2,0,32},{36011,0,0,0},{64321,2,0,32},{36033,0,0,0},
{64321,2,0,32},{36034,0,0,0},{64321,2,0,32},{36040,0,0,0},{64321,2,0,32},{36051,
0,0,0},{64321,2,0,32},{36104,0,0,0},{64321,2,0,32},{36123,0,0,0},{64321,2,0,32},
{36215,0,0,0},{64321,2,0,32},{36284,0,0,0},{64321,2,0,32},{36299,0,0,0},{64321,
2,0,32},{36335,0,0,0},{64321,2,0,32},{36336,0,0,0},{64321,2,0,32},{36554,0,0,0},
{64321,2,0,32},{36564,0,0,0},{64321,2,0,32},{36646,0,0,0},{64321,2,0,32},{36650,
0,0,0},{64321,2,0,32},{36664,0,0,0},{64321,2,0,32},{36667,0,0,0},{64321,2,0,32},
{36706,0,0,0},{64321,2,0,32},{36766,0,0,0},{64321,2,0,32},{36784,0,0,0},{64321,
2,0,32},{36790,0,0,0},{64321,2,0,32},{36899,0,0,0},{64321,2,0,32},{36920,0,0,0},
{64321,2,0,32},{36978,0,0,0},{64321,2,0,32},{36988,0,0,0},{64321,2,0,32},{37007,
0,0,0},{64321,2,0,32},{37012,0,0,0},{64321,2,0,32},{37070,0,0,0},{64321,2,0,32},
{37086,0,0,0},{64321,2,0,32},{37105,0,0,0},{64321,2,0,32},{37117,0,0,0},{64321,
2,0,32},{37137,0,0,0},{64321,2,0,32},{37147,0,0,0},{64321,2,0,32},{37226,0,0,0},
{64321,2,0,32},{37273,0,0,0},{64321,2,0,32},{37300,0,0,0},{64321,2,0,32},{37324,
0,0,0},{64321,2,0,32},{37327,0,0,0},{64321,2,0,32},{37329,0,0,0},{64321,2,0,32},
{37428,0,0,0},{64321,2,0,32},{37432,0,0,0},{64321,2,0,32},{37494,0,0,0},{64321,
2,0,32},{37500,0,0,0},{64321,2,0,32},{37591,0,0,0},{64321,2,0,32},{37592,0,0,0},
{64321,2,0,32},{37636,0,0,0},{64321,2,0,32},{37706,0,0,0},{64321,2,0,32},{37881,
0,0,0},{64321,2,0,32},{37909,0,0,0},{64321,2,0,32},{38283,0,0,0},{64321,2,0,32},
{38317,0,0,0},{64321,2,0,32},{38327,0,0,0},{64321,2,0,32},{38446,0,0,0},{64321,
2,0,32},{38475,0,0,0},{64321,2,0,32},{38477,0,0,0},{64321,2,0,32},{38517,0,0,0},
{64321,2,0,32},{38520,0,0,0},{64321,2,0,32},{38524,0,0,0},{64321,2,0,32},{38534,
0,0,0},{64321,2,0,32},{38563,0,0,0},{64321,2,0,32},{38583,0,0,0},{64321,2,0,32},
{38584,0,0,0},{64321,2,0,32},{38595,0,0,0},{64321,2,0,32},{38626,0,0,0},{64321,
2,0,32},{38627,0,0,0},{64321,2,0,32},{38646,0,0,0},{64321,2,0,32},{38647,0,0,0},
{64321,2,0,32},{38691,0,0,0},{64321,2,0,32},{38706,0,0,0},{64321,2,0,32},{38728,
0,0,0},{64321,2,0,32},{38742,0,0,0},{64321,2,0,32},{38875,0,0,0},{64321,2,0,32},
{38880,0,0,0},{64321,2,0,32},{38911,0,0,0},{64321,2,0,32},{38923,0,0,0},{64321,
2,0,32},{38936,0,0,0},{64321,2,0,32},{38953,0,0,0},{64321,2,0,32},{38971,0,0,0},
{64321,2,0,32},{39006,0,0,0},{64321,2,0,32},{39138,0,0,0},{64321,2,0,32},{39151,
0,0,0},{64321,2,0,32},{39164,0,0,0},{64321,2,0,32},{39208,0,0,0},{64321,2,0,32},
{39209,0,0,0},{64321,2,0,32},{39335,0,0,0},{64321,2,0,32},{39362,0,0,0},{64321,
2,0,32},{39409,0,0,0},{64321,2,0,32},{39422,0,0,0},{64321,2,0,32},{39530,0,0,0},
{64321,2,0,32},{39698,0,0,0},{64321,2,0,32},{39791,0,0,0},{64321,2,0,32},{40000,
0,0,0},{64321,2,0,32},{40023,0,0,0},{64321,2,0,32},{40189,0,0,0},{64321,2,0,32},
{40295,0,0,0},{64321,2,0,32},{40372,0,0,0},{64321,2,0,32},{40442,0,0,0},{64321,
2,0,32},{40478,0,0,0},{64321,2,0,32},{40575,0,0,0},{64321,2,0,32},{40599,0,0,0},
{64321,2,0,32},{40607,0,0,0},{64321,2,0,32},{40635,0,0,0},{64321,2,0,32},{40654,
0,0,0},{64321,2,0,32},{40697,0,0,0},{64321,2,0,32},{40702,0,0,0},{64321,2,0,32},
{40709,0,0,0},{64321,2,0,32},{40719,0,0,0},{64321,2,0,32},{40726,0,0,0},{64321,
2,0,32},{40763,0,0,0},{64321,2,0,32},{40771,0,0,0},{64321,2,0,32},{40845,0,0,0},
{64321,2,0,32},{40846,0,0,0},{64321,2,0,32},{40860,0,0,0},{14461,4,0,32},{14716,
4,0,32},{14479,4,0,32},{14716,4,0,32},{14500,4,0,32},{14716,4,0,32},{14520,4,0,
32},{14717,4,0,32},{14531,4,0,32},{14716,4,0,32},{14537,4,0,32},{14717,4,0,32},
{14539,4,0,32},{14717,4,0,32},{14545,4,0,32},{14716,4,0,32},{14582,4,0,32},
{14716,4,0,32},{14629,4,0,32},{14716,4,0,32},{14652,4,0,32},{14716,4,0,32},
{14658,4,0,32},{14717,4,0,32},{14665,4,0,32},{14716,4,0,32},{8430,4,0,32},{0,4,
0,43},{7931,10,0,32},{8071,4,0,32},{7931,4,0,32},{8071,4,0,32},{7341,10,0,32},
{7341,10,0,32},{7341,4,0,32},{7341,4,0,32},{7341,10,0,32},{7747,10,0,32},{7341,
4,0,32},{7747,4,0,32},{7341,10,0,32},{7963,10,0,32},{7341,4,0,32},{7963,4,0,32},
{7341,10,0,32},{8009,10,0,32},{7341,4,0,32},{8009,4,0,32},{7341,10,0,32},{0,4,0,
273},{8009,10,0,32},{7341,4,0,32},{0,4,0,273},{8009,4,0,32},{7341,10,0,32},
{8049,10,0,32},{7341,4,0,32},{8049,4,0,32},{7747,10,0,32},{7747,10,0,32},{7747,
4,0,32},{7747,4,0,32},{8009,10,0,32},{8049,10,0,32},{8009,4,0,32},{8049,4,0,32},
{7413,10,0,32},{0,4,0,274},{7413,4,0,32},{0,4,0,274},{7499,10,0,32},{0,4,0,274},
{7499,4,0,32},{0,4,0,274},{7514,10,0,32},{0,4,0,274},{7833,10,0,32},{0,4,0,274},
{7833,4,0,32},{0,4,0,274},{7895,10,0,32},{0,4,0,274},{7895,4,0,32},{0,4,0,274},
{7931,10,0,32},{0,4,0,274},{7931,4,0,32},{0,4,0,274},{7341,10,0,32},{0,4,0,43},
{7341,4,0,32},{0,4,0,43},{7747,10,0,32},{0,4,0,43},{7747,4,0,32},{0,4,0,43},
{7963,10,0,32},{0,4,0,43},{7963,4,0,32},{0,4,0,43},{7514,10,0,32},{0,4,0,53},
{7514,4,0,32},{0,4,0,53},{7627,10,0,32},{0,4,0,53},{7627,4,0,32},{0,4,0,53},
{7711,10,0,32},{0,4,0,53},{7711,4,0,32},{0,4,0,53},{7833,10,0,32},{0,4,0,53},
{7833,4,0,32},{0,4,0,53},{7895,10,0,32},{0,4,0,53},{7895,4,0,32},{0,4,0,53},
{7550,20,0,32},{0,20,0,57},{7747,20,0,32},{0,20,0,273},{7440,20,0,32},{11920,2,
0,32},{11973,2,0,32},{11921,2,0,32},{11973,2,0,32},{11922,2,0,32},{11973,2,0,
32},{11923,2,0,32},{11973,2,0,32},{11924,2,0,32},{11973,2,0,32},{11925,2,0,32},
{11973,2,0,32},{11926,2,0,32},{11973,2,0,32},{11927,2,0,32},{11973,2,0,32},
{11928,2,0,32},{11973,2,0,32},{11929,2,0,32},{11973,2,0,32},{11930,2,0,32},
{11973,2,0,32},{11931,2,0,32},{11973,2,0,32},{11932,2,0,32},{11973,2,0,32},
{11933,2,0,32},{11973,2,0,32},{11934,2,0,32},{11973,2,0,32},{11935,2,0,32},
{11973,2,0,32},{11936,2,0,32},{11973,2,0,32},{11937,2,0,32},{11973,2,0,32},
{11938,2,0,32},{11973,2,0,32},{11939,2,0,32},{11973,2,0,32},{11940,2,0,32},
{11973,2,0,32},{11941,2,0,32},{11973,2,0,32},{11942,2,0,32},{11973,2,0,32},
{11943,2,0,32},{11973,2,0,32},{11944,2,0,32},{11973,2,0,32},{11945,2,0,32},
{11973,2,0,32},{11946,2,0,32},{11973,2,0,32},{11947,2,0,32},{11973,2,0,32},
{11948,2,0,32},{11973,2,0,32},{11949,2,0,32},{11973,2,0,32},{11950,2,0,32},
{11973,2,0,32},{11951,2,0,32},{11973,2,0,32},{11952,2,0,32},{11973,2,0,32},
{11953,2,0,32},{11973,2,0,32},{11954,2,0,32},{11973,2,0,32},{11955,2,0,32},
{11973,2,0,32},{11956,2,0,32},{11973,2,0,32},{11957,2,0,32},{11973,2,0,32},
{11958,2,0,32},{11973,2,0,32},{11959,2,0,32},{11973,2,0,32},{11960,2,0,32},
{11973,2,0,32},{11961,2,0,32},{11973,2,0,32},{11962,2,0,32},{11973,2,0,32},
{11963,2,0,32},{11973,2,0,32},{11964,2,0,32},{11973,2,0,32},{11965,2,0,32},
{11973,2,0,32},{11966,2,0,32},{11973,2,0,32},{11967,2,0,32},{11973,2,0,32},
{11920,2,0,32},{11974,2,0,32},{11921,2,0,32},{11974,2,0,32},{11922,2,0,32},
{11974,2,0,32},{11923,2,0,32},{11974,2,0,32},{11924,2,0,32},{11974,2,0,32},
{11925,2,0,32},{11974,2,0,32},{11926,2,0,32},{11974,2,0,32},{11927,2,0,32},
{11974,2,0,32},{11928,2,0,32},{11974,2,0,32},{11929,2,0,32},{11974,2,0,32},
{11930,2,0,32},{11974,2,0,32},{11931,2,0,32},{11974,2,0,32},{11932,2,0,32},
{11974,2,0,32},{11933,2,0,32},{11974,2,0,32},{11934,2,0,32},{11974,2,0,32},
{11935,2,0,32},{11974,2,0,32},{11936,2,0,32},{11974,2,0,32},{11937,2,0,32},
{11974,2,0,32},{11938,2,0,32},{11974,2,0,32},{11939,2,0,32},{11974,2,0,32},
{11940,2,0,32},{11974,2,0,32},{11941,2,0,32},{11974,2,0,32},{11942,2,0,32},
{11974,2,0,32},{11943,2,0,32},{11974,2,0,32},{11944,2,0,32},{11974,2,0,32},
{11945,2,0,32},{11974,2,0,32},{11946,2,0,32},{11974,2,0,32},{11947,2,0,32},
{11974,2,0,32},{11948,2,0,32},{11974,2,0,32},{11949,2,0,32},{11974,2,0,32},
{11950,2,0,32},{11974,2,0,32},{11951,2,0,32},{11974,2,0,32},{11952,2,0,32},
{11974,2,0,32},{11953,2,0,32},{11974,2,0,32},{11954,2,0,32},{11974,2,0,32},
{11955,2,0,32},{11974,2,0,32},{11956,2,0,32},{11974,2,0,32},{11957,2,0,32},
{11974,2,0,32},{11958,2,0,32},{11974,2,0,32},{11959,2,0,32},{11974,2,0,32},
{11960,2,0,32},{11974,2,0,32},{11961,2,0,32},{11974,2,0,32},{11962,2,0,32},
{11974,2,0,32},{11963,2,0,32},{11974,2,0,32},{11964,2,0,32},{11974,2,0,32},
{11965,2,0,32},{11974,2,0,32},{11966,2,0,32},{11974,2,0,32},{11967,2,0,32},
{11974,2,0,32},{11920,2,0,32},{11977,2,0,32},{11921,2,0,32},{11977,2,0,32},
{11922,2,0,32},{11977,2,0,32},{11923,2,0,32},{11977,2,0,32},{11924,2,0,32},
{11977,2,0,32},{11925,2,0,32},{11977,2,0,32},{11926,2,0,32},{11977,2,0,32},
{11927,2,0,32},{11977,2,0,32},{11928,2,0,32},{11977,2,0,32},{11929,2,0,32},
{11977,2,0,32},{11930,2,0,32},{11977,2,0,32},{11931,2,0,32},{11977,2,0,32},
{11932,2,0,32},{11977,2,0,32},{11933,2,0,32},{11977,2,0,32},{11934,2,0,32},
{11977,2,0,32},{11935,2,0,32},{11977,2,0,32},{11936,2,0,32},{11977,2,0,32},
{11937,2,0,32},{11977,2,0,32},{11938,2,0,32},{11977,2,0,32},{11939,2,0,32},
{11977,2,0,32},{11940,2,0,32},{11977,2,0,32},{11941,2,0,32},{11977,2,0,32},
{11942,2,0,32},{11977,2,0,32},{11943,2,0,32},{11977,2,0,32},{11944,2,0,32},
{11977,2,0,32},{11945,2,0,32},{11977,2,0,32},{11946,2,0,32},{11977,2,0,32},
{11947,2,0,32},{11977,2,0,32},{11948,2,0,32},{11977,2,0,32},{11949,2,0,32},
{11977,2,0,32},{11950,2,0,32},{11977,2,0,32},{11951,2,0,32},{11977,2,0,32},
{11952,2,0,32},{11977,2,0,32},{11953,2,0,32},{11977,2,0,32},{11954,2,0,32},
{11977,2,0,32},{11955,2,0,32},{11977,2,0,32},{11956,2,0,32},{11977,2,0,32},
{11957,2,0,32},{11977,2,0,32},{11958,2,0,32},{11977,2,0,32},{11959,2,0,32},
{11977,2,0,32},{11960,2,0,32},{11977,2,0,32},{11961,2,0,32},{11977,2,0,32},
{11962,2,0,32},{11977,2,0,32},{11963,2,0,32},{11977,2,0,32},{11964,2,0,32},
{11977,2,0,32},{11965,2,0,32},{11977,2,0,32},{11966,2,0,32},{11977,2,0,32},
{11967,2,0,32},{11977,2,0,32},{11920,2,0,32},{11979,2,0,32},{11921,2,0,32},
{11979,2,0,32},{11922,2,0,32},{11979,2,0,32},{11923,2,0,32},{11979,2,0,32},
{11924,2,0,32},{11979,2,0,32},{11925,2,0,32},{11979,2,0,32},{11926,2,0,32},
{11979,2,0,32},{11927,2,0,32},{11979,2,0,32},{11928,2,0,32},{11979,2,0,32},
{11929,2,0,32},{11979,2,0,32},{11930,2,0,32},{11979,2,0,32},{11931,2,0,32},
{11979,2,0,32},{11932,2,0,32},{11979,2,0,32},{11933,2,0,32},{11979,2,0,32},
{11934,2,0,32},{11979,2,0,32},{11935,2,0,32},{11979,2,0,32},{11936,2,0,32},
{11979,2,0,32},{11937,2,0,32},{11979,2,0,32},{11938,2,0,32},{11979,2,0,32},
{11939,2,0,32},{11979,2,0,32},{11940,2,0,32},{11979,2,0,32},{11941,2,0,32},
{11979,2,0,32},{11942,2,0,32},{11979,2,0,32},{11943,2,0,32},{11979,2,0,32},
{11944,2,0,32},{11979,2,0,32},{11945,2,0,32},{11979,2,0,32},{11946,2,0,32},
{11979,2,0,32},{11947,2,0,32},{11979,2,0,32},{11948,2,0,32},{11979,2,0,32},
{11949,2,0,32},{11979,2,0,32},{11950,2,0,32},{11979,2,0,32},{11951,2,0,32},
{11979,2,0,32},{11952,2,0,32},{11979,2,0,32},{11953,2,0,32},{11979,2,0,32},
{11954,2,0,32},{11979,2,0,32},{11955,2,0,32},{11979,2,0,32},{11956,2,0,32},
{11979,2,0,32},{11957,2,0,32},{11979,2,0,32},{11958,2,0,32},{11979,2,0,32},
{11959,2,0,32},{11979,2,0,32},{11960,2,0,32},{11979,2,0,32},{11961,2,0,32},
{11979,2,0,32},{11962,2,0,32},{11979,2,0,32},{11963,2,0,32},{11979,2,0,32},
{11964,2,0,32},{11979,2,0,32},{11965,2,0,32},{11979,2,0,32},{11966,2,0,32},
{11979,2,0,32},{11967,2,0,32},{11979,2,0,32},{11920,2,0,32},{11980,2,0,32},
{11921,2,0,32},{11980,2,0,32},{11922,2,0,32},{11980,2,0,32},{11923,2,0,32},
{11980,2,0,32},{11924,2,0,32},{11980,2,0,32},{11925,2,0,32},{11980,2,0,32},
{11926,2,0,32},{11980,2,0,32},{11927,2,0,32},{11980,2,0,32},{11928,2,0,32},
{11980,2,0,32},{11929,2,0,32},{11980,2,0,32},{11930,2,0,32},{11980,2,0,32},
{11931,2,0,32},{11980,2,0,32},{11932,2,0,32},{11980,2,0,32},{11933,2,0,32},
{11980,2,0,32},{11934,2,0,32},{11980,2,0,32},{11935,2,0,32},{11980,2,0,32},
{11936,2,0,32},{11980,2,0,32},{11937,2,0,32},{11980,2,0,32},{11938,2,0,32},
{11980,2,0,32},{11939,2,0,32},{11980,2,0,32},{11940,2,0,32},{11980,2,0,32},
{11941,2,0,32},{11980,2,0,32},{11942,2,0,32},{11980,2,0,32},{11943,2,0,32},
{11980,2,0,32},{11944,2,0,32},{11980,2,0,32},{11945,2,0,32},{11980,2,0,32},
{11946,2,0,32},{11980,2,0,32},{11947,2,0,32},{11980,2,0,32},{11948,2,0,32},
{11980,2,0,32},{11949,2,0,32},{11980,2,0,32},{11950,2,0,32},{11980,2,0,32},
{11951,2,0,32},{11980,2,0,32},{11952,2,0,32},{11980,2,0,32},{11953,2,0,32},
{11980,2,0,32},{11954,2,0,32},{11980,2,0,32},{11955,2,0,32},{11980,2,0,32},
{11956,2,0,32},{11980,2,0,32},{11957,2,0,32},{11980,2,0,32},{11958,2,0,32},
{11980,2,0,32},{11959,2,0,32},{11980,2,0,32},{11960,2,0,32},{11980,2,0,32},
{11961,2,0,32},{11980,2,0,32},{11962,2,0,32},{11980,2,0,32},{11963,2,0,32},
{11980,2,0,32},{11964,2,0,32},{11980,2,0,32},{11965,2,0,32},{11980,2,0,32},
{11966,2,0,32},{11980,2,0,32},{11967,2,0,32},{11980,2,0,32},{64321,2,0,32},
{64014,0,0,0},{64321,2,0,32},{64015,0,0,0},{64321,2,0,32},{64017,0,0,0},{64321,
2,0,32},{64019,0,0,0},{64321,2,0,32},{64020,0,0,0},{64321,2,0,32},{64031,0,0,0},
{64321,2,0,32},{64033,0,0,0},{64321,2,0,32},{64035,0,0,0},{64321,2,0,32},{64036,
0,0,0},{64321,2,0,32},{64039,0,0,0},{64321,2,0,32},{64040,0,0,0},{64321,2,0,32},
{64041,0,0,0},{7499,4,0,32},{7499,4,0,32},{7499,4,0,32},{7576,4,0,32},{7499,4,0,
32},{7645,4,0,32},{7499,4,0,32},{7499,4,0,32},{7576,4,0,32},{7499,4,0,32},{7499,
4,0,32},{7645,4,0,32},{7895,4,0,32},{0,4,0,274},{7931,4,0,32},{7895,4,0,32},
{7931,4,0,32},{8969,4,0,32},{8971,4,0,32},{8969,4,0,32},{8954,4,0,32},{8969,4,0,
32},{8960,4,0,32},{8979,4,0,32},{8971,4,0,32},{8969,4,0,32},{8962,4,0,32},{8989,
4,0,32},{9000,4,0,32},{9244,26,0,32},{0,26,0,131},{9244,25,0,32},{0,25,0,131},
{9274,26,0,32},{0,26,0,131},{9274,25,0,32},{0,25,0,131},{9249,26,0,32},{9059,26,
0,32},{9069,26,0,32},{9073,26,0,32},{9069,25,0,32},{9073,25,0,32},{9069,26,0,
32},{9244,26,0,32},{9069,25,0,32},{9244,25,0,32},{9069,26,0,32},{9245,26,0,32},
{9069,25,0,32},{9245,25,0,32},{9069,26,0,32},{9249,26,0,32},{9069,25,0,32},
{9249,25,0,32},{9069,26,0,32},{9248,26,0,32},{9069,25,0,32},{9248,25,0,32},
{9069,26,0,32},{9250,26,0,32},{9069,25,0,32},{9250,25,0,32},{9069,26,0,32},
{9264,26,0,32},{9069,25,0,32},{9264,25,0,32},{9069,23,0,32},{9264,23,0,32},
{9069,26,0,32},{9259,26,0,32},{9069,25,0,32},{9259,25,0,32},{9069,23,0,32},
{9259,23,0,32},{9069,26,0,32},{9099,26,0,32},{9069,26,0,32},{9106,26,0,32},
{9069,26,0,32},{9225,26,0,32},{9069,26,0,32},{9259,26,0,32},{9069,26,0,32},
{9260,26,0,32},{9075,26,0,32},{9099,26,0,32},{9075,26,0,32},{9106,26,0,32},
{9075,26,0,32},{9107,26,0,32},{9075,26,0,32},{9225,26,0,32},{9075,26,0,32},
{9259,26,0,32},{9075,26,0,32},{9260,26,0,32},{9091,26,0,32},{9099,26,0,32},
{9091,26,0,32},{9106,26,0,32},{9091,26,0,32},{9107,26,0,32},{9091,26,0,32},
{9225,26,0,32},{9091,26,0,32},{9259,26,0,32},{9091,26,0,32},{9260,26,0,32},
{9092,26,0,32},{9099,26,0,32},{9092,26,0,32},{9225,26,0,32},{9092,26,0,32},
{9259,26,0,32},{9092,26,0,32},{9260,26,0,32},{9099,26,0,32},{9106,26,0,32},
{9099,26,0,32},{9225,26,0,32},{9106,26,0,32},{9099,26,0,32},{9106,26,0,32},
{9225,26,0,32},{9107,26,0,32},{9099,26,0,32},{9107,26,0,32},{9106,26,0,32},
{9107,26,0,32},{9225,26,0,32},{9151,26,0,32},{9099,26,0,32},{9151,26,0,32},
{9106,26,0,32},{9151,26,0,32},{9107,26,0,32},{9151,26,0,32},{9225,26,0,32},
{9162,26,0,32},{9106,26,0,32},{9162,26,0,32},{9225,26,0,32},{9163,26,0,32},
{9099,26,0,32},{9163,26,0,32},{9106,26,0,32},{9163,26,0,32},{9107,26,0,32},
{9163,26,0,32},{9225,26,0,32},{9168,26,0,32},{9106,26,0,32},{9168,26,0,32},
{9225,26,0,32},{9169,26,0,32},{9225,26,0,32},{9172,26,0,32},{9099,26,0,32},
{9172,26,0,32},{9225,26,0,32},{9173,26,0,32},{9099,26,0,32},{9173,26,0,32},
{9225,26,0,32},{9180,26,0,32},{9099,26,0,32},{9180,26,0,32},{9106,26,0,32},
{9180,26,0,32},{9107,26,0,32},{9180,26,0,32},{9225,26,0,32},{9180,26,0,32},
{9259,26,0,32},{9180,26,0,32},{9260,26,0,32},{9192,26,0,32},{9106,26,0,32},
{9192,26,0,32},{9225,26,0,32},{9192,26,0,32},{9259,26,0,32},{9192,26,0,32},
{9260,26,0,32},{9197,26,0,32},{9073,26,0,32},{9197,26,0,32},{9099,26,0,32},
{9197,26,0,32},{9106,26,0,32},{9197,26,0,32},{9107,26,0,32},{9197,26,0,32},
{9218,26,0,32},{9197,26,0,32},{9225,26,0,32},{9197,26,0,32},{9259,26,0,32},
{9197,26,0,32},{9260,26,0,32},{9218,26,0,32},{9099,26,0,32},{9218,26,0,32},
{9106,26,0,32},{9218,26,0,32},{9107,26,0,32},{9218,26,0,32},{9225,26,0,32},
{9218,26,0,32},{9259,26,0,32},{9218,26,0,32},{9260,26,0,32},{9225,26,0,32},
{9099,26,0,32},{9225,26,0,32},{9106,26,0,32},{9225,26,0,32},{9107,26,0,32},
{9225,26,0,32},{9225,26,0,32},{9225,26,0,32},{9259,26,0,32},{9225,26,0,32},
{9260,26,0,32},{9229,26,0,32},{9099,26,0,32},{9229,26,0,32},{9106,26,0,32},
{9229,26,0,32},{9107,26,0,32},{9229,26,0,32},{9225,26,0,32},{9229,26,0,32},
{9259,26,0,32},{9229,26,0,32},{9260,26,0,32},{9239,26,0,32},{9099,26,0,32},
{9239,26,0,32},{9225,26,0,32},{9239,26,0,32},{9259,26,0,32},{9239,26,0,32},
{9260,26,0,32},{9260,26,0,32},{9099,26,0,32},{9260,26,0,32},{9106,26,0,32},
{9260,26,0,32},{9107,26,0,32},{9260,26,0,32},{9225,26,0,32},{9260,26,0,32},
{9259,26,0,32},{9260,26,0,32},{9260,26,0,32},{9118,26,0,32},{0,26,0,152},{9132,
26,0,32},{0,26,0,152},{9259,26,0,32},{0,26,0,152},{0,26,0,112},{0,26,0,128},{0,
26,0,115},{0,26,0,128},{0,26,0,118},{0,26,0,128},{0,26,0,122},{0,26,0,128},{0,
26,0,125},{0,26,0,128},{0,26,0,128},{0,26,0,152},{9069,25,0,32},{9132,25,0,32},
{9069,25,0,32},{9133,25,0,32},{9069,25,0,32},{9225,25,0,32},{9069,25,0,32},
{9229,25,0,32},{9069,25,0,32},{9259,25,0,32},{9069,25,0,32},{9260,25,0,32},
{9075,25,0,32},{9132,25,0,32},{9075,25,0,32},{9133,25,0,32},{9075,25,0,32},
{9225,25,0,32},{9075,25,0,32},{9229,25,0,32},{9075,25,0,32},{9259,25,0,32},
{9075,25,0,32},{9260,25,0,32},{9091,25,0,32},{9132,25,0,32},{9091,25,0,32},
{9133,25,0,32},{9091,25,0,32},{9225,25,0,32},{9091,25,0,32},{9229,25,0,32},
{9091,25,0,32},{9259,25,0,32},{9091,25,0,32},{9260,25,0,32},{9092,25,0,32},
{9132,25,0,32},{9092,25,0,32},{9133,25,0,32},{9092,25,0,32},{9225,25,0,32},
{9092,25,0,32},{9229,25,0,32},{9092,25,0,32},{9259,25,0,32},{9092,25,0,32},
{9260,25,0,32},{9180,25,0,32},{9259,25,0,32},{9180,25,0,32},{9260,25,0,32},
{9192,25,0,32},{9259,25,0,32},{9192,25,0,32},{9260,25,0,32},{9197,25,0,32},
{9073,25,0,32},{9197,25,0,32},{9218,25,0,32},{9197,25,0,32},{9225,25,0,32},
{9197,25,0,32},{9259,25,0,32},{9197,25,0,32},{9260,25,0,32},{9218,25,0,32},
{9225,25,0,32},{9218,25,0,32},{9259,25,0,32},{9218,25,0,32},{9260,25,0,32},
{9225,25,0,32},{9073,25,0,32},{9225,25,0,32},{9225,25,0,32},{9229,25,0,32},
{9132,25,0,32},{9229,25,0,32},{9133,25,0,32},{9229,25,0,32},{9225,25,0,32},
{9229,25,0,32},{9229,25,0,32},{9229,25,0,32},{9259,25,0,32},{9229,25,0,32},
{9260,25,0,32},{9259,25,0,32},{0,25,0,152},{9260,25,0,32},{9132,25,0,32},{9260,
25,0,32},{9133,25,0,32},{9260,25,0,32},{9225,25,0,32},{9260,25,0,32},{9229,25,0,
32},{9260,25,0,32},{9259,25,0,32},{9260,25,0,32},{9260,25,0,32},{9069,23,0,32},
{9099,23,0,32},{9069,23,0,32},{9106,23,0,32},{9069,23,0,32},{9107,23,0,32},
{9069,23,0,32},{9225,23,0,32},{9069,23,0,32},{9239,23,0,32},{9075,23,0,32},
{9099,23,0,32},{9075,23,0,32},{9106,23,0,32},{9075,23,0,32},{9107,23,0,32},
{9075,23,0,32},{9225,23,0,32},{9075,23,0,32},{9239,23,0,32},{9091,23,0,32},
{9099,23,0,32},{9091,23,0,32},{9106,23,0,32},{9091,23,0,32},{9107,23,0,32},
{9091,23,0,32},{9225,23,0,32},{9091,23,0,32},{9239,23,0,32},{9092,23,0,32},
{9225,23,0,32},{9099,23,0,32},{9106,23,0,32},{9099,23,0,32},{9225,23,0,32},
{9106,23,0,32},{9099,23,0,32},{9106,23,0,32},{9225,23,0,32},{9107,23,0,32},
{9099,23,0,32},{9107,23,0,32},{9225,23,0,32},{9151,23,0,32},{9099,23,0,32},
{9151,23,0,32},{9106,23,0,32},{9151,23,0,32},{9107,23,0,32},{9151,23,0,32},
{9225,23,0,32},{9162,23,0,32},{9106,23,0,32},{9162,23,0,32},{9107,23,0,32},
{9162,23,0,32},{9225,23,0,32},{9163,23,0,32},{9099,23,0,32},{9163,23,0,32},
{9106,23,0,32},{9163,23,0,32},{9107,23,0,32},{9163,23,0,32},{9225,23,0,32},
{9168,23,0,32},{9106,23,0,32},{9169,23,0,32},{9225,23,0,32},{9172,23,0,32},
{9099,23,0,32},{9172,23,0,32},{9225,23,0,32},{9173,23,0,32},{9099,23,0,32},
{9173,23,0,32},{9225,23,0,32},{9180,23,0,32},{9099,23,0,32},{9180,23,0,32},
{9106,23,0,32},{9180,23,0,32},{9107,23,0,32},{9180,23,0,32},{9225,23,0,32},
{9192,23,0,32},{9106,23,0,32},{9192,23,0,32},{9225,23,0,32},{9197,23,0,32},
{9099,23,0,32},{9197,23,0,32},{9106,23,0,32},{9197,23,0,32},{9107,23,0,32},
{9197,23,0,32},{9218,23,0,32},{9197,23,0,32},{9225,23,0,32},{9218,23,0,32},
{9099,23,0,32},{9218,23,0,32},{9106,23,0,32},{9218,23,0,32},{9107,23,0,32},
{9218,23,0,32},{9225,23,0,32},{9218,23,0,32},{9239,23,0,32},{9225,23,0,32},
{9099,23,0,32},{9225,23,0,32},{9106,23,0,32},{9225,23,0,32},{9107,23,0,32},
{9225,23,0,32},{9225,23,0,32},{9229,23,0,32},{9099,23,0,32},{9229,23,0,32},
{9106,23,0,32},{9229,23,0,32},{9107,23,0,32},{9229,23,0,32},{9225,23,0,32},
{9229,23,0,32},{9239,23,0,32},{9239,23,0,32},{9099,23,0,32},{9239,23,0,32},
{9225,23,0,32},{9239,23,0,32},{0,23,0,152},{9260,23,0,32},{9099,23,0,32},{9260,
23,0,32},{9106,23,0,32},{9260,23,0,32},{9107,23,0,32},{9260,23,0,32},{9225,23,0,
32},{9260,23,0,32},{9239,23,0,32},{9069,24,0,32},{9225,24,0,32},{9069,24,0,32},
{9239,24,0,32},{9075,24,0,32},{9225,24,0,32},{9075,24,0,32},{9239,24,0,32},
{9091,24,0,32},{9225,24,0,32},{9091,24,0,32},{9239,24,0,32},{9092,24,0,32},
{9225,24,0,32},{9092,24,0,32},{9239,24,0,32},{9151,24,0,32},{9225,24,0,32},
{9151,24,0,32},{9239,24,0,32},{9152,24,0,32},{9225,24,0,32},{9152,24,0,32},
{9239,24,0,32},{9197,24,0,32},{9218,24,0,32},{9197,24,0,32},{9225,24,0,32},
{9218,24,0,32},{9225,24,0,32},{9229,24,0,32},{9225,24,0,32},{9229,24,0,32},
{9239,24,0,32},{9260,24,0,32},{9225,24,0,32},{9260,24,0,32},{9239,24,0,32},{0,
24,0,118},{0,24,0,128},{0,24,0,122},{0,24,0,128},{0,24,0,125},{0,24,0,128},
{9168,26,0,32},{9259,26,0,32},{9168,26,0,32},{9260,26,0,32},{9172,26,0,32},
{9259,26,0,32},{9172,26,0,32},{9260,26,0,32},{9173,26,0,32},{9259,26,0,32},
{9173,26,0,32},{9260,26,0,32},{9151,26,0,32},{9259,26,0,32},{9151,26,0,32},
{9260,26,0,32},{9152,26,0,32},{9259,26,0,32},{9152,26,0,32},{9260,26,0,32},
{9106,26,0,32},{9259,26,0,32},{9106,26,0,32},{9260,26,0,32},{9099,26,0,32},
{9259,26,0,32},{9099,26,0,32},{9260,26,0,32},{9107,26,0,32},{9259,26,0,32},
{9107,26,0,32},{9260,26,0,32},{9162,26,0,32},{9259,26,0,32},{9162,26,0,32},
{9260,26,0,32},{9163,26,0,32},{9259,26,0,32},{9163,26,0,32},{9260,26,0,32},
{9152,26,0,32},{9099,26,0,32},{9152,26,0,32},{9106,26,0,32},{9152,26,0,32},
{9107,26,0,32},{9152,26,0,32},{9225,26,0,32},{9152,26,0,32},{9132,26,0,32},
{9151,26,0,32},{9132,26,0,32},{9162,26,0,32},{9132,26,0,32},{9163,26,0,32},
{9132,26,0,32},{9168,25,0,32},{9259,25,0,32},{9168,25,0,32},{9260,25,0,32},
{9172,25,0,32},{9259,25,0,32},{9172,25,0,32},{9260,25,0,32},{9173,25,0,32},
{9259,25,0,32},{9173,25,0,32},{9260,25,0,32},{9151,25,0,32},{9259,25,0,32},
{9151,25,0,32},{9260,25,0,32},{9152,25,0,32},{9259,25,0,32},{9152,25,0,32},
{9260,25,0,32},{9106,25,0,32},{9259,25,0,32},{9106,25,0,32},{9260,25,0,32},
{9099,25,0,32},{9259,25,0,32},{9099,25,0,32},{9260,25,0,32},{9107,25,0,32},
{9259,25,0,32},{9107,25,0,32},{9260,25,0,32},{9162,25,0,32},{9259,25,0,32},
{9162,25,0,32},{9260,25,0,32},{9163,25,0,32},{9259,25,0,32},{9163,25,0,32},
{9260,25,0,32},{9152,25,0,32},{9099,25,0,32},{9152,25,0,32},{9106,25,0,32},
{9152,25,0,32},{9107,25,0,32},{9152,25,0,32},{9225,25,0,32},{9152,25,0,32},
{9132,25,0,32},{9151,25,0,32},{9132,25,0,32},{9162,25,0,32},{9132,25,0,32},
{9163,25,0,32},{9132,25,0,32},{9152,23,0,32},{9099,23,0,32},{9152,23,0,32},
{9106,23,0,32},{9152,23,0,32},{9107,23,0,32},{9152,23,0,32},{9225,23,0,32},
{9151,23,0,32},{9239,23,0,32},{9152,23,0,32},{9239,23,0,32},{9168,23,0,32},
{9225,23,0,32},{9151,24,0,32},{9099,24,0,32},{9151,24,0,32},{9106,24,0,32},
{9151,24,0,32},{9107,24,0,32},{9152,24,0,32},{9099,24,0,32},{9152,24,0,32},
{9106,24,0,32},{9152,24,0,32},{9107,24,0,32},{9168,24,0,32},{9225,24,0,32},
{9169,24,0,32},{9225,24,0,32},{9073,25,0,32},{0,25,0,109},{9073,26,0,32},{0,26,
0,109},{9091,23,0,32},{9099,23,0,32},{9225,23,0,32},{9091,25,0,32},{9106,25,0,
32},{9099,25,0,32},{9091,23,0,32},{9106,23,0,32},{9099,23,0,32},{9091,23,0,32},
{9106,23,0,32},{9225,23,0,32},{9091,23,0,32},{9107,23,0,32},{9225,23,0,32},
{9091,23,0,32},{9225,23,0,32},{9099,23,0,32},{9091,23,0,32},{9225,23,0,32},
{9106,23,0,32},{9091,23,0,32},{9225,23,0,32},{9107,23,0,32},{9099,25,0,32},
{9225,25,0,32},{9106,25,0,32},{9099,23,0,32},{9225,23,0,32},{9106,23,0,32},
{9106,25,0,32},{9225,25,0,32},{9260,25,0,32},{9106,25,0,32},{9225,25,0,32},
{9259,25,0,32},{9151,23,0,32},{9106,23,0,32},{9099,23,0,32},{9151,23,0,32},
{9099,23,0,32},{9106,23,0,32},{9151,25,0,32},{9099,25,0,32},{9259,25,0,32},
{9151,25,0,32},{9225,25,0,32},{9106,25,0,32},{9151,23,0,32},{9225,23,0,32},
{9106,23,0,32},{9151,23,0,32},{9225,23,0,32},{9099,23,0,32},{9151,25,0,32},
{9225,25,0,32},{9225,25,0,32},{9151,23,0,32},{9225,23,0,32},{9225,23,0,32},
{9162,25,0,32},{9106,25,0,32},{9106,25,0,32},{9162,23,0,32},{9106,23,0,32},
{9106,23,0,32},{9162,25,0,32},{9225,25,0,32},{9225,25,0,32},{9152,25,0,32},
{9106,25,0,32},{9225,25,0,32},{9152,23,0,32},{9106,23,0,32},{9225,23,0,32},
{9152,25,0,32},{9099,25,0,32},{9260,25,0,32},{9152,25,0,32},{9225,25,0,32},
{9107,25,0,32},{9152,23,0,32},{9225,23,0,32},{9107,23,0,32},{9152,25,0,32},
{9225,25,0,32},{9225,25,0,32},{9152,23,0,32},{9225,23,0,32},{9225,23,0,32},
{9163,25,0,32},{9106,25,0,32},{9259,25,0,32},{9163,25,0,32},{9107,25,0,32},
{9225,25,0,32},{9163,23,0,32},{9107,23,0,32},{9225,23,0,32},{9168,25,0,32},
{9225,25,0,32},{9106,25,0,32},{9168,23,0,32},{9225,23,0,32},{9106,23,0,32},
{9168,23,0,32},{9225,23,0,32},{9225,23,0,32},{9168,25,0,32},{9225,25,0,32},
{9260,25,0,32},{9172,25,0,32},{9099,25,0,32},{9225,25,0,32},{9172,25,0,32},
{9225,25,0,32},{9225,25,0,32},{9172,23,0,32},{9225,23,0,32},{9225,23,0,32},
{9172,25,0,32},{9225,25,0,32},{9259,25,0,32},{9173,25,0,32},{9225,25,0,32},
{9225,25,0,32},{9173,25,0,32},{9225,25,0,32},{9260,25,0,32},{9173,25,0,32},
{9225,25,0,32},{9259,25,0,32},{9180,25,0,32},{9107,25,0,32},{9225,25,0,32},
{9180,23,0,32},{9107,23,0,32},{9225,23,0,32},{9192,25,0,32},{9225,25,0,32},
{9106,25,0,32},{9192,25,0,32},{9225,25,0,32},{9225,25,0,32},{9218,25,0,32},
{9106,25,0,32},{9225,25,0,32},{9218,25,0,32},{9106,25,0,32},{9260,25,0,32},
{9218,25,0,32},{9106,25,0,32},{9259,25,0,32},{9218,23,0,32},{9099,23,0,32},
{9099,23,0,32},{9218,25,0,32},{9099,25,0,32},{9099,25,0,32},{9218,25,0,32},
{9107,25,0,32},{9225,25,0,32},{9218,23,0,32},{9107,23,0,32},{9225,23,0,32},
{9218,25,0,32},{9225,25,0,32},{9106,25,0,32},{9218,23,0,32},{9225,23,0,32},
{9106,23,0,32},{9225,23,0,32},{9106,23,0,32},{9099,23,0,32},{9225,23,0,32},
{9106,23,0,32},{9225,23,0,32},{9225,25,0,32},{9106,25,0,32},{9260,25,0,32},
{9225,23,0,32},{9099,23,0,32},{9106,23,0,32},{9225,23,0,32},{9099,23,0,32},
{9225,23,0,32},{9225,23,0,32},{9107,23,0,32},{9099,23,0,32},{9225,23,0,32},
{9107,23,0,32},{9225,23,0,32},{9225,23,0,32},{9099,23,0,32},{9107,23,0,32},
{9239,23,0,32},{9225,23,0,32},{9099,23,0,32},{9239,23,0,32},{9225,23,0,32},
{9225,23,0,32},{9229,23,0,32},{9106,23,0,32},{9225,23,0,32},{9229,25,0,32},
{9106,25,0,32},{9259,25,0,32},{9229,25,0,32},{9099,25,0,32},{9225,25,0,32},
{9229,23,0,32},{9099,23,0,32},{9225,23,0,32},{9229,25,0,32},{9099,25,0,32},
{9259,25,0,32},{9229,25,0,32},{9225,25,0,32},{9260,25,0,32},{9229,25,0,32},
{9225,25,0,32},{9259,25,0,32},{9260,25,0,32},{9225,25,0,32},{9225,25,0,32},
{9260,23,0,32},{9225,23,0,32},{9225,23,0,32},{9075,25,0,32},{9107,25,0,32},
{9260,25,0,32},{9091,25,0,32},{9099,25,0,32},{9260,25,0,32},{9091,25,0,32},
{9099,25,0,32},{9259,25,0,32},{9091,25,0,32},{9107,25,0,32},{9260,25,0,32},
{9091,25,0,32},{9107,25,0,32},{9259,25,0,32},{9091,25,0,32},{9225,25,0,32},
{9260,25,0,32},{9091,25,0,32},{9225,25,0,32},{9259,25,0,32},{9099,25,0,32},
{9225,25,0,32},{9260,25,0,32},{9099,25,0,32},{9106,25,0,32},{9259,25,0,32},
{9099,25,0,32},{9225,25,0,32},{9259,25,0,32},{9151,25,0,32},{9107,25,0,32},
{9259,25,0,32},{9162,25,0,32},{9106,25,0,32},{9260,25,0,32},{9152,25,0,32},
{9106,25,0,32},{9260,25,0,32},{9163,25,0,32},{9106,25,0,32},{9260,25,0,32},
{9218,25,0,32},{9099,25,0,32},{9260,25,0,32},{9218,25,0,32},{9225,25,0,32},
{9260,25,0,32},{9260,25,0,32},{9106,25,0,32},{9260,25,0,32},{9260,25,0,32},
{9099,25,0,32},{9260,25,0,32},{9260,25,0,32},{9225,25,0,32},{9260,25,0,32},
{9225,25,0,32},{9225,25,0,32},{9260,25,0,32},{9192,25,0,32},{9225,25,0,32},
{9260,25,0,32},{9229,25,0,32},{9106,25,0,32},{9260,25,0,32},{9192,23,0,32},
{9225,23,0,32},{9106,23,0,32},{9218,23,0,32},{9106,23,0,32},{9225,23,0,32},
{9172,25,0,32},{9225,25,0,32},{9260,25,0,32},{9197,25,0,32},{9225,25,0,32},
{9260,25,0,32},{9229,23,0,32},{9099,23,0,32},{9106,23,0,32},{9225,25,0,32},
{9107,25,0,32},{9260,25,0,32},{9218,23,0,32},{9099,23,0,32},{9225,23,0,32},
{9197,25,0,32},{9225,25,0,32},{9225,25,0,32},{9218,25,0,32},{9099,25,0,32},
{9225,25,0,32},{9229,25,0,32},{9099,25,0,32},{9106,25,0,32},{9099,25,0,32},
{9106,25,0,32},{9260,25,0,32},{9106,25,0,32},{9099,25,0,32},{9260,25,0,32},
{9225,25,0,32},{9099,25,0,32},{9260,25,0,32},{9180,25,0,32},{9225,25,0,32},
{9260,25,0,32},{9075,25,0,32},{9106,25,0,32},{9260,25,0,32},{9197,23,0,32},
{9225,23,0,32},{9225,23,0,32},{9172,23,0,32},{9099,23,0,32},{9225,23,0,32},
{9162,23,0,32},{9225,23,0,32},{9225,23,0,32},{9151,25,0,32},{9107,25,0,32},
{9260,25,0,32},{9229,25,0,32},{9099,25,0,32},{9260,25,0,32},{9162,26,0,32},
{9218,26,0,32},{9274,26,0,32},{9192,26,0,32},{9218,26,0,32},{9274,26,0,32},
{9073,26,0,32},{9218,26,0,32},{9218,26,0,32},{9239,26,0,32},{9073,26,0,32},
{9197,26,0,32},{9075,26,0,32},{9132,26,0,32},{9225,26,0,32},{9106,26,0,32},
{9225,26,0,32},{9117,26,0,32},{9162,26,0,32},{9218,26,0,32},{9172,26,0,32},
{9225,26,0,32},{9132,26,0,32},{9151,26,0,32},{9245,26,0,32},{9218,26,0,32},
{9172,26,0,32},{9218,26,0,32},{9260,26,0,32},{9239,26,0,32},{9245,26,0,32},
{9151,26,0,32},{9218,26,0,32},{9225,26,0,32},{9162,26,0,32},{9218,26,0,32},
{9259,26,0,32},{9162,26,0,32},{9218,26,0,32},{9259,26,0,32},{521,26,1,32},{9073,
26,0,32},{9218,26,0,32},{9218,26,0,32},{9239,26,0,32},{521,26,1,32},{9172,26,0,
32},{9218,26,0,32},{9260,26,0,32},{9239,26,0,32},{521,26,1,32},{9245,26,0,32},
{9151,26,0,32},{9218,26,0,32},{9225,26,0,32},{9099,26,0,32},{9218,26,0,32},{521,
26,1,32},{9099,26,0,32},{9218,26,0,32},{9073,26,0,32},{9218,26,0,32},{9239,26,0,
32},{9132,26,0,32},{9261,26,0,32},{9073,26,0,32},{9218,26,0,32},{632,22,1,32},
{632,22,1,32},{632,22,1,32},{632,22,1,32},{632,22,1,32},{9218,26,0,32},{9060,26,
0,32},{9218,25,0,32},{9060,25,0,32},{9218,26,0,32},{9061,26,0,32},{9218,25,0,
32},{9061,25,0,32},{9218,26,0,32},{9065,26,0,32},{9218,25,0,32},{9065,25,0,32},
{9218,26,0,32},{9073,26,0,32},{9218,25,0,32},{9073,25,0,32},{21625,4,0,32},{0,4,
0,273},{21626,4,0,32},{0,4,0,273},{21627,4,0,32},{0,4,0,273},{21628,4,0,32},{0,
4,0,273},{21629,4,0,32},{0,4,0,273},{21630,4,0,32},{0,4,0,273},{21631,4,0,32},
{0,4,0,273},{21631,4,0,32},{0,4,0,274},{21632,4,0,32},{0,4,0,273},{21633,4,0,
32},{0,4,0,273},{21634,4,0,32},{0,4,0,273},{21634,4,0,32},{0,4,0,274},{21635,4,
0,32},{0,4,0,273},{21635,4,0,32},{0,4,0,274},{21636,4,0,32},{0,4,0,273},{21636,
4,0,32},{0,4,0,274},{21637,4,0,32},{0,4,0,273},{21638,4,0,32},{0,4,0,273},
{21639,4,0,32},{0,4,0,273},{21640,4,0,32},{0,4,0,274},{21640,4,0,32},{0,4,0,
275},{21641,4,0,32},{0,4,0,273},{21642,4,0,32},{0,4,0,273},{21643,4,0,32},{0,4,
0,273},{21644,4,0,32},{0,4,0,273},{21644,4,0,32},{0,4,0,274},{21645,4,0,32},{0,
4,0,273},{21645,4,0,32},{0,4,0,274},{21646,4,0,32},{0,4,0,273},{21647,4,0,32},
{0,4,0,273},{21640,4,0,32},{0,4,0,273},{19333,4,0,32},{0,4,0,274},{19172,4,0,
32},{0,4,0,273},{14404,4,0,32},{0,4,0,273},{14406,4,0,32},{0,4,0,273},{14409,4,
0,32},{0,4,0,273},{14410,4,0,32},{0,4,0,273},{14411,4,0,32},{0,4,0,273},{14412,
4,0,32},{0,4,0,273},{14413,4,0,32},{0,4,0,273},{14414,4,0,32},{0,4,0,273},
{14416,4,0,32},{0,4,0,273},{14417,4,0,32},{0,4,0,273},{14418,4,0,32},{0,4,0,
273},{14419,4,0,32},{0,4,0,273},{14420,4,0,32},{0,4,0,273},{14421,4,0,32},{0,4,
0,273},{14426,4,0,32},{0,4,0,273},{14427,4,0,32},{0,4,0,273},{14428,4,0,32},{0,
4,0,273},{14429,4,0,32},{0,4,0,273},{14431,4,0,32},{0,4,0,273},{14435,4,0,32},
{0,4,0,273},{14436,4,0,32},{0,4,0,273},{14437,4,0,32},{0,4,0,273},{14438,4,0,
32},{0,4,0,273},{14439,4,0,32},{0,4,0,273},{14443,4,0,32},{0,4,0,273},{14444,4,
0,32},{0,4,0,273},{14445,4,0,32},{0,4,0,273},{14446,4,0,32},{0,4,0,273},{14363,
10,0,32},{0,4,0,273},{14371,10,0,32},{0,4,0,273},{14371,10,0,32},{0,4,0,274},
{14376,10,0,32},{0,4,0,273},{14386,10,0,32},{0,4,0,273},{14387,10,0,32},{0,4,0,
273},{14387,10,0,32},{0,4,0,274},{14390,10,0,32},{0,4,0,273},{14397,10,0,32},{0,
4,0,273},{14398,10,0,32},{0,4,0,273},{14363,4,0,32},{0,4,0,273},{14371,4,0,32},
{0,4,0,273},{14371,4,0,32},{0,4,0,274},{14376,4,0,32},{0,4,0,273},{14386,4,0,
32},{0,4,0,273},{14387,4,0,32},{0,4,0,273},{14387,4,0,32},{0,4,0,274},{14390,4,
0,32},{0,4,0,273},{14397,4,0,32},{0,4,0,273},{14398,4,0,32},{0,4,0,273},{10830,
2,0,32},{0,2,0,194},{10831,2,0,32},{0,2,0,194},{10840,2,0,32},{0,2,0,194},
{11318,4,0,32},{0,4,0,273},{11318,4,0,32},{0,4,0,274},{11319,4,0,32},{0,4,0,
273},{11320,4,0,32},{0,4,0,273},{11366,4,0,32},{0,4,0,273},{11367,4,0,32},{0,4,
0,273},{11495,4,0,32},{0,4,0,273},{11511,4,0,32},{0,4,0,273},{4412,2,1,32},{0,0,
0,0},{4413,2,1,32},{0,0,0,0},{4413,2,1,32},{0,0,0,0},{0,0,0,0},{4413,2,1,32},{0,
0,0,0},{0,0,0,0},{4413,2,1,32},{0,0,0,0},{0,0,0,0},{4413,2,1,32},{0,0,0,0},{0,0,
0,0},{4413,2,1,32},{0,0,0,0},{0,0,0,0},{4465,2,1,32},{0,0,0,0},{4465,2,1,32},{0,
0,0,0},{0,0,0,0},{4465,2,1,32},{0,0,0,0},{0,0,0,0},{4466,2,1,32},{0,0,0,0},
{4466,2,1,32},{0,0,0,0},{0,0,0,0},{4466,2,1,32},{0,0,0,0},{0,0,0,0},{7331,4,0,
32},{632,4,1,32},{7331,4,0,32},{546,4,1,32},{7332,4,0,32},{546,4,1,32},{7333,4,
0,32},{546,4,1,32},{7334,4,0,32},{546,4,1,32},{7335,4,0,32},{546,4,1,32},{7336,
4,0,32},{546,4,1,32},{7337,4,0,32},{546,4,1,32},{7338,4,0,32},{546,4,1,32},
{7339,4,0,32},{546,4,1,32},{7340,4,0,32},{546,4,1,32},{792,4,1,32},{7341,10,0,
32},{793,4,1,32},{792,4,1,32},{7366,10,0,32},{793,4,1,32},{792,4,1,32},{7392,10,
0,32},{793,4,1,32},{792,4,1,32},{7413,10,0,32},{793,4,1,32},{792,4,1,32},{7440,
10,0,32},{793,4,1,32},{792,4,1,32},{7499,10,0,32},{793,4,1,32},{792,4,1,32},
{7514,10,0,32},{793,4,1,32},{792,4,1,32},{7550,10,0,32},{793,4,1,32},{792,4,1,
32},{7576,10,0,32},{793,4,1,32},{792,4,1,32},{7602,10,0,32},{793,4,1,32},{792,4,
1,32},{7627,10,0,32},{793,4,1,32},{792,4,1,32},{7645,10,0,32},{793,4,1,32},{792,
4,1,32},{7696,10,0,32},{793,4,1,32},{792,4,1,32},{7711,10,0,32},{793,4,1,32},
{792,4,1,32},{7747,10,0,32},{793,4,1,32},{792,4,1,32},{7794,10,0,32},{793,4,1,
32},{792,4,1,32},{7815,10,0,32},{793,4,1,32},{792,4,1,32},{7833,10,0,32},{793,4,
1,32},{792,4,1,32},{7895,10,0,32},{793,4,1,32},{792,4,1,32},{7931,10,0,32},{793,
4,1,32},{792,4,1,32},{7963,10,0,32},{793,4,1,32},{792,4,1,32},{8009,10,0,32},
{793,4,1,32},{792,4,1,32},{8027,10,0,32},{793,4,1,32},{792,4,1,32},{8037,10,0,
32},{793,4,1,32},{792,4,1,32},{8049,10,0,32},{793,4,1,32},{792,4,1,32},{8071,10,
0,32},{793,4,1,32},{890,4,1,32},{7895,10,0,32},{891,4,1,32},{7392,12,0,32},
{7413,12,0,32},{8027,12,0,32},{8071,12,0,32},{7550,29,0,32},{8009,29,0,32},
{7696,29,0,32},{8009,29,0,32},{7895,29,0,32},{7413,29,0,32},{7895,29,0,32},
{7895,29,0,32},{7794,29,0,32},{7794,29,0,32},{8009,29,0,32},{8027,29,0,32},
{7392,29,0,32},{7696,20,0,32},{7392,20,0,32},{7696,20,0,32},{7413,20,0,32},
{7576,29,0,32},{7392,29,0,32},{7794,29,0,32},{7341,29,0,32},{7895,29,0,32},
{7341,29,0,32},{7341,29,0,32},{7366,29,0,32},{8027,29,0,32},{7392,29,0,32},
{7413,29,0,32},{7602,29,0,32},{7392,29,0,32},{7645,29,0,32},{7392,29,0,32},
{7747,29,0,32},{7747,29,0,32},{7645,29,0,32},{7499,29,0,32},{7833,29,0,32},
{7440,29,0,32},{7440,29,0,32},{7576,29,0,32},{7413,29,0,32},{7711,29,0,32},
{7440,29,0,32},{8027,29,0,32},{7711,29,0,32},{7514,29,0,32},{7747,29,0,32},
{7627,29,0,32},{7895,29,0,32},{7747,29,0,32},{7895,29,0,32},{7963,29,0,32},
{7794,29,0,32},{609,28,1,32},{8009,29,0,32},{7895,29,0,32},{7334,28,0,32},{7413,
29,0,32},{7333,28,0,32},{7711,28,0,32},{7413,28,0,32},{521,28,1,32},{7895,29,0,
32},{7392,28,0,32},{7833,28,0,32},{7333,28,0,32},{7627,29,0,32},{7335,28,0,32},
{7627,29,0,32},{7339,28,0,32},{7627,29,0,32},{7336,28,0,32},{632,28,1,32},{7332,
28,0,32},{7338,28,0,32},{632,28,1,32},{7332,28,0,32},{7333,28,0,32},{7333,28,0,
32},{632,28,1,32},{7333,28,0,32},{7337,28,0,32},{7331,28,0,32},{7794,29,0,32},
{7332,28,0,32},{7333,28,0,32},{7331,28,0,32},{7794,29,0,32},{7550,29,0,32},
{7392,28,0,32},{7550,29,0,32},{7413,28,0,32},{7833,29,0,32},{7550,29,0,32},
{7576,28,0,32},{521,28,1,32},{7833,29,0,32},{7440,28,0,32},{7895,28,0,32},{7645,
29,0,32},{7747,28,0,32},{7895,28,0,32},{7895,28,0,32},{7645,28,0,32},{7440,28,0,
32},{7895,28,0,32},{7895,28,0,32},{7895,29,0,32},{7550,29,0,32},{8009,29,0,32},
{7963,29,0,32},{7550,29,0,32},{7413,29,0,32},{8009,29,0,32},{7747,29,0,32},
{7413,29,0,32},{16015,28,0,32},{15991,28,0,32},{15995,28,0,32},{15995,28,0,32},
{64320,28,0,32},{57931,0,0,0},{64320,28,0,32},{56151,0,0,0},{64320,28,0,32},
{54220,0,0,0},{16004,28,0,32},{0,28,0,55},{64320,28,0,32},{52876,0,0,0},{64320,
28,0,32},{55578,0,0,0},{64321,28,0,32},{35299,0,0,0},{64320,28,0,32},{55593,0,0,
0},{64320,28,0,32},{52900,0,0,0},{64320,28,0,32},{58912,0,0,0},{64320,28,0,32},
{61729,0,0,0},{64320,28,0,32},{58777,0,0,0},{64320,28,0,32},{53837,0,0,0},
{64320,28,0,32},{57228,0,0,0},{64320,28,0,32},{53645,0,0,0},{64320,28,0,32},
{58800,0,0,0},{64320,28,0,32},{53789,0,0,0},{64320,28,0,32},{64834,0,0,0},
{64320,28,0,32},{62751,0,0,0},{64321,28,0,32},{36009,0,0,0},{64320,28,0,32},
{55536,0,0,0},{64320,28,0,32},{54329,0,0,0},{64320,28,0,32},{61204,0,0,0},
{64320,28,0,32},{58005,0,0,0},{64320,28,0,32},{58197,0,0,0},{64320,28,0,32},
{52736,0,0,0},{64320,28,0,32},{52745,0,0,0},{64321,28,0,32},{36938,0,0,0},
{64320,28,0,32},{56806,0,0,0},{64320,28,0,32},{52781,0,0,0},{64320,28,0,32},
{54259,0,0,0},{64320,28,0,32},{58119,0,0,0},{64321,28,0,32},{36208,0,0,0},
{64320,28,0,32},{57939,0,0,0},{64320,28,0,32},{63873,0,0,0},{64320,28,0,32},
{64122,0,0,0},{64320,28,0,32},{54280,0,0,0},{64320,28,0,32},{61056,0,0,0},
{64320,28,0,32},{59145,0,0,0},{64320,28,0,32},{59144,0,0,0},{64320,28,0,32},
{62771,0,0,0},{64320,28,0,32},{53874,0,0,0},{64320,28,0,32},{54710,0,0,0},
{64321,28,0,32},{37197,0,0,0},{890,4,1,32},{64320,4,0,32},{59180,0,0,0},{891,4,
1,32},{890,4,1,32},{64320,4,0,32},{52745,0,0,0},{891,4,1,32},{890,4,1,32},
{64320,4,0,32},{52876,0,0,0},{891,4,1,32},{890,4,1,32},{64320,4,0,32},{56201,0,
0,0},{891,4,1,32},{890,4,1,32},{64320,4,0,32},{61625,0,0,0},{891,4,1,32},{890,4,
1,32},{64320,4,0,32},{57939,0,0,0},{891,4,1,32},{890,4,1,32},{64320,4,0,32},
{63191,0,0,0},{891,4,1,32},{890,4,1,32},{64320,4,0,32},{53981,0,0,0},{891,4,1,
32},{890,4,1,32},{64320,4,0,32},{58711,0,0,0},{891,4,1,32},{64320,6,0,32},
{57239,0,0,0},{64320,6,0,32},{54255,0,0,0},{64388,2,0,32},{33058,0,0,0},{64388,
2,0,32},{34076,0,0,0},{64388,2,0,32},{34085,0,0,0},{64388,2,0,32},{34123,0,0,0},
{64388,2,0,32},{34362,0,0,0},{64388,2,0,32},{34820,0,0,0},{64388,2,0,32},{35038,
0,0,0},{64388,2,0,32},{35372,0,0,0},{64388,2,0,32},{35683,0,0,0},{64388,2,0,32},
{38116,0,0,0},{64388,2,0,32},{38568,0,0,0},{64388,2,0,32},{38634,0,0,0},{64388,
2,0,32},{39368,0,0,0},{64388,2,0,32},{39704,0,0,0},{64388,2,0,32},{40203,0,0,0},
{64388,2,0,32},{40420,0,0,0},{64388,2,0,32},{40422,0,0,0},{64388,2,0,32},{41347,
0,0,0},{64388,2,0,32},{41375,0,0,0},{64388,2,0,32},{41777,0,0,0},{64388,2,0,32},
{42708,0,0,0},{64388,2,0,32},{43076,0,0,0},{64388,2,0,32},{43082,0,0,0},{64388,
2,0,32},{43788,0,0,0},{64388,2,0,32},{44017,0,0,0},{64388,2,0,32},{45066,0,0,0},
{64388,2,0,32},{45752,0,0,0},{64388,2,0,32},{45919,0,0,0},{64388,2,0,32},{45971,
0,0,0},{64388,2,0,32},{45980,0,0,0},{64388,2,0,32},{46019,0,0,0},{64388,2,0,32},
{46037,0,0,0},{64388,2,0,32},{46189,0,0,0},{64388,2,0,32},{46755,0,0,0},{64388,
2,0,32},{47271,0,0,0},{64388,2,0,32},{47757,0,0,0},{64388,2,0,32},{47866,0,0,0},
{64388,2,0,32},{48316,0,0,0},{64388,2,0,32},{48414,0,0,0},{64388,2,0,32},{48849,
0,0,0},{64388,2,0,32},{48990,0,0,0},{64388,2,0,32},{49038,0,0,0},{64388,2,0,32},
{49763,0,0,0},{64388,2,0,32},{49902,0,0,0},{64388,2,0,32},{50091,0,0,0},{64388,
2,0,32},{50696,0,0,0},{64388,2,0,32},{50997,0,0,0},{64388,2,0,32},{51220,0,0,0},
{64388,2,0,32},{52278,0,0,0},{64388,2,0,32},{52370,0,0,0},{64388,2,0,32},{53153,
0,0,0},{64388,2,0,32},{53176,0,0,0},{64388,2,0,32},{53316,0,0,0},{64388,2,0,32},
{53490,0,0,0},{64388,2,0,32},{53491,0,0,0},{64388,2,0,32},{53529,0,0,0},{64388,
2,0,32},{53555,0,0,0},{64388,2,0,32},{53833,0,0,0},{64388,2,0,32},{54301,0,0,0},
{64388,2,0,32},{54822,0,0,0},{64388,2,0,32},{54938,0,0,0},{64388,2,0,32},{54981,
0,0,0},{64388,2,0,32},{55676,0,0,0},{64388,2,0,32},{55975,0,0,0},{64388,2,0,32},
{56235,0,0,0},{64388,2,0,32},{56448,0,0,0},{64388,2,0,32},{56528,0,0,0},{64388,
2,0,32},{57222,0,0,0},{64388,2,0,32},{57818,0,0,0},{64388,2,0,32},{57896,0,0,0},
{64388,2,0,32},{57927,0,0,0},{64388,2,0,32},{58073,0,0,0},{64388,2,0,32},{58174,
0,0,0},{64388,2,0,32},{58586,0,0,0},{64388,2,0,32},{58659,0,0,0},{64388,2,0,32},
{58792,0,0,0},{64388,2,0,32},{59303,0,0,0},{64388,2,0,32},{59317,0,0,0},{64388,
2,0,32},{60220,0,0,0},{64388,2,0,32},{60470,0,0,0},{64388,2,0,32},{60629,0,0,0},
{64388,2,0,32},{60779,0,0,0},{64388,2,0,32},{61228,0,0,0},{64388,2,0,32},{61361,
0,0,0},{64388,2,0,32},{61650,0,0,0},{64388,2,0,32},{62410,0,0,0},{64388,2,0,32},
{63079,0,0,0},{64388,2,0,32},{63662,0,0,0},{64388,2,0,32},{63846,0,0,0},{64388,
2,0,32},{64680,0,0,0},{64388,2,0,32},{65235,0,0,0},{64388,2,0,32},{65327,0,0,0},
{64389,2,0,32},{34258,0,0,0},{64389,2,0,32},{34285,0,0,0},{64389,2,0,32},{34606,
0,0,0},{64389,2,0,32},{35834,0,0,0},{64389,2,0,32},{36215,0,0,0},{64389,2,0,32},
{37189,0,0,0},{64389,2,0,32},{37343,0,0,0},{64389,2,0,32},{37402,0,0,0},{64389,
2,0,32},{37898,0,0,0},{64389,2,0,32},{38038,0,0,0},{64389,2,0,32},{38326,0,0,0},
{64389,2,0,32},{39728,0,0,0},{64389,2,0,32},{41166,0,0,0},{64389,2,0,32},{41221,
0,0,0},{64389,2,0,32},{41486,0,0,0},{64389,2,0,32},{41617,0,0,0},{64389,2,0,32},
{41874,0,0,0},{64389,2,0,32},{42496,0,0,0}};
