#! /bin/sh
### BEGIN INIT INFO
# Provides:          mini-httpd
# Required-Start:    $local_fs $remote_fs
# Required-Stop:     $local_fs $remote_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: mini-httpd start script
# Description:       this script starts mini-httpd
### END INIT INFO

. /lib/lsb/init-functions

# Globals
PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/mini_httpd
NAME=mini_httpd
DESC="web server"
PIDFILE=/var/run/mini_httpd.pid

test -x $DAEMON || exit 0

# Include mini-httpd defaults if available
if [ -f /etc/default/mini-httpd ]
then
	. /etc/default/mini-httpd
fi

set -e

# Functions
start() {
	if [ "$START" = "1" ]
	then
		echo -n "Starting $DESC: "
		start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
			--exec $DAEMON -- $DAEMON_OPTS
		echo "$NAME."
	else
		printf "You have to edit /etc/mini-httpd.conf and\n/etc/default/mini-httpd before running mini-httpd!\n"
		printf " "
		exit 0
	fi
}

stop() {
	echo -n "Stopping $DESC: "
	# Get pid number
	if [ -e /var/run/$NAME.pid ]
	then
		PID=`cat /var/run/$NAME.pid`
		if [ -d /proc/$PID ]
		then
			start-stop-daemon -v --stop --quiet --oknodo --pidfile /var/run/$NAME.pid
		else
			# we need to remove the pidfile manually
			if [ -e /var/run/$NAME.pid ]
			then
				rm -f /var/run/$NAME.pid
			fi
		fi
	else 
		start-stop-daemon --stop --quiet --oknodo --name $DAEMON
	fi
	echo "$NAME."
}

case "$1" in
  start)
	start
	;;

  stop)
	stop
	;;
  status)
	status_of_proc -p $PIDFILE $DAEMON $NAME && exit 0 || exit $?
	;;
  restart|force-reload)
	stop
	start
	;;

  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|status|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
