# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_cloud_filter import PointCloudFilter


class MaskPointsFilter(PointCloudFilter):
    r"""
    MaskPointsFilter - extract points within an image/volume mask
    
    Superclass: PointCloudFilter
    
    MaskPointsFilter extracts points that are inside an image mask.
    The image mask is a second input to the filter. Points that are
    inside a voxel marked "inside" are copied to the output. The image
    mask can be generated by PointOccupancyFilter, with optional image
    processing steps performed on the mask. Thus PointOccupancyFilter
    and MaskPointsFilter are generally used together, with a pipeline
    of image processing algorithms in between the two filters.
    
    Note also that this filter is a subclass of PointCloudFilter which
    has the ability to produce an output mask indicating which points
    were selected for output. It also has an optional second output
    containing the points that were masked out (i.e., outliers) during
    processing.
    
    Finally, the mask value indicating non-selection of points (i.e., the
    empty value) may be specified. The second input, masking image, is
    typically of type unsigned char so the empty value is of this type as
    well.
    
    @warning
    During processing, points not within the masking image/volume are
    considered outside and never extracted.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    PointOccupancyFilter PointCloudFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMaskPointsFilter, obj, update, **traits)
    
    empty_value = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set / get the values indicating whether a voxel is empty. By
        default, an empty voxel is marked with a zero value. Any point
        inside a voxel marked empty is not selected for output. All other
        voxels with a value that is not equal to the empty value are
        selected for output.
        """
    )

    def _empty_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEmptyValue,
                        self.empty_value)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_mask(self):
        return wrap_vtk(self._vtk_obj.GetMask())
    mask = traits.Property(_get_mask, desc=\
        r"""
        
        """
    )

    def set_mask_connection(self, *args):
        """
        set_mask_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_mask_connection(AlgorithmOutput *algOutput)
        Specify the masking image. It is ImageData output from an
        algorithm.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMaskConnection, *my_args)
        return ret

    def set_mask_data(self, *args):
        """
        set_mask_data(self, source:DataObject) -> None
        C++: void set_mask_data(DataObject *source)
        Specify the masking image. It must be of type ImageData.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMaskData, *my_args)
        return ret

    _updateable_traits_ = \
    (('generate_outliers', 'GetGenerateOutliers'), ('generate_vertices',
    'GetGenerateVertices'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('empty_value',
    'GetEmptyValue'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_outliers', 'generate_vertices',
    'global_warning_display', 'release_data_flag', 'empty_value',
    'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MaskPointsFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MaskPointsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_outliers', 'generate_vertices'], [], ['empty_value',
            'object_name']),
            title='Edit MaskPointsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MaskPointsFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

