/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2019 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * RiemannSphereHobold multi powers
 * @reference https://fractalforums.org/fractal-mathematics-and-new-theories/28/
 * riemandelettuce-without-trigonometry/2996/msg16097#msg16097

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "RiemannSphereHoboldMultiIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 RiemannSphereHoboldMultiIteration(
	REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	z *= native_divide(fractal->transformCommon.scale08,
		aux->r); // normalize vector to unit length => project onto sphere

	// find X-related iso-plane: polar projection onto unit circle
	REAL Kx = 2.0f * z.x * native_divide((1.0f - z.y), ((z.y - 2.0f) * z.y + z.x * z.x + 1.0f));
	REAL Ky =
		1.0f
		- 2.0f * native_divide((mad((z.y - 2.0f), z.y, 1.0f)), ((z.y - 2.0f) * z.y + z.x * z.x + 1.0f));

	if (fractal->transformCommon.functionEnabledx)
	{
		int countDXY = fractal->transformCommon.int3;
		int n;
		for (n = 0; n < countDXY; n++)
		{
			REAL tempX = Kx;
			REAL tempY = Ky;
			Kx = -2.0f * tempX * tempY;
			Ky = -(mad(tempY, tempY, -tempX * tempX));
		}
	}

	if (fractal->transformCommon.functionEnabledxFalse)
	{
		int countTXY = fractal->transformCommon.int3X;
		int p;
		for (p = 0; p < countTXY; p++)
		{
			REAL tempY = Ky;
			REAL tempX = Kx;
			Kx = -tempX * (mad(-4.0f, tempX * tempX, 3.0f));
			Ky = -tempY * (mad(4.0f * tempY, tempY, -3.0f));
		}
	}

	// (relevant) normal vector coordinates of REALd point plane
	REAL n1x = Ky - 1.0f;
	REAL n1y = -Kx;

	n1x += fractal->transformCommon.offsetA0; // offset tweak

	// find Z-related iso-plane: polar projection onto unit circle
	REAL Kz = 2.0f * z.z * native_divide((1.0f - z.y), ((z.y - 2.0f) * z.y + z.z * z.z + 1.0f));
	Ky =
		1.0f
		- 2.0f * native_divide((mad((z.y - 2.0f), z.y, 1.0f)), ((z.y - 2.0f) * z.y + z.z * z.z + 1.0f));

	if (fractal->transformCommon.functionEnabledy)
	{
		int countDYZ = fractal->transformCommon.int3Y;
		int n;
		for (n = 0; n < countDYZ; n++)
		{
			REAL tempZ = Kz;
			REAL tempY = Ky;
			Kz = -2.0f * tempZ * tempY;
			Ky = -(mad(tempY, tempY, -tempZ * tempZ));
		}
	}

	if (fractal->transformCommon.functionEnabledyFalse)
	{
		int countTYZ = fractal->transformCommon.int3Z;
		int p;
		for (p = 0; p < countTYZ; p++)
		{
			REAL tempY = Ky;
			REAL tempZ = Kz;
			Kz = -tempZ * (mad(-4.0f, tempZ * tempZ, 3.0f));
			Ky = -tempY * (mad(4.0f * tempY, tempY, -3.0f));
		}
	}

	// (relevant) normal vector coordinates of REALd point plane
	REAL n2y = -Kz;
	REAL n2z = Ky - 1.0f;

	n2z += fractal->transformCommon.offsetB0; // offset tweak

	// internal rotation
	if (fractal->transformCommon.angle0 != 0)
	{
		REAL tpx = n1x;
		REAL tpz = n2z;
		REAL beta = fractal->transformCommon.angle0 * M_PI_180;
		n1x = mad(tpx, native_cos(beta), tpz * native_sin(beta));
		n2z = mad(tpx, -native_sin(beta), tpz * native_cos(beta));
	}

	// compute position of REALd point as intersection of planes and sphere
	// solved ray parameter
	REAL nt = 2.0f
						* native_divide((n1x * n1x * n2z * n2z),
							(mad((mad(n1x, n1x, n1y * n1y)) * n2z, n2z, n1x * n1x * n2y * n2y)));

	// REALd point position
	z.y = 1.0f - nt;
	z.x = n1y * native_divide((1.0f - z.y), n1x);
	z.z = n2y * native_divide((1.0f - z.y), n2z);

	// raise original length to the power, then add constant
	z *= native_powr(aux->r, native_divide(fractal->transformCommon.pwr8, 2.0f));

	z += fractal->transformCommon.additionConstant000;

	if (fractal->transformCommon.rotationEnabled)
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	if (fractal->analyticDE.enabled)
	{
		aux->DE = fractal->analyticDE.offset1
							+ aux->DE * native_divide(fabs(fractal->transformCommon.scale08), aux->r);
		aux->DE *= 8.0f * fractal->analyticDE.scale1 * native_divide(length(z), aux->r);
	}
	return z;
}