-*
   Copyright 2020, Luigi Ferraro, Federico Galetto,
   Francesca Gandini, Hang Huang, Matthew Mastroeni, Xianglong Ni.

   You may redistribute this file under the terms of the GNU General Public
   License as published by the Free Software Foundation, either version 2 of
   the License, or any later version.
*-


document {
	Key => {diagonalAction, 
	    (diagonalAction, Matrix, PolynomialRing),
	    (diagonalAction, Matrix, List, PolynomialRing),
	    (diagonalAction, Matrix, Matrix, List, PolynomialRing)
	    },
	Headline => "diagonal group action via weights",
	Usage => "diagonalAction(W, R), diagonalAction(W, d, R), diagonalAction(W1, W2, d, R)",
	Inputs => {
	    	"W" => Matrix => {"of weights of the diagonal group action"},
		"W1" => Matrix => {"of weights for the torus action"},
		"W2" => Matrix => {"of weights for the finite abelian action"},
	    	"d" => List => {"of orders of cyclic abelian factors in the 
		    decomposition of the diagonal group"},
		"R" => PolynomialRing => {"on which the group acts"}
		},
	Outputs => {
		DiagonalAction => {"the diagonal action of the product of a torus
		    with a finite abelian group corresponding to the given weight matrices"}
		},
	"This function is provided by the package ", TO InvariantRing,". ",

       	PARA {
	    "Use this function to set up a diagonal action of a group",
	    TEX /// $(k^*)^r \times \mathbb{Z}/d_1 \times \cdots \times \mathbb{Z}/d_g$ ///,
	    " on a polynomial ring ",
	    TEX /// $R = k[x_1,\ldots,x_n]$ ///,
	    "over a field. Saying the action is diagonal means that ",
	    TEX /// $(t_1,\ldots,t_r) \in (k^*)^r$ ///,
	    " acts by",
	    TEX /// $$(t_1,\ldots,t_r) \cdot x_j = t_1^{w_{1,j}}\cdots t_r^{w_{r,j}} x_j$$ ///,
	    "for some integers ",
	    TEX /// $w_{i,j}$ ///, 
	    " and the generators ",
	    TEX /// $u_1, \dots, u_g$ ///,
	    " of the cyclic abelian factors act by",
	    TEX /// $$u_i \cdot x_j = \zeta_i^{w_{r+i,j}} x_j$$ ///,
	    "for ",
	    TEX /// $\zeta_i$ ///,
	    " a primitive ",
	    TEX /// $d_i$///,
	    "-th root of unity. The integers",
	    TEX /// $w_{i,j}$ ///,
	    "comprise the weight matrix ", TT "W",
	    ". In other words, the ",
	    TEX /// $j$ ///,
	    "-th column of ", TT "W", 
	    " is the weight vector of",
	    TEX /// $x_j$. ///
	    },
    
    	PARA {
	    "The following example defines an action of a 
	    two-dimensional torus on a four-dimensional vector space
	    with a basis of weight vectors whose weights are
	    the columns of the input matrix."
	    },
        	
	EXAMPLE {
	    "R = QQ[x_1..x_4]",
	    "W = matrix{{0,1,-1,1},{1,0,-1,-1}}",
	    "T = diagonalAction(W, R)"
		},
	    
    	PARA {
	    "Here is an example of a product of two cyclic groups of order 3 
	    acting on a three-dimensional vector space:"
	    },
	
	EXAMPLE {
	    "R = QQ[x_1..x_3]",
	    "d = {3,3}",
	    "W = matrix{{1,0,1},{0,1,1}}",
	    "A = diagonalAction(W, d, R)",
		},
    
	    }

document {
	Key => {DiagonalAction},
	Headline => "the class of all diagonal actions",
	"This class is provided by the package ", TO InvariantRing,".",
	
	PARA {
	    	TT "DiagonalAction", " is the class of all
		diagonal actions on polynomial rings by a 
		product of a torus (possibly trivial)
		with a finite abelian group  for the
		purpose of computing invariants.
		It is created using ", TO "diagonalAction", "."
	    },
	}

document {
	Key => { equivariantHilbertSeries,
	    (equivariantHilbertSeries, DiagonalAction)
	    },
	Headline => "equivariant Hilbert series for a diagonal action",
	Usage => "equivariantHilbertSeries D",
	Inputs => {
	    	"D" => DiagonalAction,
		Order => ZZ => {"stopping degree of the equivariant Hilbert series"}
		},
	Outputs => {
		Divide => {"the equivariant Hilbert series"}
		},
	"This function is provided by the package ", TO InvariantRing,". ",

    	PARA {
	    "For a torus acting on the vector space",
	    TEX /// $V$ ///,
	    "this function returns the equivariant Hilbert series of the coordinate ring",
	    TEX /// $K[V]$ ///,
	    "as a rational function of",
	    TEX /// $z_0, \ldots, z_{r-1}, t$ ///,
	    "where",
	    TEX /// $r$ ///,
	    "is the rank of the torus. The series in",
	    TEX /// $t$ ///,
	    "which is the coefficient of",
	    TEX /// $z_0^0\cdots z_{r-1}^0$ ///,
	    "gives the ordinary Hilbert series of",
	    TEX /// $K[V]^T$ ///,
	    ". The option ",
	    TT "Order => N",
	    " can be used to compute the series up to the ",
	    TEX /// $t$ ///,
	    "-degree ",
	    TT "N-1",
	    "."
	},
    
    	PARA {
	    "Here is an example of a rank 2 torus acting on a polynomial ring in 3 variables, whose invariant ring is generated by the single element",
	    TEX /// $x_1 x_2 x_3$ ///,
	    "."
	},
	
	
	EXAMPLE {
	    "R = QQ[x_1..x_3]",
	    "W = matrix{{-1,0,1},{0,-1,1}}",
	    "T = diagonalAction(W, R)",
	    "equivariantHilbertSeries T",
	    "S = equivariantHilbertSeries(T, Order => 7)",
	    "sub(S, {z_0 => 0, z_1 => 0})"
		},
	 
	    }

document {
	Key => { equivariantHilbert },
	Headline => "stores equivariant Hilbert series expansions",

    	PARA {
	    "This key is created in the cache table of a ",
	    TO "DiagonalAction", " upon calling ",
	    TO "equivariantHilbertSeries", " with the ",
	    TO "Order", " option. It stores partial expansions
	    of the equivariant Hilbert series to avoid computing
	    them again."
	},
    	
	EXAMPLE {
	    "R = QQ[x_1..x_3]",
	    "W = matrix{{-1,0,1},{0,-1,1}}",
	    "T = diagonalAction(W, R)",
	    "T.cache.?equivariantHilbert",
	    "elapsedTime equivariantHilbertSeries(T, Order => 5)",
	    "T.cache.?equivariantHilbert",
	    "elapsedTime equivariantHilbertSeries(T, Order => 5);",
		},
	 
	    }

document {
	Key => {(numgens, DiagonalAction)},
	Headline => "number of generators of the finite part of a diagonal group",
	Usage => "numgens D",
	Inputs => {
	    	"D" => DiagonalAction =>
		{"the action of a diagonal group"},
		},
	Outputs => {
		ZZ => {"the number of generators of the group"}
		},
	"This function is provided by the package ", TO InvariantRing,". ",

    	PARA {	 
	    "Writing the diagonal group acting on the polynomial ring",
	    TEX /// $k[x_1,\dots,x_n]$ ///, "as",
	    TEX /// $(k^*)^r \times \mathbb{Z}/d_1 \times \cdots \times \mathbb{Z}/d_g$, ///,
	    "this function returns ", TT "g", "."
	},
    
    	PARA {
	    "Here is an example of a product of two cyclic groups
	    of order 3 acting on a polynomial ring in 3 variables."
	},
	
	EXAMPLE {
	    "R = QQ[x_1..x_3]",
	    "d = {3,3}",
	    "W = matrix{{1,0,1},{0,1,1}}",
	    "A = diagonalAction(W, d, R)",
	    "numgens A"
		},
	    }

document {
	Key => { weights,
	    (weights, DiagonalAction)
	    },
	Headline => "of a diagonal action",
	Usage => "weights D",
	Inputs => {
	    	"D" => DiagonalAction
		},
	Outputs => {
		Matrix => {"the weight matrix of the group action"}
		},
	"This function is provided by the package ", TO InvariantRing,". ",
	    
	PARA {
	    "Use this function to recover the weight matrix of a
	    diagonal action on a polynomial ring. For a diagonal action
	    on a polynomial ring ",
	    TEX /// $k[x_1, \dots, x_n]$ ///,
	    ", the ",
	    TEX /// $j$ ///,
	    "-th column of the weight matrix is the weight of the
	    variable ",
	    TEX /// $x_j$ ///,
	    "."
	    },
	
    	PARA {
	    "The following example defines an action of a 
	    two-dimensional torus on a polynomial ring in four
	    variables."
	    },
        	
	EXAMPLE {
	    "R = QQ[x_1..x_4]",
	    "W = matrix{{0,1,-1,1},{1,0,-1,-1}}",
	    "T = diagonalAction(W, R)",
	    "weights T"
	    },  
	    
	PARA {
	    "Here is an example of a product of two cyclic groups
	    of order 3 acting on a polynomial ring in 3 variables."
	    },
	
	EXAMPLE {
	    "R = QQ[x_1..x_3]",
	    "d = {3,3}",
	    "W = matrix{{1,0,1},{0,1,1}}",
	    "A = diagonalAction(W, d, R)",
	    "weights A"
	    },    
	    
	SeeAlso => {
	    DiagonalAction,
	    diagonalAction
	    }      
	}
    
document {
	Key => { cyclicFactors,
	    (cyclicFactors, DiagonalAction)
	    },
	Headline => "of a diagonal action",
	Usage => "cyclicFactors D",
	Inputs => {
	    	"D" => DiagonalAction
		},
	Outputs => {
		List => {"of orders of cyclic abelian factors in the decomposition of the diagonal group"}
		},
	"This function is provided by the package ", TO InvariantRing,". ",
	    
	PARA {
	    "Use this function to recover the cyclic abelian factors of a
	    diagonal action on a polynomial ring."
	    },
	
    	PARA {
	    "The following example defines an action of a product of two cyclic groups of order 3 acting on a three-dimensional vector space."
	    },
        	
	EXAMPLE {
	    "R = QQ[x_1..x_3]",
	    "d = {3,3}",
	    "W = matrix{{1,0,1},{0,1,1}}",
	    "A = diagonalAction(W, d, R)",
	    "cyclicFactors A"
	    },  

	SeeAlso => {
	    DiagonalAction,
	    diagonalAction
	    }      
	}
    
    
document {
	Key => { (rank, DiagonalAction)
	    },
	Headline => "of a diagonal action",
	Usage => "rank D",
	Inputs => {
	    	"D" => DiagonalAction
		},
	Outputs => {
		ZZ => {"the rank of the torus factor of a diagonal action "}
		},
	"This function is provided by the package ", TO InvariantRing,". ",
	    
	PARA {
	    "Use this function to recover the rank of the torus factor of a diagonal action."
	    },
	
    	PARA {
	    "The following example defines an action of a 
	    two-dimensional torus on a polynomial ring in four
	    variables."
	    },
        	
	EXAMPLE {
	    "R = QQ[x_1..x_4]",
	    "W = matrix{{0,1,-1,1},{1,0,-1,-1}}",
	    "T = diagonalAction(W, R)",
	    "rank T"
	    },      
	    
	SeeAlso => {
	    DiagonalAction,
	    diagonalAction
	    }      
	}
    
 document {
	Key => { (degreesRing, DiagonalAction)
	    },
	Headline => "of a diagonal action",
	Usage => "degreesRing D",
	Inputs => {
	    	"D" => DiagonalAction
		},
	Outputs => {
		Ring => {"where the equivariant Hilbert series of the diagonal group action lives in"}
		},
	"This function is provided by the package ", TO InvariantRing,". ",
	    
	PARA {
	    "Use this function to get the ring where the equivariant Hilbert series of the diagonal group action lives in."
	    },
	
    	PARA {
	    "The following example defines an action of the product of a 
	    two-dimensional torus and two cyclic group of order 3 on a polynomial ring in four
	    variables."
	    },
        	
	EXAMPLE {
	    "R = QQ[x_1..x_4]",
	    "W = matrix{{0,1,-1,1},{1,0,-1,-1}}",
	    "W1 = matrix{{1,0,1,0},{0,1,1,0}}",
	    "T = diagonalAction(W,W1,{3,3},R)",
	    "degreesRing T"
	    },      
	    
	SeeAlso => {
	    DiagonalAction,
	    diagonalAction
	    }      
	}

