/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>		/* for FILE */

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "ykneomgr"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "ykneomgr"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
  struct gengetopt_args_info
  {
    const char *help_help;
			 /**< @brief Print help and exit help description.  */
    const char *version_help;
			    /**< @brief Print version and exit help description.  */
    int get_mode_flag;	/**< @brief Output mode of YubiKey NEO (default=off).  */
    const char *get_mode_help;
			     /**< @brief Output mode of YubiKey NEO help description.  */
    int get_version_flag;
			/**< @brief Output firmware version for YubiKey NEO (default=off).  */
    const char *get_version_help;
				/**< @brief Output firmware version for YubiKey NEO help description.  */
    int get_serialno_flag;	/**< @brief Output serial number (default=off).  */
    const char *get_serialno_help;
				 /**< @brief Output serial number help description.  */
    int list_readers_flag;	/**< @brief List all connected PCSC devices (default=off).  */
    const char *list_readers_help;
				 /**< @brief List all connected PCSC devices help description.  */
    int applet_list_flag;
			/**< @brief List applets on device (default=off).  */
    const char *applet_list_help;
				/**< @brief List applets on device help description.  */
    char *applet_delete_arg;	/**< @brief Delete given applet AID from device.  */
    char *applet_delete_orig;	/**< @brief Delete given applet AID from device original value given at command line.  */
    const char *applet_delete_help;
				  /**< @brief Delete given applet AID from device help description.  */
    char *applet_install_arg;	/**< @brief Install applets on device from CAP file.  */
    char *applet_install_orig;	/**< @brief Install applets on device from CAP file original value given at command line.  */
    const char *applet_install_help;
				   /**< @brief Install applets on device from CAP file help description.  */
    char *set_mode_arg;	/**< @brief Set the USB operation mode of the YubiKey NEO.
  The possible MODE arguments are:
  0 for HID device only,
  1 for CCID device only,
  81 for CCID device with touch eject,
  2 for HID/CCID composite device,
  3 for U2F device only,
  4 for OTP/U2F composite device,
  5 for U2F/CCID composite device,
  6 for OTP/U2F/CCID composite device..  */
    char *set_mode_orig;/**< @brief Set the USB operation mode of the YubiKey NEO.
  The possible MODE arguments are:
  0 for HID device only,
  1 for CCID device only,
  81 for CCID device with touch eject,
  2 for HID/CCID composite device,
  3 for U2F device only,
  4 for OTP/U2F composite device,
  5 for U2F/CCID composite device,
  6 for OTP/U2F/CCID composite device. original value given at command line.  */
    const char *set_mode_help;
			     /**< @brief Set the USB operation mode of the YubiKey NEO.
  The possible MODE arguments are:
  0 for HID device only,
  1 for CCID device only,
  81 for CCID device with touch eject,
  2 for HID/CCID composite device,
  3 for U2F device only,
  4 for OTP/U2F composite device,
  5 for U2F/CCID composite device,
  6 for OTP/U2F/CCID composite device. help description.  */
    char **send_apdu_arg;	/**< @brief Send an arbitrary APDU to the device.  */
    char **send_apdu_orig;	/**< @brief Send an arbitrary APDU to the device original value given at command line.  */
    unsigned int send_apdu_min;
			      /**< @brief Send an arbitrary APDU to the device's minimum occurreces */
    unsigned int send_apdu_max;
			      /**< @brief Send an arbitrary APDU to the device's maximum occurreces */
    const char *send_apdu_help;
			      /**< @brief Send an arbitrary APDU to the device help description.  */
    char *reader_arg;	/**< @brief Use only a matching card reader.  */
    char *reader_orig;	/**< @brief Use only a matching card reader original value given at command line.  */
    const char *reader_help;
			   /**< @brief Use only a matching card reader help description.  */
    int debug_flag;	/**< @brief Print debug information to standard error (default=off).  */
    const char *debug_help;
			  /**< @brief Print debug information to standard error help description.  */

    unsigned int help_given;	/**< @brief Whether help was given.  */
    unsigned int version_given;	/**< @brief Whether version was given.  */
    unsigned int get_mode_given;/**< @brief Whether get-mode was given.  */
    unsigned int get_version_given;	/**< @brief Whether get-version was given.  */
    unsigned int get_serialno_given;	/**< @brief Whether get-serialno was given.  */
    unsigned int list_readers_given;	/**< @brief Whether list-readers was given.  */
    unsigned int applet_list_given;	/**< @brief Whether applet-list was given.  */
    unsigned int applet_delete_given;	/**< @brief Whether applet-delete was given.  */
    unsigned int applet_install_given;	/**< @brief Whether applet-install was given.  */
    unsigned int set_mode_given;/**< @brief Whether set-mode was given.  */
    unsigned int send_apdu_given;	/**< @brief Whether send-apdu was given.  */
    unsigned int reader_given;	/**< @brief Whether reader was given.  */
    unsigned int debug_given;	/**< @brief Whether debug was given.  */

  };

/** @brief The additional parameters to pass to parser functions */
  struct cmdline_parser_params
  {
    int override;
		/**< @brief whether to override possibly already present options (default 0) */
    int initialize;
		  /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
    int check_required;
		      /**< @brief whether to check that all required options were provided (default 1) */
    int check_ambiguity;
		       /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
    int print_errors;
		    /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
  };

/** @brief the purpose string of the program */
  extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
  extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
  extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
  extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
  int cmdline_parser (int argc, char **argv,
		      struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
  int cmdline_parser2 (int argc, char **argv,
		       struct gengetopt_args_info *args_info,
		       int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
  int cmdline_parser_ext (int argc, char **argv,
			  struct gengetopt_args_info *args_info,
			  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
  int cmdline_parser_dump (FILE * outfile,
			   struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
  int cmdline_parser_file_save (const char *filename,
				struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
  void cmdline_parser_print_help (void);
/**
 * Print the version
 */
  void cmdline_parser_print_version (void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
  void cmdline_parser_params_init (struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
  struct cmdline_parser_params *cmdline_parser_params_create (void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
  void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
  void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
  int cmdline_parser_required (struct gengetopt_args_info *args_info,
			       const char *prog_name);


#ifdef __cplusplus
}
#endif				/* __cplusplus */
#endif				/* CMDLINE_H */
