#!/bin/sh

set -e

DESTDIR=${DESTDIR:-..}
MODULE=WWW-Search
PACKAGE=libwww-search-perl
VERSION=2.51.80
EBAY_VERS=`cat debian/components/ebay/version`
ALTAVISTA_VERS=`cat debian/components/altavista/version`
FIRSTGOV_VERS=`cat debian/components/firstgov/version`
GOOGLISM_VERS=`cat debian/components/googlism/version`
JOBSERVE_VERS=`cat debian/components/jobserve/version`
LYCOS_VERS=`cat debian/components/lycos/version`
PAGESJAUNES_VERS=`cat debian/components/pagesjaunes/version`
YAHOO_VERS=`cat debian/components/yahoo/version`
FD=--force-download
NS=--no-symlink
RE=--rename
DD="--destdir ${DESTDIR}"
RS=--report-status
DC="--watch debian/components"
US=--upstream-version

if [ $1 ]
then
    echo update;
    rm -f ${DESTDIR}/${MODULE}*.tar.gz
    uscan ${FD} ${RE} ${DD} && true;
    uscan ${DC}/ebay/watch ${FD} ${NS} ${DD} ${US} ${EBAY_VERS} && true;
    uscan ${DC}/altavista/watch ${FD} ${NS} ${DD} ${US} ${ALTAVISTA_VERS} && true;
    uscan ${DC}/firstgov/watch ${FD} ${NS} ${DD} ${US} ${FIRSTGOV_VERS} && true;
    uscan ${DC}/googlism/watch ${FD} ${NS} ${DD} ${US} ${GOOGLISM_VERS} && true;
    uscan ${DC}/jobserve/watch ${FD} ${NS} ${DD} ${US} ${JOBSERVE_VERS} && true;
    uscan ${DC}/lycos/watch ${FD} ${NS} ${DD} ${US} ${LYCOS_VERS} && true;
    uscan ${DC}/pagesjaunes/watch ${FD} ${NS} ${DD} ${US} ${PAGESJAUNES_VERS} && true;
    uscan ${DC}/yahoo/watch ${FD} ${NS} ${DD} ${US} ${YAHOO_VERS} && true;
    cd ${DESTDIR}
    EBAY=`ls ${MODULE}-Ebay*.tar.gz`
    mv ${EBAY} ${PACKAGE}_${VERSION}.orig-ebay.tar.gz
    ALTAVISTA=`ls ${MODULE}-AltaVista*.tar.gz`
    mv ${ALTAVISTA} ${PACKAGE}_${VERSION}.orig-altavista.tar.gz
    FIRSTGOV=`ls ${MODULE}-FirstGov*.tar.gz`
    mv ${FIRSTGOV} ${PACKAGE}_${VERSION}.orig-firstgov.tar.gz
    PAGESJAUNES=`ls ${MODULE}-Pagesjaunes*.tar.gz`
    mv ${PAGESJAUNES} ${PACKAGE}_${VERSION}.orig-pagesjaunes.tar.gz
    LYCOS=`ls ${MODULE}-Lycos*.tar.gz`
    mv ${LYCOS} ${PACKAGE}_${VERSION}.orig-lycos.tar.gz
    JOBSERVE=`ls ${MODULE}-Jobserve*.tar.gz`
    mv ${JOBSERVE} ${PACKAGE}_${VERSION}.orig-jobserve.tar.gz
    YAHOO=`ls ${MODULE}-Yahoo*.tar.gz`
    mv ${YAHOO} ${PACKAGE}_${VERSION}.orig-yahoo.tar.gz
    GOOGLISM=`ls ${MODULE}-Googlism*.tar.gz`
    mv ${GOOGLISM} ${PACKAGE}_${VERSION}.orig-googlism.tar.gz
    cd -
else
    echo report;
    uscan ${RS} && true;
    uscan ${DC}/ebay/watch ${RS} ${DD} ${US} ${EBAY_VERS} && true;
    uscan ${DC}/altavista/watch ${RS} ${DD} ${US} ${ALTAVISTA_VERS} && true;
    uscan ${DC}/firstgov/watch ${RS} ${DD} ${US} ${FIRSTGOV_VERS} && true;
    uscan ${DC}/googlism/watch ${RS} ${DD} ${US} ${GOOGLISM_VERS} && true;
    uscan ${DC}/jobserve/watch ${RS} ${DD} ${US} ${JOBSERVE_VERS} && true;
    uscan ${DC}/lycos/watch ${RS} ${DD} ${US} ${LYCOS_VERS} && true;
    uscan ${DC}/pagesjaunes/watch ${RS} ${DD} ${US} ${PAGESJAUNES_VERS} && true;
    uscan ${DC}/yahoo/watch ${RS} ${DD} ${US} ${YAHOO_VERS} && true;
fi
