/*
 * libspe - A wrapper library to adapt the JSRE SPU usage model to SPUFS
 * Copyright (C) 2005 IBM Corp.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License,
 * or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 *  License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software Foundation,
 *   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __DEFAULT_SYSCALL_HANDLER
#define __DEFAULT_SYSCALL_HANDLER


#define SYS_OPEN   0x0101
#define SYS_CLOSE  0x0102
#define SYS_READ   0x0103
#define SYS_WRITE  0x0104
#define SYS_SEEK   0x0105
#define SYS_FSTAT  0x0106
#define SYS_UNLINK 0x0107


typedef struct
{
	unsigned short no;
	short rc;
	unsigned short err;
	unsigned char pad[64 - 3 * 2];
} syscall_t;

typedef struct
{
	unsigned short no;
	short rc;
	unsigned short err;
	int fd;
	unsigned long ptr;
	int len;
} syscall_write_t;

typedef struct
{
	unsigned short no;
	short rc;
	unsigned short err;
	int fd;
	unsigned long ptr;
	int len;
} syscall_read_t;

typedef struct
{
	unsigned short no;
	short rc;
	unsigned short err;
	unsigned long fd;
	unsigned long pathname;
	unsigned short flags;
	unsigned short mode;
} syscall_open_t;

typedef struct
{
	unsigned short no;
	short rc;
	unsigned short err;
	unsigned long fd;
} syscall_close_t;

typedef struct
{
	unsigned short no;
	short rc;
	unsigned short err;
	unsigned long fd;
	unsigned long offset;
	unsigned char whence;
} syscall_lseek_t;

typedef struct
{
	unsigned short no;
	short rc;
	unsigned short err;
	unsigned long fd;
	void *buf;
} syscall_fstat_t;

typedef struct
{
	unsigned short no;
	short rc;
	unsigned short err;
	char *pathname;
} syscall_unlink_t;


int default_syscall_handler (unsigned long *base, unsigned long args);

int default_syscall_handler_write (unsigned char *base, syscall_write_t * ps);
int default_syscall_handler_read (unsigned char *base, syscall_read_t * ps);
int default_syscall_handler_open (unsigned char *base, syscall_open_t * ps);
int default_syscall_handler_close (unsigned char *base, syscall_close_t * ps);
int default_syscall_handler_lseek (unsigned char *base, syscall_lseek_t * ps);
int default_syscall_handler_fstat (unsigned char *base, syscall_fstat_t * ps);
int default_syscall_handler_unlink (unsigned char *base,
				    syscall_unlink_t * ps);


#endif
