/*

Copyright (C) 2008-2022 Michele Martone

This file is part of librsb.

librsb is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

librsb is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public
License along with librsb; see the file COPYING.
If not, see <http://www.gnu.org/licenses/>.

*/
/* @cond INNERDOC */
/*!
 * @file
 * @author Michele Martone 
 * @brief This file is part of the Octave based test suite for librsb
 */
#include <stdio.h>
#ifdef SBTC_USE_RSB_H
#include <rsb.h>
#endif /* SBTC_USE_RSB_H */
#include <complex.h>
#ifdef RSB_RSB_H_INCLUDED
#include "rsb_internals.h"
#define RSB_BLAS_SUPPORT_EMPTY 1
#define RSB_BLAS_SUPPORTED_TYPE(T) ((errval = rsb__BLAS_is_type_supported(T)) != RSB_ERR_UNSUPPORTED_TYPE) 
#endif /* RSB_RSB_H_INCLUDED */
#ifndef RSB_RSB_H_INCLUDED
#include <blas_sparse.h>
#define RSB_PROGRAM_SUCCESS 0
#define RSB_PROGRAM_ERROR (-1)
#define RSB_ERR_NO_ERROR 0
#define RSB_ERROR printf
#define RSB_WITH_SPARSE_BLAS_INTERFACE 1
#define RSB_BLAS_SUPPORTED_TYPE(T) 1
/*#define rsb_err_t int*/
#define RSB_ERR_UNSUPPORTED_TYPE 0x004
/*#define rsb_nnz_idx_t int*/
/*#define rsb_coo_idx_t int*/
#define RSB_BLAS_ERROR -1
#define RSB_BLAS_NO_ERROR 0
#define RSB_BLAS_SUPPORT_EMPTY 0
#define rsb__debug_print_vectors_diff(A1,A2,A3,A4,A5,A6,A7) RSB_ERR_NO_ERROR
int rsb__do_are_same(void*v1_,void*v2_,int n,int typecode,int s1,int s2){ char*v1=(char*)v1_,*v2=(char*)v2_; int vi,bi,bs; switch(typecode){case('S'):bs=4;break;case('C'): case('D'):bs=8;break;case('Z'):bs=16;break;default: return RSB_ERR_NO_ERROR; } for(vi=0;vi< n;++vi) for(bi=0;bi<bs;++bi) if(v1[vi*bs*s1+bi] != v2[vi*bs*s2+bi]) return RSB_BLAS_ERROR; return RSB_ERR_NO_ERROR;}
#endif /* RSB_RSB_H_INCLUDED */
const int rsb_sbtc_print_vec(const void*v,int n,int typecode){ float*fv=(float*)v; double*dv=(double*)v; int vi,fl=1,fi; if(typecode=='C' || typecode=='Z')fl=2; if(typecode=='S' || typecode=='C')for(vi=0;vi<n;++vi){for(fi=0;fi<fl;++fi)printf("%f " ,fv[vi*fl+fi]);printf("\n");} if(typecode=='D' || typecode=='Z')for(vi=0;vi<n;++vi){for(fi=0;fi<fl;++fi)printf(" %lf",dv[vi*fl+fi]);printf("\n");} ; return RSB_ERR_NO_ERROR;}
	static rsb_err_t ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 0
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const float VA[]={ 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 3 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 0\n 0 0\n"	" y' = \n 6\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 0
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 9, 3 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 0\n 1 0\n"	" y' = \n 9\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 2
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 2 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 9 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 2\n 0 0\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 4
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 4 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 18, 0, 3, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 4\n 0 0\n"	" y' = \n 18\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 0
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 9, 0, 3, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 0\n 1 0\n"	" y' = \n 9\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 0, 9, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 0
 3 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const float VA[]={ 1, 3 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 6, 12 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 0\n 3 0\n"	" y' = \n 6\n 12\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 2
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 2 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 6, 9 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 2\n 0 0\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 2
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float VA[]={ 1, 2, 1 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 2\n 1 0\n"	" y' = \n 9\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 0
 0 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 3 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 6, 0, 12, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 0\n 0 3\n"	" y' = \n 6\n 12\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 9, 0, 6, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 9\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 0
 1 4
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 4 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 9, 0, 15, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 0\n 1 4\n"	" y' = \n 9\n 15\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 1
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 5, 3 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 1\n 0 0\n"	" y' = \n 5\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 2
 2 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float VA[]={ 1, 2, 2 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 5 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 2\n 2 0\n"	" y' = \n 6\n 5\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 3
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 3 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 4, 6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 3\n 0 0\n"	" y' = \n 4\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 5
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 5, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 9, 0, 4, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 5\n 0 1\n"	" y' = \n 9\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 3
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 3 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 4, 0, 6, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 3\n 0 0\n"	" y' = \n 4\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 0, 4, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 0\n 2 1\n"	" y' = \n 6\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 0
 0 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 3 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 4, 6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 0\n 0 3\n"	" y' = \n 4\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 0
 1 5
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 5 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 5, 8 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 0\n 1 5\n"	" y' = \n 5\n 8\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 1
 1 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float VA[]={ 1, 1, 1, 2 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 5, 6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 1\n 1 2\n"	" y' = \n 5\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 6, 0, 4, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 2\n 0 1\n"	" y' = \n 6\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 1
 0 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 2 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 4, 0, 6, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 1\n 0 2\n"	" y' = \n 4\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 4, 0, 6, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 2\n 0 1\n"	" y' = \n 4\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 0
 1 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 2 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 2, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 0\n 1 2\n"	" y' = \n 2\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 3
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float VA[]={ 1, 3, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 1, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 3\n 1 0\n"	" y' = \n 1\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 2, 1 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 2\n 1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 0
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 2, 0, 2, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 0\n 1 0\n"	" y' = \n 2\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 2, 0, 2, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 2\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 2, 0, 2, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 2\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 2 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 2, 1 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 0\n 0 2\n"	" y' = \n 2\n 1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 2 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 2, 3 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 0, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 0\n 2 3\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const float VA[]={ 1, 1 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 1, 3 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 1 0\n"	" y' = \n 1\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 1
 3 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float VA[]={ 1, 1, 3 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 1, 0, 0, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 1\n 3 0\n"	" y' = \n 1\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 1
 2 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float VA[]={ 1, 1, 2 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 0, 0, 2, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 1\n 2 0\n"	" y' = \n 0\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 3
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 3 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 2, 0, 0, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 3\n 0 0\n"	" y' = \n 2\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 0
 1 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 2 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, -6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 0\n 1 2\n"	" y' = \n 0\n -6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 1
 3 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float VA[]={ 1, 1, 3, 3 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ -9, -9 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 1\n 3 3\n"	" y' = \n -9\n -9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 2
 3 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float VA[]={ 1, 2, 3, 2 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ -6, 0, -12, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 2\n 3 2\n"	" y' = \n -6\n -12\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, 0, 0, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 3
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 3 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, 0, -6, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 3\n 0 0\n"	" y' = \n 0\n -6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 1
 1 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float VA[]={ 1, 1, 1, 2 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ -3, -6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 1\n 1 2\n"	" y' = \n -3\n -6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 1
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float VA[]={ 1, 1, 3, 1 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ -9, -3 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 1\n 3 1\n"	" y' = \n -9\n -3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 0, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 0
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const float VA[]={ 1, 1 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ 0, 0, 0, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 0\n 1 0\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 1
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ -3, 0, 0, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 1\n 1 0\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:s; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 3
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float VA[]={ 1, 3, 2, 1 };		/* x: 4 */
	const float x[]={ 1, 0, 1, 0 };/* reference x */
	const float cy[]={ -6, 0, -9, 0 };/* reference cy after */
	float y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 3\n 2 1\n"	" y' = \n -6\n -9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 1
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 9, 3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 1\n 0 0\n"	" y' = \n 9\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 2
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 2 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 6, 9 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 2\n 0 0\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 1
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 6, 6 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 1\n 0 0\n"	" y' = \n 6\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 1
 0 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 2 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 1\n 0 2\n"	" y' = \n 9\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 1
 0 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 2 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 6, 0, 12, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 1\n 0 2\n"	" y' = \n 6\n 12\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 0
 3 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const double VA[]={ 1, 3 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 15, 0, 3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 0\n 3 0\n"	" y' = \n 15\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 0
 0 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 3 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 6, 12 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 0\n 0 3\n"	" y' = \n 6\n 12\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 0
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double VA[]={ 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 6, 3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 0\n 0 0\n"	" y' = \n 6\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 2
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 2 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 6, 9 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 2\n 0 0\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 2
 0 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 2, 3 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 12, 0, 12, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 2\n 0 3\n"	" y' = \n 12\n 12\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 0
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const double VA[]={ 1, 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 9, 0, 3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 0\n 1 0\n"	" y' = \n 9\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 5
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 5 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 6, 0, 18, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 5\n 0 0\n"	" y' = \n 6\n 18\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 3
 0 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 3, 2 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 7, 5 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 3\n 0 2\n"	" y' = \n 7\n 5\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 4, 4 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 4\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 2
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double VA[]={ 1, 2, 3, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 7, 6 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 2\n 3 1\n"	" y' = \n 7\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 3
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 3 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 7, 0, 3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 3\n 0 0\n"	" y' = \n 7\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 3
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double VA[]={ 1, 3, 3, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 7, 0, 7, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 3\n 3 1\n"	" y' = \n 7\n 7\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 0
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 5, 0, 3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 0\n 1 0\n"	" y' = \n 5\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 0
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double VA[]={ 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 4, 3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 0\n 0 0\n"	" y' = \n 4\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 0
 3 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const double VA[]={ 1, 3 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 7, 3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 0\n 3 0\n"	" y' = \n 7\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 0
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double VA[]={ 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 4, 3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 0\n 0 0\n"	" y' = \n 4\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 1
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double VA[]={ 1, 1, 1, 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 5, 0, 5, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 1\n 1 1\n"	" y' = \n 5\n 5\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 2
 2 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double VA[]={ 1, 2, 2 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 6, 0, 5, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 2\n 2 0\n"	" y' = \n 6\n 5\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 0
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double VA[]={ 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 4, 0, 3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 0\n 0 0\n"	" y' = \n 4\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double VA[]={ 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 2, 3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 0\n 0 0\n"	" y' = \n 2\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 2
 3 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double VA[]={ 1, 2, 3, 2 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -1, -1 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 2\n 3 2\n"	" y' = \n -1\n -1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 0
 4 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const double VA[]={ 1, 4 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -2, 3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 4 0\n"	" y' = \n -2\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 2
 3 4
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double VA[]={ 1, 2, 3, 4 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 0, 0, -4, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 2\n 3 4\n"	" y' = \n 0\n -4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 1
 2 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double VA[]={ 1, 1, 2, 2 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 0, 0, 0, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 1\n 2 2\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 0
 3 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 3, 3 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -1, 0, 0, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 3 3\n"	" y' = \n -1\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 1
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double VA[]={ 1, 1, 3, 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 1, -1 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 1\n 3 1\n"	" y' = \n 1\n -1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 2
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double VA[]={ 1, 2, 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 2\n 1 0\n"	" y' = \n 1\n 1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ -1, 2 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 3 1\n"	" y' = \n -1\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double VA[]={ 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 2, 0, 3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 0\n 0 0\n"	" y' = \n 2\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 3 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 2, 0, 0, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 0\n 0 3\n"	" y' = \n 2\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 2, 0, 1, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 2\n 1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 2
 3 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double VA[]={ 1, 2, 3 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -6, -6 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 2\n 3 0\n"	" y' = \n -6\n -6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -3, 0 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 2 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 0, -3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 0\n 0 2\n"	" y' = \n 0\n -3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 2
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 2 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 0, 0, -3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 0\n 0 2\n"	" y' = \n 0\n -3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -3, 0, 0, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 2
 2 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double VA[]={ 1, 2, 2 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -6, 0, -3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 2\n 2 0\n"	" y' = \n -6\n -3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 2
 1 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double VA[]={ 1, 2, 1, 3 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ -6, -9 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 2\n 1 3\n"	" y' = \n -6\n -9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ -3, 0 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 1
 3 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double VA[]={ 1, 1, 3 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ -9, 0 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 1\n 3 0\n"	" y' = \n -9\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 1 3
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 3 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ 0, 0, -9, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 0\n 1 3\n"	" y' = \n 0\n -9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 1 0
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const double VA[]={ 1, 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ -3, 0, 3, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 1 0\n"	" y' = \n -3\n 3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:d; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 4 */
	const double x[]={ 1, 0, 1, 0 };/* reference x */
	const double cy[]={ -3, 0, 0, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmv(transT,alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+2i 1+3i
 0+3i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 1+3*I, 0+3*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 9+15*I, 6+9*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+2i 1+3i\n 0+3i 1+0i\n"	" y' = \n 9+15i\n 6+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+2i 0+1i
 0+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 0+1*I, 0+1*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 6+9*I, 3+3*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+2i 0+1i\n 0+1i 0+0i\n"	" y' = \n 6+9i\n 3+3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+2i 0+4i
 0+4i 1+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+4*I, 0+4*I, 1+4*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 6+-18*I, 6+-24*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+2i 0+4i\n 0+4i 1+4i\n"	" y' = \n 6+-18i\n 6+-24i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+2i 1+0i
 0+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 9+6*I, 0+0*I, 3+0*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+2i 1+0i\n 0+0i 0+0i\n"	" y' = \n 9+6i\n 3+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+2i 0+1i
 0+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 0+1*I, 0+1*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 6+9*I, 0+0*I, 3+3*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+2i 0+1i\n 0+1i 0+0i\n"	" y' = \n 6+9i\n 3+3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+2i 5+2i
 1+2i 2+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 5+2*I, 1+2*I, 2+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 9+-12*I, 0+0*I, 24+-6*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+2i 5+2i\n 1+2i 2+0i\n"	" y' = \n 9+-12i\n 24+-6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+2i 0+1i
 0+1i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+1*I, 0+1*I, 1+0*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 6+9*I, 6+3*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+2i 0+1i\n 0+1i 1+0i\n"	" y' = \n 6+9i\n 6+3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+2i 1+4i
 1+4i 0+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 1+4*I, 1+4*I, 0+4*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 9+18*I, 6+24*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+2i 1+4i\n 1+4i 0+4i\n"	" y' = \n 9+18i\n 6+24i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+2i 0+3i
 0+3i 2+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+3*I, 0+3*I, 2+2*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 6+-15*I, 9+-15*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+2i 0+3i\n 0+3i 2+2i\n"	" y' = \n 6+-15i\n 9+-15i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+2i 3+3i
 3+3i 2+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 3+3*I, 3+3*I, 2+0*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 15+15*I, 0+0*I, 18+9*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+2i 3+3i\n 3+3i 2+0i\n"	" y' = \n 15+15i\n 18+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+2i 0+0i
 0+0i 3+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1+2*I, 3+0*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 6+6*I, 0+0*I, 12+0*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+2i 0+0i\n 0+0i 3+0i\n"	" y' = \n 6+6i\n 12+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+2i 2+2i
 0+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 2+2*I, 0+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 6+-12*I, 0+0*I, 12+-6*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+2i 2+2i\n 0+2i 1+0i\n"	" y' = \n 6+-12i\n 12+-6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+2i 1+0i
 1+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 1+0*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 5+2*I, 4+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+2i 1+0i\n 1+0i 0+0i\n"	" y' = \n 5+2i\n 4+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+2i 0+0i
 0+0i 3+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1+2*I, 3+4*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 4+2*I, 6+4*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+2i 0+0i\n 0+0i 3+4i\n"	" y' = \n 4+2i\n 6+4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+2i 3+6i
 1+6i 2+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 3+6*I, 1+6*I, 2+4*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 5+-8*I, 8+-10*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+2i 3+6i\n 1+6i 2+4i\n"	" y' = \n 5+-8i\n 8+-10i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+2i 0+4i
 2+4i 3+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+4*I, 2+4*I, 3+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 4+6*I, 0+0*I, 8+4*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+2i 0+4i\n 2+4i 3+0i\n"	" y' = \n 4+6i\n 8+4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+2i 1+0i
 4+0i 0+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 1+0*I, 4+0*I, 0+2*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 8+2*I, 0+0*I, 4+2*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+2i 1+0i\n 4+0i 0+2i\n"	" y' = \n 8+2i\n 4+2i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+2i 0+2i
 1+2i 6+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+2*I, 1+2*I, 6+2*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 5+-4*I, 0+0*I, 9+-4*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+2i 0+2i\n 1+2i 6+2i\n"	" y' = \n 5+-4i\n 9+-4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1+2i 2+1i
 0+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 2+1*I, 0+1*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 6+3*I, 3+1*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+2i 2+1i\n 0+1i 0+0i\n"	" y' = \n 6+3i\n 3+1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1+2i 2+1i
 2+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 2+1*I, 2+1*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 6+3*I, 5+1*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+2i 2+1i\n 2+1i 0+0i\n"	" y' = \n 6+3i\n 5+1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1+2i 0+4i
 1+4i 4+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+4*I, 1+4*I, 4+2*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 5+-6*I, 7+-6*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+2i 0+4i\n 1+4i 4+2i\n"	" y' = \n 5+-6i\n 7+-6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1+2i 1+6i
 0+6i 5+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 1+6*I, 0+6*I, 5+2*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 5+8*I, 0+0*I, 8+8*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+2i 1+6i\n 0+6i 5+2i\n"	" y' = \n 5+8i\n 8+8i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1+2i 0+2i
 0+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+2*I, 0+2*I, 1+0*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 4+4*I, 0+0*I, 4+2*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+2i 0+2i\n 0+2i 1+0i\n"	" y' = \n 4+4i\n 4+2i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1+2i 1+0i
 1+0i 2+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 1+0*I, 1+0*I, 2+4*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 5+-2*I, 0+0*I, 6+-4*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+2i 1+0i\n 1+0i 2+4i\n"	" y' = \n 5+-2i\n 6+-4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+1i
 2+1i 1+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+1*I, 2+1*I, 1+4*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 2+-3*I, 0+-5*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+2i 0+1i\n 2+1i 1+4i\n"	" y' = \n 2+-3i\n 0+-5i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+0i
 3+0i 1+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+2*I, 3+0*I, 1+4*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ -1+-2*I, 2+-4*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+2i 0+0i\n 3+0i 1+4i\n"	" y' = \n -1+-2i\n 2+-4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 2+1i
 2+1i 1+6i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 2+1*I, 2+1*I, 1+6*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 0+3*I, 0+7*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+2i 2+1i\n 2+1i 1+6i\n"	" y' = \n 0+3i\n 0+7i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+2i
 4+2i 3+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+2*I, 4+2*I, 3+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 2+-4*I, 0+0*I, -4+-2*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+2i 0+2i\n 4+2i 3+0i\n"	" y' = \n 2+-4i\n -4+-2i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+2i
 0+2i 0+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+2*I, 0+2*I, 0+2*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 2+-4*I, 0+0*I, 3+-4*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+2i 0+2i\n 0+2i 0+2i\n"	" y' = \n 2+-4i\n 3+-4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+0i
 1+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const float complex VA[]={ 1+2*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 1+2*I, 0+0*I, 3+0*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+2i 0+0i\n 1+0i 0+0i\n"	" y' = \n 1+2i\n 3+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+3i
 0+3i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 0+3*I, 0+3*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 2+-5*I, 3+-3*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+2i 0+3i\n 0+3i 0+0i\n"	" y' = \n 2+-5i\n 3+-3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 1+0i
 0+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 2+-2*I, 2+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+2i 1+0i\n 0+0i 0+0i\n"	" y' = \n 2+-2i\n 2+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+3i
 0+3i 0+6i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+3*I, 0+3*I, 0+6*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 2+5*I, 3+9*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+2i 0+3i\n 0+3i 0+6i\n"	" y' = \n 2+5i\n 3+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+3i
 2+3i 2+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+3*I, 2+3*I, 2+0*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 2+-5*I, 0+0*I, -1+-3*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+2i 0+3i\n 2+3i 2+0i\n"	" y' = \n 2+-5i\n -1+-3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+0i
 1+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const float complex VA[]={ 1+2*I, 1+0*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 1+-2*I, 0+0*I, 3+0*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+2i 0+0i\n 1+0i 0+0i\n"	" y' = \n 1+-2i\n 3+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+2i 0+3i
 0+3i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+3*I, 0+3*I, 1+0*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 2+5*I, 0+0*I, 2+3*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+2i 0+3i\n 0+3i 1+0i\n"	" y' = \n 2+5i\n 2+3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 0+2i
 3+2i 3+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+2*I, 3+2*I, 3+2*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 0+-12*I, -15+-12*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+2i 0+2i\n 3+2i 3+2i\n"	" y' = \n 0+-12i\n -15+-12i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 0+2i
 0+2i 0+12i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+2*I, 0+2*I, 0+12*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 0+-12*I, 3+-42*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+2i 0+2i\n 0+2i 0+12i\n"	" y' = \n 0+-12i\n 3+-42i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 3+0i
 1+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 3+0*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ -3+6*I, -6+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+2i 3+0i\n 1+0i 0+0i\n"	" y' = \n -3+6i\n -6+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 1+4i
 0+4i 0+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 1+4*I, 0+4*I, 0+2*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ -3+-18*I, 0+0*I, 3+-18*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+2i 1+4i\n 0+4i 0+2i\n"	" y' = \n -3+-18i\n 3+-18i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 0+2i
 0+2i 3+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+2*I, 0+2*I, 3+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 0+-12*I, 0+0*I, -6+-6*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+2i 0+2i\n 0+2i 3+0i\n"	" y' = \n 0+-12i\n -6+-6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 0+6i
 1+6i 0+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+6*I, 1+6*I, 0+4*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ -3+24*I, 0+0*I, 3+30*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+2i 0+6i\n 1+6i 0+4i\n"	" y' = \n -3+24i\n 3+30i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 2+4i
 0+4i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 2+4*I, 0+4*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ -6+-18*I, 3+-12*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+2i 2+4i\n 0+4i 0+0i\n"	" y' = \n -6+-18i\n 3+-12i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 2+2i
 2+2i 0+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 2+2*I, 2+2*I, 0+2*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ -6+-12*I, -3+-12*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+2i 2+2i\n 2+2i 0+2i\n"	" y' = \n -6+-12i\n -3+-12i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 6+3i
 4+3i 0+12i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 6+3*I, 4+3*I, 0+12*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ -12+15*I, -15+45*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+2i 6+3i\n 4+3i 0+12i\n"	" y' = \n -12+15i\n -15+45i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 1+3i
 1+3i 0+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 1+3*I, 1+3*I, 0+2*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ -3+-15*I, 0+0*I, 0+-15*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+2i 1+3i\n 1+3i 0+2i\n"	" y' = \n -3+-15i\n 0+-15i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 0+2i
 1+2i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const float complex VA[]={ 1+2*I, 0+2*I, 1+2*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ -3+-12*I, 0+0*I, 3+-6*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+2i 0+2i\n 1+2i 0+0i\n"	" y' = \n -3+-12i\n 3+-6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:c; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+2i 0+1i
 0+1i 3+6i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const float complex VA[]={ 1+2*I, 0+1*I, 0+1*I, 3+6*I };		/* x: 4 */
	const float complex x[]={ 1, 0, 1, 0 };/* reference x */
	const float complex cy[]={ 0+9*I, 0+0*I, -6+21*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+2i 0+1i\n 0+1i 3+6i\n"	" y' = \n 0+9i\n -6+21i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1+2i 0+3i
 0+3i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+3*I, 0+3*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 6+15*I, 6+9*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+2i 0+3i\n 0+3i 1+0i\n"	" y' = \n 6+15i\n 6+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1+2i 1+0i
 0+0i 3+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+2*I, 1+0*I, 3+4*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 6+6*I, 15+12*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+2i 1+0i\n 0+0i 3+4i\n"	" y' = \n 6+6i\n 15+12i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1+2i 0+0i
 0+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double complex VA[]={ 1+2*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 6+-6*I, 3+0*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+2i 0+0i\n 0+0i 0+0i\n"	" y' = \n 6+-6i\n 3+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1+2i 0+2i
 0+2i 0+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+2*I, 0+2*I, 0+2*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 6+12*I, 0+0*I, 3+12*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+2i 0+2i\n 0+2i 0+2i\n"	" y' = \n 6+12i\n 3+12i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1+2i 3+3i
 1+3i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 3+3*I, 1+3*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 9+15*I, 0+0*I, 15+9*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+2i 3+3i\n 1+3i 1+0i\n"	" y' = \n 9+15i\n 15+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1+2i 0+2i
 1+2i 3+6i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+2*I, 1+2*I, 3+6*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 9+-12*I, 0+0*I, 12+-24*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+2i 0+2i\n 1+2i 3+6i\n"	" y' = \n 9+-12i\n 12+-24i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+2i 1+0i
 0+0i 0+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+2*I, 1+0*I, 0+2*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 9+6*I, 3+6*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+2i 1+0i\n 0+0i 0+2i\n"	" y' = \n 9+6i\n 3+6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+2i 0+3i
 1+3i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+3*I, 1+3*I, 1+0*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 9+15*I, 6+9*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+2i 0+3i\n 1+3i 1+0i\n"	" y' = \n 9+15i\n 6+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+2i 0+3i
 5+3i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 0+3*I, 5+3*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 21+-15*I, 3+-9*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+2i 0+3i\n 5+3i 0+0i\n"	" y' = \n 21+-15i\n 3+-9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+2i 0+3i
 0+3i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 0+3*I, 0+3*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 6+15*I, 0+0*I, 3+9*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+2i 0+3i\n 0+3i 0+0i\n"	" y' = \n 6+15i\n 3+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+2i 3+3i
 0+3i 2+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 3+3*I, 0+3*I, 2+0*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 6+15*I, 0+0*I, 18+9*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+2i 3+3i\n 0+3i 2+0i\n"	" y' = \n 6+15i\n 18+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+2i 0+6i
 0+6i 0+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+6*I, 0+6*I, 0+4*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 6+-24*I, 0+0*I, 3+-30*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+2i 0+6i\n 0+6i 0+4i\n"	" y' = \n 6+-24i\n 3+-30i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1+2i 0+3i
 0+3i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 0+3*I, 0+3*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 4+5*I, 3+3*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+2i 0+3i\n 0+3i 0+0i\n"	" y' = \n 4+5i\n 3+3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1+2i 0+1i
 0+1i 2+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+1*I, 0+1*I, 2+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 4+3*I, 5+1*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+2i 0+1i\n 0+1i 2+0i\n"	" y' = \n 4+3i\n 5+1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1+2i 1+0i
 0+0i 1+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+2*I, 1+0*I, 1+2*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 4+-2*I, 5+-2*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+2i 1+0i\n 0+0i 1+2i\n"	" y' = \n 4+-2i\n 5+-2i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1+2i 0+4i
 0+4i 3+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+4*I, 0+4*I, 3+2*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 4+6*I, 0+0*I, 6+6*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+2i 0+4i\n 0+4i 3+2i\n"	" y' = \n 4+6i\n 6+6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1+2i 0+0i
 0+0i 2+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1+2*I, 2+2*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 4+2*I, 0+0*I, 5+2*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+2i 0+0i\n 0+0i 2+2i\n"	" y' = \n 4+2i\n 5+2i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1+2i 0+0i
 1+0i 4+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double complex VA[]={ 1+2*I, 1+0*I, 4+2*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 5+-2*I, 0+0*I, 7+-2*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+2i 0+0i\n 1+0i 4+2i\n"	" y' = \n 5+-2i\n 7+-2i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1+2i 3+1i
 0+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 3+1*I, 0+1*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 7+3*I, 3+1*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+2i 3+1i\n 0+1i 0+0i\n"	" y' = \n 7+3i\n 3+1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1+2i 1+4i
 3+4i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 1+4*I, 3+4*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 7+6*I, 4+4*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+2i 1+4i\n 3+4i 0+0i\n"	" y' = \n 7+6i\n 4+4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1+2i 1+0i
 0+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1+2*I, 1+0*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 4+-2*I, 4+0*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+2i 1+0i\n 0+0i 0+0i\n"	" y' = \n 4+-2i\n 4+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1+2i 0+4i
 0+4i 0+6i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+4*I, 0+4*I, 0+6*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 4+6*I, 0+0*I, 3+10*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+2i 0+4i\n 0+4i 0+6i\n"	" y' = \n 4+6i\n 3+10i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1+2i 0+1i
 3+1i 3+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+1*I, 3+1*I, 3+0*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 7+3*I, 0+0*I, 6+1*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+2i 0+1i\n 3+1i 3+0i\n"	" y' = \n 7+3i\n 6+1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1+2i 0+2i
 0+2i 4+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+2*I, 0+2*I, 4+4*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 4+-4*I, 0+0*I, 7+-6*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+2i 0+2i\n 0+2i 4+4i\n"	" y' = \n 4+-4i\n 7+-6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 0+0i
 2+0i 3+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double complex VA[]={ 1+2*I, 2+0*I, 3+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 2+-2*I, -2+0*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+2i 0+0i\n 2+0i 3+0i\n"	" y' = \n 2+-2i\n -2+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 0+2i
 1+2i 2+6i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+2*I, 1+2*I, 2+6*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 1+-4*I, 1+-8*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+2i 0+2i\n 1+2i 2+6i\n"	" y' = \n 1+-4i\n 1+-8i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 1+1i
 3+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 1+1*I, 3+1*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ -1+3*I, 2+1*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+2i 1+1i\n 3+1i 0+0i\n"	" y' = \n -1+3i\n 2+1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 0+0i
 0+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double complex VA[]={ 1+2*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 2+-2*I, 0+0*I, 3+0*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+2i 0+0i\n 0+0i 0+0i\n"	" y' = \n 2+-2i\n 3+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 1+1i
 2+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 1+1*I, 2+1*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0+-3*I, 0+0*I, 2+-1*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+2i 1+1i\n 2+1i 0+0i\n"	" y' = \n 0+-3i\n 2+-1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 4+5i
 2+5i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 4+5*I, 2+5*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0+7*I, 0+0*I, -1+5*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+2i 4+5i\n 2+5i 0+0i\n"	" y' = \n 0+7i\n -1+5i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 0+0i
 0+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=1;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0 };
	const rsb_coo_idx_t JA[]={ 0 };
	const double complex VA[]={ 1+2*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 2+-2*I, 3+0*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+2i 0+0i\n 0+0i 0+0i\n"	" y' = \n 2+-2i\n 3+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 1+0i
 1+0i 0+10i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 1+0*I, 1+0*I, 0+10*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 1+-2*I, 2+-10*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+2i 1+0i\n 1+0i 0+10i\n"	" y' = \n 1+-2i\n 2+-10i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 3+1i
 2+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 3+1*I, 2+1*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 0+3*I, 0+1*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+2i 3+1i\n 2+1i 0+0i\n"	" y' = \n 0+3i\n 0+1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 0+1i
 0+1i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 0+1*I, 0+1*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 2+-3*I, 0+0*I, 3+-1*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+2i 0+1i\n 0+1i 0+0i\n"	" y' = \n 2+-3i\n 3+-1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 0+2i
 0+2i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 0+2*I, 0+2*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 2+-4*I, 0+0*I, 3+-2*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+2i 0+2i\n 0+2i 0+0i\n"	" y' = \n 2+-4i\n 3+-2i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+2i 1+1i
 0+1i 5+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 1+1*I, 0+1*I, 5+0*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 2+3*I, 0+0*I, -3+1*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+2i 1+1i\n 0+1i 5+0i\n"	" y' = \n 2+3i\n -3+1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 2+0i
 2+0i 0+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 2+0*I, 2+0*I, 0+2*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ -6+-6*I, -3+-6*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+2i 2+0i\n 2+0i 0+2i\n"	" y' = \n -6+-6i\n -3+-6i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 0+3i
 0+3i 1+2i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+3*I, 0+3*I, 1+2*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0+-15*I, 0+-15*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+2i 0+3i\n 0+3i 1+2i\n"	" y' = \n 0+-15i\n 0+-15i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 1+3i
 3+3i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 1+3*I, 3+3*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ -9+15*I, -3+9*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+2i 1+3i\n 3+3i 1+0i\n"	" y' = \n -9+15i\n -3+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 0+5i
 3+5i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0 };
	const double complex VA[]={ 1+2*I, 0+5*I, 3+5*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0+-21*I, 0+0*I, -6+-15*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+2i 0+5i\n 3+5i 0+0i\n"	" y' = \n 0+-21i\n -6+-15i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 0+3i
 0+3i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+3*I, 0+3*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0+-15*I, 0+0*I, 0+-9*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+2i 0+3i\n 0+3i 1+0i\n"	" y' = \n 0+-15i\n 0+-9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 0+4i
 0+4i 1+6i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+4*I, 0+4*I, 1+6*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0+18*I, 0+0*I, 0+30*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+2i 0+4i\n 0+4i 1+6i\n"	" y' = \n 0+18i\n 0+30i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 0+2i
 0+2i 0+4i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+2*I, 0+2*I, 0+4*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 0+-12*I, 3+-18*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+2i 0+2i\n 0+2i 0+4i\n"	" y' = \n 0+-12i\n 3+-18i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 0+0i
 1+0i 0+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0 };
	const double complex VA[]={ 1+2*I, 1+0*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ -3+-6*I, 3+0*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+2i 0+0i\n 1+0i 0+0i\n"	" y' = \n -3+-6i\n 3+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 2+1i
 0+1i 2+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 2+1*I, 0+1*I, 2+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 0+9*I, -9+3*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+2i 2+1i\n 0+1i 2+0i\n"	" y' = \n 0+9i\n -9+3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:n kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 1+0i
 0+0i 2+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+2*I, 1+0*I, 2+0*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ -3+-6*I, 0+0*I, -3+0*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+2i 1+0i\n 0+0i 2+0i\n"	" y' = \n -3+-6i\n -3+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:t kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 1+0i
 0+0i 2+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+2*I, 1+0*I, 2+0*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 0+-6*I, 0+0*I, -6+0*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+2i 1+0i\n 0+0i 2+0i\n"	" y' = \n 0+-6i\n -6+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:usmv; type:z; trans:c kind:g; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1+2i 0+2i
 0+2i 0+10i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=4;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 0, 1 };
	const double complex VA[]={ 1+2*I, 0+2*I, 0+2*I, 0+10*I };		/* x: 4 */
	const double complex x[]={ 1, 0, 1, 0 };/* reference x */
	const double complex cy[]={ 0+12*I, 0+0*I, 3+36*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+2i 0+2i\n 0+2i 0+10i\n"	" y' = \n 0+12i\n 3+36i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmv(transT,&alpha,A,x,incx,y,incy) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=g diag=e blocks=1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ 9, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 9\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ 3, 9 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 9\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ 12, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 12\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ 3, 0, 6, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ 3, 0, 6, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ 1, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ 1, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 6
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 6, 1 };/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ 1, 0, 7, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 6\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 7\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ 1, 0, 4, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 4\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 4
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 4, 1 };/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ -5, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 4\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -5\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ -1, -4 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -4\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ -1, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ -1, 0, -1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ -1, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ -1, 0, -2, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -2\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ -9, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -9\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ -3, -6 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ -3, -12 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -12\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ -12, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -12\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ -3, 0, -6, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_ussv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ -3, 0, -12, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -12\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 15, 6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 3\n 0 1\n"	" y' = \n 15\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 6\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 15 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 3\n 0 1\n"	" y' = \n 6\n 15\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 4, 4 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 4\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 4, 4 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 4\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 4, 5 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 4\n 5\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 1, 2 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 1\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 2, 2 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 2\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 2, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 2\n 0 1\n"	" y' = \n 2\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ -9, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 3\n 0 1\n"	" y' = \n -9\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 3, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, -9 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 3\n 0 1\n"	" y' = \n 0\n -9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_su_de_usmm_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-3;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float VA[]={ 1, 2, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, -6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 2\n 0 1\n"	" y' = \n 0\n -6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ 3, 6 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ 3, 0, 9, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 9\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 2, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ 3, 0, 9, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 9\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ 1, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 3, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ 4, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 4\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ 1, 0, 4, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 4\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ 1, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ -1, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 5
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 5, 1 };/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ -1, -6 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 5\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ -1, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ -1, 0, -1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ -1, 0, -1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 3, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ -1, 0, -4, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -4\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ -3, 0, -6, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_ussv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 9, 6 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 9\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 6, 9 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 6, 15 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 3\n 0 1\n"	" y' = \n 6\n 15\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 5, 4 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 5\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 4, 4 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 4\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 4, 4 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 4\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 1, 2 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 1\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 2, 1 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 2\n 1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 2, 2 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 2\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -3, 0 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 0, 0 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_su_de_usmm_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 0, -3 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 0\n -3\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+0i 2+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 2+2*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ 9+6*I, 3+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1+0i 2+2i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 9+6i\n 3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+0i 6+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 6+2*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ 3+0*I, 21+6*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1+0i 6+2i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+0i\n 21+6i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+1*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ 3+3*I, 0+0*I, 3+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+3i\n 3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+3*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ 3+0*I, 0+0*I, 3+9*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1+0i 0+3i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+0i\n 3+9i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+0i 1+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 1+1*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ 3+0*I, 0+0*I, 6+-3*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1+0i 1+1i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+0i\n 6+-3i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+0i 2+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 2+2*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ 3+2*I, 1+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1+0i 2+2i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n 3+2i\n 1+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+0i 0+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+2*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ 1+0*I, 1+2*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1+0i 0+2i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n 1+0i\n 1+2i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+1*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ 1+0*I, 1+-1*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n 1+0i\n 1+-1i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ 1, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ 1, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1+0i 0+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+3*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ 1+0*I, 0+0*I, 1+-3*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1+0i 0+3i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n 1+0i\n 1+-3i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1, 1, 1 };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ -2, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -2\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1, 2, 1 };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ -1, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1, 1, 1 };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ -1, -2 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -2\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 1+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 1+3*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ -2+-3*I, 0+0*I, -1+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1+0i 1+3i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -2+-3i\n -1+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ -1, 0, -2, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -2\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 4+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 4+3*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ -1+0*I, 0+0*I, -5+3*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1+0i 4+3i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+0i\n -5+3i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1, 3, 1 };/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ -3, -12 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -12\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1, 1, 1 };/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ -6, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -6\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 4+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 4+1*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ -3+0*I, 0+0*I, -15+-3*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1+0i 4+1i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n -3+0i\n -15+-3i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_ussv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1, 1, 1 };/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ -3, 0, -6, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+4i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+4*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 6+12*I, 6+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+0i 0+4i\n 0+0i 1+0i\n"	" y' = \n 6+12i\n 6+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=3;
	/*
 A = 
 1+0i 4+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 4+3*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 6+0*I, 18+9*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+0i 4+3i\n 0+0i 1+0i\n"	" y' = \n 6+0i\n 18+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+1*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 6+0*I, 6+-3*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y' = \n 6+0i\n 6+-3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=1;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+1*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 4+1*I, 4+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y' = \n 4+1i\n 4+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=1;
	/*
 A = 
 1+0i 0+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+2*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 4+0*I, 4+2*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+0i 0+2i\n 0+0i 1+0i\n"	" y' = \n 4+0i\n 4+2i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=1;
	/*
 A = 
 1+0i 2+5i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 2+5*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 4+0*I, 6+-5*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+0i 2+5i\n 0+0i 1+0i\n"	" y' = \n 4+0i\n 6+-5i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+2*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 2+-2*I, 2+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+0i 0+2i\n 0+0i 1+0i\n"	" y' = \n 2+-2i\n 2+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+3*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 2+0*I, 2+-3*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+0i 0+3i\n 0+0i 1+0i\n"	" y' = \n 2+0i\n 2+-3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+4i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+4*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 2+0*I, 2+4*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1+0i 0+4i\n 0+0i 1+0i\n"	" y' = \n 2+0i\n 2+4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ -3, 0 };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 0+1*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 0+0*I, 0+-3*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y' = \n 0+0i\n 0+-3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_su_de_usmm_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 1+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const float complex VA[]={ 1+0*I, 1+3*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 0+0*I, -3+9*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+0i 1+3i\n 0+0i 1+0i\n"	" y' = \n 0+0i\n -3+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1+0i 1+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 1+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 9, 9 };/* reference cy after */
	double complex y[]={ 6+6*I, 3+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1+0i 1+2i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 6+6i\n 3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };/* type is double complex */

	const double complex cy[]={ 9, 9 };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 1, 1 };/* type is double complex */

	const double complex cy[]={ 9, 9 };/* reference cy after */
	double complex y[]={ 3, 6 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+1*I, 1+0*I };/* type is double complex */

	const double complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double complex y[]={ 3+3*I, 0+0*I, 3+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+3i\n 3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+0i 0+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+3*I, 1+0*I };/* type is double complex */

	const double complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double complex y[]={ 3+0*I, 0+0*I, 3+9*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1+0i 0+3i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+0i\n 3+9i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double complex alpha=3;
	/*
 A = 
 1+0i 0+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double complex y[]={ 3+0*I, 0+0*I, 3+-6*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1+0i 0+2i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+0i\n 3+-6i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };/* type is double complex */

	const double complex cy[]={ 1, 1 };/* reference cy after */
	double complex y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };/* type is double complex */

	const double complex cy[]={ 1, 1 };/* reference cy after */
	double complex y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double complex alpha=1;
	/*
 A = 
 1+0i 1+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 1+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 1, 1 };/* reference cy after */
	double complex y[]={ 1+0*I, 2+-2*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1+0i 1+2i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n 1+0i\n 2+-2i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double complex y[]={ 3, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 2\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 3\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double complex y[]={ 1, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double complex alpha=1;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 3, 1 };/* type is double complex */

	const double complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double complex y[]={ 1, 0, 4, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 4\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 1, 1 };/* type is double complex */

	const double complex cy[]={ 1, 1 };/* reference cy after */
	double complex y[]={ -2, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -2\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+1*I, 1+0*I };/* type is double complex */

	const double complex cy[]={ 1, 1 };/* reference cy after */
	double complex y[]={ -1+0*I, -1+-1*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+0i\n -1+-1i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };/* type is double complex */

	const double complex cy[]={ 1, 1 };/* reference cy after */
	double complex y[]={ -1, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+1*I, 1+0*I };/* type is double complex */

	const double complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double complex y[]={ -1+-1*I, 0+0*I, -1+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+-1i\n -1+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+0i 1+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 1+1*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double complex y[]={ -1+0*I, 0+0*I, -2+-1*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1+0i 1+1i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+0i\n -2+-1i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-1;
	/*
 A = 
 1+0i 0+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+3*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double complex y[]={ -1+0*I, 0+0*I, -1+3*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1+0i 0+3i\n 0+0i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+0i\n -1+3i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1+0i 2+5i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 2+5*I, 1+0*I };/* type is double complex */

	const double complex cy[]={ 9, 9 };/* reference cy after */
	double complex y[]={ -9+-15*I, -3+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1+0i 2+5i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n -9+-15i\n -3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1+0i 1+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 1+3*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 9, 9 };/* reference cy after */
	double complex y[]={ -3+0*I, -6+-9*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1+0i 1+3i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n -3+0i\n -6+-9i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double complex alpha=-3;
	/*
 A = 
 1 3
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 3, 1 };/* type is double complex */

	const double complex cy[]={ 9, 9 };/* reference cy after */
	double complex y[]={ -3, -12 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 3\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -12\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double complex */

	const double complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double complex y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1+0i 0+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+1*I, 1+0*I };/* type is double complex */

	const double complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double complex y[]={ -3+0*I, 0+0*I, -3+-3*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1+0i 0+1i\n 0+0i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n -3+0i\n -3+-3i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_ussv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double complex alpha=-3;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 1, 1 };/* type is double complex */

	const double complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double complex y[]={ -3, 0, -6, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 1\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_upper_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=3;
	/*
 A = 
 1+0i 0+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 6+6*I, 6+0*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1+0i 0+2i\n 0+0i 1+0i\n"	" y' = \n 6+6i\n 6+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=3;
	/*
 A = 
 1+0i 0+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+3*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 6+0*I, 6+9*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+0i 0+3i\n 0+0i 1+0i\n"	" y' = \n 6+0i\n 6+9i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 6, 6 };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 6\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 2, 1 };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 6, 4 };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 2\n 0 1\n"	" y' = \n 6\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=1;
	/*
 A = 
 1+0i 3+3i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 3+3*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 4+0*I, 7+3*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1+0i 3+3i\n 0+0i 1+0i\n"	" y' = \n 4+0i\n 7+3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=1;
	/*
 A = 
 1+0i 0+8i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+8*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 4+0*I, 4+-8*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1+0i 0+8i\n 0+0i 1+0i\n"	" y' = \n 4+0i\n 4+-8i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=-1;
	/*
 A = 
 1 2
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0, 2 };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 2\n 0 1\n"	" y' = \n 0\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=-1;
	/*
 A = 
 1+0i 0+4i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 0+4*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 2+0*I, 2+-4*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+0i 0+4i\n 0+0i 1+0i\n"	" y' = \n 2+0i\n 2+-4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=-1;
	/*
 A = 
 1 1
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1, 1, 1 };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 2, 1 };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 1\n 0 1\n"	" y' = \n 2\n 1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:n kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=-3;
	/*
 A = 
 1+0i 5+2i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 5+2*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ -15+-6*I, 0+0*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+0i 5+2i\n 0+0i 1+0i\n"	" y' = \n -15+-6i\n 0+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:t kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0, 0 };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_su_de_usmm_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:z; trans:c kind:u; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double complex alpha=-3;
	/*
 A = 
 1+0i 3+1i
 0+0i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1, 1 };
	const double complex VA[]={ 1+0*I, 3+1*I, 1+0*I };		/* x: 2 */
	const double complex x[]={ 1, 1 };/* reference x */
	const double complex cy[]={ 0+0*I, -9+3*I };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+0i 3+1i\n 0+0i 1+0i\n"	" y' = \n 0+0i\n -9+3i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=u diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ 3, 6 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ 6, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 9\n 9\n"	" y' = \n 6\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ 6, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 9\n 9\n"	" y' = \n 6\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 0
 5 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 5, 1 };/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ 3, 0, 18, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 0\n 5 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 18\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ 9, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 9\n 9\n"	" y' = \n 9\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ 6, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 9\n 9\n"	" y' = \n 6\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 0
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ 4, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 3 1\n"	" y = \n 1\n 1\n"	" y' = \n 4\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ 2, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 1\n 1\n"	" y' = \n 2\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ 1, 0, 2, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 2\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ 2, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 1\n 1\n"	" y' = \n 2\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 2, 1 };/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ 3, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 1\n 1\n"	" y' = \n 3\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ -1, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ -1, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=-1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 1 };/* reference cy after */
	float y[]={ -2, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 1\n 1\n"	" y' = \n -2\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ -1, 0, -4, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 0\n 3 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -4\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 2, 1 };/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ -3, 0, -1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 1\n 1\n"	" y' = \n -3\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float y[]={ -1, 0, -1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 0
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 3, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ -3, -12 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 3 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -12\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 9, 9 };/* reference cy after */
	float y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float */

	const float cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_sussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 9 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 9, 6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 9\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 6 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 6\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 4, 5 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 4\n 5\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 2, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 6, 4 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 0\n 2 1\n"	" y' = \n 6\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 4, 4 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 4\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 2, 1 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 2\n 1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 1, 2 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 1\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 1, 2 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 1\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-3;
	/*
 A = 
 1 0
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float VA[]={ 1, 3, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, -9 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 0\n 3 1\n"	" y' = \n 0\n -9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t ts_sl_de_usmm_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:s; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float VA[]={ 1, 1 };		/* x: 2 */
	const float x[]={ 1, 1 };/* reference x */
	const float cy[]={ 0, 0 };/* reference cy after */
	float y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 0\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('s')){printf("type=s unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_suscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_suscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'S',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'S',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=s dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'S'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ 6, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 9\n 9\n"	" y' = \n 6\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ 6, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 9\n 9\n"	" y' = \n 6\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ 3, 0, 9, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 9\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=3;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ 9, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 9\n 9\n"	" y' = \n 9\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ 1, 2 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 2\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=1;
	/*
 A = 
 1 0
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 3, 1 };/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ 4, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 0\n 3 1\n"	" y = \n 1\n 1\n"	" y' = \n 4\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ 1, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ 2, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 1\n 1\n"	" y' = \n 2\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ 1, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ -1, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ -3, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 1\n 1\n"	" y' = \n -3\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=-1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 1, 1 };/* reference cy after */
	double y[]={ -3, -1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 1\n 1\n"	" y' = \n -3\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ -1, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ -1, 0, -1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 1, 0, 1, 0 };/* reference cy after */
	double y[]={ -1, 0, -1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n -1\n -1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ -3, -9 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -9\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 9 };/* reference cy after */
	double y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };/* type is double */

	const double cy[]={ 9, 0, 9, 0 };/* reference cy after */
	double y[]={ -9, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 9\n 9\n"	" y' = \n -9\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dussv(transT,alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 6, 9 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 6, 6 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 6\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 6, 6 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 6\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 4, 5 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 4\n 5\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=1;
	/*
 A = 
 1 0
 4 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 4, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 8, 4 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 0\n 4 1\n"	" y' = \n 8\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 4, 4 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 4\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 2, 1 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 2\n 1\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 0, 2 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1 0\n 2 1\n"	" y' = \n 0\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 2, 2 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 2\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 2, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ 0, -6 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1 0\n 2 1\n"	" y' = \n 0\n -6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -3, 0 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t td_sl_de_usmm_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:d; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const double alpha=-3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double VA[]={ 1, 1, 1 };		/* x: 2 */
	const double x[]={ 1, 1 };/* reference x */
	const double cy[]={ -3, 0 };/* reference cy after */
	double y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n -3\n 0\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('d')){printf("type=d unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_duscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_duscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'D',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'D',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=d dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'D'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+0i
 0+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ 3+0*I, 3+6*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1+0i 0+0i\n 0+2i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+0i\n 3+6i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+0i
 0+1i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+1*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ 3+3*I, 3+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1+0i 0+0i\n 0+1i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+3i\n 3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+0i
 0+3i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+3*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ 3+-9*I, 3+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1+0i 0+0i\n 0+3i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+-9i\n 3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+0i
 0+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+2*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ 3+6*I, 0+0*I, 3+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1+0i 0+0i\n 0+2i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n 3+6i\n 3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ 3, 0, 3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1 0
 2 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1, 2, 1 };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ 1, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1 0\n 2 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1 0
 4 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1, 4, 1 };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ 5, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 4 1\n"	" y = \n 1\n 1\n"	" y' = \n 5\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ 1, 1 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1+0i 0+0i
 0+1i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+1*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ 1+0*I, 0+0*I, 1+1*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-1 * y \n"" A = \n 1+0i 0+0i\n 0+1i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n 1+0i\n 1+1i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ 1, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ 1, 0, 1, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 1 A^-H * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 1\n 1\n"	" y' = \n 1\n 1\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+0i
 0+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+2*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ -1+0*I, -1+-2*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1+0i 0+0i\n 0+2i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+0i\n -1+-2i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+0i
 0+4i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+4*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ -1+-4*I, -1+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1+0i 0+0i\n 0+4i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+-4i\n -1+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+0i
 0+1i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+1*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 1 };/* reference cy after */
	float complex y[]={ -1+1*I, -1+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1+0i 0+0i\n 0+1i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+1i\n -1+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+0i
 3+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 3+2*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ -1+0*I, 0+0*I, -4+-2*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-1 * y \n"" A = \n 1+0i 0+0i\n 3+2i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+0i\n -4+-2i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+0i
 2+4i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 2+4*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ -3+-4*I, 0+0*I, -1+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-T * y \n"" A = \n 1+0i 0+0i\n 2+4i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -3+-4i\n -1+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+0i
 0+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 1, 0, 1, 0 };/* reference cy after */
	float complex y[]={ -1+2*I, 0+0*I, -1+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -1 A^-H * y \n"" A = \n 1+0i 0+0i\n 0+2i 1+0i\n"	" y = \n 1\n 1\n"	" y' = \n -1+2i\n -1+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ -3, -3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int incx=1;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 0+0i
 1+1i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 1+1*I, 1+0*I };/* type is float complex */

	const float complex cy[]={ 9, 9 };/* reference cy after */
	float complex y[]={ -6+3*I, -3+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1+0i 0+0i\n 1+1i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n -6+3i\n -3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ -3, 0, -3, 0 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-1 * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n -3\n -3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 0+0i
 0+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ -3+-6*I, 0+0*I, -3+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-T * y \n"" A = \n 1+0i 0+0i\n 0+2i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n -3+-6i\n -3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(void)
{
	/* op:ussv; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=2;
	const int incx=2;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 0+0i
 2+1i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 2+1*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
/* type is float complex */

	const float complex cy[]={ 9, 0, 9, 0 };/* reference cy after */
	float complex y[]={ -9+3*I, 0+0*I, -3+0*I, 0+0*I };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- -3 A^-H * y \n"" A = \n 1+0i 0+0i\n 2+1i 1+0i\n"	" y = \n 9\n 9\n"	" y' = \n -9+3i\n -3+0i\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',2,2)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',2,2,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 6, 9 };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^1 * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 6\n 9\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=3;
	/*
 A = 
 1+0i 0+0i
 1+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 1+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 9+6*I, 6+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^T * x \n"" A = \n 1+0i 0+0i\n 1+2i 1+0i\n"	" y' = \n 9+6i\n 6+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_c_ap3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1, 1, 1 };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 9, 6 };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 3 A^H * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 9\n 6\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_n_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=1;
	/*
 A = 
 1+0i 0+0i
 2+4i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 2+4*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 4+0*I, 6+4*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^1 * x \n"" A = \n 1+0i 0+0i\n 2+4i 1+0i\n"	" y' = \n 4+0i\n 6+4i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_t_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=1;
	/*
 A = 
 1 0
 3 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1, 3, 1 };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 7, 4 };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^T * x \n"" A = \n 1 0\n 3 1\n"	" y' = \n 7\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_c_ap1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=1;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const float complex VA[]={ 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 4, 4 };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + 1 A^H * x \n"" A = \n 1 0\n 0 1\n"	" y' = \n 4\n 4\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_n_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+0i
 1+1i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 1+1*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 2+0*I, 1+-1*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^1 * x \n"" A = \n 1+0i 0+0i\n 1+1i 1+0i\n"	" y' = \n 2+0i\n 1+-1i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_t_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-1;
	/*
 A = 
 1+0i 0+0i
 3+1i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 3+1*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ -1+-1*I, 2+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^T * x \n"" A = \n 1+0i 0+0i\n 3+1i 1+0i\n"	" y' = \n -1+-1i\n 2+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_begin(nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_c_anr1_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-1;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1, 1, 1 };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 1, 2 };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -1 A^H * x \n"" A = \n 1 0\n 1 1\n"	" y' = \n 1\n 2\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_n_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 0+0i
 0+4i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 0+4*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ 0+0*I, 0+-12*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^1 * x \n"" A = \n 1+0i 0+0i\n 0+4i 1+0i\n"	" y' = \n 0+0i\n 0+-12i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_t_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 0+0i
 5+5i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 5+5*I, 1+0*I };		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ -15+-15*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^T * x \n"" A = \n 1+0i 0+0i\n 5+5i 1+0i\n"	" y' = \n -15+-15i\n 0+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tc_sl_de_usmm_2_c_anr3_bp1_ix1_iy1(void)
{
	/* op:usmm; type:c; trans:c kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_conj_trans ;
	const int incy=1;
	const int ldX=2;
	const int ldY=2;
	const float complex alpha=-3;
	/*
 A = 
 1+0i 0+0i
 2+2i 1+0i
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const float complex VA[]={ 1+0*I, 2+2*I, 1+0*I };	rsb_coo_idx_t K[]={ 1, 1 };// K
	rsb_coo_idx_t L[]={ 1, 1 };// L
		/* x: 2 */
	const float complex x[]={ 1, 1 };/* reference x */
	const float complex cy[]={ -6+6*I, 0+0*I };/* reference cy after */
	float complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- y + -3 A^H * x \n"" A = \n 1+0i 0+0i\n 2+2i 1+0i\n"	" y' = \n -6+6i\n 0+0i\n"	" y = \n 3\n 3\n"	" x = \n 1\n 1\n";	
	if(!RSB_BLAS_SUPPORTED_TYPE('c')){printf("type=c unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_cuscr_variable_block_begin(nr,nc,K,L);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_cuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_cusmm(blas_colmajor,transT,1,&alpha,A,x,ldX,y,ldY) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'C',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'C',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=c dims=2x2 sym=l diag=e blocks=1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'C'); }
err:	return errval;
}

	static rsb_err_t tz_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:n kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_no_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1 0
 1 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=3;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1, 1 };
	const rsb_coo_idx_t JA[]={ 0, 0, 1 };
	const double complex VA[]={ 1, 1, 1 };/* type is double complex */

	const double complex cy[]={ 9, 9 };/* reference cy after */
	double complex y[]={ 3, 6 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-1 * y \n"" A = \n 1 0\n 1 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 6\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS_ussp(A,blas_lower_triangular) != RSB_BLAS_NO_ERROR )  {RSB_ERROR("ussp() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA) != RSB_BLAS_NO_ERROR){RSB_ERROR("uscr_insert_entries() gave %d!\n",A);goto ferr;}
	if( BLAS_zuscr_end(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("uscr_end() gave %d!\n",A);goto ferr;}
	if( BLAS_zussv(transT,&alpha,A,y,incx) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	if( (errval = rsb__do_are_same(y,cy,nr,'Z',1,1)) != RSB_ERR_NO_ERROR ){  rsb__debug_print_vectors_diff(y,cy,nr,'Z',1,1,RSB_VECTORS_DIFF_DISPLAY_N);  goto ferr; }
		else printf("type=z dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is ok\n");

	if( BLAS_usds(A) != RSB_BLAS_NO_ERROR ){RSB_ERROR("!\n");goto ferr;}
	errval = RSB_ERR_NO_ERROR;
ferr:	if(errval != RSB_ERR_NO_ERROR){  RSB_ERROR("type=z dims=2x2 sym=l diag=e blocks=1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n is not ok\n");  RSB_ERRLN(lsc);  RSB_ERROR("Computed solution: y'=\n"); 	rsb_sbtc_print_vec(y,nr*incy,'Z'); }
err:	return errval;
}

	static rsb_err_t tz_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(void)
{
	/* op:ussv; type:z; trans:t kind:l; diag:e */
	rsb_err_t errval = RSB_BLAS_ERROR;
	blas_sparse_matrix A = -1;
	const enum blas_trans_type transT=blas_trans;
	const int incy=1;
	const int incx=1;
	const double complex alpha=3;
	/*
 A = 
 1 0
 0 1
*/
	/* declaration of VA,IA,JA */
 	const int nnz=2;
	const rsb_coo_idx_t nr=2;
	const rsb_coo_idx_t nc=2;
	const rsb_coo_idx_t IA[]={ 0, 1 };
	const rsb_coo_idx_t JA[]={ 0, 1 };
	const double complex VA[]={ 1, 1 };/* type is double complex */

	const double complex cy[]={ 9, 9 };/* reference cy after */
	double complex y[]={ 3, 3 };/* y */

	
	const char*lsc="System and hardcoded solution: y' <- 3 A^-T * y \n"" A = \n 1 0\n 0 1\n"	" y = \n 9\n 9\n"	" y' = \n 3\n 3\n";
	
	if(!RSB_BLAS_SUPPORTED_TYPE('z')){printf("type=z unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	if((nnz == 0 ) && !RSB_BLAS_SUPPORT_EMPTY ){ printf("empty matrices are unsupported: skipping test.\n");errval=RSB_ERR_UNSUPPORTED_TYPE;goto err;}
	A = BLAS_zuscr_block_begin(1,1,nr,nc);
	if( A == -1 ){RSB_ERROR("uscr_begin() gave %d!\n",A);goto ferr;}
	if( BLAS