/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - ReservedPLKeywords
 * - ReservedPLKeywords_kw_string
 * - ReservedPLKeywords_kw_offsets
 * - ReservedPLKeywords_hash_func
 *--------------------------------------------------------------------
 */

/*-------------------------------------------------------------------------
 *
 * pl_reserved_kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2020, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef PL_RESERVED_KWLIST_D_H
#define PL_RESERVED_KWLIST_D_H

#include "common/kwlookup.h"

static const char ReservedPLKeywords_kw_string[] =
	"all\0"
	"begin\0"
	"by\0"
	"case\0"
	"declare\0"
	"else\0"
	"end\0"
	"execute\0"
	"for\0"
	"foreach\0"
	"from\0"
	"if\0"
	"in\0"
	"into\0"
	"loop\0"
	"not\0"
	"null\0"
	"or\0"
	"strict\0"
	"then\0"
	"to\0"
	"using\0"
	"when\0"
	"while";

static const uint16 ReservedPLKeywords_kw_offsets[] = {
	0,
	4,
	10,
	13,
	18,
	26,
	31,
	35,
	43,
	47,
	55,
	60,
	63,
	66,
	71,
	76,
	80,
	85,
	88,
	95,
	100,
	103,
	109,
	114,
};

#define RESERVEDPLKEYWORDS_NUM_KEYWORDS 24

static int
ReservedPLKeywords_hash_func(const void *key, size_t keylen)
{
	static const int8 h[49] = {
		    -2,    127,      7,    127,      0,    127,    127,    127,
		    18,      5,    127,     27,    127,      0,    127,    127,
		     0,     39,     32,     22,     10,    127,     19,    -26,
		   127,    -11,      0,     12,    127,    127,     -1,     28,
		    20,      0,     23,    127,      0,     14,     -8,    127,
		   127,    127,     13,      5,    127,    -23,      1,      0,
		   127,
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 1;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 31 + c;
		b = b * 127 + c;
	}
	return h[a % 49] + h[b % 49];
}

static const ScanKeywordList ReservedPLKeywords = {
	ReservedPLKeywords_kw_string,
	ReservedPLKeywords_kw_offsets,
	ReservedPLKeywords_hash_func,
	RESERVEDPLKEYWORDS_NUM_KEYWORDS,
	7
};

#endif							/* PL_RESERVED_KWLIST_D_H */
