/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#include "Instance.h"

Instance::Instance(){}

Instance::~Instance(){}

Instance::Instance(const CMPIBroker* _broker, CMPIInstance* inst) {
	hdl = inst;
	broker = (CMPIBroker*) _broker;
}

Instance::Instance(const CMPIBroker* _broker, Objectpath& op) {
	hdl = CMNewInstance(_broker, op.getHdl(), NULL);
	// Added by Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr> (2007/05/20)
	// Copy the objectpath keys as instance properties
	unsigned int keyCount = CMGetKeyCount(op.getHdl(), NULL);
	for (unsigned int i=0; i<keyCount; i++) {
		CMPIString* keyName;
		CMPIData keyData=CMGetKeyAt(op.getHdl(), i, &keyName, NULL);
		CMSetProperty(hdl, CMGetCharPtr(keyName), &(keyData.value), keyData.type);
	}
	// End of Added
	broker = (CMPIBroker*) _broker;
}

CMPIInstance* Instance::getHdl() {
	return hdl;
}

Objectpath Instance::getObjectpath() {
	return Objectpath(broker, hdl->ft->getObjectPath(hdl, NULL));
}

string Instance::getClassname() const {
	CMPIObjectPath* op = hdl->ft->getObjectPath(hdl, NULL);
	return CMGetCharPtr(op->ft->getClassName(op, NULL));
}

string Instance::getNamespace() const {
	CMPIObjectPath* op = hdl->ft->getObjectPath(hdl, NULL);
	return CMGetCharPtr(op->ft->getNameSpace(op, NULL));	
}

int Instance::getPropertyCount() const {
	return CMGetPropertyCount(hdl, NULL);
}

string Instance::toString() const {
	return CMGetCharPtr(broker->eft->toString(broker, hdl, NULL));
}

//uint8
void Instance::setProperty(const string& name, const unsigned char& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_uint8);
}
int Instance::getProperty(const string& name, unsigned char& value) const {
	_GET_PROPERTY
}

//uint16
void Instance::setProperty(const string& name, const unsigned short& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_uint16);
}
int Instance::getProperty(const string& name, unsigned short& value) const {
	_GET_PROPERTY
}

//uint32
void Instance::setProperty(const string& name, const unsigned int& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_uint32);
}
int Instance::getProperty(const string& name, unsigned int& value) const {
	_GET_PROPERTY
}

//uint32 deprecated
void Instance::setProperty(const string& name, const unsigned long& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_uint32);
}
int Instance::getProperty(const string& name, unsigned long& value) const {
	_GET_PROPERTY
}

//uint64
void Instance::setProperty(const string& name, const unsigned long long& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_uint64);
}
int Instance::getProperty(const string& name, unsigned long long& value) const {
	_GET_PROPERTY
}

//sint8
void Instance::setProperty(const string& name, const signed char& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_sint8);
}
int Instance::getProperty(const string& name, signed char& value) const {
	_GET_PROPERTY
}

//sint16
void Instance::setProperty(const string& name, const short& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_sint16);
}
int Instance::getProperty(const string& name, short& value) const {
	_GET_PROPERTY
}

//sint32
void Instance::setProperty(const string& name, const int& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_sint32);
}
int Instance::getProperty(const string& name, int& value) const {
	_GET_PROPERTY
}

//sint32 deprecated
void Instance::setProperty(const string& name, const long& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_sint32);
}
int Instance::getProperty(const string& name, long& value) const {
	_GET_PROPERTY
}

//sint64
void Instance::setProperty(const string& name, const long long& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_sint64);
}
int Instance::getProperty(const string& name, long long& value) const {
	_GET_PROPERTY
}

//real32
void Instance::setProperty(const string& name, const float& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_real32);
}
int Instance::getProperty(const string& name, float& value) const {
	_GET_PROPERTY
}

//real64
void Instance::setProperty(const string& name, const double& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_real64);
}
int Instance::getProperty(const string& name, double& value) const {
	_GET_PROPERTY
}

//char16
void Instance::setPropertyChar16(const string& name, const unsigned short& value) {
	CMPIValue myValue = CT_toCMPIChar16(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_char16);
}
int Instance::getPropertyChar16(const string& name, unsigned short& value) const {
	CMPIStatus rc;
	CMPIData data = CMGetProperty(hdl, name.c_str(), &rc);
	if (rc.rc != CMPI_RC_OK) return FAILED;
	if ((data.state & CMPI_nullValue) == CMPI_nullValue || (data.state & CMPI_badValue) == CMPI_badValue || (data.state & CMPI_notFound) == CMPI_notFound)
		return FAILED;
	return CT_ToCChar16(data, value);
}

//boolean
void Instance::setProperty(const string& name, const bool& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_boolean);
}
int Instance::getProperty(const string& name, bool& value) const {
	_GET_PROPERTY
}

//string
void Instance::setProperty(const string& name, const string& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_string);
}
int Instance::getProperty(const string& name, string& value) const {
	_GET_PROPERTY
}

//datetime
void Instance::setPropertyDatetime(const string& name, const string& value) {
	CMPIValue myValue = CT_toCMPIDatetime(broker, value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_dateTime);
}
int Instance::getPropertyDatetime(const string& name, string& value) const {
	CMPIStatus rc;
	CMPIData data = CMGetProperty(hdl, name.c_str(), &rc);
	if (rc.rc != CMPI_RC_OK) return FAILED;
	if ((data.state & CMPI_nullValue) == CMPI_nullValue || (data.state & CMPI_badValue) == CMPI_badValue || (data.state & CMPI_notFound) == CMPI_notFound)
		return FAILED;
	return CT_ToCDatetime(data, value);
}

//REF
void Instance::setProperty(const string& name, const Objectpath& value) {
	CMPIValue myValue = CT_toCMPI(value);
	hdl->ft->setProperty(hdl, name.c_str(), &myValue, CMPI_ref);
}
int Instance::getProperty(const string& name, Objectpath& value) const {
	CMPIStatus rc;
	CMPIData data = CMGetProperty(hdl, name.c_str(), &rc);
	if (rc.rc != CMPI_RC_OK) return FAILED;
	if ((data.state & CMPI_nullValue) == CMPI_nullValue || (data.state & CMPI_badValue) == CMPI_badValue || (data.state & CMPI_notFound) == CMPI_notFound)
		return FAILED;
	return CT_ToC(broker, data, value);
}

//uint8[]
void Instance::setProperty(const string& name, const vector<unsigned char>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_uint8A);
}
int Instance::getProperty(const string& name, vector<unsigned char>& value) const {
	_GET_PROPERTY
}

//uint16[]
void Instance::setProperty(const string& name, const vector<unsigned short>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_uint16A);
}
int Instance::getProperty(const string& name, vector<unsigned short>& value) const {
	_GET_PROPERTY
}

//uint32[]
void Instance::setProperty(const string& name, const vector<unsigned int>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_uint32A);
}
int Instance::getProperty(const string& name, vector<unsigned int>& value) const {
	_GET_PROPERTY
}

//uint32[] deprecated
void Instance::setProperty(const string& name, const vector<unsigned long>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_uint32A);
}
int Instance::getProperty(const string& name, vector<unsigned long>& value) const {
	_GET_PROPERTY
}

//uint64[]
void Instance::setProperty(const string& name, const vector<unsigned long long>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_uint64A);
}
int Instance::getProperty(const string& name, vector<unsigned long long>& value) const {
	_GET_PROPERTY
}

//sint8[]
void Instance::setProperty(const string& name, const vector<signed char>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_sint8A);
}
int Instance::getProperty(const string& name, vector<signed char>& value) const {
	_GET_PROPERTY
}

//sint16[]
void Instance::setProperty(const string& name, const vector<short>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_sint16A);
}
int Instance::getProperty(const string& name, vector<short>& value) const {
	_GET_PROPERTY
}

//sint32[]
void Instance::setProperty(const string& name, const vector<int>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_sint32A);
}
int Instance::getProperty(const string& name, vector<int>& value) const {
	_GET_PROPERTY
}

//sint32[] deprecated
void Instance::setProperty(const string& name, const vector<long>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_sint32A);
}
int Instance::getProperty(const string& name, vector<long>& value) const {
	_GET_PROPERTY
}

//sint64[]
void Instance::setProperty(const string& name, const vector<long long>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_sint64A);
}
int Instance::getProperty(const string& name, vector<long long>& value) const {
	_GET_PROPERTY
}

//real32[]
void Instance::setProperty(const string& name, const vector<float>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_real32A);
}
int Instance::getProperty(const string& name, vector<float>& value) const {
	_GET_PROPERTY
}

//real64[]
void Instance::setProperty(const string& name, const vector<double>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_real64A);
}
int Instance::getProperty(const string& name, vector<double>& value) const {
	_GET_PROPERTY
}

//char16[]
void Instance::setPropertyChar16(const string& name, const vector<unsigned short>& value) {
	CMPIValue myValue = CT_toCMPIChar16(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_char16A);
}
int Instance::getPropertyChar16(const string& name, vector<unsigned short>& value) const {
	CMPIStatus rc;
	CMPIData data = CMGetProperty(hdl, name.c_str(), &rc);
	if (rc.rc != CMPI_RC_OK) return rc.rc;
	if ((data.state & CMPI_nullValue) == CMPI_nullValue || (data.state & CMPI_badValue) == CMPI_badValue || (data.state & CMPI_notFound) == CMPI_notFound)
		return FAILED;
	return CT_ToCChar16(data, value);
}

//boolean[]
void Instance::setProperty(const string& name, const vector<bool>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_booleanA);
}
int Instance::getProperty(const string& name, vector<bool>& value) const {
	_GET_PROPERTY
}
	
//string[]
void Instance::setProperty(const string& name, const vector<string>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_charsA);
}
int Instance::getProperty(const string& name, vector<string>& value) const {
	_GET_PROPERTY
}
	
//datetime[]
void Instance::setPropertyDatetime(const string& name, const vector<string>& value) {
	CMPIValue myValue = CT_toCMPIDatetime(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_dateTimeA);
}
int Instance::getPropertyDatetime(const string& name, vector<string>& value) const {
	CMPIStatus rc;
	CMPIData data = CMGetProperty(hdl, name.c_str(), &rc);
	if (rc.rc != CMPI_RC_OK) return rc.rc;
	if ((data.state & CMPI_nullValue) == CMPI_nullValue || (data.state & CMPI_badValue) == CMPI_badValue || (data.state & CMPI_notFound) == CMPI_notFound)
		return FAILED;
	return CT_ToCDatetime(data, value);
}
	
//REF[]
void Instance::setProperty(const string& name, const vector<Objectpath>& value) {
	CMPIValue myValue = CT_toCMPI(broker, value);
	CMSetProperty(hdl, name.c_str(), &myValue, CMPI_refA);
}
int Instance::getProperty(const string& name, vector<Objectpath>& value) const {
	CMPIStatus rc;
	CMPIData data = CMGetProperty(hdl, name.c_str(), &rc);
	if (rc.rc != CMPI_RC_OK) return rc.rc;
	if ((data.state & CMPI_nullValue) == CMPI_nullValue || (data.state & CMPI_badValue) == CMPI_badValue || (data.state & CMPI_notFound) == CMPI_notFound)
		return FAILED;
	return CT_ToC(broker, data, value);
}
