/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#ifndef OBJECTPATH_H_
#define OBJECTPATH_H_

#include <string>

#include "cmpidt.h"
#include "cmpimacs.h"

using namespace std;

#define _GET_KEY CMPIStatus rc;\
	CMPIData data = CMGetKey(hdl, name.c_str(), &rc);\
	if (rc.rc != CMPI_RC_OK) return FAILED;\
	if ((data.state & CMPI_nullValue) == CMPI_nullValue || (data.state & CMPI_badValue) == CMPI_badValue || (data.state & CMPI_notFound) == CMPI_notFound)\
		return FAILED;\
	return CT_ToC(data, value);

// C++ class to represent a CIM objectpath
class Objectpath {
private:
	CMPIObjectPath* hdl;
	CMPIBroker* broker;

public:
	Objectpath();
	Objectpath(const CMPIBroker* _broker, const string& classname, const string& nameSpace);
	Objectpath(const CMPIBroker* _broker, CMPIObjectPath* ob);
	~Objectpath();
	CMPIObjectPath* getHdl() const;
	Objectpath getObjectpath() const;
	string getNamespace() const;
	void setNamespace(const string& value);
	string getClassname() const;
	string getHostname() const;
	bool equals(const Objectpath& anotherObjectpath) const;
	string toString() const;
	unsigned int getKeyCount() const;

	int getKeyAt(unsigned int index, CMPIData& data, string& name) const;
	int getKey(const string& name, CMPIData& data) const;

	//uint8
	void addKey(const string& name, const unsigned char& value);
	int getKey(const string& name, unsigned char& value) const;
	
	//uint16
	void addKey(const string& name, const unsigned short int& value);
	int getKey(const string& name, unsigned short int& value) const;

	//uint32
	void addKey(const string& name, const unsigned int& value);
	int getKey(const string& name, unsigned int& value) const;

	//uint32 deprecated
	void addKey(const string& name, const unsigned long& value);
	int getKey(const string& name, unsigned long& value) const;

	//uint64
	void addKey(const string& name, const unsigned long long& value);
	int getKey(const string& name, unsigned long long& value) const;

	//sint8
	void addKey(const string& name, const signed char& value);
	int getKey(const string& name, signed char& value) const;
	
	//sint16
	void addKey(const string& name, const short int& value);
	int getKey(const string& name, short int& value) const;

	//sint32
	void addKey(const string& name, const int& value);
	int getKey(const string& name, int& value) const;

	//sint32 deprecated
	void addKey(const string& name, const long& value);
	int getKey(const string& name, long& value) const;

	//sint64
	void addKey(const string& name, const long long& value);
	int getKey(const string& name, long long& value) const;

	//real32
	void addKey(const string& name, const float& value);
	int getKey(const string& name, float& value) const;

	//real64
	void addKey(const string& name, const double& value);
	int getKey(const string& name, double& value) const;
	
	//char16
	void addKeyChar16(const string& name, const unsigned short int& value);
	int getKeyChar16(const string& name, unsigned short int& value) const;

	//boolean
	void addKey(const string& name, const bool& value);
	int getKey(const string& name, bool& value) const;

	//string
	void addKey(const string& name, const string& value);
	int getKey(const string& name, string& value) const;

	//datetime
	void addKeyDatetime(const string& name, const string& value);
	int getKeyDatetime(const string& name, string& value) const;
	
	//REF
	void addKey(const string& name, const Objectpath& value);
	int getKey(const string& name, Objectpath& value) const;

};

#include "Common.h"
#include "Transtype.h"

#endif /*OBJECTPATH_H_*/
