/* ----- encode/761x1531, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_761x1531_checksums[] = {
  "55bac32e896eeda274c06a45e55b1df05006e43780b35a6a3e1c0b3e52407838",
  "9a3fb7d7bd06856c18640990282f267f81500881d97c9fcb94d3a358cb24b9a7",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_761x1531_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_761x1531_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_761x1531_ITEMBYTES

static void *storage_encode_761x1531_s;
static unsigned char *test_encode_761x1531_s;
static void *storage_encode_761x1531_x;
static unsigned char *test_encode_761x1531_x;
static void *storage_encode_761x1531_s2;
static unsigned char *test_encode_761x1531_s2;
static void *storage_encode_761x1531_x2;
static unsigned char *test_encode_761x1531_x2;

#define precomputed_encode_761x1531_NUM 4

static const unsigned char precomputed_encode_761x1531_s[precomputed_encode_761x1531_NUM][crypto_encode_STRBYTES] = {
  {157,21,141,197,21,64,227,213,228,147,254,229,237,86,41,161,248,102,130,26,122,219,206,27,65,244,65,228,107,226,104,76,203,10,39,116,106,4,79,141,161,170,126,23,88,123,186,166,141,223,199,167,171,54,120,8,229,127,197,113,111,47,161,6,174,173,86,17,98,21,114,79,66,202,2,236,136,253,120,125,88,109,137,108,59,11,50,70,141,99,70,164,140,135,116,56,188,37,254,240,52,103,67,35,241,100,4,59,133,189,154,162,17,10,248,27,240,30,226,41,157,112,63,236,219,154,61,7,51,104,135,17,9,104,231,38,171,6,115,173,194,177,165,206,212,82,168,238,195,143,179,36,253,72,127,18,13,94,89,168,176,208,253,44,33,162,20,7,83,102,40,196,25,74,142,96,55,167,136,169,142,188,149,199,156,155,135,69,145,67,240,210,79,4,177,16,56,101,12,56,10,150,29,216,128,211,156,233,40,202,64,242,29,176,90,46,121,106,234,5,41,40,86,119,5,157,97,81,214,189,203,86,116,16,123,173,245,48,248,89,217,116,45,248,163,168,49,50,206,11,69,88,118,184,215,85,42,145,223,42,129,170,136,11,13,221,101,86,33,193,147,98,102,205,82,116,117,140,152,55,98,244,172,208,149,90,179,24,229,89,92,22,21,69,180,93,0,173,129,52,49,43,149,47,241,129,131,209,76,28,42,180,221,198,9,3,192,233,182,99,180,230,102,170,60,61,98,87,30,224,193,165,143,240,118,48,238,200,211,28,225,79,96,213,101,172,208,27,171,106,159,204,149,29,180,157,50,80,93,51,121,249,250,204,156,236,75,33,49,207,48,52,227,103,102,172,134,210,80,115,158,17,221,177,239,234,130,235,221,174,135,153,217,126,124,4,213,55,59,205,224,49,167,52,1,151,9,48,156,159,116,133,4,152,211,94,60,105,186,215,113,185,38,125,166,28,161,213,173,27,81,189,212,95,96,40,158,196,18,241,185,0,226,244,91,59,33,174,54,133,155,223,229,117,66,224,107,198,250,138,134,85,69,245,12,121,49,76,47,113,53,90,55,0,247,198,69,246,255,189,31,225,60,20,171,101,206,168,170,233,220,169,76,222,54,251,109,168,244,25,154,181,62,56,223,238,101,98,176,57,29,5,70,27,40,246,126,4,70,37,54,246,243,153,137,19,204,72,10,74,237,197,84,251,156,196,32,199,20,11,127,27,187,68,52,210,143,72,160,152,208,17,0,146,182,115,56,51,48,138,96,123,108,98,111,198,158,158,161,41,222,255,2,73,1,40,85,15,117,82,65,245,75,110,90,167,55,175,58,252,224,59,142,249,216,208,153,43,85,158,195,184,95,166,82,108,198,96,65,31,49,131,41,86,132,130,126,78,218,23,131,172,250,225,171,70,113,13,133,241,9,154,239,40,204,234,229,251,70,184,218,233,183,208,239,249,221,108,94,22,252,184,163,251,93,153,35,144,185,224,82,10,42,125,220,118,78,114,218,223,164,106,123,239,193,247,224,1,47,3,233,173,108,59,206,192,5,170,66,87,33,84,36,51,198,128,228,19,77,27,135,226,121,175,39,101,229,103,81,244,40,57,112,214,2,247,31,14,48,132,250,113,131,70,92,166,52,240,87,34,151,134,125,140,217,237,248,156,219,185,84,166,92,79,212,141,224,85,239,162,106,16,9,117,131,67,94,185,6,42,51,61,94,244,211,248,65,99,49,148,156,127,43,231,43,214,197,222,1,114,133,178,55,163,241,36,133,56,161,114,14,190,131,9,126,132,149,226,206,114,144,253,13,92,175,30,26,164,83,231,106,28,251,49,227,4,70,4,97,241,138,95,34,227,128,232,110,139,89,40,184,91,150,106,161,107,68,185,7,144,148,209,187,198,176,35,121,223,134,198,131,81,254,128,18,138,33,185,48,54,240,142,34,237,152,171,40,156,37,173,156,162,167,67,66,156,225,12,6,122,217,214,239,162,55,214,42,106,219,231,221,209,82,80,167,225,121,184,248,35,35,29,190,203,15,215,204,3,198,144,181,153,57,161,8,159,171,145,229,100,19,103,141,58,133,195,129,217,202,115,65,148,154,174,26,221,132,187,115,163,26,47,125,209,77,133,37,39,107,215,219,141,184,113,173,69,14,243,216,240,57,245,110,9,5,194,29,70,169,211,131,248,186,120,8,25,253,145,34,197,167,68,96,13,120,203,245,64,226,141,61,36,110,229,27,30,152,17,116,239,138,203,42,108,28,236,17},
  {1,73,16,96,163,45,234,205,116,143,26,93,46,77,165,144,35,118,94,151,163,9,123,139,224,235,119,126,47,177,211,170,127,244,62,63,48,14,213,186,208,27,253,118,47,57,90,141,226,35,22,217,156,235,227,245,190,93,31,233,49,235,153,90,57,28,220,36,131,252,131,94,40,234,182,55,76,126,140,106,124,205,247,219,218,79,64,161,214,38,192,130,130,93,122,95,88,247,100,19,17,239,141,171,86,139,113,203,126,242,207,48,38,1,224,225,129,242,80,236,40,92,69,102,161,219,230,73,88,132,246,8,185,8,49,170,105,62,84,109,238,133,205,154,193,198,183,241,125,156,159,10,157,45,74,136,141,31,16,173,252,5,186,11,156,177,91,72,175,164,12,150,240,198,105,97,44,217,0,83,201,223,79,99,188,0,29,125,64,200,37,208,85,1,102,83,220,163,224,12,104,95,148,102,141,224,71,232,142,232,217,131,10,214,63,191,208,159,237,161,151,77,52,229,119,136,26,230,230,155,106,197,162,29,43,135,191,77,141,61,51,215,198,208,178,77,47,215,61,38,184,82,239,229,213,206,92,166,233,50,246,147,239,238,63,164,225,165,236,206,79,151,84,82,138,23,9,84,76,113,76,173,12,81,244,142,15,74,48,179,238,155,222,205,101,53,219,39,200,39,224,177,109,94,181,15,197,17,83,145,12,236,185,224,228,179,110,194,95,126,45,77,167,84,164,46,233,75,96,190,5,131,128,154,193,21,235,155,112,243,5,0,49,120,114,237,239,7,60,238,245,142,18,252,51,46,118,126,62,119,187,126,167,60,14,63,191,117,202,162,223,254,16,114,211,244,231,31,105,221,240,229,91,116,60,53,66,182,13,39,189,147,76,69,152,5,4,172,56,183,31,13,81,68,154,154,204,195,52,29,52,83,178,155,93,126,16,7,137,41,236,117,183,253,81,244,234,132,76,183,212,82,65,178,209,187,34,222,178,34,158,129,250,227,14,141,164,240,160,209,68,225,96,104,131,120,80,21,124,68,77,119,67,24,226,85,84,13,207,36,93,186,107,63,44,92,166,104,202,105,53,109,187,41,165,147,131,168,122,100,248,224,152,243,231,26,104,209,225,73,116,54,7,142,188,82,1,106,180,248,241,146,180,106,156,84,5,128,200,143,158,45,44,78,72,164,176,92,226,79,62,48,145,94,21,141,163,247,110,186,77,172,233,44,236,158,254,137,115,250,102,65,19,238,96,209,110,17,245,28,49,226,182,97,167,16,109,10,108,180,128,41,90,7,114,142,1,17,243,165,252,112,227,117,56,50,122,124,12,18,107,237,59,12,144,175,41,154,233,60,48,193,218,4,10,168,132,91,55,198,110,25,252,244,78,127,112,99,44,71,170,15,163,141,139,182,65,117,23,77,67,128,159,33,91,51,36,85,107,255,230,165,253,145,50,57,38,174,23,46,191,47,76,230,90,130,152,203,138,131,164,225,140,238,149,228,221,217,36,84,95,144,184,223,227,124,80,121,156,83,204,144,60,147,216,210,255,120,133,242,199,128,234,108,107,171,62,101,118,200,218,44,229,151,179,185,78,17,170,170,116,202,68,79,219,173,85,66,76,60,207,95,68,41,32,234,149,114,66,186,225,21,225,160,59,11,99,156,178,84,216,78,234,207,78,184,231,227,238,19,77,235,63,156,208,73,85,13,213,44,111,218,184,168,115,25,150,119,150,79,28,154,6,192,13,83,78,171,167,117,188,52,180,190,232,192,91,232,15,44,78,237,86,62,96,125,210,204,0,160,146,70,152,158,155,154,58,35,105,100,227,40,144,230,37,141,115,44,51,138,230,163,99,96,168,48,191,241,78,147,228,151,17,96,79,84,172,198,83,217,171,85,16,13,61,232,203,52,8,205,66,249,209,90,21,130,77,137,223,40,76,135,139,71,13,211,162,97,195,73,77,250,42,107,81,187,189,225,1,242,153,113,96,159,198,171,189,17,159,21,193,119,91,112,148,247,41,87,144,145,250,191,115,221,77,196,46,233,206,161,140,42,198,157,47,65,116,63,88,196,199,231,71,25,33,32,58,156,14,13,150,26,74,152,81,227,98,151,235,8,63,30,42,114,37,10,69,25,53,145,131,119,69,223,167,209,175,124,68,147,160,100,144,164,95,42,63,187,108,141,51,108,205,29,255,211,167,177,21,183,188,147,241,143,77,251,8,150,133,5,192,218,188,195,29,171,213,56,207,9,246,239,194,210,203,181,33},
  {192,214,189,149,220,92,156,43,60,211,7,14,158,27,237,105,91,140,83,255,187,83,196,196,71,172,218,29,126,213,76,194,5,114,187,230,11,71,153,152,109,180,59,36,136,108,224,61,30,233,65,198,42,7,246,161,246,184,143,253,82,15,204,184,143,90,199,144,174,49,90,178,129,178,246,54,193,254,93,149,213,149,100,123,48,162,251,68,204,87,198,80,199,247,85,223,220,39,126,183,254,212,166,137,173,171,204,184,195,4,99,123,190,20,126,156,248,42,1,71,144,112,166,54,196,26,232,149,17,0,75,23,244,121,189,31,161,71,168,191,155,108,216,133,124,94,103,104,200,49,115,169,124,188,84,147,175,204,142,169,9,183,118,211,16,101,71,149,227,71,54,52,43,193,76,45,142,172,64,63,139,116,70,207,78,200,220,8,16,249,23,240,230,233,114,90,120,217,101,72,203,67,26,147,40,190,161,134,218,111,254,238,129,201,255,117,25,250,8,248,181,41,173,42,71,219,10,60,156,94,122,105,81,246,191,15,174,193,97,158,247,242,40,113,4,201,195,113,209,79,48,202,180,104,17,156,179,194,103,126,179,49,69,233,78,79,145,80,51,88,224,50,24,105,195,117,194,23,158,13,148,73,10,230,223,116,144,34,91,191,229,251,117,183,243,233,157,79,228,146,202,204,72,32,11,69,70,163,116,29,11,70,225,141,173,230,245,180,43,251,245,176,182,3,126,117,141,131,111,246,192,29,139,244,184,163,186,183,211,65,59,128,249,137,136,113,72,13,210,37,6,110,232,233,199,91,226,143,154,102,124,116,167,152,100,71,57,13,233,214,136,108,97,180,173,55,245,54,226,42,51,161,118,157,174,180,8,79,26,161,134,108,116,106,91,135,253,219,217,128,203,35,59,17,15,214,16,2,211,99,106,185,11,15,0,10,175,65,128,38,208,51,12,59,136,113,189,98,19,128,182,143,45,190,111,29,137,1,211,204,171,149,90,194,182,231,214,181,197,101,127,200,188,141,159,198,159,217,107,134,184,50,85,215,168,56,92,255,16,11,177,156,167,20,215,42,154,227,181,1,0,73,247,38,46,254,27,60,5,163,116,216,132,188,5,6,247,29,251,253,45,92,104,145,179,160,77,143,93,161,151,240,23,29,73,48,14,221,121,236,72,222,155,54,172,213,96,253,34,200,36,94,21,241,95,144,188,9,109,49,4,99,33,219,211,202,95,155,132,14,252,235,232,51,207,254,10,230,123,54,30,158,153,148,162,6,212,217,240,211,134,232,10,103,55,171,63,130,241,64,173,163,141,94,85,245,216,64,211,189,119,87,202,202,67,221,46,210,85,142,242,128,35,33,172,0,151,45,158,76,104,248,77,182,68,31,249,57,255,1,28,151,161,199,227,152,190,11,4,48,68,138,180,178,18,106,14,227,101,151,16,168,72,135,141,141,103,221,8,4,68,0,185,206,66,93,231,165,139,187,37,189,224,7,142,67,254,150,201,20,173,97,28,141,238,186,209,153,216,230,118,61,91,14,136,204,141,118,237,50,18,185,17,123,185,75,6,198,35,221,172,21,115,83,12,73,81,234,51,226,52,30,117,238,79,109,53,229,50,225,78,39,69,238,96,70,24,106,122,188,245,57,87,216,250,5,148,178,98,188,252,252,85,179,73,172,67,152,185,99,149,243,156,93,223,169,4,236,114,154,225,214,240,135,217,191,20,109,250,153,25,24,97,140,249,57,15,204,5,0,195,191,46,154,106,38,101,123,82,230,196,120,95,109,171,202,92,76,97,23,115,183,110,209,160,95,181,216,116,87,240,167,152,127,95,46,138,65,157,26,109,162,151,31,166,6,95,241,97,109,40,20,103,79,160,241,90,18,61,117,207,59,141,103,73,255,83,20,162,187,163,20,230,210,23,94,43,226,251,38,92,137,28,114,21,181,19,178,149,212,154,13,236,141,11,4,122,214,0,31,97,58,59,253,61,122,136,149,119,252,109,179,175,199,176,196,251,53,90,107,178,79,31,174,207,88,6,113,145,176,44,61,176,227,223,110,241,227,51,83,221,174,131,124,211,18,110,36,200,157,118,74,180,79,218,174,252,61,47,141,134,14,140,189,140,113,73,109,239,205,133,119,127,85,145,100,207,232,78,216,166,134,212,206,129,169,93,95,203,0,174,83,38,98,66,64,170,78,177,247,128,77,77,10,33,40,220,172,97,227,1,149,247,111,75,26,200,2,219,24,248,35,178,55,53,230,7},
  {6,109,105,251,7,119,49,199,106,51,153,191,207,120,110,102,134,82,44,2,105,158,48,212,167,11,25,195,46,101,6,166,226,184,127,55,147,135,43,149,97,207,75,203,48,203,221,252,198,35,182,100,136,148,54,255,30,186,222,172,239,76,221,4,62,64,163,135,155,90,110,170,223,156,213,240,224,79,214,204,116,86,77,33,25,235,199,4,148,119,132,191,93,18,137,241,35,113,60,111,232,157,73,88,121,215,94,24,72,234,102,63,239,115,72,109,127,179,135,8,226,139,110,17,11,16,225,81,244,120,8,134,19,12,131,205,68,250,20,19,226,200,108,196,181,66,226,43,31,48,146,107,5,185,137,188,2,90,204,32,201,26,198,208,44,173,78,180,184,220,157,42,169,202,165,34,2,104,8,216,133,171,78,17,15,226,3,135,127,144,186,33,253,183,195,116,15,239,9,87,173,156,160,24,214,168,243,74,96,64,17,169,79,21,152,2,62,20,8,216,79,223,14,112,22,15,50,135,75,202,70,74,94,200,227,228,57,131,113,86,141,114,245,0,248,51,6,149,23,25,95,227,141,37,20,84,102,41,13,121,203,20,212,7,54,110,184,210,83,254,221,40,64,156,248,45,55,88,239,11,93,151,246,196,49,71,8,128,149,110,24,156,169,147,44,151,144,43,190,67,45,67,32,169,251,217,152,124,138,64,224,47,6,239,240,76,77,17,218,96,129,10,69,136,196,14,57,249,192,148,166,61,206,62,170,81,225,59,78,94,245,20,172,90,44,61,97,67,117,253,85,30,79,219,143,77,27,100,115,36,65,114,62,97,110,155,187,93,175,175,232,169,119,147,135,193,215,23,49,5,190,53,200,206,170,161,94,62,130,91,110,139,116,43,10,220,95,135,103,38,207,82,0,251,127,154,86,158,148,57,202,189,107,250,123,148,99,172,152,231,250,194,115,244,148,82,24,152,150,199,118,66,200,230,182,108,200,81,28,27,194,211,15,173,105,231,39,82,208,185,86,172,45,213,238,82,115,55,72,79,108,247,87,86,179,77,102,59,138,55,192,159,171,52,50,99,23,30,61,110,20,215,186,67,241,82,62,123,71,67,22,153,125,207,216,228,57,70,130,213,168,100,96,156,30,81,27,72,90,59,226,145,215,242,230,196,20,159,200,44,109,218,88,244,248,77,47,24,60,160,33,153,126,104,91,136,151,242,121,123,57,90,207,22,149,99,166,136,218,27,73,137,170,130,212,106,153,148,120,148,124,152,74,97,156,135,198,203,168,247,161,107,206,201,209,251,199,199,147,47,76,90,56,235,194,244,214,210,61,177,103,160,3,43,29,116,88,151,119,216,208,93,73,255,219,221,222,164,64,231,13,122,57,20,132,111,143,121,130,221,217,185,134,195,67,96,30,198,103,88,89,90,162,46,55,66,128,98,139,229,118,223,207,211,155,145,230,203,139,215,155,73,199,198,19,203,63,78,147,37,232,57,48,109,161,156,250,155,83,192,28,174,59,95,128,22,27,213,171,96,129,62,125,190,67,230,86,74,91,104,245,254,147,1,2,138,137,160,78,124,134,129,107,44,234,37,88,236,184,219,182,78,227,152,163,54,82,113,223,231,6,43,132,110,79,51,246,14,185,35,150,5,169,206,140,179,116,232,150,78,176,188,252,145,93,243,238,86,247,156,66,174,95,238,220,211,107,129,155,119,82,11,255,107,190,104,155,176,48,104,142,169,167,28,162,113,194,229,249,126,231,120,209,147,112,47,6,209,11,63,237,24,173,122,103,5,48,74,222,187,169,165,8,5,113,185,199,1,55,76,157,185,221,249,34,61,167,25,38,30,124,198,163,214,152,160,33,254,115,57,204,161,163,237,38,28,228,244,89,65,140,43,6,239,242,194,117,203,74,206,50,10,160,195,75,221,98,179,223,137,20,241,252,28,0,3,29,19,137,143,153,41,146,110,106,60,158,204,245,15,67,199,96,97,175,71,89,192,182,131,20,71,43,38,122,187,112,149,157,60,177,52,15,247,232,139,210,28,239,39,166,5,30,182,144,215,192,231,175,110,142,125,23,215,184,100,83,245,75,140,53,207,246,12,250,189,67,24,55,22,87,169,125,45,40,17,194,174,84,149,8,238,170,57,236,213,51,227,231,212,90,73,153,150,253,89,97,214,135,67,120,145,154,48,182,221,28,107,149,35,118,115,44,243,24,26,135,205,179,162,180,214,252,161,204,62,91,250,56,149,216,15,27,43,130,174,17},
} ;

static const int16_t precomputed_encode_761x1531_x[precomputed_encode_761x1531_NUM][crypto_encode_ITEMS] = {
  {-31828,-31590,-27362,9832,18701,7606,-24993,-6644,28472,25709,9616,5272,-5205,-26973,-24014,10539,23301,-15743,-3530,-1965,-17360,32120,-10594,-22985,16643,21523,-13486,-3098,-32149,20791,13503,11521,-8968,27556,23362,10404,15916,-5950,-31355,-20513,24285,20511,-3783,-23152,-4359,17290,29382,9965,-22455,6026,24312,-11096,17673,2377,25947,10847,-8900,-7111,14209,-31949,-29904,16596,22628,-17016,21810,-9576,19519,-29375,-12438,-15304,-20317,-14108,-7568,-30906,-9250,-25346,-4558,17173,25903,19133,-10623,-11635,-20333,-29915,-10165,16179,26656,12339,10338,27623,-1278,-28174,-9173,12243,10109,-27765,-2798,-22294,27608,-6585,7568,-31365,10300,-2590,21112,9759,-5247,18588,-21873,8566,-32715,-27531,-8262,8406,-520,-23877,-31297,-22599,-4337,29639,-6684,17652,13143,32150,-32454,-14106,-17535,7914,-28436,19919,8590,18467,-22163,9604,-4025,1854,-7657,5075,12388,20392,-3459,-10942,-2385,-14239,-19140,-12615,-2802,-30473,23697,-31605,-5977,-21604,-5984,-31068,-16808,-21785,1468,10061,7021,4101,-15999,-11282,-1907,-32746,-26939,-22152,-29583,25411,25662,-24027,11,-7010,-913,27391,3246,3074,-25697,-18835,-12164,-25677,-6831,-29509,17303,-31754,2325,-13999,-18597,-5227,14147,-4605,-17126,15749,9420,18316,18439,5005,-4347,-15658,7144,-9408,31477,-5759,13916,-30347,19806,-14197,-27743,27821,-17248,-11011,25746,-18966,-2140,-23054,-10637,-4203,-5143,-29209,-29867,-2852,10417,-22320,-29258,4454,1395,9492,5069,9310,-12220,-19327,-5087,17867,-23410,-32723,-25406,-8162,4163,-30988,19284,11776,2231,-8038,-19234,19647,-4639,-20310,-19608,-12658,-5630,21945,-26683,21204,-27839,-30122,818,28532,-10187,-10712,-13838,6444,19869,29604,17843,-7031,-6927,1895,-7615,-25845,-24597,3960,20692,-19634,-23403,7615,19255,10102,-21837,8269,-19712,58,-30215,14636,8234,933,14268,-26524,28251,29239,-22981,764,-30744,7428,24275,-18840,-3413,-28311,20189,2956,-20824,-20473,27713,-18672,3405,13569,3483,-31447,-11109,27694,-28755,7338,13052,22217,19833,10980,-26019,27363,-29215,22117,23438,-23002,-23475,-12013,-11038,-23521,-20219,-12790,28113,-20765,-27818,-16021,-31567,-17770,10107,-30136,23680,6531,-9579,-1293,-1117,7864,-15246,-23495,6062,950,-13457,-11506,1035,-12833,5495,21861,-6815,-20920,-31337,10399,-4395,-13465,24815,29362,-11977,-15902,13052,21990,21207,6083,-235,14872,-471,30872,23190,-25195,-14715,16940,15597,10676,-27441,27707,3279,-7358,31961,-9820,-16216,-23347,-16623,14375,18840,28970,4546,-1082,-4719,30447,-15165,14784,23905,-15365,5127,20428,-29157,-12282,23440,18846,18841,-11436,-4220,9109,22120,11890,21012,-9896,5861,-32740,-24141,27052,-135,-31498,15032,25505,8147,22299,-25383,-32326,-30628,18165,-5936,3950,-20043,1153,28374,8904,14728,14472,12414,-16071,-20638,22740,-22339,4027,-2952,-12293,-24407,6438,13616,22315,-7760,-2284,-19815,14631,-13810,-30933,3450,-31613,-21976,7141,-19255,-32265,6398,16395,-5478,-21184,16982,474,5653,-22996,14430,5095,25802,18975,-17066,-21846,-3104,14366,12174,2031,10860,957,28451,-14146,32299,21218,-1358,15299,-20377,13877,-6748,-29059,28960,-27815,-21309,-27237,57,1764,18594,-1956,-7778,-31990,22435,-19137,-22411,11478,31753,7939,3542,214,23413,30751,30390,24191,-6589,-21389,23671,9632,19508,10104,27969,-12703,16816,15471,-32647,-22732,-24574,-11076,13834,-1757,-4062,32219,-24190,-21142,15002,10476,-3123,28406,-13037,-30072,-22556,12741,-3374,-23606,27292,30074,-13399,-29054,-6395,26135,-10473,26884,30274,29862,15366,10895,29206,6516,17725,-12031,-21192,20481,5587,-23893,-14212,-30727,-23845,-25785,-2150,13037,12427,32043,-13332,6351,26881,-6415,-30239,-32496,163,30041,-23402,-17682,25461,2115,13961,6349,26087,9269,11384,-9392,-15768,-21131,14571,1015,5849,21821,-5064,-24460,10614,2537,-31992,-22620,-1297,-10748,28176,18212,28068,16548,11730,27464,28222,26413,-5483,-11368,-12435,-26008,28463,-14413,-30448,-13840,6367,6117,20858,17314,7944,-18518,7118,-26132,19854,-5109,22712,-11531,32049,22107,18549,-28606,-17223,2447,30315,25780,19034,-12582,5560,-17247,26941,-18061,-27633,-25494,21123,1461,18043,26570,-23993,13991,-14899,-29032,-19647,-13021,22422,-4145,18629,-31140,981,-22940,-19169,-18281,30543,-24276,7546,29460,8464,9588,28060,32569,-21699,22148,31681,5710,-10101,-9466,-3706,-1438,31150,32025,-11050,-435,-24791,1126,-5846,21590,29289,-19322,170,15292,22471,-26755,-19826,26600,16624,-23600,-18023,25617,9354,-31367,18250,19274,12717,32183,767,22132,21776,-27197,-1240,-29872,-29522,-897,16776,-22345,-29746,979,26154,3007,2211,-14293,-10724,2620,-5270,-18024,-4626,-1553,10545,30179,-6169,9273,-30408,-15106,21143,-28368,29066,29079,-18187,-12327,20202,21590,-24512,-13985,-20890,28780,11696,23003,28972,-31196,-28149,-5450,-7696,-15469,-5950,-2267,28322,30605,29204,24097,9369,15067,-1530,13938,21280,-4560,20160},
  {-25402,32558,8157,11886,-30202,29029,9023,5133,14723,1114,-8593,-12387,7422,20500,23661,-7670,-26445,17127,-15006,2041,17911,-25558,15100,-30922,-15540,20066,28811,-18083,-3501,4636,5148,-3758,1384,-17349,4546,-21784,17978,-343,-26271,294,17622,-7164,19064,20608,27964,-5532,4794,6875,-23927,-10134,28202,-18147,29104,19941,29392,-10318,8083,-31017,-16884,-10900,26838,25269,-16981,-19618,-23214,-4403,25075,-11712,6875,-9049,23046,-15695,22711,4623,8206,-8293,16582,-11856,27684,22074,-17093,3273,11269,-32212,-5641,-15915,-7448,-24439,-20516,26649,9703,7444,-10915,10264,5757,23603,-3553,22969,-7037,-30451,507,15099,24575,24812,31539,-14565,24930,-3288,20530,-14455,-13488,-4731,-23330,8233,-12107,19648,-25017,22686,8229,1976,-26871,-26694,12136,31683,10885,5626,-27314,-17642,23141,-24837,-31357,-12885,8984,-18962,14006,9086,-3221,23862,-2782,-21589,-24296,-21927,29577,32286,-21506,7459,14720,14691,-32318,1525,6366,31097,-8593,-32476,13767,28285,21217,18349,1221,-10511,-515,2748,3059,-6058,-10579,-2308,-16591,-27402,-16121,28449,-28652,-10223,14880,8731,-5542,-31455,30864,-5826,31470,17492,20885,-15591,784,-26999,4297,-16976,8843,-19682,15338,11091,-6756,11708,-9635,22603,30738,17681,3410,26537,28080,20871,-31286,-1855,8616,-24268,13441,-9318,-22983,21011,16786,1574,-23233,-5490,-21725,16997,4752,29048,-32250,-9897,-7726,-14174,12262,-26898,4465,-16586,-20475,-17933,14379,30531,10255,-16918,11161,-4603,17465,18373,2282,-17601,12445,28816,-20528,23922,20024,-1593,-2560,21712,5697,21792,-13691,-31821,-13289,26591,-13103,4987,-17603,8841,28013,-11791,15192,-438,7863,-2747,5435,-25985,24007,-14089,5246,10163,-20148,30687,4833,16715,7955,27405,6877,23235,11071,32648,-21909,10271,-12157,25312,-23813,7185,-5341,31832,-18299,32578,12064,31409,18318,16202,-1899,-7812,16013,18512,22257,8256,-22527,-26948,20467,-15191,13222,28924,-30373,26850,-26745,-11733,11559,-14090,-29502,12752,29815,-13464,19841,-24934,-27515,15580,-17685,21190,3600,11530,31372,6644,-15365,4662,-32619,-74,18762,1553,-8123,19641,-13259,29045,-23523,13016,-19022,13926,19868,-2165,-18833,-17221,-5300,-2237,-22240,-32435,21505,14354,-15428,28446,31026,-5422,-17821,24341,4530,-22357,-3224,-2509,8187,24787,30538,-21735,-8060,27919,-4567,-31758,23720,19655,25149,-10688,-14089,16892,-11591,-29345,-16659,16933,-3135,16969,23265,18343,-6826,5180,10149,29458,-17484,-17029,-16558,-21941,-27840,31764,-13211,-3823,-16134,32470,26547,-30707,4375,12766,-4106,-4839,-20857,19534,-25891,18474,-19239,-16954,24429,20983,-12461,8871,-30757,25003,20018,-14863,-8779,-15050,-15025,16065,-1518,-16611,31424,-16323,18879,-6177,30416,-30493,-7830,-27676,9337,32211,1492,5490,-19389,1033,-9279,-22556,7082,-21149,-379,-10144,-13418,-21359,6180,30695,10388,-15421,-24233,28052,-25174,6,-15291,-29848,19525,21853,-1426,-7462,-12557,-3767,17492,-28223,21400,-29391,-10580,17490,23205,-11752,8671,18796,20449,-17576,10069,-5173,-12542,-32380,14842,8493,-29438,-24461,-9307,-19908,-17988,10250,13172,21914,30317,-16943,15352,-17468,6975,-22889,16693,21417,21702,-24371,29708,-25668,-3819,8536,27266,7064,-24781,-106,-17125,-19347,-18885,-19588,-23502,-25060,7750,15346,21598,18535,-50,-32741,-28550,-29052,334,-9804,-19494,8207,17657,-688,-2626,-13312,-1750,-18505,18481,-21271,26591,-12327,-18415,18713,10627,-21518,15477,14693,24986,16630,28764,-1806,22086,-17818,-17604,-26293,-18974,4367,29408,-32356,-3380,-8296,9178,-13547,-18403,14286,-28442,30563,16824,26566,23814,-14474,1144,28072,19923,16286,6045,5876,11639,-27982,31580,-23830,-26900,13477,-21236,78,-8295,-2940,-20134,9557,17526,9576,-11062,-10350,10618,-15624,21527,-24298,20160,-6230,25518,-10987,12563,-32305,-3400,-9510,19470,-27052,11275,13605,-3557,-1695,8167,29522,-17269,-26620,-28617,-20978,-1686,-15397,17723,374,-670,-10014,-7126,-1681,15515,27619,22303,-20526,24793,-11979,3805,28585,26439,-31677,23893,19442,-30225,-23762,-12028,5354,13670,-27092,-3788,21722,-20634,-29017,-18214,-5031,14390,8462,-8921,7877,-7788,20081,-13180,-28019,-23063,-3015,-2490,-6582,28172,2727,792,-10102,-29789,-21859,-9685,32536,32156,-3808,-11143,-19384,-6925,-2967,-10032,740,-10224,21849,-10503,-5769,10856,6365,13808,18679,18738,3256,-21456,-20146,31435,11963,7161,-26251,12020,-29283,-1213,32226,31720,-4788,31533,-9782,25236,15328,-26174,-13356,-16099,-27931,-7193,-26778,14338,25164,-25832,-29365,21173,-5274,-23872,-27995,20723,-17822,-19017,26977,-24696,-3427,-8300,18750,26860,-12200,930,3037,31145,-27593,-570,3202,-7102,19057,29393,-32078,6382,-28052,-13517,-27153,-7985,28507,-19835,-7682,1451,22098,-9344,-22359,13485,4121,-17592,3971,-6556,22831,-24935,1577,2117,-24820,10255,23598,-7356,30614,-14360,-17192,-1994,-25003,22936,-32235,9317,3037,5427,-16192,-7235},
  {9983,-32722,13817,-30586,-6648,7526,27740,7873,14177,17201,7104,-12398,-28688,-17342,3976,-4701,18616,-32504,22753,-26850,5909,-19141,-15298,17369,3943,-22544,1620,-26309,15842,9126,-13212,25566,19024,-30137,-19326,19456,26019,-6050,-26296,-29161,23229,32342,10383,-21518,26614,-18698,-2632,-15280,-21157,9045,29491,32377,6174,-28123,21458,-12154,7335,2013,28090,3605,21999,-30454,13638,8149,-31213,5692,-3300,-6762,-2050,7779,20763,-20655,29977,-29587,27734,86,-20123,14375,-20335,-7684,9685,-27969,-3158,-17678,20287,-31093,-2727,-10287,14890,-8770,-11885,4221,13006,-19235,-15925,25818,-14694,-23991,-26690,-20933,-11753,-3968,27054,14566,-13301,-9181,27139,12908,31441,31133,28229,5505,-12493,-17741,-12290,26010,5175,27480,-28359,7958,18752,19273,-31694,30678,-6117,25234,-15803,25460,8443,11903,-24727,-6681,23955,-5918,11106,1374,-3083,11625,-40,-17029,12494,-9476,23392,1302,26604,28495,28393,-27699,-17474,-17816,-4047,5514,2801,28049,-31443,-19439,-10315,-28070,-12582,24743,26946,-5022,24697,-18746,28322,-30587,3688,-22574,-15800,8852,8435,-13403,16445,-20763,-4474,-3130,27858,-10670,-24119,20680,-28616,6403,-26871,24897,-11080,7707,-24855,11118,6044,-4619,765,950,-8802,29450,-30003,16306,2433,-10127,1505,-13882,-4824,16094,18297,-5675,27258,-24540,-23849,-31518,-9683,7082,-18028,-23669,-2554,-28274,5828,-11480,25930,-23134,12045,-9055,-24074,19454,-13153,1962,21441,-4265,-7195,30763,19161,5709,-17885,6526,14021,-25805,-502,-6824,9433,-11418,-30968,-24916,-9277,-5364,27004,-26096,-18888,-10166,8517,-931,-23998,-9209,21555,7323,7755,-10357,-11583,-20061,1239,-2775,23372,-12829,-10496,19981,17282,30945,-11015,14709,-8795,-11860,-2289,-1332,-22456,20280,-30488,-26410,-13162,-29854,-30431,-4949,5711,-31579,-6327,23071,21792,3944,12152,8300,31889,21360,-23285,11967,-25523,1708,-19891,29505,-28957,28919,-3984,9281,25557,-2026,-1341,2743,-13503,6935,17958,21701,20945,-31040,25099,18391,-25695,-3837,-30530,31123,13112,26112,28665,-15234,2591,-30962,-3298,-9155,-28023,26448,-26530,8403,-30502,5557,-178,2882,4232,23936,28230,22712,2848,25014,27538,-7831,-31405,-14611,-11636,7069,26002,18898,-4344,-24540,-8313,20347,7286,23333,31897,14500,26802,21156,-19422,-1728,-31435,-4168,14024,-759,32293,-17169,-16621,-18335,28850,20071,976,10064,-13515,13591,6832,2945,1161,-24827,-514,12649,-15142,32247,-14932,23138,-22064,13347,22495,-28456,-5333,28449,11887,-12755,15249,-23687,-14463,-16352,-570,-5349,5851,-20968,17843,-23619,15981,-22899,-11450,5789,17789,-15059,3221,-14059,14789,1445,20763,-7998,-28595,-22517,-11004,32374,-19062,-19500,-14669,21211,-19087,-27171,-1799,12090,30697,-11249,-16435,7447,-15067,-31850,10201,19507,-13247,-10444,25833,12481,-28953,-21856,5410,24841,8659,32054,22685,20461,26412,22521,11161,-2573,-18701,-4218,-27818,-15583,-8664,-18188,-28070,23776,3861,-3197,-6464,-11722,-12651,-1144,19001,-21864,4298,14013,19823,-20907,14556,108,-19108,-25380,14159,-1214,-26933,2913,-19649,27042,15535,3312,-29373,26192,32251,217,-15316,20916,27527,-244,-28795,22802,-3024,3292,21388,-31727,13813,-15420,-11536,24206,21329,-25905,5787,-2516,-6860,2192,-30673,613,18322,9043,-4979,-4789,-13058,12489,-18975,27811,16077,-8866,-4523,-8897,-25156,-29150,-21150,-30973,28061,28605,-2381,476,-20362,-22334,-3562,25269,4894,-13907,-11387,-1038,9552,7054,13395,16412,-21916,-7018,29954,28730,-22368,-26053,-5733,-19446,6167,28669,-26128,-17415,5919,8754,-30971,-13629,19975,-19871,18295,22751,14951,30449,-3141,18571,9407,13474,-4789,-13948,-11715,-6692,-24218,24569,-5907,-30952,-30589,-30397,23868,-1961,10344,-23953,1998,19503,20156,10940,15533,14701,-9157,12054,-13931,-26504,-9092,741,-10497,18805,29715,22452,-4256,3569,-10276,2871,-13471,6599,-28447,-20616,-6753,30740,-26345,17709,-26312,-27211,-9201,31274,30936,-5229,-16239,-23710,8700,12152,9384,-19768,-24816,9822,7964,5116,-24326,-9318,-135,-3697,-6839,10538,-9709,-3758,-10965,-6948,9538,-27305,3408,-14765,30610,-2632,-22622,-9151,-20773,13162,-5923,-20676,16708,3960,12396,25368,-23636,-19877,24025,4071,-9001,-23828,885,27083,-8373,18531,10416,1565,-6318,-27209,20378,-27622,19948,20007,-5913,-25066,6391,-16472,-27304,-22408,8244,-26908,4548,1268,-19552,8070,-22994,11207,-9701,-10316,22284,-24549,32344,15923,20396,-2668,23107,29020,-7120,-7539,-28822,-21902,-32332,-8652,26290,-12253,-31365,8764,29875,30538,9615,-2321,-10590,-128,-13943,17047,-19982,31967,-21060,-22857,-20079,17339,-910,-3945,2189,-13412,3060,-4796,28025,-6429,-6513,21671,-13870,14674,-4461,-12403,6405,23727,-18482,28662,-26919,20591,15737,17918,27169,24072,31134,-1842,-24262,21343,20185,16610,-28724,11197,10489,11111,30918,-16085,-12062,13211,-29607,-24482,-30816,-14135,19836,-20274,6572,28170,25561,29109,263},
  {-22363,-8002,-4087,29999,-13896,-27872,-31913,-124,25783,-4976,19114,-9450,-21626,11116,-29884,13675,-2534,15718,-17219,-3057,2747,15468,22357,-28147,-25573,15709,27825,-79,-9295,13648,-18798,-29413,26106,-27518,-5152,-12489,22266,8378,12560,-17860,-12230,17006,-5623,-1927,-4695,-4082,-9899,11775,23185,-7744,25197,23831,8881,-9545,-20042,32287,25833,4941,-28573,16557,-22733,11841,9961,-27180,19004,-32217,11229,25286,14771,-3258,-24397,6718,23102,24713,31967,31768,31835,5478,-22896,-19047,20639,-14509,14955,15520,10421,-26882,-30354,29349,-3846,-27671,15228,13019,10706,-17287,8023,-31152,-3051,6702,-31206,-17159,-27535,-23222,-25364,25494,-16364,10374,-13269,-8468,20429,-14984,-7671,-24411,4062,-3446,-1326,-20694,24151,-4819,-20027,31842,-31956,-21681,16184,10061,-1700,-15159,-10860,-6672,-19931,2691,-28335,15705,27292,13612,-19346,24218,-16045,23279,-19266,19500,7394,18419,-10422,23012,31707,-16721,-14607,-26814,10108,8352,10675,-30768,18405,31355,-31100,-13631,-28163,-23981,-5567,30516,-3919,7655,-17338,-1463,27390,24229,13191,-8534,-26561,-22472,15283,-9057,-18953,20880,30515,20240,-10661,17294,-2047,294,-18657,22462,853,24895,23159,6376,-27811,-32700,-5625,14468,5836,28780,-32135,10404,-16364,16328,3268,26840,3657,20897,9825,22058,-22283,-294,29925,6206,-17572,17178,14590,-28276,-14183,4160,4884,11528,6397,-5126,15757,-5179,5809,-5985,-8968,14435,1045,28545,13082,-6684,-25478,8770,-9149,-3605,-12002,-12186,20965,-994,27064,27175,-30497,6678,29920,30717,7716,-4677,6114,4065,20179,10378,14044,32350,-5456,-24131,25260,16007,30708,10981,17933,-31270,-19669,-19380,28836,12103,10168,20263,14629,12173,-12853,-24384,16986,-27270,28282,-12079,-30174,7929,19305,-1292,4713,-4523,8357,20815,18050,11389,-31909,-1800,5213,-12228,9911,-31150,-24701,16352,28247,-22816,13859,13493,-29378,27534,-5234,17059,28704,-3486,-8110,-11985,17885,-4798,-25532,-27844,-2354,-4817,-28401,26830,9547,3832,-18143,-25852,7287,-32686,5829,22111,-5122,3366,14134,18227,-11501,-1901,-14880,-12558,-23389,-5402,7818,-4954,-10785,-25368,-15381,-21604,-29324,342,28572,27324,19337,-19532,-14078,-430,28732,-9547,8589,-5160,-5947,-10088,20738,26971,-14030,21218,24036,-22496,4314,1177,-6447,2701,3268,11715,22579,-17723,8750,-30323,-22936,7556,1775,-7620,-6868,27961,-32417,990,15223,2098,-21452,-5051,23345,18165,-14396,20245,-26342,-23114,-29503,-8770,5042,22142,-8235,16334,-12626,-12047,3508,-1864,-26985,17019,15741,23626,-30792,-26518,27783,-18248,862,30030,-11159,31414,-11642,20165,22380,23639,-22117,-6274,13159,-26262,32694,3885,-10223,29460,31408,21606,-2613,17398,-32586,25914,11,11058,18888,-19611,-32369,23950,-6569,-29581,-15588,-14772,-5845,-17803,-29798,-30667,-20708,-11212,3016,-7943,16978,-617,23682,-30580,-25077,29010,12343,11378,-18494,20356,-31833,-10212,-27600,11171,-6348,-18547,2406,-26061,13011,-1122,-5423,2386,-2894,-31333,17412,2473,-10048,13508,-9122,-8440,29419,21934,-15396,-6792,5193,14170,9222,-8467,11325,20278,-11189,-13393,-6930,-4894,-27928,-14,14435,5307,31370,-21673,-31715,1606,-11300,-6942,-104,-1707,-20527,-17551,30643,-6062,-118,1966,11520,22940,-22410,15717,-26064,3568,-18666,5826,-19873,29712,-31688,-8991,13209,-8113,32503,-30840,-9445,-28615,-16594,-15108,-18352,11320,13461,-20710,9899,30941,-18978,30768,-28964,25415,-24273,20636,-28039,14052,5039,9185,-24173,13352,-6512,-31399,14157,24568,-25240,-6600,-6345,20052,27293,1788,3058,-20469,16993,-8602,1887,-13881,29783,-24756,-13517,3817,-14721,30799,4043,-15776,-12277,-17949,-1475,8166,-11757,25186,-29340,-22119,32027,-17182,8439,5223,12449,12712,31823,14884,-7086,21104,32036,17152,-21347,-22581,11411,-25356,30093,10494,17211,5061,9849,25336,-17066,22313,-9501,18818,-8765,-8977,-31326,-17665,22651,-16840,25350,26131,-13240,-8548,9773,-14522,-1846,4095,-24972,32207,1155,-2155,9349,420,-11132,-18328,-17237,-29590,-20113,-27446,32108,-5784,-9990,-4657,-17217,-29230,-21664,-24232,7736,15742,2060,4061,-6025,-14776,-19806,25920,-18569,21733,9385,30583,28706,-21701,6532,11258,7833,-12127,32328,14804,3854,-16689,11983,-6179,-3282,-17745,-3080,3476,29952,-17744,2000,14850,-10464,31773,-7624,27852,10503,-27779,-2541,25049,-10830,17148,-4512,-17823,3676,20470,21349,-25515,22484,-2311,-20896,-27308,-17519,20299,-3076,27246,-21818,27437,-2419,1545,20121,3637,14034,-19721,956,7378,-26235,-17750,-14310,-32496,-15966,26255,16330,30597,-11267,27658,-7616,-10146,28389,16404,27989,-11490,4609,-20488,22652,281,-29273,-7606,-10840,13537,12165,-18128,17636,30655,-17665,5397,20810,13891,32757,1014,26972,32342,21440,24970,-12768,-7106,-32436,-26195,-18521,11148,-31139,-3593,30383,5164,-26645,17698,83,-31604,6348,31968,10578,8920,-27924,-26699,14563,10843,-6391,17746,8073,20616,19986},
} ;

static void test_encode_761x1531_impl(long long impl)
{
  unsigned char *s = test_encode_761x1531_s;
  unsigned char *x = test_encode_761x1531_x;
  unsigned char *s2 = test_encode_761x1531_s2;
  unsigned char *x2 = test_encode_761x1531_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_761x1531_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_761x1531(impl);
    printf("encode_761x1531 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761x1531_implementation(impl),ntruprime_dispatch_encode_761x1531_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_761x1531;
    printf("encode_761x1531 selected implementation %s compiler %s\n",ntruprime_encode_761x1531_implementation(),ntruprime_encode_761x1531_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_761x1531_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_761x1531_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_761x1531_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_761x1531_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_761x1531_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_761x1531_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_761x1531(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761x1531")) return;
  storage_encode_761x1531_s = callocplus(crypto_encode_STRBYTES);
  test_encode_761x1531_s = aligned(storage_encode_761x1531_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_761x1531_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_761x1531_x = aligned(storage_encode_761x1531_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_761x1531_s2 = callocplus(maxalloc);
  test_encode_761x1531_s2 = aligned(storage_encode_761x1531_s2,crypto_encode_STRBYTES);
  storage_encode_761x1531_x2 = callocplus(maxalloc);
  test_encode_761x1531_x2 = aligned(storage_encode_761x1531_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_761x1531 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_761x1531();++impl)
      forked(test_encode_761x1531_impl,impl);
    ++test_encode_761x1531_s;
    ++test_encode_761x1531_x;
    ++test_encode_761x1531_s2;
    ++test_encode_761x1531_x2;
  }
  free(storage_encode_761x1531_x2);
  free(storage_encode_761x1531_s2);
  free(storage_encode_761x1531_x);
  free(storage_encode_761x1531_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

