#ifndef TIMEUTIL_H_
#define TIMEUTIL_H_

#include <jni.h>
#ifdef WINDOWS
#include <windows.h>
#include <process.h>
#else
#include <unistd.h>
#include <sys/time.h>
#endif



/** Use one TimeUtil per thread. This is not thread safe as there is no synchronization on this class */
class TimeUtil
{
public:
	TimeUtil();
	virtual ~TimeUtil();

	void sysTimeMillis(jlong &currentTime);
	inline jlong sysTimeMillis()
	{
		jlong retTime;
		sysTimeMillis(retTime);
		return retTime;
	}
	
	
private:
#ifdef WINDOWS
	    SYSTEMTIME st0;
	    FILETIME   ft0;
#else
	    struct timeval t;
#endif


};

#endif /*TIMEUTIL_H_*/
