------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2006-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;          use Ada.Text_IO;
with Ada.Command_Line;     use Ada.Command_Line;
with GNATCOLL.Email.Parser;    use GNATCOLL.Email, GNATCOLL.Email.Parser;
with GNATCOLL.Email.Mailboxes; use GNATCOLL.Email.Mailboxes;
with GNATCOLL.VFS;             use GNATCOLL.VFS;

procedure Test_Email4 is
   Box : Mbox;
   Stored : Stored_Mailbox;
   Iter   : Stored_Mailbox_Cursor;
   Count  : Natural := 0;
begin
   Open (Box, Filename => Create (+"../email_data/FA11-011/bug"));
   Store (Stored, Box, Factory  => Parse_No_Payload'Access);

   Open (Box, Filename => Create (+"../email_data/FA11-011/comment"));
   Store (Stored, Box, Factory  => Parse_No_Payload'Access);

   Iter := Stored_Mailbox_Cursor (First (Stored));
   while Has_Element (Iter) loop
      Count := Count + 1;
      Next (Iter, Stored);
   end loop;

   if Count /= 14 then
      Put_Line ("Incorrect parsing of multiple files with a single mbox,"
                & " found" & Count'Img & " messages instead of 14");
      Set_Exit_Status (1);
   end if;
end Test_Email4;
